/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderOptions;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ICanvasChangeListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ITitles;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.AngleAxisPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BasePropertiesPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.CBOptionsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.CategoricalAxisPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ChartAppearancePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ComponentSwapperPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.DualYElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.EmptyPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.HiLoElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.LegendPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.OneDDotPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.OverlayElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.PanelsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.PolarElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.PropertiesPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.PyramidPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.SSVAxisPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.SSVElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ScaleAxisPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.SplomPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.StatisticsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.TitlesPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.ApplyPropertiesEdit;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SidePropertiesPanel
extends JPanel
implements ListSelectionListener,
ICanvasChangeListener,
IModListener,
IPropEnum {
    private ChartBuilderDlg mChartBuilderDlg;
    private ChartCanvas mCanvas;
    private ComponentSwapperPanel mSwapperPanel;
    private JList mMainList;
    private DefaultListModel mMainListModel;
    private UpDownArrowButton mUpButton;
    private UpDownArrowButton mDownButton;
    private ExcludeButton mExcludeButton;
    private boolean mApplyEnabled;
    private boolean mInReload;
    private HashMap<String, PropertiesPanel> mPanelMap = new HashMap();
    private ChartProps mProperties = null;
    private boolean mHasDualYControls;
    private JPanel mListPanel;
    private PanelItem mCurrentPanel;
    private Vector<Object> mTabOrder = new Vector();
    private JTabbedPane mTabbedPane;
    private JPanel mElementPropPanel;
    private ChartAppearancePanel mChartAppearancePanel;
    private CBOptionsPanel mOptionsPanel;

    public SidePropertiesPanel(ChartBuilderDlg chartBuilderDlg, ChartBuilderOptions chartBuilderOptions) {
        this.setLayout(new BorderLayout());
        this.mChartBuilderDlg = chartBuilderDlg;
        this.mTabbedPane = new JTabbedPane(){

            @Override
            public void setSelectedIndex(int n) {
                if (SidePropertiesPanel.this.canSwitchTab()) {
                    super.setSelectedIndex(n);
                }
            }
        };
        this.mElementPropPanel = new BasePropertiesPanel(this.mChartBuilderDlg);
        this.initElementPropPanel(this.mElementPropPanel);
        this.mChartAppearancePanel = new ChartAppearancePanel(this.mChartBuilderDlg, this);
        this.mOptionsPanel = new CBOptionsPanel(chartBuilderDlg, chartBuilderOptions);
        this.mTabbedPane.addTab(chartBuilderDlg.getResString("IDS_ELEMENT_PROPERTIES"), this.mElementPropPanel);
        this.mTabbedPane.addTab(chartBuilderDlg.getResString("IDS_CHART_APPEARANCE"), this.mChartAppearancePanel);
        this.mTabbedPane.addTab(chartBuilderDlg.getResString("IDS_CB_OPTIONS_TITLE"), this.mOptionsPanel);
        this.add((Component)this.mTabbedPane, "Center");
        this.mCanvas = chartBuilderDlg.getCanvas();
        this.mInReload = false;
        this.mHasDualYControls = false;
        this.setupPanels();
        Insets insets = (Insets)UIToolDialogUtil.getStandardDialogInsets().clone();
        insets.top -= 6;
        insets.left -= 2;
        insets.right -= 2;
        this.setBorder(new EmptyBorder(insets));
        this.mCanvas.addChangeListener(this);
        this.addDragDropAdapters();
        this.updateContent();
    }

    public boolean hasCollapsedVars() {
        for (Props props : this.mProperties.getProperties()) {
            if (!(props instanceof Props.CatAxisProps) || (props.getFlags() & 0x10) == 0) continue;
            return true;
        }
        return false;
    }

    public void uponShowOrHide(boolean bl) {
        if (bl && this.mCurrentPanel != null) {
            this.mCanvas.setHighlights(this.getHighlights(this.mCurrentPanel.getProp()));
        } else {
            this.mCanvas.setHighlights("");
        }
        if (bl) {
            this.updateContent();
        }
    }

    public void selectItem(IPropEnum.ElementPanelType elementPanelType, int n) {
        int n2 = 0;
        for (Props props : this.mProperties.getProperties()) {
            boolean bl = false;
            if (elementPanelType == IPropEnum.ElementPanelType.ept_Axis) {
                bl = props instanceof Props.AxisProps && !(props instanceof Props.LegendProps) && !(props instanceof Props.PanelProps);
            } else if (elementPanelType == IPropEnum.ElementPanelType.ept_Element) {
                bl = props instanceof Props.ElProps;
            } else if (elementPanelType == IPropEnum.ElementPanelType.ept_Legend) {
                bl = props instanceof Props.LegendProps;
            } else if (elementPanelType == IPropEnum.ElementPanelType.ept_TitleFootnote) {
                bl = props instanceof Props.TitleProps;
            }
            if (!bl || n != n2++) continue;
            for (int i = 0; i < this.mMainListModel.getSize(); ++i) {
                PanelItem panelItem = this.getPanelItemByIndex(i);
                if (panelItem.getProp() != props) continue;
                this.selectPanel(panelItem, false);
                return;
            }
        }
    }

    public void chartItemHit(Object object, DropZone dropZone, int n) {
        int n2 = n == -1 ? (dropZone != null ? dropZone.getClickDelta() : 0) : n;
        for (Props props : this.mProperties.getProperties()) {
            if (!(object instanceof String && props.getStrElId().equals(object) || props instanceof Props.AxisProps && object instanceof ZoneType && ((Props.AxisProps)props).getZoneType() == object || props instanceof Props.PanelProps && object instanceof ZoneType && ((Props.PanelProps)props).getZoneType() == object || props instanceof Props.LegendProps && object instanceof ZoneType && ((Props.LegendProps)props).getZoneType() == object) && (!(props instanceof Props.TitleProps) || !(object instanceof Integer))) continue;
            for (int i = 0; i < this.mMainListModel.getSize(); ++i) {
                PanelItem panelItem = this.getPanelItemByIndex(i);
                if (panelItem.getProp() != props) continue;
                if (props instanceof Props.TitleProps && object instanceof Integer) {
                    ITitles.TitleType titleType = this.mCanvas.titleFlagToTitleType(((Props.TitleProps)props).getTitleType());
                    if (titleType.ordinal() != ((Integer)object).intValue()) continue;
                    this.selectPanel(panelItem, true);
                    return;
                }
                if (n2 > 0) {
                    panelItem = this.getPanelItemByIndex(i + n2);
                }
                this.selectPanel(panelItem, true);
                return;
            }
        }
    }

    public String getCurrentListItemTitle() {
        String string = "";
        PanelItem panelItem = this.getPanelItemByIndex(this.mMainList.getSelectedIndex());
        if (panelItem != null) {
            string = panelItem.toString();
        }
        return string;
    }

    public void setDualYAxisAssociation(Props.ElProps elProps, String string) {
        boolean bl = false;
        for (Props object : this.mProperties.getProperties()) {
            if (object == elProps || !(object instanceof Props.ElProps)) continue;
            if (!string.equals(object.getStrElAssoc())) {
                bl = true;
            }
            object.setStrElAssoc(string);
            object.setModified(true);
            break;
        }
        if (bl) {
            DropZone dropZone = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_y);
            DropZone dropZone2 = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_y2);
            ISpssVariable iSpssVariable = null;
            if (dropZone.getVariables().size() > 0) {
                iSpssVariable = dropZone.getVariables().get(0);
            }
            ISpssVariable iSpssVariable2 = null;
            if (dropZone2.getVariables().size() > 0) {
                iSpssVariable2 = dropZone2.getVariables().get(0);
            }
            dropZone.getVariables().clear();
            if (iSpssVariable2 != null) {
                dropZone.getVariables().add(iSpssVariable2);
            }
            dropZone2.getVariables().clear();
            if (iSpssVariable != null) {
                dropZone2.getVariables().add(iSpssVariable);
            }
        }
    }

    public boolean checkDualYStat(Props.ElProps elProps, Statistics statistics) {
        boolean bl;
        int n = 0;
        Props.ElProps elProps2 = null;
        for (Props props : this.mProperties.getProperties()) {
            if (props == elProps) {
                ++n;
                continue;
            }
            if (!(props instanceof Props.ElProps)) continue;
            elProps2 = (Props.ElProps)props;
            break;
        }
        if (elProps == null || elProps2 == null) {
            return true;
        }
        boolean bl2 = statistics == Statistics.Value;
        boolean bl3 = bl = elProps2.getStatistic().getStat() == Statistics.Value;
        if (bl2 != bl) {
            int n2 = SpssAlertOptionPane.showConfirmDialog(this, this.mCanvas.getResources().getResString("ERR_DUALY_STAT_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n2 != 0) {
                return false;
            }
            if (bl2) {
                elProps2.getStatistic().setStat(Statistics.Value);
            } else {
                ZoneType zoneType = n == 0 ? ZoneType.zt_y : ZoneType.zt_y2;
                elProps2.getStatistic().setStat(this.mCanvas.getZoneMgr().getZone(zoneType).isEmpty() ? Statistics.Count : Statistics.Mean);
            }
        }
        return true;
    }

    public void notifyErrorBarChange(boolean bl) {
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        if (elProps != null && this.mCurrentPanel.getPanel() instanceof ElementPanel) {
            ElementPanel elementPanel = (ElementPanel)this.mCurrentPanel.getPanel();
            StatisticsPanel statisticsPanel = elementPanel.getStatsPanel();
            statisticsPanel.updateForErrorBars(bl);
        }
    }

    public CBOptionsPanel getOptionsPanel() {
        return this.mOptionsPanel;
    }

    public ChartAppearancePanel getChartAppearancePanel() {
        return this.mChartAppearancePanel;
    }

    public boolean canSwitchTab() {
        Component component;
        if (this.mInReload) {
            return true;
        }
        boolean bl = true;
        PropertiesPanel propertiesPanel = this.getCurrentPanel();
        if (propertiesPanel != null) {
            bl = propertiesPanel.canSwitchTab();
        }
        if (bl && (component = this.mTabbedPane.getSelectedComponent()) instanceof BasePropertiesPanel) {
            bl = ((BasePropertiesPanel)component).canSwitchTab();
        }
        return bl;
    }

    public void setInReload(boolean bl) {
        this.mInReload = bl;
    }

    Props.SSVData getElementSSVs() {
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        if (elProps != null) {
            return elProps.getSSVData();
        }
        elProps = this.mCanvas.getImager().getDefaultDataProp();
        if (elProps != null) {
            return elProps.getSSVData();
        }
        return null;
    }

    Props.ElProps getPrimaryElementProp() {
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        if (elProps == null) {
            elProps = this.mCanvas.getImager().getDefaultDataProp();
        }
        return elProps;
    }

    void updateErrorBarFootnote(IPropEnum.ErrorIntervalType errorIntervalType, double d, boolean bl) {
        Props.TitleProps titleProps = this.getAutoFootnoteProp(bl);
        if (titleProps == null) {
            return;
        }
        if (bl) {
            String string = errorIntervalType == IPropEnum.ErrorIntervalType.eit_MultStdDev ? this.mCanvas.getResources().getResString("IDS_ERROR_BARS_SD_FOOTNOTE") : (errorIntervalType == IPropEnum.ErrorIntervalType.eit_MultStdError ? this.mCanvas.getResources().getResString("IDS_ERROR_BARS_SE_FOOTNOTE") : this.mCanvas.getResources().getResString("IDS_ERROR_BARS_CI_FOOTNOTE"));
            String string2 = String.format(string, DialogUtil.formatDouble(d));
            titleProps.setStrTitle(string2);
            titleProps.setDeleted(false);
        } else {
            titleProps.setDeleted(true);
        }
    }

    private Props.TitleProps getAutoFootnoteProp(boolean bl) {
        Props.TitleProps titleProps;
        Props props;
        boolean bl2 = false;
        boolean bl3 = false;
        Props props2 = props = this.mCurrentPanel != null ? this.mCurrentPanel.getProp() : null;
        if (!(props instanceof Props.ElProps)) {
            return null;
        }
        String string = props.getStrElId();
        for (Props props3 : this.mProperties.getProperties()) {
            if (!(props3 instanceof Props.TitleProps) || (titleProps = (Props.TitleProps)props3).getTitleType() != IPropEnum.TitleFlag.tf_Footnote1 && titleProps.getTitleType() != IPropEnum.TitleFlag.tf_Footnote2) continue;
            if (string.equals(titleProps.getStrElAssoc()) && (titleProps.getFlags() & 0x8000) != 0) {
                return titleProps;
            }
            if (titleProps.getTitleType() == IPropEnum.TitleFlag.tf_Footnote1) {
                bl2 = true;
                continue;
            }
            if (titleProps.getTitleType() != IPropEnum.TitleFlag.tf_Footnote2) continue;
            bl3 = true;
        }
        titleProps = null;
        if (!(!bl || bl2 && bl3)) {
            titleProps = new Props.TitleProps();
            titleProps.setTitleType(bl2 ? IPropEnum.TitleFlag.tf_Footnote2 : IPropEnum.TitleFlag.tf_Footnote1);
            titleProps.setFlags(titleProps.getFlags() | 0x8000);
            titleProps.setStrElAssoc(string);
            titleProps.setModified(true);
            this.mProperties.addProp(titleProps);
        }
        return titleProps;
    }

    public void reset() {
        this.getChartAppearancePanel().reset();
    }

    @Override
    public void canvasChange(CanvasChangeEvent canvasChangeEvent) {
        this.updateContent();
    }

    public JTabbedPane getTabbedPane() {
        return this.mTabbedPane;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mInReload || listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.mApplyEnabled && this.mCurrentPanel != null) {
            if (!this.mCurrentPanel.getPanel().applyChanges()) {
                this.mInReload = true;
                this.selectPanel(this.mCurrentPanel, false);
                this.mInReload = false;
                return;
            }
            new ApplyPropertiesEdit(this.getCanvas().getUndoManager(), this.mCanvas.getParentDlg(), this.mProperties);
            this.setModified(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SidePropertiesPanel.this.selectPanelByIndex(SidePropertiesPanel.this.mMainList.getSelectedIndex());
            }
        });
        if (this.mHasDualYControls) {
            this.updateListButtons();
        }
        this.clearModFlag();
    }

    @Override
    public void itemModified() {
        this.setModified(true);
        this.applyChangesAsNeeded();
    }

    @Override
    public void clearModFlag() {
        this.setModified(false);
    }

    public void applyChangesAsNeeded() {
        if (this.applyChanges()) {
            new ApplyPropertiesEdit(this.getCanvas().getUndoManager(), this.mCanvas.getParentDlg(), this.mProperties);
            this.mCanvas.getTitleMgr().clearHighlight();
            this.mCanvas.updateTitlesText();
            this.mCanvas.repaint();
            this.setModified(false);
        }
    }

    ChartCanvas getCanvas() {
        return this.mCanvas;
    }

    private void addDragDropAdapters() {
        for (Map.Entry<String, PropertiesPanel> entry : this.mPanelMap.entrySet()) {
            entry.getValue().addDragAdapters();
        }
    }

    private PropertiesPanel getCurrentPanel() {
        return this.getPanelByIndex(this.mMainList.getSelectedIndex());
    }

    private PropertiesPanel getPanelByIndex(int n) {
        PanelItem panelItem = this.getPanelItemByIndex(n);
        return panelItem != null ? panelItem.getPanel() : null;
    }

    private PanelItem getPanelItemByIndex(int n) {
        Object e;
        PanelItem panelItem = null;
        if (n > -1 && n < this.mMainListModel.getSize() && (e = this.mMainListModel.getElementAt(n)) instanceof PanelItem) {
            panelItem = (PanelItem)e;
        }
        return panelItem;
    }

    private void updateContent() {
        try {
            this.mInReload = true;
            PanelItem panelItem = this.getPanelItemByIndex(this.mMainList.getSelectedIndex());
            this.mProperties = this.mCanvas.getProperties();
            Coords coords = this.mProperties.getCoords();
            boolean bl = coords == Coords.coords_none;
            this.loadProperties(this.mProperties);
            this.mInReload = false;
            this.setModified(false);
            if (!bl) {
                if (!this.selectPanel(panelItem, false)) {
                    this.mMainList.setSelectedIndex(0);
                    this.mCurrentPanel = (PanelItem)this.mMainList.getModel().getElementAt(0);
                    this.updateFocusTraversal();
                }
                if (this.isFocusCycleRoot()) {
                    this.mMainList.requestFocusInWindow();
                }
            } else {
                this.mExcludeButton.setEnabled(false);
                this.mSwapperPanel.setActivePanel("no_panel");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setModified(false);
    }

    private void loadProperties(ChartProps chartProps) {
        boolean bl;
        this.mMainListModel.clear();
        if (chartProps.getCoords() == Coords.coords_none) {
            return;
        }
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        Props.ElProps elProps2 = this.mProperties.getElementProp(1);
        int n = 1;
        String string = null;
        String string2 = null;
        Elements elements = elProps != null ? elProps.getElement() : null;
        PropertiesPanel propertiesPanel = this.getElementPanel(chartProps, elements);
        if (propertiesPanel != null) {
            string = this.generateName(elements, n++);
            this.mMainListModel.addElement(new PanelItem(propertiesPanel, elProps, string));
        }
        if ((propertiesPanel = this.getElementPanel(chartProps, elements = elProps2 != null ? elProps2.getElement() : null)) != null) {
            string2 = this.generateName(elements, n);
            this.mMainListModel.addElement(new PanelItem(propertiesPanel, elProps2, string2));
        }
        if (!(bl = this.mCanvas.getImager().isSplom())) {
            this.placeAxisProps(chartProps, string, string2);
        }
        if (!this.mCanvas.getImager().isOverlayScatter()) {
            this.placeLegendProps(chartProps, string);
        }
        this.placePanelProps(chartProps, string);
        this.placeTitleProps(chartProps);
    }

    private void placeAxisProps(ChartProps chartProps, String string, String string2) {
        for (Props props : chartProps.getProperties()) {
            boolean bl = props instanceof Props.LegendProps;
            boolean bl2 = props instanceof Props.PanelProps;
            boolean bl3 = props instanceof Props.AxisProps && !bl && !bl2;
            if (!bl3) continue;
            IPropEnum.AxisRole axisRole = ((Props.AxisProps)props).getAxisRole();
            String string3 = this.generateAxisName(axisRole, string, string2);
            PropertiesPanel propertiesPanel = this.getAxisPanel((Props.AxisProps)props);
            this.mMainListModel.addElement(new PanelItem(propertiesPanel, props, string3));
        }
    }

    private PropertiesPanel getAxisPanel(Props.AxisProps axisProps) {
        PropertiesPanel propertiesPanel = null;
        if (axisProps instanceof Props.ScaleAxisProps) {
            propertiesPanel = this.mPanelMap.get("scale_panel");
        } else if (axisProps instanceof Props.CatAxisProps) {
            IPropEnum.AxisRole axisRole = axisProps.getAxisRole();
            ZoneType zoneType = this.mCanvas.getZoneMgr().getIndexVarZoneType();
            if (zoneType != null && (zoneType == ZoneType.zt_x && axisRole == IPropEnum.AxisRole.ar_x || zoneType == ZoneType.zt_z && axisRole == IPropEnum.AxisRole.ar_z)) {
                propertiesPanel = this.mPanelMap.get("ssv_axis_panel");
            }
            if (propertiesPanel == null) {
                propertiesPanel = this.mPanelMap.get("cat_panel");
            }
        } else if (axisProps instanceof Props.AngleAxisProps) {
            propertiesPanel = this.mPanelMap.get("angle_panel");
        }
        return propertiesPanel;
    }

    private String generateAxisName(IPropEnum.AxisRole axisRole, String string, String string2) {
        String string3 = "";
        String string4 = this.makeAxisSuffix(axisRole, string, string2);
        String string5 = this.mCanvas.getResources().getResString("IDS_EL_PROP_AXIS");
        if (axisRole == IPropEnum.AxisRole.ar_x) {
            string3 = String.format(string5, "X", 1) + string4;
        } else if (axisRole == IPropEnum.AxisRole.ar_y) {
            string3 = String.format(string5, "Y", 1) + string4;
        } else if (axisRole == IPropEnum.AxisRole.ar_z) {
            string3 = String.format(string5, "Z", 1) + string4;
        } else if (axisRole == IPropEnum.AxisRole.ar_y2) {
            string3 = String.format(string5, "Y", 2) + string4;
        } else if (axisRole == IPropEnum.AxisRole.ar_theta) {
            string3 = String.format(string5, this.mCanvas.getResources().getResString("IDS_ANGLE"), 1) + string4;
        }
        return string3;
    }

    private String makeAxisSuffix(IPropEnum.AxisRole axisRole, String string, String string2) {
        String string3 = "";
        if (this.mCanvas.getImager().getCoordinates() == Coords.coords_DualY && (axisRole == IPropEnum.AxisRole.ar_y || axisRole == IPropEnum.AxisRole.ar_y2)) {
            boolean bl = false;
            for (Props props : this.mProperties.getProperties()) {
                if (!(props instanceof Props.ElProps)) continue;
                bl = props.getStrElAssoc().equals("2");
                break;
            }
            if (bl) {
                if (axisRole == IPropEnum.AxisRole.ar_y) {
                    string3 = string2 != null && string2.length() > 0 ? " (" + string2 + ")" : "";
                } else if (axisRole == IPropEnum.AxisRole.ar_y2) {
                    string3 = string != null && string.length() > 0 ? " (" + string + ")" : "";
                }
            } else if (axisRole == IPropEnum.AxisRole.ar_y) {
                string3 = string != null && string.length() > 0 ? " (" + string + ")" : "";
            } else if (axisRole == IPropEnum.AxisRole.ar_y2) {
                string3 = string2 != null && string2.length() > 0 ? " (" + string2 + ")" : "";
            }
        } else if (axisRole == IPropEnum.AxisRole.ar_x) {
            if (this.mCanvas.getImager().getCoordinates() == Coords.coords_DualY) {
                String string4 = "";
                if (string != null && string.length() > 0) {
                    string4 = string4 + " (" + string;
                }
                if (string2 != null && string2.length() > 0) {
                    string4 = string4 + (string4.length() > 0 ? "-" + string2 + ")" : " (" + string2 + ")");
                }
                string3 = string4;
            } else {
                string3 = string != null && string.length() > 0 ? " (" + string + ")" : "";
            }
        } else if (axisRole == IPropEnum.AxisRole.ar_y || axisRole == IPropEnum.AxisRole.ar_z || axisRole == IPropEnum.AxisRole.ar_theta) {
            string3 = string != null && string.length() > 0 ? " (" + string + ")" : "";
        }
        return string3;
    }

    private void placeLegendProps(ChartProps chartProps, String string) {
        for (Props props : chartProps.getProperties()) {
            if (!(props instanceof Props.LegendProps)) continue;
            String string2 = this.generateLegendName((Props.LegendProps)props, string);
            PropertiesPanel propertiesPanel = this.getLegendPanel((Props.LegendProps)props);
            this.mMainListModel.addElement(new PanelItem(propertiesPanel, props, string2));
        }
    }

    private String generateLegendName(Props.LegendProps legendProps, String string) {
        boolean bl = this.mCanvas.getImager().getUsesColorForStyleByType(legendProps.getZoneType());
        String string2 = legendProps.getZoneType() == ZoneType.zt_split_var ? this.mCanvas.getResources().getResString("IDS_SPLIT") : (bl ? this.mCanvas.getResources().getResString("IDS_GROUP_COLOR") : this.mCanvas.getResources().getResString("IDS_GROUP_PATTERN"));
        if (string != null && string.length() > 0) {
            string2 = string2 + " (" + string + ")";
        }
        return string2;
    }

    private PropertiesPanel getLegendPanel(Props.LegendProps legendProps) {
        ZoneType zoneType = this.mCanvas.getZoneMgr().getIndexVarZoneType();
        PropertiesPanel propertiesPanel = legendProps.getZoneType() == zoneType ? this.mPanelMap.get("ssv_axis_panel") : this.mPanelMap.get("legend_panel");
        return propertiesPanel;
    }

    private void placePanelProps(ChartProps chartProps, String string) {
        for (Props props : chartProps.getProperties()) {
            if (!(props instanceof Props.PanelProps)) continue;
            String string2 = this.generatePanelName((Props.PanelProps)props, string);
            PropertiesPanel propertiesPanel = this.getPanelPanel((Props.PanelProps)props);
            this.mMainListModel.addElement(new PanelItem(propertiesPanel, props, string2));
        }
    }

    private String generatePanelName(Props.PanelProps panelProps, String string) {
        String string2 = null;
        ZoneType zoneType = panelProps.getZoneType();
        if (zoneType == ZoneType.zt_filter) {
            string2 = this.mCanvas.getResources().getResString("IDS_FILTER_PANEL") + panelProps.getPanelIndex();
        } else if (zoneType == ZoneType.zt_panel_horz) {
            string2 = this.mCanvas.getResources().getResString("IDS_COLUMNS_PANEL");
        } else if (zoneType == ZoneType.zt_panel_vert) {
            string2 = this.mCanvas.getResources().getResString("IDS_ROWS_PANEL");
        }
        if (string != null && string.length() > 0) {
            string2 = string2 + " (" + string + ")";
        }
        return string2;
    }

    private PropertiesPanel getPanelPanel(Props.PanelProps panelProps) {
        ZoneType zoneType = this.mCanvas.getZoneMgr().getIndexVarZoneType();
        PropertiesPanel propertiesPanel = panelProps.getZoneType() == zoneType ? this.mPanelMap.get("ssv_axis_panel") : this.mPanelMap.get("panels_panel");
        return propertiesPanel;
    }

    private void placeTitleProps(ChartProps chartProps) {
        for (Props props : chartProps.getProperties()) {
            if (!(props instanceof Props.TitleProps)) continue;
            String string = this.generateTitleName((Props.TitleProps)props);
            PropertiesPanel propertiesPanel = this.mPanelMap.get("titles_panel");
            this.mMainListModel.addElement(new PanelItem(propertiesPanel, props, string));
        }
    }

    private String generateTitleName(Props.TitleProps titleProps) {
        String string = null;
        IPropEnum.TitleFlag titleFlag = titleProps.getTitleType();
        if (titleFlag == IPropEnum.TitleFlag.tf_Title1) {
            string = this.mCanvas.getResources().getResString("IDS_TITLE1");
        } else if (titleFlag == IPropEnum.TitleFlag.tf_Title2) {
            string = this.mCanvas.getResources().getResString("IDS_TITLE2");
        } else if (titleFlag == IPropEnum.TitleFlag.tf_Subtitle) {
            string = this.mCanvas.getResources().getResString("IDS_SUBTITLE1");
        } else if (titleFlag == IPropEnum.TitleFlag.tf_Footnote1) {
            string = this.mCanvas.getResources().getResString("IDS_FOOTNOTE1");
        } else if (titleFlag == IPropEnum.TitleFlag.tf_Footnote2) {
            string = this.mCanvas.getResources().getResString("IDS_FOOTNOTE2");
        }
        return string;
    }

    private PropertiesPanel getElementPanel(ChartProps chartProps, Elements elements) {
        if (elements == null || elements == Elements.none) {
            return null;
        }
        PropertiesPanel propertiesPanel = elements == Elements.hilo || elements == Elements.diff_area ? this.mPanelMap.get("hilo_panel") : (elements == Elements.pyramid ? this.mPanelMap.get("pyramid_panel") : (elements == Elements.splom ? this.mPanelMap.get("splom_panel") : (chartProps.getHasSSVs() ? this.mPanelMap.get("ssv_element_panel") : (elements == Elements.polar_interval ? this.mPanelMap.get("polar_panel") : (chartProps.getIsOverlayScatter() ? this.mPanelMap.get("overlay_panel") : (elements == Elements.point && chartProps.getCoords() == Coords.coords_1D ? this.mPanelMap.get("dotplot_panel") : (this.mCanvas.getImager().getCoordinates() == Coords.coords_DualY ? this.mPanelMap.get("dualy_panel") : this.mPanelMap.get("element_panel"))))))));
        return propertiesPanel;
    }

    private String getResString(String string) {
        return this.mChartBuilderDlg.getResString(string);
    }

    private String generateName(Elements elements, int n) {
        String string = "";
        if (elements == Elements.area) {
            string = this.getResString("IDS_AREA");
        } else if (elements == Elements.diff_area) {
            string = this.getResString("IDS_DIFF_AREA");
        } else if (elements == Elements.hilo) {
            string = this.getResString("IDS_HI_LO_CLOSE");
        } else if (elements == Elements.interval) {
            string = this.getResString("IDS_BAR");
        } else if (elements == Elements.line) {
            string = this.getResString("IDS_LINE");
        } else if (elements == Elements.point) {
            string = this.getResString("IDS_POINT");
        } else if (elements == Elements.polar_interval) {
            string = this.getResString("IDS_POLAR_INTERVAL");
        } else if (elements == Elements.pyramid) {
            string = this.getResString("IDS_PYRAMID");
        } else if (elements == Elements.schema) {
            string = this.getResString("IDS_BOX");
        } else if (elements == Elements.splom) {
            string = this.getResString("IDS_SCATTERMATRIX");
        } else {
            return string;
        }
        return string + Integer.toString(n);
    }

    private boolean selectPanel(PanelItem panelItem, boolean bl) {
        if (bl) {
            this.mTabbedPane.setSelectedIndex(0);
        }
        for (int i = 0; i < this.mMainListModel.getSize(); ++i) {
            if (!this.getPanelItemByIndex(i).equals(panelItem)) continue;
            this.mMainList.setSelectedIndex(i);
            this.mCurrentPanel = panelItem;
            this.updateFocusTraversal();
            return true;
        }
        return false;
    }

    private void updateFocusTraversal() {
        this.mTabOrder.clear();
        this.mTabOrder.add(this.mMainList);
        if (this.mUpButton.getParent() == this.mListPanel) {
            this.mTabOrder.add(this.mUpButton);
        }
        if (this.mDownButton.getParent() == this.mListPanel) {
            this.mTabOrder.add(this.mDownButton);
        }
        if (this.mExcludeButton.getParent() == this.mListPanel) {
            this.mTabOrder.add(this.mExcludeButton);
        }
        this.mCurrentPanel.getPanel().addTabTraversalComponents(this.mTabOrder);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void selectPanelByIndex(int n) {
        PanelItem panelItem = this.getPanelItemByIndex(n);
        if (panelItem == null) {
            return;
        }
        PropertiesPanel propertiesPanel = panelItem.getPanel();
        boolean bl = propertiesPanel != null && (propertiesPanel instanceof ElementPanel || propertiesPanel instanceof TitlesPanel);
        boolean bl2 = propertiesPanel != null && propertiesPanel instanceof DualYElementPanel;
        this.mExcludeButton.setEnabled(bl);
        if (propertiesPanel == null) {
            return;
        }
        this.mCurrentPanel = panelItem;
        propertiesPanel.initialize(this.mProperties, panelItem.getProp());
        this.mSwapperPanel.setActivePanel(propertiesPanel.getPanelId());
        if (this.mHasDualYControls != bl2) {
            this.setDualYControls(bl2);
        }
        this.mMainList.ensureIndexIsVisible(n);
        this.mCanvas.setHighlights(this.getHighlights(this.mCurrentPanel.getProp()));
        this.mCanvas.clearHighlight2();
        ZoneType zoneType = null;
        if (panelItem.getProp() instanceof Props.AxisProps) {
            zoneType = ((Props.AxisProps)panelItem.getProp()).getZoneType();
        }
        if (zoneType != null) {
            this.mCanvas.getZoneMgr().highlight2Zone(this.mCanvas.getZoneMgr().getZone(zoneType));
        } else if (panelItem.getProp() instanceof Props.TitleProps) {
            this.mCanvas.getTitleMgr().highlightTitle(((Props.TitleProps)panelItem.getProp()).getTitleType());
        }
        this.updateFocusTraversal();
    }

    private String getHighlights(Props props) {
        String string;
        if (props == null) {
            return "";
        }
        String string2 = props.getStrElId();
        if (props instanceof Props.HiLoCloseProps && this.mCanvas.getImager().isHiLoClose()) {
            String string3 = this.mCanvas.getImager().getRangeElementId();
            if (string3 != null && string3.length() > 0) {
                string2 = this.mCanvas.getZoneMgr().hasScaleVar(ZoneType.zt_close) ? string2 + ";" + string3 : string3;
            }
        } else if (props instanceof Props.ElProps && (props.getFlags() & 0x10) != 0 && (string = this.mCanvas.getImager().getErrorBarsId(props.getStrElId())) != null && string.length() > 0) {
            string2 = string2 + ";" + string;
        }
        return string2;
    }

    private void setDualYControls(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(1, 2, n2, n2 - 1);
        this.mHasDualYControls = bl;
        if (bl) {
            this.mListPanel.remove(this.mExcludeButton);
            DialogUtil.addUsingGBL(this.mListPanel, this.mUpButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
            DialogUtil.addUsingGBL(this.mListPanel, this.mDownButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(this.mListPanel, this.mExcludeButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
            this.updateListButtons();
        } else {
            this.mListPanel.remove(this.mUpButton);
            this.mListPanel.remove(this.mDownButton);
            this.mListPanel.remove(this.mExcludeButton);
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(this.mListPanel, this.mExcludeButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        }
    }

    private void updateListButtons() {
        if (!this.mHasDualYControls) {
            return;
        }
        int n = this.mMainListModel.getSize();
        int n2 = this.mMainList.getSelectedIndex();
        boolean bl = false;
        if (n2 == 0 && n > 1) {
            PanelItem panelItem = this.getPanelItemByIndex(1);
            bl = panelItem.getPanel() instanceof ElementPanel;
        }
        boolean bl2 = n2 > 0;
        boolean bl3 = bl;
        this.mUpButton.setEnabled(bl2);
        this.mDownButton.setEnabled(bl3);
    }

    private void setModified(boolean bl) {
        boolean bl2 = true;
        if (bl) {
            bl2 = this.getCurrentPanel() == null || this.getCurrentPanel().canApply();
        }
        this.mApplyEnabled = bl && bl2;
    }

    private void setupPanels() {
        Class[] classArray;
        for (Class clazz : classArray = new Class[]{AngleAxisPanel.class, CategoricalAxisPanel.class, DualYElementPanel.class, ElementPanel.class, EmptyPanel.class, HiLoElementPanel.class, LegendPanel.class, OneDDotPanel.class, OverlayElementPanel.class, PanelsPanel.class, PolarElementPanel.class, PyramidPanel.class, ScaleAxisPanel.class, SplomPanel.class, SSVAxisPanel.class, SSVElementPanel.class, TitlesPanel.class}) {
            try {
                Constructor constructor = clazz.getConstructor(ChartCanvas.class, IModListener.class);
                PropertiesPanel propertiesPanel = (PropertiesPanel)constructor.newInstance(new Object[]{this.mCanvas, this});
                propertiesPanel.setParentDlg(this.mChartBuilderDlg);
                this.mPanelMap.put(propertiesPanel.getPanelId(), propertiesPanel);
                this.mSwapperPanel.addPanel(propertiesPanel, propertiesPanel.getPanelId());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean applyChanges() {
        PropertiesPanel propertiesPanel = this.getCurrentPanel();
        boolean bl = true;
        if (this.mChartAppearancePanel.isDirty()) {
            bl = this.mApplyEnabled && this.mChartAppearancePanel.applyChanges();
        }
        return bl && this.mApplyEnabled && (propertiesPanel == null || propertiesPanel.applyChanges());
    }

    private void excludeSelected() {
        int n = this.mMainList.getSelectedIndex();
        PanelItem panelItem = this.getPanelItemByIndex(n);
        if (panelItem != null) {
            this.mMainListModel.removeElement(panelItem);
            panelItem.getProp().setDeleted(true);
            this.setModified(true);
            if (this.mMainListModel.getSize() == 0) {
                this.mExcludeButton.setEnabled(false);
                this.mSwapperPanel.setActivePanel("no_panel");
            } else {
                this.selectPanelByIndex(0);
                if (this.mHasDualYControls) {
                    this.updateListButtons();
                }
            }
        }
    }

    private void initElementPropPanel(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, n2, 1, n2);
        JLabel jLabel = new JLabel(this.getResString("IDS_EDIT_PROPERTIES"));
        jLabel.setDisplayedMnemonic(this.mChartBuilderDlg.getDlgAccessKey("IDK_EDIT_PROPERTIES_KEY"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mListPanel = new JPanel(new GridBagLayout(), true);
        insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mListPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mMainListModel = new DefaultListModel();
        this.mMainList = new JList(this.mMainListModel);
        jLabel.setLabelFor(this.mMainList);
        this.mMainList.setCellRenderer(new CustomVarListCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.mMainList);
        insets = new Insets(1, n2, n2, 1);
        DialogUtil.addUsingGBL(this.mListPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 3, n, insets);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width <= 800 || dimension.height <= 600) {
            this.mMainList.setMinimumSize(new Dimension(200, 50));
            jScrollPane.setMinimumSize(new Dimension(200, 55));
            jScrollPane.setPreferredSize(new Dimension(200, 55));
        } else {
            this.mMainList.setMinimumSize(new Dimension(200, 65));
            jScrollPane.setMinimumSize(new Dimension(200, 70));
            jScrollPane.setPreferredSize(new Dimension(200, 70));
        }
        this.mMainList.addListSelectionListener(this);
        this.mMainList.setSelectionMode(0);
        jLabel.setLabelFor(this.mMainList);
        Dimension dimension2 = new Dimension(24, 22);
        this.mExcludeButton = new ExcludeButton();
        String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_REMOVE_MESSAGE"), jLabel.getText());
        this.mExcludeButton.getAccessibleContext().setAccessibleName(string);
        insets = new Insets(1, 2, n2, n2 - 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this.mListPanel, this.mExcludeButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mExcludeButton.setPreferredSize(dimension2);
        this.mExcludeButton.setMaximumSize(dimension2);
        this.mExcludeButton.setEnabled(false);
        this.mUpButton = new UpDownArrowButton(SpssArrowButton.ButtonOrientation.up);
        this.mUpButton.setPreferredSize(dimension2);
        this.mUpButton.setMaximumSize(dimension2);
        this.mUpButton.setEnabled(false);
        this.mDownButton = new UpDownArrowButton(SpssArrowButton.ButtonOrientation.down);
        this.mDownButton.setPreferredSize(dimension2);
        this.mDownButton.setMaximumSize(dimension2);
        this.mDownButton.setEnabled(false);
        this.mSwapperPanel = new ComponentSwapperPanel();
        insets = new Insets(0, n2, 0, n2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSwapperPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    public boolean isCollapseOK() {
        boolean bl;
        boolean bl2 = !this.mCanvas.getImager().isHiLoClose() && !this.mCanvas.getImager().isDifferenceArea();
        boolean bl3 = false;
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        if (bl2 && elProps != null) {
            Statistics statistics = elProps.getStatistic().getStat();
            bl3 = statistics == Statistics.Count || statistics == Statistics.Sum || statistics == Statistics.ValidN || statistics == Statistics.PctOfCases;
            bl3 &= (elProps.getFlags() & 0x10) == 0;
        }
        boolean bl4 = bl = this.mProperties.getCoords() == Coords.coords_1D && elProps instanceof Props.PointProps;
        if (this.mCanvas.getImager().isSchema() || bl) {
            bl3 = false;
        }
        if (bl3 && this.mProperties.getCoords() == Coords.coords_DualY && (elProps = this.mProperties.getElementProp(1)) != null) {
            bl3 = (elProps.getFlags() & 0x10) == 0;
        }
        return bl2 && bl3;
    }

    class UpDownArrowButton
    extends PlainListArrowButton {
        public UpDownArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(buttonOrientation);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.moveSelected(this.mArrowOrientation == SpssArrowButton.ButtonOrientation.down);
        }

        private void moveSelected(boolean bl) {
            Object e;
            int n;
            boolean bl2;
            int[] nArray = SidePropertiesPanel.this.mMainList.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            int n2 = bl ? nArray[nArray.length - 1] : nArray[0];
            int n3 = SidePropertiesPanel.this.mMainList.getModel().getSize();
            boolean bl3 = !bl && n2 == 0;
            boolean bl4 = bl2 = bl && n2 == n3 - 1;
            if (bl3 || bl2) {
                return;
            }
            boolean bl5 = false;
            for (n = 0; n < n3; ++n) {
                int n4;
                int n5 = n4 = bl ? n3 - n - 1 : n;
                if (!SidePropertiesPanel.this.mMainList.isSelectedIndex(n4)) continue;
                e = SidePropertiesPanel.this.mMainListModel.getElementAt(n4);
                SidePropertiesPanel.this.mInReload = true;
                SidePropertiesPanel.this.mMainListModel.removeElementAt(n4);
                n4 = bl ? n4 + 1 : n4 - 1;
                SidePropertiesPanel.this.mMainListModel.insertElementAt(e, n4);
                SidePropertiesPanel.this.mMainList.addSelectionInterval(n4, n4);
                SidePropertiesPanel.this.mInReload = false;
                bl5 = true;
                if (!SidePropertiesPanel.this.mHasDualYControls) continue;
                SidePropertiesPanel.this.updateListButtons();
            }
            if (bl5) {
                for (n = 0; n < n3; ++n) {
                    PanelItem panelItem;
                    e = SidePropertiesPanel.this.mMainListModel.getElementAt(n);
                    if (!(e instanceof PanelItem) || !((panelItem = (PanelItem)e).getProp() instanceof Props.ElProps)) continue;
                    int n6 = panelItem.getProp().getFlags();
                    panelItem.getProp().setFlags(n6 ^= 0x40);
                }
            }
            nArray = SidePropertiesPanel.this.mMainList.getSelectedIndices();
            SidePropertiesPanel.this.mMainList.ensureIndexIsVisible(bl ? nArray[nArray.length - 1] : nArray[0]);
            SidePropertiesPanel.this.setModified(true);
        }
    }

    class ExcludeButton
    extends JButton {
        public ExcludeButton() {
            this.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SidePropertiesPanel.this.excludeSelected();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SidePropertiesPanel.this.applyChanges()) {
                                new ApplyPropertiesEdit(SidePropertiesPanel.this.getCanvas().getUndoManager(), SidePropertiesPanel.this.mCanvas.getParentDlg(), SidePropertiesPanel.this.mProperties);
                                SidePropertiesPanel.this.setModified(false);
                            }
                        }
                    });
                }
            });
            String string = ResUtil.getCommonDlgString("IDS_EXCLUDE_IMAGE");
            ImageIcon imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(string));
            this.setIcon(imageIcon);
            string = ResUtil.getCommonDlgString("IDS_EXCLUDE_DISABLED_IMAGE");
            this.setDisabledIcon(new ImageIcon(ResUtil.getCommonDlgImageResource(string)));
            Image image = imageIcon.getImage().getScaledInstance(imageIcon.getIconHeight() + 1, imageIcon.getIconHeight() + 1, 4);
            this.setRolloverIcon(new ImageIcon(image));
            image = imageIcon.getImage().getScaledInstance(imageIcon.getIconHeight() - 1, imageIcon.getIconHeight() - 1, 4);
            this.setPressedIcon(new ImageIcon(image));
        }
    }

    class PanelItem {
        private PropertiesPanel mPanel;
        private String mName;
        private Props mProp;

        public PanelItem(PropertiesPanel propertiesPanel, Props props, String string) {
            this.mPanel = propertiesPanel;
            this.mProp = props;
            this.mName = string;
        }

        public String toString() {
            return this.mName;
        }

        public PropertiesPanel getPanel() {
            return this.mPanel;
        }

        public Props getProp() {
            return this.mProp;
        }

        public boolean equals(Object object) {
            if (object instanceof PanelItem) {
                PanelItem panelItem = (PanelItem)object;
                return panelItem.toString().equals(this.toString());
            }
            return false;
        }
    }
}

