/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.AxisPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.res.IResourceAccessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.net.URL;
import java.text.Bidi;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class ScaleAxisPanel
extends AxisPanel
implements ActionListener,
DocumentListener {
    private KeyListener processKeyEvent = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            JTextField jTextField;
            if (ComponentState.getBTD() == 0 && keyEvent.getSource() instanceof JTextField && (jTextField = (JTextField)keyEvent.getSource()).getCaretPosition() == 0) {
                if (new Bidi(Character.toString(keyEvent.getKeyChar()), 1).isRightToLeft()) {
                    jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                } else {
                    jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    };
    final int LINEAR = 0;
    final int LOG = 1;
    final int SAFE_LOG = 2;
    final int POWER = 3;
    protected IResourceAccessor mResources;
    private Props.ScaleAxisProps mProp;
    private boolean mInReload;
    private JTextField mLabelEdit;
    private JLabel mVarPromptLabel;
    private JLabel mVarNameLabel;
    private Color mEnabledColor;
    private boolean mIsSummaryVariable;
    private NoLabelCheckBox mMinimumCheck;
    private FloatTextField mMinimumEdit;
    private NoLabelCheckBox mMaximumCheck;
    private FloatTextField mMaximumEdit;
    private NoLabelCheckBox mIncrementCheck;
    private FloatTextField mIncrementEdit;
    private NoLabelCheckBox mOriginCheck;
    private FloatTextField mOriginEdit;
    private JComboBox mScaleTypeCombo;
    private JLabel mLogBaseLabel;
    private FloatTextField mLogBaseEdit;
    private JLabel mPowerExponentLabel;
    private FloatTextField mPowerExponentEdit;

    public ScaleAxisPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.mResources = chartCanvas.getResources();
        this.mInReload = false;
        this.init();
        this.mMinimumCheck.addActionListener(this);
        this.mMaximumCheck.addActionListener(this);
        this.mIncrementCheck.addActionListener(this);
        this.mOriginCheck.addActionListener(this);
        this.mScaleTypeCombo.addActionListener(this);
        this.mLabelEdit.getDocument().addDocumentListener(this);
        this.mMinimumEdit.getDocument().addDocumentListener(this);
        this.mMaximumEdit.getDocument().addDocumentListener(this);
        this.mIncrementEdit.getDocument().addDocumentListener(this);
        this.mOriginEdit.getDocument().addDocumentListener(this);
        this.mLogBaseEdit.getDocument().addDocumentListener(this);
        this.mPowerExponentEdit.getDocument().addDocumentListener(this);
        this.mLabelEdit.addFocusListener(this);
        this.mMinimumEdit.addFocusListener((FocusListener)this);
        this.mMaximumEdit.addFocusListener((FocusListener)this);
        this.mIncrementEdit.addFocusListener((FocusListener)this);
        this.mOriginEdit.addFocusListener((FocusListener)this);
        this.mLogBaseEdit.addFocusListener((FocusListener)this);
        this.mPowerExponentEdit.addFocusListener((FocusListener)this);
    }

    @Override
    public String getPanelId() {
        return "scale_panel";
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mLabelEdit);
        vector.add(this.mMinimumCheck);
        vector.add(this.mMinimumEdit);
        vector.add(this.mMaximumCheck);
        vector.add(this.mMaximumEdit);
        vector.add(this.mIncrementCheck);
        vector.add(this.mIncrementEdit);
        vector.add(this.mOriginCheck);
        vector.add(this.mOriginEdit);
        vector.add(this.mScaleTypeCombo);
        vector.add(this.mLogBaseEdit);
        vector.add(this.mPowerExponentEdit);
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        this.mInReload = true;
        if (props instanceof Props.ScaleAxisProps) {
            this.mProp = (Props.ScaleAxisProps)props;
            if (ComponentState.getBTD() == 0 && this.mProp.getStrLabel() != null && this.mProp.getStrLabel().length() > 0) {
                if (ComponentState.isBidiLetter((char)this.mProp.getStrLabel().charAt(0)) || this.mProp.getStrLabel().charAt(0) == '\u05b9') {
                    this.mLabelEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                } else {
                    this.mLabelEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
            this.mLabelEdit.setText(this.mProp.getStrLabel());
            this.mLabelEdit.setCaretPosition(0);
            Object object = "";
            this.mIsSummaryVariable = false;
            boolean bl = false;
            DropZone dropZone = this.mCanvas.getZoneMgr().getZone(this.mProp.getZoneType());
            if (dropZone != null && !dropZone.isEmpty()) {
                Object object2;
                Object object3;
                this.mVarPromptLabel.setEnabled(true);
                this.mVarNameLabel.setEnabled(true);
                if (dropZone.isDependentVarZone() && this.mCanvas.getImager().hasSSVs()) {
                    object = this.mResources.getResString("IDS_SUMMARY");
                    this.mVarPromptLabel.setEnabled(true);
                    this.mVarNameLabel.setEnabled(true);
                    object3 = ResUtil.getCommonDlgString("IDS_SCALE_VAR_IMAGE");
                    object2 = ResUtil.getCommonDlgImageResource((String)object3);
                    this.mVarNameLabel.setIcon(new ImageIcon((URL)object2));
                    if (ComponentState.isBtdRtlOrLtr()) {
                        this.mVarNameLabel.setText(ComponentState.prepareStringForBidiRendering((String)object));
                    } else {
                        this.mVarNameLabel.setText((String)object);
                    }
                    this.mIsSummaryVariable = true;
                } else {
                    object3 = dropZone.getVariables().get(0);
                    this.mVarNameLabel.setIcon(VariableList.getStandardIcon(object3));
                    object2 = object3.getLabel();
                    if (object2 == null || ((String)object2).length() == 0) {
                        object2 = object3.getName();
                    }
                    if (ComponentState.isBtdRtlOrLtr()) {
                        this.mVarNameLabel.setText(ComponentState.prepareStringForBidiRendering((String)object2));
                    } else {
                        this.mVarNameLabel.setText((String)object2);
                    }
                    object = object2;
                    bl = object3.getFormat().getFormatType().isDateOrTimeFormat();
                }
            } else {
                this.mVarNameLabel.setIcon(null);
                this.mVarNameLabel.setText(null);
                this.mVarPromptLabel.setEnabled(false);
                this.mVarNameLabel.setEnabled(false);
            }
            this.mVarNameLabel.setToolTipText((String)object);
            int n = this.mProp.getFlags();
            if (bl) {
                this.mMinimumCheck.setSelected(true);
                this.mMaximumCheck.setSelected(true);
                this.mIncrementCheck.setSelected(true);
                this.mOriginCheck.setSelected(true);
                this.mMinimumCheck.setEnabled(false);
                this.mMaximumCheck.setEnabled(false);
                this.mIncrementCheck.setEnabled(false);
                this.mOriginCheck.setEnabled(false);
                int n2 = 15;
                if ((n & n2) != n2) {
                    this.mProp.setFlags(n | n2);
                    this.mCanvas.setProperties(chartProps);
                }
            } else {
                this.mMinimumCheck.setEnabled(true);
                this.mMaximumCheck.setEnabled(true);
                this.mIncrementCheck.setEnabled(true);
                this.mOriginCheck.setEnabled(true);
                this.mMinimumCheck.setSelected((n & 1) != 0);
                this.mMaximumCheck.setSelected((n & 2) != 0);
                this.mIncrementCheck.setSelected((n & 4) != 0);
                this.mOriginCheck.setSelected((n & 8) != 0);
            }
            this.mMinimumEdit.setText(bl ? "0" : this.mProp.getStrMinimum());
            this.mMaximumEdit.setText(bl ? "0" : this.mProp.getStrMaximum());
            this.mIncrementEdit.setText(bl ? "0" : this.mProp.getStrMajorIncrement());
            this.mOriginEdit.setText(bl ? "0" : this.mProp.getStrOrigin());
            IPropEnum.ScaleType scaleType = this.mProp.getScaleType();
            int n3 = 0;
            if (scaleType == IPropEnum.ScaleType.st_Linear) {
                n3 = 0;
            } else if (scaleType == IPropEnum.ScaleType.st_Log) {
                n3 = 1;
            } else if (scaleType == IPropEnum.ScaleType.st_SafeLog) {
                n3 = 2;
            } else if (scaleType == IPropEnum.ScaleType.st_Power) {
                n3 = 3;
            }
            this.mScaleTypeCombo.setSelectedIndex(n3);
            this.mLogBaseEdit.setText(this.mProp.getStrBase());
            this.mPowerExponentEdit.setText(this.mProp.getStrExponent());
            this.updateCheckBoxEditField(this.mMinimumCheck);
            this.updateCheckBoxEditField(this.mMaximumCheck);
            this.updateCheckBoxEditField(this.mIncrementCheck);
            this.updateCheckBoxEditField(this.mOriginCheck);
            this.updateScaleTypeFields();
        }
        this.mInReload = false;
    }

    @Override
    boolean applyChanges() {
        if (!this.validateContent()) {
            return false;
        }
        this.mProp.setStrLabel(this.mLabelEdit.getText());
        int n = this.mProp.getFlags();
        n = this.mMinimumCheck.isSelected() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = this.mMaximumCheck.isSelected() ? (n |= 2) : (n &= 0xFFFFFFFD);
        n = this.mIncrementCheck.isSelected() ? (n |= 4) : (n &= 0xFFFFFFFB);
        n = this.mOriginCheck.isSelected() ? (n |= 8) : (n &= 0xFFFFFFF7);
        this.mProp.setFlags(n);
        this.mProp.setStrMinimum(this.mMinimumEdit.getText());
        this.mProp.setStrMaximum(this.mMaximumEdit.getText());
        this.mProp.setStrMajorIncrement(this.mIncrementEdit.getText());
        this.mProp.setStrOrigin(this.mOriginEdit.getText());
        this.mProp.setStrBase(this.mLogBaseEdit.getText());
        this.mProp.setStrExponent(this.mPowerExponentEdit.getText());
        IPropEnum.ScaleType scaleType = IPropEnum.ScaleType.st_Linear;
        int n2 = this.mScaleTypeCombo.getSelectedIndex();
        if (n2 == 1) {
            scaleType = IPropEnum.ScaleType.st_Log;
        } else if (n2 == 2) {
            scaleType = IPropEnum.ScaleType.st_SafeLog;
        } else if (n2 == 3) {
            scaleType = IPropEnum.ScaleType.st_Power;
        }
        this.mProp.setScaleType(scaleType);
        this.mIsEditFieldDirty = false;
        return true;
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.mIsSummaryVariable) {
            Point point = this.mVarNameLabel.getBounds().getLocation();
            Point point2 = SwingUtilities.convertPoint(this.mVarNameLabel.getParent(), point, this);
            graphics.setFont(this.mVarNameLabel.getFont());
            graphics.drawString("*", point2.x + 11, point2.y + 18);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.mMinimumCheck || object == this.mMaximumCheck || object == this.mIncrementCheck || object == this.mOriginCheck) {
            this.updateCheckBoxEditField(object);
        } else if (object == this.mScaleTypeCombo) {
            this.updateScaleTypeFields();
        }
        this.mModListener.itemModified();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mInReload) {
            return;
        }
        this.mIsEditFieldDirty = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mInReload) {
            return;
        }
        this.mIsEditFieldDirty = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mInReload) {
            return;
        }
        this.mIsEditFieldDirty = true;
    }

    private void registerKeyListener(JTextField jTextField) {
        jTextField.addKeyListener(this.processKeyEvent);
    }

    private boolean validateContent() {
        String string;
        boolean bl;
        boolean bl2;
        String string2 = this.mMinimumEdit.getText();
        String string3 = this.mMaximumEdit.getText();
        String string4 = this.mIncrementEdit.getText();
        String string5 = this.mOriginEdit.getText();
        double d = string2 != null && string2.length() > 0 ? Double.valueOf(string2) : -1.0;
        double d2 = string3 != null && string3.length() > 0 ? Double.valueOf(string3) : -1.0;
        double d3 = string4 != null && string4.length() > 0 ? Double.valueOf(string4) : -1.0;
        double d4 = string5 != null && string5.length() > 0 ? Double.valueOf(string5) : -1.0;
        boolean bl3 = !this.mMinimumCheck.isSelected() && !this.mMaximumCheck.isSelected() && d >= d2;
        boolean bl4 = !this.mMinimumCheck.isSelected() && !this.mOriginCheck.isSelected() && d > d4;
        boolean bl5 = !this.mMaximumCheck.isSelected() && !this.mOriginCheck.isSelected() && d2 < d4;
        boolean bl6 = bl2 = !this.mMaximumCheck.isSelected() && !this.mIncrementCheck.isSelected() && d3 >= d2 - d;
        if (!this.mMinimumCheck.isSelected()) {
            boolean bl7 = bl = string2 == null || string2.length() == 0;
            if (bl || bl3 || bl4) {
                String string6 = bl ? this.mResources.getResString("ERR_NO_MINIMUM") : (bl3 ? this.mResources.getResString("ERR_MIN_MORE_THAN_MAX") : this.mResources.getResString("ERR_ORIGIN_BWTN_MINMAX"));
                SpssAlertOptionPane.showWarningMessageDialog(this, string6, VersionInfo.getAppVersionString());
                this.reselect((JTextField)this.mMinimumEdit);
                return false;
            }
        }
        if (!this.mMaximumCheck.isSelected()) {
            boolean bl8 = bl = string3 == null || string3.length() == 0;
            if (bl || bl3 || bl5) {
                String string7 = bl ? this.mResources.getResString("ERR_NO_MAXIMUM") : (bl3 ? this.mResources.getResString("ERR_MIN_MORE_THAN_MAX") : this.mResources.getResString("ERR_ORIGIN_BWTN_MINMAX"));
                SpssAlertOptionPane.showWarningMessageDialog(this, string7, VersionInfo.getAppVersionString());
                this.reselect((JTextField)this.mMaximumEdit);
                return false;
            }
        }
        if (!this.mIncrementCheck.isSelected()) {
            bl = string4 == null || string4.length() == 0;
            if ((bl |= d3 <= 0.0) || bl2) {
                String string8 = bl ? this.mResources.getResString("ERR_NO_MAJOR_INC") : this.mResources.getResString("ERR_MAJINC_MORE_THAN_MAX");
                SpssAlertOptionPane.showWarningMessageDialog(this, string8, VersionInfo.getAppVersionString());
                this.reselect((JTextField)this.mIncrementEdit);
                return false;
            }
        }
        if (!this.mOriginCheck.isSelected()) {
            boolean bl9 = bl = string5 == null || string5.length() == 0;
            if (bl || bl4 || bl5) {
                String string9 = bl ? this.mResources.getResString("ERR_NO_ORIGIN") : this.mResources.getResString("ERR_ORIGIN_BWTN_MINMAX");
                SpssAlertOptionPane.showWarningMessageDialog(this, string9, VersionInfo.getAppVersionString());
                this.reselect((JTextField)this.mOriginEdit);
                return false;
            }
        }
        boolean bl10 = this.mMinimumCheck.isSelected();
        boolean bl11 = this.mMaximumCheck.isSelected();
        boolean bl12 = this.mOriginCheck.isSelected();
        boolean bl13 = bl10 || Double.valueOf(string2) > 0.0;
        boolean bl14 = bl11 || Double.valueOf(string3) > 0.0;
        boolean bl15 = bl12 || Double.valueOf(string5) > 0.0;
        int n = this.mScaleTypeCombo.getSelectedIndex();
        if (n == 1 || n == 2) {
            string = this.mLogBaseEdit.getText();
            boolean bl16 = false;
            if (string != null && string.length() > 0) {
                boolean bl17 = bl16 = Double.valueOf(string) > 1.0;
            }
            if (!bl16) {
                String string10 = this.mResources.getResString("ERR_LOG_BASE_ERROR");
                SpssAlertOptionPane.showWarningMessageDialog(this, string10, VersionInfo.getAppVersionString());
                this.reselect((JTextField)this.mLogBaseEdit);
                return false;
            }
            if (!(n != 1 || bl13 && bl14 && bl15)) {
                String string11 = this.mResources.getResString("ERR_LOG_SCALE_ERROR");
                SpssAlertOptionPane.showWarningMessageDialog(this, string11, VersionInfo.getAppVersionString());
                this.reselect((JTextField)this.mLogBaseEdit);
                return false;
            }
        }
        if (n == 3) {
            string = this.mPowerExponentEdit.getText();
            double d5 = 0.0;
            boolean bl18 = false;
            if (string != null && string.length() > 0) {
                d5 = Double.valueOf(string);
                boolean bl19 = bl18 = d5 != 0.0 && !Double.isNaN(d5);
            }
            if (!bl18) {
                String string12 = this.mResources.getResString("ERR_POWER_ERROR");
                SpssAlertOptionPane.showWarningMessageDialog(this, string12, VersionInfo.getAppVersionString());
                this.reselect((JTextField)this.mPowerExponentEdit);
                return false;
            }
            if (!(!(d5 < 0.0) || bl13 && bl14 && bl15)) {
                String string13 = this.mResources.getResString("ERR_POWER_SCALE_ERROR");
                SpssAlertOptionPane.showWarningMessageDialog(this, string13, VersionInfo.getAppVersionString());
                this.reselect((JTextField)this.mPowerExponentEdit);
                return false;
            }
        }
        return true;
    }

    private void reselect(JTextField jTextField) {
        final JTextField jTextField2 = jTextField;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextField2.requestFocusInWindow();
                jTextField2.selectAll();
            }
        });
    }

    private void updateCheckBoxEditField(Object object) {
        if (object == this.mMinimumCheck) {
            boolean bl = this.mMinimumCheck.isSelected();
            this.mMinimumEdit.setEnabled(!bl);
            this.mMinimumEdit.setBackground(bl ? SystemColor.control : this.mEnabledColor);
        } else if (object == this.mMaximumCheck) {
            boolean bl = this.mMaximumCheck.isSelected();
            this.mMaximumEdit.setEnabled(!bl);
            this.mMaximumEdit.setBackground(bl ? SystemColor.control : this.mEnabledColor);
        } else if (object == this.mIncrementCheck) {
            boolean bl = this.mIncrementCheck.isSelected();
            this.mIncrementEdit.setEnabled(!bl);
            this.mIncrementEdit.setBackground(bl ? SystemColor.control : this.mEnabledColor);
        } else if (object == this.mOriginCheck) {
            boolean bl = this.mOriginCheck.isSelected();
            this.mOriginEdit.setEnabled(!bl);
            this.mOriginEdit.setBackground(bl ? SystemColor.control : this.mEnabledColor);
        }
    }

    private void updateScaleTypeFields() {
        boolean bl;
        boolean bl2;
        int n = this.mScaleTypeCombo.getSelectedIndex();
        if (n == 0) {
            bl2 = false;
            bl = false;
        } else if (n == 1 || n == 2) {
            bl2 = true;
            bl = false;
        } else if (n == 3) {
            bl2 = false;
            bl = true;
        } else {
            return;
        }
        this.mLogBaseLabel.setEnabled(bl2);
        this.mLogBaseEdit.setEnabled(bl2);
        this.mLogBaseEdit.setBackground(bl2 ? this.mEnabledColor : SystemColor.control);
        this.mPowerExponentLabel.setEnabled(bl);
        this.mPowerExponentEdit.setEnabled(bl);
        this.mPowerExponentEdit.setBackground(bl ? this.mEnabledColor : SystemColor.control);
    }

    void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(this.mResources.getResString("IDS_AXIS_LABEL"));
        jLabel.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_AXIS_LABEL_KEY"));
        Insets insets = new Insets(n2 + 4, n2 - 2, n2, 2);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mLabelEdit = new JTextField();
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.mLabelEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mLabelEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        } else {
            this.registerKeyListener(this.mLabelEdit);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n2 + 2, 2, n2, n2 - 2);
        DialogUtil.addUsingGBL(this, this.mLabelEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jLabel.setLabelFor(this.mLabelEdit);
        JPanel jPanel = this.buildScaleRangePanel();
        insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        JPanel jPanel2 = this.buildScaleTypePanel();
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 2, 2, 1, n, insets);
    }

    private JPanel buildScaleRangePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mResources.getResString("IDS_SCALE_RANGE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        this.mVarPromptLabel = new JLabel(this.mResources.getResString("IDS_VARIABLE"));
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mVarPromptLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mVarNameLabel = new JLabel();
        insets = new Insets(0, 1, n2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mVarNameLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.buildRangeCtrlsPanel();
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(0, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel buildRangeCtrlsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, n2, 2, 2);
        JLabel jLabel = new JLabel(this.mResources.getResString("IDS_AUTOMATIC"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.mResources.getResString("IDS_CUSTOM"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        CheckLabel checkLabel = new CheckLabel(this.mResources.getResString("IDS_MINIMUM"));
        checkLabel.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_MINIMUM_KEY"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, checkLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mMinimumCheck = new NoLabelCheckBox();
        insets = new Insets(0, n2, n2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mMinimumCheck, gridBagConstraints, 1, 1, 1, 1, 10, insets);
        checkLabel.setLabelFor(this.mMinimumCheck);
        this.mMinimumEdit = new FloatTextField(false);
        this.mMinimumEdit.setColumns(6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinimumEdit, gridBagConstraints, 2, 1, 1, 1, n, insets);
        this.mEnabledColor = this.mMinimumEdit.getBackground();
        CheckLabel checkLabel2 = new CheckLabel(this.mResources.getResString("IDS_MAXIMUM"));
        checkLabel2.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_MAXIMUM_KEY"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, checkLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mMaximumCheck = new NoLabelCheckBox();
        DialogUtil.addUsingGBL(jPanel, this.mMaximumCheck, gridBagConstraints, 1, 2, 1, 1, 10, insets);
        checkLabel2.setLabelFor(this.mMaximumCheck);
        this.mMaximumEdit = new FloatTextField(false);
        this.mMaximumEdit.setColumns(6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaximumEdit, gridBagConstraints, 2, 2, 1, 1, n, insets);
        CheckLabel checkLabel3 = new CheckLabel(this.mResources.getResString("IDS_MAJOR_INCREMENT"));
        checkLabel3.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_MAJOR_INCREMENT_KEY"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, checkLabel3, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mIncrementCheck = new NoLabelCheckBox();
        DialogUtil.addUsingGBL(jPanel, this.mIncrementCheck, gridBagConstraints, 1, 3, 1, 1, 10, insets);
        checkLabel3.setLabelFor(this.mIncrementCheck);
        this.mIncrementEdit = new FloatTextField(true);
        this.mIncrementEdit.setColumns(6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mIncrementEdit, gridBagConstraints, 2, 3, 1, 1, n, insets);
        CheckLabel checkLabel4 = new CheckLabel(this.mResources.getResString("IDS_ORIGIN"));
        checkLabel4.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_ORIGIN_KEY"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, checkLabel4, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.mOriginCheck = new NoLabelCheckBox();
        DialogUtil.addUsingGBL(jPanel, this.mOriginCheck, gridBagConstraints, 1, 4, 1, 1, 10, insets);
        checkLabel4.setLabelFor(this.mOriginCheck);
        this.mOriginEdit = new FloatTextField(false);
        this.mOriginEdit.setColumns(6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mOriginEdit, gridBagConstraints, 2, 4, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel buildScaleTypePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mResources.getResString("IDS_SCALE_TYPE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, n2 * 5, n2, n2 + 2);
        JLabel jLabel = new JLabel(this.mResources.getResString("IDS_TYPE"));
        jLabel.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_TYPE_KEY"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        String[] stringArray = new String[]{this.mResources.getResString("IDS_LINEAR"), this.mResources.getResString("IDS_LOG"), this.mResources.getResString("IDS_SAFE_LOG"), this.mResources.getResString("IDS_POWER")};
        this.mScaleTypeCombo = new JComboBox<String>(stringArray);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mScaleTypeCombo, gridBagConstraints, 1, 0, 2, 1, n, insets);
        jLabel.setLabelFor(this.mScaleTypeCombo);
        this.mScaleTypeCombo.setEditable(false);
        this.mLogBaseLabel = new JLabel(this.mResources.getResString("IDS_BASE"));
        this.mLogBaseLabel.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_BASE_KEY"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLogBaseLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.mLogBaseEdit = new FloatTextField(10);
        this.mLogBaseEdit.setColumns(6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLogBaseEdit, gridBagConstraints, 2, 1, 1, 1, n, insets);
        this.mLogBaseLabel.setLabelFor((Component)this.mLogBaseEdit);
        this.mPowerExponentLabel = new JLabel(this.mResources.getResString("IDS_EXPONENT"));
        this.mPowerExponentLabel.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_EXPONENT_KEY"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mPowerExponentLabel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.mPowerExponentEdit = new FloatTextField(false);
        this.mPowerExponentEdit.setColumns(6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPowerExponentEdit, gridBagConstraints, 2, 2, 1, 1, n, insets);
        this.mPowerExponentLabel.setLabelFor((Component)this.mPowerExponentEdit);
        return jPanel;
    }

    class CheckLabel
    extends JLabel {
        public CheckLabel(String string) {
            super(string);
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            Component component;
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            if (bl2 && !bl && (component = this.getLabelFor()) instanceof JCheckBox) {
                JCheckBox jCheckBox;
                jCheckBox.setSelected(!(jCheckBox = (JCheckBox)component).isSelected());
            }
            return bl2;
        }
    }

    public static class NoLabelCheckBox
    extends JCheckBox {
        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.paintFocus(this, graphics);
        }

        private void paintFocus(JComponent jComponent, Graphics graphics) {
            if (jComponent.hasFocus()) {
                Rectangle rectangle = graphics.getClipBounds();
                rectangle.x -= 2;
                rectangle.width += 3;
                BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

