/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.StatisticsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class SSVStatsPanel
extends StatisticsPanel {
    private JComboBox mDepVarsCombo;
    private DefaultComboBoxModel mComboModel;

    public SSVStatsPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.mElProp = null;
        this.mDepVarsCombo.addActionListener(this);
    }

    public Statistics getLCDStat() {
        Statistics statistics = Statistics.Mean;
        for (int i = 0; i < this.mComboModel.getSize(); ++i) {
            ComboItem comboItem = (ComboItem)this.mComboModel.getElementAt(i);
            Statistics statistics2 = comboItem.getElStat().getStat();
            if (statistics == Statistics.Mean) {
                if (statistics2 == Statistics.Mean) continue;
                statistics = statistics2;
                continue;
            }
            if (statistics != Statistics.Count && statistics != Statistics.Median && statistics != Statistics.PctOfCases || statistics2 == Statistics.Mean || statistics2 == Statistics.Count || statistics2 == Statistics.Median || statistics2 == Statistics.PctOfCases) continue;
            statistics = statistics2;
            break;
        }
        return statistics;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        int n = this.mStatsList.getSelectedIndex();
        if (n > -1 && !this.checkStatistics()) {
            return;
        }
        ComboItem comboItem = (ComboItem)this.mDepVarsCombo.getSelectedItem();
        if (actionEvent.getSource() == this.mDepVarsCombo) {
            this.mWorkStat = comboItem.getElStat();
            this.mInReload = true;
            this.selectStat(this.mWorkStat.getStat());
            this.mParametersButton.setEnabled(this.parameterCount(this.mWorkStat.getStat()) > 0);
            super.updateCurrentStatisticParms();
            this.mInReload = false;
        } else {
            super.actionPerformed(actionEvent);
            comboItem.getElStat().setStrParm1(this.mWorkStat.getStrParm1());
            comboItem.getElStat().setStrParm2(this.mWorkStat.getStrParm2());
            comboItem.getElStat().setPctBaseType(this.mWorkStat.getPctBaseType());
            this.updateCurrentVarStat();
        }
    }

    @Override
    void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mDepVarsCombo);
        super.addTabTraversalComponents(vector);
    }

    @Override
    void updateCurrentStatisticParms() {
        super.updateCurrentStatisticParms();
        ComboItem comboItem = (ComboItem)this.mDepVarsCombo.getSelectedItem();
        comboItem.getElStat().setStrParm1(this.mWorkStat.getStrParm1());
        comboItem.getElStat().setStrParm2(this.mWorkStat.getStrParm2());
        comboItem.getElStat().setPctBaseType(this.mWorkStat.getPctBaseType());
        this.updateCurrentVarStat();
    }

    @Override
    void initialize(ChartProps chartProps, Props.ElProps elProps) {
        this.mInReload = true;
        this.mElProp = elProps;
        this.enableControls(true);
        int n = this.mDepVarsCombo.getSelectedIndex();
        this.mParameters.clear();
        this.mVarPrompt.setEnabled(true);
        this.mDepVarsCombo.removeAllItems();
        this.loadStatsList(chartProps);
        Props.SSVData sSVData = this.mElProp.getSSVData();
        int n2 = 0;
        for (ElementStat object : sSVData.getSSVVariables()) {
            String string = object.getVariable().getName() + ": " + object.getStat().getUserString(this.mCanvas.getResources());
            this.mComboModel.addElement(new ComboItem(string, object));
            this.mDepVarsCombo.setSelectedIndex(n2++);
            this.mWorkStat = object;
            this.selectStat(object.getStat());
            this.updateCurrentStatisticParms();
        }
        if (n < 0 || n >= this.mComboModel.getSize()) {
            n = 0;
        }
        if (this.mComboModel.getSize() > n) {
            this.mDepVarsCombo.setSelectedIndex(n);
            ComboItem comboItem = (ComboItem)this.mComboModel.getElementAt(n);
            this.mWorkStat = comboItem.getElStat();
            Statistics statistics = this.mWorkStat.getStat();
            this.selectStat(statistics);
            this.updateCurrentStatisticParms();
            this.mParametersButton.setEnabled(this.parameterCount(statistics) > 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SSVStatsPanel.this.fireStatChange();
                }
            });
        }
        this.mInReload = false;
    }

    boolean canApply() {
        for (int i = 0; i < this.mComboModel.getSize(); ++i) {
            ComboItem comboItem = (ComboItem)this.mComboModel.getElementAt(i);
            ElementStat elementStat = comboItem.getElStat();
            int n = this.parameterCount(elementStat.getStat());
            if (n > 0 && elementStat.getStrParm1().length() == 0) {
                return false;
            }
            if (n <= 1 || elementStat.getStrParm2().length() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean applyChanges() {
        Props.SSVData sSVData = this.mElProp.getSSVData();
        Vector<ElementStat> vector = sSVData.getSSVVariables();
        vector.clear();
        for (int i = 0; i < this.mComboModel.getSize(); ++i) {
            ComboItem comboItem = (ComboItem)this.mComboModel.getElementAt(i);
            vector.add(comboItem.getElStat());
        }
        this.mElProp.setModified(true);
        return true;
    }

    boolean checkStatistics() {
        ComboItem comboItem;
        int n;
        int n2 = this.mDepVarsCombo.getSelectedIndex();
        StatisticsPanel.StatItem statItem = (StatisticsPanel.StatItem)this.mStatsList.getModel().getSelectedItem();
        boolean bl = false;
        boolean bl2 = statItem.getStat() == Statistics.CumSum;
        for (n = 0; n < this.mComboModel.getSize(); ++n) {
            boolean bl3;
            if (n == n2) continue;
            comboItem = (ComboItem)this.mComboModel.getElementAt(n);
            Statistics statistics = comboItem.getElStat().getStat();
            boolean bl4 = bl3 = statistics == Statistics.CumSum;
            if (bl3 == bl2) continue;
            bl = true;
            break;
        }
        if (bl) {
            n = SpssAlertOptionPane.showConfirmDialog(this, this.mCanvas.getResources().getResString("ERR_SSV_STAT_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n != 0) {
                this.selectStat(this.mWorkStat.getStat());
                return false;
            }
            Statistics statistics = statItem.getStat();
            for (int i = 0; i < this.mComboModel.getSize(); ++i) {
                if (i == n2) continue;
                comboItem = (ComboItem)this.mComboModel.getElementAt(i);
                comboItem.getElStat().setStat(statistics);
                comboItem.getElStat().setStrParm1("");
                comboItem.getElStat().setStrParm2("");
                comboItem.getElStat().setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
                String string = comboItem.getElStat().getVariable().getName() + ": " + statItem.toString();
                comboItem.setName(string);
            }
        }
        return true;
    }

    private void updateCurrentVarStat() {
        ComboItem comboItem = (ComboItem)this.mDepVarsCombo.getSelectedItem();
        StatisticsPanel.StatItem statItem = (StatisticsPanel.StatItem)this.mStatsList.getModel().getSelectedItem();
        if (statItem == null) {
            return;
        }
        ElementStat elementStat = comboItem.getElStat();
        elementStat.setStat(statItem.getStat());
        String string = null;
        string = elementStat.getVariable().getName() != null && elementStat.getVariable().getName().length() > 0 && statItem.toString() != null && statItem.toString().length() > 0 ? (ComponentState.isBtdRtlOrLtr() ? (ComponentState.getBTD() == 1 ? Character.toString('\u200e') + '\u200f' + elementStat.getVariable().getName() + '\u202c' + '\u200f' + ": " + statItem.toString() : '\u200e' + elementStat.getVariable().getName() + '\u200e' + ": " + '\u200e' + statItem.toString()) : (ComponentState.isBidiLetter((char)elementStat.getVariable().getName().charAt(0)) || elementStat.getVariable().getName().charAt(0) == '\u05b9' ? Character.toString('\u200e') + '\u200f' + elementStat.getVariable().getName() + '\u202c' + ": " + statItem.toString() : '\u200e' + elementStat.getVariable().getName() + '\u200e' + ": " + '\u200e' + statItem.toString())) : elementStat.getVariable().getName() + ": " + statItem.toString();
        comboItem.setName(string);
        this.mDepVarsCombo.repaint();
    }

    @Override
    protected void initControls() {
        this.setBorder(BorderFactory.createTitledBorder(this.mCanvas.getResources().getResString("IDS_STATISTICS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        this.mVarPrompt = new JLabel(this.mCanvas.getResources().getResString("IDS_VARIABLES"));
        this.mVarPrompt.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_VARIABLE_KEY"));
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mVarPrompt, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mComboModel = new DefaultComboBoxModel();
        this.mDepVarsCombo = new JComboBox(this.mComboModel);
        insets = new Insets(0, 1, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mDepVarsCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mVarPrompt.setLabelFor(this.mDepVarsCombo);
        this.mStatLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_STATISTIC_COLON"));
        this.mStatLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_STATISTIC_COLON_KEY"));
        insets = new Insets(0, n2, 1, n2);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mStatLabel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mStatsList = new JComboBox();
        insets = new Insets(0, n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mStatsList, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.mStatLabel.setLabelFor(this.mStatsList);
        this.mParametersButton = new JButton(new StatisticsPanel.SetParmsAction(this));
        insets = new Insets(0, n2, n2, n2);
        n = 26;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mParametersButton, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.mParametersButton.setMargin(new Insets(0, 6, 0, 6));
    }

    class ComboItem {
        private ElementStat mElStat;
        private String mName;

        public ComboItem(String string, ElementStat elementStat) {
            this.mName = string;
            this.mElStat = elementStat;
        }

        public ElementStat getElStat() {
            return this.mElStat;
        }

        public void setName(String string) {
            this.mName = string;
        }

        public String toString() {
            return this.mName;
        }
    }
}

