/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneChangeType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SSVQueryDlg
extends BaseSubDialog {
    private JList mCatsList;

    public SSVQueryDlg(BaseProcedureDialog baseProcedureDialog, ZoneType zoneType) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_CREATE_SSV_TITLE"), true);
        this.loadVariables(baseProcedureDialog, zoneType);
        this.renameContinueAction("IDS_OK");
        this.pack();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    public static boolean runDialog(BaseProcedureDialog baseProcedureDialog, ZoneType zoneType, ISpssVariable[] iSpssVariableArray) {
        SSVQueryDlg sSVQueryDlg = new SSVQueryDlg(baseProcedureDialog, zoneType);
        sSVQueryDlg.setVisible(true);
        boolean bl = sSVQueryDlg.wasContinuePressed();
        if (bl) {
            SSVQueryDlg.addIndexVariable(baseProcedureDialog);
            SSVQueryDlg.setupSSVStats(baseProcedureDialog, zoneType, iSpssVariableArray);
        } else {
            SSVQueryDlg.removeVariables(baseProcedureDialog, zoneType, iSpssVariableArray);
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idc_cg_help_ssv_intro";
    }

    @Override
    protected void init() {
        super.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JLabel jLabel = new JLabel();
        URL uRL = this.getResImageURL("IDI_SSV_PREVIEW");
        jLabel.setIcon(new ImageIcon(uRL));
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(3, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel, gridBagConstraints, 0, 0, 1, 4, n, insets);
        jLabel.setBorder(BorderFactory.createBevelBorder(1));
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_SSV_INFO"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets = new Insets(3, n2, n2, n2);
        DialogUtil.addUsingGBL(this.getViewPanel(), jTextArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        int n3 = Toolkit.getDefaultToolkit().getScreenResolution();
        int n4 = n3 > 100 ? 40 : 0;
        jTextArea.setMinimumSize(new Dimension(340, 140 + n4));
        jTextArea.setPreferredSize(new Dimension(340, 140 + n4));
        JLabel jLabel2 = new JLabel(this.getResString("IDS_INDEX_PROMPT"));
        gridBagConstraints.fill = 2;
        insets = new Insets(n2, n2, 1, n2);
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel2, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.mCatsList = new JList();
        this.mCatsList.setModel(new DefaultListModel());
        JScrollPane jScrollPane = new JScrollPane(this.mCatsList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets = new Insets(0, n2, n2, n2);
        DialogUtil.addUsingGBL(this.getViewPanel(), jScrollPane, gridBagConstraints, 1, 3, 1, 1, n, insets);
        jScrollPane.setMinimumSize(new Dimension(290, 70));
        jScrollPane.setPreferredSize(new Dimension(290, 70));
    }

    private void loadVariables(BaseProcedureDialog baseProcedureDialog, ZoneType zoneType) {
        DropZone dropZone = ((ChartBuilderDlg)baseProcedureDialog).getCanvas().getZoneMgr().getZone(zoneType);
        Vector<ISpssVariable> vector = dropZone.getVariables();
        DefaultListModel defaultListModel = (DefaultListModel)this.mCatsList.getModel();
        for (ISpssVariable iSpssVariable : vector) {
            char c;
            if (ComponentState.isBtdRtlOrLtr()) {
                if (ComponentState.getBTD() == 1) {
                    defaultListModel.addElement(iSpssVariable.getLabel().length() > 0 ? '\u200f' + iSpssVariable.getLabel() : '\u200f' + iSpssVariable.getName());
                    continue;
                }
                defaultListModel.addElement(iSpssVariable.getLabel().length() > 0 ? '\u200e' + iSpssVariable.getLabel() : '\u200e' + iSpssVariable.getName());
                continue;
            }
            char c2 = c = iSpssVariable.getLabel().length() > 0 ? iSpssVariable.getLabel().charAt(0) : iSpssVariable.getName().charAt(0);
            if (ComponentState.isBidiLetter((char)c) || c == '\u05b9') {
                defaultListModel.addElement(iSpssVariable.getLabel().length() > 0 ? '\u200f' + iSpssVariable.getLabel() : '\u200f' + iSpssVariable.getName());
                continue;
            }
            defaultListModel.addElement(iSpssVariable.getLabel().length() > 0 ? '\u200e' + iSpssVariable.getLabel() : '\u200e' + iSpssVariable.getName());
        }
    }

    private static void addIndexVariable(BaseProcedureDialog baseProcedureDialog) {
        Object object;
        ChartCanvas chartCanvas = ((ChartBuilderDlg)baseProcedureDialog).getCanvas();
        DropZone dropZone = chartCanvas.getZoneMgr().getZone(ZoneType.zt_x);
        if (dropZone != null && chartCanvas.getZoneMgr().hasScaleVar(ZoneType.zt_x)) {
            dropZone.clear();
        }
        if (dropZone == null || !dropZone.isEmpty()) {
            dropZone = chartCanvas.getZoneMgr().getZone(ZoneType.zt_cluster_x);
        }
        if (dropZone == null) {
            dropZone = chartCanvas.getZoneMgr().getZone(ZoneType.zt_group);
        }
        if (dropZone == null) {
            dropZone = chartCanvas.getZoneMgr().getZone(ZoneType.zt_slice_by);
        }
        if (dropZone == null) {
            object = chartCanvas.getNewGroupingZoneType();
            chartCanvas.addZone((ZoneType)((Object)object));
            dropZone = chartCanvas.getZoneMgr().getZone((ZoneType)((Object)object));
            dropZone.setBounds(chartCanvas);
        }
        object = DropZone.constructIndexVariable();
        DropZone.updateIndexValueLabelMap(chartCanvas, object);
        dropZone.clear();
        dropZone.dropVars(new ISpssVariable[]{object});
        chartCanvas.getImager().zoneChange(chartCanvas.getZoneMgr(), dropZone.getZoneType(), ZoneChangeType.addVariable);
    }

    private static void removeVariables(BaseProcedureDialog baseProcedureDialog, ZoneType zoneType, ISpssVariable[] iSpssVariableArray) {
        ChartCanvas chartCanvas = ((ChartBuilderDlg)baseProcedureDialog).getCanvas();
        DropZone dropZone = chartCanvas.getZoneMgr().getZone(zoneType);
        Vector<ISpssVariable> vector = dropZone.getVariables();
        Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
        for (ISpssVariable object2 : vector) {
            boolean bl = false;
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (!object2.getName().equals(iSpssVariable.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector2.add(object2);
        }
        dropZone.clear();
        ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[vector2.size()];
        dropZone.dropVars(vector2.toArray(iSpssVariableArray2));
        Rectangle rectangle = dropZone.getBounds().getBounds();
        rectangle.grow(2, 2);
        chartCanvas.repaint(rectangle);
    }

    private static void setupSSVStats(BaseProcedureDialog baseProcedureDialog, ZoneType zoneType, ISpssVariable[] iSpssVariableArray) {
        ElementStat elementStat;
        ChartCanvas chartCanvas = ((ChartBuilderDlg)baseProcedureDialog).getCanvas();
        ChartProps chartProps = chartCanvas.getProperties();
        Props.ElProps elProps = chartProps.getElementProp(0);
        if (elProps == null) {
            elProps = chartCanvas.getImager().getDefaultDataProp();
            chartProps.addProp(elProps);
        }
        if (elProps == null) {
            return;
        }
        Statistics statistics = ((ChartBuilderDlg)baseProcedureDialog).getCanvas().getImager().getPrimaryStatistic();
        if (!chartCanvas.legalStat(chartProps, statistics, 0)) {
            statistics = chartCanvas.getDefaultStatistic(chartProps);
        }
        DropZone dropZone = chartCanvas.getZoneMgr().getZone(zoneType);
        Vector<ElementStat> vector = elProps.getSSVData().getSSVVariables();
        Vector<ISpssVariable> vector2 = dropZone.getVariables();
        int n = vector2.size() - iSpssVariableArray.length;
        for (int i = 0; i < n; ++i) {
            elementStat = new ElementStat(elProps);
            elementStat.setStat(statistics);
            elementStat.setVariable(vector2.get(i));
            vector.add(elementStat);
        }
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            elementStat = new ElementStat(elProps);
            elementStat.setStat(statistics);
            elementStat.setVariable(iSpssVariable);
            vector.add(elementStat);
        }
        elProps.setModified(true);
        chartCanvas.setProperties(chartProps);
    }
}

