/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ErrorBarsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.SSVStatsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;

public class SSVElementPanel
extends ElementPanel {
    public SSVElementPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
    }

    @Override
    public String getPanelId() {
        return "ssv_element_panel";
    }

    @Override
    public void statisticChanged(Statistics statistics) {
        if (this.mErrorBarsPanel != null) {
            this.mErrorBarsPanel.statChanged(((SSVStatsPanel)this.mStatsPanel).getLCDStat());
        }
        if (this.mStylePanel != null) {
            this.mStylePanel.statChanged(statistics);
        }
    }

    @Override
    boolean canApply() {
        return ((SSVStatsPanel)this.mStatsPanel).canApply();
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        this.mStatsPanel.addTabTraversalComponents(vector);
        this.mErrorBarsPanel.addTabTraversalComponents(vector);
        if (this.mStylePanel != null) {
            this.mStylePanel.addTabTraversalComponents(vector);
        }
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        super.initialize(chartProps, props);
        this.mErrorBarsPanel.enableAllControls(chartProps.getCoords() != Coords.coords_Polar);
    }

    @Override
    protected void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mStatsPanel = new SSVStatsPanel(this.mCanvas, this.mModListener);
        DialogUtil.addUsingGBL(this, this.mStatsPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mErrorBarsPanel = new ErrorBarsPanel(this.mCanvas, this.mModListener);
        gridBagConstraints.weighty = 0.1;
        DialogUtil.addUsingGBL(this, this.mErrorBarsPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }
}

