/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.UpDownListWidget;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.CategoricalAxisPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.RelabelBag;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.font.TextAttribute;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SSVAxisPanel
extends CategoricalAxisPanel {
    public SSVAxisPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
    }

    @Override
    public String getPanelId() {
        return "ssv_axis_panel";
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mLabelEdit);
        this.mOrderPanel.addTabTraversalComponents(vector);
    }

    @Override
    void addDragAdapters() {
    }

    @Override
    void addListeners() {
        this.mLabelEdit.getDocument().addDocumentListener(this);
        this.mOrderPanel.addListListener(this);
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        if (props instanceof Props.CatAxisProps && ((Props.CatAxisProps)props).getZoneType() == this.mCanvas.getZoneMgr().getIndexVarZoneType()) {
            this.mInReload = true;
            this.mProp = (Props.CatAxisProps)props;
            this.mLabelEdit.setText(this.mProp.getStrLabel());
            this.mOrderPanel.clear();
            this.mOrderPanel.enableWidget(true);
            boolean bl = this.mCanvas.getShowVarLabels();
            Props.SSVData sSVData = this.getParentDialog().getSidePropertiesPanel().getElementSSVs();
            for (ElementStat elementStat : sSVData.getSSVVariables()) {
                String string = bl ? elementStat.getVarLabel() : elementStat.getVarName();
                this.mOrderPanel.addListItem(string, elementStat);
            }
            if (this.mOrderPanel.getList().getModel().getSize() > 0) {
                this.mOrderPanel.setSelectedItem(0);
            }
            this.mInReload = false;
        }
    }

    @Override
    boolean applyChanges() {
        this.mProp.setStrLabel(this.mLabelEdit.getText());
        Props.SSVData sSVData = this.getParentDialog().getSidePropertiesPanel().getElementSSVs();
        Vector<ElementStat> vector = sSVData.getSSVVariables();
        vector.clear();
        Vector<RelabelBag> vector2 = this.mProp.getCategories();
        Vector<RelabelBag> vector3 = new Vector<RelabelBag>();
        Vector<UpDownListWidget.ListItem> vector4 = this.mOrderPanel.getListItems();
        for (UpDownListWidget.ListItem listItem : vector4) {
            ElementStat elementStat = (ElementStat)listItem.getUserObject();
            vector.add(elementStat);
            RelabelBag relabelBag = this.getBag(elementStat, vector2);
            vector3.add(relabelBag);
        }
        vector2.clear();
        vector2.addAll(vector3);
        this.mProp.setModified(true);
        Props.ElProps elProps = this.getParentDialog().getSidePropertiesPanel().getPrimaryElementProp();
        if (elProps != null) {
            elProps.setModified(true);
        }
        return true;
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        Point point = this.mVarNameLabel.getBounds().getLocation();
        Point point2 = SwingUtilities.convertPoint(this.mVarNameLabel.getParent(), point, this);
        graphics.setFont(this.mVarNameLabel.getFont());
        graphics.drawString("*", point2.x + 13, point2.y + 11);
    }

    @Override
    public void listItemChanged(UpDownListWidget.ListChangeType listChangeType, Vector<Object> vector) {
        if (this.mInReload) {
            return;
        }
        if (listChangeType == UpDownListWidget.ListChangeType.itemDeleted) {
            String string;
            int n;
            PlainList plainList = this.mOrderPanel.getList();
            int n2 = plainList.getModel().getSize();
            if (n2 > 0) {
                String string2;
                String string3 = this.mResources.getResString("ERR_DELETE_SSV_VAR_MSG");
                String string4 = String.format(string3, string2 = this.mCanvas.getImager().getCoordinates() == Coords.coords_Polar ? this.mResources.getResString("IDS_ANGLE") : "Y");
                int n3 = SpssAlertOptionPane.showConfirmDialog(this, string4, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                if (n3 != 0) {
                    this.replaceListObjects(vector);
                    return;
                }
            } else if (n2 == 0 && (n = SpssAlertOptionPane.showConfirmDialog(this, string = this.mResources.getResString("ERR_SSV_REMOVE_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) != 0) {
                this.replaceListObjects(vector);
                return;
            }
        }
        this.mModListener.itemModified();
    }

    @Override
    void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(this.getAxisLabelPrompt());
        Insets insets = new Insets(n2 + 4, 3, n2, 2);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mLabelEdit = new JTextField();
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.mLabelEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mLabelEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n2 + 2, 0, n2, 2);
        DialogUtil.addUsingGBL(this, this.mLabelEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jLabel.setLabelFor(this.mLabelEdit);
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mResources.getResString("IDS_CATEGORIES")));
        insets = new Insets(2, 2, n2, 2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mVarPromptLabel = new JLabel(this.mResources.getResString("IDS_VARIABLE"));
        insets = new Insets(n2, n2 + 3, n2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mVarPromptLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mVarNameLabel = new JLabel();
        insets = new Insets(n2, 1, n2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mVarNameLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mOrderPanel = new UpDownListWidget(this.mResources.getResString("IDS_ORDER"), this.mResources.getDlgAccessKey("IDK_ORDER_KEY"));
        insets = new Insets(n2, n2, n2, n2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mOrderPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        String string = this.mResources.getResString("IDS_INDEX");
        this.mVarPromptLabel.setEnabled(true);
        this.mVarNameLabel.setEnabled(true);
        String string2 = ResUtil.getCommonDlgString("IDS_NOMINAL_STRING_VAR_IMAGE");
        URL uRL = ResUtil.getCommonDlgImageResource(string2);
        this.mVarNameLabel.setIcon(new ImageIcon(uRL));
        if (ComponentState.isBtdRtlOrLtr()) {
            this.mVarNameLabel.setText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            this.mVarNameLabel.setText(string);
        }
        this.mVarNameLabel.setToolTipText(string);
    }

    private void replaceListObjects(Vector<Object> vector) {
        this.mOrderPanel.getList().clearSelection();
        boolean bl = this.mCanvas.getShowVarLabels();
        for (Object object : vector) {
            if (!(object instanceof ElementStat)) continue;
            ElementStat elementStat = (ElementStat)object;
            String string = bl ? elementStat.getVarLabel() : elementStat.getVarName();
            int n = this.mOrderPanel.getList().getModel().getSize();
            this.mOrderPanel.addListItem(string, elementStat);
            this.mOrderPanel.getList().addSelectionInterval(n, n);
        }
        if (this.mOrderPanel.getList().getSelectedIndex() < 0) {
            this.mOrderPanel.getList().setSelectedIndex(0);
        }
    }

    private RelabelBag getBag(ElementStat elementStat, Vector<RelabelBag> vector) {
        boolean bl = this.mCanvas.getShowVarLabels();
        for (RelabelBag relabelBag : vector) {
            ISpssVariable iSpssVariable = elementStat.getVariable();
            String string = bl && iSpssVariable.getLabel().length() > 0 ? iSpssVariable.getLabel() : iSpssVariable.getName();
            if (!string.equals(relabelBag.getStrTo())) continue;
            return relabelBag;
        }
        return null;
    }
}

