/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BinningPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PyramidPanel
extends ElementPanel
implements DocumentListener {
    private JLabel mScaleLabel;
    private BinningPanel mBinningPanel;
    private JLabel mCatLabel;
    private JCheckBox mErrorBarsCheck;
    private JLabel mConfIntLabel;
    private FloatTextField mConfIntEdit;
    private Props.PyramidProps mElProp;

    public PyramidPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.mErrorBarsCheck.addActionListener(this);
        this.mConfIntEdit.getDocument().addDocumentListener(this);
        this.mConfIntEdit.addFocusListener((FocusListener)this);
    }

    @Override
    public String getPanelId() {
        return "pyramid_panel";
    }

    @Override
    protected boolean canSwitchTab() {
        return this.mBinningPanel.canSwitchTab();
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mNormalCurveCheck);
        this.mBinningPanel.addTabTraversalComponents(vector);
        vector.add(this.mErrorBarsCheck);
        vector.add(this.mConfIntEdit);
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        this.mInReload = true;
        if (props instanceof Props.PyramidProps) {
            int n;
            this.mElProp = (Props.PyramidProps)props;
            ElementStat elementStat = this.mElProp.getStatistic();
            ElementStat elementStat2 = new ElementStat(this.mElProp);
            this.copyStat(elementStat2, elementStat);
            this.mBinningPanel.initialize(elementStat2);
            this.enableScaleCatControls();
            if (this.mNormalCurveCheck.isEnabled()) {
                this.mNormalCurveCheck.setSelected(this.mElProp.getStatistic().getDisplayNormalCurve());
            }
            this.mErrorBarsCheck.setSelected(((n = this.mElProp.getFlags()) & 0x10) != 0);
            this.mConfIntEdit.setText(DialogUtil.formatDouble(this.mElProp.getLevel()));
            if (this.mErrorBarsCheck.isEnabled()) {
                this.enableErrorBarControls(false, this.mErrorBarsCheck.isSelected());
            } else {
                this.enableErrorBarControls(false, false);
            }
        }
        this.mInReload = false;
    }

    @Override
    boolean applyChanges() {
        if (!this.validateContent()) {
            return false;
        }
        boolean bl = true;
        if (this.mNormalCurveCheck.isEnabled()) {
            bl = this.mBinningPanel.applyChanges();
            if (!bl) {
                return false;
            }
            ElementStat elementStat = this.mBinningPanel.getStatistic();
            ElementStat elementStat2 = this.mElProp.getStatistic();
            this.copyStat(elementStat2, elementStat);
            elementStat2.setAnchorType(elementStat.getAnchorType());
            elementStat2.setBinSize(elementStat.getBinSize());
            elementStat2.setBinSizeCustom(elementStat.getBinSizeCustom());
            this.mElProp.setAnchorCustVal(elementStat.getStrParm1());
            if (elementStat.getBinSizeCustom() == 0) {
                this.mElProp.setNoOfIntervals(elementStat.getStrParm2());
            } else {
                this.mElProp.setIntervalWidth(elementStat.getStrParm2());
            }
            this.mElProp.getStatistic().setDisplayNormalCurve(this.mNormalCurveCheck.isSelected());
        } else if (this.mErrorBarsCheck.isEnabled()) {
            int n = this.mElProp.getFlags();
            n = this.mErrorBarsCheck.isSelected() ? n | 0x10 : n & 0xFFFFFFEF;
            this.mElProp.setFlags(n);
            String string = this.mConfIntEdit.getText();
            double d = Double.valueOf(string);
            this.mElProp.setLevel(d);
        }
        this.mIsEditFieldDirty = false;
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.mErrorBarsCheck) {
            this.enableErrorBarControls(false, this.mErrorBarsCheck.isSelected());
            this.mModListener.itemModified();
        }
    }

    private void copyStat(ElementStat elementStat, ElementStat elementStat2) {
        elementStat.setVariable(elementStat2.getVariable());
        elementStat.setAnchorType(elementStat2.getAnchorType());
        elementStat.setBinSize(elementStat2.getBinSize());
        elementStat.setBinSizeCustom(elementStat2.getBinSizeCustom());
        elementStat.setStrParm1(this.mElProp.getAnchorCustVal());
        elementStat.setStrParm2(elementStat2.getBinSizeCustom() == 0 ? this.mElProp.getNoOfIntervals() : this.mElProp.getIntervalWidth());
    }

    @Override
    protected void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, 2, n);
        int n2 = 23;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mScaleLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_SCALE_VAR_OPTS"));
        DialogUtil.addUsingGBL(this, this.mScaleLabel, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        Insets insets2 = new Insets(n, n, n, n);
        this.mNormalCurveCheck = new JCheckBox(this.mCanvas.getResources().getResString("IDS_SHOW_NORMAL_CURVE"));
        this.mNormalCurveCheck.setMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_SHOW_NORMAL_CURVE_KEY"));
        DialogUtil.addUsingGBL(this, this.mNormalCurveCheck, gridBagConstraints, 0, 1, 2, 1, n2, insets2);
        this.mBinningPanel = new BinningPanel(this.mCanvas, this.mModListener);
        Insets insets3 = new Insets(0, 0, n, 0);
        DialogUtil.addUsingGBL(this, this.mBinningPanel, gridBagConstraints, 0, 2, 2, 1, n2, insets3);
        this.mCatLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_CAT_VAR_OPTS"));
        DialogUtil.addUsingGBL(this, this.mCatLabel, gridBagConstraints, 0, 3, 2, 1, n2, insets2);
        this.mErrorBarsCheck = new JCheckBox(new ShowErrorBarsAction());
        insets2 = new Insets(2, n, 2, n);
        DialogUtil.addUsingGBL(this, this.mErrorBarsCheck, gridBagConstraints, 0, 4, 2, 1, n2, insets2);
        this.mConfIntLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_CONF_INT_LEVEL"));
        this.mConfIntLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_CONF_INT_LEVEL_KEY"));
        insets2 = new Insets(0, n * 4, 0, n);
        DialogUtil.addUsingGBL(this, this.mConfIntLabel, gridBagConstraints, 0, 5, 1, 1, n2, insets2);
        this.mConfIntEdit = new FloatTextField(true);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        insets2 = new Insets(2, n * 4, 0, n);
        DialogUtil.addUsingGBL(this, (JComponent)this.mConfIntEdit, gridBagConstraints, 0, 6, 1, 1, n2, insets2);
        this.mConfIntEdit.setColumns(6);
    }

    private void enableScaleCatControls() {
        ISpssVariable iSpssVariable = this.mElProp.getStatistic().getVariable();
        boolean bl = iSpssVariable == null || iSpssVariable.getDisplayMeasurementLevel() == MeasurementLevel.scale;
        this.mScaleLabel.setEnabled(bl);
        this.mNormalCurveCheck.setEnabled(bl);
        this.mBinningPanel.setEnabled(bl);
        this.mCatLabel.setEnabled(!bl);
        this.enableErrorBarControls(true, !bl);
    }

    private void enableErrorBarControls(boolean bl, boolean bl2) {
        if (bl) {
            this.mErrorBarsCheck.setEnabled(bl2);
        }
        this.mConfIntLabel.setEnabled(bl2);
        this.mConfIntEdit.setEnabled(bl2);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.mInReload) {
            this.mIsEditFieldDirty = true;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.mInReload) {
            this.mIsEditFieldDirty = true;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this.mInReload) {
            this.mIsEditFieldDirty = true;
        }
    }

    private boolean validateContent() {
        if (!this.mErrorBarsCheck.isSelected()) {
            return true;
        }
        boolean bl = true;
        FloatTextField floatTextField = null;
        String string = this.mConfIntEdit.getText();
        Double d = string != null && string.length() > 0 ? Double.valueOf(string) : -1.0;
        if (d < 50.0 || d > 99.9) {
            bl = false;
            floatTextField = this.mConfIntEdit;
        }
        if (!bl) {
            SpssAlertOptionPane.showInformationMessageDialog(this, ResUtil.getCommonDlgString("ERR_OUT_OF_RANGE_ERROR_MSG"), VersionInfo.getAppVersionString());
            final FloatTextField floatTextField2 = floatTextField;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    floatTextField2.requestFocusInWindow();
                    floatTextField2.selectAll();
                }
            });
        }
        return bl;
    }

    class ShowErrorBarsAction
    extends AbstractAction {
        ShowErrorBarsAction() {
            this.putValue("Name", PyramidPanel.this.mCanvas.getResources().getResString("IDS_SHOW_ERROR_BARS"));
            this.putValue("MnemonicKey", PyramidPanel.this.mCanvas.getResources().getDlgAccessKey("IDK_SHOW_ERROR_BARS_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyramidPanel.this.enableErrorBarControls(false, PyramidPanel.this.mErrorBarsCheck.isSelected());
            if (!PyramidPanel.this.mInReload) {
                PyramidPanel.this.mModListener.itemModified();
            }
        }
    }
}

