/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public abstract class PropertiesPanel
extends JPanel
implements IPropEnum,
FocusListener {
    protected ChartCanvas mCanvas;
    protected ChartBuilderDlg mParentDlg;
    protected IModListener mModListener;
    protected boolean mIsEditFieldDirty = false;

    public PropertiesPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(new GridBagLayout(), true);
        this.mCanvas = chartCanvas;
        this.mModListener = iModListener;
    }

    protected boolean canSwitchTab() {
        return true;
    }

    void setParentDlg(ChartBuilderDlg chartBuilderDlg) {
        this.mParentDlg = chartBuilderDlg;
    }

    void fireSetModifiedEvent() {
        if (this.mModListener != null) {
            this.mModListener.itemModified();
        }
    }

    boolean canApply() {
        return true;
    }

    boolean applyChanges() {
        return true;
    }

    ChartBuilderDlg getParentDialog() {
        return this.mParentDlg;
    }

    void addDragAdapters() {
    }

    public abstract String getPanelId();

    abstract void initialize(ChartProps var1, Props var2);

    protected abstract String getDlgHelpId();

    protected abstract void addTabTraversalComponents(Vector<Object> var1);

    public static String formatNumeric(double d) {
        String string = "";
        try {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(ResUtil.getLocale());
            string = String.format("%.15f", d);
            int n = string.length();
            char c = decimalFormatSymbols.getDecimalSeparator();
            if (string.indexOf(c) > -1) {
                for (int i = n - 1; i >= 0; --i) {
                    if (string.charAt(i) == c) {
                        --n;
                        break;
                    }
                    if (string.charAt(i) != '0') break;
                    --n;
                }
                string = string.substring(0, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (this.mIsEditFieldDirty && (object instanceof JTextField || object instanceof JTextArea)) {
            this.mModListener.itemModified();
            this.mIsEditFieldDirty = false;
        }
    }
}

