/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BaseStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IErrorBarListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class PointStylePanel
extends BaseStylePanel
implements ActionListener,
IErrorBarListener,
ItemListener {
    private boolean mInReload = false;
    private Props.PointProps mPtProp;
    private Statistics mStat;
    private JCheckBox mStackIdenticalCheck;
    private JCheckBox mDropLinesCheck;
    private JCheckBox mTotalCheck;
    private JCheckBox mSubgroupsCheck;

    public PointStylePanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.init();
        this.mStackIdenticalCheck.addActionListener(this);
        this.mDropLinesCheck.addActionListener(this);
        this.mTotalCheck.addItemListener(this);
        this.mSubgroupsCheck.addItemListener(this);
    }

    @Override
    void initialize(Props.ElProps elProps) {
        if (elProps instanceof Props.PointProps) {
            this.mInReload = true;
            this.mPtProp = (Props.PointProps)elProps;
            this.mStat = this.mPtProp.getStatistic().getStat();
            this.mStackIdenticalCheck.setSelected(this.mPtProp.getStackIdentical());
            this.mDropLinesCheck.setSelected(this.mPtProp.getHasDropLine());
            this.mTotalCheck.setSelected(this.mPtProp.hasTotalRegressionLine());
            this.mSubgroupsCheck.setSelected(this.mPtProp.hasSubgroupRegressionLine());
            this.updateEnable();
            this.mInReload = false;
        }
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mStackIdenticalCheck);
        vector.add(this.mDropLinesCheck);
    }

    @Override
    void statChanged(Statistics statistics) {
        this.mStat = statistics;
        this.updateEnable();
    }

    @Override
    boolean applyChanges() {
        this.mPtProp.setStackIdentical(this.mStackIdenticalCheck.isEnabled() && this.mStackIdenticalCheck.isSelected());
        this.mPtProp.setHasDropLine(this.mDropLinesCheck.isEnabled() && this.mDropLinesCheck.isSelected());
        this.mPtProp.setCanHaveRegressionLine(this.mTotalCheck.isEnabled() || this.mSubgroupsCheck.isEnabled());
        this.mPtProp.setHasTotalRegressionLine(this.mTotalCheck.isEnabled() && this.mTotalCheck.isSelected());
        this.mPtProp.setHasSubgroupRegressionLine(this.mSubgroupsCheck.isEnabled() && this.mSubgroupsCheck.isSelected());
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        this.mModListener.itemModified();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mInReload) {
            return;
        }
        this.mModListener.itemModified();
    }

    @Override
    public void errorBarStateChanged(boolean bl) {
        if (bl && this.mDropLinesCheck.isSelected()) {
            this.mDropLinesCheck.setSelected(false);
            this.mModListener.itemModified();
        }
        this.updateEnable();
    }

    private void updateEnable() {
        boolean bl = this.mCanvas.getZoneMgr().hasCatVar(ZoneType.zt_x) || this.mCanvas.getZoneMgr().hasCatVar(ZoneType.zt_y);
        boolean bl2 = this.mStat == Statistics.Value;
        this.mStackIdenticalCheck.setEnabled(bl && bl2);
        boolean bl3 = this.mStat != Statistics.CumCount && this.mStat != Statistics.CumSum && this.mStat != Statistics.CumPct && this.mStat != Statistics.CumResponses && this.mStat != Statistics.CumResponsePct && this.mStat != Statistics.PctOfCases && this.mStat != Statistics.Value && this.mStat != Statistics.Histogram && this.mStat != Statistics.HistogramPct;
        boolean bl4 = !this.mCanvas.getZoneMgr().hasCatVar(ZoneType.zt_y);
        boolean bl5 = this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_group);
        boolean bl6 = false;
        ElementPanel elementPanel = this.getElementPanel();
        if (elementPanel != null) {
            bl6 = elementPanel.errorBarsSelected();
        }
        this.mDropLinesCheck.setEnabled(bl4 && bl3 && bl5 && !bl6);
        CanvasImager canvasImager = this.mCanvas.getImager();
        boolean bl7 = false;
        if (canvasImager.getPrototype() != null) {
            if (canvasImager.getPrototype().getChartGroup() == 16 && !canvasImager.isDropLine() && !canvasImager.isSummaryPointPlot()) {
                this.mTotalCheck.setEnabled(true);
                this.mSubgroupsCheck.setEnabled(canvasImager.hasGrouping());
                bl7 = true;
            }
        } else if (this.mPtProp.canHaveRegressionLine()) {
            this.mTotalCheck.setEnabled(true);
            this.mSubgroupsCheck.setEnabled(canvasImager.hasGrouping() || this.mPtProp.hasSubgroupRegressionLine());
            bl7 = true;
        }
        if (!bl7) {
            this.mTotalCheck.setEnabled(false);
            this.mSubgroupsCheck.setEnabled(false);
        }
    }

    private ElementPanel getElementPanel() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof ElementPanel); container = container.getParent()) {
        }
        return (ElementPanel)container;
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mStackIdenticalCheck = new JCheckBox(this.mCanvas.getResources().getResString("IDS_STACK_IDENTICAL"));
        this.mStackIdenticalCheck.setMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_STACK_IDENTICAL_KEY"));
        DialogUtil.addUsingGBL(this, this.mStackIdenticalCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mDropLinesCheck = new JCheckBox(this.mCanvas.getResources().getResString("IDS_DISPLAY_DROPLINES"));
        this.mDropLinesCheck.setMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_DISPLAY_DROPLINES_KEY"));
        DialogUtil.addUsingGBL(this, this.mDropLinesCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel = this.createFitLinePanel();
        this.mTotalCheck = (JCheckBox)jPanel.getComponent(0);
        this.mSubgroupsCheck = (JCheckBox)jPanel.getComponent(1);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }
}

