/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneMgr;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BinningPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ParametersDlg
extends BaseDialog
implements DocumentListener,
IModListener {
    private ChartBuilderDlg mParent;
    private ContinueAction mContinueAction;
    private ElementStat mElStat;
    private Mode mMode;
    private JComboBox mBox;
    private boolean mContinuePressed;
    private FloatTextField mNumberField1;
    private FloatTextField mNumberField2;
    private JButton mContinueButton;
    private JButton mCancelButton;
    private JButton mHelpButton;
    private BinningPanel mBinningPanel;

    public ParametersDlg(ChartBuilderDlg chartBuilderDlg, ElementStat elementStat) {
        super((BaseDialog)chartBuilderDlg, chartBuilderDlg.getResString("IDS_PARMS_DLG_TITLE"), true, chartBuilderDlg.getResourceBundle(), chartBuilderDlg.getImageFilePath());
        this.mContinueButton = new JButton(this.mContinueAction);
        this.mCancelButton = new JButton(new CancelAction());
        this.mHelpButton = new JButton(new HelpAction());
        this.mParent = chartBuilderDlg;
        this.mElStat = elementStat;
        this.mContinuePressed = false;
        this.initialize();
        this.pack();
        this.setLocationRelativeTo((Component)((Object)chartBuilderDlg));
        this.updateContinue();
    }

    public boolean getContentModified() {
        return this.mContinuePressed;
    }

    public void doHelp() {
        if (this.mMode == Mode.histogram) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idc_cg_help_histogram_params");
        } else {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idc_cg_help_ep_params");
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    private void updateContinue() {
        boolean bl;
        if (this.mMode == Mode.histogram) {
            bl = this.mBinningPanel.checkComplete(false);
        } else if (this.mNumberField1 != null) {
            boolean bl2 = bl = this.mNumberField1.getText().length() > 0;
            if (bl && (this.mMode == Mode.twoParms || this.mMode == Mode.histogram)) {
                bl = this.mNumberField2.getText().length() > 0;
            }
        } else {
            bl = true;
        }
        this.enableContinue(bl);
    }

    protected void enableContinue(boolean bl) {
        this.mContinueAction.setEnabled(bl);
    }

    protected void initialize() {
        boolean bl;
        Statistics statistics = this.mElStat.getStat();
        boolean bl2 = statistics == Statistics.Histogram || statistics == Statistics.HistogramPct;
        boolean bl3 = statistics == Statistics.PctOfCases;
        boolean bl4 = statistics == Statistics.NumInside || statistics == Statistics.PctInside;
        boolean bl5 = bl = !bl2 && !bl3 && !bl4;
        if (bl2) {
            this.setupHistogramControls();
        } else if (bl3) {
            this.setupPctBaseControls();
        } else if (bl) {
            this.setupOneParmControls();
        } else {
            this.setupTwoParmControls();
        }
    }

    private boolean supportsNegatives() {
        Statistics statistics = this.mElStat.getStat();
        return statistics == Statistics.NumAbove || statistics == Statistics.NumBelow || statistics == Statistics.NumInside || statistics == Statistics.PctBelow || statistics == Statistics.PctAbove || statistics == Statistics.PctInside;
    }

    private void setupHistogramControls() {
        this.mMode = Mode.histogram;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, 2, n);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mBinningPanel = new BinningPanel(this.mParent.getCanvas(), this);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mBinningPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        String string = this.getResString("IDS_PCT_BASE_PROMPT");
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), jPanel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.mBox = new JComboBox<Object>(this.getComboItems());
        Insets insets2 = new Insets(n, n, n * 2, n);
        DialogUtil.addUsingGBL(jPanel, this.mBox, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mBox.setEnabled(this.mElStat.getStat() == Statistics.HistogramPct);
        this.mBinningPanel.initialize(this.mElStat);
        this.selectComboItem(this.mElStat.getPctBaseType());
    }

    private void setupPctBaseControls() {
        this.mMode = Mode.pctBase;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, 2, n);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        String string = this.mElStat.getStat().equals((Object)Statistics.ResponsePct) ? "IDK_RESP_PCT_DENOM_KEY" : "IDS_PCT_BASE_PROMPT";
        JLabel jLabel = new JLabel(this.getResString(string));
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.mBox = new JComboBox<Object>(this.getComboItems());
        insets = new Insets(0, n, n, n);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mBox, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.selectComboItem(this.mElStat.getPctBaseType());
    }

    private void selectComboItem(IPropEnum.PercentageBaseType percentageBaseType) {
        for (int i = 0; i < this.mBox.getModel().getSize(); ++i) {
            ComboItem comboItem = (ComboItem)this.mBox.getModel().getElementAt(i);
            if (comboItem.getPctType() != percentageBaseType) continue;
            this.mBox.setSelectedIndex(i);
            break;
        }
    }

    private Object[] getComboItems() {
        Vector<ComboItem> vector = new Vector<ComboItem>();
        ZoneMgr zoneMgr = this.mParent.getCanvas().getZoneMgr();
        boolean bl = zoneMgr.hasCatVar(ZoneType.zt_x);
        boolean bl2 = zoneMgr.hasCatVar(ZoneType.zt_z);
        boolean bl3 = zoneMgr.hasCatVar(ZoneType.zt_panel_horz) || zoneMgr.hasCatVar(ZoneType.zt_panel_vert);
        boolean bl4 = zoneMgr.hasCatVar(ZoneType.zt_group) || zoneMgr.hasCatVar(ZoneType.zt_slice_by);
        boolean bl5 = zoneMgr.hasCatVar(ZoneType.zt_cluster_x);
        boolean bl6 = zoneMgr.hasCatVar(ZoneType.zt_cluster_z);
        vector.add(new ComboItem(this.getResString("IDS_GRAND_TOTAL"), IPropEnum.PercentageBaseType.pbt_GrandTotal));
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            ++n;
        }
        if (bl3) {
            ++n;
        }
        if (bl4) {
            ++n;
        }
        if (bl5) {
            ++n;
        }
        if (bl6) {
            ++n;
        }
        if (n > 1 || bl3 || bl4) {
            int n2 = 0;
            if (bl) {
                vector.add(new ComboItem(this.getResString("IDS_X_TOTAL"), IPropEnum.PercentageBaseType.pbt_XAxisTotal));
            }
            if (bl2) {
                vector.add(new ComboItem(this.getResString("IDS_Z_TOTAL"), IPropEnum.PercentageBaseType.pbt_ZAxisTotal));
            }
            if (bl5) {
                vector.add(this.setupLegendItem(ZoneType.zt_cluster_x, ++n2));
            }
            if (bl6) {
                vector.add(this.setupLegendItem(ZoneType.zt_cluster_z, ++n2));
            }
            if (bl4) {
                vector.add(this.setupLegendItem(ZoneType.zt_group, ++n2));
            }
            if (bl3) {
                vector.add(new ComboItem(this.getResString("IDS_PANEL_TOTAL"), IPropEnum.PercentageBaseType.pbt_PanelTotal));
            }
        }
        ComboItem[] comboItemArray = new ComboItem[vector.size()];
        return vector.toArray(comboItemArray);
    }

    private ComboItem setupLegendItem(ZoneType zoneType, int n) {
        String string = this.getResString("IDS_LEGEND_TOTAL");
        IPropEnum.PercentageBaseType percentageBaseType = n == 1 ? IPropEnum.PercentageBaseType.pbt_LegendTotal1 : IPropEnum.PercentageBaseType.pbt_LegendTotal2;
        boolean bl = this.mParent.getCanvas().getImager().getUsesColorForStyleByType(zoneType);
        Elements elements = this.mParent.getCanvas().getImager().getPrimaryElementType();
        string = bl ? (elements == Elements.line || elements == Elements.point ? string + " (" + this.getResString("IDS_LINE_COLOR_LOWER") + ")" : string + " (" + this.getResString("IDS_FILL_COLOR_LOWER") + ")") : (elements == Elements.point ? string + " (" + this.getResString("IDS_MARKER_PATTERN_LOWER") + ")" : (elements == Elements.line ? string + " (" + this.getResString("IDS_LINE_PATTERN_LOWER") + ")" : string + " (" + this.getResString("IDS_FILL_PATTERN_LOWER") + ")"));
        return new ComboItem(string, percentageBaseType);
    }

    private void setupOneParmControls() {
        this.mMode = Mode.oneParm;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, 2, n);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.getStatLabelPrompt());
        jLabel.setDisplayedMnemonic(this.getStatLabelKey());
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.mNumberField1 = new FloatTextField(!this.supportsNegatives());
        this.mNumberField1.setColumns(8);
        insets = new Insets(0, n, n, n);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), (JComponent)this.mNumberField1, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        jLabel.setLabelFor((Component)this.mNumberField1);
        String string = this.mElStat.getStrParm1();
        if (string != null && string.length() > 0) {
            this.mNumberField1.setText(string);
        } else {
            this.enableContinue(false);
        }
        this.mNumberField1.getDocument().addDocumentListener(this);
    }

    private int getStatLabelKey() {
        String string = "";
        Statistics statistics = this.mElStat.getStat();
        if (statistics == Statistics.PTile) {
            string = "IDK_PERCENTILE_KEY";
        } else if (statistics == Statistics.GPTile) {
            string = "IDK_G_PERCENTILE_KEY";
        } else if (statistics == Statistics.PctBelow) {
            string = "IDK_PCT_LESS_THAN_KEY";
        } else if (statistics == Statistics.PctAbove) {
            string = "IDK_PCT_GREATER_THAN_KEY";
        } else if (statistics == Statistics.NumAbove) {
            string = "IDK_NUM_GREATER_THAN_KEY";
        } else if (statistics == Statistics.NumBelow) {
            string = "IDK_NUM_LESS_THAN_KEY";
        }
        return this.getDlgAccessKey(string);
    }

    private String getStatLabelPrompt() {
        String string = "";
        Statistics statistics = this.mElStat.getStat();
        if (statistics == Statistics.PTile) {
            string = "IDS_PERCENTILE";
        } else if (statistics == Statistics.GPTile) {
            string = "IDS_G_PERCENTILE";
        } else if (statistics == Statistics.PctBelow) {
            string = "IDS_PCT_LESS_THAN";
        } else if (statistics == Statistics.PctAbove) {
            string = "IDS_PCT_GREATER_THAN";
        } else if (statistics == Statistics.NumAbove) {
            string = "IDS_NUM_GREATER_THAN";
        } else if (statistics == Statistics.NumBelow) {
            string = "IDS_NUM_LESS_THAN";
        }
        return this.getResString(string);
    }

    private void setupTwoParmControls() {
        this.mMode = Mode.twoParms;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, n, n);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RANGE")));
        DialogUtil.addUsingGBL(this.getViewPanel(), jPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JLabel jLabel = new JLabel(this.getResString("IDS_LOW"));
        jLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_LOW2_KEY"));
        insets = new Insets(n, n, 2, n);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.mNumberField1 = new FloatTextField(!this.supportsNegatives());
        this.mNumberField1.setColumns(8);
        insets = new Insets(0, n, n, n);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberField1, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        jLabel.setLabelFor((Component)this.mNumberField1);
        JLabel jLabel2 = new JLabel(this.getResString("IDS_HIGH"));
        jLabel2.setDisplayedMnemonic(this.getDlgAccessKey("IDK_HIGH_KEY"));
        insets = new Insets(n, n, 2, n);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.mNumberField2 = new FloatTextField(!this.supportsNegatives());
        this.mNumberField2.setColumns(8);
        insets = new Insets(0, n, n, n);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberField2, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        jLabel2.setLabelFor((Component)this.mNumberField2);
        String string = this.mElStat.getStrParm1();
        String string2 = this.mElStat.getStrParm2();
        this.mNumberField1.setText(string);
        this.mNumberField2.setText(string2);
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            this.enableContinue(false);
        }
        this.mNumberField1.getDocument().addDocumentListener(this);
        this.mNumberField2.getDocument().addDocumentListener(this);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        this.mContinueButton = new JButton(this.mContinueAction);
        this.mCancelButton = new JButton(new CancelAction());
        this.mHelpButton = new JButton(new HelpAction());
        this.mHelpButton.putClientProperty("JButton.buttonType", "help");
        if (OSCheck.getOSType() == OSInfo.OSType.MAC && OSCheck.isMacOSXLeopardOrLater()) {
            this.mHelpButton.setText("");
        }
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 24;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
                DialogUtil.addUsingGBL(jPanel, this.mContinueButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mContinueButton);
                jPanel.add(this.mCancelButton);
                jPanel.add(this.mHelpButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            this.mContinueButton = new JButton(new ContinueAction());
            jPanel.add(this.mContinueButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mContinueButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private boolean checkRange() {
        if (this.mElStat.getStat() == Statistics.PTile || this.mElStat.getStat() == Statistics.GPTile) {
            String string = this.mNumberField1.getText();
            double d = -1.0;
            if (string != null && string.length() > 0) {
                try {
                    d = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                if (d <= 0.0 || d >= 100.0) {
                    String string2 = MessageFormat.format(this.getResString("ERR_PARAMETERS_RANGE_INCLUSIVE"), 1, 99);
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ParametersDlg.this.mNumberField1.requestFocusInWindow();
                            ParametersDlg.this.mNumberField1.selectAll();
                        }
                    });
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkHighLow() {
        String string = this.mNumberField1.getText();
        String string2 = this.mNumberField2.getText();
        double d = -1.0;
        double d2 = -1.0;
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return false;
        }
        try {
            d = Double.valueOf(string);
            d2 = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        if (d > d2) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_RANGE_ERROR"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParametersDlg.this.mNumberField1.requestFocusInWindow();
                    ParametersDlg.this.mNumberField1.selectAll();
                }
            });
            return false;
        }
        return true;
    }

    @Override
    public void itemModified() {
        this.updateContinue();
    }

    @Override
    public void clearModFlag() {
        assert (false);
    }

    static enum Mode {
        pctBase,
        oneParm,
        twoParms,
        histogram;

    }

    class ComboItem {
        private IPropEnum.PercentageBaseType mPctType;
        private String mName;

        public ComboItem(String string, IPropEnum.PercentageBaseType percentageBaseType) {
            this.mName = string;
            this.mPctType = percentageBaseType;
        }

        public String toString() {
            return this.mName;
        }

        public IPropEnum.PercentageBaseType getPctType() {
            return this.mPctType;
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ParametersDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ParametersDlg.this.dispose();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            if (ParametersDlg.this.mMode == Mode.pctBase) {
                ComboItem comboItem = (ComboItem)ParametersDlg.this.mBox.getSelectedItem();
                bl = ParametersDlg.this.mElStat.getPctBaseType() != comboItem.getPctType();
                ParametersDlg.this.mElStat.setPctBaseType(comboItem.getPctType());
            } else if (ParametersDlg.this.mMode == Mode.oneParm) {
                if (!ParametersDlg.this.checkRange()) {
                    return;
                }
                bl = !ParametersDlg.this.mElStat.getStrParm1().equals(ParametersDlg.this.mNumberField1.getText());
                ParametersDlg.this.mElStat.setStrParm1(ParametersDlg.this.mNumberField1.getText());
            } else if (ParametersDlg.this.mMode == Mode.twoParms) {
                if (!ParametersDlg.this.checkHighLow()) {
                    return;
                }
                bl = !ParametersDlg.this.mElStat.getStrParm1().equals(ParametersDlg.this.mNumberField1.getText()) || !ParametersDlg.this.mElStat.getStrParm2().equals(ParametersDlg.this.mNumberField2.getText());
                ParametersDlg.this.mElStat.setStrParm1(ParametersDlg.this.mNumberField1.getText());
                ParametersDlg.this.mElStat.setStrParm2(ParametersDlg.this.mNumberField2.getText());
            } else if (ParametersDlg.this.mMode == Mode.histogram) {
                ComboItem comboItem = (ComboItem)ParametersDlg.this.mBox.getSelectedItem();
                ParametersDlg.this.mElStat.setPctBaseType(comboItem.getPctType());
                if (!ParametersDlg.this.mBinningPanel.applyChanges()) {
                    return;
                }
                bl = true;
            } else {
                return;
            }
            ParametersDlg.this.mContinuePressed = bl;
            ParametersDlg.this.dispose();
        }
    }
}

