/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.controls.IUpDownListListener;
import com.spss.java_client.ui.controls.UpDownListWidget;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BaseStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.StatisticsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.YXPairs;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;

public class OverlayElementPanel
extends ElementPanel
implements IUpDownListListener {
    private UpDownListWidget mListWidget;
    protected boolean mInReload = false;
    private Props.PointProps mPointProps;

    public OverlayElementPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
    }

    @Override
    public String getPanelId() {
        return "overlay_panel";
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        this.mStatsPanel.addTabTraversalComponents(vector);
        this.mListWidget.addTabTraversalComponents(vector);
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        this.mInReload = true;
        if (props instanceof Props.PointProps) {
            this.mPointProps = (Props.PointProps)props;
            this.mStatsPanel.initialize(chartProps, this.mPointProps);
            this.mStatsPanel.setVarName(this.mCanvas.getResources().getResString("IDS_MULTI_VARS"), null);
            this.mStatsPanel.enableStatisticsList(false);
            this.mListWidget.clear();
            YXPairs yXPairs = this.mPointProps.getYXPairs();
            for (int i = 0; i < yXPairs.getCount(); ++i) {
                this.mListWidget.addListItem(yXPairs.getAt(i), yXPairs.get(i));
            }
            if (yXPairs.getCount() > 0) {
                this.mListWidget.setSelectedItem(0);
            }
        }
        this.mInReload = false;
    }

    @Override
    boolean applyChanges() {
        boolean bl = this.mStatsPanel.applyChanges();
        if (bl) {
            YXPairs yXPairs = this.mPointProps.getYXPairs();
            yXPairs.clear();
            Vector<UpDownListWidget.ListItem> vector = this.mListWidget.getListItems();
            for (UpDownListWidget.ListItem listItem : vector) {
                String string = (String)listItem.getUserObject();
                int n = string.indexOf(",");
                if (n <= -1) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                yXPairs.add(string2, string3);
            }
        }
        return bl;
    }

    @Override
    public void listItemChanged(UpDownListWidget.ListChangeType listChangeType, Vector<Object> vector) {
        if (!this.mInReload) {
            this.mModListener.itemModified();
        }
    }

    @Override
    protected BaseStylePanel getStylePanel(Props.ElProps elProps) {
        return null;
    }

    @Override
    protected void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mStatsPanel = new StatisticsPanel(this.mCanvas, this.mModListener);
        DialogUtil.addUsingGBL(this, this.mStatsPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.createYXPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel createYXPanel() {
        this.mListWidget = new UpDownListWidget(this.mCanvas.getResources().getResString("IDS_XY_PAIRS_COLON"), this.mCanvas.getResources().getDlgAccessKey("IDK_XY_PAIRS_COLON_KEY"));
        this.mListWidget.addListListener(this);
        this.mListWidget.setListSize(new Dimension(160, 120));
        return this.mListWidget;
    }
}

