/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.base.graphs.IMatrixListener;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.StatisticsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OneDDotPanel
extends ElementPanel
implements IMatrixListener {
    private boolean mInReload = false;
    private MatrixImage mAsymmetic;
    private MatrixImage mSymmetic;
    private MatrixImage mFlat;
    private Props.PointProps mPtProp = null;

    public OneDDotPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
    }

    @Override
    public String getPanelId() {
        return "dotplot_panel";
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        this.mStatsPanel.addTabTraversalComponents(vector);
        vector.add(this.mAsymmetic);
        vector.add(this.mSymmetic);
        vector.add(this.mFlat);
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        this.mInReload = true;
        if (props instanceof Props.PointProps) {
            this.mPtProp = (Props.PointProps)props;
            this.mStatsPanel.initialize(chartProps, this.mPtProp);
            IPropEnum.PlotShape plotShape = this.mPtProp.getPlotShape();
            if (plotShape == IPropEnum.PlotShape.ps_Asymmetric) {
                this.mAsymmetic.setSelected(true);
            } else if (plotShape == IPropEnum.PlotShape.ps_Symmetric) {
                this.mSymmetic.setSelected(true);
            } else if (plotShape == IPropEnum.PlotShape.ps_Flat) {
                this.mFlat.setSelected(true);
            }
        }
        this.mInReload = false;
    }

    @Override
    boolean applyChanges() {
        boolean bl = this.mStatsPanel.applyChanges();
        if (bl) {
            IPropEnum.PlotShape plotShape;
            if (this.mAsymmetic.isSelected()) {
                plotShape = IPropEnum.PlotShape.ps_Asymmetric;
            } else if (this.mSymmetic.isSelected()) {
                plotShape = IPropEnum.PlotShape.ps_Symmetric;
            } else if (this.mFlat.isSelected()) {
                plotShape = IPropEnum.PlotShape.ps_Flat;
            } else {
                return false;
            }
            this.mPtProp.setPlotShape(plotShape);
        }
        return bl;
    }

    @Override
    public void matrixImageEvent(IMatrixListener.EventType eventType, int n) {
        if (n < 0) {
            return;
        }
        if (!this.mInReload) {
            this.mModListener.itemModified();
        }
    }

    @Override
    protected void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mStatsPanel = new StatisticsPanel(this.mCanvas, this.mModListener);
        DialogUtil.addUsingGBL(this, this.mStatsPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        MatrixImagesGroup matrixImagesGroup = new MatrixImagesGroup();
        JLabel jLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_ASYMMETRIC"));
        jLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_ASYMMETRIC_KEY"));
        this.mAsymmetic = new MatrixImage(this.mCanvas.getResources().getResImageURL("IDS_ASYMMETRIC_IMAGE"));
        this.mAsymmetic.setImageLabelGroup(matrixImagesGroup);
        this.mAsymmetic.addMatrixListener(this);
        JLabel jLabel2 = new JLabel(this.mCanvas.getResources().getResString("IDS_SYMMETRIC"));
        jLabel2.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_SYMMETRIC_KEY"));
        this.mSymmetic = new MatrixImage(this.mCanvas.getResources().getResImageURL("IDS_SYMMETRIC_IMAGE"));
        this.mSymmetic.setImageLabelGroup(matrixImagesGroup);
        this.mSymmetic.addMatrixListener(this);
        JLabel jLabel3 = new JLabel(this.mCanvas.getResources().getResString("IDS_FLAT"));
        jLabel3.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_FLAT_KEY"));
        this.mFlat = new MatrixImage(this.mCanvas.getResources().getResImageURL("IDS_FLAT_IMAGE"));
        this.mFlat.setImageLabelGroup(matrixImagesGroup);
        this.mFlat.addMatrixListener(this);
        Vector<MatrixImage> vector = new Vector<MatrixImage>();
        vector.add(this.mAsymmetic);
        vector.add(this.mSymmetic);
        vector.add(this.mFlat);
        this.mAsymmetic.addKeyListener(new ImageLabelKeyListener(vector, matrixImagesGroup));
        this.mSymmetic.addKeyListener(new ImageLabelKeyListener(vector, matrixImagesGroup));
        this.mFlat.addKeyListener(new ImageLabelKeyListener(vector, matrixImagesGroup));
        this.mAsymmetic.setFocusable(true);
        this.mSymmetic.setFocusable(true);
        this.mFlat.setFocusable(true);
        JComponent[] jComponentArray = new JComponent[]{this.mAsymmetic, this.mSymmetic, this.mFlat, jLabel, jLabel2, jLabel3, new JLabel()};
        JPanel jPanel = PanelFactory.getPanelForImageLabels(jComponentArray, this.mCanvas.getResources().getResString("IDS_SD_PLOT_SHAPE_LABEL"), 3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }
}

