/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.IUpDownListListener;
import com.spss.java_client.ui.controls.UpDownListWidget;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BaseStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class MatrixStylePanel
extends BaseStylePanel
implements IUpDownListListener,
ItemListener {
    private Props.MatrixProps mMatrixProps;
    private boolean mInReload = false;
    private UpDownListWidget mUpDownListWidget;
    private JCheckBox mTotalCheck;
    private JCheckBox mSubgroupCheck;

    public MatrixStylePanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.init();
    }

    @Override
    boolean applyChanges() {
        Vector<ISpssVariable> vector = this.mMatrixProps.getMatrixVarList();
        vector.clear();
        Vector<UpDownListWidget.ListItem> vector2 = this.mUpDownListWidget.getListItems();
        for (UpDownListWidget.ListItem listItem : vector2) {
            vector.add((ISpssVariable)listItem.getUserObject());
        }
        this.mMatrixProps.setHasTotalRegressionLine(this.mTotalCheck.isEnabled() && this.mTotalCheck.isSelected());
        this.mMatrixProps.setHasSubgroupRegressionLine(this.mSubgroupCheck.isEnabled() && this.mSubgroupCheck.isSelected());
        return true;
    }

    @Override
    void initialize(Props.ElProps elProps) {
        this.mInReload = true;
        if (elProps instanceof Props.MatrixProps) {
            this.mUpDownListWidget.clear();
            this.mMatrixProps = (Props.MatrixProps)elProps;
            Vector<ISpssVariable> vector = this.mMatrixProps.getMatrixVarList();
            for (ISpssVariable iSpssVariable : vector) {
                String string = iSpssVariable.getLabel();
                if (string == null || string.length() == 0) {
                    string = iSpssVariable.getName();
                }
                this.mUpDownListWidget.addListItem(string, iSpssVariable);
            }
            if (vector.size() > 0) {
                this.mUpDownListWidget.setSelectedItem(0);
            }
            this.mTotalCheck.setEnabled(true);
            this.mTotalCheck.setSelected(this.mMatrixProps.hasTotalRegressionLine());
            this.mSubgroupCheck.setSelected(this.mMatrixProps.hasSubgroupRegressionLine());
            CanvasImager canvasImager = this.mCanvas.getImager();
            boolean bl = false;
            if (canvasImager.getPrototype() != null) {
                this.mSubgroupCheck.setEnabled(canvasImager.hasGrouping());
                bl = true;
            } else if (this.mMatrixProps.canHaveRegressionLine()) {
                this.mSubgroupCheck.setEnabled(canvasImager.hasGrouping() || this.mMatrixProps.hasSubgroupRegressionLine());
                bl = true;
            }
            if (!bl) {
                this.mSubgroupCheck.setEnabled(false);
            }
        }
        this.mInReload = false;
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        this.mUpDownListWidget.addTabTraversalComponents(vector);
    }

    @Override
    public void listItemChanged(UpDownListWidget.ListChangeType listChangeType, Vector<Object> vector) {
        if (!this.mInReload) {
            this.mModListener.itemModified();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mInReload) {
            return;
        }
        this.mModListener.itemModified();
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder(this.mCanvas.getResources().getResString("IDS_MATRIX_VARIABLES")));
        this.mUpDownListWidget = new UpDownListWidget(this.mCanvas.getResources().getResString("IDS_ORDER"), this.mCanvas.getResources().getDlgAccessKey("IDK_ORDER_KEY"));
        this.mUpDownListWidget.addListListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mUpDownListWidget, gridBagConstraints, 0, 0, 1, 1, n, null);
        JPanel jPanel = this.createFitLinePanel();
        this.mTotalCheck = (JCheckBox)jPanel.getComponent(0);
        this.mSubgroupCheck = (JCheckBox)jPanel.getComponent(1);
        this.mTotalCheck.addItemListener(this);
        this.mSubgroupCheck.addItemListener(this);
        gridBagConstraints.weighty = 1.0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, n2, 0, n2));
    }
}

