/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BaseStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ListLabel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class MarkerStylePanel
extends BaseStylePanel
implements ActionListener {
    private JComboBox mItemList;
    private Props.HiLoCloseProps mHLCProp;
    private boolean mInReload = false;

    public MarkerStylePanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.init();
        this.mItemList.addActionListener(this);
    }

    @Override
    boolean applyChanges() {
        int n = this.mItemList.getSelectedIndex();
        if (n > -1) {
            ListLabel listLabel = (ListLabel)this.mItemList.getModel().getElementAt(n);
            this.mHLCProp.setSymbolType(listLabel.getSymbolType());
        }
        return true;
    }

    @Override
    void initialize(Props.ElProps elProps) {
        this.mInReload = true;
        if (elProps instanceof Props.HiLoCloseProps) {
            this.mHLCProp = (Props.HiLoCloseProps)elProps;
            this.mItemList.setSelectedIndex(this.findListIndex(this.mHLCProp.getSymbolType()));
        }
        this.mInReload = false;
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mItemList);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        this.mModListener.itemModified();
    }

    private int findListIndex(IPropEnum.SymbolType symbolType) {
        for (int i = 0; i < this.mItemList.getModel().getSize(); ++i) {
            ListLabel listLabel = (ListLabel)this.mItemList.getModel().getElementAt(i);
            if (listLabel.getSymbolType() != symbolType) continue;
            return i;
        }
        return -1;
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_MARKER_TYPE_PROMPT"));
        jLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_MARKER_TYPE_PROMPT_KEY"));
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mItemList = new JComboBox<Object>(this.getItems());
        this.mItemList.setEditable(false);
        this.mItemList.setRenderer(new ListLabel((IPropEnum.SymbolType)null, null, null, 10));
        DialogUtil.addUsingGBL(this, this.mItemList, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jLabel.setLabelFor(this.mItemList);
    }

    private Object[] getItems() {
        Vector<ListLabel> vector = new Vector<ListLabel>();
        String string = this.mCanvas.getResources().getResString("IDS_ARROW");
        ImageIcon imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_ARROW_IMAGE"));
        ListLabel listLabel = new ListLabel(IPropEnum.SymbolType.st_Arrow, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_BOWTIE");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_BOWTIE_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Bowtie, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_CIRCLE");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_CIRCLE_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Circle, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_CROSS");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_CROSS_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Cross, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_FEMALE");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_FEMALE_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Female, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_FLOWER");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_FLOWER_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Flower, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_IBEAM2");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_IBEAM_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_IBeam, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_LINE");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_LINE_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Line, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_MALE");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_MALE_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Male, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_PLUS");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_PLUS_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Plus, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_POLYGON");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_POLYGON_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Polygon, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_SQUARE");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_SQUARE_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Square, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_STAR");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_STAR_IMAGE"));
        listLabel = new ListLabel(IPropEnum.SymbolType.st_Star, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        ListLabel[] listLabelArray = new ListLabel[vector.size()];
        return vector.toArray(listLabelArray);
    }
}

