/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BaseStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ListLabel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.InterpolationGroup;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class InterpolationStylePanel
extends BaseStylePanel
implements ActionListener {
    private boolean mInReload = false;
    private InterpolationGroup mInterpolationGroup;
    private JComboBox mTypeCombo;
    private JComboBox mLocationCombo;
    private JLabel mLocationLabel;
    private JCheckBox mThroughMissingCheck;

    public InterpolationStylePanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.init();
        this.mTypeCombo.addActionListener(this);
        this.mLocationCombo.addActionListener(this);
        this.mThroughMissingCheck.addActionListener(this);
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mTypeCombo);
        vector.add(this.mLocationCombo);
        vector.add(this.mThroughMissingCheck);
    }

    @Override
    void initialize(Props.ElProps elProps) {
        ListLabel listLabel;
        int n;
        this.mInReload = true;
        if (elProps instanceof Props.LineProps) {
            this.mInterpolationGroup = ((Props.LineProps)elProps).getInterpolationGroup();
        } else if (elProps instanceof Props.AreaProps) {
            this.mInterpolationGroup = ((Props.AreaProps)elProps).getInterpolationGroup();
        } else if (elProps instanceof Props.HiLoCloseProps) {
            this.mInterpolationGroup = ((Props.HiLoCloseProps)elProps).getInterpolationGroup();
        } else {
            this.mInReload = false;
            return;
        }
        for (n = 0; n < this.mTypeCombo.getModel().getSize(); ++n) {
            listLabel = (ListLabel)this.mTypeCombo.getModel().getElementAt(n);
            if (listLabel.getInterpolationType() != this.mInterpolationGroup.getInterpolationType()) continue;
            this.mTypeCombo.setSelectedIndex(n);
            break;
        }
        for (n = 0; n < this.mLocationCombo.getModel().getSize(); ++n) {
            listLabel = (ListLabel)this.mLocationCombo.getModel().getElementAt(n);
            if (listLabel.getInterpolationLocation() != this.mInterpolationGroup.getInterpolationLocation()) continue;
            this.mLocationCombo.setSelectedIndex(n);
            break;
        }
        this.mThroughMissingCheck.setSelected(this.mInterpolationGroup.getInterpolateThroughMissing());
        this.updateEnable();
        this.mInReload = false;
    }

    @Override
    boolean applyChanges() {
        ListLabel listLabel = (ListLabel)this.mTypeCombo.getModel().getElementAt(this.mTypeCombo.getSelectedIndex());
        this.mInterpolationGroup.setInterpolationType(listLabel.getInterpolationType());
        listLabel = (ListLabel)this.mLocationCombo.getModel().getElementAt(this.mLocationCombo.getSelectedIndex());
        this.mInterpolationGroup.setInterpolationLocation(listLabel.getInterpolationLocation());
        this.mInterpolationGroup.setInterpolateThroughMissing(this.mThroughMissingCheck.isSelected());
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        if (actionEvent.getSource() == this.mTypeCombo) {
            this.updateEnable();
        }
        this.mModListener.itemModified();
    }

    private void updateEnable() {
        ListLabel listLabel = (ListLabel)this.mTypeCombo.getModel().getElementAt(this.mTypeCombo.getSelectedIndex());
        boolean bl = listLabel.getInterpolationType() == IPropEnum.InterpolationType.it_Jump || listLabel.getInterpolationType() == IPropEnum.InterpolationType.it_Step;
        this.mLocationLabel.setEnabled(bl);
        this.mLocationCombo.setEnabled(bl);
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder(this.mCanvas.getResources().getResString("IDS_INTERPOLATION")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 3, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_TYPE"));
        jLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_TYPE_KEY"));
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        ListLabel listLabel = new ListLabel((IPropEnum.InterpolationType)null, null, null, 10);
        this.mTypeCombo = new JComboBox<Object>(this.getTypeItems());
        this.mTypeCombo.setEditable(false);
        this.mTypeCombo.setRenderer(listLabel);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this, this.mTypeCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jLabel.setLabelFor(this.mTypeCombo);
        this.mLocationLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_LOCATION"));
        this.mLocationLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_LOCATION_KEY"));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this, this.mLocationLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        listLabel = new ListLabel((IPropEnum.InterpolationLocation)null, null, null, 10);
        this.mLocationCombo = new JComboBox<Object>(this.getLocationItems());
        gridBagConstraints.weightx = 1.0;
        this.mLocationCombo.setEditable(false);
        this.mLocationCombo.setRenderer(listLabel);
        DialogUtil.addUsingGBL(this, this.mLocationCombo, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.mLocationLabel.setLabelFor(this.mLocationCombo);
        this.mThroughMissingCheck = new JCheckBox(this.mCanvas.getResources().getResString("IDS_INTERPOLATE_CHECK"));
        this.mThroughMissingCheck.setMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_INTERPOLATE_CHECK_KEY"));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.mThroughMissingCheck, gridBagConstraints, 0, 2, 2, 1, n, insets);
    }

    private Object[] getTypeItems() {
        Vector<ListLabel> vector = new Vector<ListLabel>();
        String string = this.mCanvas.getResources().getResString("IDS_STRAIGHT");
        ImageIcon imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_INTERP_STRAIGHT_IMAGE"));
        ListLabel listLabel = new ListLabel(IPropEnum.InterpolationType.it_Straight, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_STEP");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_INTERP_STEP_IMAGE"));
        listLabel = new ListLabel(IPropEnum.InterpolationType.it_Step, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_JUMP");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_INTERP_JUMP_IMAGE"));
        listLabel = new ListLabel(IPropEnum.InterpolationType.it_Jump, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_SPLINE");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_INTERP_SPLINE_IMAGE"));
        listLabel = new ListLabel(IPropEnum.InterpolationType.it_Spline, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        ListLabel[] listLabelArray = new ListLabel[vector.size()];
        return vector.toArray(listLabelArray);
    }

    private Object[] getLocationItems() {
        Vector<ListLabel> vector = new Vector<ListLabel>();
        String string = this.mCanvas.getResources().getResString("IDS_LEFT");
        ListLabel listLabel = new ListLabel(IPropEnum.InterpolationLocation.il_Left, string, null, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_RIGHT");
        listLabel = new ListLabel(IPropEnum.InterpolationLocation.il_Right, string, null, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_CENTER");
        listLabel = new ListLabel(IPropEnum.InterpolationLocation.il_Center, string, null, 10);
        vector.add(listLabel);
        ListLabel[] listLabelArray = new ListLabel[vector.size()];
        return vector.toArray(listLabelArray);
    }
}

