/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.StatisticsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class HiLoStatsPanel
extends StatisticsPanel
implements ListSelectionListener,
FocusListener {
    private JTable mVarsTable;
    private DefaultTableModel mTableModel;
    private Props.HiLoCloseProps mHLCProp = null;
    private ElementStat mHighStat;
    private ElementStat mLowStat;
    private ElementStat mCloseStat;
    private boolean mIsDiffArea;

    public HiLoStatsPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.mVarsTable.getSelectionModel().addListSelectionListener(this);
        this.mVarsTable.addFocusListener(this);
    }

    @Override
    void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mVarsTable);
        vector.add(this.mStatsList);
        vector.add(this.mParametersButton);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mInReload || listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.mVarsTable.getSelectedRow();
        this.mWorkStat = n == 0 ? this.mHighStat : (n == 1 ? this.mLowStat : this.mCloseStat);
        this.mInReload = true;
        this.selectStat(this.mWorkStat.getStat());
        this.mInReload = false;
        this.updateCurrentStatisticParms();
        this.mParametersButton.setEnabled(this.parameterCount(this.mWorkStat.getStat()) > 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        int n = this.mStatsList.getSelectedIndex();
        if (n > -1 && !this.checkStatistics()) {
            return;
        }
        super.actionPerformed(actionEvent);
        this.updateCurrentVarStat();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.mVarsTable.repaint(100L);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mVarsTable.repaint(100L);
    }

    @Override
    void updateCurrentStatisticParms() {
        super.updateCurrentStatisticParms();
        this.updateCurrentVarStat();
    }

    @Override
    void initialize(ChartProps chartProps, Props.ElProps elProps) {
        this.mInReload = true;
        this.mElProp = elProps;
        this.mIsDiffArea = this.mCanvas.getImager().isDifferenceArea();
        int n = this.mVarsTable.getSelectedRow();
        if (n == -1) {
            n = 0;
        }
        this.enableControls(true);
        this.mTableModel.setRowCount(this.mIsDiffArea ? 2 : 3);
        if (n == 2 && this.mIsDiffArea) {
            n = 0;
        }
        int n2 = this.mVarsTable.getWidth();
        this.mVarsTable.getColumnModel().getColumn(0).setPreferredWidth((int)((double)n2 * 0.55));
        this.mVarsTable.getColumnModel().getColumn(1).setPreferredWidth((int)((double)n2 * 0.45));
        this.mParameters.clear();
        this.mVarPrompt.setEnabled(true);
        this.mHLCProp = (Props.HiLoCloseProps)elProps;
        try {
            this.mHighStat = this.mHLCProp.getHighStat().clone();
            this.mLowStat = this.mHLCProp.getLowStat().clone();
            this.mCloseStat = this.mHLCProp.getCloseStat().clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return;
        }
        this.loadStatsList(chartProps);
        String string = this.mIsDiffArea ? String.format(this.mCanvas.getResources().getResString("IDS_VAR_SUBST"), 1) : this.mCanvas.getResources().getResString("IDS_HIGH");
        string = string + " " + this.mHighStat.getVarName();
        this.mVarsTable.getModel().setValueAt(string, 0, 0);
        this.mVarsTable.getModel().setValueAt(this.formatNameString(this.mHighStat), 0, 1);
        string = this.mIsDiffArea ? String.format(this.mCanvas.getResources().getResString("IDS_VAR_SUBST"), 2) : this.mCanvas.getResources().getResString("IDS_LOW");
        string = string + " " + this.mLowStat.getVarName();
        this.mVarsTable.getModel().setValueAt(string, 1, 0);
        this.mVarsTable.getModel().setValueAt(this.formatNameString(this.mLowStat), 1, 1);
        if (!this.mIsDiffArea) {
            string = this.mCanvas.getResources().getResString("IDS_HILO_CLOSE_LABEL");
            string = string + " " + this.mCloseStat.getVarName();
            this.mVarsTable.getModel().setValueAt(string, 2, 0);
            this.mVarsTable.getModel().setValueAt(this.formatNameString(this.mCloseStat), 2, 1);
        }
        this.mWorkStat = n == 0 ? this.mHighStat : (n == 1 ? this.mLowStat : this.mCloseStat);
        this.mVarsTable.getSelectionModel().setSelectionInterval(n, n);
        this.selectStat(this.mWorkStat.getStat());
        this.updateCurrentStatisticParms();
        this.mParametersButton.setEnabled(this.parameterCount(this.mWorkStat.getStat()) > 0);
        this.mInReload = false;
    }

    @Override
    boolean applyChanges() {
        this.mHLCProp.getHighStat().setStat(this.mHighStat.getStat());
        this.mHLCProp.getHighStat().setStrParm1(this.mHighStat.getStrParm1());
        this.mHLCProp.getHighStat().setStrParm2(this.mHighStat.getStrParm2());
        this.mHLCProp.getLowStat().setStat(this.mLowStat.getStat());
        this.mHLCProp.getLowStat().setStrParm1(this.mLowStat.getStrParm1());
        this.mHLCProp.getLowStat().setStrParm2(this.mLowStat.getStrParm2());
        if (!this.mIsDiffArea) {
            this.mHLCProp.getCloseStat().setStat(this.mCloseStat.getStat());
            this.mHLCProp.getCloseStat().setStrParm1(this.mCloseStat.getStrParm1());
            this.mHLCProp.getCloseStat().setStrParm2(this.mCloseStat.getStrParm2());
        }
        return true;
    }

    private void updateCurrentVarStat() {
        int n = this.mVarsTable.getSelectedRow();
        StatisticsPanel.StatItem statItem = (StatisticsPanel.StatItem)this.mStatsList.getModel().getSelectedItem();
        if (statItem == null || n < 0) {
            return;
        }
        ElementStat elementStat = n == 0 ? this.mHighStat : (n == 1 ? this.mLowStat : this.mCloseStat);
        elementStat.setStrParm1(this.mWorkStat.getStrParm1());
        elementStat.setStrParm2(this.mWorkStat.getStrParm2());
        elementStat.setPctBaseType(this.mWorkStat.getPctBaseType());
        elementStat.setStat(statItem.getStat());
        this.mVarsTable.getModel().setValueAt(this.formatNameString(elementStat), n, 1);
    }

    @Override
    protected void initControls() {
        this.setBorder(BorderFactory.createTitledBorder(this.mCanvas.getResources().getResString("IDS_STATISTICS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        this.mVarPrompt = new JLabel(this.mCanvas.getResources().getResString("IDS_VARIABLES"));
        this.mVarPrompt.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_VARIABLE_KEY"));
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mVarPrompt, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.mTableModel = new DefaultTableModel(3, 2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.mVarsTable = new JTable(this.mTableModel);
        this.mVarsTable.setBorder(BorderFactory.createLineBorder(UIManager.getColor("TitledBorder.titleColor")));
        this.mVarsTable.setDefaultEditor(String.class, null);
        HiLoCellRenderer hiLoCellRenderer = new HiLoCellRenderer();
        this.mVarsTable.getColumnModel().getColumn(0).setCellRenderer(hiLoCellRenderer);
        this.mVarsTable.getColumnModel().getColumn(1).setCellRenderer(hiLoCellRenderer);
        this.mVarsTable.setSelectionMode(0);
        this.mVarsTable.setRowSelectionAllowed(true);
        this.mVarsTable.setColumnSelectionAllowed(false);
        this.mVarsTable.setShowGrid(false);
        this.mVarsTable.setTableHeader(null);
        this.mVarsTable.setMinimumSize(new Dimension(200, 70));
        this.mVarsTable.setPreferredSize(new Dimension(200, 70));
        insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mVarsTable, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mVarPrompt.setLabelFor(this.mVarsTable);
        this.mStatsList = new JComboBox();
        DialogUtil.addUsingGBL(this, this.mStatsList, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.mParametersButton = new JButton(new StatisticsPanel.SetParmsAction(this));
        insets = new Insets(0, n2, n2, n2);
        n = 26;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mParametersButton, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.mParametersButton.setMargin(new Insets(0, 6, 0, 6));
        this.mVarsTable.setFocusTraversalKeys(0, null);
        this.mVarsTable.setFocusTraversalKeys(1, null);
    }

    boolean checkStatistics() {
        StatisticsPanel.StatItem statItem = (StatisticsPanel.StatItem)this.mStatsList.getModel().getSelectedItem();
        if (this.mWorkStat.getStat() == Statistics.Value && statItem.getStat() != Statistics.Value || this.mWorkStat.getStat() != Statistics.Value && statItem.getStat() == Statistics.Value) {
            boolean bl;
            int n = SpssAlertOptionPane.showConfirmDialog(this, this.mCanvas.getResources().getResString("ERR_RANGE_STAT_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n != 0) {
                this.selectStat(this.mWorkStat.getStat());
                return false;
            }
            this.mInReload = true;
            boolean bl2 = bl = this.mWorkStat.getStat() != Statistics.Value && statItem.getStat() == Statistics.Value;
            if (bl) {
                if (this.mHighStat != this.mWorkStat) {
                    this.mHighStat.setStat(Statistics.Value);
                    this.mHighStat.setStrParm1("");
                    this.mHighStat.setStrParm2("");
                    this.mHighStat.setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
                    this.mVarsTable.getModel().setValueAt(this.formatNameString(this.mHighStat), 0, 1);
                }
                if (this.mLowStat != this.mWorkStat) {
                    this.mLowStat.setStat(Statistics.Value);
                    this.mLowStat.setStrParm1("");
                    this.mLowStat.setStrParm2("");
                    this.mLowStat.setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
                    this.mVarsTable.getModel().setValueAt(this.formatNameString(this.mLowStat), 1, 1);
                }
                if (!this.mIsDiffArea && this.mCloseStat != this.mWorkStat) {
                    this.mCloseStat.setStat(Statistics.Value);
                    this.mCloseStat.setStrParm1("");
                    this.mCloseStat.setStrParm2("");
                    this.mCloseStat.setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
                    this.mVarsTable.getModel().setValueAt(this.formatNameString(this.mCloseStat), 2, 1);
                }
            } else {
                if (this.mHighStat != this.mWorkStat) {
                    this.mHighStat.setStat(this.mIsDiffArea ? Statistics.Mean : Statistics.Maximum);
                    this.mVarsTable.getModel().setValueAt(this.formatNameString(this.mHighStat), 0, 1);
                }
                if (this.mLowStat != this.mWorkStat) {
                    this.mLowStat.setStat(this.mIsDiffArea ? Statistics.Mean : Statistics.Minimum);
                    this.mVarsTable.getModel().setValueAt(this.formatNameString(this.mLowStat), 1, 1);
                }
                if (!this.mIsDiffArea && this.mCloseStat != this.mWorkStat) {
                    this.mCloseStat.setStat(Statistics.Mean);
                    this.mVarsTable.getModel().setValueAt(this.formatNameString(this.mCloseStat), 2, 1);
                }
            }
            this.mInReload = false;
        }
        return true;
    }

    String formatNameString(ElementStat elementStat) {
        String string;
        int n = this.parameterCount(elementStat.getStat());
        if (n == 1) {
            String string2 = elementStat.getStat().getUserString(this.mCanvas.getResources());
            string = String.format(string2, elementStat.getStrParm1());
        } else if (n == 2) {
            String string3 = elementStat.getStat().getUserString(this.mCanvas.getResources());
            string = String.format(string3, elementStat.getStrParm1(), elementStat.getStrParm2());
        } else {
            string = elementStat.getStat().getUserString(this.mCanvas.getResources());
        }
        return string;
    }

    class HiLoCellRenderer
    extends DefaultTableCellRenderer {
        private Border mEmptyBorder = new EmptyBorder(1, 1, 1, 1);

        HiLoCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                if (jTable.hasFocus()) {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                } else {
                    this.setBackground(Color.lightGray);
                    this.setForeground(Color.black);
                }
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setFont(jTable.getFont());
            if (bl2) {
                Border border = null;
                if (bl) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.setBorder(border);
            } else {
                this.setBorder(this.mEmptyBorder);
            }
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                if (((String)object).indexOf(58) != -1 && ((String)object).indexOf(58) < ((String)object).length() - 1) {
                    this.setValue(ComponentState.prepareStringForBidiRendering((String)((String)object).substring(0, ((String)object).indexOf(58) + 1)) + '\u200f' + ((String)object).substring(((String)object).indexOf(58) + 1));
                } else {
                    this.setValue(ComponentState.prepareStringForBidiRendering((String)((String)object)));
                }
            } else {
                this.setValue(object);
            }
            return this;
        }
    }
}

