/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BarStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.HiLoStatsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.InterpolationStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.MarkerStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;

public class HiLoElementPanel
extends ElementPanel {
    private MarkerStylePanel mMarkerStylePanel;
    private InterpolationStylePanel mInterpolationStylePanel;
    private boolean mIsDiffArea = false;

    public HiLoElementPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
    }

    @Override
    public String getPanelId() {
        return "hilo_panel";
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        boolean bl = this.mCanvas.getImager().isDifferenceArea();
        if (this.mIsDiffArea != bl) {
            this.mIsDiffArea = bl;
            this.swapPanels();
        }
        Props.ElProps elProps = (Props.ElProps)props;
        this.mStatsPanel.initialize(chartProps, elProps);
        if (this.mIsDiffArea) {
            this.mInterpolationStylePanel.initialize(elProps);
        } else {
            this.mStylePanel.initialize(elProps);
            this.mMarkerStylePanel.initialize(elProps);
        }
    }

    @Override
    boolean applyChanges() {
        boolean bl = this.mStatsPanel.applyChanges();
        if (this.mIsDiffArea) {
            if (bl) {
                bl = this.mInterpolationStylePanel.applyChanges();
            }
        } else {
            if (bl) {
                bl = this.mStylePanel.applyChanges();
            }
            if (bl) {
                bl = this.mMarkerStylePanel.applyChanges();
            }
        }
        return bl;
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        super.addTabTraversalComponents(vector);
        if (this.mMarkerStylePanel != null) {
            this.mMarkerStylePanel.addTabTraversalComponents(vector);
        }
    }

    @Override
    protected void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mStatsPanel = new HiLoStatsPanel(this.mCanvas, this.mModListener);
        DialogUtil.addUsingGBL(this, this.mStatsPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mStylePanel = new BarStylePanel(this.mCanvas, this.mModListener);
        DialogUtil.addUsingGBL(this, this.mStylePanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mMarkerStylePanel = new MarkerStylePanel(this.mCanvas, this.mModListener);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.mMarkerStylePanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mInterpolationStylePanel = new InterpolationStylePanel(this.mCanvas, this.mModListener);
    }

    private void swapPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        if (this.mIsDiffArea) {
            this.remove(this.mStylePanel);
            this.remove(this.mMarkerStylePanel);
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(this, this.mInterpolationStylePanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        } else {
            this.remove(this.mInterpolationStylePanel);
            DialogUtil.addUsingGBL(this, this.mStylePanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(this, this.mMarkerStylePanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        }
    }
}

