/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneMgr;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.ModifyLegendZoneEdit;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class GroupingZoneDlg
extends BaseSubDialog {
    public static final int STACK = 1;
    public static final int CLUSTER_X = 2;
    public static final int CLUSTER_Z = 4;
    private ChartBuilderDlg mParentDlg;
    private DropZone mZone;
    private boolean mShowVarLabels;
    private boolean mOldColorsSelected = false;
    private int mOldArrangement = 0;
    private JLabel mGroupingLabel;
    private JLabel mVariable;
    private JLabel mAestheticLabel;
    private JComboBox mAestheticCombo;
    private JLabel mArrangementLabel;
    private JComboBox mArrangementCombo;

    public GroupingZoneDlg(ChartBuilderDlg chartBuilderDlg, DropZone dropZone) {
        super(chartBuilderDlg, chartBuilderDlg.getResString("IDS_GROUPING_DLG_TITLE"), true);
        this.mParentDlg = chartBuilderDlg;
        this.mZone = dropZone;
        this.renameContinueAction("IDS_OK");
        this.readDisplayPrefs();
        this.setupData();
        this.pack();
        this.setLocationRelativeTo((Component)((Object)chartBuilderDlg));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idc_cg_help_drop_zone_edit";
    }

    @Override
    public boolean continuePressed() {
        Object object;
        boolean bl;
        boolean bl2 = this.mAestheticCombo.getSelectedIndex() == 0;
        boolean bl3 = bl = this.mOldColorsSelected != bl2;
        if (bl && this.hasTwoAesthetics() && !this.confirmColorSwap()) {
            return false;
        }
        int n = 0;
        boolean bl4 = false;
        if (this.mArrangementCombo.isEnabled()) {
            object = (ArrangementItem)this.mArrangementCombo.getItemAt(this.mArrangementCombo.getSelectedIndex());
            n = ((ArrangementItem)object).getType();
            boolean bl5 = bl4 = this.mOldArrangement != n;
        }
        if (!bl && !bl4) {
            return true;
        }
        object = new ModifyLegendZoneEdit.ModifyContainer(this.mZone, bl4, bl, bl2, n, this.mOldArrangement);
        new ModifyLegendZoneEdit(this.mParentDlg.getCanvas().getUndoManager(), this.mParentDlg, (ModifyLegendZoneEdit.ModifyContainer)object);
        return true;
    }

    private boolean confirmColorSwap() {
        String string;
        String string2;
        if (this.mOldColorsSelected) {
            string2 = this.getResString("IDS_PATTERNS");
            string = this.getResString("IDS_COLORS");
        } else {
            string2 = this.getResString("IDS_COLORS");
            string = this.getResString("IDS_PATTERNS");
        }
        String string3 = this.getResString("ERR_CONFIRM_STYLE_CHANGE");
        String string4 = String.format(string3, string2, string);
        String string5 = VersionInfo.getAppVersionString();
        int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string4, string5, SpssAlertOptionPane.OptionType.YES_NO_OPTION);
        return n == 1;
    }

    private boolean hasTwoAesthetics() {
        int n = 0;
        ZoneMgr zoneMgr = this.mParentDlg.getCanvas().getZoneMgr();
        if (zoneMgr.hasZone(ZoneType.zt_cluster_x)) {
            ++n;
        }
        if (zoneMgr.hasZone(ZoneType.zt_cluster_z)) {
            ++n;
        }
        if (zoneMgr.hasZone(ZoneType.zt_group)) {
            ++n;
        }
        return n > 1;
    }

    private void setupData() {
        Object object;
        if (!this.mZone.isEmpty()) {
            object = this.mZone.getVariables().get(0);
            this.mGroupingLabel.setEnabled(true);
            this.mVariable.setIcon(VariableList.getStandardIcon((ISpssVariable)object));
            String string = this.mShowVarLabels && object.getLabel() != null && object.getLabel().length() > 0 ? object.getLabel() : object.getName();
            this.mVariable.setText(string);
        }
        this.mOldColorsSelected = this.mZone.getUsesColorStyling();
        this.mAestheticCombo.setSelectedIndex(this.mOldColorsSelected ? 0 : 1);
        if (this.mParentDlg.getCanvas().getImager().isOverlayScatter()) {
            this.mGroupingLabel.setEnabled(true);
            this.mAestheticLabel.setEnabled(true);
            this.mGroupingLabel.setText(this.getResString("IDS_XY_PAIRS"));
            this.mAestheticLabel.setText(this.getResString("IDS_PAIRS_BY"));
            this.mArrangementCombo.setSelectedIndex(-1);
            this.mArrangementLabel.setEnabled(false);
            this.mArrangementCombo.setEnabled(false);
        } else {
            this.mArrangementCombo.setModel(new DefaultComboBoxModel<ArrangementItem>(this.getArrangementItems()));
            for (int i = 0; i < this.mArrangementCombo.getModel().getSize(); ++i) {
                object = (ArrangementItem)this.mArrangementCombo.getItemAt(i);
                if (((ArrangementItem)object).getType() == 2 && this.mZone.getZoneType() == ZoneType.zt_cluster_x) {
                    this.mOldArrangement = 2;
                    this.mArrangementCombo.setSelectedIndex(i);
                    break;
                }
                if (((ArrangementItem)object).getType() == 4 && this.mZone.getZoneType() == ZoneType.zt_cluster_z) {
                    this.mOldArrangement = 4;
                    this.mArrangementCombo.setSelectedIndex(i);
                    break;
                }
                if (((ArrangementItem)object).getType() != 1 || this.mZone.getZoneType() != ZoneType.zt_group) continue;
                this.mOldArrangement = 1;
                this.mArrangementCombo.setSelectedIndex(i);
                break;
            }
            this.enableCombos();
        }
    }

    private void enableCombos() {
        CanvasImager canvasImager = this.mParentDlg.getCanvas().getImager();
        Elements elements = canvasImager.getPrimaryElementType();
        if (elements == Elements.point || elements == Elements.line || elements == Elements.polar_interval || elements == Elements.splom) {
            this.mArrangementLabel.setEnabled(false);
            this.mArrangementCombo.setEnabled(false);
            this.mArrangementCombo.setSelectedIndex(-1);
        } else if (elements == Elements.interval || elements == Elements.hilo) {
            this.mArrangementCombo.setEnabled(elements != Elements.hilo);
        } else if (elements == Elements.area || elements == Elements.schema) {
            this.mArrangementCombo.setEnabled(false);
        }
    }

    private void readDisplayPrefs() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node("general");
        this.mShowVarLabels = preferences3.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS).equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
    }

    @Override
    protected void init() {
        super.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, n2, 3, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mGroupingLabel = new JLabel(this.getResString("IDS_GROUPING_VAR"));
        this.mGroupingLabel.setEnabled(false);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mGroupingLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.mVariable = new JLabel(" ");
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mVariable, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mAestheticLabel = new JLabel(this.getResString("IDS_GROUPING_PROMPT"));
        this.mAestheticLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_GROUPING_PROMPT_KEY"));
        insets = new Insets(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mAestheticLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        String[] stringArray = new String[]{this.getResString("IDS_COLOR"), this.getResString("IDS_PATTERN")};
        insets = new Insets(1, n2, n2, n2);
        this.mAestheticCombo = new JComboBox<String>(stringArray);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mAestheticCombo, gridBagConstraints, 0, 3, 1, 1, n, insets);
        JLabel jLabel = new JLabel("           ");
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.mArrangementLabel = new JLabel(this.getResString("IDS_ARRANGEMENT_PROMPT"));
        this.mArrangementLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_ARRANGEMENT_PROMPT_KEY"));
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mArrangementLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.mArrangementCombo = new JComboBox();
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(1, n2, n2, n2);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mArrangementCombo, gridBagConstraints, 0, 5, 1, 1, n, insets);
        this.mAestheticLabel.setLabelFor(this.mAestheticCombo);
        this.mArrangementLabel.setLabelFor(this.mArrangementCombo);
    }

    private ArrangementItem[] getArrangementItems() {
        CanvasImager canvasImager = this.mParentDlg.getCanvas().getImager();
        int n = this.getValidZoneTypes();
        int n2 = this.getCurrentZoneTypes(canvasImager);
        int n3 = this.getZoneType();
        int n4 = n & ~n2 | n3;
        Vector<ArrangementItem> vector = new Vector<ArrangementItem>();
        if ((n4 & 2) != 0) {
            vector.add(new ArrangementItem(this.getResString("IDS_CLUSTER_X"), 2));
        }
        if ((n4 & 4) != 0) {
            vector.add(new ArrangementItem(this.getResString("IDS_CLUSTER_Z"), 4));
        }
        if ((n4 & 1) != 0) {
            vector.add(new ArrangementItem(this.getResString("IDS_STACK"), 1));
        }
        ArrangementItem[] arrangementItemArray = new ArrangementItem[vector.size()];
        return vector.toArray(arrangementItemArray);
    }

    private int getValidZoneTypes() {
        int n = 7;
        boolean bl = this.mParentDlg.getCanvas().getZoneMgr().hasScaleVar(ZoneType.zt_x);
        boolean bl2 = this.mParentDlg.getCanvas().getZoneMgr().hasScaleVar(ZoneType.zt_z);
        if (bl) {
            n &= 0xFFFFFFFD;
        }
        if (bl2 || this.mParentDlg.getCanvas().getImager().getCoordinates() != Coords.coords_3D) {
            n &= 0xFFFFFFFB;
        }
        if (!this.canStack()) {
            n &= 0xFFFFFFFE;
        }
        return n;
    }

    private boolean canStack() {
        Elements elements;
        Vector<ISpssVariable> vector;
        boolean bl = false;
        ChartCanvas chartCanvas = this.mParentDlg.getCanvas();
        DropZone dropZone = chartCanvas.getZoneMgr().getZone(ZoneType.zt_y);
        Vector<ISpssVariable> vector2 = vector = dropZone != null ? dropZone.getVariables() : null;
        if (vector != null && vector.size() > 0) {
            elements = vector.get(0);
            bl = elements.getFormat().getFormatType().isDateOrTimeFormat();
        }
        return !bl || (elements = chartCanvas.getImager().getPrimaryElementType()) != Elements.interval && elements != Elements.area;
    }

    private int getCurrentZoneTypes(CanvasImager canvasImager) {
        int n = 0;
        if (canvasImager.hasXCluster()) {
            n |= 2;
        }
        if (canvasImager.hasZCluster()) {
            n |= 4;
        }
        if (canvasImager.hasGrouping()) {
            n |= 1;
        }
        return n;
    }

    private int getZoneType() {
        int n = 0;
        if (this.mZone.getZoneType() == ZoneType.zt_cluster_x) {
            n = 2;
        } else if (this.mZone.getZoneType() == ZoneType.zt_cluster_z) {
            n = 4;
        } else if (this.mZone.getZoneType() == ZoneType.zt_group) {
            n = 1;
        }
        return n;
    }

    class ArrangementItem {
        private String mName;
        private int mType;

        public ArrangementItem(String string, int n) {
            this.mName = string;
            this.mType = n;
        }

        public int getType() {
            return this.mType;
        }

        public String toString() {
            return this.mName;
        }
    }
}

