/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartLib;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartPrototype;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GalleryNamesDlg
extends BaseDialog
implements ListSelectionListener,
DocumentListener {
    private ChartLib mLibrary;
    private JTextField mTitleField;
    private JList mNamesList;
    private JButton mApplyButton;
    private boolean mSelectionChange;

    public GalleryNamesDlg(BaseDialog baseDialog, ChartLib chartLib) {
        super(baseDialog, baseDialog.getResString("IDS_NAMES_TITLE"), true, baseDialog.getResourceBundle(), null);
        this.mLibrary = chartLib;
        this.fillLibraryList();
        this.mSelectionChange = false;
        this.mNamesList.addListSelectionListener(this);
        this.mTitleField.getDocument().addDocumentListener(this);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height += 40;
        this.setSize(dimension);
        this.setLocationRelativeTo((Component)baseDialog);
    }

    public void doHelp() {
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_G_NAMES_PROMPT"));
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.mTitleField = new JTextField();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = (Insets)DialogUtil.getStandardButtonInsets().clone();
        insets2.bottom = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTitleField, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mNamesList = new JList(new DefaultListModel());
        Insets insets3 = (Insets)DialogUtil.getStandardButtonInsets().clone();
        insets3.top = 1;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mNamesList);
        jScrollPane.setMinimumSize(new Dimension(200, 240));
        jScrollPane.setPreferredSize(new Dimension(200, 240));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 2, 1, 3, n, insets3);
        this.mNamesList.setSelectionMode(0);
        this.mApplyButton = new JButton(new ApplyChangeAction());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mApplyButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mApplyButton.setEnabled(false);
        JLabel jLabel = new JLabel("");
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        JButton jButton = new JButton(new ExportAction());
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 3, 1, 1, n, insets);
        JButton jButton2 = new JButton(new ImportAction());
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 4, 1, 1, n, insets);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        OKAction oKAction = new OKAction();
        JButton jButton = new JButton(oKAction);
        JButton jButton2 = new JButton(new CancelAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 24;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jButton = new JButton(new OKAction());
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void fillLibraryList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mNamesList.getModel();
        defaultListModel.clear();
        Vector<ChartPrototype> vector = new Vector<ChartPrototype>();
        this.mLibrary.getPrototypes(-1, vector);
        for (ChartPrototype chartPrototype : vector) {
            defaultListModel.addElement(chartPrototype.getTitle());
        }
    }

    private void saveLibraryList() {
        Vector<ChartPrototype> vector = new Vector<ChartPrototype>();
        this.mLibrary.getPrototypes(-1, vector);
        if (vector.size() == 0) {
            return;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.mNamesList.getModel();
        for (int i = 0; i < vector.size() && i < defaultListModel.getSize(); ++i) {
            vector.get(i).setTitle(defaultListModel.getElementAt(i).toString());
        }
        this.mLibrary.setModified(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.mApplyButton.setEnabled(false);
        }
        if (this.mNamesList.getSelectedValue() == null) {
            return;
        }
        this.mSelectionChange = true;
        this.mTitleField.setText(this.mNamesList.getSelectedValue().toString());
        this.mSelectionChange = false;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableApplyButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableApplyButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableApplyButton();
    }

    private void enableApplyButton() {
        if (!this.mSelectionChange) {
            this.mApplyButton.setEnabled(true);
        }
    }

    class ImportAction
    extends AbstractAction {
        ImportAction() {
            this.putValue("Name", GalleryNamesDlg.this.getResString("IDS_IMPORT_NAMES"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GalleryNamesDlg.this.mApplyButton.setEnabled(false);
            JFileChooser jFileChooser = new JFileChooser(FileLocationsUtil.getOtherFilesDirectoryPath());
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.setDialogTitle("Choose an Import File");
            jFileChooser.setDialogType(0);
            if (jFileChooser.showOpenDialog((Component)((Object)GalleryNamesDlg.this)) == 0) {
                FileLocationsUtil.setOtherFilesDirectoryPath((String)jFileChooser.getCurrentDirectory().getAbsolutePath());
                File file = jFileChooser.getSelectedFile();
                try {
                    String string;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                    DefaultListModel defaultListModel = (DefaultListModel)GalleryNamesDlg.this.mNamesList.getModel();
                    DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
                    while ((string = bufferedReader.readLine()) != null) {
                        defaultListModel2.addElement(string);
                    }
                    if (defaultListModel2.getSize() != defaultListModel.getSize()) {
                        JOptionPane.showMessageDialog((Component)((Object)GalleryNamesDlg.this), "Number of lines in the input file does not match those in the list - no changes made.");
                        bufferedReader.close();
                        return;
                    }
                    GalleryNamesDlg.this.mNamesList.setModel(defaultListModel2);
                    JOptionPane.showMessageDialog((Component)((Object)GalleryNamesDlg.this), "Chart names loaded in UTF-8 format from file " + file.getPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog((Component)((Object)GalleryNamesDlg.this), "Error reading file " + file.getPath());
                }
            }
        }
    }

    class ExportAction
    extends AbstractAction {
        ExportAction() {
            this.putValue("Name", GalleryNamesDlg.this.getResString("IDS_EXPORT_NAMES"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GalleryNamesDlg.this.mApplyButton.setEnabled(false);
            JFileChooser jFileChooser = new JFileChooser(FileLocationsUtil.getOtherFilesDirectoryPath());
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.setDialogTitle("Choose an Export File");
            jFileChooser.setDialogType(1);
            if (jFileChooser.showSaveDialog((Component)((Object)GalleryNamesDlg.this)) == 0) {
                FileOutputStream fileOutputStream;
                FileLocationsUtil.setOtherFilesDirectoryPath((String)jFileChooser.getCurrentDirectory().getAbsolutePath());
                File file = jFileChooser.getSelectedFile();
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    JOptionPane.showMessageDialog((Component)((Object)GalleryNamesDlg.this), "Error writing file " + file.getPath());
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer(256);
                DefaultListModel defaultListModel = (DefaultListModel)GalleryNamesDlg.this.mNamesList.getModel();
                for (int i = 0; i < defaultListModel.getSize(); ++i) {
                    stringBuffer.append(defaultListModel.getElementAt(i).toString()).append("\r\n");
                }
                try {
                    byte[] byArray = new byte[]{-17, -69, -65};
                    fileOutputStream.write(byArray);
                    byte[] byArray2 = stringBuffer.toString().getBytes("UTF-8");
                    fileOutputStream.write(byArray2);
                    fileOutputStream.close();
                    JOptionPane.showMessageDialog((Component)((Object)GalleryNamesDlg.this), "Chart names saved in UTF-8 format to file " + file.getPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog((Component)((Object)GalleryNamesDlg.this), "Error writing file " + file.getPath());
                }
            }
        }
    }

    class ApplyChangeAction
    extends AbstractAction {
        ApplyChangeAction() {
            this.putValue("Name", GalleryNamesDlg.this.getResString("IDS_APPLY_CHANGE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (GalleryNamesDlg.this.mNamesList.getSelectedIndex() < 0) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)GalleryNamesDlg.this.mNamesList.getModel();
            defaultListModel.setElementAt(GalleryNamesDlg.this.mTitleField.getText(), GalleryNamesDlg.this.mNamesList.getSelectedIndex());
            GalleryNamesDlg.this.mApplyButton.setEnabled(false);
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GalleryNamesDlg.this.dispose();
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (GalleryNamesDlg.this.mApplyButton.isEnabled() && (n = JOptionPane.showConfirmDialog((Component)((Object)GalleryNamesDlg.this), "Discard changes?", "Changes Not Applied", 0)) != 0) {
                return;
            }
            GalleryNamesDlg.this.saveLibraryList();
            GalleryNamesDlg.this.dispose();
        }
    }
}

