/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IErrorBarListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.SidePropertiesPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ErrorBarsPanel
extends JPanel
implements DocumentListener,
IPropEnum,
ActionListener,
FocusListener {
    private Props.ElProps mElProp = null;
    private ChartCanvas mCanvas;
    private IModListener mModListener;
    private boolean mStatIsMean;
    private Statistics mStatistic;
    private boolean mInReload;
    private Vector<IErrorBarListener> mErrorBarListeners = new Vector();
    private JCheckBox mShowErrorBarsCheck;
    private JRadioButton mConfIntRadio;
    private JRadioButton mStdErrRadio;
    private JRadioButton mStdDevRadio;
    private JLabel mConfIntLabel;
    private JLabel mStdErrLabel;
    private JLabel mStdDevLabel;
    private FloatTextField mConfIntEdit;
    private FloatTextField mStdErrEdit;
    private FloatTextField mStdDevEdit;
    private SpssButtonGroup mButtonGroup;
    private boolean mIsEditFieldDirty = false;

    public ErrorBarsPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(new GridBagLayout(), true);
        this.mCanvas = chartCanvas;
        this.mModListener = iModListener;
        this.mStatIsMean = false;
        this.mInReload = false;
        this.initControls();
        this.mConfIntEdit.getDocument().addDocumentListener(this);
        this.mConfIntEdit.addFocusListener((FocusListener)this);
        this.mStdErrEdit.getDocument().addDocumentListener(this);
        this.mStdErrEdit.addActionListener((ActionListener)this);
        this.mStdErrEdit.addFocusListener((FocusListener)this);
        this.mStdDevEdit.getDocument().addDocumentListener(this);
        this.mStdDevEdit.addActionListener((ActionListener)this);
        this.mStdDevEdit.addFocusListener((FocusListener)this);
        this.mShowErrorBarsCheck.addActionListener(this);
    }

    void initialize(Props.ElProps elProps) {
        this.mInReload = true;
        this.mElProp = elProps;
        this.mStatistic = this.mElProp.getStatistic().getStat();
        this.mStatIsMean = this.mStatistic == Statistics.Mean;
        int n = this.mElProp.getFlags();
        this.mShowErrorBarsCheck.setSelected((n & 0x10) != 0);
        IPropEnum.ErrorIntervalType errorIntervalType = this.mElProp.getErrorIntervalType();
        if (errorIntervalType == IPropEnum.ErrorIntervalType.eit_Confidence) {
            this.mConfIntRadio.setSelected(true);
        } else if (errorIntervalType == IPropEnum.ErrorIntervalType.eit_MultStdError) {
            this.mStdErrRadio.setSelected(true);
        } else if (errorIntervalType == IPropEnum.ErrorIntervalType.eit_MultStdDev) {
            this.mStdDevRadio.setSelected(true);
        }
        this.mConfIntEdit.setText(DialogUtil.formatDouble(this.mElProp.getLevel()));
        this.mStdErrEdit.setText(DialogUtil.formatDouble(this.mElProp.getMultiplierStdError()));
        this.mStdDevEdit.setText(DialogUtil.formatDouble(this.mElProp.getMultiplierStdDev()));
        this.updateEditControls();
        this.updateParmsForErrorBars();
        this.mInReload = false;
    }

    public boolean applyChanges() {
        if (!this.validateContent()) {
            return false;
        }
        int n = this.mElProp.getFlags();
        n = this.mShowErrorBarsCheck.isEnabled() && this.mShowErrorBarsCheck.isSelected() ? (n |= 0x10) : (n &= 0xFFFFFFEF);
        this.mElProp.setFlags(n);
        if ((n & 0x10) != 0) {
            if (this.mConfIntRadio.isSelected()) {
                this.mElProp.setErrorIntervalType(IPropEnum.ErrorIntervalType.eit_Confidence);
                double d = Double.valueOf(this.mConfIntEdit.getText());
                this.mElProp.setLevel(d);
            } else if (this.mStdErrRadio.isSelected()) {
                this.mElProp.setErrorIntervalType(IPropEnum.ErrorIntervalType.eit_MultStdError);
                double d = Double.valueOf(this.mStdErrEdit.getText());
                this.mElProp.setMultiplierStdError(d);
            } else if (this.mStdDevRadio.isSelected()) {
                this.mElProp.setErrorIntervalType(IPropEnum.ErrorIntervalType.eit_MultStdDev);
                double d = Double.valueOf(this.mStdDevEdit.getText());
                this.mElProp.setMultiplierStdDev(d);
            }
        }
        this.mIsEditFieldDirty = false;
        return true;
    }

    void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mShowErrorBarsCheck);
        vector.add(this.mButtonGroup);
        vector.add(this.mConfIntEdit);
        vector.add(this.mStdErrEdit);
        vector.add(this.mStdDevEdit);
    }

    boolean errorBarsSelected() {
        return this.mShowErrorBarsCheck.isSelected();
    }

    void statChanged(Statistics statistics) {
        this.mStatistic = statistics;
        boolean bl = this.mStatIsMean = statistics == Statistics.Mean;
        if (!this.mStatIsMean && !this.mConfIntRadio.isSelected()) {
            this.mConfIntRadio.setSelected(true);
        }
        this.updateEditControls();
        this.updateErrorBarFootnote();
    }

    void addErrorBarSelectionListener(IErrorBarListener iErrorBarListener) {
        if (!this.mErrorBarListeners.contains(iErrorBarListener)) {
            this.mErrorBarListeners.add(iErrorBarListener);
        }
    }

    void removeErrorBarSelectionListener(IErrorBarListener iErrorBarListener) {
        this.mErrorBarListeners.remove(iErrorBarListener);
    }

    void updateErrorBarFootnote() {
        try {
            double d;
            IPropEnum.ErrorIntervalType errorIntervalType;
            boolean bl;
            boolean bl2 = bl = this.mShowErrorBarsCheck.isSelected() && this.mShowErrorBarsCheck.isEnabled();
            if (this.mStdErrRadio.isSelected()) {
                errorIntervalType = IPropEnum.ErrorIntervalType.eit_MultStdError;
                d = Double.valueOf(this.mStdErrEdit.getText());
            } else if (this.mStdDevRadio.isSelected()) {
                errorIntervalType = IPropEnum.ErrorIntervalType.eit_MultStdDev;
                d = Double.valueOf(this.mStdDevEdit.getText());
            } else {
                errorIntervalType = IPropEnum.ErrorIntervalType.eit_Confidence;
                d = Double.valueOf(this.mConfIntEdit.getText());
            }
            this.getParentPropertiesPanel().updateErrorBarFootnote(errorIntervalType, d, bl);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.mInReload) {
            this.updateErrorBarFootnote();
            this.updateParmsForErrorBars();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.mInReload) {
            this.mIsEditFieldDirty = true;
            this.updateErrorBarFootnote();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.mInReload) {
            this.mIsEditFieldDirty = true;
            this.updateErrorBarFootnote();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (this.mIsEditFieldDirty && (object == this.mConfIntEdit || object == this.mStdDevEdit || object == this.mStdErrEdit)) {
            this.mModListener.itemModified();
            this.mIsEditFieldDirty = false;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this.mInReload) {
            this.updateErrorBarFootnote();
            this.mModListener.itemModified();
        }
    }

    void enableAllControls(boolean bl) {
        this.mConfIntRadio.setEnabled(bl);
        this.mStdErrRadio.setEnabled(bl && this.mStatIsMean);
        this.mStdDevRadio.setEnabled(bl && this.mStatIsMean);
        this.enableEditControls(RadioType.conf_interval, bl && this.mConfIntRadio.isSelected());
        this.enableEditControls(RadioType.std_err, bl && this.mStdErrRadio.isSelected());
        this.enableEditControls(RadioType.std_dev, bl && this.mStdDevRadio.isSelected());
    }

    private void updateParmsForErrorBars() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof ChartBuilderDlg) {
            ChartBuilderDlg chartBuilderDlg = (ChartBuilderDlg)((Object)container);
            chartBuilderDlg.getSidePropertiesPanel().notifyErrorBarChange(this.mShowErrorBarsCheck.isSelected());
        }
    }

    private boolean validateContent() {
        String string;
        Double d;
        if (!this.mShowErrorBarsCheck.isSelected()) {
            return true;
        }
        boolean bl = true;
        FloatTextField floatTextField = null;
        if (this.mConfIntRadio.isSelected()) {
            String string2 = this.mConfIntEdit.getText();
            Double d2 = string2 != null && string2.length() > 0 ? Double.valueOf(string2) : -1.0;
            if (d2 < 50.0 || d2 > 99.9) {
                bl = false;
                floatTextField = this.mConfIntEdit;
            }
        } else if (this.mStdErrRadio.isSelected()) {
            String string3 = this.mStdErrEdit.getText();
            Double d3 = string3 != null && string3.length() > 0 ? Double.valueOf(string3) : -1.0;
            if (d3 < 1.0 || d3 > 99999.0) {
                bl = false;
                floatTextField = this.mStdErrEdit;
            }
        } else if (this.mStdDevRadio.isSelected() && ((d = Double.valueOf((string = this.mStdDevEdit.getText()) != null && string.length() > 0 ? Double.valueOf(string) : -1.0)) < 1.0 || d > 99999.0)) {
            bl = false;
            floatTextField = this.mStdDevEdit;
        }
        if (!bl) {
            SpssAlertOptionPane.showInformationMessageDialog(this, ResUtil.getCommonDlgString("ERR_OUT_OF_RANGE_ERROR_MSG"), VersionInfo.getAppVersionString());
            final FloatTextField floatTextField2 = floatTextField;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    floatTextField2.requestFocusInWindow();
                    floatTextField2.selectAll();
                }
            });
        }
        return bl;
    }

    private void updateEditControls() {
        this.enableAllControls(false);
        boolean bl = this.isValidState();
        this.mShowErrorBarsCheck.setEnabled(bl);
        if (bl && this.mShowErrorBarsCheck.isSelected()) {
            this.mConfIntRadio.setEnabled(true);
            this.mStdErrRadio.setEnabled(this.mStatIsMean);
            this.mStdDevRadio.setEnabled(this.mStatIsMean);
            if (this.mConfIntRadio.isSelected()) {
                this.enableEditControls(RadioType.conf_interval, true);
            } else if (this.mStdErrRadio.isSelected()) {
                this.enableEditControls(RadioType.std_err, true);
            } else if (this.mStdDevRadio.isSelected()) {
                this.enableEditControls(RadioType.std_dev, true);
            }
        }
    }

    private boolean isValidState() {
        CanvasImager canvasImager = this.mCanvas.getImager();
        Coords coords = canvasImager.getCoordinates();
        if (coords != Coords.coords_2D && coords != Coords.coords_3D && coords != Coords.coords_DualY) {
            return false;
        }
        if (canvasImager.isSplom() || canvasImager.isHiLoClose() || canvasImager.isSchema()) {
            return false;
        }
        if (this.mCanvas.getZoneMgr().hasCatVar(ZoneType.zt_y)) {
            return false;
        }
        SidePropertiesPanel sidePropertiesPanel = this.getParentPropertiesPanel();
        if (sidePropertiesPanel.hasCollapsedVars()) {
            return false;
        }
        boolean bl = canvasImager.hasElementStacking() && canvasImager.hasGrouping();
        return !bl && (this.mStatistic == Statistics.Count || this.mStatistic == Statistics.Mean || this.mStatistic == Statistics.Median || this.mStatistic == Statistics.PctOfCases);
    }

    private SidePropertiesPanel getParentPropertiesPanel() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof SidePropertiesPanel); container = container.getParent()) {
        }
        return container != null ? (SidePropertiesPanel)container : null;
    }

    private void enableEditControls(RadioType radioType, boolean bl) {
        if (radioType == RadioType.conf_interval) {
            this.mConfIntLabel.setEnabled(bl);
            this.mConfIntEdit.setEnabled(bl);
        } else if (radioType == RadioType.std_err) {
            this.mStdErrLabel.setEnabled(bl && this.mStatIsMean);
            this.mStdErrEdit.setEnabled(bl && this.mStatIsMean);
        } else {
            this.mStdDevLabel.setEnabled(bl && this.mStatIsMean);
            this.mStdDevEdit.setEnabled(bl && this.mStatIsMean);
        }
    }

    private void initControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, n2, 0, n2);
        this.mShowErrorBarsCheck = new JCheckBox(new ShowErrorBarsAction());
        DialogUtil.addUsingGBL(this, this.mShowErrorBarsCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mCanvas.getResources().getResString("IDS_EBARS_REP")));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n, null);
        this.mButtonGroup = new SpssButtonGroup();
        this.mConfIntRadio = new JRadioButton(new RadioSelectAction(RadioType.conf_interval));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mConfIntRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.mButtonGroup.add(this.mConfIntRadio);
        this.mConfIntLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_EBAR_LEVEL"));
        this.mConfIntLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_EBAR_LEVEL_KEY"));
        this.mConfIntLabel.setVerticalAlignment(3);
        Insets insets2 = new Insets(1, n2 * 5, 1, n2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mConfIntLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mConfIntEdit = new FloatTextField(true);
        this.mConfIntEdit.setColumns(6);
        this.mConfIntLabel.setLabelFor((Component)this.mConfIntEdit);
        Insets insets3 = new Insets(0, 0, 1, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfIntEdit, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        this.mStdErrRadio = new JRadioButton(new RadioSelectAction(RadioType.std_err));
        DialogUtil.addUsingGBL(jPanel, this.mStdErrRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.mButtonGroup.add(this.mStdErrRadio);
        this.mStdErrLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_STD_ERR_MULT"));
        this.mStdErrLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_STD_ERR_MULT_KEY"));
        this.mStdErrLabel.setVerticalAlignment(3);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mStdErrLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        this.mStdErrEdit = new FloatTextField(true);
        this.mStdErrEdit.setColumns(6);
        this.mStdErrLabel.setLabelFor((Component)this.mStdErrEdit);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStdErrEdit, gridBagConstraints, 1, 3, 1, 1, n, insets3);
        this.mStdDevRadio = new JRadioButton(new RadioSelectAction(RadioType.std_dev));
        DialogUtil.addUsingGBL(jPanel, this.mStdDevRadio, gridBagConstraints, 0, 4, 2, 1, n, insets);
        this.mButtonGroup.add(this.mStdDevRadio);
        this.mStdDevLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_STD_DEV_MULT"));
        this.mStdDevLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_STD_DEV_MULT_KEY"));
        this.mStdDevLabel.setVerticalAlignment(3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mStdDevLabel, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        this.mStdDevEdit = new FloatTextField(true);
        this.mStdDevEdit.setColumns(6);
        this.mStdDevLabel.setLabelFor((Component)this.mStdDevEdit);
        gridBagConstraints.weightx = 1.0;
        insets3 = new Insets(0, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStdDevEdit, gridBagConstraints, 1, 5, 1, 1, n, insets3);
    }

    private static enum RadioType {
        conf_interval,
        std_err,
        std_dev;

    }

    class RadioSelectAction
    extends AbstractAction {
        private RadioType mRadioType;

        RadioSelectAction(RadioType radioType) {
            this.mRadioType = radioType;
            if (this.mRadioType == RadioType.conf_interval) {
                this.putValue("Name", ErrorBarsPanel.this.mCanvas.getResources().getResString("IDS_CONF_INT"));
                this.putValue("MnemonicKey", ErrorBarsPanel.this.mCanvas.getResources().getDlgAccessKey("IDK_CONF_INT_KEY"));
            } else if (this.mRadioType == RadioType.std_err) {
                this.putValue("Name", ErrorBarsPanel.this.mCanvas.getResources().getResString("IDS_STD_ERR"));
                this.putValue("MnemonicKey", ErrorBarsPanel.this.mCanvas.getResources().getDlgAccessKey("IDK_STD_ERR_KEY"));
            } else {
                this.putValue("Name", ErrorBarsPanel.this.mCanvas.getResources().getResString("IDS_STD_DEV"));
                this.putValue("MnemonicKey", ErrorBarsPanel.this.mCanvas.getResources().getDlgAccessKey("IDK_STD_DEV_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.mRadioType == RadioType.conf_interval) {
                ErrorBarsPanel.this.enableEditControls(RadioType.conf_interval, true);
                ErrorBarsPanel.this.enableEditControls(RadioType.std_err, false);
                ErrorBarsPanel.this.enableEditControls(RadioType.std_dev, false);
            } else if (this.mRadioType == RadioType.std_err) {
                ErrorBarsPanel.this.enableEditControls(RadioType.conf_interval, false);
                ErrorBarsPanel.this.enableEditControls(RadioType.std_err, true);
                ErrorBarsPanel.this.enableEditControls(RadioType.std_dev, false);
            } else {
                ErrorBarsPanel.this.enableEditControls(RadioType.conf_interval, false);
                ErrorBarsPanel.this.enableEditControls(RadioType.std_err, false);
                ErrorBarsPanel.this.enableEditControls(RadioType.std_dev, true);
            }
            if (!ErrorBarsPanel.this.mInReload) {
                ErrorBarsPanel.this.updateErrorBarFootnote();
                ErrorBarsPanel.this.mModListener.itemModified();
            }
        }
    }

    class ShowErrorBarsAction
    extends AbstractAction {
        ShowErrorBarsAction() {
            this.putValue("Name", ErrorBarsPanel.this.mCanvas.getResources().getResString("IDS_SHOW_ERROR_BARS"));
            this.putValue("MnemonicKey", ErrorBarsPanel.this.mCanvas.getResources().getDlgAccessKey("IDK_SHOW_ERROR_BARS_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ErrorBarsPanel.this.enableAllControls(ErrorBarsPanel.this.mShowErrorBarsCheck.isSelected());
            if (!ErrorBarsPanel.this.mInReload) {
                ErrorBarsPanel.this.mModListener.itemModified();
                for (IErrorBarListener iErrorBarListener : ErrorBarsPanel.this.mErrorBarListeners) {
                    iErrorBarListener.errorBarStateChanged(ErrorBarsPanel.this.mShowErrorBarsCheck.isSelected());
                }
            }
        }
    }
}

