/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BarStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BaseStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ErrorBarsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IStatChangeListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.InterpolationStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.PointStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.PropertiesPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.StatisticsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;

public class ElementPanel
extends PropertiesPanel
implements IStatChangeListener,
ActionListener {
    protected StatisticsPanel mStatsPanel = null;
    protected ErrorBarsPanel mErrorBarsPanel = null;
    protected BaseStylePanel mStylePanel = null;
    protected JCheckBox mNormalCurveCheck = null;
    protected boolean mShowNormalCurve = false;
    protected Props.ElProps mElProp;
    protected boolean mInReload = false;
    protected Statistics mStatistic;

    public ElementPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.init();
        if (this.mStatsPanel != null) {
            this.mStatsPanel.addStatChangeListener(this);
        }
        if (this.mNormalCurveCheck != null) {
            this.mNormalCurveCheck.addActionListener(this);
        }
    }

    @Override
    public String getPanelId() {
        return "element_panel";
    }

    @Override
    public void statisticChanged(Statistics statistics) {
        boolean bl;
        this.mStatistic = statistics;
        if (this.mErrorBarsPanel != null) {
            this.mErrorBarsPanel.statChanged(statistics);
        }
        if (this.mStylePanel != null) {
            this.mStylePanel.statChanged(statistics);
        }
        boolean bl2 = bl = statistics == Statistics.Histogram || statistics == Statistics.HistogramPct;
        if (bl != this.mShowNormalCurve) {
            this.showNormalCurveCtrl(bl);
        }
    }

    @Override
    boolean canApply() {
        boolean bl = true;
        if (this.mElProp != null) {
            bl = true;
            if (this.mStatistic == Statistics.PctOfCases) {
                return true;
            }
            int n = this.mStatsPanel.parameterCount(this.mStatistic);
            if (n > 0) {
                ElementStat elementStat = this.mStatsPanel.mWorkStat;
                boolean bl2 = bl = elementStat.getStrParm1().length() > 0;
                if (bl && n > 1) {
                    bl = elementStat.getStrParm2().length() > 0;
                }
            }
        }
        return bl;
    }

    public StatisticsPanel getStatsPanel() {
        return this.mStatsPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mNormalCurveCheck) {
            this.mModListener.itemModified();
        }
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        this.mStatsPanel.addTabTraversalComponents(vector);
        if (this.mErrorBarsPanel != null) {
            this.mErrorBarsPanel.addTabTraversalComponents(vector);
        }
        if (this.mStylePanel != null) {
            this.mStylePanel.addTabTraversalComponents(vector);
        }
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        boolean bl;
        this.mInReload = true;
        this.mElProp = props instanceof Props.ElProps ? (Props.ElProps)props : chartProps.getElementProp(0);
        this.mStatsPanel.initialize(chartProps, this.mElProp);
        this.mErrorBarsPanel.initialize(this.mElProp);
        this.placeStylePanel(chartProps.getElementProp(0));
        if (this.mStylePanel != null) {
            this.mStylePanel.initialize(this.mElProp);
        }
        this.mStatistic = this.mElProp.getStatistic().getStat();
        boolean bl2 = bl = this.mStatistic == Statistics.Histogram || this.mStatistic == Statistics.HistogramPct;
        if (bl != this.mShowNormalCurve) {
            this.showNormalCurveCtrl(bl);
        }
        if (bl) {
            this.mNormalCurveCheck.setSelected(this.mElProp.getStatistic().getDisplayNormalCurve());
        }
        this.mInReload = false;
    }

    void placeStylePanel(Props.ElProps elProps) {
        this.removeStylePanel();
        this.mStylePanel = this.getStylePanel(elProps);
        if (this.mStylePanel != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            Insets insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(this, this.mStylePanel, gridBagConstraints, 0, 3, 1, 1, n, insets);
            this.handleStyleListener(true);
        }
    }

    @Override
    boolean applyChanges() {
        boolean bl = this.mStatsPanel.applyChanges();
        if (bl) {
            bl = this.mErrorBarsPanel.applyChanges();
        }
        if (bl && this.mStylePanel != null) {
            bl = this.mStylePanel.applyChanges();
        }
        if (bl && this.mShowNormalCurve) {
            this.mElProp.getStatistic().setDisplayNormalCurve(this.mNormalCurveCheck.isSelected());
        }
        return bl;
    }

    boolean errorBarsSelected() {
        return this.mErrorBarsPanel.errorBarsSelected();
    }

    @Override
    protected String getDlgHelpId() {
        return "idh_idc_cg_help_el_props";
    }

    protected void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = 2;
        Insets insets = new Insets(0, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.mStatsPanel = new StatisticsPanel(this.mCanvas, this.mModListener);
        DialogUtil.addUsingGBL(this, this.mStatsPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mNormalCurveCheck = new JCheckBox(this.mCanvas.getResources().getResString("IDS_SHOW_NORMAL_CURVE"));
        this.mNormalCurveCheck.setMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_SHOW_NORMAL_CURVE_KEY"));
        this.mErrorBarsPanel = new ErrorBarsPanel(this.mCanvas, this.mModListener);
        gridBagConstraints.weighty = 0.1;
        DialogUtil.addUsingGBL(this, this.mErrorBarsPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    protected BaseStylePanel getStylePanel(Props.ElProps elProps) {
        if (elProps instanceof Props.BarProps) {
            return new BarStylePanel(this.mCanvas, this.mModListener);
        }
        if (elProps instanceof Props.AreaProps || elProps instanceof Props.LineProps) {
            return new InterpolationStylePanel(this.mCanvas, this.mModListener);
        }
        if (this.mCanvas.getImager().getCoordinates() == Coords.coords_2D && elProps instanceof Props.PointProps) {
            return new PointStylePanel(this.mCanvas, this.mModListener);
        }
        return null;
    }

    protected void removeStylePanel() {
        if (this.mStylePanel != null) {
            this.handleStyleListener(false);
            for (Component component : this.getComponents()) {
                if (component != this.mStylePanel) continue;
                this.remove(component);
                break;
            }
            this.mStylePanel = null;
        }
    }

    private void handleStyleListener(boolean bl) {
        if (this.mStylePanel instanceof PointStylePanel) {
            PointStylePanel pointStylePanel = (PointStylePanel)this.mStylePanel;
            if (bl) {
                this.mErrorBarsPanel.addErrorBarSelectionListener(pointStylePanel);
            } else {
                this.mErrorBarsPanel.removeErrorBarSelectionListener(pointStylePanel);
            }
        }
    }

    private void showNormalCurveCtrl(boolean bl) {
        if (bl) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            int n2 = DialogUtil.getGroupBoxInnerMargin();
            Insets insets = new Insets(0, 2, n2, n2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(this, this.mNormalCurveCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        } else {
            this.remove(this.mNormalCurveCheck);
        }
        this.mShowNormalCurve = bl;
    }
}

