/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ElementPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ErrorBarsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.StatisticsPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DualYElementPanel
extends ElementPanel {
    private JComboBox mAssignedAxisCombo;
    private Statistics mLastStat;

    public DualYElementPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.mAssignedAxisCombo.addActionListener(this);
    }

    @Override
    public String getPanelId() {
        return "dualy_panel";
    }

    @Override
    public void statisticChanged(Statistics statistics) {
        if (!this.mInReload && !this.getParentDialog().getSidePropertiesPanel().checkDualYStat(this.mElProp, statistics)) {
            this.mStatsPanel.selectStat(this.mLastStat);
            return;
        }
        this.mLastStat = statistics;
        super.statisticChanged(statistics);
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mAssignedAxisCombo);
        this.mStatsPanel.addTabTraversalComponents(vector);
        this.mErrorBarsPanel.addTabTraversalComponents(vector);
        if (this.mStylePanel != null) {
            this.mStylePanel.addTabTraversalComponents(vector);
        }
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        this.mInReload = true;
        if (props instanceof Props.ElProps) {
            this.mElProp = (Props.ElProps)props;
        } else assert (false);
        String string = this.mElProp.getStrElAssoc();
        if (string == null || string.length() == 0) {
            string = "1";
        }
        this.mAssignedAxisCombo.setSelectedIndex(string.equals("1") ? 0 : 1);
        this.mLastStat = this.mElProp.getStatistic().getStat();
        this.mStatsPanel.initialize(chartProps, this.mElProp);
        this.mErrorBarsPanel.initialize(this.mElProp);
        this.placeStylePanel(this.mElProp);
        if (this.mStylePanel != null) {
            this.mStylePanel.initialize(this.mElProp);
        }
        this.mInReload = false;
    }

    @Override
    boolean applyChanges() {
        boolean bl = super.applyChanges();
        if (bl) {
            int n = this.mAssignedAxisCombo.getSelectedIndex();
            this.mElProp.setStrElAssoc(Integer.toString(n + 1));
            String string = n == 0 ? "2" : "1";
            this.getParentDialog().getSidePropertiesPanel().setDualYAxisAssociation(this.mElProp, string);
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.mAssignedAxisCombo) {
            this.mModListener.itemModified();
        }
    }

    @Override
    protected void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JLabel jLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_ASSIGNED_Y_AXIS"));
        jLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_ASSIGNED_Y_AXIS_KEY"));
        insets = new Insets(n2, 0, n2, 2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        String string = this.mCanvas.getResources().getResString("IDS_BASE_AXIS");
        String[] stringArray = new String[]{String.format(string, 1), String.format(string, 2)};
        this.mAssignedAxisCombo = new JComboBox<String>(stringArray);
        DialogUtil.addUsingGBL(jPanel, this.mAssignedAxisCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jLabel.setLabelFor(this.mAssignedAxisCombo);
        this.mStatsPanel = new StatisticsPanel(this.mCanvas, this.mModListener);
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(this, this.mStatsPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mErrorBarsPanel = new ErrorBarsPanel(this.mCanvas, this.mModListener);
        gridBagConstraints.weighty = 0.1;
        DialogUtil.addUsingGBL(this, this.mErrorBarsPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }
}

