/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.ColorWellPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartAppearanceOption;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.StyleCycler;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BasePropertiesPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class ChartAppearancePanel
extends BasePropertiesPanel
implements ItemListener,
ActionListener,
ListSelectionListener,
ChangeListener {
    private int USE_CUSTOM_AREA = 0;
    private int CYCLE_ORDER_AREA = 1;
    private int COLORS_AREA = 2;
    private int FRAME_GRIDLINE_AREA = 3;
    private int TEMPLATE_AREA = 4;
    private static final String SWATCH_COLORS_KEY = "SwatchColorsKey";
    private static final String TEMPLATE_PATH_KEY = "TemplatePathKey";
    private String[] mColorsCategs;
    private Color[] mSwatchColors = new Color[30];
    private String mCategoryStr;
    private JCheckBox mUseCustomSettings;
    private JLabel mCycleOrderLabel;
    private JLabel mColorsLabel;
    private JRadioButton mUseDefaultRadio;
    private JRadioButton mUseTemplateRadio;
    private FocusableTextArea mTempPathTextField;
    private JButton mBrowseBtn;
    private JCheckBox mOutFrame;
    private JCheckBox mInnerFrame;
    private JCheckBox mXAxisCheck;
    private JCheckBox mYAxisCheck;
    private String mTemplatePathStr = "None";
    private ResourceBundle mChartOptionResBundle;
    private ThisColorWellPanel mColorWellPanel;
    private JList mCycleOrderList;
    protected JButton mResetSeqBtn;
    private IModListener mModListener;
    private boolean mInReload;
    private boolean[] mDirtyFlags = new boolean[5];
    private StyleCycler mStyleCycler;
    private ChartAppearanceOption mChartAppearanceOption;
    private Map<Integer, Color> mChangedColorMap = new TreeMap<Integer, Color>();
    private boolean mUseCustomSettingChanged = false;

    public ChartAppearancePanel(ChartBuilderDlg chartBuilderDlg, IModListener iModListener) {
        super(chartBuilderDlg);
        this.mModListener = iModListener;
        this.mStyleCycler = this.getStyleCycler();
        this.mChartAppearanceOption = this.getChartAppearanceOption();
        this.mChartOptionResBundle = ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.initVars();
        this.initializeFromPrefs();
        this.initPanel();
    }

    @Override
    public boolean canSwitchTab() {
        this.validateThisPanel();
        return true;
    }

    public void validateThisPanel() {
        String string = this.mTempPathTextField.getText();
        if (this.mUseTemplateRadio.isSelected() && string.equals(this.mChartOptionResBundle.getString("IDS_NONE"))) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mChartBuilderDlg), this.mChartBuilderDlg.getResString("IDS_APPEARANCE_TEMPLATE_ALERT"), VersionInfo.getAppVersionString());
            this.mUseDefaultRadio.setSelected(true);
            this.onUseRadioSelection(this.mUseDefaultRadio);
        }
    }

    private void initializeFromPrefs() {
        Object object;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("charts");
        Preferences preferences3 = preferences2.node("color_swatches");
        String[] stringArray = PrefDefaults.DEF_CHART_COLOR_SWATCHES;
        for (int i = 0; i < 30; ++i) {
            object = new int[3];
            int n = 0;
            String string = preferences3.get(IOptionConstants.CHART_COLOR_PALETTE_KEY[i], stringArray[i]);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                object[n] = Integer.parseInt(string2);
                ++n;
            }
            this.mSwatchColors[i] = new Color((int)object[0], (int)object[1], (int)object[2]);
        }
        try {
            object = new Vector();
            Preferences preferences4 = preferences2.node("chart_colors");
            int n = preferences4.keys().length;
            if (n > 0) {
                for (int i = 0; i < n - 1; ++i) {
                    String string = String.format("%s%s", "Cat_", i);
                    ((Vector)object).add(preferences4.get(string, ""));
                }
                if (((Vector)object).size() > 0) {
                    this.mColorsCategs = new String[((Vector)object).size()];
                    ((Vector)object).toArray(this.mColorsCategs);
                    ((Vector)object).clear();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mCycleOrderList = this.getCycleOrderList();
        Color[] colorArray = this.getCategoryColors();
        this.mColorWellPanel = new ThisColorWellPanel(this.mChartBuilderDlg, colorArray[0], this.mSwatchColors);
        this.mCycleOrderLabel = DialogUtil.createLabel(this.mChartBuilderDlg, "IDS_APPEARANCE_CYCLE_ORDER");
        this.mColorsLabel = new JLabel(this.mChartOptionResBundle.getString("IDS_CHARTS_AVAILABLE_COLORS"));
        this.mCycleOrderList.addListSelectionListener(this);
        this.mCycleOrderLabel.setLabelFor(this.mCycleOrderList);
    }

    public void loadState(DialogDataModel dialogDataModel) {
        boolean bl;
        this.mInReload = true;
        boolean bl2 = bl = dialogDataModel.getBoolean("IDS_APPEARANCE_USE_CUSTOM_SETTINGS") != null && dialogDataModel.getBoolean("IDS_APPEARANCE_USE_CUSTOM_SETTINGS") != false;
        if (dialogDataModel.getArray(SWATCH_COLORS_KEY) != null) {
            this.mSwatchColors = (Color[])dialogDataModel.getArray(SWATCH_COLORS_KEY);
            this.mColorWellPanel.refreshColors(this.mSwatchColors);
        }
        this.mTemplatePathStr = dialogDataModel.getString(TEMPLATE_PATH_KEY);
        this.onCustomSettings(bl);
        this.refreshChartAppearanceOptionControls();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ChartAppearancePanel.this.mTemplatePathStr == null || ChartAppearancePanel.this.mTemplatePathStr.equals("None")) {
                    ChartAppearancePanel.this.mTempPathTextField.setText(ChartAppearancePanel.this.mChartOptionResBundle.getString("IDS_NONE"));
                } else {
                    ChartAppearancePanel.this.mTempPathTextField.setText(ChartAppearancePanel.this.mTemplatePathStr);
                }
                ChartAppearancePanel.this.addListeners();
            }
        });
        this.mInReload = false;
    }

    public void saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putArray(SWATCH_COLORS_KEY, this.mSwatchColors);
        dialogDataModel.putString(TEMPLATE_PATH_KEY, this.mTemplatePathStr);
    }

    public boolean applyChanges() {
        boolean bl;
        ChartAppearanceOption chartAppearanceOption = this.getChartAppearanceOption();
        chartAppearanceOption.setUseCustomSetting(this.mUseCustomSettings.isSelected());
        if (this.mDirtyFlags[this.USE_CUSTOM_AREA]) {
            chartAppearanceOption.setModified(true);
        }
        if (this.mUseCustomSettings.isSelected()) {
            boolean bl2;
            if (this.mDirtyFlags[this.CYCLE_ORDER_AREA]) {
                Color[] colorArray = this.getCategoryColors();
                this.getStyleCycler().refreshColorCycle(colorArray);
                chartAppearanceOption.setChangedColorMap(this.mChangedColorMap);
                chartAppearanceOption.setCycleColors(colorArray);
            }
            if (this.mDirtyFlags[this.COLORS_AREA]) {
                this.mSwatchColors = this.mColorWellPanel.getAllColors();
            }
            if (this.mDirtyFlags[this.FRAME_GRIDLINE_AREA]) {
                chartAppearanceOption.refreshBorderGridlineOption(true, this.mOutFrame.isSelected(), this.mInnerFrame.isSelected(), this.mXAxisCheck.isSelected(), this.mYAxisCheck.isSelected());
            }
            boolean bl3 = bl2 = this.mDirtyFlags[this.CYCLE_ORDER_AREA] || this.mDirtyFlags[this.COLORS_AREA] || this.mDirtyFlags[this.FRAME_GRIDLINE_AREA];
            if (bl2) {
                this.mUseCustomSettingChanged = bl2;
                chartAppearanceOption.setModified(true);
            }
        } else {
            chartAppearanceOption.reset(false);
            if (this.mUseTemplateRadio.isSelected()) {
                String string = this.mTempPathTextField.getText();
                chartAppearanceOption.setTemplatePath(string);
                boolean bl4 = bl = string != null && string.length() > 0 && !string.equals("None");
                if (bl) {
                    chartAppearanceOption.applyChartAppearanceOption(new File(string));
                    chartAppearanceOption.setTemplatePath(string);
                }
            }
            this.getStyleCycler().refreshColorCycle(chartAppearanceOption.getCycleColors());
            this.refreshCustomSettingsControls();
        }
        if (this.mDirtyFlags[this.TEMPLATE_AREA]) {
            boolean bl5 = false;
            if (this.mUseTemplateRadio.isSelected()) {
                this.mChartAppearanceOption.reset(true);
                boolean bl6 = bl = this.mTemplatePathStr != null && this.mTemplatePathStr.length() > 0 && !this.mTemplatePathStr.equals("None");
                if (bl) {
                    this.mChartAppearanceOption.applyChartAppearanceOption(new File(this.mTemplatePathStr));
                    this.mChartAppearanceOption.setTemplatePath(this.mTemplatePathStr);
                }
                bl5 = true;
                chartAppearanceOption.setModified(true);
            } else if (this.mUseDefaultRadio.isSelected()) {
                this.mChartAppearanceOption.reset(true);
                bl5 = true;
                chartAppearanceOption.setModified(true);
            }
            if (bl5) {
                this.getStyleCycler().refreshColorCycle(this.mChartAppearanceOption.getCycleColors());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChartAppearancePanel.this.refreshCustomSettingsControls();
                        ChartAppearancePanel.this.mUseCustomSettingChanged = false;
                        ChartAppearancePanel.this.mChangedColorMap.clear();
                    }
                });
            }
        }
        Arrays.fill(this.mDirtyFlags, false);
        return true;
    }

    public boolean isDirty() {
        for (boolean bl : this.mDirtyFlags) {
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.mInReload = true;
        this.mUseCustomSettings.setSelected(this.mChartAppearanceOption.isUseCustomSetting());
        this.onCustomSettings(this.mChartAppearanceOption.isUseCustomSetting());
        this.refreshChartAppearanceOptionControls();
        this.mUseCustomSettingChanged = false;
        this.mTemplatePathStr = "None";
        this.mTempPathTextField.setText(this.mChartOptionResBundle.getString("IDS_NONE"));
        this.mInReload = false;
    }

    public void refreshChartAppearanceOptionControls() {
        this.refreshCustomSettingsControls();
        this.mInReload = true;
        String string = this.mChartAppearanceOption.getTemplatePath();
        if (string != null && string.length() > 0) {
            this.mUseTemplateRadio.setSelected(true);
            this.mTempPathTextField.setEnabled(true);
            this.mTempPathTextField.setText(string);
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.mTempPathTextField.setOpaque(true);
            }
        } else {
            this.mUseDefaultRadio.setSelected(true);
            this.mTempPathTextField.setText(this.mChartOptionResBundle.getString("IDS_NONE"));
            this.mTempPathTextField.setEnabled(false);
            this.mTempPathTextField.setOpaque(false);
            this.mBrowseBtn.setEnabled(false);
        }
        this.mInReload = false;
    }

    private void refreshCustomSettingsControls() {
        this.mInReload = true;
        Color[] colorArray = this.mChartAppearanceOption.getCycleColors();
        if (colorArray != null && colorArray.length > 0 && colorArray[0] != null) {
            NameItemListModel nameItemListModel = (NameItemListModel)this.mCycleOrderList.getModel();
            ColorIcon[] colorIconArray = nameItemListModel.getColorIcons();
            for (int i = 0; i < colorArray.length; ++i) {
                colorIconArray[i].setColor(colorArray[i]);
            }
            this.mColorWellPanel.getPicker().setSelectedColor(colorArray[0]);
            this.mCycleOrderList.repaint();
        }
        if (this.mChartAppearanceOption.getChangedColorMap() != null) {
            this.mChangedColorMap = this.mChartAppearanceOption.getChangedColorMap();
        }
        this.mOutFrame.setSelected(this.mChartAppearanceOption.isOuterFrameBorder());
        this.mInnerFrame.setSelected(this.mChartAppearanceOption.isInnerFrameBorder());
        this.mXAxisCheck.setSelected(this.mChartAppearanceOption.isGridlineX());
        this.mYAxisCheck.setSelected(this.mChartAppearanceOption.isGridlineY());
        this.mInReload = false;
    }

    private String getCategoryStr() {
        if (this.mCategoryStr == null) {
            this.mCategoryStr = this.mChartOptionResBundle.getString("IDS_CHARTS_CAT");
        }
        return this.mCategoryStr;
    }

    private void initVars() {
        this.mResetSeqBtn = DialogUtil.createButton(this.mChartBuilderDlg, "IDS_APPEARANCE_CYCLE_RESET", this);
        this.mUseCustomSettings = DialogUtil.createCheckBox(this.mChartBuilderDlg, "IDS_APPEARANCE_USE_CUSTOM_SETTINGS", (ActionListener)this);
        this.mUseDefaultRadio = DialogUtil.createRadioButton(this.mChartBuilderDlg, "IDS_APPEARANCE_USE_TEMPLATE_DEFAULT", (ActionListener)this);
        this.mUseTemplateRadio = DialogUtil.createRadioButton(this.mChartBuilderDlg, "IDS_APPEARANCE_USE_TEMPLATE_FILE", (ActionListener)this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mUseDefaultRadio);
        spssButtonGroup.add(this.mUseTemplateRadio);
        this.mTempPathTextField = new FocusableTextArea(this.mChartOptionResBundle.getString("IDS_NONE"), null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mChartOptionResBundle, "IDS_USE_BROWSE_3DOT");
        this.mBrowseBtn = new JButton(toggleButtonAction);
        this.mBrowseBtn.addActionListener(this);
        this.mOutFrame = DialogUtil.createCheckBox(this.mChartOptionResBundle, "IDS_OUTER", (ActionListener)this);
        this.mInnerFrame = DialogUtil.createCheckBox(this.mChartOptionResBundle, "IDS_INNER", (ActionListener)this);
        this.mXAxisCheck = DialogUtil.createCheckBox(this.mChartBuilderDlg, "IDS_APPEARANCE_GRID_X", (ActionListener)this);
        this.mYAxisCheck = DialogUtil.createCheckBox(this.mChartBuilderDlg, "IDS_APPEARANCE_GRID_Y", (ActionListener)this);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mOutFrame);
        spssButtonGroup2.add(this.mInnerFrame);
        SpssButtonGroup spssButtonGroup3 = new SpssButtonGroup();
        spssButtonGroup3.add(this.mXAxisCheck);
        spssButtonGroup3.add(this.mYAxisCheck);
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this, this.setupEditAppearancePanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.setupChartTemplatePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel setupEditAppearancePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mChartBuilderDlg.getResString("IDS_APPEARANCE_EDIT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.mUseCustomSettings, gridBagConstraints, 0, 0, 2, 1, n, new Insets(0, n2, 0, n2));
        DialogUtil.addUsingGBL(jPanel, this.setupColorsPanel(), gridBagConstraints, 0, 1, 2, 1, n, new Insets(0, n2 += 10, 0, n2));
        DialogUtil.addUsingGBL(jPanel, this.setUpFramePanel(), gridBagConstraints, 0, 2, 1, 1, n, new Insets(0, n2, 0, n2));
        DialogUtil.addUsingGBL(jPanel, this.setUpGridlinesPanel(), gridBagConstraints, 1, 2, 1, 1, n, new Insets(0, n2, 0, n2));
        return jPanel;
    }

    private JPanel setupColorsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mChartBuilderDlg.getResString("IDS_APPEARANCE_COLORS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.setupCycleOrderPanel(), gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, n2, 0, 0));
        DialogUtil.addUsingGBL(jPanel, this.getAvailablePanel(), gridBagConstraints, 1, 0, 1, 1, n, new Insets(0, 0, 0, n2));
        return jPanel;
    }

    private JPanel setupCycleOrderPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JScrollPane jScrollPane = new JScrollPane(this.mCycleOrderList, 20, 31);
        Dimension dimension = new Dimension(this.mCycleOrderList.getPreferredSize().width + 10, 145);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        gridBagConstraints.weightx = 0.0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mCycleOrderLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mResetSeqBtn, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JList getCycleOrderList() {
        NameItemListModel nameItemListModel = this.getCycleOrderListModel();
        JList jList = new JList(nameItemListModel);
        jList.setCellRenderer(new NameItemListCellRenderer());
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        return jList;
    }

    private NameItemListModel getCycleOrderListModel() {
        if (this.mColorsCategs != null) {
            int n = this.mColorsCategs.length;
            ColorIcon[] colorIconArray = new ColorIcon[n];
            for (int i = 0; i < n; ++i) {
                colorIconArray[i] = new ColorIcon(this.getColorFromString(this.mColorsCategs[i]));
            }
            return new NameItemListModel(colorIconArray);
        }
        return this.getSystemCycleOrderListModel();
    }

    private NameItemListModel getSystemCycleOrderListModel() {
        int n = 30;
        ColorIcon[] colorIconArray = new ColorIcon[n];
        for (int i = 0; i < n; ++i) {
            colorIconArray[i] = new ColorIcon(this.getColorFromString(PrefDefaults.DEF_CHART_COLOR_CYCLE[i]));
        }
        return new NameItemListModel(colorIconArray);
    }

    private NameItemListModel getCycleOrderListModel(Color[] colorArray) {
        int n = 30;
        ColorIcon[] colorIconArray = new ColorIcon[n];
        for (int i = 0; i < n; ++i) {
            colorIconArray[i] = new ColorIcon(colorArray[i]);
        }
        return new NameItemListModel(colorIconArray);
    }

    private Color[] getCategoryColors() {
        NameItemListModel nameItemListModel = (NameItemListModel)this.mCycleOrderList.getModel();
        ColorIcon[] colorIconArray = nameItemListModel.getColorIcons();
        Color[] colorArray = new Color[colorIconArray.length];
        for (int i = 0; i < colorIconArray.length; ++i) {
            colorArray[i] = colorIconArray[i].getColor();
        }
        return colorArray;
    }

    private JPanel getAvailablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.mColorWellPanel.setPreferredSize(new Dimension(this.mColorWellPanel.getPreferredSize().width + 10, this.mColorWellPanel.getPreferredSize().height + 10));
        } else {
            this.mColorsLabel.setDisplayedMnemonic(this.mChartBuilderDlg.getResInt(this.mChartOptionResBundle, "IDK_CHARTS_AVAILABLE_COLORS_KEY"));
            this.mColorsLabel.setLabelFor((Component)this.mColorWellPanel.getPicker());
        }
        DialogUtil.addUsingGBL(jPanel, this.mColorsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mColorWellPanel, gridBagConstraints, 0, 1, 1, 4, n, insets);
        return jPanel;
    }

    private Color getColorFromString(String string) {
        if ("transparent".equals(string)) {
            return new Color(255, 255, 255, 0);
        }
        int n = 0;
        Object[] objectArray = new String[4];
        Arrays.fill(objectArray, "255");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            objectArray[n++] = stringTokenizer.nextToken();
        }
        return new Color(Integer.parseInt(((String)objectArray[0]).trim()), Integer.parseInt(((String)objectArray[1]).trim()), Integer.parseInt(((String)objectArray[2]).trim()));
    }

    private JPanel setUpFramePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mChartOptionResBundle.getString("IDS_FRAME_PANEL")));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.mOutFrame);
        jPanel.add(this.mInnerFrame);
        return jPanel;
    }

    private JPanel setUpGridlinesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mChartOptionResBundle.getString("IDS_GRID_LINES_PANEL")));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.mXAxisCheck);
        jPanel.add(this.mYAxisCheck);
        return jPanel;
    }

    private JPanel setupChartTemplatePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mChartBuilderDlg.getResString("IDS_APPEARANCE_TEMPLATE_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, 0);
        FocusableTextArea focusableTextArea = new FocusableTextArea(this.mChartBuilderDlg.getResString("IDS_APPEARANCE_TEMPLATE_INFO"));
        DialogUtil.addUsingGBL(jPanel, focusableTextArea, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mUseDefaultRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mUseTemplateRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n2 * 6, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseBtn, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), n2, DialogUtil.getGroupBoxInnerMargin(), 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTempPathTextField, gridBagConstraints, 0, 3, 2, 1, n, insets);
        return jPanel;
    }

    private void addListeners() {
        this.mUseDefaultRadio.addItemListener(this);
        this.mUseTemplateRadio.addItemListener(this);
        this.mOutFrame.addItemListener(this);
        this.mInnerFrame.addItemListener(this);
        this.mXAxisCheck.addItemListener(this);
        this.mYAxisCheck.addItemListener(this);
        this.mColorWellPanel.getPicker().addChangeListener((ChangeListener)this);
    }

    private void setListSelectedColor(Color color, JList jList) {
        if (color == null) {
            return;
        }
        Object e = jList.getSelectedValue();
        int n = jList.getSelectedIndex();
        if (e instanceof ColorIcon) {
            ColorIcon colorIcon = (ColorIcon)e;
            colorIcon.setColor(color);
            this.mChangedColorMap.put(n, color);
            jList.repaint();
        }
    }

    private boolean onUseRadioSelection(Object object) {
        boolean bl = true;
        if (object == this.mUseDefaultRadio && this.mUseDefaultRadio.isSelected()) {
            bl = this.onDefaultSelection();
        } else if (object == this.mUseTemplateRadio && this.mUseTemplateRadio.isSelected()) {
            bl = this.onTemplateSelection();
        }
        return bl;
    }

    private boolean onTemplateSelection() {
        int n;
        if (this.mUseCustomSettingChanged && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mChartBuilderDlg), this.mChartBuilderDlg.getResString("IDS_APPEARANCE_TEMPLATE_CONFIRM"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 2) {
            this.mUseTemplateRadio.removeItemListener(this);
            this.mUseDefaultRadio.removeItemListener(this);
            this.mUseDefaultRadio.setSelected(true);
            this.mUseTemplateRadio.addItemListener(this);
            this.mUseDefaultRadio.addItemListener(this);
            return false;
        }
        this.mUseCustomSettings.setSelected(false);
        this.onCustomSettings(false);
        this.mTempPathTextField.setEnabled(true);
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mTempPathTextField.setOpaque(true);
        }
        this.mBrowseBtn.setEnabled(true);
        return true;
    }

    private boolean onDefaultSelection() {
        int n;
        if (this.mUseCustomSettingChanged && this.mTemplatePathStr != null && !this.mTemplatePathStr.equals("None") && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mChartBuilderDlg), this.mChartBuilderDlg.getResString("IDS_APPEARANCE_TEMPLATE_CONFIRM"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 2) {
            this.mUseTemplateRadio.removeItemListener(this);
            this.mUseDefaultRadio.removeItemListener(this);
            this.mUseTemplateRadio.setSelected(true);
            this.mUseTemplateRadio.addItemListener(this);
            this.mUseDefaultRadio.addItemListener(this);
            return false;
        }
        this.mUseCustomSettings.setSelected(false);
        this.onCustomSettings(false);
        this.mTempPathTextField.setEnabled(false);
        this.mTempPathTextField.setOpaque(false);
        this.mBrowseBtn.setEnabled(false);
        return true;
    }

    private int doBrowse() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.GenericWithoutPES, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        RefFileFilter refFileFilter = new RefFileFilter(this.mChartOptionResBundle.getString("IDS_CHARTS_FILE_FILTER"), this.mChartOptionResBundle.getString("IDS_CHARTS_EXT"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(true);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this.mChartBuilderDlg));
        if (n == 0) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            if (file != null && file.isFile()) {
                this.mTemplatePathStr = remoteFileChooser.getSelectedFilePath();
                this.mDirtyFlags[this.TEMPLATE_AREA] = true;
                this.mModListener.itemModified();
            }
        }
        return n;
    }

    private void onCustomSettings(boolean bl) {
        this.onColorControls(bl);
        this.mOutFrame.setEnabled(bl);
        this.mInnerFrame.setEnabled(bl);
        this.mXAxisCheck.setEnabled(bl);
        this.mYAxisCheck.setEnabled(bl);
    }

    private void onColorControls(boolean bl) {
        boolean bl2 = bl && this.mStyleCycler.getUseColors();
        this.mCycleOrderLabel.setEnabled(bl2);
        this.mColorsLabel.setEnabled(bl2);
        this.mCycleOrderList.setEnabled(bl2);
        this.mResetSeqBtn.setEnabled(bl2);
        this.mColorWellPanel.setEnabled(bl2);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mInReload) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.mOutFrame || object == this.mInnerFrame || object == this.mXAxisCheck || object == this.mYAxisCheck) {
            this.mDirtyFlags[this.FRAME_GRIDLINE_AREA] = true;
            this.mModListener.itemModified();
        }
        if (itemEvent.getStateChange() == 1 && (object == this.mUseDefaultRadio || object == this.mUseTemplateRadio)) {
            this.mDirtyFlags[this.TEMPLATE_AREA] = true;
            if (this.onUseRadioSelection(object)) {
                this.mModListener.itemModified();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.mUseCustomSettings) {
            this.onCustomSettings(this.mUseCustomSettings.isSelected());
            this.mDirtyFlags[this.USE_CUSTOM_AREA] = true;
            this.mModListener.itemModified();
        } else if (object == this.mResetSeqBtn) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mChartBuilderDlg), this.mChartOptionResBundle.getString("ERR_CHARTS_RESET_DEFAULT_WARN"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n == 1) {
                this.mInReload = true;
                this.mChartAppearanceOption.resetColorCycleOnly();
                this.mCycleOrderList.setModel(this.getCycleOrderListModel(this.mChartAppearanceOption.getCycleColors()));
                this.mCycleOrderList.setSelectedIndex(0);
                this.mChangedColorMap.clear();
                this.mDirtyFlags[this.CYCLE_ORDER_AREA] = true;
                this.mModListener.itemModified();
                this.mInReload = false;
            }
        } else if (object == this.mBrowseBtn && this.doBrowse() == 0) {
            this.mTempPathTextField.setText(this.mTemplatePathStr);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e;
        Object object = listSelectionEvent.getSource();
        if (!listSelectionEvent.getValueIsAdjusting() && object == this.mCycleOrderList && (e = this.mCycleOrderList.getSelectedValue()) instanceof ColorIcon) {
            ColorIcon colorIcon = (ColorIcon)e;
            this.mColorWellPanel.getPicker().setSelectedColor(colorIcon.getColor());
            if (this.mColorWellPanel.getPicker().getSelIndex() == -1 || this.mColorWellPanel.getPicker().getSelIndex() == 0 || this.mColorWellPanel.getPicker().getSelIndex() == 1 || this.mColorWellPanel.getPicker().getSelIndex() == 2) {
                this.mColorWellPanel.retEditButton().setEnabled(false);
            } else {
                this.mColorWellPanel.retEditButton().setEnabled(true);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartAppearancePanel.this.mCycleOrderList.requestFocus();
                }
            });
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.mInReload) {
            return;
        }
        this.mColorWellPanel.retEditButton().setEnabled(true);
        this.setListSelectedColor(this.mColorWellPanel.getPicker().getSelectedColor(), this.mCycleOrderList);
        this.mCycleOrderList.repaint();
        this.mDirtyFlags[this.CYCLE_ORDER_AREA] = true;
        this.mModListener.itemModified();
    }

    class NameItemListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        NameItemListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            NameItemListModel nameItemListModel = (NameItemListModel)jList.getModel();
            if (nameItemListModel.getName() == null) {
                this.setText(ChartAppearancePanel.this.getCategoryStr() + (n + 1));
            } else {
                this.setText(nameItemListModel.getName());
            }
            this.setIcon((ColorIcon)object);
            this.setEnabled(jList.isEnabled());
            try {
                object2 = ((ColorIcon)object).clone();
                ((ColorIcon)object2).setEnable(false);
                this.setDisabledIcon((Icon)object2);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (jList.hasFocus()) {
                        this.setForeground(jList.getSelectionForeground());
                        this.setBackground(jList.getSelectionBackground());
                    } else {
                        this.setForeground(Color.black);
                        this.setBackground(Color.lightGray);
                    }
                } else {
                    this.setForeground(jList.getForeground());
                    this.setBackground(jList.getBackground());
                }
            } else {
                this.setOpaque(false);
            }
            object2 = null;
            if (bl2) {
                if (bl) {
                    object2 = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (object2 == null) {
                    object2 = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                object2 = new EmptyBorder(1, 1, 1, 1);
            }
            this.setBorder((Border)object2);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    class NameItemListModel
    extends DefaultListModel {
        private String mNameStr;
        private ColorIcon[] mColorIcons;

        NameItemListModel(ColorIcon[] colorIconArray) {
            this(null, colorIconArray);
        }

        NameItemListModel(String string, ColorIcon[] colorIconArray) {
            this.mNameStr = string;
            this.mColorIcons = colorIconArray;
            for (ColorIcon colorIcon : colorIconArray) {
                this.addElement(colorIcon);
            }
        }

        public String getName() {
            return this.mNameStr;
        }

        public ColorIcon[] getColorIcons() {
            return this.mColorIcons;
        }
    }

    class ColorIcon
    implements Icon,
    Cloneable {
        private Color mColor;
        protected boolean mIsEnabled = true;

        ColorIcon(Color color) {
            this.mColor = color;
        }

        public void setEnable(boolean bl) {
            this.mIsEnabled = bl;
        }

        public ColorIcon clone() throws CloneNotSupportedException {
            return (ColorIcon)super.clone();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setBackground(Color.white);
            graphics2D.clearRect(0, 0, this.getIconWidth(), this.getIconHeight());
            graphics2D.setPaint(this.mColor);
            graphics2D.fill(new Rectangle(2, 0, 16, 16));
            if (!this.mIsEnabled) {
                graphics2D.setPaint(new Color(0.7f, 0.7f, 0.7f, 0.5f));
                graphics2D.fill(new Rectangle(0, 0, 18, 18));
            }
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }

        public Color getColor() {
            return this.mColor;
        }

        public void setColor(Color color) {
            this.mColor = color;
        }
    }

    class ThisColorWellPanel
    extends ColorWellPanel {
        ThisColorWellPanel(BaseDialog baseDialog, Color color, Color[] colorArray) {
            super(baseDialog, color, colorArray);
        }

        @Override
        protected void layingout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            OptionsUtil.addUsingGBL(this, (JComponent)this.mPicker, gridBagConstraints, 0, 0, 2, 1, n, null);
            gridBagConstraints.weightx = 0.0;
            n = 10;
            Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
            insets.left += 20;
            OptionsUtil.addUsingGBL(this, this.editButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
            gridBagConstraints.weighty = 1.0;
            OptionsUtil.addUsingGBL(this, this.rgbLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        }

        @Override
        protected void uponColorEdit() {
            ChartAppearancePanel.this.setListSelectedColor(this.mPicker.getSelectedColor(), ChartAppearancePanel.this.mCycleOrderList);
            ChartAppearancePanel.this.getCycleOrderList().repaint();
            ((ChartAppearancePanel)ChartAppearancePanel.this).mDirtyFlags[((ChartAppearancePanel)ChartAppearancePanel.this).CYCLE_ORDER_AREA] = true;
            ((ChartAppearancePanel)ChartAppearancePanel.this).mDirtyFlags[((ChartAppearancePanel)ChartAppearancePanel.this).COLORS_AREA] = true;
            ChartAppearancePanel.this.mModListener.itemModified();
        }

        Color[] getAllColors() {
            Color[] colorArray = new Color[this.mDescriptors.length];
            for (int i = 3; i < this.mDescriptors.length; ++i) {
                colorArray[i - 3] = this.mDescriptors[i].getColor();
            }
            return colorArray;
        }
    }
}

