/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.IUpDownListListener;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.UpDownListWidget;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.AbstractListDropListener;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.AxisPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.RelabelBag;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.res.IResourceAccessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.text.Bidi;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CategoricalAxisPanel
extends AxisPanel
implements IUpDownListListener,
ActionListener,
ListSelectionListener,
DocumentListener,
ItemListener {
    private KeyListener processKeyEvent = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            JTextField jTextField;
            if (ComponentState.getBTD() == 0 && keyEvent.getSource() instanceof JTextField && (jTextField = (JTextField)keyEvent.getSource()).getCaretPosition() == 0) {
                if (new Bidi(Character.toString(keyEvent.getKeyChar()), 1).isRightToLeft()) {
                    jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                } else {
                    jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    };
    private final int SORT_CUSTOM = 0;
    private final int SORT_LABEL = 1;
    private final int SORT_VALUE = 2;
    private final int DIRECTION_ASCENDING = 0;
    private final int DIRECTION_DESCENDING = 1;
    protected IResourceAccessor mResources;
    protected Props.CatAxisProps mProp;
    protected JTextField mLabelEdit;
    protected JLabel mVarPromptLabel;
    protected JLabel mVarNameLabel;
    protected UpDownListWidget mOrderPanel;
    protected boolean mInReload;
    private JComboBox mSortByCombo;
    private JLabel mSortDirectionLabel;
    private JComboBox mSortDirectionCombo;
    private JLabel mExcludedListLabel;
    private PlainList mExcludedCatsList;
    private DefaultListModel mExcludeModel;
    private IncludeButton mIncludeButton;
    private JRadioButton mShowEmptyCatsRadio;
    private JRadioButton mShowPresentCatsRadio;
    private JCheckBox mCollapseSmallCheck;
    private JLabel mCollapsePctLabel;
    private IntTextField mCollapsePctEdit;
    private Color mEnabledColor;
    private boolean mDisableCollapse;
    private SpssButtonGroup mButtonGroup;
    private JPanel mEmptyCatsPanel;
    private JCheckBox mIncludeUnlabeledCheck;

    public CategoricalAxisPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.mResources = chartCanvas.getResources();
        this.mInReload = false;
        this.init();
        this.addListeners();
    }

    @Override
    public String getPanelId() {
        return "cat_panel";
    }

    @Override
    void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getParentDialog().getGlassPane();
        PlainList plainList = this.mOrderPanel.getList();
        ListDragAdapter listDragAdapter = new ListDragAdapter(this.mExcludedCatsList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mExcludedCatsList, listDragAdapter);
        listDragAdapter = new ListDragAdapter(plainList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(plainList, listDragAdapter);
        CatListDropListener catListDropListener = new CatListDropListener(this.mExcludedCatsList, (Component)plainList);
        dragPane.addDropListener((IDropListener)catListDropListener);
        catListDropListener = new CatListDropListener(plainList, (Component)this.mExcludedCatsList);
        dragPane.addDropListener((IDropListener)catListDropListener);
    }

    void addListeners() {
        this.mLabelEdit.getDocument().addDocumentListener(this);
        this.mLabelEdit.addFocusListener(this);
        this.mSortByCombo.addActionListener(this);
        this.mSortDirectionCombo.addActionListener(this);
        this.mOrderPanel.addListListener(this);
        this.mCollapsePctEdit.getDocument().addDocumentListener(this);
        this.mCollapsePctEdit.addFocusListener((FocusListener)this);
        this.mIncludeUnlabeledCheck.addItemListener(this);
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mLabelEdit);
        vector.add(this.mSortByCombo);
        vector.add(this.mSortDirectionCombo);
        this.mOrderPanel.addTabTraversalComponents(vector);
        vector.add(this.mExcludedCatsList);
        vector.add(this.mIncludeButton);
        vector.add(this.mButtonGroup);
        vector.add(this.mCollapseSmallCheck);
        vector.add(this.mCollapsePctEdit);
        vector.add(this.mIncludeUnlabeledCheck);
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        if (props instanceof Props.CatAxisProps) {
            boolean bl;
            boolean bl2;
            this.mInReload = true;
            this.mProp = (Props.CatAxisProps)props;
            boolean bl3 = this.mDisableCollapse = !this.getParentDialog().getSidePropertiesPanel().isCollapseOK() || this.mProp.getZoneType() == ZoneType.zt_split_var;
            if (ComponentState.getBTD() == 0 && this.mProp.getStrLabel() != null && this.mProp.getStrLabel().length() > 0) {
                if (ComponentState.isBidiLetter((char)this.mProp.getStrLabel().charAt(0)) && this.mLabelEdit.getDocument().getProperty(TextAttribute.RUN_DIRECTION) == TextAttribute.RUN_DIRECTION_LTR) {
                    this.mLabelEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                } else if (!ComponentState.isBidiLetter((char)this.mProp.getStrLabel().charAt(0)) && this.mLabelEdit.getDocument().getProperty(TextAttribute.RUN_DIRECTION) == TextAttribute.RUN_DIRECTION_RTL) {
                    this.mLabelEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
            this.mLabelEdit.setText(this.mProp.getStrLabel());
            String string = "";
            DropZone dropZone = this.mCanvas.getZoneMgr().getZone(this.mProp.getZoneType());
            ISpssVariable iSpssVariable = null;
            if (dropZone != null && !dropZone.isEmpty()) {
                String string2;
                this.mVarPromptLabel.setEnabled(true);
                this.mVarNameLabel.setEnabled(true);
                iSpssVariable = dropZone.getVariables().get(0);
                if (this.mProp.getZoneType() == ZoneType.zt_filter && this.mProp instanceof Props.PanelProps) {
                    iSpssVariable = dropZone.getVariables().get(((Props.PanelProps)this.mProp).getPanelIndex() - 1);
                }
                this.mVarNameLabel.setIcon(VariableList.getStandardIcon(iSpssVariable));
                ChartBuilderDlg chartBuilderDlg = (ChartBuilderDlg)((Object)this.getTopLevelAncestor());
                SrcVariableList srcVariableList = chartBuilderDlg.getSrcVarList();
                String string3 = string2 = srcVariableList.getModel().getShowVarLabels() ? iSpssVariable.getLabel() : iSpssVariable.getName();
                if (string2 == null || string2.length() == 0) {
                    string2 = iSpssVariable.getName();
                }
                if (ComponentState.isBtdRtlOrLtr()) {
                    this.mVarNameLabel.setText(ComponentState.prepareStringForBidiRendering((String)string2));
                } else {
                    this.mVarNameLabel.setText(string2);
                }
                string = string2;
                bl2 = iSpssVariable.getValueLabels().size() > 0;
            } else {
                this.mVarNameLabel.setIcon(null);
                this.mVarNameLabel.setText(null);
                this.mVarPromptLabel.setEnabled(false);
                this.mVarNameLabel.setEnabled(false);
                bl2 = false;
            }
            if (ComponentState.isBtdRtlOrLtr()) {
                this.mVarNameLabel.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                this.mVarNameLabel.setToolTipText(string);
            }
            int n = 2;
            if (this.mProp.getSortType() == IPropEnum.CatSortType.cst_Custom) {
                n = 0;
            } else if (this.mProp.getSortType() == IPropEnum.CatSortType.cst_Label) {
                n = 1;
            }
            this.mSortByCombo.setSelectedIndex(n);
            n = 0;
            if (this.mProp.getSortOrder() == IPropEnum.CatSortOrder.cso_Descending) {
                n = 1;
            }
            this.mSortDirectionCombo.setSelectedIndex(n);
            this.mSortDirectionCombo.setEnabled(this.mProp.getSortType() != IPropEnum.CatSortType.cst_Custom);
            this.mSortDirectionLabel.setEnabled(this.mProp.getSortType() != IPropEnum.CatSortType.cst_Custom);
            int n2 = this.mOrderPanel.getList().getMinSelectionIndex();
            int n3 = this.mExcludedCatsList.getMinSelectionIndex();
            this.mOrderPanel.clear();
            this.mExcludeModel.clear();
            this.mOrderPanel.enableWidget(bl2);
            this.mExcludedListLabel.setEnabled(bl2);
            this.mExcludedCatsList.setEnabled(bl2);
            if (bl2) {
                this.mExcludedCatsList.setBackground(this.mEnabledColor);
            } else {
                this.mExcludedCatsList.setBackground(SystemColor.control);
            }
            if (bl2) {
                Vector<RelabelBag> vector = this.mProp.getCategories();
                for (RelabelBag relabelBag : vector) {
                    if (!relabelBag.getExcluded()) {
                        this.mOrderPanel.addListItem(relabelBag.getStrTo(), relabelBag);
                        continue;
                    }
                    this.mExcludeModel.addElement(relabelBag);
                }
                if (this.mOrderPanel.getList().getModel().getSize() > 0) {
                    this.mOrderPanel.setSelectedItem(n2 < this.mOrderPanel.getList().getModel().getSize() ? n2 : 0);
                }
                if (this.mExcludeModel.getSize() > 0) {
                    this.mExcludedCatsList.setSelectedIndex(n3 < this.mExcludedCatsList.getModel().getSize() ? n3 : 0);
                }
            }
            this.mIncludeButton.setEnabled(bl2 && this.mExcludeModel.size() > 0);
            if (this.mProp.getZoneType() == ZoneType.zt_filter) {
                this.mEmptyCatsPanel.setVisible(false);
                this.mIncludeUnlabeledCheck.setVisible(true);
                this.mIncludeUnlabeledCheck.setSelected(this.mProp.getIncludeUnlabeled());
                this.mInReload = false;
                return;
            }
            this.mIncludeUnlabeledCheck.setVisible(false);
            this.mEmptyCatsPanel.setVisible(true);
            int n4 = this.mProp.getFlags();
            boolean bl4 = bl = (n4 & 0x40) != 0;
            if (bl) {
                this.mShowEmptyCatsRadio.setSelected(true);
            } else {
                this.mShowPresentCatsRadio.setSelected(true);
            }
            boolean bl5 = (n4 & 0x10) != 0;
            this.mCollapseSmallCheck.setSelected(!this.mDisableCollapse && bl5);
            this.mCollapsePctEdit.setText(Integer.toString(this.mProp.getCollapsePct()));
            this.mCollapseSmallCheck.setEnabled(!this.mDisableCollapse && !bl);
            this.mCollapsePctLabel.setEnabled(!this.mDisableCollapse && !bl && bl5);
            this.mCollapsePctEdit.setEnabled(!this.mDisableCollapse && !bl && bl5);
            if (bl5 && this.mDisableCollapse) {
                this.mProp.setFlags(n4 & 0xFFFFFFEF);
                this.mCanvas.setProperties(chartProps);
            }
            this.mInReload = false;
        } else assert (false);
    }

    @Override
    boolean applyChanges() {
        int n;
        RelabelBag relabelBag;
        if (this.mCollapseSmallCheck.isSelected()) {
            try {
                Integer.valueOf(this.mCollapsePctEdit.getText());
            }
            catch (NumberFormatException numberFormatException) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.mResources.getResString("ERR_NO_COLLAPSE_PCT"), VersionInfo.getAppVersionString());
                this.mCollapsePctEdit.requestFocus();
                return false;
            }
        }
        this.mProp.setStrLabel(this.mLabelEdit.getText());
        int n2 = this.mSortByCombo.getSelectedIndex();
        if (n2 == 2) {
            this.mProp.setSortType(IPropEnum.CatSortType.cst_Value);
        } else if (n2 == 1) {
            this.mProp.setSortType(IPropEnum.CatSortType.cst_Label);
        } else if (n2 == 0) {
            this.mProp.setSortType(IPropEnum.CatSortType.cst_Custom);
        }
        n2 = this.mSortDirectionCombo.getSelectedIndex();
        if (n2 == 0) {
            this.mProp.setSortOrder(IPropEnum.CatSortOrder.cso_Ascending);
        } else if (n2 == 1) {
            this.mProp.setSortOrder(IPropEnum.CatSortOrder.cso_Descending);
        }
        Vector<RelabelBag> vector = this.mProp.getCategories();
        vector.clear();
        Vector<UpDownListWidget.ListItem> vector2 = this.mOrderPanel.getListItems();
        for (UpDownListWidget.ListItem listItem : vector2) {
            relabelBag = (RelabelBag)listItem.getUserObject();
            relabelBag.setExcluded(false);
            vector.add(relabelBag);
        }
        for (n = 0; n < this.mExcludeModel.getSize(); ++n) {
            relabelBag = (RelabelBag)this.mExcludeModel.getElementAt(n);
            relabelBag.setExcluded(true);
            vector.add(relabelBag);
        }
        if (this.mProp.getZoneType() != ZoneType.zt_filter) {
            n = this.mProp.getFlags();
            n = this.mShowEmptyCatsRadio.isSelected() ? (n |= 0x40) : (n &= 0xFFFFFFBF);
            n = this.mCollapseSmallCheck.isSelected() ? (n |= 0x10) : (n &= 0xFFFFFFEF);
            this.mProp.setFlags(n);
            this.mProp.setCollapsePct(Integer.valueOf(this.mCollapsePctEdit.getText()));
        } else {
            this.mProp.setIncludeUnlabeled(this.mIncludeUnlabeledCheck.isVisible() && this.mIncludeUnlabeledCheck.isSelected());
        }
        this.mIsEditFieldDirty = false;
        return true;
    }

    protected String getAxisLabelPrompt() {
        return this.mResources.getResString("IDS_AXIS_LABEL");
    }

    protected Integer getAxisLabelKey() {
        return this.mResources.getDlgAccessKey("IDK_AXIS_LABEL_KEY");
    }

    protected void includeSelected() {
        int[] nArray = this.mExcludedCatsList.getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            RelabelBag relabelBag = (RelabelBag)this.mExcludeModel.getElementAt(nArray[i]);
            this.mExcludeModel.removeElementAt(nArray[i]);
            this.mOrderPanel.addListItem(relabelBag.getStrTo(), relabelBag);
            this.mOrderPanel.setSelectedItem(this.mOrderPanel.getListItems().size() - 1);
            this.mSortByCombo.setSelectedIndex(0);
            this.mSortDirectionLabel.setEnabled(false);
            this.mSortDirectionCombo.setEnabled(false);
            this.mModListener.itemModified();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        if (actionEvent.getSource() == this.mSortByCombo) {
            boolean bl = this.mSortByCombo.getSelectedIndex() == 0;
            this.mSortDirectionLabel.setEnabled(!bl);
            this.mSortDirectionCombo.setEnabled(!bl);
            this.sortCatsList(this.mSortByCombo.getSelectedIndex(), this.mSortDirectionCombo.getSelectedIndex());
        } else if (actionEvent.getSource() == this.mSortDirectionCombo) {
            this.sortCatsList(this.mSortByCombo.getSelectedIndex(), this.mSortDirectionCombo.getSelectedIndex());
        }
        this.mModListener.itemModified();
    }

    @Override
    public void listItemChanged(UpDownListWidget.ListChangeType listChangeType, Vector<Object> vector) {
        if (this.mInReload) {
            return;
        }
        if (listChangeType == UpDownListWidget.ListChangeType.itemDeleted) {
            PlainList plainList = this.mOrderPanel.getList();
            int n = plainList.getModel().getSize();
            if (n == 0) {
                for (Object object : vector) {
                    if (!(object instanceof RelabelBag)) continue;
                    this.mOrderPanel.addListItem(((RelabelBag)object).getStrTo(), object);
                }
                this.mOrderPanel.getList().clearSelection();
                this.mOrderPanel.getList().setSelectedIndex(0);
                SpssAlertOptionPane.showInformationMessageDialog(this, this.mResources.getResString("ERR_MIN_CAT_WARNING"), VersionInfo.getAppVersionString());
                return;
            }
            int n2 = 0;
            this.mExcludedCatsList.getSelectionModel().clearSelection();
            for (Object object : vector) {
                if (!(object instanceof RelabelBag)) continue;
                RelabelBag relabelBag = (RelabelBag)object;
                n2 = this.mExcludeModel.getSize();
                this.mExcludeModel.addElement(relabelBag);
                this.mExcludedCatsList.getSelectionModel().addSelectionInterval(n2, n2);
            }
            this.mExcludedCatsList.ensureIndexIsVisible(n2);
        } else if (listChangeType == UpDownListWidget.ListChangeType.itemMoved) {
            this.mSortByCombo.setSelectedIndex(0);
            this.mSortDirectionLabel.setEnabled(false);
            this.mSortDirectionCombo.setEnabled(false);
        }
        this.mModListener.itemModified();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mExcludedCatsList) {
            this.mIncludeButton.setEnabled(this.mExcludedCatsList.getSelectedIndex() > -1);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mInReload) {
            return;
        }
        this.mIsEditFieldDirty = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mInReload) {
            return;
        }
        this.mIsEditFieldDirty = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mInReload) {
            return;
        }
        this.mIsEditFieldDirty = true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mInReload) {
            return;
        }
        this.mModListener.itemModified();
    }

    private void sortCatsList(int n, int n2) {
        CatComparator catComparator;
        if (n == 0) {
            return;
        }
        Vector<UpDownListWidget.ListItem> vector = this.mOrderPanel.getListItems();
        RelabelBag[] relabelBagArray = new RelabelBag[vector.size()];
        int n3 = 0;
        for (UpDownListWidget.ListItem listItem : vector) {
            relabelBagArray[n3++] = (RelabelBag)listItem.getUserObject();
        }
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(this.mProp.getZoneType());
        boolean bl = true;
        if (dropZone != null && !dropZone.isEmpty()) {
            catComparator = dropZone.getVariables().get(0);
            bl = catComparator.getType() == 0;
        }
        catComparator = new CatComparator(n, n2, bl);
        Arrays.sort(relabelBagArray, catComparator);
        this.mOrderPanel.clear();
        for (RelabelBag relabelBag : relabelBagArray) {
            this.mOrderPanel.addListItem(relabelBag.getStrTo(), relabelBag);
        }
        this.mOrderPanel.getList().setSelectedIndex(0);
        this.mOrderPanel.getList().ensureIndexIsVisible(0);
    }

    void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(this.getAxisLabelPrompt());
        jLabel.setDisplayedMnemonic(this.getAxisLabelKey());
        Insets insets = new Insets(n2 + 4, n2 - 2, n2, 2);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mLabelEdit = new JTextField();
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.mLabelEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mLabelEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        } else {
            this.registerKeyListener(this.mLabelEdit);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n2 + 2, 2, n2, n2 - 2);
        DialogUtil.addUsingGBL(this, this.mLabelEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jLabel.setLabelFor(this.mLabelEdit);
        JPanel jPanel = this.buildCategoriesPanel();
        insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mEmptyCatsPanel = this.buildEmptyCatsPanel();
        insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(this, this.mEmptyCatsPanel, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.mIncludeUnlabeledCheck = new JCheckBox(this.mResources.getResString("IDS_INCLUDE_VALUES_CHECK"));
        this.mIncludeUnlabeledCheck.setMnemonic(this.mResources.getDlgAccessKey("IDK_INCLUDE_VALUES_CHECK_KEY"));
        jPanel2.add(this.mIncludeUnlabeledCheck);
        this.mIncludeUnlabeledCheck.setSelected(true);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, insets);
    }

    private void registerKeyListener(JTextField jTextField) {
        jTextField.addKeyListener(this.processKeyEvent);
    }

    private JPanel buildCategoriesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mResources.getResString("IDS_CATEGORIES")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        this.mVarPromptLabel = new JLabel(this.mResources.getResString("IDS_VARIABLE"));
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mVarPromptLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mVarNameLabel = new JLabel();
        insets = new Insets(0, 1, n2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mVarNameLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.buildSortPanel();
        insets = new Insets(0, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mOrderPanel = new UpDownListWidget(this.mResources.getResString("IDS_ORDER"), this.mResources.getDlgAccessKey("IDK_ORDER_KEY"));
        insets = new Insets(0, n2, 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mOrderPanel, gridBagConstraints, 0, 2, 2, 1, n, insets);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width <= 800 || dimension.height <= 600) {
            this.mOrderPanel.setListSize(new Dimension(160, 60));
        }
        this.mExcludedListLabel = new JLabel(this.mResources.getResString("IDS_EXCLUDED"));
        this.mExcludedListLabel.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_EXCLUDED_KEY"));
        insets = new Insets(0, n2 * 2, 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mExcludedListLabel, gridBagConstraints, 0, 3, 2, 1, n, insets);
        JPanel jPanel3 = this.buildExcludePanel();
        insets = new Insets(0, n2, 2, n2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 2, 1, n, insets);
        this.mExcludedListLabel.setLabelFor(this.mExcludedCatsList);
        return jPanel;
    }

    private JPanel buildExcludePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        this.mExcludeModel = new DefaultListModel();
        this.mExcludedCatsList = new PlainList(this.mExcludeModel, "PlainList", PlainList.DragType.eAutoDragMove);
        JScrollPane jScrollPane = new JScrollPane(this.mExcludedCatsList);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mEnabledColor = this.mExcludedCatsList.getBackground();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = dimension.width <= 800 || dimension.height <= 600 ? new Dimension(160, 30) : new Dimension(160, 60);
        jScrollPane.setMinimumSize(dimension2);
        jScrollPane.setPreferredSize(dimension2);
        Dimension dimension3 = new Dimension(24, 22);
        this.mIncludeButton = new IncludeButton();
        String string = MessageFormat.format(ResUtil.getCommonDlgString("TXT_REMOVE_MESSAGE"), this.mExcludedListLabel.getText());
        this.mIncludeButton.getAccessibleContext().setAccessibleName(string);
        this.mIncludeButton.setPreferredSize(dimension3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.left -= 2;
        insets.bottom += 2;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel buildSortPanel() {
        String[] stringArray = new String[]{this.mResources.getResString("IDS_CUSTOM_SORT"), this.mResources.getResString("IDS_LABEL_SORT"), this.mResources.getResString("IDS_VALUE_SORT")};
        String[] stringArray2 = new String[]{this.mResources.getResString("IDS_ASCENDING_SORT"), this.mResources.getResString("IDS_DESCENDING_SORT")};
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        JLabel jLabel = new JLabel(this.mResources.getResString("IDS_SORT_BY"));
        jLabel.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_SORT_BY_KEY"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mSortDirectionLabel = new JLabel(this.mResources.getResString("IDS_DIRECTION"));
        this.mSortDirectionLabel.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_DIRECTION_KEY"));
        DialogUtil.addUsingGBL(jPanel, this.mSortDirectionLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mSortByCombo = new JComboBox<String>(stringArray);
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(0, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSortByCombo, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jLabel.setLabelFor(this.mSortByCombo);
        this.mSortDirectionCombo = new JComboBox<String>(stringArray2);
        DialogUtil.addUsingGBL(jPanel, this.mSortDirectionCombo, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.mSortDirectionLabel.setLabelFor(this.mSortDirectionCombo);
        return jPanel;
    }

    private JPanel buildEmptyCatsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 1, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mResources.getResString("IDS_EMPTY_CATS")));
        this.mButtonGroup = new SpssButtonGroup();
        this.mShowEmptyCatsRadio = new JRadioButton(new ShowCatsAction(true));
        DialogUtil.addUsingGBL(jPanel, this.mShowEmptyCatsRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.mButtonGroup.add(this.mShowEmptyCatsRadio);
        this.mShowPresentCatsRadio = new JRadioButton(new ShowCatsAction(false));
        DialogUtil.addUsingGBL(jPanel, this.mShowPresentCatsRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mButtonGroup.add(this.mShowPresentCatsRadio);
        insets = new Insets(0, n2 * 5, 2, 2);
        this.mCollapseSmallCheck = new JCheckBox(new CollapseSmallAction());
        DialogUtil.addUsingGBL(jPanel, this.mCollapseSmallCheck, gridBagConstraints, 0, 2, 2, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, insets);
        this.mCollapsePctLabel = new JLabel(this.mResources.getResString("IDS_COLLAPSE_IF_LESS"));
        this.mCollapsePctLabel.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_COLLAPSE_IF_LESS_KEY"));
        insets = new Insets(2, n2 * 7, 2, 2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mCollapsePctLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mCollapsePctEdit = new IntTextField(1, 50, true);
        insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mCollapsePctEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mCollapsePctLabel.setLabelFor((Component)this.mCollapsePctEdit);
        return jPanel;
    }

    private void setEnabledForEmptyCatsControls(boolean bl) {
        this.mShowEmptyCatsRadio.setEnabled(bl);
        this.mShowPresentCatsRadio.setEnabled(bl);
        this.mCollapseSmallCheck.setEnabled(bl);
        this.mCollapsePctLabel.setEnabled(bl);
        this.mCollapsePctEdit.setEnabled(bl);
        this.mCollapsePctLabel.setEnabled(bl);
    }

    protected class CatListDropListener
    extends AbstractListDropListener {
        public CatListDropListener(PlainList plainList, Component component) {
            super(plainList, component);
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            return true;
        }

        @Override
        public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
            if (!this.isRecursivelyVisible(this.mDropTarget)) {
                return null;
            }
            return super.dragItemOver(point, dragDropAdapter);
        }

        boolean isRecursivelyVisible(Component component) {
            boolean bl = component.isVisible();
            if (bl && component.getParent() != null) {
                bl = this.isRecursivelyVisible(component.getParent());
            }
            return bl;
        }

        @Override
        protected void showDropFeedback(Point point) {
            super.showDropFeedback(point);
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            boolean bl;
            if (!this.isRecursivelyVisible(this.mDropTarget)) {
                return;
            }
            boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
            if (bl && this.mDropTarget == CategoricalAxisPanel.this.mExcludedCatsList) {
                PlainList plainList = (PlainList)dropEvent.getSource();
                Object object = dropEvent.getTransferData();
                if (object == null) {
                    return;
                }
                if (!(object instanceof PlainList.TransferData)) {
                    assert (false);
                    return;
                }
                PlainList.TransferData transferData = (PlainList.TransferData)object;
                Object[] objectArray = transferData.getVariables();
                if (plainList.getModel().getSize() - objectArray.length == 0) {
                    SpssAlertOptionPane.showInformationMessageDialog(CategoricalAxisPanel.this, CategoricalAxisPanel.this.mResources.getResString("ERR_MIN_CAT_WARNING"), VersionInfo.getAppVersionString());
                    return;
                }
            }
            super.itemDropped(dropEvent);
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            CategoricalAxisPanel.this.mInReload = true;
            if (object instanceof PlainList.TransferData) {
                try {
                    PlainList plainList = this.mDropTarget == CategoricalAxisPanel.this.mExcludedCatsList ? CategoricalAxisPanel.this.mExcludedCatsList : CategoricalAxisPanel.this.mOrderPanel.getList();
                    plainList.clearSelection();
                    PlainList.TransferData transferData = (PlainList.TransferData)object;
                    for (Object object2 : transferData.getVariables()) {
                        RelabelBag relabelBag;
                        if (object2 instanceof UpDownListWidget.ListItem) {
                            relabelBag = (RelabelBag)((UpDownListWidget.ListItem)object2).getUserObject();
                        } else {
                            if (!(object2 instanceof RelabelBag)) continue;
                            relabelBag = (RelabelBag)object2;
                        }
                        if (this.mDropTarget == CategoricalAxisPanel.this.mExcludedCatsList) {
                            CategoricalAxisPanel.this.mExcludeModel.add(n, relabelBag);
                        } else if (this.mDropTarget == CategoricalAxisPanel.this.mOrderPanel.getList()) {
                            CategoricalAxisPanel.this.mOrderPanel.insertListItem(n, relabelBag.getStrTo(), relabelBag);
                        }
                        plainList.addSelectionInterval(n, n++);
                        if (this.mDropTarget != CategoricalAxisPanel.this.mOrderPanel.getList()) continue;
                        CategoricalAxisPanel.this.mSortByCombo.setSelectedIndex(0);
                        CategoricalAxisPanel.this.mSortDirectionLabel.setEnabled(false);
                        CategoricalAxisPanel.this.mSortDirectionCombo.setEnabled(false);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CategoricalAxisPanel.this.mModListener.itemModified();
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            CategoricalAxisPanel.this.mInReload = false;
        }
    }

    class CatComparator
    implements Comparator<RelabelBag> {
        private int mCompType;
        private int mDirection;
        private boolean mIsNumeric;

        public CatComparator(int n, int n2, boolean bl) {
            this.mCompType = n;
            this.mDirection = n2;
            this.mIsNumeric = bl;
        }

        @Override
        public int compare(RelabelBag relabelBag, RelabelBag relabelBag2) {
            int n = 0;
            if (this.mCompType == 1) {
                n = relabelBag.getStrTo().compareTo(relabelBag2.getStrTo());
            } else if (this.mCompType == 2) {
                double d;
                double d2;
                n = this.mIsNumeric ? ((d2 = Double.valueOf(relabelBag.getStrOrgValue()).doubleValue()) < (d = Double.valueOf(relabelBag2.getStrOrgValue()).doubleValue()) ? -1 : (d2 == d ? 0 : 1)) : relabelBag.getStrOrgValue().compareTo(relabelBag2.getStrOrgValue());
            }
            if (this.mDirection == 1) {
                n = -n;
            }
            return n;
        }
    }

    class IncludeButton
    extends JButton {
        public IncludeButton() {
            this.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CategoricalAxisPanel.this.includeSelected();
                }
            });
            String string = ResUtil.getCommonDlgString("IDS_INCLUDE_IMAGE");
            ImageIcon imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(string));
            this.setIcon(imageIcon);
            string = ResUtil.getCommonDlgString("IDS_INCLUDE_DISABLED_IMAGE");
            this.setDisabledIcon(new ImageIcon(ResUtil.getCommonDlgImageResource(string)));
            Image image = imageIcon.getImage().getScaledInstance(imageIcon.getIconHeight() + 1, imageIcon.getIconHeight() + 1, 4);
            this.setRolloverIcon(new ImageIcon(image));
            image = imageIcon.getImage().getScaledInstance(imageIcon.getIconHeight() - 1, imageIcon.getIconHeight() - 1, 4);
            this.setPressedIcon(new ImageIcon(image));
        }
    }

    class CollapseSmallAction
    extends AbstractAction {
        public CollapseSmallAction() {
            this.putValue("Name", CategoricalAxisPanel.this.mResources.getResString("IDS_COLLAPSE_SMALL_CATS"));
            this.putValue("MnemonicKey", CategoricalAxisPanel.this.mResources.getDlgAccessKey("IDK_COLLAPSE_SMALL_CATS_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = CategoricalAxisPanel.this.mCollapseSmallCheck.isSelected();
            CategoricalAxisPanel.this.mCollapsePctLabel.setEnabled(!CategoricalAxisPanel.this.mDisableCollapse && bl);
            CategoricalAxisPanel.this.mCollapsePctEdit.setEnabled(!CategoricalAxisPanel.this.mDisableCollapse && bl);
            CategoricalAxisPanel.this.mModListener.itemModified();
        }
    }

    class ShowCatsAction
    extends AbstractAction {
        private boolean mShowEmpty;

        public ShowCatsAction(boolean bl) {
            this.mShowEmpty = bl;
            String string = this.mShowEmpty ? "IDS_SHOW_EMPTY_CATS" : "IDS_SHOW_PRESENT_CATS";
            this.putValue("Name", CategoricalAxisPanel.this.mResources.getResString(string));
            string = this.mShowEmpty ? "IDK_SHOW_EMPTY_CATS_KEY" : "IDK_SHOW_PRESENT_CATS_KEY";
            this.putValue("MnemonicKey", CategoricalAxisPanel.this.mResources.getDlgAccessKey(string));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = !this.mShowEmpty;
            boolean bl2 = CategoricalAxisPanel.this.mCollapseSmallCheck.isSelected();
            CategoricalAxisPanel.this.mCollapseSmallCheck.setEnabled(!CategoricalAxisPanel.this.mDisableCollapse && bl);
            CategoricalAxisPanel.this.mCollapsePctLabel.setEnabled(!CategoricalAxisPanel.this.mDisableCollapse && bl && bl2);
            CategoricalAxisPanel.this.mCollapsePctEdit.setEnabled(!CategoricalAxisPanel.this.mDisableCollapse && bl && bl2);
            CategoricalAxisPanel.this.mModListener.itemModified();
        }
    }
}

