/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderOptions;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BasePropertiesPanel;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.IntTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class CBOptionsPanel
extends BasePropertiesPanel {
    private ChartBuilderOptions mOptions;
    private JRadioButton mExcludeBreakRadio;
    private JRadioButton mExcludeListwiseRadio;
    private IntTextField mScaleText;
    private JCheckBox mWrapPanelsCheck;
    private Vector<Object> mFocusTraversal;

    public CBOptionsPanel(ChartBuilderDlg chartBuilderDlg, ChartBuilderOptions chartBuilderOptions) {
        super(chartBuilderDlg);
        this.mOptions = chartBuilderOptions;
        this.init();
        this.initializeData();
    }

    public boolean saveState(DialogDataModel dialogDataModel) {
        String string = this.mScaleText.getText();
        if (string != null && string.length() > 0) {
            this.mOptions.setChartSizePct(Integer.valueOf(string));
        }
        this.mOptions.setIncludeBreakVars(!this.mExcludeBreakRadio.isSelected());
        this.mOptions.setExcludeListwise(this.mExcludeListwiseRadio.isSelected());
        this.mOptions.setWrapPanels(this.mWrapPanelsCheck.isSelected());
        return true;
    }

    @Override
    protected boolean canSwitchTab() {
        if (this.mScaleText.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.mChartBuilderDlg.getResString("ERR_NO_SIZE"), VersionInfo.getAppVersionString());
            this.mScaleText.requestFocus();
            return false;
        }
        return this.mScaleText.checkRange();
    }

    private void initializeData() {
        this.mExcludeBreakRadio.setSelected(true);
        this.mExcludeListwiseRadio.setSelected(true);
        this.mScaleText.setText("100");
    }

    private void init() {
        this.mFocusTraversal = new Vector();
        this.setLayout(new GridBagLayout());
        this.setupUserMissingPanel();
        this.setupLowerPanels();
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.mFocusTraversal, false));
    }

    private void setupUserMissingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(new TitledBorder(this.mChartBuilderDlg.getResString("IDS_USER_MISSING")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JLabel jLabel = new JLabel();
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        jLabel.setIcon(new ImageIcon(uRL));
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(3, n2, n2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.mChartBuilderDlg.getResString("IDS_SYSMIS_INFO"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(true);
        jTextArea.setEditable(false);
        jTextArea.setEnabled(true);
        TextAreaFocusListener textAreaFocusListener = new TextAreaFocusListener(jTextArea);
        jTextArea.addFocusListener(textAreaFocusListener);
        this.mFocusTraversal.add(jTextArea);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(3, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(new TitledBorder(this.mChartBuilderDlg.getResString("IDS_BREAK_VARS")));
        insets = new Insets(3, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        this.mFocusTraversal.add(spssButtonGroup);
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.bottom = 0;
        this.mExcludeBreakRadio = new JRadioButton(new ToggleButtonAction(this.mChartBuilderDlg, "IDS_EXCLUDE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mExcludeBreakRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        spssButtonGroup.add(this.mExcludeBreakRadio);
        JRadioButton jRadioButton = new JRadioButton(new ToggleButtonAction(this.mChartBuilderDlg, "IDS_INCLUDE"));
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        DialogUtil.addUsingGBL(jPanel2, jRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        spssButtonGroup.add(jRadioButton);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        jPanel3.setBorder(new TitledBorder(this.mChartBuilderDlg.getResString("IDS_SUMMARY_STATS")));
        insets = new Insets(3, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 2, 1, n, insets);
        spssButtonGroup = new SpssButtonGroup();
        this.mFocusTraversal.add(spssButtonGroup);
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.bottom = 0;
        this.mExcludeListwiseRadio = new JRadioButton(new ToggleButtonAction(this.mChartBuilderDlg, "IDS_EXCLUDE_LISTWISE"));
        DialogUtil.addUsingGBL(jPanel3, this.mExcludeListwiseRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        spssButtonGroup.add(this.mExcludeListwiseRadio);
        JRadioButton jRadioButton2 = new JRadioButton(new ToggleButtonAction(this.mChartBuilderDlg, "IDS_EXCLUDE_VARIABLEWISE"));
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        DialogUtil.addUsingGBL(jPanel3, jRadioButton2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        spssButtonGroup.add(jRadioButton2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardButtonInsets().clone();
        insets.top = 1;
        insets.bottom = insets2.bottom;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private void setupLowerPanels() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(new TitledBorder(this.mChartBuilderDlg.getResString("IDS_CHART_SIZE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = new Insets(3, n, n, 0);
        this.mScaleText = new IntTextField(25, 400, true);
        this.mFocusTraversal.add(this.mScaleText);
        this.mScaleText.setAction((Action)new TextFieldAction(this.mChartBuilderDlg, "chart_scale"));
        this.mScaleText.setColumns(6);
        this.mScaleText.setPreferredSize(this.mScaleText.getPreferredSize());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mScaleText, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JLabel jLabel = new JLabel("%", 2);
        jLabel.setLabelFor((Component)this.mScaleText);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.top = insets2.top;
        insets.bottom = 0;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(new TitledBorder(this.mChartBuilderDlg.getResString("IDS_PANELS")));
        this.mWrapPanelsCheck = new JCheckBox(new ToggleButtonAction(this.mChartBuilderDlg, "IDS_WRAP_PANELS"));
        this.mFocusTraversal.add(this.mWrapPanelsCheck);
        DialogUtil.addUsingGBL(jPanel2, this.mWrapPanelsCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        insets.top = insets2.top;
        insets.bottom = 0;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
    }

    private class TextAreaFocusListener
    implements FocusListener {
        private JTextArea mJTA;

        public TextAreaFocusListener(JTextArea jTextArea) {
            this.mJTA = jTextArea;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.mJTA.setBorder(new LineBorder(Color.BLACK));
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.mJTA.setBorder(null);
        }
    }
}

