/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BinningPanel
extends JPanel
implements DocumentListener,
ActionListener,
FocusListener {
    protected ChartCanvas mCanvas;
    protected IModListener mModListener;
    protected ElementStat mElStat;
    protected boolean mInReload;
    private JPanel mTopPanel;
    private JRadioButton mAutoAnchorRadio;
    private JRadioButton mCustomAnchorRadio;
    private JTextField mCustomAnchorEdit;
    private JRadioButton mAutoBinRadio;
    private JRadioButton mCustomBinRadio;
    private JRadioButton mBinCountRadio;
    private JRadioButton mBinWidthRadio;
    private IntTextField mBinCountEdit;
    private FloatTextField mBinWidthEdit;
    private SpssButtonGroup mFirstBinGroup;
    private SpssButtonGroup mBinSizeGroup;
    private SpssButtonGroup mBinIntervalGroup;
    private boolean mIsEditFieldDirty = false;

    public BinningPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(new GridBagLayout(), true);
        this.mCanvas = chartCanvas;
        this.mModListener = iModListener;
        this.mInReload = false;
        this.initControls();
        this.mAutoAnchorRadio.addActionListener(this);
        this.mCustomAnchorRadio.addActionListener(this);
        this.mAutoBinRadio.addActionListener(this);
        this.mCustomBinRadio.addActionListener(this);
        this.mBinCountRadio.addActionListener(this);
        this.mBinWidthRadio.addActionListener(this);
        this.mBinCountEdit.getDocument().addDocumentListener(this);
        this.mBinWidthEdit.getDocument().addDocumentListener(this);
        this.mBinCountEdit.addFocusListener((FocusListener)this);
        this.mBinWidthEdit.addFocusListener((FocusListener)this);
    }

    protected boolean canSwitchTab() {
        return this.checkComplete(true);
    }

    boolean checkComplete(boolean bl) {
        boolean bl2;
        JTextField jTextField = null;
        boolean bl3 = bl2 = this.mAutoAnchorRadio.isSelected() || this.mCustomAnchorEdit.getText().length() > 0;
        if (!bl2 && bl) {
            jTextField = this.mCustomAnchorEdit;
        }
        if (bl2 && this.mCustomBinRadio.isSelected()) {
            if (this.mBinCountRadio.isSelected()) {
                bl2 = this.mBinCountEdit.getText().length() > 0;
                jTextField = this.mBinCountEdit;
            } else {
                bl2 = this.mBinWidthEdit.getText().length() > 0;
                jTextField = this.mBinWidthEdit;
            }
        }
        if (bl && !bl2) {
            SpssAlertOptionPane.showInformationMessageDialog(this, ResUtil.getCommonDlgString("ERR_OUT_OF_RANGE_ERROR_MSG"), VersionInfo.getAppVersionString());
            final JTextField jTextField2 = jTextField;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTextField2.requestFocusInWindow();
                    jTextField2.selectAll();
                }
            });
        }
        return bl2;
    }

    public void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mFirstBinGroup);
        vector.add(this.mCustomAnchorEdit);
        vector.add(this.mBinSizeGroup);
        vector.add(this.mBinIntervalGroup);
        vector.add(this.mBinCountEdit);
        vector.add(this.mBinWidthEdit);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.mAutoAnchorRadio.setEnabled(bl);
        this.mCustomAnchorRadio.setEnabled(bl);
        this.mCustomAnchorEdit.setEnabled(bl && this.mCustomAnchorRadio.isSelected());
        this.mAutoBinRadio.setEnabled(bl);
        this.mCustomBinRadio.setEnabled(bl);
        this.mBinCountRadio.setEnabled(bl && this.mCustomBinRadio.isSelected());
        this.mBinWidthRadio.setEnabled(bl && this.mCustomBinRadio.isSelected());
        this.mBinCountEdit.setEnabled(bl && this.mCustomBinRadio.isSelected() && this.mBinCountRadio.isSelected());
        this.mBinWidthEdit.setEnabled(bl && this.mCustomBinRadio.isSelected() && this.mBinWidthRadio.isSelected());
    }

    void initialize(ElementStat elementStat) {
        this.mInReload = true;
        if (elementStat != null) {
            this.mElStat = elementStat;
            this.recreateCustomAnchorEdit();
            if (this.mElStat.getAnchorType() == 0) {
                this.mAutoAnchorRadio.setSelected(true);
                this.mCustomAnchorEdit.setEnabled(false);
            } else {
                this.mCustomAnchorRadio.setSelected(true);
                this.mCustomAnchorEdit.setEnabled(true);
                this.mCustomAnchorEdit.setText(this.mElStat.getStrParm1());
            }
            if (this.mElStat.getBinSize() == 0) {
                this.mAutoBinRadio.setSelected(true);
                this.mBinCountRadio.setEnabled(false);
                this.mBinCountEdit.setEnabled(false);
                this.mBinWidthRadio.setEnabled(false);
                this.mBinWidthEdit.setEnabled(false);
            } else {
                this.mCustomBinRadio.setSelected(true);
                this.mBinCountRadio.setEnabled(true);
                this.mBinWidthRadio.setEnabled(true);
            }
            if (this.mElStat.getBinSizeCustom() == 0) {
                this.mBinCountRadio.setSelected(true);
                this.mBinCountEdit.setText(this.mElStat.getStrParm2());
                this.mBinCountEdit.setEnabled(this.mElStat.getBinSize() != 0);
                this.mBinWidthEdit.setEnabled(false);
                this.mBinWidthEdit.setText("");
            } else {
                this.mBinWidthRadio.setSelected(true);
                this.mBinWidthEdit.setText(this.mElStat.getStrParm2());
                this.mBinCountEdit.setEnabled(false);
                this.mBinWidthEdit.setEnabled(this.mElStat.getBinSize() != 0);
                this.mBinCountEdit.setText("");
            }
        }
        this.mInReload = false;
    }

    boolean applyChanges() {
        if (!this.checkComplete(true)) {
            return false;
        }
        int n = this.mAutoAnchorRadio.isSelected() ? 0 : 1;
        this.mElStat.setAnchorType(n);
        int n2 = this.mAutoBinRadio.isSelected() ? 0 : 1;
        this.mElStat.setBinSize(n2);
        int n3 = this.mBinCountRadio.isSelected() ? 0 : 1;
        this.mElStat.setBinSizeCustom(n3);
        if (this.mCustomAnchorRadio.isSelected()) {
            this.mElStat.setStrParm1(this.mCustomAnchorEdit.getText());
        }
        if (this.mBinCountRadio.isSelected()) {
            this.mElStat.setStrParm2(this.mBinCountEdit.getText());
        } else {
            this.mElStat.setStrParm2(this.mBinWidthEdit.getText());
        }
        this.mIsEditFieldDirty = false;
        return true;
    }

    ElementStat getStatistic() {
        return this.mElStat;
    }

    private void recreateCustomAnchorEdit() {
        this.mTopPanel.remove(this.mCustomAnchorEdit);
        this.mCustomAnchorEdit.getDocument().removeDocumentListener(this);
        this.mCustomAnchorEdit.removeFocusListener(this);
        ISpssVariable iSpssVariable = this.mElStat.getVariable();
        this.mCustomAnchorEdit = iSpssVariable != null && iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat() ? new DateTextField(iSpssVariable.getFormat()) : new FloatTextField(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        this.mCustomAnchorEdit.setColumns(8);
        Insets insets = new Insets(0, 2, n, n);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mTopPanel, this.mCustomAnchorEdit, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        this.mCustomAnchorEdit.getDocument().addDocumentListener(this);
        this.mCustomAnchorEdit.addFocusListener(this);
    }

    private void initControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, 2, n);
        int n2 = 23;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.mTopPanel = new JPanel(new GridBagLayout(), true);
        this.mTopPanel.setBorder(BorderFactory.createTitledBorder(this.mCanvas.getResources().getResString("IDS_ANCHOR_1ST_BIN")));
        DialogUtil.addUsingGBL(this, this.mTopPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.mFirstBinGroup = new SpssButtonGroup();
        Insets insets2 = new Insets(0, n, n, n);
        this.mAutoAnchorRadio = new JRadioButton(new AnchorAction(false));
        DialogUtil.addUsingGBL(this.mTopPanel, this.mAutoAnchorRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mFirstBinGroup.add(this.mAutoAnchorRadio);
        gridBagConstraints.weighty = 1.0;
        this.mCustomAnchorRadio = new JRadioButton(new AnchorAction(true));
        insets2 = new Insets(0, n, n, 2);
        DialogUtil.addUsingGBL(this.mTopPanel, this.mCustomAnchorRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        this.mFirstBinGroup.add(this.mCustomAnchorRadio);
        this.mCustomAnchorEdit = new FloatTextField(false);
        this.mCustomAnchorEdit.setColumns(8);
        insets2 = new Insets(0, 2, n, n);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mTopPanel, this.mCustomAnchorEdit, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mCanvas.getResources().getResString("IDS_BIN_SIZES")));
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.mBinSizeGroup = new SpssButtonGroup();
        insets2 = new Insets(0, n, n, n);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.mAutoBinRadio = new JRadioButton(new BinSizeAction(false));
        DialogUtil.addUsingGBL(jPanel, this.mAutoBinRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mBinSizeGroup.add(this.mAutoBinRadio);
        gridBagConstraints.weighty = 1.0;
        this.mCustomBinRadio = new JRadioButton(new BinSizeAction(true));
        insets2 = new Insets(0, n, n, 2);
        DialogUtil.addUsingGBL(jPanel, this.mCustomBinRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        this.mBinSizeGroup.add(this.mCustomBinRadio);
        this.mBinIntervalGroup = new SpssButtonGroup();
        this.mBinCountRadio = new JRadioButton(new IntervalsAction(true));
        Insets insets3 = new Insets(0, n * 4, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mBinCountRadio, gridBagConstraints, 0, 2, 1, 1, n2, insets3);
        this.mBinIntervalGroup.add(this.mBinCountRadio);
        this.mBinCountEdit = new IntTextField(3, 400, true);
        this.mBinCountEdit.setColumns(6);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        insets2 = new Insets(0, 2, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mBinCountEdit, gridBagConstraints, 1, 2, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 1.0;
        this.mBinWidthRadio = new JRadioButton(new IntervalsAction(false));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mBinWidthRadio, gridBagConstraints, 0, 3, 1, 1, n2, insets3);
        this.mBinIntervalGroup.add(this.mBinWidthRadio);
        this.mBinWidthEdit = new FloatTextField(1.0, 400000.0, 6, true);
        this.mBinWidthEdit.setColumns(6);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        insets2 = new Insets(0, 2, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mBinWidthEdit, gridBagConstraints, 1, 3, 1, 1, n2, insets2);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.mIsEditFieldDirty = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.mIsEditFieldDirty = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.mIsEditFieldDirty = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mIsEditFieldDirty) {
            this.mModListener.itemModified();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (this.mIsEditFieldDirty && object instanceof JTextField) {
            this.mModListener.itemModified();
            this.mIsEditFieldDirty = false;
        }
    }

    class DateTextField
    extends JTextField {
        private SPSS_Format mFormat;

        public DateTextField(SPSS_Format sPSS_Format) {
            this.mFormat = sPSS_Format;
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    String string;
                    if (focusEvent.getOppositeComponent() == null) {
                        return;
                    }
                    if (focusEvent.getOppositeComponent() instanceof JButton && ((string = ((JButton)focusEvent.getOppositeComponent()).getText()).equals(UIToolResUtil.getString((String)"IDS_CANCEL")) || string.equals(UIToolResUtil.getString((String)"IDS_RESET")))) {
                        return;
                    }
                    DateTextField.this.checkFormat();
                }
            });
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.setOpaque(bl);
        }

        public Date getDate() {
            String string = this.getText();
            if (string.length() > 0) {
                Object object = CellValueFormatter.parseDate((SPSS_Format)this.mFormat, (String)string);
                if (!(object instanceof Date)) {
                    object = CellValueFormatter.parseDate((String)string);
                }
                if (object instanceof Date) {
                    return (Date)object;
                }
            }
            return null;
        }

        private void checkFormat() {
            Date date;
            String string = this.getText();
            if (string.length() > 0 && (date = this.getDate()) == null) {
                SpssAlertOptionPane.showErrorMessageDialog(this, BinningPanel.this.mCanvas.getResources().getResString("ERR_BINNING_INVALID_DATA"), VersionInfo.getAppVersionString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BinningPanel.this.mCustomAnchorEdit.requestFocus();
                        BinningPanel.this.mCustomAnchorEdit.selectAll();
                    }
                });
            }
        }
    }

    class IntervalsAction
    extends AbstractAction {
        private boolean mUseCount;

        IntervalsAction(boolean bl) {
            this.mUseCount = bl;
            this.putValue("Name", BinningPanel.this.mCanvas.getResources().getResString(this.mUseCount ? "IDS_NUM_INTERVALS" : "IDS_INTERVAL_WIDTH"));
            this.putValue("MnemonicKey", BinningPanel.this.mCanvas.getResources().getDlgAccessKey(this.mUseCount ? "IDK_NUM_INTERVALS_KEY" : "IDK_INTERVAL_WIDTH_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BinningPanel.this.mBinCountEdit.setEnabled(this.mUseCount);
            BinningPanel.this.mBinWidthEdit.setEnabled(!this.mUseCount);
        }
    }

    class BinSizeAction
    extends AbstractAction {
        private boolean mIsCustom;

        BinSizeAction(boolean bl) {
            this.mIsCustom = bl;
            this.putValue("Name", BinningPanel.this.mCanvas.getResources().getResString(!this.mIsCustom ? "IDS_AUTO_BIN_SIZE" : "IDS_CUSTOM_BIN_SIZE"));
            this.putValue("MnemonicKey", BinningPanel.this.mCanvas.getResources().getDlgAccessKey(!this.mIsCustom ? "IDK_AUTO_BIN_SIZE_KEY" : "IDK_CUSTOM_BIN_SIZE_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.mIsCustom;
            boolean bl2 = false;
            if (bl) {
                bl2 = BinningPanel.this.mBinCountRadio.isSelected();
            }
            BinningPanel.this.mBinCountRadio.setEnabled(bl);
            BinningPanel.this.mBinWidthRadio.setEnabled(bl);
            BinningPanel.this.mBinCountEdit.setEnabled(bl && bl2);
            BinningPanel.this.mBinWidthEdit.setEnabled(bl && !bl2);
        }
    }

    class AnchorAction
    extends AbstractAction {
        private boolean mIsCustom;

        AnchorAction(boolean bl) {
            this.mIsCustom = bl;
            this.putValue("Name", BinningPanel.this.mCanvas.getResources().getResString(!this.mIsCustom ? "IDS_AUTO_ANCHOR" : "IDS_CUSTOM_ANCHOR"));
            this.putValue("MnemonicKey", BinningPanel.this.mCanvas.getResources().getDlgAccessKey(!this.mIsCustom ? "IDK_AUTO_ANCHOR_KEY" : "IDK_CUSTOM_ANCHOR_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BinningPanel.this.mCustomAnchorEdit.setEnabled(this.mIsCustom);
        }
    }
}

