/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.BaseStylePanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ListLabel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class BarStylePanel
extends BaseStylePanel
implements ActionListener {
    private JComboBox mItemList;
    private Props.BarProps mBarProp;
    private Props.HiLoCloseProps mHLCProp;
    private boolean mInReload = false;

    public BarStylePanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.init();
        this.mItemList.addActionListener(this);
    }

    @Override
    boolean applyChanges() {
        int n = this.mItemList.getSelectedIndex();
        if (n > -1) {
            ListLabel listLabel = (ListLabel)this.mItemList.getModel().getElementAt(n);
            if (this.mBarProp != null) {
                this.mBarProp.setIntervalStyle(listLabel.getIntervalStyle());
            } else if (this.mHLCProp != null) {
                this.mHLCProp.setIntervalStyle(listLabel.getIntervalStyle());
            }
        }
        return true;
    }

    @Override
    void initialize(Props.ElProps elProps) {
        this.mInReload = true;
        if (elProps instanceof Props.BarProps) {
            this.mBarProp = (Props.BarProps)elProps;
            this.mHLCProp = null;
            this.mItemList.setSelectedIndex(this.findListIndex(this.mBarProp.getIntervalStyle()));
        } else if (elProps instanceof Props.HiLoCloseProps) {
            this.mHLCProp = (Props.HiLoCloseProps)elProps;
            this.mBarProp = null;
            this.mItemList.setSelectedIndex(this.findListIndex(this.mHLCProp.getIntervalStyle()));
        }
        this.mInReload = false;
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mItemList);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        this.mModListener.itemModified();
    }

    private int findListIndex(IPropEnum.IntervalStyle intervalStyle) {
        for (int i = 0; i < this.mItemList.getModel().getSize(); ++i) {
            ListLabel listLabel = (ListLabel)this.mItemList.getModel().getElementAt(i);
            if (listLabel.getIntervalStyle() != intervalStyle) continue;
            return i;
        }
        return -1;
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_BAR_STYLE"));
        jLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_BAR_STYLE_KEY"));
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mItemList = new JComboBox<Object>(this.getItems());
        this.mItemList.setEditable(false);
        this.mItemList.setRenderer(new ListLabel((IPropEnum.IntervalStyle)null, null, null, 10));
        insets = new Insets(0, n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mItemList, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jLabel.setLabelFor(this.mItemList);
    }

    private Object[] getItems() {
        Vector<ListLabel> vector = new Vector<ListLabel>();
        String string = this.mCanvas.getResources().getResString("IDS_BAR");
        ImageIcon imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_BAR_SMALL_IMAGE"));
        ListLabel listLabel = new ListLabel(IPropEnum.IntervalStyle.is_Square, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_IBEAM");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_IBEAM_SMALL_IMAGE"));
        listLabel = new ListLabel(IPropEnum.IntervalStyle.is_IBeam, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        string = this.mCanvas.getResources().getResString("IDS_WHISKER");
        imageIcon = new ImageIcon(this.mCanvas.getResources().getResImageURL("IDS_LINE_SMALL_IMAGE"));
        listLabel = new ListLabel(IPropEnum.IntervalStyle.is_Line, string, (Icon)imageIcon, 10);
        vector.add(listLabel);
        ListLabel[] listLabelArray = new ListLabel[vector.size()];
        return vector.toArray(listLabelArray);
    }
}

