/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.PropertiesPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.res.IResourceAccessor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AngleAxisPanel
extends PropertiesPanel
implements ActionListener {
    protected IResourceAccessor mResources;
    private Props.AngleAxisProps mProp;
    private boolean mInReload;
    private JLabel mVarPromptLabel;
    private JLabel mVarNameLabel;
    private JComboBox mClockPosCombo;
    private JComboBox mClockDirectionCombo;
    private JCheckBox mAxisCheck;
    private boolean mIsSummaryVariable;

    public AngleAxisPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.mResources = chartCanvas.getResources();
        this.init();
        this.mClockPosCombo.addActionListener(this);
        this.mClockDirectionCombo.addActionListener(this);
        this.mAxisCheck.addActionListener(this);
    }

    @Override
    public String getPanelId() {
        return "angle_panel";
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mClockPosCombo);
        vector.add(this.mClockDirectionCombo);
        vector.add(this.mAxisCheck);
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        this.mInReload = true;
        if (props instanceof Props.AngleAxisProps) {
            this.mProp = (Props.AngleAxisProps)props;
            String string = "";
            this.mIsSummaryVariable = false;
            DropZone dropZone = this.mCanvas.getZoneMgr().getZone(this.mProp.getZoneType());
            if (dropZone != null && !dropZone.isEmpty()) {
                Object object;
                this.mVarPromptLabel.setEnabled(true);
                this.mVarNameLabel.setEnabled(true);
                if (dropZone.isDependentVarZone() && this.mCanvas.getImager().hasSSVs()) {
                    string = this.mResources.getResString("IDS_SUMMARY");
                    this.mVarPromptLabel.setEnabled(true);
                    this.mVarNameLabel.setEnabled(true);
                    object = ResUtil.getCommonDlgString("IDS_SCALE_VAR_IMAGE");
                    URL uRL = ResUtil.getCommonDlgImageResource((String)object);
                    this.mVarNameLabel.setIcon(new ImageIcon(uRL));
                    if (ComponentState.isBtdRtlOrLtr()) {
                        this.mVarNameLabel.setText(ComponentState.prepareStringForBidiRendering((String)string));
                    } else {
                        this.mVarNameLabel.setText(string);
                    }
                    this.mIsSummaryVariable = true;
                } else {
                    this.mVarPromptLabel.setEnabled(true);
                    this.mVarNameLabel.setEnabled(true);
                    object = dropZone.getVariables().get(0);
                    this.mVarNameLabel.setIcon(VariableList.getStandardIcon(object));
                    String string2 = object.getLabel();
                    if (string2 == null || string2.length() == 0) {
                        string2 = object.getName();
                    }
                    if (ComponentState.isBtdRtlOrLtr()) {
                        this.mVarNameLabel.setText(ComponentState.prepareStringForBidiRendering((String)string2));
                    } else {
                        this.mVarNameLabel.setText(string2);
                    }
                    string = string2;
                }
            } else {
                this.mVarNameLabel.setIcon(null);
                this.mVarNameLabel.setText(null);
                this.mVarPromptLabel.setEnabled(false);
                this.mVarNameLabel.setEnabled(false);
            }
            if (ComponentState.isBtdRtlOrLtr()) {
                this.mVarNameLabel.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                this.mVarNameLabel.setToolTipText(string);
            }
            this.mClockPosCombo.setSelectedIndex(this.mProp.getClockPos() - 1);
            boolean bl = this.mProp.getClockOrder() == IPropEnum.PolarClockOrder.pco_Clockwise;
            this.mClockDirectionCombo.setSelectedIndex(bl ? 0 : 1);
            this.mAxisCheck.setSelected((this.mProp.getFlags() & 0x20) != 0);
        }
        this.mInReload = false;
    }

    @Override
    boolean applyChanges() {
        int n = this.mClockPosCombo.getSelectedIndex() + 1;
        this.mProp.setClockPos(n);
        IPropEnum.PolarClockOrder polarClockOrder = this.mClockDirectionCombo.getSelectedIndex() == 1 ? IPropEnum.PolarClockOrder.pco_CounterClockwise : IPropEnum.PolarClockOrder.pco_Clockwise;
        this.mProp.setClockOrder(polarClockOrder);
        int n2 = this.mProp.getFlags();
        n2 = this.mAxisCheck.isSelected() ? (n2 |= 0x20) : (n2 &= 0xFFFFFFDF);
        this.mProp.setFlags(n2);
        return true;
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.mIsSummaryVariable) {
            Point point = this.mVarNameLabel.getBounds().getLocation();
            Point point2 = SwingUtilities.convertPoint(this.mVarNameLabel.getParent(), point, this);
            graphics.setFont(this.mVarNameLabel.getFont());
            graphics.drawString("*", point2.x + 11, point2.y + 18);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        this.mModListener.itemModified();
    }

    @Override
    protected String getDlgHelpId() {
        return "idh_idc_cg_help_axis_props";
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        this.mVarPromptLabel = new JLabel(this.mResources.getResString("IDS_VARIABLE"));
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 * 2, n2, n2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mVarPromptLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mVarNameLabel = new JLabel();
        insets = new Insets(n2 * 2, 1, n2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mVarNameLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mResources.getResString("IDS_ANGLE")));
        insets = new Insets(n2, 2, n2, 2);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        URL uRL = this.mResources.getResImageURL("IDS_CLOCK_POS_IMAGE");
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 3, n, insets);
        jLabel.setBorder(BorderFactory.createBevelBorder(1));
        JLabel jLabel2 = new JLabel(this.mResources.getResString("IDS_START_FIRST"));
        jLabel2.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_START_FIRST_KEY"));
        insets = new Insets(0, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JLabel jLabel3 = new JLabel(this.mResources.getResString("IDS_CLOCK_POS"));
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        String[] stringArray = new String[]{"1:00", "2:00", "3:00", "4:00", "5:00", "6:00", "7:00", "8:00", "9:00", "10:00", "11:00", "12:00"};
        this.mClockPosCombo = new JComboBox<String>(stringArray);
        insets = new Insets(2, n2, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mClockPosCombo, gridBagConstraints, 1, 2, 1, 1, n, insets);
        jLabel2.setLabelFor(this.mClockPosCombo);
        JLabel jLabel4 = new JLabel(this.mResources.getResString("IDS_DIRECTION"));
        jLabel4.setDisplayedMnemonic(this.mResources.getDlgAccessKey("IDK_DIRECTION_KEY"));
        insets = new Insets(n2, n2, 0, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 3, 1, 1, n, insets);
        String[] stringArray2 = new String[]{this.mResources.getResString("IDS_CLOCKWISE"), this.mResources.getResString("IDS_COUNTER_CLOCKWISE")};
        this.mClockDirectionCombo = new JComboBox<String>(stringArray2);
        insets = new Insets(2, n2, n2 * 2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mClockDirectionCombo, gridBagConstraints, 1, 3, 1, 1, n, insets);
        jLabel4.setLabelFor(this.mClockDirectionCombo);
        this.mAxisCheck = new JCheckBox(this.mResources.getResString("IDS_DISPLAY_AXIS"));
        this.mAxisCheck.setMnemonic(this.mResources.getDlgAccessKey("IDK_DISPLAY_AXIS_KEY"));
        insets = new Insets(n2, n2 * 2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mAxisCheck, gridBagConstraints, 0, 2, 2, 1, n, insets);
    }
}

