/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.IndexVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneChangeType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.uitools.res.IResourceAccessor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class ZoneMgr {
    private TreeMap<ZoneType, DropZone> mDropZones = new TreeMap();
    private IResourceAccessor mResources;
    private ChartCanvas mCanvas;

    public ZoneMgr(ChartCanvas chartCanvas, IResourceAccessor iResourceAccessor) {
        this.mCanvas = chartCanvas;
        this.mResources = iResourceAccessor;
    }

    public void addZone(ChartCanvas chartCanvas, ZoneType zoneType) {
        DropZone dropZone = new DropZone(chartCanvas, zoneType, this.mResources);
        dropZone.setBounds(chartCanvas);
        this.mDropZones.put(zoneType, dropZone);
    }

    public void removeZone(ZoneType zoneType) {
        this.mDropZones.remove((Object)zoneType);
    }

    public DropZone getZone(ZoneType zoneType) {
        return this.mDropZones.get((Object)zoneType);
    }

    public void setZoneType(DropZone dropZone, ZoneType zoneType) {
        if (dropZone == null || !dropZone.isStyleByZone()) {
            return;
        }
        this.mDropZones.remove((Object)dropZone.getZoneType());
        this.mDropZones.put(zoneType, dropZone);
        dropZone.setZoneType(zoneType);
    }

    public void clear() {
        this.mDropZones.clear();
    }

    public void removeSSVVariables() {
        DropZone dropZone;
        ZoneType zoneType = this.getIndexVarZoneType();
        if (zoneType != null) {
            this.getZone(zoneType).clear();
            this.mCanvas.getImager().zoneChange(this, zoneType, ZoneChangeType.removeVariable);
        }
        if ((dropZone = this.getSummaryZone()) != null) {
            dropZone.clear();
            this.mCanvas.getImager().zoneChange(this, dropZone.getZoneType(), ZoneChangeType.removeVariable);
        }
        this.mCanvas.getImager().removeSSVVariables();
        if (zoneType != null || dropZone != null) {
            DropZone.setRoleStatDisplay(this.hasVariables());
        }
    }

    public DropZone getSummaryZone() {
        ZoneType zoneType = this.mCanvas.getImager().getCoordinates() == Coords.coords_Polar ? ZoneType.zt_angle : ZoneType.zt_y;
        return this.getZone(zoneType);
    }

    public IndexVariable getIndexVariable() {
        IndexVariable indexVariable = null;
        ZoneType zoneType = this.getIndexVarZoneType();
        if (zoneType != null) {
            indexVariable = (IndexVariable)this.getZone(zoneType).getVariables().get(0);
        }
        return indexVariable;
    }

    public ZoneType getIndexVarZoneType() {
        ZoneType[] zoneTypeArray;
        ZoneType zoneType = null;
        for (ZoneType zoneType2 : zoneTypeArray = new ZoneType[]{ZoneType.zt_x, ZoneType.zt_z, ZoneType.zt_cluster_x, ZoneType.zt_cluster_z, ZoneType.zt_group, ZoneType.zt_slice_by, ZoneType.zt_panel_horz, ZoneType.zt_panel_vert}) {
            DropZone dropZone = this.getZone(zoneType2);
            if (dropZone == null || dropZone.isEmpty() || !(dropZone.getVariables().get(0) instanceof IndexVariable)) continue;
            zoneType = dropZone.getZoneType();
            break;
        }
        return zoneType;
    }

    public ZoneType getVarZoneType(ISpssVariable iSpssVariable) {
        ZoneType[] zoneTypeArray;
        ZoneType zoneType = null;
        for (ZoneType zoneType2 : zoneTypeArray = new ZoneType[]{ZoneType.zt_x, ZoneType.zt_z, ZoneType.zt_cluster_x, ZoneType.zt_cluster_z, ZoneType.zt_group, ZoneType.zt_slice_by, ZoneType.zt_panel_horz, ZoneType.zt_panel_vert}) {
            DropZone dropZone = this.getZone(zoneType2);
            if (dropZone == null || dropZone.isEmpty() || !dropZone.getVariables().get(0).getName().equals(iSpssVariable.getName())) continue;
            zoneType = dropZone.getZoneType();
            break;
        }
        return zoneType;
    }

    public ISpssVariable[] getSummaryVariables() {
        ISpssVariable[] iSpssVariableArray = null;
        DropZone dropZone = this.getSummaryZone();
        if (dropZone != null) {
            Vector<ISpssVariable> vector = dropZone.getVariables();
            iSpssVariableArray = new ISpssVariable[vector.size()];
            iSpssVariableArray = vector.toArray(iSpssVariableArray);
        }
        return iSpssVariableArray;
    }

    public void setTranspose(boolean bl) {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            entry.getValue().setTranspose(bl);
        }
    }

    public void navKeyPressed(int n) {
        int n2 = 0;
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (entry.getValue().isFocused()) break;
            ++n2;
        }
        boolean bl = n == 37 || n == 38;
        int n3 = bl ? n2 - 1 : n2 + 1;
        if (n3 < 0) {
            n3 = this.mDropZones.size() - 1;
        }
        if (n3 >= this.mDropZones.size()) {
            n3 = 0;
        }
        n2 = 0;
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (n2 == n3) {
                this.setFocusZone(entry.getValue());
                break;
            }
            ++n2;
        }
    }

    public boolean sufficientVariables() {
        Object object;
        if (this.mCanvas.getImager().dataElementCount() == 0) {
            return false;
        }
        for (Map.Entry<ZoneType, DropZone> object22 : this.mDropZones.entrySet()) {
            if (!this.requiredZone(object22.getKey()) || object22.getKey() == ZoneType.zt_filter || !object22.getValue().isEmpty()) continue;
            return false;
        }
        Coords coords = this.mCanvas.getImager().getCoordinates();
        boolean bl = this.mCanvas.getImager().isSplom();
        if (bl) {
            object = this.getZone(ZoneType.zt_matrix);
            if (((DropZone)object).getVariables().size() < 2) {
                return false;
            }
        } else if (coords != Coords.coords_1D) {
            ZoneType zoneType = this.mCanvas.getImager().getDepZoneType();
            ElementStat elementStat = this.mCanvas.getImager().getStatForDependentZone(zoneType);
            object = this.mCanvas.getZoneMgr().getZone(zoneType);
            if (((DropZone)object).isEmpty() && !this.isLegalEmptyZoneStat(elementStat.getStat())) {
                return false;
            }
            if (coords == Coords.coords_DualY && this.mCanvas.getZoneMgr().getZone(ZoneType.zt_y2).isEmpty() && ((elementStat = this.mCanvas.getImager().getStatForDependentZone(ZoneType.zt_y2)) == null || !this.isLegalEmptyZoneStat(elementStat.getStat()))) {
                return false;
            }
        }
        return true;
    }

    public boolean hasVariables() {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMRVars() {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (entry.getValue().isEmpty() || !(entry.getValue().getVariables().get(0) instanceof SpssMRVariable)) continue;
            return true;
        }
        return false;
    }

    public boolean hasScaleVar(ZoneType zoneType) {
        DropZone dropZone = this.mDropZones.get((Object)zoneType);
        if (dropZone != null && !dropZone.isEmpty()) {
            for (ISpssVariable iSpssVariable : dropZone.getVariables()) {
                if (!iSpssVariable.getDisplayMeasurementLevel().equals((Object)MeasurementLevel.scale)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCatVar(ZoneType zoneType) {
        DropZone dropZone = this.mDropZones.get((Object)zoneType);
        if (dropZone != null && !dropZone.isEmpty()) {
            for (ISpssVariable iSpssVariable : dropZone.getVariables()) {
                if (iSpssVariable.getDisplayMeasurementLevel().equals((Object)MeasurementLevel.scale)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasVarInZone(ISpssVariable iSpssVariable, ZoneType zoneType) {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (entry.getKey().equals((Object)zoneType)) continue;
            for (ISpssVariable iSpssVariable2 : entry.getValue().getVariables()) {
                if (!iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasVarInPanelZone(ISpssVariable iSpssVariable) {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (entry.getKey() != ZoneType.zt_panel_horz && entry.getKey() != ZoneType.zt_panel_vert && entry.getKey() != ZoneType.zt_filter) continue;
            for (ISpssVariable iSpssVariable2 : entry.getValue().getVariables()) {
                if (!iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public DropZone hitTest(Point point) {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (!entry.getValue().pointWithin(point)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void rebuildZones(CanvasImager canvasImager, Coords coords) {
        boolean bl = canvasImager.isHiLoClose();
        boolean bl2 = canvasImager.isDifferenceArea();
        boolean bl3 = canvasImager.isPopulationPyramid();
        boolean bl4 = canvasImager.isSplom();
        ChartCanvas chartCanvas = canvasImager.getOwnerCanvas();
        TreeMap<ZoneType, DropZone> treeMap = new TreeMap<ZoneType, DropZone>();
        Coords coords2 = canvasImager.getCoordinates();
        if (bl3) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_dist_var);
            this.addZone(chartCanvas, treeMap, ZoneType.zt_split_var);
            this.addZone(chartCanvas, treeMap, ZoneType.zt_filter);
            if (canvasImager.hasVertPanels()) {
                this.addZone(chartCanvas, treeMap, ZoneType.zt_panel_vert);
            }
            this.replaceVars(this.mDropZones, treeMap, canvasImager, coords);
            this.mDropZones = treeMap;
            return;
        }
        if (bl4) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_matrix);
            if (canvasImager.hasGrouping()) {
                this.addZone(chartCanvas, treeMap, ZoneType.zt_group);
            }
            if (canvasImager.hasPointId()) {
                this.addZone(chartCanvas, treeMap, ZoneType.zt_point_id);
            }
            this.addZone(chartCanvas, treeMap, ZoneType.zt_filter);
            this.replaceVars(this.mDropZones, treeMap, canvasImager, coords);
            this.mDropZones = treeMap;
            return;
        }
        if (coords2.equals((Object)Coords.coords_1D) || coords2.equals((Object)Coords.coords_2D) || coords2.equals((Object)Coords.coords_DualY) || coords2.equals((Object)Coords.coords_3D)) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_x);
        }
        if (bl) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_high);
            this.addZone(chartCanvas, treeMap, ZoneType.zt_low);
            this.addZone(chartCanvas, treeMap, ZoneType.zt_close);
        } else if (bl2) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_high);
            this.addZone(chartCanvas, treeMap, ZoneType.zt_low);
        } else {
            if (coords2.equals((Object)Coords.coords_2D) || coords2.equals((Object)Coords.coords_DualY) || coords2.equals((Object)Coords.coords_3D)) {
                this.addZone(chartCanvas, treeMap, ZoneType.zt_y);
            }
            if (coords2.equals((Object)Coords.coords_DualY)) {
                this.addZone(chartCanvas, treeMap, ZoneType.zt_y2);
            }
        }
        if (coords2.equals((Object)Coords.coords_3D)) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_z);
        }
        if (coords2.equals((Object)Coords.coords_Polar)) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_slice_by);
            this.addZone(chartCanvas, treeMap, ZoneType.zt_angle);
        }
        if (canvasImager.hasXCluster()) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_cluster_x);
        }
        if (canvasImager.hasZCluster()) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_cluster_z);
        }
        if (canvasImager.hasGrouping()) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_group);
        }
        if (canvasImager.hasHorzPanels()) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_panel_horz);
        }
        if (canvasImager.hasVertPanels()) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_panel_vert);
        }
        if (canvasImager.hasPointId()) {
            this.addZone(chartCanvas, treeMap, ZoneType.zt_point_id);
        }
        this.addZone(chartCanvas, treeMap, ZoneType.zt_filter);
        this.replaceVars(this.mDropZones, treeMap, canvasImager, coords);
        this.mDropZones = treeMap;
    }

    public boolean hasZone(ZoneType zoneType) {
        return this.mDropZones.containsKey((Object)zoneType);
    }

    public void highlightZone(DropZone dropZone, ISpssVariable[] iSpssVariableArray, Point point) {
        this.clearHighlights(dropZone);
        dropZone.setHighlight(true, this.isSpecialHighlight(dropZone, iSpssVariableArray, point));
    }

    public void highlight2Zone(DropZone dropZone) {
        if (dropZone == null) {
            return;
        }
        this.clearHighlights(dropZone);
        dropZone.setHighlight2(true);
        this.setFocusZone(dropZone);
    }

    public void clearHighlights() {
        this.clearHighlights(null);
    }

    public void clearHighlights2() {
        this.clearHighlights2(null);
    }

    public DropZone getFocusZone() {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (!entry.getValue().isFocused()) continue;
            return entry.getValue();
        }
        return null;
    }

    public void setFocusZone(DropZone dropZone) {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (entry.getValue() == dropZone) continue;
            entry.getValue().setFocused(false);
        }
        dropZone.setFocused(true);
    }

    public void updateZonePositions(ChartCanvas chartCanvas) {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            entry.getValue().setBounds(chartCanvas);
        }
    }

    public void render(Graphics2D graphics2D, Locale locale) {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            entry.getValue().render(graphics2D, locale);
        }
    }

    public void serializeIn(DataInputStream dataInputStream) throws IOException {
        this.mDropZones.clear();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            DropZone dropZone = new DropZone(this.mCanvas, ZoneType.zt_x, this.mResources);
            dropZone.serializeIn(dataInputStream);
            this.mDropZones.put(dropZone.getZoneType(), dropZone);
        }
        IndexVariable indexVariable = this.getIndexVariable();
        if (indexVariable != null) {
            DropZone.updateIndexValueLabelMap(this.mCanvas, indexVariable);
        }
    }

    public void serializeOut(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.mDropZones.size());
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            entry.getValue().serializeOut(dataOutputStream);
        }
    }

    public TreeMap<ZoneType, DropZone> getDropZones() {
        return this.mDropZones;
    }

    private void addZone(ChartCanvas chartCanvas, TreeMap<ZoneType, DropZone> treeMap, ZoneType zoneType) {
        DropZone dropZone = new DropZone(chartCanvas, zoneType, this.mResources);
        if (treeMap.size() == 0) {
            dropZone.setFocused(true);
        }
        treeMap.put(dropZone.getZoneType(), dropZone);
        if (dropZone.isStyleByZone()) {
            dropZone.setUsesColorStyling(chartCanvas.getImager().getUsesColorForStyleByType(zoneType));
        }
    }

    private void clearHighlights(DropZone dropZone) {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (entry.getValue() == dropZone) continue;
            entry.getValue().setHighlight(false, false);
        }
    }

    private void clearHighlights2(DropZone dropZone) {
        for (Map.Entry<ZoneType, DropZone> entry : this.mDropZones.entrySet()) {
            if (entry.getValue() == dropZone) continue;
            entry.getValue().setHighlight2(false);
        }
    }

    private void replaceVars(TreeMap<ZoneType, DropZone> treeMap, TreeMap<ZoneType, DropZone> treeMap2, CanvasImager canvasImager, Coords coords) {
        Object object;
        boolean bl;
        Object object2;
        boolean bl2;
        if (coords == Coords.coords_none) {
            return;
        }
        Coords coords2 = canvasImager.getCoordinates();
        boolean bl3 = coords2.equals((Object)Coords.coords_Polar) && !coords.equals((Object)Coords.coords_Polar);
        boolean bl4 = bl2 = !coords2.equals((Object)Coords.coords_Polar) && coords.equals((Object)Coords.coords_Polar);
        if (bl3) {
            object2 = treeMap.get((Object)ZoneType.zt_x);
            if (object2 != null && ((DropZone)object2).isEmpty() && ((object2 = treeMap.get((Object)ZoneType.zt_cluster_x)) == null || ((DropZone)object2).isEmpty())) {
                object2 = treeMap.get((Object)ZoneType.zt_group);
            }
            DropZone dropZone = treeMap2.get((Object)ZoneType.zt_slice_by);
            this.moveVarsAndRemoveZone(treeMap, (DropZone)object2, dropZone);
        }
        object2 = this.mCanvas.getImager().getPrimaryStatistic();
        boolean bl5 = this.isSpecialGather(canvasImager);
        boolean bl6 = bl = this.isLegalEmptyZoneStat((Statistics)((Object)object2)) && !bl5;
        if (bl2) {
            DropZone dropZone = treeMap.get((Object)ZoneType.zt_angle);
            DropZone dropZone2 = treeMap2.get((Object)ZoneType.zt_y);
            if (bl) {
                dropZone.clear();
            }
            this.moveVarsAndRemoveZone(treeMap, dropZone, dropZone2);
            object = treeMap.get((Object)ZoneType.zt_slice_by);
            if (((DropZone)object).isEmpty() && ((object = treeMap.get((Object)ZoneType.zt_cluster_x)) == null || ((DropZone)object).isEmpty())) {
                object = treeMap.get((Object)ZoneType.zt_group);
            }
            DropZone dropZone3 = treeMap2.get((Object)ZoneType.zt_x);
            this.moveVarsAndRemoveZone(treeMap, (DropZone)object, dropZone3);
        }
        boolean bl7 = coords2 == Coords.coords_DualY;
        boolean bl8 = this.mCanvas.getImager().dataElementCount() > 0;
        object = bl7 ? this.mCanvas.getImager().getSecondaryStatistic() : null;
        boolean bl9 = bl7 && object != null && this.isLegalEmptyZoneStat((Statistics)((Object)object));
        for (Map.Entry<ZoneType, DropZone> entry : treeMap.entrySet()) {
            DropZone dropZone;
            Object object3;
            DropZone dropZone4 = entry.getValue();
            if (treeMap2.containsKey((Object)entry.getKey())) {
                if (bl7 ? entry.getKey() == ZoneType.zt_y && !entry.getValue().isEmpty() && bl || entry.getKey() == ZoneType.zt_y2 && !entry.getValue().isEmpty() && bl9 : entry.getValue().isDependentVarZone() && !entry.getValue().isEmpty() && bl && bl8) continue;
                object3 = new ISpssVariable[dropZone4.getVariables().size()];
                if (dropZone4.getZoneType() != ZoneType.zt_filter && (!dropZone4.canDrop(dropZone4.getVariables().toArray((T[])object3)) || dropZone4.scaleOnCluster((ISpssVariable[])object3))) continue;
                dropZone = treeMap2.get((Object)entry.getKey());
                dropZone4.setUsesColorStyling(dropZone.getUsesColorStyling());
                treeMap2.put(entry.getKey(), dropZone4);
                continue;
            }
            if (coords2 != Coords.coords_2D && coords2 != Coords.coords_3D || (entry.getKey() != ZoneType.zt_group || !treeMap2.containsKey((Object)ZoneType.zt_cluster_x)) && (entry.getKey() != ZoneType.zt_cluster_x || !treeMap2.containsKey((Object)ZoneType.zt_group))) continue;
            object3 = entry.getKey() == ZoneType.zt_group ? ZoneType.zt_cluster_x : ZoneType.zt_group;
            dropZone = treeMap2.get(object3);
            ISpssVariable[] iSpssVariableArray = new ISpssVariable[dropZone4.getVariables().size()];
            if (!dropZone.canDrop(dropZone4.getVariables().toArray(iSpssVariableArray)) || dropZone.scaleOnCluster(iSpssVariableArray)) continue;
            dropZone.dropVars(iSpssVariableArray);
        }
    }

    private boolean isSpecialGather(CanvasImager canvasImager) {
        return canvasImager.isHiLoClose() || canvasImager.isOverlayScatter() || canvasImager.isDifferenceArea() || canvasImager.hasSSVs() || canvasImager.isPopulationPyramid() || canvasImager.isSplom() || canvasImager.isSchema();
    }

    private void moveVarsAndRemoveZone(TreeMap<ZoneType, DropZone> treeMap, DropZone dropZone, DropZone dropZone2) {
        if (dropZone != null && dropZone2 != null) {
            Vector<ISpssVariable> vector = dropZone.getVariables();
            ISpssVariable[] iSpssVariableArray = new ISpssVariable[vector.size()];
            vector.toArray(iSpssVariableArray);
            if (dropZone2.canDrop(iSpssVariableArray)) {
                dropZone2.dropVars(iSpssVariableArray);
            }
            treeMap.remove((Object)dropZone.getZoneType());
        }
    }

    private boolean isSpecialHighlight(DropZone dropZone, ISpssVariable[] iSpssVariableArray, Point point) {
        int n;
        int n2;
        ZoneType zoneType = dropZone.getZoneType();
        if (zoneType != ZoneType.zt_filter) {
            if (zoneType != ZoneType.zt_x && zoneType != ZoneType.zt_y && zoneType != ZoneType.zt_angle && zoneType != ZoneType.zt_matrix) {
                return false;
            }
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (iSpssVariable.getDisplayMeasurementLevel() == MeasurementLevel.scale) continue;
                return false;
            }
            if (this.hasCatVar(zoneType)) {
                return false;
            }
            if (this.mCanvas.getImager().isSchema() || this.mCanvas.getImager().getCoordinates() == Coords.coords_DualY) {
                return false;
            }
            n2 = this.mCanvas.getImager().isOverlayScatter() ? 1 : 0;
            if (n2 == 0 && zoneType == ZoneType.zt_x) {
                return false;
            }
        }
        n2 = dropZone.getVariables().size();
        int n3 = iSpssVariableArray.length;
        int n4 = n = n3 > 1 && n2 == 0 ? 1 : 0;
        if (n != 0 || n2 > 0 && zoneType == ZoneType.zt_matrix) {
            return true;
        }
        if (n2 > 0) {
            return dropZone.pointInMultiVarArea(point);
        }
        return false;
    }

    private boolean requiredZone(ZoneType zoneType) {
        if (zoneType == ZoneType.zt_group && this.mCanvas.getImager().isOverlayScatter()) {
            return false;
        }
        if (zoneType == ZoneType.zt_x && this.mCanvas.getImager().isSchema() && this.mCanvas.getImager().getCoordinates() == Coords.coords_2D && !this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_cluster_x)) {
            return false;
        }
        return zoneType != ZoneType.zt_angle && zoneType != ZoneType.zt_close && zoneType != ZoneType.zt_panel_horz && zoneType != ZoneType.zt_panel_vert && zoneType != ZoneType.zt_point_id && zoneType != ZoneType.zt_y && zoneType != ZoneType.zt_y2;
    }

    private boolean isLegalEmptyZoneStat(Statistics statistics) {
        return statistics == Statistics.Count || statistics == Statistics.CumCount || statistics == Statistics.CumPct || statistics == Statistics.PctOfCases || statistics == Statistics.Responses || statistics == Statistics.CumResponses || statistics == Statistics.ResponsePct || statistics == Statistics.CumResponsePct || statistics == Statistics.Histogram || statistics == Statistics.HistogramPct;
    }
}

