/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.vis.specification.Attribute;
import com.spss.vis.specification.ExtensionSpecification;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.aesthetic.ColorAestheticSpecification;
import com.spss.vis.specification.data.SourceVariableSpecification;
import com.spss.vis.specification.element.ElementSpecification;
import com.spss.vis.specification.facet.CrossSpecification;
import com.spss.vis.specification.facet.FacetingSpecification;
import com.spss.vis.specification.facet.VariableReferenceSpecification;
import com.spss.vis.specification.format.RelabelSpecification;
import java.util.Vector;

public class VarInfo {
    private SourceVariableSpecification mVarSpec;
    private boolean mCategorical;
    private boolean mEmptyVariable;
    private Vector<CatInfo> mCategories = new Vector();

    public VarInfo(SourceVariableSpecification sourceVariableSpecification, int n) {
        this.mVarSpec = sourceVariableSpecification;
        this.mCategorical = this.mVarSpec.getCategorical();
        Attribute attribute = this.mVarSpec.getAttribute("shortLabel");
        boolean bl = this.mEmptyVariable = attribute == null || attribute.toString().length() == 0;
        if (this.mCategorical) {
            this.acquireCategories(n);
        }
    }

    public int categoryCount() {
        return this.mCategories.size();
    }

    public SourceVariableSpecification getVarSpec() {
        return this.mVarSpec;
    }

    public boolean isCategorical() {
        return this.mCategorical;
    }

    public Vector<CatInfo> getCategories() {
        return this.mCategories;
    }

    public boolean isEmptyVariable() {
        return this.mEmptyVariable;
    }

    public boolean isRangeLow() {
        ExtensionSpecification[] extensionSpecificationArray;
        for (ExtensionSpecification extensionSpecification : extensionSpecificationArray = this.mVarSpec.getExtensionSpecifications()) {
            String string = extensionSpecification.get("low_range_key");
            if (string == null || !string.equals("low")) continue;
            return true;
        }
        return false;
    }

    public boolean isRangeHigh() {
        ExtensionSpecification[] extensionSpecificationArray;
        for (ExtensionSpecification extensionSpecification : extensionSpecificationArray = this.mVarSpec.getExtensionSpecifications()) {
            String string = extensionSpecification.get("high_range_key");
            if (string == null || !string.equals("high")) continue;
            return true;
        }
        return false;
    }

    public boolean isXVar() {
        Specification[] specificationArray;
        for (Specification specification : specificationArray = this.mVarSpec.getTop().getReferencesTo(this.mVarSpec.getId())) {
            if (!(specification instanceof ElementSpecification) || !this.mVarSpec.equals(((ElementSpecification)specification).getX())) continue;
            return true;
        }
        return false;
    }

    public boolean isYVar() {
        Specification[] specificationArray;
        for (Specification specification : specificationArray = this.mVarSpec.getTop().getReferencesTo(this.mVarSpec.getId())) {
            if (!(specification instanceof ElementSpecification) || !this.mVarSpec.equals(((ElementSpecification)specification).getY())) continue;
            return true;
        }
        return false;
    }

    public boolean isPanelVar() {
        Specification[] specificationArray;
        for (Specification specification : specificationArray = this.mVarSpec.getTop().getReferencesTo(this.mVarSpec.getId())) {
            if (!(specification instanceof VariableReferenceSpecification) || !(specification.getParent() instanceof CrossSpecification) || !(specification.getParent().getParent() instanceof FacetingSpecification)) continue;
            return true;
        }
        return false;
    }

    public boolean isColorSplitVar() {
        Specification[] specificationArray;
        for (Specification specification : specificationArray = this.mVarSpec.getTop().getReferencesTo(this.mVarSpec.getId())) {
            if (!(specification instanceof ColorAestheticSpecification)) continue;
            return true;
        }
        return false;
    }

    private void acquireCategories(int n) {
        Specification[] specificationArray = this.mVarSpec.findDescendantsOfType(RelabelSpecification.class);
        if (specificationArray != null && specificationArray.length > 0) {
            RelabelSpecification[] relabelSpecificationArray;
            int n2 = 0;
            for (RelabelSpecification relabelSpecification : relabelSpecificationArray = (RelabelSpecification[])specificationArray) {
                CatInfo catInfo = new CatInfo();
                catInfo.mOrgValue = relabelSpecification.getFrom();
                catInfo.mValue = relabelSpecification.getTo();
                this.mCategories.add(catInfo);
                if (++n2 == n) break;
            }
        }
    }

    class CatInfo {
        String mValue;
        String mOrgValue;

        CatInfo() {
        }
    }
}

