/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class TristateCheckBox
extends JCheckBox {
    public static final State NOT_SELECTED = new State("NOT_SELECTED");
    public static final State CHECKED = new State("CHECKED");
    public static final State MIXED = new State("MIXED");
    private final TristateModel model;

    public TristateCheckBox(String string, State state) {
        super(string);
        TristateCheckBoxIcon tristateCheckBoxIcon = new TristateCheckBoxIcon();
        super.setIcon(tristateCheckBoxIcon);
        super.setSelectedIcon(tristateCheckBoxIcon);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TristateCheckBox.this.mousePressed();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                TristateCheckBox.this.mouseReleased();
            }
        });
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TristateCheckBox.this.mousePressed();
            }
        });
        actionMapUIResource.put("released", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TristateCheckBox.this.mouseReleased();
            }
        });
        SwingUtilities.replaceUIActionMap(this, actionMapUIResource);
        this.model = new TristateModel(this.getModel());
        this.setModel(this.model);
        this.setState(state);
    }

    private void mousePressed() {
        this.grabFocus();
        this.model.setPressed(true);
        this.model.setArmed(true);
    }

    private void mouseReleased() {
        this.model.nextState();
        this.model.setArmed(false);
        this.model.setPressed(false);
    }

    @Override
    public void doClick() {
        this.mousePressed();
        this.mouseReleased();
    }

    public TristateCheckBox(String string) {
        this(string, NOT_SELECTED);
    }

    public TristateCheckBox() {
        this((String)null);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
    }

    @Override
    public void setIcon(Icon icon) {
    }

    public void setState(State state) {
        this.model.setState(state);
    }

    public State getState() {
        return this.model.getState();
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl) {
            this.setState(CHECKED);
        } else {
            this.setState(NOT_SELECTED);
        }
    }

    private class TristateCheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private TristateCheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl;
            JCheckBox jCheckBox = (JCheckBox)component;
            TristateModel tristateModel = (TristateModel)jCheckBox.getModel();
            int n3 = this.getControlSize();
            boolean bl2 = tristateModel.getState() == CHECKED;
            boolean bl3 = bl = tristateModel.getState() == MIXED;
            if (tristateModel.isEnabled()) {
                if (tristateModel.isPressed() && tristateModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(n, n2, n3 - 1, n3 - 1);
                    this.drawPressed3DBorder(graphics, n, n2, n3, n3);
                } else {
                    this.drawFlush3DBorder(graphics, n, n2, n3, n3);
                }
                graphics.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n, n2, n3 - 1, n3 - 1);
            }
            if (bl) {
                this.drawSquare(component, graphics, n, n2);
            }
            if (bl2) {
                if (jCheckBox.isBorderPaintedFlat()) {
                    ++n;
                }
                this.drawCheck(component, graphics, n, n2);
            }
        }

        private void drawSquare(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getControlSize();
            graphics.fillRect(n + 3, n2 + 3, n3 - 6, n3 - 6);
        }

        private void drawCheck(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getControlSize();
            graphics.fillRect(n + 3, n2 + 5, 2, n3 - 8);
            graphics.drawLine(n + (n3 - 4), n2 + 3, n + 5, n2 + (n3 - 6));
            graphics.drawLine(n + (n3 - 4), n2 + 4, n + 5, n2 + (n3 - 5));
        }

        private void drawFlush3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawRect(1, 1, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(0, n4 - 1, 1, n4 - 2);
            graphics.drawLine(n3 - 1, 0, n3 - 2, 1);
            graphics.translate(-n, -n2);
        }

        private void drawPressed3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            this.drawFlush3DBorder(graphics, 0, 0, n3, n4);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(1, 1, 1, n4 - 2);
            graphics.drawLine(1, 1, n3 - 2, 1);
            graphics.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private class TristateModel
    implements ButtonModel {
        private final ButtonModel other;
        private State currentState = NOT_SELECTED;

        private TristateModel(ButtonModel buttonModel) {
            this.other = buttonModel;
        }

        private State getState() {
            return this.currentState;
        }

        private void setState(State state) {
            this.currentState = state;
        }

        @Override
        public boolean isSelected() {
            return this.currentState == CHECKED || this.currentState == MIXED;
        }

        private void nextState() {
            State state = this.getState();
            if (state == NOT_SELECTED) {
                this.setState(CHECKED);
            } else if (state == CHECKED) {
                this.setState(NOT_SELECTED);
            } else if (state == MIXED) {
                this.setState(NOT_SELECTED);
            }
            this.other.setSelected(!this.other.isSelected());
        }

        @Override
        public void setArmed(boolean bl) {
            this.other.setArmed(bl);
        }

        @Override
        public void setEnabled(boolean bl) {
            try {
                TristateCheckBox.this.setFocusable(bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.other.setEnabled(bl);
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setSelected(boolean bl) {
            this.other.setSelected(bl);
        }

        @Override
        public void setPressed(boolean bl) {
            this.other.setPressed(bl);
        }

        @Override
        public void setRollover(boolean bl) {
            this.other.setRollover(bl);
        }

        @Override
        public void setMnemonic(int n) {
            this.other.setMnemonic(n);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String string) {
            this.other.setActionCommand(string);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup buttonGroup) {
            this.other.setGroup(buttonGroup);
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.other.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.other.removeActionListener(actionListener);
        }

        @Override
        public void addItemListener(ItemListener itemListener) {
            this.other.addItemListener(itemListener);
        }

        @Override
        public void removeItemListener(ItemListener itemListener) {
            this.other.removeItemListener(itemListener);
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.other.addChangeListener(changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.other.removeChangeListener(changeListener);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    public static class State {
        private String desc = "";

        private State(String string) {
            this.desc = string;
        }

        public String toString() {
            return this.desc;
        }
    }
}

