/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ICanvasChangeListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ITitles;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.doc_util.ThinBeveledBorder;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class TitlesFrontPanel
extends JPanel
implements ICanvasChangeListener {
    private BaseDialog mParent;
    private ChartCanvas mCanvas;
    private JCheckBox mTitle1Check;
    private JCheckBox mTitle2Check;
    private JCheckBox mSubtitleCheck;
    private JCheckBox mFootnote1Check;
    private JCheckBox mFootnote2Check;

    public TitlesFrontPanel(BaseDialog baseDialog, ChartCanvas chartCanvas) {
        super(new GridBagLayout(), true);
        this.mParent = baseDialog;
        this.mCanvas = chartCanvas;
        this.init();
        this.mCanvas.addChangeListener(this);
    }

    @Override
    public void canvasChange(CanvasChangeEvent canvasChangeEvent) {
        this.updateCheckboxes();
    }

    private void updateCheckboxes() {
        if (this.mCanvas.isEmpty()) {
            this.mTitle1Check.setSelected(false);
            this.mTitle2Check.setSelected(false);
            this.mSubtitleCheck.setSelected(false);
            this.mFootnote1Check.setSelected(false);
            this.mFootnote2Check.setSelected(false);
            this.mTitle1Check.setEnabled(false);
            this.mTitle2Check.setEnabled(false);
            this.mSubtitleCheck.setEnabled(false);
            this.mFootnote1Check.setEnabled(false);
            this.mFootnote2Check.setEnabled(false);
        } else {
            this.mTitle1Check.setEnabled(true);
            this.mTitle2Check.setEnabled(true);
            this.mSubtitleCheck.setEnabled(true);
            this.mFootnote1Check.setEnabled(true);
            this.mFootnote2Check.setEnabled(true);
            this.mTitle1Check.setSelected(this.mCanvas.getImager().hasTitle(ITitles.TitleType.title1));
            this.mTitle2Check.setSelected(this.mCanvas.getImager().hasTitle(ITitles.TitleType.title2));
            this.mSubtitleCheck.setSelected(this.mCanvas.getImager().hasTitle(ITitles.TitleType.subTitle1));
            this.mFootnote1Check.setSelected(this.mCanvas.getImager().hasTitle(ITitles.TitleType.footnote1));
            this.mFootnote2Check.setSelected(this.mCanvas.getImager().hasTitle(ITitles.TitleType.footnote2));
        }
    }

    private void init() {
        JTextArea jTextArea = new JTextArea(this.mParent.getResString("IDS_TITLES_TAB_INFO"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.left = DialogUtil.getStandardDialogInsets().left;
        insets.top = 3;
        insets.bottom = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(this, jTextArea, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinBeveledBorder thinBeveledBorder = new ThinBeveledBorder(uIDefaults.getColor("ToolBar.highlight"), uIDefaults.getColor("ToolBar.shadow"), 1);
        jPanel.setBorder(thinBeveledBorder);
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.top += n + 2;
        insets.left += n;
        this.mTitle1Check = new JCheckBox(new TitleAction(ITitles.TitleType.title1));
        this.mTitle1Check.setSelected(true);
        DialogUtil.addUsingGBL(jPanel, this.mTitle1Check, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.top -= n;
        this.mTitle2Check = new JCheckBox(new TitleAction(ITitles.TitleType.title2));
        DialogUtil.addUsingGBL(jPanel, this.mTitle2Check, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.mSubtitleCheck = new JCheckBox(new TitleAction(ITitles.TitleType.subTitle1));
        DialogUtil.addUsingGBL(jPanel, this.mSubtitleCheck, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        this.mFootnote1Check = new JCheckBox(new TitleAction(ITitles.TitleType.footnote1));
        DialogUtil.addUsingGBL(jPanel, this.mFootnote1Check, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        insets.bottom += n;
        this.mFootnote2Check = new JCheckBox(new TitleAction(ITitles.TitleType.footnote2));
        DialogUtil.addUsingGBL(jPanel, this.mFootnote2Check, gridBagConstraints, 0, 4, 1, 1, n2, insets);
        gridBagConstraints.fill = 1;
        insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        insets.top = 5;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
    }

    class TitleAction
    extends AbstractAction {
        ITitles.TitleType mType;

        TitleAction(ITitles.TitleType titleType) {
            Integer n;
            String string;
            this.mType = titleType;
            if (this.mType.equals((Object)ITitles.TitleType.title1)) {
                string = TitlesFrontPanel.this.mParent.getResString("IDS_TITLE1");
                n = TitlesFrontPanel.this.mParent.getDlgAccessKey("IDK_TITLE1_KEY");
            } else if (this.mType.equals((Object)ITitles.TitleType.title2)) {
                string = TitlesFrontPanel.this.mParent.getResString("IDS_TITLE2");
                n = TitlesFrontPanel.this.mParent.getDlgAccessKey("IDK_TITLE2_KEY");
            } else if (this.mType.equals((Object)ITitles.TitleType.subTitle1)) {
                string = TitlesFrontPanel.this.mParent.getResString("IDS_SUBTITLE1");
                n = TitlesFrontPanel.this.mParent.getDlgAccessKey("IDK_SUBTITLE1_KEY");
            } else if (this.mType.equals((Object)ITitles.TitleType.footnote1)) {
                string = TitlesFrontPanel.this.mParent.getResString("IDS_FOOTNOTE1");
                n = TitlesFrontPanel.this.mParent.getDlgAccessKey("IDK_FOOTNOTE1_KEY");
            } else if (this.mType.equals((Object)ITitles.TitleType.footnote2)) {
                string = TitlesFrontPanel.this.mParent.getResString("IDS_FOOTNOTE2");
                n = TitlesFrontPanel.this.mParent.getDlgAccessKey("IDK_FOOTNOTE2_KEY");
            } else {
                assert (false);
                return;
            }
            this.putValue("Name", string);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    TitlesFrontPanel.this.mCanvas.getTitleMgr().addTitle(this.mType, false);
                } else {
                    TitlesFrontPanel.this.mCanvas.getTitleMgr().removeTitle(this.mType);
                }
            }
        }
    }
}

