/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ITitles;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.ModifyTitleEdit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.util.Arrays;
import java.util.HashMap;

public class TitleMgr {
    private static final int TITLE_COUNT = 5;
    private ChartCanvas mCanvas;
    private boolean[] mTitleFlags = new boolean[5];
    private String[] mTitleStrings = new String[5];
    private Rectangle[] mTitleFrameRects = new Rectangle[5];
    private Font mTitleFont = null;
    private boolean mHighlight;
    private Rectangle mRectToHighlight;
    private boolean mAllowScrollToVisible;

    public TitleMgr(ChartCanvas chartCanvas) {
        this.mCanvas = chartCanvas;
        Arrays.fill(this.mTitleFlags, false);
        this.mTitleStrings[0] = this.mCanvas.getResources().getResString("IDS_T1");
        this.mTitleStrings[1] = this.mCanvas.getResources().getResString("IDS_T2");
        this.mTitleStrings[2] = this.mCanvas.getResources().getResString("IDS_S");
        this.mTitleStrings[3] = this.mCanvas.getResources().getResString("IDS_F1");
        this.mTitleStrings[4] = this.mCanvas.getResources().getResString("IDS_F2");
    }

    public void addTitle(ITitles.TitleType titleType, boolean bl) {
        new ModifyTitleEdit(this.mCanvas.getUndoManager(), this.mCanvas.getParentDlg(), titleType, true, this.getInstance(titleType), bl);
    }

    public String getTitleText(ITitles.TitleType titleType) {
        return this.mTitleStrings[titleType.ordinal()];
    }

    public void removeTitle(ITitles.TitleType titleType) {
        new ModifyTitleEdit(this.mCanvas.getUndoManager(), this.mCanvas.getParentDlg(), titleType, false, -1, false);
    }

    public boolean hasTitle(ITitles.TitleType titleType) {
        return this.mTitleFlags[titleType.ordinal()];
    }

    public void clear() {
        Arrays.fill(this.mTitleFlags, false);
        this.mTitleStrings[0] = this.mCanvas.getResources().getResString("IDS_T1");
        this.mTitleStrings[1] = this.mCanvas.getResources().getResString("IDS_T2");
        this.mTitleStrings[2] = this.mCanvas.getResources().getResString("IDS_S");
        this.mTitleStrings[3] = this.mCanvas.getResources().getResString("IDS_F1");
        this.mTitleStrings[4] = this.mCanvas.getResources().getResString("IDS_F2");
    }

    public int getFootnotesHeight() {
        boolean bl = this.hasTitle(ITitles.TitleType.footnote1);
        boolean bl2 = this.hasTitle(ITitles.TitleType.footnote2);
        if (!bl && !bl2) {
            return 0;
        }
        if (this.mTitleFont == null) {
            this.createTitleFont();
        }
        Graphics graphics = this.mCanvas.getGraphics();
        Font font = graphics.getFont();
        graphics.setFont(this.mTitleFont);
        int n = graphics.getFontMetrics().getHeight() - 2;
        graphics.setFont(font);
        graphics.dispose();
        int n2 = 0;
        if (bl) {
            n2 += n;
        }
        if (bl2) {
            n2 += n;
        }
        return n2;
    }

    public int checkForTitleHits(Point point) {
        int n = this.getTitleIndexToHighlight(point);
        if (n > -1) {
            this.mRectToHighlight = this.mTitleFrameRects[n];
            this.mHighlight = true;
        }
        return n;
    }

    public void renderTitles(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        if (!this.hasTitles()) {
            return;
        }
        if (this.mTitleFont == null) {
            this.createTitleFont();
        }
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.mTitleFont);
        int n4 = graphics2D.getFontMetrics().getHeight() - 2;
        int n5 = 0;
        Rectangle rectangle = this.mCanvas.getBounds();
        int n6 = n3 = (int)rectangle.getMaxX() / 2 - rectangle.width / 12;
        if (this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_split_var)) {
            int n7 = n3 = n3 < 200 ? 200 : n3;
        }
        if (this.hasTitle(ITitles.TitleType.title1)) {
            n2 = graphics2D.getFontMetrics().stringWidth(this.mTitleStrings[0]) + 4;
            this.mTitleFrameRects[0] = new Rectangle(n3 - n2 / 2, n5 + 2, n2, n4);
            graphics2D.drawString(this.mTitleStrings[0], n3 - n2 / 2 + 3, n5 += n4);
        }
        if (this.hasTitle(ITitles.TitleType.title2)) {
            n2 = graphics2D.getFontMetrics().stringWidth(this.mTitleStrings[1]) + 4;
            this.mTitleFrameRects[1] = new Rectangle(n3 - n2 / 2, n5 + 2, n2, n4);
            graphics2D.drawString(this.mTitleStrings[1], n3 - n2 / 2 + 3, n5 += n4);
        }
        if (this.hasTitle(ITitles.TitleType.subTitle1)) {
            n2 = graphics2D.getFontMetrics().stringWidth(this.mTitleStrings[2]) + 4;
            this.mTitleFrameRects[2] = new Rectangle(n3 - n2 / 2, n5 + 2, n2, n4);
            graphics2D.drawString(this.mTitleStrings[2], n3 - n2 / 2 + 3, n5 += n4);
        }
        n3 = n6;
        n5 = rectangle.height + 4;
        if (this.hasTitle(ITitles.TitleType.footnote2)) {
            n2 = graphics2D.getFontMetrics().stringWidth(this.mTitleStrings[4]) + 4;
            graphics2D.drawString(this.mTitleStrings[4], n3 - n2 / 2 + 3, n5 -= n4);
            n = n5 - n4 + 2;
            this.mTitleFrameRects[4] = new Rectangle(n3 - n2 / 2, n, n2, n4);
        }
        if (this.hasTitle(ITitles.TitleType.footnote1)) {
            n2 = graphics2D.getFontMetrics().stringWidth(this.mTitleStrings[3]) + 4;
            graphics2D.drawString(this.mTitleStrings[3], n3 - n2 / 2 + 3, n5 -= n4);
            n = n5 - n4 + 3;
            this.mTitleFrameRects[3] = new Rectangle(n3 - n2 / 2, n, n2, n4);
        }
        graphics2D.setFont(font);
        if (this.mHighlight) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(DropZone.sHighlight2Color);
            graphics2D.setStroke(DropZone.sHiliteStroke);
            graphics2D.drawRect(this.mRectToHighlight.x, this.mRectToHighlight.y, this.mRectToHighlight.width, this.mRectToHighlight.height);
            graphics2D.setColor(color);
            if (this.mAllowScrollToVisible) {
                this.mCanvas.scrollRectToVisible(this.mRectToHighlight);
            }
        }
    }

    public void setTitle(ITitles.TitleType titleType, boolean bl) {
        this.mTitleFlags[titleType.ordinal()] = bl;
    }

    public void setTitleText(ITitles.TitleType titleType, String string) {
        if (string == null) {
            this.resetTitleText(titleType);
        } else if (this.mTitleFlags[titleType.ordinal()] && string.length() > 0) {
            this.mTitleStrings[titleType.ordinal()] = string;
        }
    }

    public boolean isHighlight() {
        return this.mHighlight;
    }

    public void clearHighlight() {
        this.mHighlight = false;
    }

    public void highlightTitle(IPropEnum.TitleFlag titleFlag) {
        this.mHighlight = true;
        ITitles.TitleType titleType = this.mCanvas.titleFlagToTitleType(titleFlag);
        this.mRectToHighlight = this.mTitleFrameRects[titleType.ordinal()];
        this.mAllowScrollToVisible = true;
    }

    public void setAllowScrollToVisible(boolean bl) {
        this.mAllowScrollToVisible = bl;
    }

    private int getTitleIndexToHighlight(Point point) {
        int n = -1;
        for (int i = 0; i < 5; ++i) {
            if (this.mTitleFrameRects[i] == null || !this.mTitleFrameRects[i].contains(point)) continue;
            n = i;
            break;
        }
        return n;
    }

    private boolean hasTitles() {
        for (boolean bl : this.mTitleFlags) {
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private void createTitleFont() {
        Font font = this.mCanvas.getFont();
        HashMap hashMap = new HashMap(font.getAttributes());
        hashMap.put(TextAttribute.SIZE, Float.valueOf(font.getSize() - 3));
        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
        this.mTitleFont = font.deriveFont(hashMap);
    }

    private int getInstance(ITitles.TitleType titleType) {
        ITitles.TitleType[] titleTypeArray = new ITitles.TitleType[]{ITitles.TitleType.title1, ITitles.TitleType.title2, ITitles.TitleType.subTitle1, ITitles.TitleType.footnote1, ITitles.TitleType.footnote2};
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            if (titleType == titleTypeArray[i]) {
                return n;
            }
            if (!this.mTitleFlags[i]) continue;
            ++n;
        }
        return -1;
    }

    private void resetTitleText(ITitles.TitleType titleType) {
        int n = titleType.ordinal();
        String string = "";
        if (n == 0) {
            string = "T1";
        } else if (n == 1) {
            string = "T2";
        } else if (n == 2) {
            string = "S";
        } else if (n == 3) {
            string = "F1";
        } else if (n == 4) {
            string = "F2";
        }
        this.mTitleStrings[n] = this.mCanvas.getResources().getResString("IDS_" + string);
    }
}

