/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartAppearanceOption;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderOptions;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.SyntaxVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneMgr;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.InterpolationGroup;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.RelabelBag;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.YXPairs;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.utils.GplUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.prefs.Preferences;

public class SyntaxGenerator
implements IPropEnum {
    private ChartCanvas mCanvas;
    private ChartBuilderOptions mOptions;
    private ChartProps mProperties = null;
    private Vector<SyntaxVariable> mVariables = null;
    private HashMap<String, TransBag> mTransBags = new HashMap();

    public SyntaxGenerator(ChartCanvas chartCanvas, ChartBuilderOptions chartBuilderOptions) {
        this.mCanvas = chartCanvas;
        this.mOptions = chartBuilderOptions;
    }

    public static boolean isNameInDataset(String string) {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId());
        return iSpssDataSrc.findVarIndex(string) > -1;
    }

    public boolean isNameInDataset(String string, String string2) {
        return !string.equals(string2) && SyntaxGenerator.isNameInDataset(string);
    }

    public String generateSyntax() {
        this.mTransBags.clear();
        this.mProperties = this.mCanvas.getProperties();
        this.acquireVariables();
        StringBuffer stringBuffer = new StringBuffer();
        String string = "* " + this.mCanvas.getResources().getResString("IDS_CHART_BUILDER_WINDOW_TITLE") + ".\n";
        stringBuffer.append(string);
        this.addGGraphSyntax(stringBuffer);
        this.addGPLSyntax(stringBuffer);
        return stringBuffer.toString();
    }

    private void addGGraphSyntax(StringBuffer stringBuffer) {
        Props.MatrixProps matrixProps;
        stringBuffer.append("GGRAPH\n");
        stringBuffer.append("  /GRAPHDATASET NAME=\"graphdataset\" VARIABLES=");
        stringBuffer.append(this.getVariableList());
        stringBuffer.append(" MISSING=");
        if (this.mOptions.getExcludeListwise()) {
            stringBuffer.append("LISTWISE");
        } else {
            stringBuffer.append("VARIABLEWISE");
        }
        stringBuffer.append(" REPORTMISSING=");
        if (this.mOptions.getIncludeBreakVars()) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        Vector<ISpssVariable> vector = this.mCanvas.getFilterVars();
        if (vector != null && vector.size() > 0) {
            stringBuffer.append(this.getFilterSyntaxPortion(vector));
        }
        if (this.mProperties.getHasSSVs()) {
            stringBuffer.append("\n    TRANSFORM=VARSTOCASES(SUMMARY=\"#SUMMARY\" INDEX=\"#INDEX\"");
            if (this.isErrorBarDepZone(this.getSyntaxVar(ZoneType.zt_y))) {
                stringBuffer.append(" LOW=\"#LOW\" HIGH=\"#HIGH\"");
            }
            stringBuffer.append(")");
        }
        if (this.mCanvas.getImager().isDifferenceArea()) {
            stringBuffer.append("\n    TRANSFORM=VARSTOCASES(SUMMARY=\"values\" INDEX=\"category\")");
        }
        stringBuffer.append("\n  /GRAPHSPEC SOURCE=INLINE");
        ChartAppearanceOption chartAppearanceOption = this.mCanvas.getImager().getChartAppearanceOption();
        String string = chartAppearanceOption.getTemplatePath();
        if (string != null && string.length() > 0) {
            stringBuffer.append("\n   TEMPLATE=[");
            stringBuffer.append("\"").append(string).append("\"");
            stringBuffer.append("]");
        }
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        boolean bl = elProps instanceof Props.PointProps;
        boolean bl2 = elProps instanceof Props.MatrixProps;
        Props.PointProps pointProps = bl ? (Props.PointProps)elProps : null;
        Props.MatrixProps matrixProps2 = matrixProps = bl2 ? (Props.MatrixProps)elProps : null;
        if (bl && pointProps.canHaveRegressionLine()) {
            stringBuffer.append(this.getRegressionLineSyntax(pointProps.hasTotalRegressionLine(), pointProps.hasSubgroupRegressionLine()));
        }
        if (bl2 && matrixProps.canHaveRegressionLine()) {
            stringBuffer.append(this.getRegressionLineSyntax(matrixProps.hasTotalRegressionLine(), matrixProps.hasSubgroupRegressionLine()));
        }
        if (chartAppearanceOption.isUseCustomSetting()) {
            stringBuffer.append(this.getColorCycleSyntax(chartAppearanceOption));
            stringBuffer.append(this.getFrameSyntax(chartAppearanceOption));
            stringBuffer.append(this.getGridlineSyntax(chartAppearanceOption));
        }
        stringBuffer.append(".\n");
    }

    private String getFilterSyntaxPortion(Vector<ISpssVariable> vector) {
        StringBuffer stringBuffer = new StringBuffer();
        if (vector != null && vector.size() > 0) {
            ArrayList<Props.PanelProps> arrayList = this.getFilterPanelProps(ZoneType.zt_filter);
            stringBuffer.append(" DATAFILTER=");
            for (Props.PanelProps panelProps : arrayList) {
                Vector<RelabelBag> vector2 = panelProps.getCategories();
                int n = 0;
                for (RelabelBag relabelBag : vector2) {
                    if (!relabelBag.getExcluded()) continue;
                    ++n;
                }
                stringBuffer.append(vector.get(panelProps.getPanelIndex() - 1).getName()).append("(");
                stringBuffer.append("VALUES=");
                if (n == 0) {
                    stringBuffer.append("ALL ");
                } else {
                    for (RelabelBag relabelBag : vector2) {
                        if (relabelBag.getExcluded()) continue;
                        stringBuffer.append(relabelBag.getStrOrgValue());
                        stringBuffer.append(" ");
                    }
                }
                stringBuffer.append("UNLABELED=");
                stringBuffer.append(panelProps.getIncludeUnlabeled() ? "INCLUDE" : "EXCLUDE");
                stringBuffer.append(") ");
            }
        }
        return stringBuffer.toString();
    }

    private String getVariableList() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.mProperties.getHasSSVs();
        ZoneType zoneType = bl ? this.mCanvas.getZoneMgr().getIndexVarZoneType() : null;
        boolean bl2 = false;
        Vector<String> vector = new Vector<String>();
        for (SyntaxVariable syntaxVariable : this.mVariables) {
            boolean bl3;
            boolean bl4 = bl3 = bl && (syntaxVariable.getZoneType() == ZoneType.zt_y || syntaxVariable.getZoneType() == ZoneType.zt_angle);
            if (bl3) {
                if (bl2) {
                    stringBuffer.append(" ");
                }
                this.retrieveSSVDepVars(stringBuffer, vector);
            } else {
                if (syntaxVariable.getZoneType() == zoneType || this.isNameInStringList(vector, syntaxVariable.getOrgName())) continue;
                vector.add(syntaxVariable.getOrgName());
                if (bl2) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(syntaxVariable.getOrgName());
                boolean bl5 = this.isErrorBarDepZone(syntaxVariable);
                if (bl5) {
                    stringBuffer.append("[name=\"").append(syntaxVariable.getGGraphName()).append("\" ");
                    stringBuffer.append("LOW=\"").append(syntaxVariable.getGGraphName()).append("_LOW\" ");
                    stringBuffer.append("HIGH=\"").append(syntaxVariable.getGGraphName()).append("_HIGH\"]");
                } else {
                    boolean bl6;
                    boolean bl7 = bl6 = !syntaxVariable.getOrgName().equals(syntaxVariable.getGGraphName());
                    if (bl6) {
                        stringBuffer.append("[name=\"").append(syntaxVariable.getGGraphName()).append("\"");
                    }
                    boolean bl8 = false;
                    ISpssVariable iSpssVariable = syntaxVariable.getVariable();
                    if (iSpssVariable != null && iSpssVariable.getMeasurementLevel() != iSpssVariable.getDisplayMeasurementLevel()) {
                        String string = "SCALE";
                        if (iSpssVariable.getDisplayMeasurementLevel() == MeasurementLevel.nominal) {
                            string = "NOMINAL";
                        } else if (iSpssVariable.getDisplayMeasurementLevel() == MeasurementLevel.ordinal) {
                            string = "ORDINAL";
                        }
                        if (bl6) {
                            stringBuffer.append(" ");
                        } else {
                            stringBuffer.append("[");
                        }
                        stringBuffer.append("LEVEL=").append(string);
                        bl8 = true;
                    }
                    if (bl6 || bl8) {
                        stringBuffer.append("]");
                    }
                }
            }
            bl2 = true;
        }
        return stringBuffer.toString();
    }

    private boolean isNameInStringList(Vector<String> vector, String string) {
        for (String string2 : vector) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private void retrieveSSVDepVars(StringBuffer stringBuffer, Vector<String> vector) {
        boolean bl = false;
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        Props.SSVData sSVData = elProps.getSSVData();
        ZoneType zoneType = this.mProperties.getCoords() == Coords.coords_Polar ? ZoneType.zt_angle : ZoneType.zt_y;
        for (ElementStat elementStat : sSVData.getSSVVariables()) {
            SyntaxVariable syntaxVariable = new SyntaxVariable("");
            syntaxVariable.setZoneType(zoneType);
            this.makeDepVarSyntaxName(syntaxVariable, elementStat, zoneType, elementStat.getVariable());
            vector.add(syntaxVariable.getOrgName());
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(syntaxVariable.getOrgName());
            bl = true;
        }
    }

    private boolean isErrorBarDepZone(SyntaxVariable syntaxVariable) {
        if (syntaxVariable == null) {
            return false;
        }
        ZoneType zoneType = syntaxVariable.getZoneType();
        if (zoneType == ZoneType.zt_y || zoneType == ZoneType.zt_y2) {
            String string;
            int n;
            int n2 = zoneType == ZoneType.zt_y2 ? 1 : 0;
            Props.ElProps elProps = this.mProperties.getElementProp(n2);
            if (this.mProperties.getCoords() == Coords.coords_DualY && (n = Integer.valueOf(string = elProps.getStrElAssoc()).intValue()) - 1 != n2) {
                elProps = this.mProperties.getElementProp(n2 == 1 ? 0 : 1);
            }
            if (elProps.getStatistic().getStat() != Statistics.PctOfCases && (elProps.getFlags() & 0x10) != 0) {
                return true;
            }
        }
        return false;
    }

    private void addGPLSyntax(StringBuffer stringBuffer) {
        stringBuffer.append("BEGIN GPL\n");
        boolean bl = this.checkPageSize(stringBuffer);
        stringBuffer.append(String.format("  SOURCE: s=userSource(id(\"graphdataset\")%s)\n", this.getWeightSyntax()));
        this.setupGPLDataStatements(stringBuffer);
        this.setupGPLCoordStatement(stringBuffer);
        this.setupGPLAxisGuideStatements(stringBuffer);
        this.setupGPLLegendGuideStatements(stringBuffer);
        this.setupGPLTitleStatements(stringBuffer);
        this.setupGPLScaleStatements(stringBuffer);
        this.setupGPLTransStatements(stringBuffer);
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        this.setupGPLElementStatements(stringBuffer, elProps, 0);
        if (this.mProperties.getCoords() == Coords.coords_DualY) {
            elProps = this.mProperties.getElementProp(1);
            this.setupGPLElementStatements(stringBuffer, elProps, 1);
        }
        if (bl) {
            stringBuffer.append("  PAGE: end()\n");
        }
        stringBuffer.append("END GPL.\n");
    }

    private String getWeightSyntax() {
        boolean bl;
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        if (elProps != null) {
            boolean bl2 = bl = (elProps.getFlags() & 0x10) != 0;
            if (elProps.getStatistic().getStat() == Statistics.PctOfCases && bl) {
                return ", weight(COUNT)";
            }
        }
        if ((elProps = this.mProperties.getElementProp(1)) != null) {
            boolean bl3 = bl = (elProps.getFlags() & 0x10) != 0;
            if (elProps.getStatistic().getStat() == Statistics.PctOfCases && bl) {
                return ", weight(COUNT)";
            }
        }
        return "";
    }

    private boolean checkPageSize(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = this.mOptions.getChartSizePct();
        if (n != 100) {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
            Preferences preferences2 = preferences.node("charts");
            String string = preferences2.get("aspect_ratio", PrefDefaults.DEF_CHART_ASPECT_RATIO);
            double d = Double.valueOf(string);
            int n2 = (int)((d *= 500.0) * (double)n) / 100;
            int n3 = 500 * n / 100;
            String string2 = String.format("  PAGE: begin(scale(%dpx,%dpx))", n2, n3);
            stringBuffer.append(string2);
            bl = true;
        }
        return bl;
    }

    private Vector<SyntaxVariable> acquireVariables() {
        boolean bl = this.mProperties.getHasSSVs();
        boolean bl2 = this.mProperties.getIsOverlayScatter();
        boolean bl3 = this.mCanvas.getImager().isPopulationPyramid();
        ZoneMgr zoneMgr = this.mCanvas.getZoneMgr();
        ZoneType zoneType = bl ? this.mCanvas.getZoneMgr().getIndexVarZoneType() : null;
        this.mVariables = new Vector();
        for (ZoneType zoneType2 : ZoneType.values()) {
            String string;
            String string2;
            boolean bl4;
            if (bl2 && zoneType2 == ZoneType.zt_group) continue;
            boolean bl5 = bl4 = bl3 && zoneType2 == ZoneType.zt_y;
            if (!zoneMgr.hasZone(zoneType2) && !bl4) continue;
            DropZone dropZone = zoneMgr.getZone(zoneType2);
            if (bl2 && (zoneType2 == ZoneType.zt_x || zoneType2 == ZoneType.zt_y)) {
                this.addOverlayDepVars(this.mVariables, zoneType2);
                continue;
            }
            if (bl4 || dropZone.isDependentVarZone()) {
                if (bl4 && zoneMgr.hasScaleVar(ZoneType.zt_dist_var) || dropZone != null && dropZone.isEmpty() && zoneType2 == ZoneType.zt_close || zoneType2 == ZoneType.zt_y && dropZone != null && dropZone.isEmpty() && this.mCanvas.getImager().isHistogram()) continue;
                if (bl) {
                    this.addSSVDepVars(zoneType2, this.mVariables);
                    continue;
                }
                this.addDependentVariables(dropZone, this.mVariables, bl4);
                continue;
            }
            if (zoneType2 == ZoneType.zt_matrix) {
                this.addMatrixVariables(dropZone, this.mVariables);
                continue;
            }
            if (dropZone.isEmpty() || zoneType2 == zoneType) continue;
            ISpssVariable iSpssVariable = dropZone.getVariables().get(0);
            SyntaxVariable syntaxVariable = new SyntaxVariable(iSpssVariable.getName());
            if (zoneType2 == ZoneType.zt_point_id) {
                string2 = this.fixupGPLName(GplUtil.makeLegalGplName((String)iSpssVariable.getName()));
                string = this.fixupGPLName(iSpssVariable.getName());
            } else {
                string2 = this.fixupGPLName(this.makeLegalGPLName(iSpssVariable.getName()));
                String string3 = this.fixupGPLName(iSpssVariable.getName());
                syntaxVariable.setGGraphBaseName(string3);
                string = this.makeUniqueGGraphName(string3, iSpssVariable.getName());
            }
            syntaxVariable.setSyntaxName(string2);
            syntaxVariable.setGGraphName(string);
            syntaxVariable.setVariable(iSpssVariable);
            syntaxVariable.setZoneType(zoneType2);
            syntaxVariable.setAxisLabel(this.getAxisLabel(zoneType2));
            this.mVariables.add(syntaxVariable);
        }
        return this.mVariables;
    }

    private String fixupGPLName(String string) {
        string = string.replace(".", "_").replace("#", "_").replace("$", "_").replace("@", "_").replace("-", "_");
        return string;
    }

    private void addOverlayDepVars(Vector<SyntaxVariable> vector, ZoneType zoneType) {
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(zoneType);
        for (ISpssVariable iSpssVariable : dropZone.getVariables()) {
            if (this.isNameInList(iSpssVariable.getName())) continue;
            SyntaxVariable syntaxVariable = new SyntaxVariable(iSpssVariable.getName());
            syntaxVariable.setZoneType(zoneType);
            syntaxVariable.setAxisLabel(this.getAxisLabel(zoneType));
            syntaxVariable.setSyntaxName(this.fixupGPLName(iSpssVariable.getName()));
            syntaxVariable.setGGraphName(syntaxVariable.getOrgName());
            syntaxVariable.setVariable(iSpssVariable);
            vector.add(syntaxVariable);
        }
    }

    private void addSSVDepVars(ZoneType zoneType, Vector<SyntaxVariable> vector) {
        SyntaxVariable syntaxVariable = new SyntaxVariable("#SUMMARY");
        syntaxVariable.setZoneType(zoneType);
        syntaxVariable.setAxisLabel(this.getAxisLabel(zoneType));
        syntaxVariable.setSyntaxName(this.fixupGPLName("SUMMARY"));
        syntaxVariable.setGGraphName(syntaxVariable.getOrgName());
        vector.add(syntaxVariable);
        ZoneType zoneType2 = this.mCanvas.getZoneMgr().getIndexVarZoneType();
        syntaxVariable = new SyntaxVariable("#INDEX");
        syntaxVariable.setZoneType(zoneType2);
        syntaxVariable.setAxisLabel(this.getAxisLabel(zoneType2));
        syntaxVariable.setSyntaxName(this.fixupGPLName("INDEX"));
        syntaxVariable.setGGraphName(syntaxVariable.getOrgName());
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(zoneType2);
        syntaxVariable.setVariable(dropZone.getVariables().get(0));
        vector.add(syntaxVariable);
    }

    private void addDependentVariables(DropZone dropZone, Vector<SyntaxVariable> vector, boolean bl) {
        boolean bl2;
        ZoneType zoneType = bl ? ZoneType.zt_y : dropZone.getZoneType();
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        if (this.mProperties.getCoords() == Coords.coords_DualY && (!(bl2 = this.mCanvas.getImager().dualYElementWithFirstYAxis(elProps.getStrElId())) && zoneType == ZoneType.zt_y || bl2 && zoneType == ZoneType.zt_y2)) {
            elProps = this.mProperties.getElementProp(1);
        }
        if (bl || dropZone.isEmpty()) {
            boolean bl3;
            Statistics statistics = elProps.getStatistic().getStat();
            boolean bl4 = (elProps.getFlags() & 0x10) != 0 && statistics != Statistics.PctOfCases;
            boolean bl5 = statistics == Statistics.ResponsePct || statistics == Statistics.CumResponsePct;
            boolean bl6 = bl3 = statistics == Statistics.Responses || statistics == Statistics.CumResponses || bl5;
            SyntaxVariable syntaxVariable = bl4 ? new SyntaxVariable(String.format("COUNTCI(%s)", DialogUtil.formatDouble(elProps.getLevel(), Locale.ENGLISH))) : (bl3 ? (bl5 ? new SyntaxVariable("PCTRESPONSES()") : new SyntaxVariable("RESPONSES()")) : new SyntaxVariable("COUNT()"));
            syntaxVariable.setZoneType(zoneType);
            syntaxVariable.setAxisLabel(this.getAxisLabel(zoneType));
            if (bl4) {
                String string = DialogUtil.formatDouble(elProps.getLevel());
                string = string.replace('.', '_');
                syntaxVariable.setGGraphName("COUNTCI_" + string);
                if (this.mProperties.getCoords() == Coords.coords_DualY) {
                    syntaxVariable.setSyntaxName(this.fixupGPLName(syntaxVariable.getGGraphName()));
                } else {
                    syntaxVariable.setSyntaxName("COUNT");
                }
            } else if (bl3) {
                if (bl5) {
                    syntaxVariable.setSyntaxName(this.fixupGPLName("PCTRESPONSES"));
                } else {
                    syntaxVariable.setSyntaxName(this.fixupGPLName("RESPONSES"));
                }
                syntaxVariable.setGGraphName(syntaxVariable.getSyntaxName());
            } else {
                syntaxVariable.setSyntaxName(this.fixupGPLName("COUNT"));
                syntaxVariable.setGGraphName(syntaxVariable.getSyntaxName());
            }
            vector.add(syntaxVariable);
            return;
        }
        bl2 = this.mCanvas.getImager().isSchema();
        Statistics statistics = elProps.getStatistic().getStat();
        for (ISpssVariable iSpssVariable : dropZone.getVariables()) {
            SyntaxVariable syntaxVariable = new SyntaxVariable(iSpssVariable.getName());
            syntaxVariable.setVariable(iSpssVariable);
            syntaxVariable.setZoneType(zoneType);
            syntaxVariable.setAxisLabel(this.getAxisLabel(zoneType));
            if (statistics == Statistics.Value || bl2) {
                syntaxVariable.setSyntaxName(this.fixupGPLName(this.makeLegalGPLName(iSpssVariable.getName())));
                syntaxVariable.setGGraphName(this.fixupGPLName(iSpssVariable.getName()));
            } else {
                syntaxVariable.setSyntaxName(this.fixupGPLName(this.makeDepVarSyntaxName(syntaxVariable, elProps.getStatistic(), zoneType, iSpssVariable)));
                syntaxVariable.setGGraphName(syntaxVariable.getSyntaxName());
            }
            vector.add(syntaxVariable);
        }
    }

    private String makeDepVarSyntaxName(SyntaxVariable syntaxVariable, ElementStat elementStat, ZoneType zoneType, ISpssVariable iSpssVariable) {
        int n = zoneType == ZoneType.zt_y2 ? 1 : 0;
        Props.ElProps elProps = this.mProperties.getElementProp(n);
        boolean bl = this.isErrorBarDepZone(syntaxVariable);
        if (zoneType == ZoneType.zt_low) {
            elementStat = ((Props.HiLoCloseProps)elProps).getLowStat();
        } else if (zoneType == ZoneType.zt_close) {
            elementStat = ((Props.HiLoCloseProps)elProps).getCloseStat();
        }
        String string = "";
        String string2 = bl ? this.getErrorBarStatName(elementStat.getStat(), elProps.getErrorIntervalType()) : elementStat.getStat().getSyntaxString();
        String string3 = string2 + "_" + iSpssVariable.getName();
        int n2 = bl ? 1 : this.parameterCount(elementStat.getStat());
        if (n2 > 0) {
            string3 = bl ? string3 + "_" + this.getErrorBarParmString(elProps) : string3 + "_" + elementStat.getStrParm1();
            if (n2 > 1) {
                string3 = string3 + "_" + elementStat.getStrParm2();
            }
            string3 = string3.replace('.', '_');
            string3 = string3.replace(',', '_');
        }
        if (n2 == 0) {
            string = String.format("%s(%s)", string2, iSpssVariable.getName());
        } else if (n2 == 1) {
            String string4 = bl ? this.getErrorBarParmString(elProps) : elementStat.getStrParm1();
            string4 = string4.replace(',', '.');
            string = String.format("%s(%s, %s)", string2, iSpssVariable.getName(), string4);
        } else if (n2 == 2) {
            String string5 = elementStat.getStrParm1();
            string5 = string5.replace(',', '.');
            String string6 = elementStat.getStrParm2();
            string6 = string6.replace(',', '.');
            string = String.format("%s(%s, %s, %s)", string2, iSpssVariable.getName(), string5, string6);
        }
        syntaxVariable.setOrgName(string);
        syntaxVariable.setGGraphName(string3);
        if (bl) {
            string3 = elementStat.getStat().getSyntaxString() + "_" + iSpssVariable.getName();
        }
        return this.makeLegalGPLName(string3);
    }

    private String getErrorBarParmString(Props.ElProps elProps) {
        IPropEnum.ErrorIntervalType errorIntervalType = elProps.getErrorIntervalType();
        String string = errorIntervalType == IPropEnum.ErrorIntervalType.eit_Confidence ? DialogUtil.formatDouble(elProps.getLevel()) : (errorIntervalType == IPropEnum.ErrorIntervalType.eit_MultStdError ? DialogUtil.formatDouble(elProps.getMultiplierStdError()) : DialogUtil.formatDouble(elProps.getMultiplierStdDev()));
        string = string.replace(',', '.');
        return string;
    }

    private int parameterCount(Statistics statistics) {
        int n = 0;
        if (statistics == Statistics.PctOfCases || statistics == Statistics.PTile || statistics == Statistics.GPTile || statistics == Statistics.NumAbove || statistics == Statistics.NumBelow || statistics == Statistics.PctAbove || statistics == Statistics.PctBelow) {
            n = 1;
        } else if (statistics == Statistics.NumInside || statistics == Statistics.PctInside) {
            n = 2;
        }
        return n;
    }

    private String getAxisLabel(ZoneType zoneType) {
        String string = "";
        for (Props props : this.mProperties.getProperties()) {
            Props.AxisProps axisProps;
            if (!(props instanceof Props.AxisProps) || (axisProps = (Props.AxisProps)props).getZoneType() != zoneType) continue;
            string = axisProps.getStrLabel();
            break;
        }
        return string;
    }

    private void addMatrixVariables(DropZone dropZone, Vector<SyntaxVariable> vector) {
        for (ISpssVariable iSpssVariable : dropZone.getVariables()) {
            SyntaxVariable syntaxVariable = new SyntaxVariable(iSpssVariable.getName());
            syntaxVariable.setSyntaxName(this.fixupGPLName(this.makeLegalGPLName(iSpssVariable.getName())));
            syntaxVariable.setGGraphName(syntaxVariable.getSyntaxName());
            syntaxVariable.setVariable(iSpssVariable);
            syntaxVariable.setZoneType(ZoneType.zt_matrix);
            String string = iSpssVariable.getLabel();
            if (string == null || string.length() == 0) {
                string = iSpssVariable.getName();
            }
            syntaxVariable.setAxisLabel(string);
            vector.add(syntaxVariable);
        }
    }

    private void setupGPLDataStatements(StringBuffer stringBuffer) {
        Object object;
        boolean bl = this.mProperties.getHasSSVs();
        boolean bl2 = this.mCanvas.getImager().isDifferenceArea();
        for (SyntaxVariable syntaxVariable : this.mVariables) {
            CharSequence charSequence;
            if ((syntaxVariable.getZoneType() == ZoneType.zt_point_id || syntaxVariable.getZoneType() == ZoneType.zt_filter) && this.hasNonPointIdVarInList(syntaxVariable.getSyntaxName())) continue;
            stringBuffer.append("  DATA: ");
            if (bl2 && (syntaxVariable.getZoneType() == ZoneType.zt_high || syntaxVariable.getZoneType() == ZoneType.zt_low)) {
                if (syntaxVariable.getZoneType() == ZoneType.zt_high) {
                    stringBuffer.append("values=col(source(s), name(\"values\")");
                } else {
                    stringBuffer.append("category=col(source(s), name(\"category\"), unit.category()");
                }
            } else {
                stringBuffer.append(syntaxVariable.getSyntaxName()).append("=col(source(s), name(\"");
                charSequence = syntaxVariable.getGGraphName();
                if (syntaxVariable.getGGraphBaseName() != null && !syntaxVariable.getGGraphBaseName().equals(charSequence)) {
                    charSequence = syntaxVariable.getOrgName();
                }
                stringBuffer.append((String)charSequence).append("\")");
            }
            if (syntaxVariable.isCategorical()) {
                if (syntaxVariable.getZoneType() != ZoneType.zt_point_id) {
                    charSequence = new StringBuffer();
                    object = "";
                    boolean bl3 = false;
                    Props.CatAxisProps catAxisProps = (Props.CatAxisProps)this.getAxisProp(syntaxVariable.getZoneType());
                    Vector<RelabelBag> vector = catAxisProps.getCategories();
                    for (RelabelBag relabelBag : vector) {
                        if (!this.mOptions.getIncludeBreakVars() && relabelBag.getUserMissing() || !relabelBag.getExcluded()) continue;
                        int n = relabelBag.getStrOrgValue().length();
                        if (n > 40 || ((String)object).length() + n > 80) {
                            object = (String)object + "\n";
                            ((StringBuffer)charSequence).append((String)object);
                            object = "";
                        }
                        if (bl3) {
                            object = (String)object + ", ";
                        }
                        object = (String)object + "\"" + relabelBag.getStrOrgValue() + "\"";
                        bl3 = true;
                    }
                    ((StringBuffer)charSequence).append((String)object);
                    if (((StringBuffer)charSequence).length() > 0) {
                        stringBuffer.append(",\nnotIn(").append(((StringBuffer)charSequence).toString()).append(")");
                    }
                }
                stringBuffer.append(", unit.category()");
            }
            stringBuffer.append(")\n");
        }
        if (this.mCanvas.getImager().isSchema() && this.getSyntaxVar(ZoneType.zt_point_id) == null) {
            stringBuffer.append("  DATA: id=col(source(s), name(\"$CASENUM\"), unit.category())\n");
        }
        if (this.mProperties.getCoords() == Coords.coords_2D || this.mProperties.getCoords() == Coords.coords_DualY || this.mProperties.getCoords() == Coords.coords_3D) {
            boolean bl4;
            Object object2 = this.mProperties.getElementProp(0);
            boolean bl5 = bl4 = (((Props)object2).getFlags() & 0x10) != 0 && ((Props.ElProps)object2).getStatistic().getStat() != Statistics.PctOfCases;
            if (bl4) {
                boolean bl6 = false;
                if (this.mProperties.getCoords() == Coords.coords_DualY) {
                    bl6 = !this.mCanvas.getImager().dualYElementWithFirstYAxis(((Props)object2).getStrElId());
                }
                object = !bl6 ? ZoneType.zt_y : ZoneType.zt_y2;
                SyntaxVariable syntaxVariable = this.getSyntaxVar((ZoneType)((Object)object));
                stringBuffer.append("  DATA: LOW=col(source(s), name(\"");
                if (bl) {
                    stringBuffer.append("#LOW").append("\"))\n");
                } else {
                    stringBuffer.append(syntaxVariable.getGGraphName()).append("_LOW").append("\"))\n");
                }
                stringBuffer.append("  DATA: HIGH=col(source(s), name(\"");
                if (bl) {
                    stringBuffer.append("#HIGH").append("\"))\n");
                } else {
                    stringBuffer.append(syntaxVariable.getGGraphName()).append("_HIGH").append("\"))\n");
                }
            }
            if (this.mProperties.getCoords() == Coords.coords_DualY) {
                object2 = this.mProperties.getElementProp(1);
                boolean bl7 = bl4 = (((Props)object2).getFlags() & 0x10) != 0 && ((Props.ElProps)object2).getStatistic().getStat() != Statistics.PctOfCases;
                if (bl4) {
                    boolean bl8 = !this.mCanvas.getImager().dualYElementWithFirstYAxis(((Props)object2).getStrElId());
                    object = !bl8 ? ZoneType.zt_y : ZoneType.zt_y2;
                    SyntaxVariable syntaxVariable = this.getSyntaxVar((ZoneType)((Object)object));
                    stringBuffer.append("  DATA: LOW2=col(source(s), name(\"");
                    stringBuffer.append(syntaxVariable.getGGraphName()).append("_LOW").append("\"))\n");
                    stringBuffer.append("  DATA: HIGH2=col(source(s), name(\"");
                    stringBuffer.append(syntaxVariable.getGGraphName()).append("_HIGH").append("\"))\n");
                }
            }
        }
    }

    private boolean hasNonPointIdVarInList(String string) {
        for (SyntaxVariable syntaxVariable : this.mVariables) {
            if (syntaxVariable.getZoneType() == ZoneType.zt_point_id || !syntaxVariable.getSyntaxName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void setupGPLCoordStatement(StringBuffer stringBuffer) {
        boolean bl = this.mCanvas.getImager().hasXCluster();
        boolean bl2 = this.mCanvas.getImager().isTransposed();
        boolean bl3 = this.mCanvas.getImager().hasHorzPanels();
        boolean bl4 = this.mCanvas.getImager().hasVertPanels();
        boolean bl5 = this.mOptions.getWrapPanels() && (bl3 || bl4);
        Coords coords = this.mProperties.getCoords();
        String string = "";
        if (coords == Coords.coords_1D) {
            string = "rect(dim(1)";
            if (bl2) {
                string = string + ", transpose()";
            } else if (bl5) {
                string = string + ", wrap()";
            }
            string = string + ")";
        } else if (coords == Coords.coords_2D || coords == Coords.coords_DualY) {
            boolean bl6 = this.mCanvas.getImager().isPopulationPyramid();
            if (bl6) {
                string = "transpose(mirror(rect(dim(1,2)";
                if (bl5) {
                    string = string + ", wrap()";
                }
                string = string + ")))";
            } else if (bl || bl2 || bl5) {
                string = "rect(dim(1,2)";
                if (bl2) {
                    string = string + ", transpose()";
                }
                if (bl) {
                    string = string + ", cluster(3,0)";
                }
                if (bl5 && !bl2) {
                    string = string + ", wrap()";
                }
                string = string + ")";
            }
        } else if (coords == Coords.coords_3D) {
            boolean bl7 = this.mCanvas.getImager().hasZCluster();
            string = "rect(dim(1,2,3)";
            if (bl || bl7 || bl2) {
                if (bl2) {
                    string = string + ", transpose()";
                }
                if (bl && bl7) {
                    string = string + ", cluster(4,5,0)";
                } else if (bl) {
                    string = string + ", cluster(0,4,0)";
                } else if (bl7) {
                    string = string + ", cluster(4,0,0)";
                }
            }
            if (bl5 && !bl2) {
                string = string + ", wrap()";
            }
            string = string + ")";
        } else if (coords == Coords.coords_Polar) {
            Props.AngleAxisProps angleAxisProps = (Props.AngleAxisProps)this.getAxisProp(ZoneType.zt_angle);
            int n = 360 - angleAxisProps.getClockPos() * 30;
            if (angleAxisProps.getClockPos() == 12) {
                n = 0;
            }
            string = String.format("polar.theta(startAngle(%d)", n);
            if (angleAxisProps.getClockOrder() == IPropEnum.PolarClockOrder.pco_CounterClockwise) {
                string = string + ", reverse()";
            }
            if (bl5) {
                string = string + ", wrap()";
            }
            string = string + ")";
        } else {
            return;
        }
        if (string.length() > 0) {
            stringBuffer.append("  COORD: ").append(string).append("\n");
        }
    }

    private void setupGPLAxisGuideStatements(StringBuffer stringBuffer) {
        Coords coords = this.mProperties.getCoords();
        if (coords == Coords.coords_1D) {
            this.addAxisGuide(1, stringBuffer, ZoneType.zt_x, false);
            if (this.mCanvas.getImager().hasHorzPanels()) {
                this.addAxisGuide(2, stringBuffer, ZoneType.zt_panel_horz, true);
            }
            if (this.mCanvas.getImager().hasVertPanels()) {
                this.addAxisGuide(3, stringBuffer, ZoneType.zt_panel_vert, true);
            }
        } else if (coords == Coords.coords_2D || coords == Coords.coords_DualY) {
            if (this.mCanvas.getImager().isSplom()) {
                this.setupSplomAxisGuide(stringBuffer);
                return;
            }
            boolean bl = this.mCanvas.getImager().hasXCluster();
            if (this.mCanvas.getImager().isPopulationPyramid()) {
                this.addPyramidAxisGuides(stringBuffer);
            } else {
                int n = bl ? 3 : 1;
                this.addAxisGuide(n, stringBuffer, ZoneType.zt_x, false);
                if (coords == Coords.coords_DualY) {
                    this.addDualYDepVarAxisGuides(stringBuffer);
                } else if (!this.mCanvas.getImager().isDifferenceArea()) {
                    this.addAxisGuide(2, stringBuffer, ZoneType.zt_y, false);
                }
                if (this.mCanvas.getImager().hasHorzPanels()) {
                    this.addAxisGuide(bl ? 4 : 3, stringBuffer, ZoneType.zt_panel_horz, true);
                }
                if (this.mCanvas.getImager().hasVertPanels()) {
                    this.addAxisGuide(bl ? 5 : 4, stringBuffer, ZoneType.zt_panel_vert, true);
                }
            }
        } else if (coords == Coords.coords_3D) {
            boolean bl = this.mCanvas.getImager().hasXCluster();
            boolean bl2 = this.mCanvas.getImager().hasZCluster();
            int n = bl2 ? 4 : 1;
            this.addAxisGuide(n, stringBuffer, ZoneType.zt_z, false);
            n = bl && bl2 ? 5 : (bl ? 4 : 2);
            this.addAxisGuide(n, stringBuffer, ZoneType.zt_x, false);
            this.addAxisGuide(3, stringBuffer, ZoneType.zt_y, false);
            if (this.mCanvas.getImager().hasHorzPanels()) {
                n = bl && bl2 ? 6 : (bl || bl2 ? 5 : 4);
                this.addAxisGuide(n, stringBuffer, ZoneType.zt_panel_horz, true);
            }
            if (this.mCanvas.getImager().hasVertPanels()) {
                n = bl && bl2 ? 7 : (bl || bl2 ? 6 : 5);
                this.addAxisGuide(n, stringBuffer, ZoneType.zt_panel_vert, true);
            }
        } else if (coords == Coords.coords_Polar) {
            stringBuffer.append("  GUIDE: axis(dim(1)");
            Props.AxisProps axisProps = this.getAxisProp(ZoneType.zt_angle);
            if ((axisProps.getFlags() & 0x20) == 0) {
                stringBuffer.append(", null()");
            }
            stringBuffer.append(")\n");
            if (this.mCanvas.getImager().hasHorzPanels()) {
                this.addAxisGuide(2, stringBuffer, ZoneType.zt_panel_horz, true);
            }
            if (this.mCanvas.getImager().hasVertPanels()) {
                this.addAxisGuide(3, stringBuffer, ZoneType.zt_panel_vert, true);
            }
        }
    }

    private void addDualYDepVarAxisGuides(StringBuffer stringBuffer) {
        Props.AxisProps axisProps = this.getAxisProp(ZoneType.zt_y);
        String string = String.format("  GUIDE: axis(scale(y1)", new Object[0]);
        String string2 = this.getAxisDelta(axisProps);
        String string3 = axisProps.getStrLabel().replace("\"", "\\\"");
        if (string3 != null && string3.length() > 0) {
            string2 = string2 + ", label(\"" + string3 + "\")";
        }
        String string4 = this.mCanvas.getImager().getDualYAxisColor(0);
        stringBuffer.append(string).append(string2).append(String.format(", color(color.\"%s\"))\n", string4));
        Props.AxisProps axisProps2 = this.getAxisProp(ZoneType.zt_y2);
        string = String.format("  GUIDE: axis(scale(y2)", new Object[0]);
        string2 = this.getAxisDelta(axisProps2);
        string3 = axisProps2.getStrLabel().replace("\"", "\\\"");
        if (string3 != null && string3.length() > 0) {
            string2 = string2 + ", label(\"" + string3 + "\")";
        }
        string4 = this.mCanvas.getImager().getDualYAxisColor(1);
        stringBuffer.append(string).append(string2).append(String.format(", color(color.\"%s\"), opposite())\n", string4));
    }

    private void addPyramidAxisGuides(StringBuffer stringBuffer) {
        Props.AxisProps axisProps = this.getAxisProp(ZoneType.zt_y);
        SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_dist_var);
        SyntaxVariable syntaxVariable2 = this.getSyntaxVar(ZoneType.zt_split_var);
        SyntaxVariable syntaxVariable3 = this.getSyntaxVar(ZoneType.zt_panel_vert);
        if (syntaxVariable == null || syntaxVariable2 == null) {
            return;
        }
        stringBuffer.append("  GUIDE: axis(dim(1), label(\"").append(syntaxVariable.getAxisLabel().replace("\"", "\\\"")).append("\"))\n");
        if (syntaxVariable.isCategorical()) {
            this.manageCollapsed(this.getAxisProp(ZoneType.zt_dist_var));
        }
        if (syntaxVariable3 == null) {
            stringBuffer.append("  GUIDE: axis(dim(1), opposite(), label(\"").append(syntaxVariable.getAxisLabel().replace("\"", "\\\"")).append("\"))\n");
        }
        stringBuffer.append("  GUIDE: axis(dim(2), label(\"").append(axisProps.getStrLabel().replace("\"", "\\\"")).append("\"))\n");
        stringBuffer.append("  GUIDE: axis(dim(3), label(\"").append(syntaxVariable2.getAxisLabel().replace("\"", "\\\""));
        stringBuffer.append("\"), opposite(), gap(0px))\n");
        if (syntaxVariable3 != null) {
            stringBuffer.append("  GUIDE: axis(dim(4), label(\"").append(syntaxVariable3.getAxisLabel().replace("\"", "\\\""));
            stringBuffer.append("\"), opposite(), gap(0px))\n");
            this.manageCollapsed(this.getAxisProp(ZoneType.zt_panel_vert));
        }
    }

    private void addAxisGuide(int n, StringBuffer stringBuffer, ZoneType zoneType, boolean bl) {
        Props.AxisProps axisProps = this.getAxisProp(zoneType);
        if (axisProps == null) {
            return;
        }
        String string = this.getAxisDelta(axisProps);
        String string2 = axisProps.getStrLabel() != null ? axisProps.getStrLabel().trim().replace("\"", "\\\"") : "";
        if ((string2 = string2.replace("\n", "\\n")) != null && string2.length() > 0) {
            string = string + ", label(\"" + string2 + "\")";
        }
        if (bl) {
            string = string + ", opposite()";
        }
        if (string.length() > 0) {
            String string3 = String.format("  GUIDE: axis(dim(%d)", n);
            stringBuffer.append(string3).append(string).append(")\n");
        }
        this.manageCollapsed(axisProps);
    }

    private void manageCollapsed(Props.AxisProps axisProps) {
        boolean bl;
        if (!(axisProps instanceof Props.CatAxisProps)) {
            return;
        }
        boolean bl2 = bl = (axisProps.getFlags() & 0x40) != 0;
        if (bl || (axisProps.getFlags() & 0x10) == 0) {
            return;
        }
        Coords coords = this.mProperties.getCoords();
        Props.CatAxisProps catAxisProps = (Props.CatAxisProps)axisProps;
        SyntaxVariable syntaxVariable = this.getSyntaxVar(catAxisProps.getZoneType());
        if (syntaxVariable != null) {
            SyntaxVariable syntaxVariable2 = coords == Coords.coords_Polar ? this.getSyntaxVar(ZoneType.zt_angle) : (coords == Coords.coords_1D || this.mCanvas.getImager().isHistogram() ? this.getSyntaxVar(ZoneType.zt_x) : this.getSyntaxVar(ZoneType.zt_y));
            String string = this.makeLegalGPLName(syntaxVariable.getSyntaxName() + "_TRANS");
            String string2 = Integer.toString(catAxisProps.getCollapsePct());
            String string3 = this.mCanvas.getResources().getResString("IDS_COLLAPSED_CAT");
            String string4 = "  TRANS: " + string + " = collapse(category(" + syntaxVariable.getSyntaxName() + ")";
            string4 = string4 + ", minimumPercent(" + string2 + "), sumVariable(" + syntaxVariable2.getSyntaxName() + ")";
            string4 = string4 + ", otherValue(\"" + string3 + "\"))\n";
            TransBag transBag = new TransBag();
            transBag.mOrgName = syntaxVariable.getSyntaxName();
            transBag.mSyntaxName = string;
            transBag.mTransString = string4;
            this.mTransBags.put(transBag.mOrgName, transBag);
        }
    }

    private String makeLegalGPLName(String string) {
        String string2;
        String string3 = string;
        string = string2 = GplUtil.makeLegalGplName((String)string);
        int n = 1;
        while (this.isNameInList(string) || this.isNameInDataset(string, string3)) {
            string = String.format("%s%d", string2, n++);
        }
        return string;
    }

    private boolean isNameInList(String string) {
        for (SyntaxVariable syntaxVariable : this.mVariables) {
            if (!syntaxVariable.getSyntaxName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isGGraphNameInList(String string) {
        for (SyntaxVariable syntaxVariable : this.mVariables) {
            if (!syntaxVariable.getGGraphName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private String makeUniqueGGraphName(String string, String string2) {
        String string3 = string;
        int n = 1;
        while (this.isGGraphNameInList(string) || this.isNameInDataset(string, string2)) {
            string = String.format("%s%d", string3, n++);
        }
        return string;
    }

    private SyntaxVariable getSyntaxVar(ZoneType zoneType) {
        for (SyntaxVariable syntaxVariable : this.mVariables) {
            if (syntaxVariable.getZoneType() != zoneType) continue;
            return syntaxVariable;
        }
        return null;
    }

    private SyntaxVariable getSyntaxVar(String string) {
        for (SyntaxVariable syntaxVariable : this.mVariables) {
            if (!syntaxVariable.getOrgName().equals(string)) continue;
            return syntaxVariable;
        }
        return null;
    }

    private String getAxisDelta(Props.AxisProps axisProps) {
        if (!(axisProps instanceof Props.ScaleAxisProps)) {
            return "";
        }
        int n = axisProps.getFlags();
        if ((n & 4) == 0) {
            String string = ((Props.ScaleAxisProps)axisProps).getStrMajorIncrement();
            string = string.replace(',', '.');
            return ", delta(" + string + ")";
        }
        return "";
    }

    private void setupSplomAxisGuide(StringBuffer stringBuffer) {
        stringBuffer.append("  GUIDE: axis(dim(1.1)").append(", ticks(null()))\n");
        stringBuffer.append("  GUIDE: axis(dim(2.1)").append(", ticks(null()))\n");
        stringBuffer.append("  GUIDE: axis(dim(1)").append(", gap(0px))\n");
        stringBuffer.append("  GUIDE: axis(dim(2)").append(", gap(0px))\n");
    }

    private void setupGPLLegendGuideStatements(StringBuffer stringBuffer) {
        Object object;
        Object object2;
        if (this.mProperties.getIsOverlayScatter()) {
            return;
        }
        if (this.mCanvas.getImager().isDifferenceArea()) {
            String string = String.format("  GUIDE: legend(aesthetic(aesthetic.color.interior), label(\"%s\"))\n", this.generateDiffAreaLegendLabel());
            stringBuffer.append(string);
            return;
        }
        if (this.mCanvas.getImager().isPopulationPyramid()) {
            stringBuffer.append("  GUIDE: legend(aesthetic(aesthetic.color), null())\n");
            return;
        }
        Props.LegendProps legendProps = this.getLegendProp(0);
        if (legendProps != null) {
            object2 = this.getSyntaxVar(legendProps.getZoneType());
            object = this.getAestheticString(legendProps, true);
            stringBuffer.append("  GUIDE: legend(aesthetic(").append((String)object).append("), label(\"");
            stringBuffer.append(((SyntaxVariable)object2).getAxisLabel().replace("\"", "\\\"")).append("\"))\n");
            this.manageCollapsed(legendProps);
        }
        if ((object2 = this.getLegendProp(1)) != null) {
            object = this.getSyntaxVar(((Props.AxisProps)object2).getZoneType());
            String string = this.getAestheticString((Props.LegendProps)object2, true);
            stringBuffer.append("  GUIDE: legend(aesthetic(").append(string).append("), label(\"");
            stringBuffer.append(((SyntaxVariable)object).getAxisLabel().replace("\"", "\\\"")).append("\"))\n");
            this.manageCollapsed((Props.AxisProps)object2);
        }
    }

    private String getAestheticString(Props.LegendProps legendProps, boolean bl) {
        if (legendProps == null) {
            return "";
        }
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        boolean bl2 = elProps instanceof Props.PointProps;
        boolean bl3 = elProps instanceof Props.LineProps;
        boolean bl4 = elProps instanceof Props.MatrixProps;
        boolean bl5 = elProps instanceof Props.SchemaProps;
        boolean bl6 = this.mProperties.getIsOverlayScatter();
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(legendProps.getZoneType());
        boolean bl7 = dropZone.getUsesColorStyling();
        boolean bl8 = false;
        if (elProps instanceof Props.BarProps) {
            boolean bl9 = bl8 = ((Props.BarProps)elProps).getIntervalStyle() != IPropEnum.IntervalStyle.is_Square;
        }
        String string = bl7 ? (bl5 ? "color" : "color.interior") : (bl3 || bl2 || bl6 || bl4 ? "shape.interior" : (bl5 ? "texture.pattern" : (bl8 ? "shape.exterior" : "texture.pattern.interior")));
        if (bl) {
            string = "aesthetic." + string;
        }
        return string;
    }

    private String generateDiffAreaLegendLabel() {
        String string;
        Props.HiLoCloseProps hiLoCloseProps = (Props.HiLoCloseProps)this.mProperties.getElementProp(0);
        ElementStat elementStat = hiLoCloseProps.getLowStat();
        ElementStat elementStat2 = hiLoCloseProps.getHighStat();
        String string2 = elementStat.getStat() == elementStat2.getStat() && elementStat.getStrParm1().equals(elementStat2.getStrParm1()) && elementStat.getStrParm2().equals(elementStat2.getStrParm2()) ? elementStat2.getStat().getStatLabel(this.mCanvas.getResources(), elementStat2) : (elementStat.getVariable().equals(elementStat2.getVariable()) ? ((string = elementStat.getVariable().getLabel()) != null && string.length() > 0 ? string : elementStat.getVariable().getName()) : elementStat2.getStat().getStatLabel(this.mCanvas.getResources(), elementStat2) + " \\\\ " + elementStat.getStat().getStatLabel(this.mCanvas.getResources(), elementStat));
        return string2;
    }

    private void setupGPLTitleStatements(StringBuffer stringBuffer) {
        String string;
        Props.TitleProps titleProps;
        Object object;
        Object object2;
        Object object3;
        Props.TitleProps titleProps2 = this.getTitleProp(IPropEnum.TitleFlag.tf_Title1);
        if (titleProps2 != null && (object3 = this.getTitle1Str(titleProps2)) != null && ((String)object3).length() > 0) {
            object2 = ((String)object3).trim();
            int n = ((String)object2).indexOf("\"");
            if (n > -1) {
                stringBuffer.append("  GUIDE: text.title(label(\"");
                object = null;
                int n2 = 0;
                while (((String)object2).length() > 65) {
                    int n3 = ((String)object2).lastIndexOf(32, 65);
                    object = ((String)object2).substring(0, n3);
                    if (n2 > 0) {
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append(((String)object).replace("\n", "\\n").replace("\"", "\\\"")).append("\",\n");
                    object2 = ((String)object2).substring(n3);
                    ++n2;
                }
                stringBuffer.append("\"");
                stringBuffer.append(((String)object2).replace("\n", "\\n").replace("\"", "\\\"")).append("\"))\n");
            } else {
                stringBuffer.append("  GUIDE: text.title(label(\"").append(((String)object2).replace("\n", "\\n").replace("\"", "\\\"")).append("\"))\n");
            }
        }
        if ((object3 = this.getTitleProp(IPropEnum.TitleFlag.tf_Title2)) != null && ((Props.TitleProps)object3).getStrTitle().length() > 0) {
            stringBuffer.append("  GUIDE: text.subtitle(label(\"").append(((Props.TitleProps)object3).getStrTitle().replace("\n", "\\n").replace("\"", "\\\"")).append("\"))\n");
        }
        if ((object2 = this.getTitleProp(IPropEnum.TitleFlag.tf_Subtitle)) != null && ((Props.TitleProps)object2).getStrTitle().length() > 0) {
            stringBuffer.append("  GUIDE: text.subsubtitle(label(\"").append(((Props.TitleProps)object2).getStrTitle().replace("\n", "\\n").replace("\"", "\\\"")).append("\"))\n");
        }
        if ((titleProps = this.getTitleProp(IPropEnum.TitleFlag.tf_Footnote1)) != null && (object = this.getFootnoteStr(titleProps)) != null && ((String)object).length() > 0) {
            stringBuffer.append("  GUIDE: text.footnote(label(\"").append(((String)object).replace("\n", "\\n").replace("\"", "\\\"")).append("\"))\n");
        }
        if ((object = this.getTitleProp(IPropEnum.TitleFlag.tf_Footnote2)) != null && (string = this.getFootnoteStr((Props.TitleProps)object)) != null && string.length() > 0) {
            stringBuffer.append("  GUIDE: text.subfootnote(label(\"").append(string.replace("\n", "\\n").replace("\"", "\\\"")).append("\"))\n");
        }
    }

    private String getTitle1Str(Props.TitleProps titleProps) {
        String string = titleProps.getStrTitle();
        String string2 = this.mCanvas.getImager().getChartAppearanceOption().getTemplateTitle(this.mCanvas.titleFlagToTitleType(titleProps.getTitleType()));
        int n = titleProps.getUseIndex();
        if (string.length() > 0) {
            return string;
        }
        if (string2 != null && string2.length() > 0) {
            string = string2;
        } else if ((n < 0 || n == 0) && (titleProps.getFlags() & 0x8002) != 0) {
            string = this.mCanvas.composeDefaultTitle();
        }
        return string;
    }

    private String getFootnoteStr(Props.TitleProps titleProps) {
        String string = titleProps.getStrTitle();
        String string2 = this.mCanvas.getImager().getChartAppearanceOption().getTemplateTitle(this.mCanvas.titleFlagToTitleType(titleProps.getTitleType()));
        int n = titleProps.getUseIndex();
        if (string.length() > 0) {
            return string;
        }
        if (string2 != null && string2.length() > 0) {
            string = string2;
        } else if ((n < 0 || n == 0) && (titleProps.getFlags() & 0x8002) != 0) {
            string = this.mCanvas.composeDefaultFootnote();
        }
        return string;
    }

    private void setupGPLScaleStatements(StringBuffer stringBuffer) {
        ZoneType[] zoneTypeArray;
        ZoneType[] zoneTypeArray2;
        boolean bl = this.mCanvas.getImager().isPopulationPyramid();
        boolean bl2 = this.mCanvas.getImager().isHiLoClose();
        boolean bl3 = this.mCanvas.getImager().isDifferenceArea();
        boolean bl4 = this.mCanvas.getImager().isHistogram();
        boolean bl5 = bl || bl2 || bl3 || bl4;
        boolean bl6 = this.mCanvas.getImager().hasHorzPanels();
        boolean bl7 = this.mCanvas.getImager().hasVertPanels();
        Coords coords = this.mProperties.getCoords();
        if (coords == Coords.coords_Polar) {
            stringBuffer.append("  SCALE: linear(dim(1), dataMinimum(), dataMaximum())\n");
        } else {
            zoneTypeArray = zoneTypeArray2 = new ZoneType[]{ZoneType.zt_dist_var, ZoneType.zt_x, ZoneType.zt_y, ZoneType.zt_y2, ZoneType.zt_z};
            int n = zoneTypeArray.length;
            for (int i = 0; i < n; ++i) {
                ZoneType zoneType = zoneTypeArray[i];
                SyntaxVariable syntaxVariable = this.getSyntaxVar(zoneType);
                if (syntaxVariable != null) {
                    if (syntaxVariable.isCategorical()) {
                        this.setupCategoricalAxisScaleStatement(stringBuffer, (Props.CatAxisProps)this.getAxisProp(zoneType), !syntaxVariable.getVariable().getFormat().getFormatType().isStringFormat());
                        continue;
                    }
                    this.setupScaleAxisScaleStatement(stringBuffer, (Props.ScaleAxisProps)this.getAxisProp(zoneType));
                    continue;
                }
                if (!bl5 || zoneType != ZoneType.zt_y) continue;
                this.setupScaleAxisScaleStatement(stringBuffer, (Props.ScaleAxisProps)this.getAxisProp(zoneType));
            }
        }
        if (bl6) {
            this.setupCategoricalAxisScaleStatement(stringBuffer, this.getPanelProp(ZoneType.zt_panel_horz));
        }
        if (bl7) {
            this.setupCategoricalAxisScaleStatement(stringBuffer, this.getPanelProp(ZoneType.zt_panel_vert));
        }
        if (bl) {
            this.setupCategoricalAxisScaleStatement(stringBuffer, (Props.CatAxisProps)this.getAxisProp(ZoneType.zt_split_var));
        } else {
            zoneTypeArray2 = this.getLegendProp(0);
            if (zoneTypeArray2 != null) {
                this.setupCategoricalAxisScaleStatement(stringBuffer, (Props.CatAxisProps)zoneTypeArray2);
            }
            if ((zoneTypeArray = this.getLegendProp(1)) != null) {
                this.setupCategoricalAxisScaleStatement(stringBuffer, (Props.CatAxisProps)zoneTypeArray);
            }
        }
    }

    private void setupCategoricalAxisScaleStatement(StringBuffer stringBuffer, Props.CatAxisProps catAxisProps) {
        this.setupCategoricalAxisScaleStatement(stringBuffer, catAxisProps, true);
    }

    /*
     * WARNING - void declaration
     */
    private void setupCategoricalAxisScaleStatement(StringBuffer stringBuffer, Props.CatAxisProps catAxisProps, boolean bl) {
        IPropEnum.CatSortType catSortType;
        int n;
        int n2;
        String string;
        ScaleBag scaleBag = this.scaleDimNumber(catAxisProps);
        int n3 = scaleBag.mDimNo;
        boolean bl2 = scaleBag.mHas2ndScale;
        boolean bl3 = catAxisProps.getZoneType() == ZoneType.zt_split_var;
        String string2 = "";
        String string3 = "";
        if (bl3 || !(catAxisProps instanceof Props.LegendProps)) {
            string = String.format("cat(dim(%d)", n3);
        } else {
            String string4 = this.getAestheticString((Props.LegendProps)catAxisProps, true);
            string = String.format("cat(aesthetic(%s)", string4);
            if (bl2) {
                string3 = String.format("cat(dim(%d)", n3);
            }
        }
        boolean bl4 = false;
        Vector<RelabelBag> vector = catAxisProps.getCategories();
        for (RelabelBag object2 : vector) {
            if (!this.mOptions.getIncludeBreakVars() && object2.getUserMissing() || object2.getStrOrgValue().length() <= 0 || object2.getExcluded()) continue;
            bl4 = true;
            break;
        }
        boolean bl5 = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string4 = "";
        if (bl4) {
            boolean bl6;
            boolean bl7 = bl6 = (catAxisProps.getFlags() & 0x40) != 0;
            if (this.mCanvas.getImager().isTransposed()) {
                string2 = string2 + ", reverse()";
            }
            if (bl6) {
                if (bl2) {
                    string3 = string3 + ", ";
                    string3 = string3 + "include(";
                }
                string2 = string2 + ", include(";
            }
            for (RelabelBag relabelBag : vector) {
                void var14_22;
                if (!this.mOptions.getIncludeBreakVars() && relabelBag.getUserMissing() || relabelBag.getStrOrgValue().length() == 0 || relabelBag.getExcluded()) continue;
                n2 = stringBuffer2.length() == 0 ? 60 : 85;
                n = relabelBag.getStrOrgValue().length();
                if (n > 40 || string4.length() + n > n2) {
                    string4 = string4 + "\n";
                    stringBuffer2.append(string4);
                    string4 = "";
                }
                if (bl5) {
                    string4 = string4 + ", ";
                }
                String string5 = relabelBag.getStrOrgValue();
                if (bl) {
                    String string6 = string5.replace(",", ".");
                }
                if (this.mCanvas.getZoneMgr().getIndexVarZoneType() == catAxisProps.getZoneType()) {
                    void var14_20;
                    int n4 = Integer.valueOf((String)var14_20);
                    String string7 = Integer.toString(n4 - 1);
                }
                string4 = string4 + "\"" + this.escapeString((String)var14_22) + "\"";
                bl5 = true;
            }
            stringBuffer2.append(string4);
            if (bl6) {
                string2 = string2 + stringBuffer2.toString() + ")";
                if (bl2) {
                    string3 = string3 + stringBuffer2.toString() + ")";
                }
            }
        }
        if ((catSortType = catAxisProps.getSortType()) == IPropEnum.CatSortType.cst_Custom) {
            string2 = string2 + ", ";
            string2 = string2 + "sort.values(";
            string2 = string2 + stringBuffer2.toString();
            string2 = string2 + ")";
            if (bl2) {
                string3 = string3 + ", ";
                string3 = string3 + "sort.values(";
                string3 = string3 + stringBuffer2.toString();
                string3 = string3 + ")";
            }
        } else {
            boolean bl8;
            boolean bl9 = bl8 = catSortType == IPropEnum.CatSortType.cst_Label;
            if (bl8) {
                string2 = string2 + ", ";
                string2 = string2 + "sort.natural()";
                if (bl2) {
                    string3 = string3 + ", ";
                    string3 = string3 + "sort.natural()";
                }
            }
            if (catAxisProps.getSortOrder() == IPropEnum.CatSortOrder.cso_Descending) {
                string2 = string2 + ", ";
                string2 = string2 + "reverse()";
                if (bl2) {
                    string3 = string3 + ", ";
                    string3 = string3 + "reverse()";
                }
            }
        }
        if (!bl3 && catAxisProps instanceof Props.LegendProps && !this.mOptions.getExcludeListwise()) {
            boolean bl10 = this.mCanvas.getZoneMgr().getZone(catAxisProps.getZoneType()).getUsesColorStyling();
            Props.ElProps elProps = this.mProperties.getElementProp(0);
            n2 = elProps instanceof Props.LineProps;
            n = elProps instanceof Props.PointProps || elProps instanceof Props.MatrixProps ? 1 : 0;
            String string8 = "color.black";
            if (!bl10) {
                string8 = n2 != 0 ? "shape.dash_dash2x" : (n != 0 ? "shape.cross" : "texture.pattern.mesh5");
            }
            string2 = string2 + String.format(", aestheticMissing(%s)", string8);
        }
        if (string2.length() > 0) {
            string2 = string2 + ")";
            if (bl2) {
                string3 = string3 + ")";
            }
            stringBuffer.append("  SCALE: ").append(string).append(string2).append("\n");
            if (bl2) {
                stringBuffer.append("  SCALE: ").append(string3).append("\n");
            }
        }
    }

    private ScaleBag scaleDimNumber(Props.AxisProps axisProps) {
        int n = 1;
        boolean bl = this.mCanvas.getImager().hasXCluster();
        boolean bl2 = this.mCanvas.getImager().hasZCluster();
        boolean bl3 = false;
        ZoneType zoneType = axisProps.getZoneType();
        Coords coords = this.mProperties.getCoords();
        if (zoneType == ZoneType.zt_x) {
            n = coords == Coords.coords_3D ? 2 : 1;
        } else if (zoneType == ZoneType.zt_y || zoneType == ZoneType.zt_y2) {
            n = coords == Coords.coords_3D ? 3 : 2;
        } else if (zoneType == ZoneType.zt_z) {
            n = 1;
        }
        if (zoneType == ZoneType.zt_panel_horz) {
            if (coords == Coords.coords_3D) {
                n = bl && bl2 ? 6 : (bl || bl2 ? 5 : 4);
            } else if (coords == Coords.coords_2D || coords == Coords.coords_DualY) {
                n = bl ? 4 : 3;
            } else if (coords == Coords.coords_1D || coords == Coords.coords_Polar) {
                n = 2;
            }
        } else if (zoneType == ZoneType.zt_panel_vert) {
            if (coords == Coords.coords_3D) {
                n = bl && bl2 ? 7 : (bl || bl2 ? 6 : 5);
            } else if (coords == Coords.coords_2D || coords == Coords.coords_DualY) {
                n = bl ? 5 : 4;
            } else if (coords == Coords.coords_1D || coords == Coords.coords_Polar) {
                n = 3;
            }
        } else if (bl || bl2) {
            if (bl && zoneType == ZoneType.zt_x) {
                n = bl2 ? (coords == Coords.coords_3D ? 5 : 3) : (coords == Coords.coords_3D ? 4 : 3);
            } else if (bl && axisProps instanceof Props.LegendProps) {
                int n2 = this.legendInstance((Props.LegendProps)axisProps);
                bl3 = true;
                int n3 = n = coords == Coords.coords_3D ? 2 : 1;
                if (bl2 && n2 == 1) {
                    n = 1;
                }
                if (!bl2 && n2 == 1) {
                    bl3 = false;
                }
            } else if (bl2 && zoneType == ZoneType.zt_z) {
                n = 4;
            } else if (bl2 && axisProps instanceof Props.LegendProps) {
                n = 1;
                bl3 = true;
            }
        } else if (this.mCanvas.getImager().isPopulationPyramid()) {
            n = zoneType == ZoneType.zt_split_var ? 3 : (zoneType == ZoneType.zt_y ? 2 : 1);
        }
        ScaleBag scaleBag = new ScaleBag();
        scaleBag.mDimNo = n;
        scaleBag.mHas2ndScale = bl3;
        return scaleBag;
    }

    private int legendInstance(Props.LegendProps legendProps) {
        int n = 0;
        for (Props props : this.mProperties.getProperties()) {
            if (!(props instanceof Props.LegendProps)) continue;
            if (legendProps == props) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private void setupScaleAxisScaleStatement(StringBuffer stringBuffer, Props.ScaleAxisProps scaleAxisProps) {
        ZoneType zoneType = scaleAxisProps.getZoneType();
        int n = scaleAxisProps.getFlags();
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 8) != 0;
        boolean bl4 = this.mCanvas.getZoneMgr().hasCatVar(ZoneType.zt_x);
        boolean bl5 = this.mProperties.getCoords() == Coords.coords_DualY;
        boolean bl6 = bl5 && (zoneType == ZoneType.zt_y || zoneType == ZoneType.zt_y2);
        IPropEnum.ScaleType scaleType = scaleAxisProps.getScaleType();
        if (bl4 || !bl || !bl2 || !bl3 || scaleType != IPropEnum.ScaleType.st_Linear || bl6) {
            String string;
            String string2 = "";
            if (bl6) {
                int n2 = zoneType == ZoneType.zt_y ? 1 : 2;
                string2 = string2 + String.format("y%d = ", n2);
            }
            ScaleBag scaleBag = this.scaleDimNumber(scaleAxisProps);
            int n3 = scaleBag.mDimNo;
            Props.ElProps elProps = this.mProperties.getElementProp(0);
            boolean bl7 = elProps instanceof Props.LineProps;
            boolean bl8 = elProps instanceof Props.BarProps;
            boolean bl9 = elProps instanceof Props.AreaProps;
            boolean bl10 = bl5 && !bl7 && !bl8 && !bl9;
            String string3 = scaleAxisProps.getStrBase();
            String string4 = scaleAxisProps.getStrExponent();
            string3 = string3.replace(',', '.');
            string4 = string4.replace(',', '.');
            string2 = scaleType == IPropEnum.ScaleType.st_Log ? string2 + String.format("log(dim(%d), base(%s)", n3, string3) : (scaleType == IPropEnum.ScaleType.st_SafeLog ? string2 + String.format("safeLog(dim(%d), base(%s)", n3, string3) : (scaleType == IPropEnum.ScaleType.st_Power ? string2 + String.format("pow(dim(%d), exponent(%s)", n3, string4) : string2 + String.format("linear(dim(%d)", n3)));
            if (!bl) {
                string = scaleAxisProps.getStrMinimum();
                string = string.replace(',', '.');
                string2 = string2 + ", min(" + string + ")";
            } else if (bl4 && scaleType == IPropEnum.ScaleType.st_Linear && !bl10) {
                string2 = string2 + ", include(0)";
            }
            if (!bl2) {
                string = scaleAxisProps.getStrMaximum();
                string = string.replace(',', '.');
                string2 = string2 + ", max(" + string + ")";
            }
            if (!bl3) {
                string = scaleAxisProps.getStrOrigin();
                string = string.replace(',', '.');
                string2 = string2 + ", origin(" + string + ")";
            }
            if ((string2 = string2 + ")").length() > 0) {
                stringBuffer.append("  SCALE: ").append(string2).append("\n");
            }
        }
    }

    private void setupGPLTransStatements(StringBuffer stringBuffer) {
        if (this.mCanvas.getImager().isSplom()) {
            Props.MatrixProps matrixProps = (Props.MatrixProps)this.mProperties.getElementProp(0);
            for (ISpssVariable iSpssVariable : matrixProps.getMatrixVarList()) {
                SyntaxVariable syntaxVariable = this.getSyntaxVar(iSpssVariable.getName());
                if (syntaxVariable == null) continue;
                String string = syntaxVariable.getGGraphName();
                String object = iSpssVariable.getLabel();
                object = object != null && object.length() > 0 ? object : iSpssVariable.getName();
                stringBuffer.append("  TRANS: ").append(string).append("_label");
                stringBuffer.append(" = eval(\"").append(object).append("\")\n");
            }
        }
        for (Map.Entry<String, TransBag> entry : this.mTransBags.entrySet()) {
            stringBuffer.append(entry.getValue().mTransString);
        }
    }

    private void setupGPLElementStatements(StringBuffer stringBuffer, Props.ElProps elProps, int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object object;
        boolean bl4 = elProps instanceof Props.PointProps;
        boolean bl5 = this.mCanvas.getImager().isHiLoClose();
        boolean bl6 = this.mCanvas.getImager().isDifferenceArea();
        boolean bl7 = this.mCanvas.getImager().isPopulationPyramid();
        Coords coords = this.mProperties.getCoords();
        if (this.mCanvas.getImager().isHistogram()) {
            this.addHistogramElementSyntax(stringBuffer, elProps);
            return;
        }
        if (this.mProperties.getIsOverlayScatter()) {
            this.addOverlayScatterSyntax(stringBuffer, elProps);
            return;
        }
        String string = this.getPointLabelSyntax();
        String string2 = this.getAestheticString(this.getLegendProp(0), false);
        String string3 = this.getAestheticString(this.getLegendProp(1), false);
        if (bl5 && elProps instanceof Props.HiLoCloseProps) {
            this.makeHiLoIntervalSyntax(stringBuffer, (Props.HiLoCloseProps)elProps, string2);
            object = this.getSyntaxVar(ZoneType.zt_close);
            if (object == null || ((SyntaxVariable)object).getSyntaxName().length() == 0) {
                return;
            }
        }
        object = this.nodeNameForProperty(elProps);
        String string4 = "  ELEMENT: " + (String)object;
        boolean bl8 = this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_group);
        boolean bl9 = bl8 && (elProps instanceof Props.BarProps || elProps instanceof Props.AreaProps);
        if (bl9 |= coords == Coords.coords_Polar) {
            string4 = string4 + ".stack";
        }
        String string5 = "";
        Props.PointProps pointProps = bl4 ? (Props.PointProps)elProps : null;
        boolean bl10 = coords == Coords.coords_DualY;
        boolean bl11 = coords == Coords.coords_1D && bl4;
        boolean bl12 = bl3 = (coords == Coords.coords_2D || bl10) && bl4 && pointProps.getStackIdentical();
        if (bl11) {
            if (pointProps.getPlotShape() == IPropEnum.PlotShape.ps_Asymmetric) {
                string4 = string4 + ".dodge.asymmetric";
            } else if (pointProps.getPlotShape() == IPropEnum.PlotShape.ps_Symmetric) {
                string4 = string4 + ".dodge";
            }
        } else if (bl3) {
            string4 = string4 + ".dodge.symmetric";
        }
        string4 = string4 + "(position(";
        boolean bl13 = (elProps.getFlags() & 0x10) != 0 && elProps.getStatistic().getStat() == Statistics.PctOfCases;
        SmootherBag smootherBag = new SmootherBag();
        String string6 = "";
        boolean bl14 = bl7 && this.mCanvas.getZoneMgr().hasScaleVar(ZoneType.zt_dist_var);
        boolean bl15 = bl2 = elProps instanceof Props.LineProps || elProps instanceof Props.AreaProps || bl6;
        if (bl2) {
            string6 = this.getSmootherStats(elProps, smootherBag);
        } else if (bl14) {
            string6 = "summary.count(";
            smootherBag.mInterpolateMissing = false;
            smootherBag.mJump = false;
            smootherBag.mSmootherClose = ")";
        }
        string4 = string4 + string6;
        PositionBag positionBag = new PositionBag();
        string4 = string4 + this.getGPLPositionStat(elProps, positionBag);
        stringBuffer.append(string4);
        String string7 = this.getPctBaseString(n);
        boolean bl16 = elProps instanceof Props.SchemaProps;
        if (coords == Coords.coords_1D) {
            SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_x);
            if (bl11) {
                string5 = syntaxVariable.getSyntaxName() + this.getPanelElementExpression();
                if (bl8) {
                    Props.LegendProps legendProps = this.getLegendProp(0);
                    SyntaxVariable syntaxVariable2 = this.getSyntaxVar(legendProps.getZoneType());
                    String string8 = string2 + "(" + syntaxVariable2.getSyntaxName() + ")";
                    stringBuffer.append("bin.dot(").append(syntaxVariable.getSyntaxName());
                    stringBuffer.append(this.getPanelElementExpression()).append(")");
                    stringBuffer.append(string7).append(positionBag.mPositionClose).append(smootherBag.mSmootherClose);
                    stringBuffer.append("), ").append(string8);
                } else {
                    stringBuffer.append("bin.dot(").append(syntaxVariable.getSyntaxName());
                    stringBuffer.append(this.getPanelElementExpression()).append(")");
                    stringBuffer.append(string7).append(positionBag.mPositionClose).append(smootherBag.mSmootherClose);
                    stringBuffer.append(")");
                }
            } else if (bl16) {
                stringBuffer.append("bin.quantile.letter(");
                stringBuffer.append(this.getTransVarName(syntaxVariable.getSyntaxName())).append(this.getPanelElementExpression());
                stringBuffer.append(string7).append(positionBag.mPositionClose).append(smootherBag.mSmootherClose);
                stringBuffer.append("))");
                SyntaxVariable syntaxVariable3 = this.getSyntaxVar(ZoneType.zt_point_id);
                if (syntaxVariable3 != null) {
                    stringBuffer.append(", label(").append(syntaxVariable3.getSyntaxName()).append(")");
                } else {
                    stringBuffer.append(", label(id)");
                }
            }
        } else if (coords == Coords.coords_2D || coords == Coords.coords_DualY) {
            if (this.mCanvas.getImager().isSplom() && elProps instanceof Props.MatrixProps) {
                this.generateSplomElementSyntax(stringBuffer, (Props.MatrixProps)elProps);
            } else if (elProps instanceof Props.SchemaProps) {
                this.generateSchemaElementSyntax(stringBuffer);
            } else {
                Object object2;
                Object object3;
                Object object4;
                String string9 = this.getPanelElementExpression();
                SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_x);
                SyntaxVariable syntaxVariable4 = this.getSyntaxVar(ZoneType.zt_y);
                SyntaxVariable syntaxVariable5 = this.getSyntaxVar(ZoneType.zt_y2);
                SyntaxVariable syntaxVariable6 = this.getSyntaxVar(ZoneType.zt_close);
                SyntaxVariable syntaxVariable7 = this.getSyntaxVar(ZoneType.zt_cluster_x);
                boolean bl17 = this.mCanvas.getImager().hasXCluster();
                String string10 = this.getPctBaseString(n);
                int n2 = 0;
                if (this.mProperties.getCoords() == Coords.coords_DualY) {
                    int n3 = n2 = this.mCanvas.getImager().dualYElementWithFirstYAxis(elProps.getStrElId()) ? 0 : 1;
                }
                if (bl17) {
                    if (bl5) {
                        string5 = String.format("%s*%s*%s", this.getTransVarName(syntaxVariable7.getSyntaxName()), syntaxVariable6.getSyntaxName(), this.getTransVarName(syntaxVariable.getSyntaxName()));
                        string5 = string5 + string9;
                        stringBuffer.append(string5).append(string10).append(positionBag.mPositionClose);
                        stringBuffer.append(smootherBag.mSmootherClose).append(")");
                    } else {
                        string5 = String.format("%s*%s*%s", this.getTransVarName(syntaxVariable7.getSyntaxName()), this.getTransVarName(syntaxVariable4.getSyntaxName()), this.getTransVarName(syntaxVariable.getSyntaxName()));
                        if (bl13) {
                            string5 = string5.replace(this.getTransVarName(syntaxVariable4.getSyntaxName()), "1");
                        }
                        string5 = string5 + string9;
                        String string11 = string2 + "(" + this.getTransVarName(syntaxVariable7.getSyntaxName()) + ")";
                        stringBuffer.append(string5).append(string10).append(positionBag.mPositionClose);
                        stringBuffer.append(smootherBag.mSmootherClose).append("), ").append(string11);
                    }
                } else if (bl8) {
                    syntaxVariable7 = this.getSyntaxVar(ZoneType.zt_group);
                    string5 = String.format("%s*%s", this.getTransVarName(syntaxVariable.getSyntaxName()), this.getTransVarName(syntaxVariable4.getSyntaxName()));
                    if (bl13) {
                        string5 = string5.replace(this.getTransVarName(syntaxVariable4.getSyntaxName()), "1");
                    }
                    string5 = string5 + string9;
                    String string12 = string2 + "(" + this.getTransVarName(syntaxVariable7.getSyntaxName()) + ")";
                    stringBuffer.append(string5).append(string10).append(positionBag.mPositionClose);
                    stringBuffer.append(smootherBag.mSmootherClose).append("), ").append(string12);
                } else {
                    if (bl5) {
                        string5 = String.format("%s*%s", this.getTransVarName(syntaxVariable.getSyntaxName()), syntaxVariable6.getSyntaxName());
                    } else if (bl6) {
                        string5 = String.format("%s*%s", this.getTransVarName(syntaxVariable.getSyntaxName()), "values");
                    } else if (bl7) {
                        SyntaxVariable syntaxVariable8;
                        object4 = (Props.PyramidProps)elProps;
                        object3 = this.getSyntaxVar(ZoneType.zt_dist_var);
                        object2 = this.getSyntaxVar(ZoneType.zt_split_var);
                        string5 = String.format("%s*%s*%s", this.getTransVarName(object3.getSyntaxName()), object3.isCategorical() ? syntaxVariable4.getSyntaxName() : "1", this.getTransVarName(((SyntaxVariable)object2).getSyntaxName()));
                        if (this.mCanvas.getImager().hasVertPanels() && (syntaxVariable8 = this.getSyntaxVar(ZoneType.zt_panel_vert)) != null) {
                            string5 = string5 + "*" + this.getTransVarName(syntaxVariable8.getSyntaxName());
                        }
                        if (!object3.isCategorical()) {
                            if (elProps.getStatistic().getAnchorType() != 0) {
                                string5 = string5 + String.format(", binStart(%s)", this.makeBinStart(elProps.getStatistic().getVariable(), ((Props.PyramidProps)object4).getAnchorCustVal()));
                            }
                            if (elProps.getStatistic().getBinSize() != 0) {
                                string5 = elProps.getStatistic().getBinSizeCustom() == 0 ? string5 + String.format(", binCount(%s)", ((Props.PyramidProps)object4).getNoOfIntervals()) : string5 + String.format(", binWidth(%s)", ((Props.PyramidProps)object4).getIntervalWidth());
                            }
                        }
                    } else {
                        string5 = bl10 && n2 == 1 ? String.format("%s*%s", this.getTransVarName(syntaxVariable.getSyntaxName()), syntaxVariable5.getSyntaxName()) : String.format("%s*%s", this.getTransVarName(syntaxVariable.getSyntaxName()), this.getTransVarName(syntaxVariable4.getSyntaxName()));
                    }
                    if (bl13) {
                        string5 = bl10 && n2 == 1 ? string5.replace(syntaxVariable5.getSyntaxName(), "1") : string5.replace(this.getTransVarName(syntaxVariable4.getSyntaxName()), "1");
                    }
                    if (!bl7) {
                        string5 = string5 + string9;
                    }
                    stringBuffer.append(string5).append(string10).append(positionBag.mPositionClose);
                    stringBuffer.append(smootherBag.mSmootherClose).append(")");
                }
                if (bl6) {
                    if (this.mCanvas.getImager().getUsesColorByDefault()) {
                        stringBuffer.append(", color.interior(category)");
                    } else {
                        stringBuffer.append(", texture.pattern.interior(category)");
                    }
                }
                if (elProps instanceof Props.BarProps) {
                    object4 = (Props.BarProps)elProps;
                    object3 = ((Props.BarProps)object4).getIntervalStyle();
                    object2 = "square";
                    if (object3 == IPropEnum.IntervalStyle.is_IBeam) {
                        object2 = "ibeam";
                    } else if (object3 == IPropEnum.IntervalStyle.is_Line) {
                        object2 = "line";
                    }
                    stringBuffer.append(", shape.interior(shape.").append((String)object2).append(")");
                }
                if (bl2) {
                    if (smootherBag.mInterpolateMissing) {
                        stringBuffer.append(", missing.interpolate()");
                    } else if (bl9) {
                        stringBuffer.append(", missing.gap()");
                    } else {
                        stringBuffer.append(", missing.wings()");
                    }
                    if (smootherBag.mJump) {
                        stringBuffer.append(", jump()");
                    }
                }
                if (bl7) {
                    object4 = this.getSyntaxVar(ZoneType.zt_split_var);
                    if (this.mCanvas.getImager().getUsesColorByDefault()) {
                        stringBuffer.append(", color.interior(").append(this.getTransVarName(((SyntaxVariable)object4).getSyntaxName())).append(")");
                    } else {
                        stringBuffer.append(", texture.pattern.interior(").append(this.getTransVarName(((SyntaxVariable)object4).getSyntaxName())).append(")");
                    }
                }
                if (bl10) {
                    object4 = "color.interior";
                    stringBuffer.append(String.format(", %s(color.\"%s\"), scale(y%d)", object4, this.mCanvas.getImager().getDualYAxisColor(n2), n2 + 1));
                }
            }
        } else if (coords == Coords.coords_3D) {
            Object object5;
            boolean bl18 = this.mCanvas.getImager().hasXCluster();
            boolean bl19 = this.mCanvas.getImager().hasZCluster();
            SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_x);
            SyntaxVariable syntaxVariable9 = this.getSyntaxVar(ZoneType.zt_y);
            SyntaxVariable syntaxVariable10 = this.getSyntaxVar(ZoneType.zt_z);
            SyntaxVariable syntaxVariable11 = this.getSyntaxVar(ZoneType.zt_cluster_x);
            SyntaxVariable syntaxVariable12 = this.getSyntaxVar(ZoneType.zt_cluster_z);
            String string13 = this.getPanelElementExpression();
            string5 = bl18 && bl19 ? String.format("%s*%s*%s*%s*%s%s", this.getTransVarName(syntaxVariable12.getSyntaxName()), this.getTransVarName(syntaxVariable11.getSyntaxName()), bl13 ? "1" : this.getTransVarName(syntaxVariable9.getSyntaxName()), this.getTransVarName(syntaxVariable10.getSyntaxName()), this.getTransVarName(syntaxVariable.getSyntaxName()), string13) : (bl18 ? String.format("%s*%s*%s*%s%s", this.getTransVarName(syntaxVariable10.getSyntaxName()), this.getTransVarName(syntaxVariable11.getSyntaxName()), bl13 ? "1" : this.getTransVarName(syntaxVariable9.getSyntaxName()), this.getTransVarName(syntaxVariable.getSyntaxName()), string13) : (bl19 ? String.format("%s*%s*%s*%s%s", this.getTransVarName(syntaxVariable12.getSyntaxName()), this.getTransVarName(syntaxVariable.getSyntaxName()), bl13 ? "1" : this.getTransVarName(syntaxVariable9.getSyntaxName()), this.getTransVarName(syntaxVariable10.getSyntaxName()), string13) : String.format("%s*%s*%s%s", this.getTransVarName(syntaxVariable10.getSyntaxName()), this.getTransVarName(syntaxVariable.getSyntaxName()), bl13 ? "1" : this.getTransVarName(syntaxVariable9.getSyntaxName()), string13)));
            stringBuffer.append(string5);
            stringBuffer.append(string7).append(positionBag.mPositionClose).append(smootherBag.mSmootherClose).append(")");
            if (bl8 || bl18 || bl19) {
                object5 = syntaxVariable11;
                if (object5 == null) {
                    object5 = syntaxVariable12;
                }
                if (object5 == null) {
                    object5 = this.getSyntaxVar(ZoneType.zt_group);
                }
                if (object5 != null && string2.length() > 0) {
                    stringBuffer.append(", ").append(string2).append("(");
                    stringBuffer.append(this.getTransVarName(((SyntaxVariable)object5).getSyntaxName())).append(")");
                }
                if (syntaxVariable11 != null) {
                    object5 = syntaxVariable12;
                }
                if (object5 == null) {
                    object5 = this.getSyntaxVar(ZoneType.zt_group);
                }
                if (object5 != null && string3.length() > 0) {
                    stringBuffer.append(", ").append(string3).append("(");
                    stringBuffer.append(this.getTransVarName(((SyntaxVariable)object5).getSyntaxName())).append(")");
                }
            }
            if (string.length() > 0 && !(elProps instanceof Props.PointProps)) {
                stringBuffer.append(string);
            }
            if (elProps instanceof Props.BarProps) {
                object5 = (Props.BarProps)elProps;
                String string14 = "square";
                if (((Props.BarProps)object5).getIntervalStyle() == IPropEnum.IntervalStyle.is_IBeam) {
                    string14 = "ibeam";
                } else if (((Props.BarProps)object5).getIntervalStyle() == IPropEnum.IntervalStyle.is_Line) {
                    string14 = "line";
                }
                stringBuffer.append(", shape.interior(shape.").append(string14).append(")");
            }
            if (smootherBag.mInterpolateMissing) {
                stringBuffer.append(", missing.interpolate()");
            } else if (bl2) {
                stringBuffer.append(", missing.wings()");
            }
        } else if (coords == Coords.coords_Polar) {
            SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_angle);
            SyntaxVariable syntaxVariable13 = this.getSyntaxVar(ZoneType.zt_slice_by);
            stringBuffer.append("summary.percent(").append(syntaxVariable.getSyntaxName());
            stringBuffer.append(this.getPanelElementExpression()).append(string7).append("))), ");
            stringBuffer.append(string2).append("(").append(this.getTransVarName(syntaxVariable13.getSyntaxName())).append(")");
        }
        if (bl5) {
            Props.HiLoCloseProps hiLoCloseProps = (Props.HiLoCloseProps)elProps;
            stringBuffer.append(String.format(", shape(shape.%s)", this.getSymbolShape(hiLoCloseProps.getSymbolType())));
        }
        if (string.length() > 0 && elProps instanceof Props.PointProps) {
            stringBuffer.append(string);
        }
        stringBuffer.append(")\n");
        if ((elProps.getFlags() & 0x10) != 0) {
            stringBuffer.append(this.getErrorBarElementSyntax(elProps, string5));
        }
        if (elProps instanceof Props.PyramidProps && this.mCanvas.getZoneMgr().hasScaleVar(ZoneType.zt_dist_var) && elProps.getStatistic().getDisplayNormalCurve()) {
            stringBuffer.append(this.getPyramidNormalCurveSyntax());
        }
        boolean bl20 = bl = (coords == Coords.coords_2D || coords == Coords.coords_3D) && pointProps != null && pointProps.getHasDropLine();
        if (bl) {
            stringBuffer.append(this.getDropLineSyntax());
        }
    }

    private String getTransVarName(String string) {
        String string2 = this.mTransBags.containsKey(string) ? this.mTransBags.get((Object)string).mSyntaxName : string;
        return string2;
    }

    private void generateSchemaElementSyntax(StringBuffer stringBuffer) {
        Object object;
        SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_x);
        SyntaxVariable syntaxVariable2 = this.getSyntaxVar(ZoneType.zt_y);
        stringBuffer.append("bin.quantile.letter(");
        String string = syntaxVariable == null || syntaxVariable.getSyntaxName().length() == 0 ? "1" : this.getTransVarName(syntaxVariable.getSyntaxName());
        String string2 = this.getPanelElementExpression();
        String string3 = this.getPctBaseString(0);
        boolean bl = this.mCanvas.getImager().hasXCluster();
        if (bl) {
            object = this.getAestheticString(this.getLegendProp(0), false);
            SyntaxVariable syntaxVariable3 = this.getSyntaxVar(ZoneType.zt_cluster_x);
            stringBuffer.append(this.getTransVarName(syntaxVariable3.getSyntaxName())).append("*");
            stringBuffer.append(this.getTransVarName(syntaxVariable2.getSyntaxName())).append("*");
            stringBuffer.append(string).append(string2);
            stringBuffer.append(string3);
            stringBuffer.append(")), ").append((String)object).append("(");
            stringBuffer.append(syntaxVariable3.getSyntaxName()).append(")");
        } else {
            stringBuffer.append(string).append("*");
            stringBuffer.append(this.getTransVarName(syntaxVariable2.getSyntaxName())).append(string2);
            stringBuffer.append(string3);
            stringBuffer.append("))");
        }
        object = this.getSyntaxVar(ZoneType.zt_point_id);
        if (object != null && ((SyntaxVariable)object).getSyntaxName().length() > 0) {
            stringBuffer.append(", label(").append(((SyntaxVariable)object).getSyntaxName()).append(")");
        } else {
            stringBuffer.append(", label(id)");
        }
    }

    private String getPointLabelSyntax() {
        String string = "";
        Props.ElProps elProps = this.mProperties.getElementProp(0);
        boolean bl = elProps instanceof Props.PointProps;
        boolean bl2 = elProps instanceof Props.MatrixProps;
        if (this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_point_id)) {
            SyntaxVariable syntaxVariable;
            DropZone dropZone = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_point_id);
            if ((bl || bl2) && !dropZone.isEmpty() && (syntaxVariable = this.getSyntaxVar(ZoneType.zt_point_id)) != null) {
                string = String.format(", label(%s)", syntaxVariable.getSyntaxName());
            }
        }
        return string;
    }

    private void generateSplomElementSyntax(StringBuffer stringBuffer, Props.MatrixProps matrixProps) {
        Object object;
        int n = 0;
        String string = "(";
        Vector<ISpssVariable> vector = matrixProps.getMatrixVarList();
        for (ISpssVariable iSpssVariable : vector) {
            SyntaxVariable syntaxVariable = this.getSyntaxVar(iSpssVariable.getName());
            if (syntaxVariable == null) continue;
            String string2 = syntaxVariable.getGGraphName();
            string = string + string2;
            string = string + "/";
            string = string + string2 + "_label";
            if (++n >= vector.size()) continue;
            string = string + "+";
        }
        string = string + ")";
        String string3 = this.getAestheticString(this.getLegendProp(0), false);
        boolean bl = this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_group);
        if (bl) {
            object = this.getSyntaxVar(ZoneType.zt_group);
            string = string + "*" + string + ")" + "," + (String)string3 + "(" + this.getTransVarName(((SyntaxVariable)object).getSyntaxName()) + ")";
        } else {
            string = string + "*" + string + ")";
        }
        object = this.getPointLabelSyntax();
        if (object != null && ((String)object).length() > 0) {
            string = string + (String)object;
        }
        stringBuffer.append(string);
    }

    private String getDropLineSyntax() {
        SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_x);
        SyntaxVariable syntaxVariable2 = this.getSyntaxVar(ZoneType.zt_y);
        SyntaxVariable syntaxVariable3 = this.getSyntaxVar(ZoneType.zt_z);
        String string = "  ELEMENT: interval(position(region.spread.range(";
        string = this.mProperties.getCoords() == Coords.coords_2D ? string + this.getTransVarName(syntaxVariable.getSyntaxName()) + "*" + this.getTransVarName(syntaxVariable2.getSyntaxName()) : string + this.getTransVarName(syntaxVariable3.getSyntaxName()) + "*" + this.getTransVarName(syntaxVariable.getSyntaxName()) + "*" + this.getTransVarName(syntaxVariable2.getSyntaxName());
        string = string + this.getPanelElementExpression() + ")),shape(shape.line))\n";
        return string;
    }

    private String getRegressionLineSyntax(boolean bl, boolean bl2) {
        String string = "\n  /FITLINE";
        string = string + " TOTAL=" + (bl ? "YES" : "NO");
        if (this.mCanvas.getImager().hasGrouping()) {
            string = string + " SUBGROUP=" + (bl2 ? "YES" : "NO");
        }
        return string;
    }

    private String getColorCycleSyntax(ChartAppearanceOption chartAppearanceOption) {
        StringBuffer stringBuffer = new StringBuffer();
        TreeMap treeMap = (TreeMap)chartAppearanceOption.getChangedColorMap();
        if (treeMap != null && treeMap.size() > 0) {
            stringBuffer.append("\n  /COLORCYCLE");
            boolean bl = false;
            Color[] colorArray = chartAppearanceOption.getCycleColors();
            for (int i = 0; i < colorArray.length; ++i) {
                if (colorArray[i] == null) continue;
                if (bl) {
                    stringBuffer.append(",");
                }
                String string = " COLOR" + (i + 1) + "(" + colorArray[i].getRed() + "," + colorArray[i].getGreen() + "," + colorArray[i].getBlue() + ")";
                stringBuffer.append(string);
                bl = true;
            }
        }
        return stringBuffer.toString();
    }

    private String getFrameSyntax(ChartAppearanceOption chartAppearanceOption) {
        String string = "\n  /FRAME";
        string = string + " OUTER=" + (chartAppearanceOption.isOuterFrameBorder() ? "YES" : "NO");
        string = string + " INNER=" + (chartAppearanceOption.isInnerFrameBorder() ? "YES" : "NO");
        return string;
    }

    private String getGridlineSyntax(ChartAppearanceOption chartAppearanceOption) {
        String string = "\n  /GRIDLINES";
        string = string + " XAXIS=" + (chartAppearanceOption.isGridlineX() ? "YES" : "NO");
        string = string + " YAXIS=" + (chartAppearanceOption.isGridlineY() ? "YES" : "NO");
        return string;
    }

    private String getPyramidNormalCurveSyntax() {
        SyntaxVariable syntaxVariable;
        SyntaxVariable syntaxVariable2 = this.getSyntaxVar(ZoneType.zt_dist_var);
        SyntaxVariable syntaxVariable3 = this.getSyntaxVar(ZoneType.zt_split_var);
        String string = "  ELEMENT: line(position(density.normal(" + syntaxVariable2.getSyntaxName();
        string = string + "*1*" + this.getTransVarName(syntaxVariable3.getSyntaxName());
        if (this.mCanvas.getImager().hasVertPanels() && (syntaxVariable = this.getSyntaxVar(ZoneType.zt_panel_vert)) != null) {
            string = string + "*" + this.getTransVarName(syntaxVariable.getSyntaxName());
        }
        string = string + ")))\n";
        return string;
    }

    private String getErrorBarElementSyntax(Props.ElProps elProps, String string) {
        String string2;
        int n;
        Object object;
        SyntaxVariable syntaxVariable;
        String string3 = "";
        int n2 = elProps == this.mProperties.getElementProp(1) ? 1 : 0;
        Props.LegendProps legendProps = this.getLegendProp(0);
        SyntaxVariable syntaxVariable2 = syntaxVariable = legendProps != null ? this.getSyntaxVar(legendProps.getZoneType()) : null;
        if (syntaxVariable != null && !(elProps instanceof Props.BarProps)) {
            if (elProps instanceof Props.PyramidProps) {
                string3 = ", color(color.black)";
            } else {
                object = this.mCanvas.getZoneMgr().getZone(legendProps.getZoneType());
                n = object != null && !((DropZone)object).getUsesColorStyling() ? 1 : 0;
                string3 = String.format(", %s(%s)", n != 0 ? "shape.exterior" : "color.interior", syntaxVariable.getSyntaxName());
            }
        }
        object = "";
        n = 0;
        if (this.mProperties.getCoords() == Coords.coords_DualY) {
            n = this.mCanvas.getImager().dualYElementWithFirstYAxis(elProps.getStrElId()) ? 0 : 1;
            object = String.format(", color.interior(color.\"%s\"), scale(y%d)", this.mCanvas.getImager().getDualYAxisColor(n), n + 1);
        }
        String string4 = string;
        Statistics statistics = elProps.getStatistic().getStat();
        boolean bl = statistics == Statistics.PctOfCases;
        SyntaxVariable syntaxVariable3 = this.getSyntaxVar(n == 0 ? ZoneType.zt_y : ZoneType.zt_y2);
        if (bl) {
            String string5 = syntaxVariable3.getSyntaxName();
            int n3 = string4.indexOf(string5);
            if (n3 > -1) {
                string4 = string4.replace(string5, "1");
            }
            String string6 = this.getPctBaseString(n2);
            String string7 = DialogUtil.formatDouble(0.01 * elProps.getLevel());
            string7 = string7.replace(',', '.');
            String string8 = "  ELEMENT: interval(position(region.confi.percent.count(%s, alpha(%s)%s)), shape.interior(shape.ibeam)%s%s)\n";
            string2 = String.format(string8, string4, string7, string6, string3, object);
        } else {
            string4 = n2 == 0 ? string4.replace(syntaxVariable3.getSyntaxName(), "(LOW+HIGH)") : string4.replace(syntaxVariable3.getSyntaxName(), "(LOW2+HIGH2)");
            String string9 = "  ELEMENT: interval(position(region.spread.range(%s)), shape.interior(shape.ibeam)%s%s)\n";
            string2 = String.format(string9, string4, string3, object);
        }
        return string2;
    }

    private String getErrorBarStatName(Statistics statistics, IPropEnum.ErrorIntervalType errorIntervalType) {
        String string = "";
        if (statistics == Statistics.Mean) {
            string = errorIntervalType == IPropEnum.ErrorIntervalType.eit_MultStdDev ? "MEANSD" : (errorIntervalType == IPropEnum.ErrorIntervalType.eit_MultStdError ? "MEANSE" : "MEANCI");
        } else if (statistics == Statistics.Median) {
            string = "MEDIANCI";
        } else if (statistics == Statistics.Count) {
            string = "COUNTCI";
        }
        return string;
    }

    private String getSymbolShape(IPropEnum.SymbolType symbolType) {
        String string = "";
        if (symbolType == IPropEnum.SymbolType.st_Arrow) {
            string = "arrow";
        } else if (symbolType == IPropEnum.SymbolType.st_Bowtie) {
            string = "bowtie";
        } else if (symbolType == IPropEnum.SymbolType.st_Circle) {
            string = "circle";
        } else if (symbolType == IPropEnum.SymbolType.st_Cross) {
            string = "cross";
        } else if (symbolType == IPropEnum.SymbolType.st_Female) {
            string = "female";
        } else if (symbolType == IPropEnum.SymbolType.st_Flower) {
            string = "flower";
        } else if (symbolType == IPropEnum.SymbolType.st_IBeam) {
            string = "ibeam";
        } else if (symbolType == IPropEnum.SymbolType.st_Line) {
            string = "line";
        } else if (symbolType == IPropEnum.SymbolType.st_Male) {
            string = "male";
        } else if (symbolType == IPropEnum.SymbolType.st_Plus) {
            string = "plus";
        } else if (symbolType == IPropEnum.SymbolType.st_Polygon) {
            string = "polygon";
        } else if (symbolType == IPropEnum.SymbolType.st_Square) {
            string = "square";
        } else if (symbolType == IPropEnum.SymbolType.st_Star) {
            string = "star";
        }
        return string;
    }

    private void addOverlayScatterSyntax(StringBuffer stringBuffer, Props.ElProps elProps) {
        if (!(elProps instanceof Props.PointProps)) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        Props.PointProps pointProps = (Props.PointProps)elProps;
        YXPairs yXPairs = pointProps.getYXPairs();
        int n = yXPairs.getCount();
        for (int i = 0; i < n; ++i) {
            String string = yXPairs.getX(i);
            String string2 = yXPairs.getY(i);
            int n2 = Math.min(string.length(), 16);
            int n3 = Math.min(string2.length(), 16);
            String string3 = string.substring(0, n2) + "_" + string2.substring(0, n3);
            int n4 = 1;
            String string4 = string3;
            while (this.isNameInList(string3) || this.isNameInDataset(string3, string3)) {
                string3 = String.format("%s%d", string4, n4++);
            }
            vector.add(string3);
            SyntaxVariable syntaxVariable = this.getSyntaxVar(yXPairs.getX(i));
            SyntaxVariable syntaxVariable2 = this.getSyntaxVar(yXPairs.getY(i));
            stringBuffer.append("  TRANS: ").append(string3).append("=eval(\"");
            String string5 = syntaxVariable.getVariable().getLabel();
            if (string5 == null || string5.length() == 0) {
                string5 = syntaxVariable.getVariable().getName();
            }
            stringBuffer.append(string5).append(" - ");
            string5 = syntaxVariable2.getVariable().getLabel();
            if (string5 == null || string5.length() == 0) {
                string5 = syntaxVariable2.getVariable().getName();
            }
            stringBuffer.append(string5).append("\")\n");
        }
        String string = this.getPointLabelSyntax();
        String string6 = this.getAestheticString(this.getLegendProp(0), false);
        String string7 = this.getPanelElementExpression();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ELEMENT: point(position(");
            stringBuffer.append(yXPairs.getX(i)).append("*").append(yXPairs.getY(i)).append(string7);
            stringBuffer.append("), ").append(string6).append("(");
            stringBuffer.append((String)vector.get(i)).append(")").append(string).append(")\n");
        }
    }

    private String getGPLPositionStat(Props.ElProps elProps, PositionBag positionBag) {
        String string = "";
        positionBag.mPositionClose = ")";
        if (this.mCanvas.getImager().isPopulationPyramid() && this.mCanvas.getZoneMgr().hasScaleVar(ZoneType.zt_dist_var)) {
            return "bin.rect(";
        }
        boolean bl = (elProps.getFlags() & 0x10) != 0;
        Statistics statistics = elProps.getStatistic().getStat();
        if (this.mProperties.getHasSSVs()) {
            statistics = elProps.getSSVData().getSSVVariables().get(0).getStat();
        }
        if (statistics == Statistics.PctOfCases) {
            string = bl ? "summary.percent.count(" : "summary.percent(";
        } else if (statistics == Statistics.CumCount || statistics == Statistics.CumResponses || statistics == Statistics.CumSum) {
            string = "summary.sum.cumulative(";
        } else if (statistics == Statistics.CumPct || statistics == Statistics.CumResponsePct) {
            string = "summary.percent.cumulative(";
        } else {
            positionBag.mPositionClose = "";
        }
        if (string.length() == 0 && this.mTransBags.size() > 0) {
            string = "summary.sum(";
            positionBag.mPositionClose = ")";
        }
        return string;
    }

    private void addHistogramElementSyntax(StringBuffer stringBuffer, Props.ElProps elProps) {
        Object object;
        Object object2;
        String string = this.nodeNameForProperty(elProps);
        boolean bl = elProps instanceof Props.LineProps || elProps instanceof Props.AreaProps;
        boolean bl2 = this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_group);
        boolean bl3 = elProps.getStatistic().getStat() == Statistics.HistogramPct;
        SmootherBag smootherBag = new SmootherBag();
        String string2 = "";
        if (bl) {
            string2 = this.getSmootherStats(elProps, smootherBag);
        }
        stringBuffer.append("  ELEMENT: ").append(string);
        if (bl2 && !"line".equals(string)) {
            stringBuffer.append(".stack");
        }
        stringBuffer.append("(position(");
        if (string2.length() > 0) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("summary.");
        if (bl3) {
            stringBuffer.append("percent.");
        }
        stringBuffer.append("count(bin.rect(");
        SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_x);
        stringBuffer.append(syntaxVariable.getSyntaxName());
        stringBuffer.append(this.getHistoElementParms(elProps));
        stringBuffer.append(")");
        if (bl3) {
            object2 = elProps.getStatistic().getPctBaseType();
            stringBuffer.append(this.getPctBaseSyntaxName((IPropEnum.PercentageBaseType)((Object)object2)));
        }
        stringBuffer.append(smootherBag.mSmootherClose).append("))");
        object2 = this.getSyntaxVar(ZoneType.zt_group);
        if (object2 != null) {
            object = this.getAestheticString(this.getLegendProp(0), false);
            stringBuffer.append(", ").append((String)object).append("(");
            stringBuffer.append(this.getTransVarName(((SyntaxVariable)object2).getSyntaxName())).append(")");
        }
        if (bl) {
            if (smootherBag.mInterpolateMissing) {
                stringBuffer.append(", missing.interpolate()");
            } else {
                stringBuffer.append(", missing.wings()");
            }
            if (smootherBag.mJump) {
                stringBuffer.append(", jump()");
            }
        } else {
            object = ((Props.BarProps)elProps).getIntervalStyle();
            if (object == IPropEnum.IntervalStyle.is_IBeam) {
                stringBuffer.append(", shape.interior(shape.ibeam)");
            } else if (object == IPropEnum.IntervalStyle.is_Line) {
                stringBuffer.append(", shape.interior(shape.line)");
            } else {
                stringBuffer.append(", shape.interior(shape.square)");
            }
        }
        stringBuffer.append(")\n");
        if (elProps.getStatistic().getDisplayNormalCurve()) {
            stringBuffer.append("  ELEMENT: line(position(density.normal(").append(syntaxVariable.getSyntaxName());
            boolean bl4 = this.mCanvas.getImager().hasHorzPanels();
            boolean bl5 = this.mCanvas.getImager().hasVertPanels();
            if (bl4 || bl5) {
                SyntaxVariable syntaxVariable2 = this.getSyntaxVar(ZoneType.zt_panel_horz);
                SyntaxVariable syntaxVariable3 = this.getSyntaxVar(ZoneType.zt_panel_vert);
                stringBuffer.append("*1");
                if (bl4) {
                    stringBuffer.append("*").append(syntaxVariable2.getSyntaxName());
                } else {
                    stringBuffer.append("*1");
                }
                if (bl5) {
                    stringBuffer.append("*").append(syntaxVariable3.getSyntaxName());
                }
            }
            stringBuffer.append(")))\n");
        }
    }

    private String getPctBaseSyntaxName(IPropEnum.PercentageBaseType percentageBaseType) {
        Coords coords = this.mProperties.getCoords();
        boolean bl = this.mCanvas.getImager().hasXCluster();
        boolean bl2 = this.mCanvas.getImager().hasZCluster();
        String string = ", base.all(acrossPanels())";
        if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_GrandTotal) {
            string = ", base.all(acrossPanels())";
        } else if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_LegendTotal1) {
            Props.LegendProps legendProps = this.getLegendProp(0);
            String string2 = this.getAestheticString(legendProps, true);
            string = String.format(", base.aesthetic(aesthetic(%s))", string2);
        } else if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_LegendTotal2) {
            Props.LegendProps legendProps = this.getLegendProp(1);
            String string3 = this.getAestheticString(legendProps, true);
            string = String.format(", base.aesthetic(aesthetic(%s))", string3);
        } else if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_XAxisTotal) {
            int n;
            int n2 = n = coords == Coords.coords_3D ? 2 : 1;
            if (bl) {
                n = coords == Coords.coords_3D ? (bl2 ? 5 : 4) : 3;
            }
            string = String.format(", base.coordinate(dim(%d))", n);
        } else if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_YAxisTotal) {
            int n = coords == Coords.coords_3D ? 3 : 2;
            string = String.format(", base.coordinate(dim(%d))", n);
        } else if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_ZAxisTotal) {
            int n = 1;
            if (bl2) {
                n = 4;
            }
            string = String.format(", base.coordinate(dim(%d))", n);
        } else if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_PanelTotal) {
            string = ", base.all()";
        }
        return string;
    }

    private String getHistoElementParms(Props.ElProps elProps) {
        String string = this.getPanelElementParms();
        int n = elProps.getStatistic().getAnchorType();
        if (n != 0) {
            string = string + ", binStart(";
            string = string + this.makeBinStart(elProps.getStatistic().getVariable(), elProps.getStatistic().getStrParm1());
            string = string + ")";
        }
        if (elProps.getStatistic().getBinSize() != 0) {
            SyntaxVariable syntaxVariable;
            string = elProps.getStatistic().getBinSizeCustom() == 0 ? string + ", binCount(" : string + ", binWidth(";
            String string2 = elProps.getStatistic().getStrParm2();
            string2 = string2.replace(',', '.');
            string = string + string2;
            if (elProps.getStatistic().getBinSizeCustom() != 0 && (syntaxVariable = this.getSyntaxVar(ZoneType.zt_x)).getVariable().getFormat().getFormatType().isDateOrTimeFormat()) {
                string = string + "d";
            }
            string = string + ")";
        }
        return string;
    }

    private String makeBinStart(ISpssVariable iSpssVariable, String string) {
        String string2 = null;
        if (iSpssVariable != null && iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) {
            Object object = CellValueFormatter.parseDate((SPSS_Format)iSpssVariable.getFormat(), (String)string);
            if (!(object instanceof Date)) {
                object = CellValueFormatter.parseDate((String)string);
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
                calendar.setTime(date);
                string2 = String.format("\"%04d-%02d-%02d\"", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
            }
        }
        if (string2 == null) {
            string2 = string.replace(',', '.');
        }
        return string2;
    }

    private String getSmootherStats(Props.ElProps elProps, SmootherBag smootherBag) {
        InterpolationGroup interpolationGroup;
        if (elProps instanceof Props.AreaProps) {
            interpolationGroup = ((Props.AreaProps)elProps).getInterpolationGroup();
        } else if (elProps instanceof Props.LineProps) {
            interpolationGroup = ((Props.LineProps)elProps).getInterpolationGroup();
        } else if (elProps instanceof Props.HiLoCloseProps) {
            interpolationGroup = ((Props.HiLoCloseProps)elProps).getInterpolationGroup();
        } else {
            return "";
        }
        String string = "";
        if (interpolationGroup.getInterpolationType() == IPropEnum.InterpolationType.it_Spline) {
            string = "smooth.spline(";
            smootherBag.mSmootherClose = ")";
        } else if (interpolationGroup.getInterpolationType() == IPropEnum.InterpolationType.it_Jump || interpolationGroup.getInterpolationType() == IPropEnum.InterpolationType.it_Step) {
            smootherBag.mJump = interpolationGroup.getInterpolationType() == IPropEnum.InterpolationType.it_Jump;
            string = "smooth.step.";
            if (interpolationGroup.getInterpolationLocation() == IPropEnum.InterpolationLocation.il_Left) {
                string = string + "left(";
            } else if (interpolationGroup.getInterpolationLocation() == IPropEnum.InterpolationLocation.il_Center) {
                string = string + "center(";
            } else if (interpolationGroup.getInterpolationLocation() == IPropEnum.InterpolationLocation.il_Right) {
                string = string + "right(";
            }
            smootherBag.mSmootherClose = ")";
        }
        smootherBag.mInterpolateMissing = interpolationGroup.getInterpolateThroughMissing();
        return string;
    }

    private void makeHiLoIntervalSyntax(StringBuffer stringBuffer, Props.HiLoCloseProps hiLoCloseProps, String string) {
        String string2;
        boolean bl = this.mCanvas.getImager().hasXCluster();
        String string3 = "square";
        if (hiLoCloseProps.getIntervalStyle() == IPropEnum.IntervalStyle.is_IBeam) {
            string3 = "ibeam";
        } else if (hiLoCloseProps.getIntervalStyle() == IPropEnum.IntervalStyle.is_Line) {
            string3 = "line";
        }
        String string4 = this.getPanelElementExpression();
        SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_x);
        SyntaxVariable syntaxVariable2 = this.getSyntaxVar(ZoneType.zt_low);
        SyntaxVariable syntaxVariable3 = this.getSyntaxVar(ZoneType.zt_high);
        if (bl) {
            String string5 = "  ELEMENT: interval(position(region.spread.range(%s*(%s+%s)*%s%s)), shape(shape.%s), %s(%s))\n";
            SyntaxVariable syntaxVariable4 = this.getSyntaxVar(ZoneType.zt_cluster_x);
            string2 = String.format(string5, syntaxVariable4.getSyntaxName(), syntaxVariable2.getSyntaxName(), syntaxVariable3.getSyntaxName(), syntaxVariable.getSyntaxName(), string4, string3, string, syntaxVariable4.getSyntaxName());
        } else {
            String string6 = "  ELEMENT: interval(position(region.spread.range(%s*(%s+%s)%s)), shape(shape.%s))\n";
            string2 = String.format(string6, syntaxVariable.getSyntaxName(), syntaxVariable2.getSyntaxName(), syntaxVariable3.getSyntaxName(), string4, string3);
        }
        stringBuffer.append(string2);
    }

    private String getPanelElementExpression() {
        String string = "";
        SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_panel_horz);
        SyntaxVariable syntaxVariable2 = this.getSyntaxVar(ZoneType.zt_panel_vert);
        if (syntaxVariable != null && syntaxVariable2 != null) {
            string = "*" + this.getTransVarName(syntaxVariable.getSyntaxName()) + "*" + this.getTransVarName(syntaxVariable2.getSyntaxName());
        } else if (syntaxVariable != null) {
            string = "*" + this.getTransVarName(syntaxVariable.getSyntaxName());
        } else if (syntaxVariable2 != null) {
            string = "*1*" + this.getTransVarName(syntaxVariable2.getSyntaxName());
        }
        return string;
    }

    private String getPanelElementParms() {
        String string = "";
        boolean bl = this.mCanvas.getImager().hasHorzPanels();
        boolean bl2 = this.mCanvas.getImager().hasVertPanels();
        if (bl || bl2) {
            SyntaxVariable syntaxVariable = this.getSyntaxVar(ZoneType.zt_panel_horz);
            SyntaxVariable syntaxVariable2 = this.getSyntaxVar(ZoneType.zt_panel_vert);
            string = string + "*1";
            string = bl ? string + "*" + this.getTransVarName(syntaxVariable.getSyntaxName()) : string + "*1";
            if (bl2) {
                string = string + "*" + this.getTransVarName(syntaxVariable2.getSyntaxName());
            }
        }
        return string;
    }

    private String nodeNameForProperty(Props.ElProps elProps) {
        String string = "interval";
        if (elProps instanceof Props.PointProps) {
            string = "point";
        } else if (elProps instanceof Props.HiLoCloseProps) {
            string = this.mCanvas.getImager().isDifferenceArea() ? "area.difference" : "point";
        } else if (elProps instanceof Props.LineProps) {
            string = "line";
        } else if (elProps instanceof Props.AreaProps) {
            string = "area";
        } else if (elProps instanceof Props.SchemaProps) {
            string = "schema";
        } else if (elProps instanceof Props.MatrixProps) {
            string = "point";
        }
        return string;
    }

    private String getPctBaseString(int n) {
        boolean bl;
        String string = "";
        Props.ElProps elProps = this.mProperties.getElementProp(n);
        ElementStat elementStat = elProps.getStatistic();
        Statistics statistics = elementStat.getStat();
        boolean bl2 = bl = statistics == Statistics.PctOfCases || statistics == Statistics.CumPct;
        if (bl) {
            Coords coords = this.mProperties.getCoords();
            boolean bl3 = this.mCanvas.getImager().hasXCluster();
            boolean bl4 = this.mCanvas.getImager().hasZCluster();
            IPropEnum.PercentageBaseType percentageBaseType = elementStat.getPctBaseType();
            if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_XAxisTotal) {
                int n2;
                int n3 = n2 = coords == Coords.coords_3D ? 2 : 1;
                if (bl3) {
                    n2 = coords == Coords.coords_3D ? (bl4 ? 5 : 4) : 3;
                }
                string = String.format(", base.coordinate(dim(%d))", n2);
            } else if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_YAxisTotal) {
                int n4 = coords == Coords.coords_3D ? 3 : 2;
                string = String.format(", base.coordinate(dim(%d))", n4);
            } else if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_ZAxisTotal) {
                int n5 = 1;
                if (bl4) {
                    n5 = 4;
                }
                string = String.format(", base.coordinate(dim(%d))", n5);
            } else if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_LegendTotal1) {
                String string2 = this.getAestheticString(this.getLegendProp(0), true);
                string = String.format(", base.aesthetic(aesthetic(%s))", string2);
            } else if (percentageBaseType == IPropEnum.PercentageBaseType.pbt_LegendTotal2) {
                String string3 = this.getAestheticString(this.getLegendProp(1), true);
                string = String.format(", base.aesthetic(aesthetic(%s))", string3);
            } else {
                string = percentageBaseType == IPropEnum.PercentageBaseType.pbt_PanelTotal ? String.format(", base.all()", new Object[0]) : String.format(", base.all(acrossPanels())", new Object[0]);
            }
        }
        return string;
    }

    private Props.LegendProps getLegendProp(int n) {
        int n2 = 0;
        for (Props props : this.mProperties.getProperties()) {
            if (!(props instanceof Props.LegendProps)) continue;
            if (n2 == n) {
                return (Props.LegendProps)props;
            }
            ++n2;
        }
        return null;
    }

    private Props.AxisProps getAxisProp(ZoneType zoneType) {
        for (Props props : this.mProperties.getProperties()) {
            if (!(props instanceof Props.AxisProps) || ((Props.AxisProps)props).getZoneType() != zoneType) continue;
            return (Props.AxisProps)props;
        }
        return null;
    }

    private Props.PanelProps getPanelProp(ZoneType zoneType) {
        for (Props props : this.mProperties.getProperties()) {
            if (!(props instanceof Props.PanelProps) || ((Props.PanelProps)props).getZoneType() != zoneType) continue;
            return (Props.PanelProps)props;
        }
        return null;
    }

    private ArrayList<Props.PanelProps> getFilterPanelProps(ZoneType zoneType) {
        ArrayList<Props.PanelProps> arrayList = new ArrayList<Props.PanelProps>();
        for (Props props : this.mProperties.getProperties()) {
            if (!(props instanceof Props.PanelProps) || ((Props.PanelProps)props).getZoneType() != zoneType) continue;
            arrayList.add((Props.PanelProps)props);
        }
        return arrayList;
    }

    private Props.TitleProps getTitleProp(IPropEnum.TitleFlag titleFlag) {
        for (Props props : this.mProperties.getProperties()) {
            if (!(props instanceof Props.TitleProps) || ((Props.TitleProps)props).getTitleType() != titleFlag) continue;
            return (Props.TitleProps)props;
        }
        return null;
    }

    private String escapeString(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\'': 
                case '\\': {
                    stringBuffer.append('\\');
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    class PositionBag {
        String mPositionClose;

        PositionBag() {
        }
    }

    class SmootherBag {
        boolean mJump = false;
        boolean mInterpolateMissing = false;
        String mSmootherClose = "";
    }

    class ScaleBag {
        int mDimNo;
        boolean mHas2ndScale;

        ScaleBag() {
        }
    }

    class TransBag {
        String mOrgName;
        String mSyntaxName;
        String mTransString;

        TransBag() {
        }
    }
}

