/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.common.prefs.PrefChartUtil;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.aesthetic.AestheticSpecification;
import com.spss.vis.specification.aesthetic.ColorAestheticSpecification;
import com.spss.vis.specification.aesthetic.PatternAestheticSpecification;
import com.spss.vis.specification.aesthetic.StyleAestheticSpecification;
import com.spss.vis.specification.element.ElementSpecification;
import com.spss.vis.specification.element.IntervalSpecification;
import com.spss.vis.specification.element.LineSpecification;
import com.spss.vis.specification.element.PointSpecification;
import com.spss.vis.specification.style.CycleSpecification;
import com.spss.vis.specification.style.StyleCycleSpecification;
import com.spss.vis.specification.style.StyleSpecification;
import com.spss.vis.specification.style.SymbolType;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class StyleCycler {
    private CanvasImager mImager;
    private CycleSpecification mFillColorCycle;
    private CycleSpecification mStrokeColorCycle;
    private CycleSpecification mFillCycle;
    private CycleSpecification mDashCycle;
    private CycleSpecification mGlyphCycle;
    private Color mSimpleColor;
    private Integer mSimpleFill;
    private Integer mSimpleDash;
    private Integer mSimpleGlyph;
    protected boolean mUseColors;
    private Color[] mCycleColors;

    public StyleCycler(CanvasImager canvasImager) {
        this.mImager = canvasImager;
        this.setupCycles();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("charts");
        int n = preferences2.getInt("cycle_option", 0);
        this.mUseColors = n == 0;
    }

    public void setCycleForElement(ElementSpecification elementSpecification, boolean bl, int n) {
        AestheticSpecification[] aestheticSpecificationArray = elementSpecification.getAestheticSpecifications();
        if (aestheticSpecificationArray.length > n) {
            if (aestheticSpecificationArray[n] instanceof StyleAestheticSpecification) {
                StyleAestheticSpecification styleAestheticSpecification = (StyleAestheticSpecification)aestheticSpecificationArray[n];
                StyleCycleSpecification styleCycleSpecification = styleAestheticSpecification.getStyleCycleSpecification();
                if (styleCycleSpecification != null && styleCycleSpecification.getParent() != null) {
                    styleCycleSpecification.getParent().remove((Specification)styleCycleSpecification);
                }
                styleCycleSpecification = new StyleCycleSpecification();
                styleCycleSpecification.addCycleChild((CycleSpecification)this.getCycleForElement(elementSpecification, bl).clone());
                styleAestheticSpecification.setStyleCycle(styleCycleSpecification);
            } else if (aestheticSpecificationArray[n] instanceof ColorAestheticSpecification) {
                ColorAestheticSpecification colorAestheticSpecification = (ColorAestheticSpecification)aestheticSpecificationArray[n];
                StyleCycleSpecification styleCycleSpecification = colorAestheticSpecification.getCycle();
                if (styleCycleSpecification != null && styleCycleSpecification.getParent() != null) {
                    styleCycleSpecification.getParent().remove((Specification)styleCycleSpecification);
                }
                styleCycleSpecification = new StyleCycleSpecification();
                styleCycleSpecification.addCycleChild((CycleSpecification)this.getCycleForElement(elementSpecification, bl).clone());
                colorAestheticSpecification.setCycle(styleCycleSpecification);
            } else if (aestheticSpecificationArray[n] instanceof PatternAestheticSpecification) {
                PatternAestheticSpecification patternAestheticSpecification = (PatternAestheticSpecification)aestheticSpecificationArray[n];
                StyleCycleSpecification styleCycleSpecification = patternAestheticSpecification.getCycle();
                if (styleCycleSpecification != null && styleCycleSpecification.getParent() != null) {
                    styleCycleSpecification.getParent().remove((Specification)styleCycleSpecification);
                }
                styleCycleSpecification = new StyleCycleSpecification();
                styleCycleSpecification.addCycleChild((CycleSpecification)this.getCycleForElement(elementSpecification, bl).clone());
                patternAestheticSpecification.setCycle(styleCycleSpecification);
            }
        }
    }

    public void clearElementCycle(ElementSpecification elementSpecification, int n) {
        StyleCycleSpecification styleCycleSpecification;
        AestheticSpecification[] aestheticSpecificationArray = elementSpecification.getAestheticSpecifications();
        if (aestheticSpecificationArray.length > n && aestheticSpecificationArray[n] instanceof StyleAestheticSpecification && (styleCycleSpecification = ((StyleAestheticSpecification)aestheticSpecificationArray[n]).getStyleCycleSpecification()) != null) {
            styleCycleSpecification.getParent().remove((Specification)styleCycleSpecification);
        }
    }

    public boolean getUseColors() {
        return this.mUseColors;
    }

    public void setBaseStyle(Coords coords, ElementSpecification elementSpecification, Elements elements, boolean bl) {
        boolean bl2 = elementSpecification instanceof IntervalSpecification && elements == Elements.hilo;
        boolean bl3 = this.mImager.isErrorBarElement(elementSpecification);
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = coords == Coords.coords_DualY;
        StyleSpecification styleSpecification = elementSpecification.getStyle("");
        if (styleSpecification == null) {
            styleSpecification = new StyleSpecification();
            elementSpecification.setStyle(styleSpecification);
            bl4 = true;
        } else if (elementSpecification instanceof IntervalSpecification) {
            boolean bl7 = bl5 = styleSpecification.getSymbol() != null && styleSpecification.getSymbol() != SymbolType.SQUARE;
        }
        if (bl) {
            if (bl6) {
                this.setDualYColor(elementSpecification, styleSpecification);
            } else if (elementSpecification instanceof PointSpecification) {
                styleSpecification.setSecondaryColor(Color.black);
            } else if (elementSpecification instanceof LineSpecification || bl5 || bl3 || bl2 && bl4) {
                styleSpecification.setColor(Color.black);
            } else {
                styleSpecification.setColor(this.mSimpleColor);
            }
        } else if (bl6) {
            this.setDualYPattern(elementSpecification, styleSpecification);
        } else if (elementSpecification instanceof PointSpecification) {
            styleSpecification.setSymbol(SymbolType.get((String)PrefChartUtil.getMarkerType((int)this.mSimpleGlyph)));
            styleSpecification.setSymbolAngle(Double.valueOf(PrefChartUtil.getMarkerAngle((int)this.mSimpleGlyph)));
            styleSpecification.setSymbolAspect(Double.valueOf(PrefChartUtil.getMarkerAspect((int)this.mSimpleGlyph)));
            styleSpecification.setSymbolSides(Integer.valueOf(PrefChartUtil.getMarkerSides((int)this.mSimpleGlyph)));
            styleSpecification.setSize(new Length(PrefChartUtil.getMarkerSize((int)this.mSimpleGlyph)));
        } else if (elementSpecification instanceof LineSpecification || bl5) {
            styleSpecification.setColor(Color.black);
            styleSpecification.setStrokeDashing(this.getLengthArray(PrefChartUtil.getLineDashArray((int)this.mSimpleDash)));
        } else {
            styleSpecification.setPatternIndex(this.mSimpleFill);
            styleSpecification.setColor(Color.white);
            styleSpecification.setSecondaryColor(Color.black);
        }
        if (elementSpecification instanceof IntervalSpecification) {
            boolean bl8 = this.mImager.isHistogram();
            if (elements == Elements.polar_interval || bl8) {
                styleSpecification.setDepth(null);
                styleSpecification.setWidth(new Length("100%"));
            } else {
                styleSpecification.setDepth(new Length("75%"));
                if (this.mImager.hasXCluster()) {
                    styleSpecification.setWidth(new Length("100%"));
                } else {
                    styleSpecification.setWidth(new Length("75%"));
                }
            }
            styleSpecification.setSize(null);
        }
        if (elementSpecification instanceof PointSpecification) {
            styleSpecification.setSize(new Length("6pt"));
        }
        if (bl2 && bl4) {
            styleSpecification.setSymbol(SymbolType.IBEAM);
            styleSpecification.setSize(new Length("75%"));
            styleSpecification.setWidth(new Length("25%"));
        }
    }

    public void setSimplePointCycle(StyleAestheticSpecification styleAestheticSpecification) {
        StyleCycleSpecification styleCycleSpecification = new StyleCycleSpecification();
        styleAestheticSpecification.setStyleCycle(styleCycleSpecification);
        CycleSpecification cycleSpecification = new CycleSpecification();
        styleCycleSpecification.addCycleChild(cycleSpecification);
        StyleSpecification styleSpecification = new StyleSpecification();
        cycleSpecification.addStyle(styleSpecification);
        styleSpecification.setColor(new Color(0, 0, 0, 0), true);
        styleSpecification.setSecondaryColor(Color.black);
    }

    public Color getDualYAxisColor(int n) {
        StyleSpecification styleSpecification = this.mFillColorCycle.getStyles()[n];
        return styleSpecification.getColor();
    }

    public Color[] getCycleColors() {
        return this.mCycleColors;
    }

    public void refreshColorCycle(Color[] colorArray) {
        for (int i = 0; i < colorArray.length; ++i) {
            if (i >= this.mCycleColors.length) continue;
            this.mCycleColors[i] = colorArray[i];
        }
        this.mFillColorCycle = new CycleSpecification();
        this.mStrokeColorCycle = new CycleSpecification();
        for (Color color : this.mCycleColors) {
            StyleSpecification styleSpecification = new StyleSpecification();
            styleSpecification.setColor(color);
            this.mFillColorCycle.addStyle(styleSpecification);
            styleSpecification = new StyleSpecification();
            styleSpecification.setSecondaryColor(color);
            this.mStrokeColorCycle.addStyle(styleSpecification);
        }
    }

    public void refreshSimpleColor(Color color) {
        this.mSimpleColor = color;
    }

    public void serializeIn(DataInputStream dataInputStream) {
        try {
            int n;
            int n2;
            int n3;
            int n4 = dataInputStream.readInt();
            if (n4 > 0) {
                this.mCycleColors = new Color[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = dataInputStream.readInt();
                    n = dataInputStream.readInt();
                    int n5 = dataInputStream.readInt();
                    this.mCycleColors[n3] = new Color(n2, n, n5);
                }
            }
            n3 = dataInputStream.readInt();
            n2 = dataInputStream.readInt();
            n = dataInputStream.readInt();
            this.mSimpleColor = new Color(n3, n2, n);
            this.refreshColorCycle(this.mCycleColors);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean serializeOut(DataOutputStream dataOutputStream) {
        try {
            boolean bl = this.mCycleColors.length > 0 && this.mCycleColors[0] != null;
            dataOutputStream.writeInt(bl ? this.mCycleColors.length : 0);
            if (bl) {
                for (Color color : this.mCycleColors) {
                    dataOutputStream.writeInt(color.getRed());
                    dataOutputStream.writeInt(color.getGreen());
                    dataOutputStream.writeInt(color.getBlue());
                }
            }
            dataOutputStream.writeInt(this.mSimpleColor.getRed());
            dataOutputStream.writeInt(this.mSimpleColor.getGreen());
            dataOutputStream.writeInt(this.mSimpleColor.getBlue());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private void setDualYColor(ElementSpecification elementSpecification, StyleSpecification styleSpecification) {
        boolean bl = this.mImager.dualYElementWithFirstYAxis(elementSpecification);
        Color color = this.getDualYAxisColor(bl ? 0 : 1);
        if (elementSpecification instanceof PointSpecification) {
            styleSpecification.setSecondaryColor(color);
        } else {
            styleSpecification.setColor(color);
        }
    }

    private void setDualYPattern(ElementSpecification elementSpecification, StyleSpecification styleSpecification) {
        int n;
        boolean bl = this.mImager.dualYElementWithFirstYAxis(elementSpecification);
        int n2 = n = bl ? 0 : 1;
        CycleSpecification cycleSpecification = elementSpecification instanceof PointSpecification ? this.mGlyphCycle : (elementSpecification instanceof LineSpecification ? this.mDashCycle : this.mFillCycle);
        StyleSpecification styleSpecification2 = cycleSpecification.getStyles()[n];
        if (elementSpecification instanceof PointSpecification) {
            styleSpecification.setSymbol(styleSpecification2.getSymbol());
            styleSpecification.setSymbolAngle(styleSpecification2.getSymbolAngle());
            styleSpecification.setSymbolAspect(styleSpecification2.getSymbolAspect());
            styleSpecification.setSymbolSides(styleSpecification2.getSymbolSides());
            styleSpecification.setSize(styleSpecification2.getSize());
        } else if (elementSpecification instanceof LineSpecification) {
            styleSpecification.setStrokeDashing(styleSpecification2.getStrokeDashing());
        } else {
            styleSpecification.setPatternIndex(styleSpecification2.getPatternIndex());
        }
    }

    private void setupCycles() {
        try {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
            Preferences preferences2 = preferences.node("charts");
            this.setupBaseStyles(preferences2);
            this.setupColorCycle(preferences2);
            this.setupFillCycle(preferences2);
            this.setupDashCycle(preferences2);
            this.setupGlyphCycle(preferences2);
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    private void setupBaseStyles(Preferences preferences) {
        Preferences preferences2 = preferences.node("chart_colors");
        String string = preferences2.get("simple_color", "85,150,230");
        this.mSimpleColor = PrefChartUtil.makeARGBColor((String)PrefChartUtil.prefColorToXmlColor((String)string));
        Preferences preferences3 = preferences.node("chart_patterns");
        String string2 = preferences3.get("simple_fill", "6");
        this.mSimpleFill = Integer.valueOf(string2);
        Preferences preferences4 = preferences.node("chart_lines");
        String string3 = preferences4.get("simple_line", "0");
        this.mSimpleDash = Integer.valueOf(string3);
        Preferences preferences5 = preferences.node("chart_markers");
        String string4 = preferences5.get("simple_marker", "5");
        this.mSimpleGlyph = Integer.valueOf(string4);
    }

    private CycleSpecification getCycleForElement(ElementSpecification elementSpecification, boolean bl) {
        if (bl) {
            return this.mFillColorCycle;
        }
        if (elementSpecification instanceof LineSpecification || this.isRangeBeam(elementSpecification)) {
            return this.mDashCycle;
        }
        if (elementSpecification instanceof PointSpecification) {
            return this.mGlyphCycle;
        }
        return this.mFillCycle;
    }

    private boolean isRangeBeam(ElementSpecification elementSpecification) {
        if (elementSpecification instanceof IntervalSpecification) {
            StyleSpecification styleSpecification = elementSpecification.getStyle("");
            SymbolType symbolType = styleSpecification.getSymbol();
            return symbolType != null && symbolType != SymbolType.SQUARE;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void setupColorCycle(Preferences preferences) throws BackingStoreException {
        if (this.mCycleColors == null) {
            int n = 0;
            int n2 = this.mImager.getMaxCats();
            Preferences preferences2 = preferences.node("chart_colors");
            String[] stringArray = preferences2.keys();
            String[] object = new String[n2];
            if (stringArray.length < n2) {
                System.arraycopy(PrefDefaults.DEF_CHART_COLOR_CYCLE, 0, object, 0, n2);
            } else {
                boolean bl = false;
                while (n < this.mImager.getMaxCats()) {
                    void var8_14;
                    String string = String.format("%s%d", "Cat_", (int)var8_14);
                    object[n++] = preferences2.get(string, PrefDefaults.DEF_CHART_COLOR_CYCLE[var8_14]);
                    ++var8_14;
                }
            }
            n = 0;
            this.mCycleColors = new Color[n2];
            for (String string : object) {
                this.mCycleColors[n++] = this.getColorFromString(string);
            }
        }
        this.mFillColorCycle = new CycleSpecification();
        this.mStrokeColorCycle = new CycleSpecification();
        for (Color color : this.mCycleColors) {
            StyleSpecification styleSpecification = new StyleSpecification();
            styleSpecification.setColor(color);
            this.mFillColorCycle.addStyle(styleSpecification);
            styleSpecification = new StyleSpecification();
            styleSpecification.setSecondaryColor(color);
            this.mStrokeColorCycle.addStyle(styleSpecification);
        }
    }

    private void setupFillCycle(Preferences preferences) throws BackingStoreException {
        int n = 0;
        int n2 = this.mImager.getMaxCats();
        Preferences preferences2 = preferences.node("chart_patterns");
        String[] stringArray = preferences2.keys();
        String[] stringArray2 = new String[n2];
        if (stringArray.length < n2) {
            System.arraycopy(PrefDefaults.DEF_CHART_PATTERN_CYCLE, 0, stringArray2, 0, n2);
        } else {
            int n3 = 0;
            while (n < this.mImager.getMaxCats()) {
                if (stringArray[n3].startsWith("Cat_")) {
                    stringArray2[n++] = preferences2.get(stringArray[n3], PrefDefaults.DEF_CHART_PATTERN_CYCLE[n3]);
                }
                ++n3;
            }
        }
        this.mFillCycle = new CycleSpecification();
        for (String string : stringArray2) {
            StyleSpecification styleSpecification = new StyleSpecification();
            styleSpecification.setPatternIndex(Integer.valueOf(string));
            this.mFillCycle.addStyle(styleSpecification);
        }
    }

    private void setupDashCycle(Preferences preferences) throws BackingStoreException {
        int n = 0;
        int n2 = this.mImager.getMaxCats();
        Preferences preferences2 = preferences.node("chart_lines");
        String[] stringArray = preferences2.keys();
        String[] stringArray2 = new String[n2];
        if (stringArray.length < n2) {
            System.arraycopy(PrefDefaults.DEF_CHART_LINE_CYCLE, 0, stringArray2, 0, n2);
        } else {
            int n3 = 0;
            while (n < this.mImager.getMaxCats()) {
                if (stringArray[n3].startsWith("Cat_")) {
                    stringArray2[n++] = preferences2.get(stringArray[n3], PrefDefaults.DEF_CHART_LINE_CYCLE[n3]);
                }
                ++n3;
            }
        }
        this.mDashCycle = new CycleSpecification();
        for (String string : stringArray2) {
            StyleSpecification styleSpecification = new StyleSpecification();
            styleSpecification.setStrokeDashing(this.getLengthArray(PrefChartUtil.getLineDashArray((int)Integer.valueOf(string))));
            this.mDashCycle.addStyle(styleSpecification);
        }
    }

    private Length[] getLengthArray(String string) {
        Vector<Length> vector = new Vector<Length>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0 || string2.equals("none")) {
                return null;
            }
            vector.add(new Length(string2));
        }
        Length[] lengthArray = new Length[vector.size()];
        return vector.toArray(lengthArray);
    }

    private void setupGlyphCycle(Preferences preferences) throws BackingStoreException {
        int n = 0;
        int n2 = this.mImager.getMaxCats();
        Preferences preferences2 = preferences.node("chart_markers");
        String[] stringArray = preferences2.keys();
        String[] stringArray2 = new String[n2];
        if (stringArray.length < n2) {
            System.arraycopy(PrefDefaults.DEF_CHART_MARKER_CYCLE, 0, stringArray2, 0, n2);
        } else {
            int n3 = 0;
            while (n < this.mImager.getMaxCats()) {
                if (stringArray[n3].startsWith("Cat_")) {
                    stringArray2[n++] = preferences2.get(stringArray[n3], PrefDefaults.DEF_CHART_MARKER_CYCLE[n3]);
                }
                ++n3;
            }
        }
        this.mGlyphCycle = new CycleSpecification();
        for (String string : stringArray2) {
            int n4 = Integer.valueOf(string);
            StyleSpecification styleSpecification = new StyleSpecification();
            styleSpecification.setSymbol(SymbolType.get((String)PrefChartUtil.getMarkerType((int)n4)));
            styleSpecification.setSymbolAngle(Double.valueOf(PrefChartUtil.getMarkerAngle((int)n4)));
            styleSpecification.setSymbolAspect(Double.valueOf(PrefChartUtil.getMarkerAspect((int)n4)));
            styleSpecification.setSymbolSides(Integer.valueOf(PrefChartUtil.getMarkerSides((int)n4)));
            styleSpecification.setSize(new Length(PrefChartUtil.getMarkerSize((int)n4)));
            this.mGlyphCycle.addStyle(styleSpecification);
        }
    }

    private Color getColorFromString(String string) {
        if ("transparent".equals(string)) {
            return new Color(255, 255, 255, 0);
        }
        int n = 0;
        Object[] objectArray = new String[4];
        Arrays.fill(objectArray, "255");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            objectArray[n++] = stringTokenizer.nextToken();
        }
        return new Color(Integer.parseInt(((String)objectArray[0]).trim()), Integer.parseInt(((String)objectArray[1]).trim()), Integer.parseInt(((String)objectArray[2]).trim()));
    }
}

