/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.uitools.res.IResourceAccessor;
import java.util.Locale;

public enum Statistics {
    Value(0),
    Count(1),
    CumCount(2),
    Mean(3),
    Median(4),
    Mode(5),
    StdDev(6),
    Variance(7),
    Minimum(8),
    Maximum(9),
    Sum(10),
    CumSum(11),
    GMedian(12),
    ValidN(13),
    Responses(14),
    CumResponses(15),
    PctOfCases(16),
    CumPct(17),
    PTile(18),
    GPTile(19),
    NumAbove(20),
    NumBelow(21),
    ResponsePct(22),
    CumResponsePct(23),
    PctAbove(24),
    PctBelow(25),
    NumInside(26),
    PctInside(27),
    Histogram(28),
    HistogramPct(29),
    Boxplot(30),
    Dotplot(31);

    private int mValue;
    private String mName = null;
    private String mLabel = null;
    private String mOLName = null;

    private Statistics(int n2) {
        this.mValue = n2;
    }

    public int value() {
        return this.mValue;
    }

    public static Statistics fromInt(int n) {
        switch (n) {
            default: {
                return Value;
            }
            case 1: {
                return Count;
            }
            case 2: {
                return CumCount;
            }
            case 3: {
                return Mean;
            }
            case 4: {
                return Median;
            }
            case 5: {
                return Mode;
            }
            case 6: {
                return StdDev;
            }
            case 7: {
                return Variance;
            }
            case 8: {
                return Minimum;
            }
            case 9: {
                return Maximum;
            }
            case 10: {
                return Sum;
            }
            case 11: {
                return CumSum;
            }
            case 12: {
                return GMedian;
            }
            case 13: {
                return ValidN;
            }
            case 14: {
                return Responses;
            }
            case 15: {
                return CumResponses;
            }
            case 16: {
                return PctOfCases;
            }
            case 17: {
                return CumPct;
            }
            case 18: {
                return PTile;
            }
            case 19: {
                return GPTile;
            }
            case 20: {
                return NumAbove;
            }
            case 21: {
                return NumBelow;
            }
            case 22: {
                return ResponsePct;
            }
            case 23: {
                return CumResponsePct;
            }
            case 24: {
                return PctAbove;
            }
            case 25: {
                return PctBelow;
            }
            case 26: {
                return NumInside;
            }
            case 27: {
                return PctInside;
            }
            case 28: {
                return Histogram;
            }
            case 29: {
                return HistogramPct;
            }
            case 30: {
                return Boxplot;
            }
            case 31: 
        }
        return Dotplot;
    }

    public static void resetNames() {
        Statistics[] statisticsArray;
        for (Statistics statistics : statisticsArray = Statistics.values()) {
            statistics.mName = null;
            statistics.mLabel = null;
            statistics.mOLName = null;
        }
    }

    public String getUserString(IResourceAccessor iResourceAccessor) {
        if (this.mName != null) {
            return this.mName;
        }
        String string = "";
        switch (this) {
            case Value: {
                string = iResourceAccessor.getResString("IDS_VALUE_STAT");
                break;
            }
            case Count: {
                string = iResourceAccessor.getResString("IDS_NUM_OF_CASES_STAT");
                break;
            }
            case CumCount: {
                string = iResourceAccessor.getResString("IDS_CUM_NUM_CASES_STAT");
                break;
            }
            case Mean: {
                string = iResourceAccessor.getResString("IDS_MEAN_OF_VALS_STAT");
                break;
            }
            case Median: {
                string = iResourceAccessor.getResString("IDS_MEDIAN_OF_VALS_STAT");
                break;
            }
            case Mode: {
                string = iResourceAccessor.getResString("IDS_MODE_OF_VALS_STAT");
                break;
            }
            case StdDev: {
                string = iResourceAccessor.getResString("IDS_STD_DEVIATION_STAT");
                break;
            }
            case Variance: {
                string = iResourceAccessor.getResString("IDS_VARIANCE_STAT");
                break;
            }
            case Minimum: {
                string = iResourceAccessor.getResString("IDS_MIN_VALUE_STAT");
                break;
            }
            case Maximum: {
                string = iResourceAccessor.getResString("IDS_MAX_VALUE_STAT");
                break;
            }
            case Sum: {
                string = iResourceAccessor.getResString("IDS_SUM_OF_VALS_STAT");
                break;
            }
            case CumSum: {
                string = iResourceAccessor.getResString("IDS_CUM_SUM_STAT");
                break;
            }
            case GMedian: {
                string = iResourceAccessor.getResString("IDS_GROUP_MEDIAN_STAT");
                break;
            }
            case ValidN: {
                string = iResourceAccessor.getResString("IDS_VALID_N_STAT");
                break;
            }
            case Responses: {
                string = iResourceAccessor.getResString("IDS_RESPONSES_STAT");
                break;
            }
            case CumResponses: {
                string = iResourceAccessor.getResString("IDS_CUM_RESPONSES_STAT");
                break;
            }
            case PctOfCases: {
                string = iResourceAccessor.getResString("IDS_PCT_OF_CASES_STAT");
                break;
            }
            case CumPct: {
                string = iResourceAccessor.getResString("IDS_CUM_PCT_CASES_STAT");
                break;
            }
            case PTile: {
                string = iResourceAccessor.getResString("IDS_PCTILE_STAT");
                break;
            }
            case GPTile: {
                string = iResourceAccessor.getResString("IDS_GPCTILE_STAT");
                break;
            }
            case NumAbove: {
                string = iResourceAccessor.getResString("IDS_NUM_ABOVE_STAT");
                break;
            }
            case NumBelow: {
                string = iResourceAccessor.getResString("IDS_NUM_BELOW_STAT");
                break;
            }
            case ResponsePct: {
                string = iResourceAccessor.getResString("IDS_RESPONSE_PCT_STAT");
                break;
            }
            case CumResponsePct: {
                string = iResourceAccessor.getResString("IDS_CUM_RESPONSE_PCT_STAT");
                break;
            }
            case PctAbove: {
                string = iResourceAccessor.getResString("IDS_PCT_ABOVE_STAT");
                break;
            }
            case PctBelow: {
                string = iResourceAccessor.getResString("IDS_PCT_BELOW_STAT");
                break;
            }
            case NumInside: {
                string = iResourceAccessor.getResString("IDS_NUM_IN_RANGE_STAT");
                break;
            }
            case PctInside: {
                string = iResourceAccessor.getResString("IDS_PCT_IN_RANGE_STAT");
                break;
            }
            case Histogram: {
                string = iResourceAccessor.getResString("IDS_HISTOGRAM_STAT");
                break;
            }
            case HistogramPct: {
                string = iResourceAccessor.getResString("IDS_HISTOGRAM_PCT_STAT");
                break;
            }
            case Boxplot: {
                string = iResourceAccessor.getResString("IDS_SCHEMA_STAT");
                break;
            }
            case Dotplot: {
                string = iResourceAccessor.getResString("IDS_DOTPLOT_STAT");
                break;
            }
        }
        this.mName = string;
        return string;
    }

    public String formatTitleAsNeeded(String string, ElementStat elementStat) {
        String string2 = string;
        switch (this) {
            case PctOfCases: {
                int n = string2.indexOf("(");
                string2 = string2.substring(0, n).trim();
                break;
            }
            case PTile: 
            case GPTile: 
            case NumAbove: 
            case NumBelow: 
            case PctAbove: 
            case PctBelow: {
                if (elementStat == null) break;
                string2 = String.format(string2, elementStat.getStrParm1());
                break;
            }
            case NumInside: 
            case PctInside: {
                if (elementStat == null) break;
                string2 = String.format(string2, elementStat.getStrParm1(), elementStat.getStrParm2());
            }
        }
        return string2;
    }

    public String getOLUserString(IResourceAccessor iResourceAccessor, Locale locale) {
        if (this.mOLName != null) {
            return this.mOLName;
        }
        String string = "";
        switch (this) {
            case Value: {
                string = iResourceAccessor.getOLResString("IDS_VALUE_STAT", locale);
                break;
            }
            case Count: {
                string = iResourceAccessor.getOLResString("IDS_NUM_OF_CASES_STAT", locale);
                break;
            }
            case CumCount: {
                string = iResourceAccessor.getOLResString("IDS_CUM_NUM_CASES_STAT", locale);
                break;
            }
            case Mean: {
                string = iResourceAccessor.getOLResString("IDS_MEAN_OF_VALS_STAT", locale);
                break;
            }
            case Median: {
                string = iResourceAccessor.getOLResString("IDS_MEDIAN_OF_VALS_STAT", locale);
                break;
            }
            case Mode: {
                string = iResourceAccessor.getOLResString("IDS_MODE_OF_VALS_STAT", locale);
                break;
            }
            case StdDev: {
                string = iResourceAccessor.getOLResString("IDS_STD_DEVIATION_STAT", locale);
                break;
            }
            case Variance: {
                string = iResourceAccessor.getOLResString("IDS_VARIANCE_STAT", locale);
                break;
            }
            case Minimum: {
                string = iResourceAccessor.getOLResString("IDS_MIN_VALUE_STAT", locale);
                break;
            }
            case Maximum: {
                string = iResourceAccessor.getOLResString("IDS_MAX_VALUE_STAT", locale);
                break;
            }
            case Sum: {
                string = iResourceAccessor.getOLResString("IDS_SUM_OF_VALS_STAT", locale);
                break;
            }
            case CumSum: {
                string = iResourceAccessor.getOLResString("IDS_CUM_SUM_STAT", locale);
                break;
            }
            case GMedian: {
                string = iResourceAccessor.getOLResString("IDS_GROUP_MEDIAN_STAT", locale);
                break;
            }
            case ValidN: {
                string = iResourceAccessor.getOLResString("IDS_VALID_N_STAT", locale);
                break;
            }
            case Responses: {
                string = iResourceAccessor.getOLResString("IDS_RESPONSES_STAT", locale);
                break;
            }
            case CumResponses: {
                string = iResourceAccessor.getOLResString("IDS_CUM_RESPONSES_STAT", locale);
                break;
            }
            case PctOfCases: {
                string = iResourceAccessor.getOLResString("IDS_PCT_OF_CASES_STAT", locale);
                break;
            }
            case CumPct: {
                string = iResourceAccessor.getOLResString("IDS_CUM_PCT_CASES_STAT", locale);
                break;
            }
            case PTile: {
                string = iResourceAccessor.getOLResString("IDS_PCTILE_STAT", locale);
                break;
            }
            case GPTile: {
                string = iResourceAccessor.getOLResString("IDS_GPCTILE_STAT", locale);
                break;
            }
            case NumAbove: {
                string = iResourceAccessor.getOLResString("IDS_NUM_ABOVE_STAT", locale);
                break;
            }
            case NumBelow: {
                string = iResourceAccessor.getOLResString("IDS_NUM_BELOW_STAT", locale);
                break;
            }
            case ResponsePct: {
                string = iResourceAccessor.getOLResString("IDS_RESPONSE_PCT_STAT", locale);
                break;
            }
            case CumResponsePct: {
                string = iResourceAccessor.getOLResString("IDS_CUM_RESPONSE_PCT_STAT", locale);
                break;
            }
            case PctAbove: {
                string = iResourceAccessor.getOLResString("IDS_PCT_ABOVE_STAT", locale);
                break;
            }
            case PctBelow: {
                string = iResourceAccessor.getOLResString("IDS_PCT_BELOW_STAT", locale);
                break;
            }
            case NumInside: {
                string = iResourceAccessor.getOLResString("IDS_NUM_IN_RANGE_STAT", locale);
                break;
            }
            case PctInside: {
                string = iResourceAccessor.getOLResString("IDS_PCT_IN_RANGE_STAT", locale);
                break;
            }
            case Histogram: {
                string = iResourceAccessor.getOLResString("IDS_HISTOGRAM_STAT", locale);
                break;
            }
            case HistogramPct: {
                string = iResourceAccessor.getOLResString("IDS_HISTOGRAM_PCT_STAT", locale);
                break;
            }
            case Boxplot: {
                string = iResourceAccessor.getOLResString("IDS_SCHEMA_STAT", locale);
                break;
            }
            case Dotplot: {
                string = iResourceAccessor.getOLResString("IDS_DOTPLOT_STAT", locale);
                break;
            }
        }
        this.mOLName = string;
        return string;
    }

    public String getStatLabel(IResourceAccessor iResourceAccessor, ElementStat elementStat) {
        if (this.mLabel != null) {
            return this.mLabel;
        }
        Locale locale = ComponentState.getOLangLocale();
        boolean bl = true;
        String string = "";
        switch (this) {
            case Value: {
                string = "";
                break;
            }
            case Count: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_COUNT", locale);
                break;
            }
            case CumCount: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_CUM_COUNT", locale);
                break;
            }
            case Mean: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_MEAN", locale);
                break;
            }
            case Median: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_MEDIAN", locale);
                break;
            }
            case Mode: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_MODE", locale);
                break;
            }
            case StdDev: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_STDDEV", locale);
                break;
            }
            case Variance: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_VARIANCE", locale);
                break;
            }
            case Minimum: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_MINIMUM", locale);
                break;
            }
            case Maximum: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_MAXIMUM", locale);
                break;
            }
            case Sum: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_SUM", locale);
                break;
            }
            case CumSum: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_CUM_SUM", locale);
                break;
            }
            case GMedian: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_GMEDIAN", locale);
                break;
            }
            case ValidN: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_VALIDN", locale);
                break;
            }
            case PctOfCases: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_PCT", locale);
                break;
            }
            case CumPct: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_CUM_PCT", locale);
                break;
            }
            case Responses: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_RESPONSES", locale);
                break;
            }
            case CumResponses: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_CUM_RESPONSES", locale);
                break;
            }
            case ResponsePct: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_RESPONSE_PCT", locale);
                break;
            }
            case CumResponsePct: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_CUM_RESPONSE_PCT", locale);
                break;
            }
            case PTile: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_PTILE", locale);
                string = string + " " + elementStat.getStrParm1();
                bl = false;
                break;
            }
            case GPTile: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_GPTILE", locale);
                string = string + " " + elementStat.getStrParm1();
                bl = false;
                break;
            }
            case NumAbove: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_NGT", locale);
                string = string + " " + elementStat.getStrParm1();
                bl = false;
                break;
            }
            case NumBelow: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_NLT", locale);
                string = string + " " + elementStat.getStrParm1();
                bl = false;
                break;
            }
            case PctAbove: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_PGT", locale);
                string = string + " " + elementStat.getStrParm1();
                bl = false;
                break;
            }
            case PctBelow: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_PLT", locale);
                string = string + " " + elementStat.getStrParm1();
                bl = false;
                break;
            }
            case NumInside: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_NIN", locale);
                string = string + " (" + elementStat.getStrParm1() + "," + elementStat.getStrParm2() + ")";
                bl = false;
                break;
            }
            case PctInside: {
                string = iResourceAccessor.getOLResString("IDS_LABEL_PIN", locale);
                string = string + " (" + elementStat.getStrParm1() + "," + elementStat.getStrParm2() + ")";
                bl = false;
                break;
            }
            case Histogram: {
                string = iResourceAccessor.getOLResString("IDS_FREQUENCY", locale);
                break;
            }
            case HistogramPct: {
                string = iResourceAccessor.getOLResString("IDS_HISTOGRAM_PCT_LABEL", locale);
                break;
            }
            case Boxplot: {
                string = "";
                break;
            }
            case Dotplot: {
                string = "";
                break;
            }
        }
        if (bl) {
            this.mLabel = string;
        }
        return string;
    }

    public String getSyntaxString() {
        String string = "";
        switch (this) {
            case Count: 
            case CumCount: 
            case PctOfCases: 
            case CumPct: {
                string = "COUNT";
                break;
            }
            case Mean: {
                string = "MEAN";
                break;
            }
            case Median: {
                string = "MEDIAN";
                break;
            }
            case Mode: {
                string = "MODE";
                break;
            }
            case StdDev: {
                string = "STDDEV";
                break;
            }
            case Variance: {
                string = "VARIANCE";
                break;
            }
            case Minimum: {
                string = "MINIMUM";
                break;
            }
            case Maximum: {
                string = "MAXIMUM";
                break;
            }
            case Sum: 
            case CumSum: {
                string = "SUM";
                break;
            }
            case GMedian: {
                string = "GMEDIAN";
                break;
            }
            case ValidN: {
                string = "VALIDN";
                break;
            }
            case Responses: 
            case CumResponses: 
            case ResponsePct: 
            case CumResponsePct: {
                string = "RESPONSES";
                break;
            }
            case PTile: {
                string = "PTILE";
                break;
            }
            case GPTile: {
                string = "GPTILE";
                break;
            }
            case NumAbove: {
                string = "NGT";
                break;
            }
            case NumBelow: {
                string = "NLT";
                break;
            }
            case PctAbove: {
                string = "PGT";
                break;
            }
            case PctBelow: {
                string = "PLT";
                break;
            }
            case NumInside: {
                string = "NIN";
                break;
            }
            case PctInside: {
                string = "PIN";
                break;
            }
        }
        return string;
    }
}

