/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ICanvasChangeListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.IGroups;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.doc_util.ThinBeveledBorder;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class GroupsFrontPanel
extends JPanel
implements ICanvasChangeListener {
    private BaseDialog mParent;
    private ChartCanvas mCanvas;
    private JCheckBox mXClusterCheck;
    private JCheckBox mZClusterCheck;
    private JCheckBox mGroupingCheck;
    private JCheckBox mHPanelCheck;
    private JCheckBox mVPanelCheck;
    private JCheckBox mPointIdCheck;
    private GroupsAction mXClusterAction;
    private GroupsAction mZClusterAction;
    private GroupsAction mGroupingAction;
    private GroupsAction mHPanelAction;
    private GroupsAction mVPanelAction;
    private GroupsAction mPointIdAction;

    public GroupsFrontPanel(BaseDialog baseDialog, ChartCanvas chartCanvas) {
        super(new GridBagLayout(), true);
        this.mParent = baseDialog;
        this.mCanvas = chartCanvas;
        this.init();
        this.mCanvas.addChangeListener(this);
    }

    @Override
    public void canvasChange(CanvasChangeEvent canvasChangeEvent) {
        this.updateCheckboxes();
    }

    private void updateCheckboxes() {
        Coords coords = this.mCanvas.getImager().getCoordinates();
        Elements elements = this.mCanvas.getImager().getPrimaryElementType();
        boolean bl = this.mCanvas.getImager().hasErrorBars();
        boolean bl2 = this.mCanvas.getImager().dataElementCount() > 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (elements != null) {
            boolean bl9;
            boolean bl10 = this.mCanvas.getZoneMgr().hasScaleVar(ZoneType.zt_x);
            boolean bl11 = this.mCanvas.getZoneMgr().hasScaleVar(ZoneType.zt_z);
            boolean bl12 = bl9 = coords == Coords.coords_DualY;
            if (elements == Elements.area) {
                bl3 = true;
                bl4 = true;
                if (!bl9 && !this.mCanvas.hasDateOnY()) {
                    bl7 = true;
                }
            } else if (elements == Elements.diff_area) {
                bl3 = true;
                bl4 = true;
            } else if (elements == Elements.hilo) {
                bl3 = true;
                bl4 = true;
                if (!bl10) {
                    bl5 = true;
                }
            } else if (elements == Elements.interval) {
                bl3 = true;
                bl4 = true;
                boolean bl13 = this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_group);
                boolean bl14 = this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_cluster_x);
                boolean bl15 = this.mCanvas.hasDateOnY();
                if (coords == Coords.coords_2D) {
                    if (!(bl13 || bl10 || bl9 || this.mCanvas.getImager().isHistogram())) {
                        bl5 = true;
                    }
                    if (!(bl14 || bl9 || bl15)) {
                        bl7 = true;
                    }
                } else {
                    boolean bl16 = this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_cluster_z);
                    if (!(bl10 || bl13 && bl16)) {
                        boolean bl17 = bl5 = !bl9;
                    }
                    if (!(bl11 || bl13 && bl14)) {
                        boolean bl18 = bl6 = !bl9;
                    }
                    if (!bl14 || !bl16) {
                        bl7 = !bl9 && !bl15;
                    }
                }
            } else if (elements == Elements.line) {
                bl3 = true;
                bl4 = true;
                if (!bl9) {
                    bl7 = true;
                }
            } else if (elements == Elements.point) {
                bl3 = true;
                bl4 = true;
                if (!bl9) {
                    if (coords == Coords.coords_2D && !bl10 && bl) {
                        bl5 = true;
                    } else {
                        bl7 = true;
                    }
                }
                if (coords != Coords.coords_1D) {
                    bl8 = this.mCanvas.getImager().getPrimaryStatistic() == Statistics.Value;
                }
            } else if (elements == Elements.polar_interval) {
                bl3 = true;
                bl4 = true;
            } else if (elements == Elements.pyramid) {
                bl3 = true;
            } else if (elements == Elements.schema) {
                bl3 = true;
                bl4 = true;
                bl8 = true;
                if (coords == Coords.coords_2D && !bl10) {
                    bl5 = true;
                }
            } else if (elements == Elements.splom) {
                bl7 = true;
                boolean bl19 = bl8 = this.mCanvas.getImager().getPrimaryStatistic() == Statistics.Value;
            }
        }
        if (bl5 && bl2) {
            this.mXClusterAction.setEnabled(true);
            this.mXClusterCheck.setSelected(this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_cluster_x));
        } else {
            this.mXClusterAction.setEnabled(false);
            this.mXClusterCheck.setSelected(false);
        }
        if (bl6 && bl2) {
            this.mZClusterAction.setEnabled(true);
            this.mZClusterCheck.setSelected(this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_cluster_z));
        } else {
            this.mZClusterAction.setEnabled(false);
            this.mZClusterCheck.setSelected(false);
        }
        if (bl7 && bl2) {
            this.mGroupingAction.setEnabled(true);
            this.mGroupingCheck.setSelected(this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_group));
        } else {
            this.mGroupingAction.setEnabled(false);
            this.mGroupingCheck.setSelected(false);
        }
        if (bl3 && bl2) {
            this.mHPanelAction.setEnabled(true);
            this.mHPanelCheck.setSelected(this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_panel_vert));
        } else {
            this.mHPanelAction.setEnabled(false);
            this.mHPanelCheck.setSelected(false);
        }
        if (bl4 && bl2) {
            this.mVPanelAction.setEnabled(true);
            this.mVPanelCheck.setSelected(this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_panel_horz));
        } else {
            this.mVPanelAction.setEnabled(false);
            this.mVPanelCheck.setSelected(false);
        }
        if (bl8) {
            this.mPointIdAction.setEnabled(true);
            this.mPointIdCheck.setSelected(this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_point_id));
        } else {
            this.mPointIdAction.setEnabled(false);
            this.mPointIdCheck.setSelected(false);
        }
    }

    private void init() {
        JTextArea jTextArea = new JTextArea(this.mParent.getResString("IDS_GROUPS_TAB_INFO"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.left = DialogUtil.getStandardDialogInsets().left;
        insets.top = 3;
        insets.bottom = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(this, jTextArea, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinBeveledBorder thinBeveledBorder = new ThinBeveledBorder(uIDefaults.getColor("ToolBar.highlight"), uIDefaults.getColor("ToolBar.shadow"), 1);
        jPanel.setBorder(thinBeveledBorder);
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.top += n + 2;
        insets.left += n;
        this.mXClusterAction = new GroupsAction(IGroups.GroupType.cluster_X);
        this.mXClusterCheck = new JCheckBox(this.mXClusterAction);
        DialogUtil.addUsingGBL(jPanel, this.mXClusterCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.top -= n;
        this.mZClusterAction = new GroupsAction(IGroups.GroupType.cluster_Z);
        this.mZClusterCheck = new JCheckBox(this.mZClusterAction);
        DialogUtil.addUsingGBL(jPanel, this.mZClusterCheck, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.mGroupingAction = new GroupsAction(IGroups.GroupType.groupStack);
        this.mGroupingCheck = new JCheckBox(this.mGroupingAction);
        DialogUtil.addUsingGBL(jPanel, this.mGroupingCheck, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        this.mHPanelAction = new GroupsAction(IGroups.GroupType.rowsPanel);
        this.mHPanelCheck = new JCheckBox(this.mHPanelAction);
        DialogUtil.addUsingGBL(jPanel, this.mHPanelCheck, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        this.mVPanelAction = new GroupsAction(IGroups.GroupType.columnsPanel);
        this.mVPanelCheck = new JCheckBox(this.mVPanelAction);
        DialogUtil.addUsingGBL(jPanel, this.mVPanelCheck, gridBagConstraints, 0, 4, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        insets.bottom += n;
        this.mPointIdAction = new GroupsAction(IGroups.GroupType.pointId);
        this.mPointIdCheck = new JCheckBox(this.mPointIdAction);
        DialogUtil.addUsingGBL(jPanel, this.mPointIdCheck, gridBagConstraints, 0, 5, 1, 1, n2, insets);
        gridBagConstraints.fill = 1;
        insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        insets.top = 5;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
    }

    class GroupsAction
    extends AbstractAction {
        IGroups.GroupType mType;

        GroupsAction(IGroups.GroupType groupType) {
            Integer n;
            String string;
            this.mType = groupType;
            if (this.mType.equals((Object)IGroups.GroupType.cluster_X)) {
                string = GroupsFrontPanel.this.mParent.getResString("IDS_CLUSTER_VAR_X");
                n = GroupsFrontPanel.this.mParent.getDlgAccessKey("IDK_CLUSTER_X_KEY");
            } else if (this.mType.equals((Object)IGroups.GroupType.cluster_Z)) {
                string = GroupsFrontPanel.this.mParent.getResString("IDS_CLUSTER_VAR_Z");
                n = GroupsFrontPanel.this.mParent.getDlgAccessKey("IDK_CLUSTER_Z_KEY");
            } else if (this.mType.equals((Object)IGroups.GroupType.groupStack)) {
                string = GroupsFrontPanel.this.mParent.getResString("IDS_GROUP_STACK");
                n = GroupsFrontPanel.this.mParent.getDlgAccessKey("IDK_GROUP_STACK");
            } else if (this.mType.equals((Object)IGroups.GroupType.rowsPanel)) {
                string = GroupsFrontPanel.this.mParent.getResString("IDS_ROWS_PANEL_VAR");
                n = GroupsFrontPanel.this.mParent.getDlgAccessKey("IDK_ROWS_PANEL_KEY");
            } else if (this.mType.equals((Object)IGroups.GroupType.columnsPanel)) {
                string = GroupsFrontPanel.this.mParent.getResString("IDS_COLS_PANEL");
                n = GroupsFrontPanel.this.mParent.getDlgAccessKey("IDK_COLS_PANEL_KEY");
            } else if (this.mType.equals((Object)IGroups.GroupType.pointId)) {
                string = GroupsFrontPanel.this.mParent.getResString("IDS_POINT_ID");
                n = GroupsFrontPanel.this.mParent.getDlgAccessKey("IDK_POINT_ID_KEY");
            } else {
                assert (false);
                return;
            }
            this.putValue("Name", string);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ZoneType zoneType;
            boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
            if (this.mType.equals((Object)IGroups.GroupType.cluster_X)) {
                zoneType = ZoneType.zt_cluster_x;
            } else if (this.mType.equals((Object)IGroups.GroupType.cluster_Z)) {
                zoneType = ZoneType.zt_cluster_z;
            } else if (this.mType.equals((Object)IGroups.GroupType.groupStack)) {
                zoneType = ZoneType.zt_group;
            } else if (this.mType.equals((Object)IGroups.GroupType.rowsPanel)) {
                zoneType = ZoneType.zt_panel_vert;
            } else if (this.mType.equals((Object)IGroups.GroupType.columnsPanel)) {
                zoneType = ZoneType.zt_panel_horz;
            } else if (this.mType.equals((Object)IGroups.GroupType.pointId)) {
                zoneType = ZoneType.zt_point_id;
            } else {
                return;
            }
            if (bl) {
                GroupsFrontPanel.this.mCanvas.addZone(zoneType);
            } else {
                GroupsFrontPanel.this.mCanvas.removeZone(zoneType);
            }
            GroupsFrontPanel.this.mCanvas.recalcLayout();
            GroupsFrontPanel.this.canvasChange(new CanvasChangeEvent(GroupsFrontPanel.this.mCanvas, CanvasChangeEvent.ChangeType.variableChange));
        }
    }
}

