/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.icon_view.IconViewer;
import com.spss.java_client.ui.controls.icon_view.IconViewerActionListener;
import com.spss.java_client.ui.controls.icon_view.IconViewerItem;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartLib;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartPrototype;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ElementDragAdapter;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.IChart;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.GalleryNamesDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GalleryFrontPanel
extends JPanel
implements IChart,
ListSelectionListener,
IconViewerActionListener {
    private static final String DELETE_ACTION_KEY = "deleteChart";
    private ChartBuilderDlg mMainParent;
    private JList mGroupsList;
    private GalleryList mChartsList;
    private ChartLib mChartLib;
    private ChartLib mCustomLib;
    private JScrollPane mChartsScrollPane;

    public GalleryFrontPanel(ChartBuilderDlg chartBuilderDlg) {
        super(new GridBagLayout(), true);
        this.mMainParent = chartBuilderDlg;
        this.init();
        this.loadChartLibraries();
        this.mChartsList.addActionListener(this);
        this.mChartsList.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), DELETE_ACTION_KEY);
        this.mChartsList.getActionMap().put(DELETE_ACTION_KEY, new DeleteChartAction());
    }

    public void close() {
        if (this.mChartLib != null) {
            this.mChartLib.save();
        }
        if (this.mCustomLib != null) {
            this.mCustomLib.save();
        }
        this.mChartsList.cleanup();
    }

    public int getActiveGroupIndex() {
        return this.mGroupsList.getSelectedIndex();
    }

    public void setActiveGroupIndex(int n) {
        if (n > -1 && n < this.mGroupsList.getModel().getSize()) {
            this.mGroupsList.setSelectedIndex(n);
        }
    }

    public void addToFavorites(ChartPrototype chartPrototype) {
        this.mCustomLib.add(chartPrototype);
        if (this.getActiveGroupIndex() != 0) {
            this.setActiveGroupIndex(0);
        } else {
            this.selectChartGroup(0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle rectangle = GalleryFrontPanel.this.mChartsList.getBounds();
                rectangle.y = rectangle.y + rectangle.height - 64;
                rectangle.height = 64;
                GalleryFrontPanel.this.mChartsList.scrollRectToVisible(rectangle);
            }
        });
    }

    @Override
    public void updateUI() {
        if (this.mGroupsList != null) {
            this.mGroupsList.removeListSelectionListener(this);
        }
        super.updateUI();
        if (this.mGroupsList != null) {
            this.mGroupsList.addListSelectionListener(this);
        }
    }

    @Override
    public void itemChosen(IconViewerItem iconViewerItem) {
        this.mMainParent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.mMainParent.getCanvas().dropGalleryChart((ChartPrototype)iconViewerItem.getUserData());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mMainParent.setCursor(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.selectChartGroup(this.mGroupsList.getAnchorSelectionIndex());
    }

    private void loadChartLibraries() {
        boolean bl = false;
        try {
            this.mChartLib = new ChartLib();
            boolean bl2 = this.mChartLib.load();
            String string = System.getProperty("user.home.spss") + File.separatorChar + ChartLib.getCustomLibFileName();
            this.mCustomLib = new ChartLib(string, true);
            this.mCustomLib.load();
            if (bl2) {
                int n = this.mCustomLib.size() > 0 ? 0 : 1;
                this.mGroupsList.setSelectedIndex(n);
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl) {
            // empty if block
        }
    }

    private void selectChartGroup(int n) {
        Object e = this.mGroupsList.getModel().getElementAt(n);
        if (e instanceof GroupItem) {
            this.mMainParent.setCursor(Cursor.getPredefinedCursor(3));
            try {
                int n2 = 0;
                GroupItem groupItem = (GroupItem)e;
                Vector<ChartPrototype> vector = new Vector<ChartPrototype>();
                if (groupItem.getGroupId() == 32768) {
                    this.mCustomLib.getPrototypes(-1, vector);
                } else {
                    this.mChartLib.getPrototypes(groupItem.getGroupId(), vector);
                }
                this.mChartsList.removeAllItems();
                for (ChartPrototype chartPrototype : vector) {
                    this.mChartsList.addItem(new IconViewerItem(n2++, new ImageIcon(chartPrototype.getImage()), null, chartPrototype.getTitle(), chartPrototype));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.mMainParent.setCursor(null);
            this.mChartsList.setSelectedItem(0);
            this.mChartsList.validate();
            this.mChartsScrollPane.revalidate();
            this.mChartsList.repaint();
        }
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        Insets insets2 = new Insets(2, insets.left, 0, insets.right);
        JLabel jLabel = new JLabel(this.mMainParent.getResString("IDS_CHOOSE_FROM"));
        jLabel.setDisplayedMnemonic(this.mMainParent.getDlgAccessKey("IDS_CHOOSE_FROM_KEY"));
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        GroupItem[] groupItemArray = new GroupItem[]{new GroupItem(32768, this.mMainParent.getResString("IDS_FAVORITES")), new GroupItem(1, this.mMainParent.getResString("IDS_BAR")), new GroupItem(2, this.mMainParent.getResString("IDS_LINE")), new GroupItem(4, this.mMainParent.getResString("IDS_AREA")), new GroupItem(8, this.mMainParent.getResString("IDS_PIE_POLAR")), new GroupItem(16, this.mMainParent.getResString("IDS_SCATTER_DOT")), new GroupItem(512, this.mMainParent.getResString("IDS_HISTOGRAM")), new GroupItem(128, this.mMainParent.getResString("IDS_HI_LO")), new GroupItem(256, this.mMainParent.getResString("IDS_SCHEMA")), new GroupItem(1024, this.mMainParent.getResString("IDS_DUAL_AXES"))};
        LineBorder lineBorder = new LineBorder(new Color(0, 128, 128));
        EmptyBorder emptyBorder = new EmptyBorder(1, 1, 1, 1);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        this.mGroupsList = new JList<GroupItem>(groupItemArray);
        this.mGroupsList.setBorder(compoundBorder);
        this.mGroupsList.setSelectionMode(0);
        this.mGroupsList.addListSelectionListener(this);
        this.mGroupsList.setCellRenderer(new CustomVarListCellRenderer());
        jLabel.setLabelFor(this.mGroupsList);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        n = 23;
        insets2 = new Insets(1, insets.left, insets.bottom, 3);
        DialogUtil.addUsingGBL(this, this.mGroupsList, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mChartsList = new GalleryList();
        this.mChartsList.setName(this.mMainParent.getResString("IDS_CHOOSE_FROM"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        insets2 = new Insets(1, 3, insets.bottom, insets.right);
        this.mChartsScrollPane = new JScrollPane(this.mChartsList);
        DialogUtil.addUsingGBL(this, this.mChartsScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        Rectangle rectangle = this.mGroupsList.getCellBounds(0, 0);
        int n2 = rectangle.height * groupItemArray.length + 2;
        DragPane dragPane = (DragPane)this.mMainParent.getGlassPane();
        ElementDragAdapter elementDragAdapter = new ElementDragAdapter(ElementDragAdapter.DragSrcType.gallery, dragPane, "Gallery");
        this.mChartsList.setDragAdapter(elementDragAdapter);
        this.mChartsScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GalleryFrontPanel.this.mChartsList.invalidate();
            }
        });
    }

    class EditChartsAction
    extends AbstractAction {
        EditChartsAction() {
            this.putValue("Name", GalleryFrontPanel.this.mMainParent.getResString("IDS_EDIT_NAMES"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GalleryNamesDlg galleryNamesDlg = new GalleryNamesDlg(GalleryFrontPanel.this.mMainParent, GalleryFrontPanel.this.mChartLib);
            galleryNamesDlg.setVisible(true);
            GalleryFrontPanel.this.selectChartGroup(GalleryFrontPanel.this.mGroupsList.getSelectedIndex());
        }
    }

    class DeleteChartAction
    extends AbstractAction {
        private IconViewerItem mItem;

        public DeleteChartAction() {
            this.mItem = null;
            this.putValue("Name", GalleryFrontPanel.this.mMainParent.getResString("IDS_DEL_FROM_FAVS"));
        }

        public DeleteChartAction(IconViewerItem iconViewerItem) {
            this.mItem = iconViewerItem;
            this.putValue("Name", GalleryFrontPanel.this.mMainParent.getResString("IDS_DEL_FROM_FAVS"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.mItem == null) {
                this.mItem = GalleryFrontPanel.this.mChartsList.getSelectedItem();
            }
            if (this.mItem == null) {
                return;
            }
            String string = GalleryFrontPanel.this.mMainParent.getResString("ERR_DEL_CONFIRM_MSG");
            String string2 = VersionInfo.getAppVersionString();
            ChartPrototype chartPrototype = (ChartPrototype)this.mItem.getUserData();
            String string3 = String.format(string, chartPrototype.getTitle());
            int n = SpssAlertOptionPane.showConfirmDialog(GalleryFrontPanel.this, string3, string2, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n == 0) {
                ChartLib chartLib = chartPrototype.isCustomChart() ? GalleryFrontPanel.this.mCustomLib : GalleryFrontPanel.this.mChartLib;
                chartLib.remove(chartPrototype);
                GalleryFrontPanel.this.mChartsList.removeItem(this.mItem);
                GalleryFrontPanel.this.mChartsList.validate();
                GalleryFrontPanel.this.mChartsList.repaint(100L);
            }
            this.mItem = null;
        }
    }

    class CopyChartAction
    extends AbstractAction {
        private IconViewerItem mItem;

        public CopyChartAction(IconViewerItem iconViewerItem) {
            this.mItem = iconViewerItem;
            this.putValue("Name", GalleryFrontPanel.this.mMainParent.getResString("IDS_COPY_TO_CANVAS"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GalleryFrontPanel.this.mChartsList.fireActionEvent(this.mItem);
        }
    }

    class GroupItem {
        private int mGroupId;
        private String mName;

        GroupItem(int n, String string) {
            this.mGroupId = n;
            this.mName = string;
        }

        public int getGroupId() {
            return this.mGroupId;
        }

        public String toString() {
            return this.mName;
        }
    }

    class GalleryList
    extends IconViewer {
        GalleryList() {
        }

        @Override
        public void doContextMenu(IconViewerItem iconViewerItem, Point point, int n, boolean bl) {
            boolean bl2;
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new CopyChartAction(iconViewerItem));
            DeleteChartAction deleteChartAction = new DeleteChartAction(iconViewerItem);
            jPopupMenu.add(deleteChartAction);
            ChartPrototype chartPrototype = (ChartPrototype)iconViewerItem.getUserData();
            deleteChartAction.setEnabled(chartPrototype.isCustomChart() || bl && (n & 0x40) != 0);
            int n2 = 704;
            boolean bl3 = bl2 = (n & n2) == n2;
            if (bl2) {
                jPopupMenu.add(new EditChartsAction());
            }
            jPopupMenu.addSeparator();
            jPopupMenu.add(ResUtil.getCommonDlgString("IDS_CANCEL"));
            jPopupMenu.show(this, point.x, point.y);
        }
    }
}

