/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.charteditor.util.AccessibilityUtil;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.SpssVLMapId;
import com.spss.java_client.core.documents.data.dictionary.value_labels.ValueLabelMap;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.IndexVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.res.IResourceAccessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.Bidi;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DropZone {
    public static final int MARGIN_LEFT = 60;
    public static final int MARGIN_TOP = 40;
    public static final int MARGIN_RIGHT = 120;
    public static final int MARGIN_BOTTOM = 45;
    protected final int HORZ_HEIGHT = 31;
    protected final int VERT_WIDTH = 35;
    protected final int HORZ_WIDTH = 130;
    protected static Stroke sStandardStroke = null;
    protected static Stroke sHiliteStroke = null;
    protected static Stroke sSpecialHiliteStroke = null;
    private static float[] sFocusDash1 = new float[]{1.0f};
    private static BasicStroke sFocusStroke = new BasicStroke(1.0f, 0, 0, 1.0f, sFocusDash1, 0.0f);
    private static Color sHighlightColor = new Color(128, 0, 0);
    protected static Color sHighlight2Color = new Color(249, 184, 38);
    private static String sIndexVarName = null;
    private static boolean sShowRoleStats = false;
    protected ZoneType mZoneType;
    protected Shape mBounds;
    protected boolean mHighlight;
    protected boolean mHighlight2;
    protected boolean mMultiHighlight;
    protected String mEmptyZoneText = null;
    protected Vector<ISpssVariable> mVariables = new Vector();
    protected ChartCanvas mCanvas = null;
    protected boolean mFocused;
    protected Font mZoneFont = null;
    protected boolean mTransposed;
    protected boolean mUsesColorStyling;
    protected String mColorStyleString = "";
    protected IResourceAccessor mResources;
    private int mClickDelta = -1;

    public DropZone(ChartCanvas chartCanvas, ZoneType zoneType, IResourceAccessor iResourceAccessor) {
        this.mCanvas = chartCanvas;
        this.mZoneType = zoneType;
        this.mBounds = null;
        this.mHighlight = false;
        this.mHighlight2 = false;
        this.mMultiHighlight = false;
        this.mFocused = false;
        this.mTransposed = false;
        this.mUsesColorStyling = true;
        this.mResources = iResourceAccessor;
        if (sStandardStroke == null) {
            DropZone.initBorders();
        }
        if (sIndexVarName == null) {
            sIndexVarName = iResourceAccessor.getResString("IDS_INDEX");
        }
    }

    public static void setRoleStatDisplay(boolean bl) {
        sShowRoleStats = bl;
    }

    public static boolean getRoleStatDisplay() {
        return sShowRoleStats;
    }

    public boolean pointWithin(Point point) {
        return this.mBounds != null && this.mBounds.contains(point);
    }

    public ZoneType getZoneType() {
        return this.mZoneType;
    }

    public void setZoneType(ZoneType zoneType) {
        this.mZoneType = zoneType;
        this.loadZoneText(this.mResources);
    }

    public boolean isFocused() {
        return this.mFocused;
    }

    public void setFocused(boolean bl) {
        boolean bl2 = this.mFocused != bl;
        this.mFocused = bl;
        if (bl2 && this.mBounds != null) {
            this.mCanvas.paintImmediately(this.mBounds.getBounds());
        }
        if (bl2 && this.mFocused) {
            this.setAccessibleText();
        }
    }

    private void setAccessibleText() {
        String string;
        String string2 = "";
        String string3 = this.getZoneText();
        if (string3 != null && (string = this.getZoneTypeText(this.mResources)) != null) {
            string = string.substring(0, string.length() - 1);
            string2 = string + ":" + string3;
        }
        AccessibilityUtil.setAccessibleText((Component)((Object)this.mCanvas), (Object)string2);
    }

    public boolean getHighlight() {
        return this.mHighlight;
    }

    public void setHighlight(boolean bl, boolean bl2) {
        boolean bl3 = this.mHighlight != bl || this.mMultiHighlight != bl2;
        this.mHighlight = bl;
        this.mMultiHighlight = bl2;
        if (bl3 && this.mBounds != null) {
            this.mCanvas.paintImmediately(this.mBounds.getBounds());
        }
    }

    public void setHighlight2(boolean bl) {
        boolean bl2 = this.mHighlight2 != bl;
        this.mHighlight2 = bl;
        if (bl2 && this.mBounds != null) {
            this.mCanvas.paintImmediately(this.mBounds.getBounds());
        }
    }

    public boolean hasMultiHighlight() {
        return this.mMultiHighlight;
    }

    public Shape getBounds() {
        if (this.mBounds == null) {
            this.setBounds(this.mCanvas);
        }
        return this.mBounds;
    }

    public void setBounds(ChartCanvas chartCanvas) {
        if (this.mZoneType.equals((Object)ZoneType.zt_x) || this.mZoneType.equals((Object)ZoneType.zt_slice_by)) {
            this.setXBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_angle) || this.mZoneType.equals((Object)ZoneType.zt_y)) {
            this.setYBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_y2)) {
            this.setY2Bounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_low)) {
            this.setLowBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_high)) {
            this.setHighBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_close)) {
            this.setCloseBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_z)) {
            this.setZBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_point_id)) {
            this.setPointIdBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_cluster_x) || this.mZoneType.equals((Object)ZoneType.zt_cluster_z) || this.mZoneType.equals((Object)ZoneType.zt_group)) {
            this.setGroupZoneBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_panel_horz)) {
            this.setHorzPanelBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_panel_vert)) {
            this.setVertPanelBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_dist_var)) {
            if (this.mTransposed) {
                this.setXBounds();
            } else {
                this.setYBounds();
            }
        } else if (this.mZoneType.equals((Object)ZoneType.zt_split_var)) {
            this.setSplitBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_matrix)) {
            this.setXBounds();
        } else if (this.mZoneType.equals((Object)ZoneType.zt_filter)) {
            this.setVertFilterBounds();
        } else assert (false);
    }

    public void setTranspose(boolean bl) {
        this.mTransposed = bl;
    }

    public void render(Graphics2D graphics2D, Locale locale) {
        this.render(graphics2D, true, locale);
    }

    public void render(Graphics2D graphics2D, boolean bl, Locale locale) {
        if (this.mBounds == null) {
            return;
        }
        if (this.mZoneFont == null) {
            this.createZoneFont();
        }
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        graphics2D.setColor(Color.white);
        graphics2D.fill(this.mBounds);
        this.renderBorder(graphics2D);
        if (this.mMultiHighlight) {
            this.drawMultiHighlight(graphics2D);
        }
        graphics2D.setFont(this.mZoneFont);
        this.renderContents(graphics2D, locale);
        if (bl && this.isFocused() && this.mCanvas.isFocusOwner()) {
            this.renderFocus(graphics2D);
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    public boolean isEmpty() {
        return this.mVariables.size() == 0;
    }

    public boolean canDrop(ISpssVariable[] iSpssVariableArray) {
        if (iSpssVariableArray == null || iSpssVariableArray.length == 0) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        ZoneType zoneType = (this.mZoneType == ZoneType.zt_filter || this.mZoneType == ZoneType.zt_matrix) && !this.mCanvas.isDeserializing() ? null : this.mZoneType;
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            MeasurementLevel measurementLevel;
            if (this.mCanvas.getZoneMgr().hasVarInZone(iSpssVariable, zoneType)) {
                if (this.isPanelZone()) {
                    return false;
                }
                if (this.mCanvas.getZoneMgr().hasVarInPanelZone(iSpssVariable)) {
                    return false;
                }
                if (this.mZoneType == ZoneType.zt_matrix) {
                    return false;
                }
            }
            if ((measurementLevel = iSpssVariable.getDisplayMeasurementLevel()).equals((Object)MeasurementLevel.scale) || measurementLevel.equals((Object)MeasurementLevel.unknown)) {
                bl = true;
            } else {
                bl2 = true;
            }
            if (iSpssVariable instanceof SpssMRVariable) {
                bl3 = true;
            }
            if (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) {
                bl4 = true;
            }
            if (iSpssVariable.getValueLabels().size() != 0) continue;
            bl5 = false;
        }
        if (this.mZoneType == ZoneType.zt_filter && !bl5) {
            return false;
        }
        boolean bl6 = iSpssVariableArray.length == 1;
        int n = this.mCanvas.getImager().isSchema() ? 1 : 0;
        int n2 = this.mCanvas.getImager().isHiLoClose() ? 1 : 0;
        boolean bl7 = this.mCanvas.getImager().isDifferenceArea();
        boolean bl8 = this.mCanvas.getImager().isPopulationPyramid();
        boolean bl9 = this.mCanvas.getImager().isOverlayScatter();
        boolean bl10 = this.mCanvas.getImager().hasSSVs();
        Coords coords = this.mCanvas.getImager().getCoordinates();
        if (coords.equals((Object)Coords.coords_DualY) && (!bl6 || bl2 && (this.mZoneType.equals((Object)ZoneType.zt_y) || this.mZoneType.equals((Object)ZoneType.zt_y2)))) {
            return false;
        }
        if (bl && (this.isStyleByZone() || this.isPanelZone())) {
            return false;
        }
        if (coords.equals((Object)Coords.coords_Polar) && (bl4 || bl2) && this.mZoneType.equals((Object)ZoneType.zt_angle)) {
            return false;
        }
        if (coords.equals((Object)Coords.coords_1D)) {
            if (n != 0 && (!bl6 || bl2 && this.mZoneType.equals((Object)ZoneType.zt_x))) {
                return false;
            }
            if (bl3 && this.mZoneType.equals((Object)ZoneType.zt_x)) {
                return false;
            }
        }
        if (coords.equals((Object)Coords.coords_2D) && n != 0 && (!bl6 || (bl || bl3) && this.mZoneType.equals((Object)ZoneType.zt_x) || bl2 && this.mZoneType.equals((Object)ZoneType.zt_y))) {
            return false;
        }
        if (coords.equals((Object)Coords.coords_2D) || coords.equals((Object)Coords.coords_3D)) {
            if (bl3 && this.mZoneType.equals((Object)ZoneType.zt_y)) {
                return false;
            }
            if (bl4 && this.mZoneType.equals((Object)ZoneType.zt_y)) {
                boolean bl11;
                Elements elements = this.mCanvas.getImager().getPrimaryElementType();
                boolean bl12 = bl11 = elements == Elements.point || elements == Elements.line;
                if (!bl11 && this.mCanvas.getImager().hasGrouping()) {
                    return false;
                }
            }
        }
        if (bl8 && (!bl6 || bl && this.mZoneType.equals((Object)ZoneType.zt_split_var))) {
            return false;
        }
        if (this.mCanvas.getImager().isSplom() && bl2 && this.mZoneType.equals((Object)ZoneType.zt_matrix)) {
            return false;
        }
        if ((n2 != 0 || bl7) && !this.isPanelZone()) {
            return bl6 && bl && (this.mZoneType.equals((Object)ZoneType.zt_low) || this.mZoneType.equals((Object)ZoneType.zt_high) || this.mZoneType.equals((Object)ZoneType.zt_close)) || this.mZoneType.equals((Object)ZoneType.zt_x) || bl2 && this.mZoneType.equals((Object)ZoneType.zt_cluster_x);
        }
        if (bl9) {
            return this.mZoneType != ZoneType.zt_group && (!bl2 || this.mZoneType != ZoneType.zt_x && this.mZoneType != ZoneType.zt_y);
        }
        if (bl10 && (this.mZoneType == ZoneType.zt_y || this.mZoneType == ZoneType.zt_angle)) {
            return !bl2;
        }
        return bl6 || !bl2 && (this.mZoneType == ZoneType.zt_y || this.mZoneType == ZoneType.zt_angle || bl9 && this.mZoneType == ZoneType.zt_x || this.mZoneType == ZoneType.zt_matrix);
    }

    public boolean pointInMultiVarArea(Point point) {
        boolean bl = this.verticalZone();
        Rectangle rectangle = this.getBounds().getBounds();
        if (bl) {
            rectangle.height = (int)((double)rectangle.height * 0.5);
        } else {
            rectangle.width = (int)((double)rectangle.width * 0.5);
        }
        return rectangle.contains(point);
    }

    public boolean isStyleByZone() {
        return this.mZoneType.equals((Object)ZoneType.zt_cluster_x) || this.mZoneType.equals((Object)ZoneType.zt_cluster_z) || this.mZoneType.equals((Object)ZoneType.zt_group) || this.mZoneType.equals((Object)ZoneType.zt_slice_by);
    }

    public boolean isPanelZone() {
        return this.mZoneType.equals((Object)ZoneType.zt_panel_horz) || this.mZoneType.equals((Object)ZoneType.zt_panel_vert) || this.mZoneType.equals((Object)ZoneType.zt_filter);
    }

    public void setUsesColorStyling(boolean bl) {
        if (this.isStyleByZone()) {
            this.mUsesColorStyling = bl;
            this.mColorStyleString = this.showArrangement() ? this.mResources.getResString(bl ? "IDS_SET_COLOR" : "IDS_SET_PATTERN") : this.mResources.getResString(bl ? "IDS_SET_COLOR_CAP" : "IDS_SET_PATTERN_CAP");
        } else assert (false);
    }

    public boolean getUsesColorStyling() {
        return this.isStyleByZone() && this.mUsesColorStyling;
    }

    public void dropVars(ISpssVariable[] iSpssVariableArray) {
        if (this.scaleOnCluster(iSpssVariableArray)) {
            SpssAlertOptionPane.showWarningMessageDialog((JComponent)((Object)this.mCanvas), this.mCanvas.getResources().getResString("ERR_NO_CLUSTERED_SCALE"), VersionInfo.getAppVersionString());
            return;
        }
        if (!this.mMultiHighlight) {
            this.mVariables.clear();
        }
        this.mVariables.addAll(Arrays.asList(iSpssVariableArray));
    }

    public boolean scaleOnCluster(ISpssVariable[] iSpssVariableArray) {
        boolean bl = false;
        CanvasImager canvasImager = this.mCanvas.getImager();
        if (this.mZoneType == ZoneType.zt_x && canvasImager.hasXCluster() || this.mZoneType == ZoneType.zt_z && canvasImager.hasZCluster()) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (!iSpssVariable.getDisplayMeasurementLevel().equals((Object)MeasurementLevel.scale)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean bl) {
        this.mVariables.clear();
        if (this.mBounds != null && bl) {
            this.mCanvas.paintImmediately(this.mBounds.getBounds());
        }
    }

    public String getZoneText() {
        boolean bl = this.mCanvas.getImager().isOverlayScatter();
        if (this.mZoneType == ZoneType.zt_group && bl) {
            return this.mResources.getResString("IDS_VAR_PAIRS");
        }
        if (this.isEmpty()) {
            if (this.mEmptyZoneText == null) {
                this.loadZoneText(this.mResources);
            }
            if (this.isStyleByZone()) {
                if (this.showArrangement()) {
                    return this.mEmptyZoneText + ": " + this.mColorStyleString;
                }
                if (this.mZoneType == ZoneType.zt_slice_by) {
                    return this.mEmptyZoneText;
                }
                return this.mColorStyleString;
            }
            return this.mEmptyZoneText;
        }
        boolean bl2 = this.mCanvas.getImager().hasSSVs();
        boolean bl3 = this.mCanvas.getImager().isSplom();
        String string = "";
        for (ISpssVariable iSpssVariable : this.mVariables) {
            if (string.length() > 0) {
                string = string + (bl3 || bl || bl2 || this.mZoneType == ZoneType.zt_filter ? "; " : "\n");
            }
            string = string + (iSpssVariable.getLabel().length() > 0 ? iSpssVariable.getLabel() : iSpssVariable.getName());
        }
        return string;
    }

    public Vector<ISpssVariable> getVariables() {
        return this.mVariables;
    }

    public boolean isIndexZone() {
        return this.mVariables.size() == 1 && this.mVariables.get(0) instanceof IndexVariable;
    }

    public boolean isDependentVarZone() {
        return this.mZoneType == ZoneType.zt_y || this.mZoneType == ZoneType.zt_y2 || this.mZoneType == ZoneType.zt_angle || this.mZoneType == ZoneType.zt_high || this.mZoneType == ZoneType.zt_low || this.mZoneType == ZoneType.zt_close;
    }

    public void serializeIn(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        this.mZoneType = ZoneType.valueOf(string);
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string2 = dataInputStream.readUTF();
            String string3 = dataInputStream.readUTF();
            String string4 = dataInputStream.readUTF();
            IndexVariable indexVariable = string2.equals(sIndexVarName) ? DropZone.constructIndexVariable() : iSpssDataSrc.getVariable(iSpssDataSrc.findVarIndex(string2));
            if (indexVariable == null) {
                indexVariable = this.getMRVar(iSpssDataSrc, string2);
            }
            if (indexVariable == null) continue;
            try {
                indexVariable = indexVariable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                continue;
            }
            indexVariable.setMeasurementLevel(MeasurementLevel.valueOf((String)string3));
            indexVariable.setDisplayMeasurementLevel(MeasurementLevel.valueOf((String)string4));
            this.mVariables.add((ISpssVariable)indexVariable);
        }
        this.mFocused = dataInputStream.readBoolean();
        this.mTransposed = dataInputStream.readBoolean();
        this.mUsesColorStyling = dataInputStream.readBoolean();
        this.mColorStyleString = dataInputStream.readUTF();
    }

    public void serializeOut(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.mZoneType.name());
        dataOutputStream.writeInt(this.mVariables.size());
        for (ISpssVariable iSpssVariable : this.mVariables) {
            dataOutputStream.writeUTF(iSpssVariable.getName());
            dataOutputStream.writeUTF(iSpssVariable.getMeasurementLevel().name());
            dataOutputStream.writeUTF(iSpssVariable.getDisplayMeasurementLevel().name());
        }
        dataOutputStream.writeBoolean(this.mFocused);
        dataOutputStream.writeBoolean(this.mTransposed);
        dataOutputStream.writeBoolean(this.mUsesColorStyling);
        dataOutputStream.writeUTF(this.mColorStyleString);
    }

    public static IndexVariable constructIndexVariable() {
        IndexVariable indexVariable = new IndexVariable();
        indexVariable.setName(sIndexVarName);
        indexVariable.setMeasurementLevel(MeasurementLevel.nominal);
        indexVariable.setFormat(new SPSS_Format(FormatType.A, 8, 0));
        return indexVariable;
    }

    public static void updateIndexValueLabelMap(ChartCanvas chartCanvas, IndexVariable indexVariable) {
        ISpssVariable[] iSpssVariableArray = chartCanvas.getZoneMgr().getSummaryVariables();
        if (iSpssVariableArray == null || iSpssVariableArray.length == 0) {
            return;
        }
        HashMap<OBSEX, String> hashMap = new HashMap<OBSEX, String>();
        boolean bl = chartCanvas.getShowVarLabels();
        for (int i = 0; i < iSpssVariableArray.length; ++i) {
            String string = null;
            if (bl) {
                string = iSpssVariableArray[i].getLabel();
            }
            if (string == null || string.length() == 0) {
                string = iSpssVariableArray[i].getName();
            }
            hashMap.put(new OBSEX(Integer.toString(i + 1), i), string);
        }
        ValueLabelMap valueLabelMap = new ValueLabelMap(SpssVLMapId.next(), hashMap);
        indexVariable.setValueLabels((IValueLabelMap)valueLabelMap);
    }

    public void setClickDelta() {
        if (this.mClickDelta < this.getVariables().size()) {
            this.mClickDelta = this.mClickDelta == this.getVariables().size() - 1 ? 0 : ++this.mClickDelta;
        }
    }

    public int getClickDelta() {
        return this.mClickDelta;
    }

    private ISpssVariable getMRVar(ISpssDataSrc iSpssDataSrc, String string) {
        Vector vector = iSpssDataSrc.getMRVariables();
        for (ISpssVariable iSpssVariable : vector) {
            if (!iSpssVariable.getName().equals(string)) continue;
            return iSpssVariable;
        }
        return null;
    }

    private static void initBorders() {
        float[] fArray = new float[]{3.0f, 2.0f, 3.0f, 2.0f};
        sStandardStroke = new BasicStroke(1.0f, 1, 1, 1.0f, fArray, 0.0f);
        sHiliteStroke = new BasicStroke(2.0f, 2, 0, 1.0f);
        sSpecialHiliteStroke = new BasicStroke(1.0f, 1, 1, 1.0f);
    }

    private void loadZoneText(IResourceAccessor iResourceAccessor) {
        String string;
        this.mEmptyZoneText = string = this.getZoneTypeText(iResourceAccessor);
    }

    private String getZoneTypeText(IResourceAccessor iResourceAccessor) {
        String string = "";
        if (this.mZoneType.equals((Object)ZoneType.zt_x)) {
            string = iResourceAccessor.getResString("IDS_X_AXIS");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_y)) {
            string = iResourceAccessor.getResString("IDS_Y_AXIS");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_y2)) {
            string = iResourceAccessor.getResString("IDS_Y_AXIS");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_low)) {
            string = this.mCanvas.getImager().isDifferenceArea() ? iResourceAccessor.getResString("IDS_DIFFAREA_VAR") : iResourceAccessor.getResString("IDS_LOW_VAR");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_high)) {
            string = this.mCanvas.getImager().isDifferenceArea() ? iResourceAccessor.getResString("IDS_DIFFAREA_VAR") : iResourceAccessor.getResString("IDS_HIGH_VAR");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_close)) {
            string = iResourceAccessor.getResString("IDS_CLOSE_VAR");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_z)) {
            string = iResourceAccessor.getResString("IDS_Z_AXIS");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_point_id)) {
            string = iResourceAccessor.getResString("IDS_POINT_ID_VAR");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_cluster_x)) {
            string = iResourceAccessor.getResString("IDS_CLUSTER_X");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_cluster_z)) {
            string = iResourceAccessor.getResString("IDS_CLUSTER_Z");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_group)) {
            string = iResourceAccessor.getResString("IDS_STACK");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_panel_horz)) {
            string = iResourceAccessor.getResString("IDS_PANEL");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_panel_vert)) {
            string = iResourceAccessor.getResString("IDS_PANEL");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_slice_by)) {
            string = iResourceAccessor.getResString("IDS_SLICE_BY");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_angle)) {
            string = iResourceAccessor.getResString("IDS_ANGLE_VAR");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_dist_var)) {
            string = iResourceAccessor.getResString("IDS_DIST_VAR");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_split_var)) {
            string = iResourceAccessor.getResString("IDS_SPLIT_VAR");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_matrix)) {
            string = iResourceAccessor.getResString("IDS_MATRIX_VAR");
        } else if (this.mZoneType.equals((Object)ZoneType.zt_filter)) {
            string = iResourceAccessor.getResString("IDS_FILTER_VAR");
        } else assert (false);
        return string;
    }

    private void renderFocus(Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(sFocusStroke);
        if (this.mZoneType.equals((Object)ZoneType.zt_z)) {
            Polygon polygon = this.calcZBounds(true);
            graphics2D.drawPolygon(polygon);
        } else {
            Rectangle rectangle = new Rectangle(this.mBounds.getBounds());
            rectangle.grow(-2, -2);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void renderBorder(Graphics2D graphics2D) {
        if (this.mZoneType == ZoneType.zt_group && this.mCanvas.getImager().isOverlayScatter()) {
            graphics2D.setStroke(sSpecialHiliteStroke);
            graphics2D.setColor(Color.gray);
        } else if (this.mHighlight) {
            graphics2D.setStroke(sHiliteStroke);
            graphics2D.setColor(sHighlightColor);
        } else if (this.mHighlight2) {
            graphics2D.setStroke(sHiliteStroke);
            graphics2D.setColor(sHighlight2Color);
        } else {
            graphics2D.setStroke(sStandardStroke);
            graphics2D.setColor(Color.blue);
        }
        graphics2D.draw(this.mBounds);
    }

    private void drawMultiHighlight(Graphics2D graphics2D) {
        graphics2D.setStroke(sSpecialHiliteStroke);
        boolean bl = this.verticalZone();
        Rectangle rectangle = this.getBounds().getBounds();
        if (bl) {
            rectangle.height = (int)((double)rectangle.height * 0.25);
        } else {
            rectangle.width = (int)((double)rectangle.width * 0.25);
        }
        rectangle.grow(-3, -3);
        graphics2D.draw(rectangle);
        int n = rectangle.x + rectangle.width / 2;
        graphics2D.setStroke(sHiliteStroke);
        graphics2D.drawLine(n - 1, rectangle.y + 3, n - 1, rectangle.y + 11);
        graphics2D.drawLine(n + 1, rectangle.y + 3, n + 1, rectangle.y + 11);
        graphics2D.drawLine(n - 5, rectangle.y + 6, n + 5, rectangle.y + 6);
        graphics2D.drawLine(n - 5, rectangle.y + 8, n + 5, rectangle.y + 8);
    }

    private void renderContents(Graphics2D graphics2D, Locale locale) {
        String string;
        int n = this.getZoneRotation();
        Rectangle rectangle = this.mBounds.getBounds();
        rectangle.grow(-2, -2);
        rectangle.height += 2;
        Icon icon = this.getZoneIcon();
        if (icon != null) {
            this.renderZoneIcon(graphics2D, icon, rectangle);
        }
        if ((string = this.getZoneText()) != null) {
            if (this.isDependentVarZone()) {
                this.renderDependentZoneText(graphics2D, string, rectangle, locale);
                return;
            }
            if (this.isEmpty()) {
                graphics2D.setColor(Color.blue);
            } else {
                graphics2D.setColor(Color.black);
            }
            if (n == 0) {
                if (!ComponentState.isBtdRtlOrLtr() || string.length() == 0) {
                    CommonUtil.drawWrappedText((Graphics)graphics2D, (String)string, (Rectangle)rectangle, (int)0);
                } else {
                    CommonUtil.drawWrappedText((Graphics)graphics2D, (String)this.prepareDropZoneTextForBidiDisplay(string), (Rectangle)rectangle, (int)0);
                }
            } else {
                this.drawRotatedText(graphics2D, rectangle, n, string);
            }
        }
        if (!(this.isEmpty() && !this.mCanvas.getImager().isOverlayScatter() || !this.isStyleByZone() && this.mZoneType != ZoneType.zt_point_id)) {
            this.renderTopText(graphics2D);
        }
    }

    private void renderDependentZoneText(Graphics2D graphics2D, String string, Rectangle rectangle, Locale locale) {
        String string2;
        int n = this.getZoneRotation();
        String string3 = null;
        ElementStat elementStat = this.mCanvas.getImager().getStatForDependentZone(this.mZoneType);
        boolean bl = false;
        boolean bl2 = this.mCanvas.getImager().hasSSVs();
        if (this.isEmpty()) {
            boolean bl3;
            boolean bl4 = bl3 = !this.isHLCZone() && !this.mCanvas.getImager().isSchema() && DropZone.getRoleStatDisplay() && elementStat != null && elementStat.getStat() != Statistics.Value;
            if (bl3) {
                string2 = this.getStatString(elementStat.getStat(), locale);
                bl = true;
            } else {
                string2 = string;
            }
        } else {
            if (bl2) {
                Props.SSVData sSVData = this.mCanvas.getImager().getSSVData();
                string2 = this.getSSVLine(sSVData, 0);
                string3 = this.getSSVLine(sSVData, 1);
            } else {
                boolean bl5;
                boolean bl6 = bl5 = !this.mCanvas.getImager().isSchema() && DropZone.getRoleStatDisplay() && elementStat != null && elementStat.getStat() != Statistics.Value;
                if (bl5) {
                    string2 = elementStat.getStat().getStatLabel(this.mCanvas.getResources(), elementStat);
                    string3 = string;
                } else {
                    string2 = string;
                }
            }
            bl = true;
        }
        if (bl) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(Color.blue);
        }
        if (string3 == null) {
            if (n == 0) {
                CommonUtil.drawWrappedText((Graphics)graphics2D, (String)string2, (Rectangle)rectangle, (int)0);
            } else if (string2 == null || string2.length() == 0) {
                this.drawRotatedText(graphics2D, rectangle, n, string2);
            } else {
                this.drawRotatedText(graphics2D, rectangle, n, this.prepareDropZoneTextForBidiDisplay(string2));
            }
        } else if (n == 0) {
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height / 2);
            Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + rectangle.height / 2, rectangle.width, rectangle.height / 2);
            if (!ComponentState.isBtdRtlOrLtr()) {
                CommonUtil.drawWrappedText((Graphics)graphics2D, (String)string2, (Rectangle)rectangle2, (int)0);
                CommonUtil.drawWrappedText((Graphics)graphics2D, (String)string3, (Rectangle)rectangle3, (int)0);
            } else {
                if (string2 == null || string2.length() == 0) {
                    CommonUtil.drawWrappedText((Graphics)graphics2D, (String)string2, (Rectangle)rectangle2, (int)0);
                } else {
                    CommonUtil.drawWrappedText((Graphics)graphics2D, (String)this.prepareDropZoneTextForBidiDisplay(string2), (Rectangle)rectangle2, (int)0);
                }
                if (string3 == null || string3.length() == 0) {
                    CommonUtil.drawWrappedText((Graphics)graphics2D, (String)string3, (Rectangle)rectangle3, (int)0);
                } else {
                    CommonUtil.drawWrappedText((Graphics)graphics2D, (String)this.prepareDropZoneTextForBidiDisplay(string3), (Rectangle)rectangle3, (int)0);
                }
            }
        } else {
            Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y, rectangle.width / 2, rectangle.height);
            Rectangle rectangle5 = new Rectangle(rectangle.x + rectangle.width / 2, rectangle.y, rectangle.width / 2, rectangle.height);
            if (!(ComponentState.isBtdRtlOrLtr() || string2 != null && string2.length() != 0 && ComponentState.containsBidiLetter((String)string2) || string3 != null && string3.length() != 0 && ComponentState.containsBidiLetter((String)string3))) {
                this.drawRotatedText(graphics2D, rectangle4, n, string2);
                this.drawRotatedText(graphics2D, rectangle5, n, string3);
            } else {
                if (string2 == null || string2.length() == 0) {
                    this.drawRotatedText(graphics2D, rectangle4, n, string2);
                } else {
                    this.drawRotatedText(graphics2D, rectangle4, n, this.prepareDropZoneTextForBidiDisplay(string2));
                }
                if (string3 == null || string3.length() == 0) {
                    this.drawRotatedText(graphics2D, rectangle5, n, string3);
                } else {
                    this.drawRotatedText(graphics2D, rectangle5, n, this.prepareDropZoneTextForBidiDisplay(string3));
                }
            }
        }
    }

    private boolean isHLCZone() {
        return this.mZoneType == ZoneType.zt_high || this.mZoneType == ZoneType.zt_low || this.mZoneType == ZoneType.zt_close;
    }

    private String getSSVLine(Props.SSVData sSVData, int n) {
        String string = null;
        boolean bl = this.mCanvas.getShowVarLabels();
        if (n > -1 && n < sSVData.getSSVVariables().size()) {
            String string2;
            ElementStat elementStat = sSVData.getSSVVariables().get(n);
            ISpssVariable iSpssVariable = elementStat.getVariable();
            String string3 = string2 = bl && iSpssVariable.getLabel().length() > 0 ? iSpssVariable.getLabel() : iSpssVariable.getName();
            string = ComponentState.isBtdRtlOrLtr() ? (ComponentState.getBTD() == 1 ? '\u200f' + string2 + '\u200f' + " [" + elementStat.getStat().getStatLabel(this.mCanvas.getResources(), elementStat) + "]" : '\u200e' + string2 + '\u200e' + " [" + elementStat.getStat().getStatLabel(this.mCanvas.getResources(), elementStat) + "]") : (string2 != null && string2.length() > 0 ? (ComponentState.isBidiLetter((char)string2.charAt(0)) ? '\u200f' + string2 + '\u200f' + " [" + elementStat.getStat().getStatLabel(this.mCanvas.getResources(), elementStat) + "]" : '\u200e' + string2 + '\u200e' + " [" + elementStat.getStat().getStatLabel(this.mCanvas.getResources(), elementStat) + "]") : string2 + " [" + elementStat.getStat().getStatLabel(this.mCanvas.getResources(), elementStat) + "]");
            if (n == 1 && sSVData.getSSVVariables().size() > 2) {
                string = string + "...";
            }
        }
        return string;
    }

    private String getStatString(Statistics statistics, Locale locale) {
        String string = statistics.getOLUserString(this.mCanvas.getResources(), locale);
        int n = string.indexOf(40);
        string = n > -1 ? string.substring(0, n) : string.replaceAll("(%s, %s)", "").replaceAll("(%s)", "").replaceAll("()", "");
        return string;
    }

    private void renderTopText(Graphics2D graphics2D) {
        String string;
        Rectangle rectangle = this.mBounds.getBounds();
        rectangle.y -= 17;
        rectangle.height = 20;
        if (rectangle.y < 0) {
            return;
        }
        rectangle.grow(10, 0);
        graphics2D.setColor(Color.blue);
        if (this.mZoneType == ZoneType.zt_point_id) {
            string = this.mResources.getResString("IDS_POINT_ID1");
        } else if (this.showArrangement()) {
            if (this.mEmptyZoneText == null) {
                this.loadZoneText(this.mResources);
            }
            string = this.mEmptyZoneText + ": " + this.mColorStyleString;
        } else {
            string = this.mColorStyleString;
        }
        CommonUtil.drawIconAndText((Graphics)graphics2D, null, (Rectangle)rectangle, null, (String)string, (int)0);
    }

    private boolean showArrangement() {
        if (this.mZoneType == ZoneType.zt_cluster_x || this.mZoneType == ZoneType.zt_cluster_z) {
            return true;
        }
        Elements elements = this.mCanvas.getImager().getPrimaryElementType();
        boolean bl = elements == Elements.line;
        boolean bl2 = elements == Elements.point;
        boolean bl3 = elements == Elements.splom;
        boolean bl4 = this.mZoneType == ZoneType.zt_slice_by;
        return !bl && !bl2 && !bl3 && !bl4;
    }

    private void drawRotatedText(Graphics2D graphics2D, Rectangle rectangle, int n, String string) {
        Rectangle rectangle2;
        Rectangle rectangle3;
        Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.height, rectangle.width);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        String string2 = SwingUtilities.layoutCompoundLabel(null, fontMetrics, string, null, 0, 0, 0, 11, rectangle4, rectangle3 = new Rectangle(0, 0, 0, 0), rectangle2 = new Rectangle(0, 0, 0, 0), 5);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        Point point = new Point(rectangle.x + rectangle.width / 2 + 4, rectangle.y + rectangle.height / 2);
        graphics2D.translate(point.x, point.y);
        graphics2D.rotate(Math.toRadians(n));
        TextLayout textLayout = new TextLayout(string2, graphics2D.getFont(), graphics2D.getFontRenderContext());
        float f = textLayout.getAdvance() / 2.0f;
        if (n == 270) {
            f = f > (float)(rectangle.y + rectangle.height - point.y) ? (float)(rectangle.y + rectangle.height - point.y) : f;
        }
        textLayout.draw(graphics2D, -f, 0.0f);
        graphics2D.setTransform(affineTransform);
    }

    private void renderZoneIcon(Graphics2D graphics2D, Icon icon, Rectangle rectangle) {
        int n;
        int n2;
        int n3 = this.getZoneRotation();
        if (n3 == 0) {
            n2 = rectangle.x + 3;
            n = rectangle.y + (rectangle.height - icon.getIconHeight()) / 2 + 1;
            int n4 = icon.getIconWidth() + 6;
            rectangle.width -= n4;
            rectangle.x += n4;
        } else if (n3 == 270) {
            int n5 = icon.getIconHeight() + 3;
            n2 = rectangle.x + (rectangle.width - icon.getIconWidth()) / 2 + 1;
            n = (int)(rectangle.getMaxY() - (double)n5);
            rectangle.height -= n5;
        } else {
            n2 = rectangle.x + 9;
            n = (int)(rectangle.getMaxY() - (double)icon.getIconHeight() - 8.0);
            rectangle.translate(icon.getIconWidth() + 2, -2);
            rectangle.width -= icon.getIconWidth() + 6;
            rectangle.height -= 10;
        }
        icon.paintIcon(null, graphics2D, n2, n);
        if (this.mVariables.size() > 1) {
            graphics2D.drawString("*", n2 + 12, n + 18);
        } else if (this.isIndexZone()) {
            graphics2D.drawString("*", n2 + 14, n + 10);
        }
    }

    private Icon getZoneIcon() {
        Icon icon = null;
        if (!this.isEmpty()) {
            ISpssVariable iSpssVariable = this.mVariables.get(0);
            icon = VariableList.getStandardIcon(iSpssVariable);
        }
        return icon;
    }

    private int getZoneRotation() {
        int n = 0;
        if (this.mZoneType.equals((Object)ZoneType.zt_x)) {
            n = this.mTransposed ? 270 : 0;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_y)) {
            n = this.mTransposed ? 0 : 270;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_y2)) {
            n = 270;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_high)) {
            n = this.mTransposed ? 0 : 270;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_low)) {
            n = this.mTransposed ? 0 : 270;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_close)) {
            n = this.mTransposed ? 0 : 270;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_z)) {
            n = 309;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_panel_vert)) {
            n = 270;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_angle)) {
            n = 270;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_dist_var)) {
            n = 270;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_matrix)) {
            n = 0;
        } else if (this.mZoneType.equals((Object)ZoneType.zt_filter)) {
            n = 270;
        }
        return n;
    }

    private void setXBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        this.mBounds = this.mTransposed && !this.mZoneType.equals((Object)ZoneType.zt_matrix) ? new Rectangle(rectangle.x + 10, rectangle.y + 40 + 10, 35, rectangle.height - 40 - 45 - 20) : new Rectangle(rectangle.x + 60 + 10, rectangle.height - 45 + 5, rectangle.width - 60 - 120 - 20, 31);
    }

    private void setYBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        this.mBounds = this.mTransposed ? new Rectangle(rectangle.x + 60 + 10, rectangle.height - 45 + 5, rectangle.width - 60 - 120 - 20, 31) : new Rectangle(rectangle.x + 10, rectangle.y + 40 + 10, 35, rectangle.height - 40 - 45 - 20);
    }

    private void setY2Bounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        this.mBounds = new Rectangle(rectangle.width - 120 + 10, rectangle.y + 40 + 10, 35, rectangle.height - 40 - 45 - 20);
    }

    private void setHighBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        if (this.mCanvas.getImager().isDifferenceArea()) {
            if (this.mTransposed) {
                int n = (rectangle.width - 50 - 15) / 2;
                this.mBounds = new Rectangle(rectangle.x + 10, rectangle.height - 31 - 5, n, 31);
            } else {
                int n = (rectangle.height - 15) / 2;
                this.mBounds = new Rectangle(rectangle.x + 10, rectangle.y + 5, 35, n);
            }
        } else if (this.mTransposed) {
            int n = (rectangle.width - 50 - 20) / 3;
            this.mBounds = new Rectangle(rectangle.x + 10, rectangle.height - 31 - 5, n, 31);
        } else {
            int n = (rectangle.height - 20) / 3;
            this.mBounds = new Rectangle(rectangle.x + 10, rectangle.y + 5, 35, n);
        }
    }

    private void setLowBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        if (this.mCanvas.getImager().isDifferenceArea()) {
            if (this.mTransposed) {
                int n = (rectangle.width - 50 - 15) / 2;
                this.mBounds = new Rectangle(rectangle.x + n + 5 + 10, rectangle.height - 31 - 5, n, 31);
            } else {
                int n = (rectangle.height - 15) / 2;
                this.mBounds = new Rectangle(rectangle.x + 10, rectangle.y + n + 10, 35, n);
            }
        } else if (this.mTransposed) {
            int n = (rectangle.width - 50 - 20) / 3;
            this.mBounds = new Rectangle(rectangle.x + n + 5 + 10, rectangle.height - 31 - 5, n, 31);
        } else {
            int n = (rectangle.height - 20) / 3;
            this.mBounds = new Rectangle(rectangle.x + 10, rectangle.y + n + 10, 35, n);
        }
    }

    private void setCloseBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        if (this.mTransposed) {
            int n = (rectangle.width - 50 - 20) / 3;
            this.mBounds = new Rectangle(rectangle.x + n * 2 + 10 + 10, rectangle.height - 31 - 5, n, 31);
        } else {
            int n = (rectangle.height - 20) / 3;
            this.mBounds = new Rectangle(rectangle.x + 10, rectangle.y + n * 2 + 15, 35, n);
        }
    }

    private void setZBounds() {
        this.mBounds = this.calcZBounds(false);
    }

    private Polygon calcZBounds(boolean bl) {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        int n = bl ? 4 : 0;
        int n2 = bl ? 2 : 0;
        Polygon polygon = new Polygon();
        polygon.reset();
        Point point = new Point(rectangle.width - 120 - 52, rectangle.height - 65);
        polygon.addPoint(point.x + n, point.y);
        polygon.addPoint(point.x + 57 + n, point.y - 72 + n2);
        polygon.addPoint(point.x + 82 - n, point.y - 56 + n2);
        polygon.addPoint(point.x + 25, point.y + 16 - n2);
        if (this.mCanvas.getImager().getCoordinates() == Coords.coords_3D && (this.mCanvas.getImager().hasHorzPanels() || this.mCanvas.getImager().hasVertPanels())) {
            polygon.translate(35, 0);
        }
        return polygon;
    }

    private void setGroupZoneBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        int n = rectangle.width - 120 - 10;
        boolean bl = this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_cluster_x);
        boolean bl2 = this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_cluster_z);
        if (this.mZoneType.equals((Object)ZoneType.zt_cluster_x)) {
            this.mBounds = new Rectangle(n, 20, rectangle.width - n - 10, 31);
        } else if (this.mZoneType.equals((Object)ZoneType.zt_cluster_z)) {
            int n2 = bl ? 72 : 20;
            this.mBounds = new Rectangle(n, n2, rectangle.width - n - 10, 31);
        } else if (this.mZoneType.equals((Object)ZoneType.zt_group)) {
            int n3 = bl || bl2 ? 72 : 20;
            this.mBounds = new Rectangle(n, n3, rectangle.width - n - 10, 31);
        }
    }

    private void setPointIdBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        int n = rectangle.width - 120 - 10;
        this.mBounds = this.mCanvas.getImager().getCoordinates() == Coords.coords_DualY ? new Rectangle(n, 10, rectangle.width - n - 10, 31) : new Rectangle(n, 80, rectangle.width - n - 10, 31);
    }

    private void setHorzPanelBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        this.mBounds = this.mCanvas.getImager().isHiLoClose() || this.mCanvas.getImager().isDifferenceArea() ? new Rectangle(rectangle.x + 60, rectangle.y + 5, 130, 31) : new Rectangle(rectangle.x + 10, rectangle.y + 10, 130, 31);
    }

    private void setVertPanelBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        this.mBounds = new Rectangle(rectangle.width - 45, rectangle.height - 103, 35, 100);
    }

    private void setVertFilterBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        this.mBounds = new Rectangle(rectangle.width - 45, rectangle.height - 103 - 103, 35, 100);
    }

    private void setSplitBounds() {
        Rectangle rectangle = this.mCanvas.getBounds();
        rectangle.height -= this.mCanvas.getTitleMgr().getFootnotesHeight();
        this.mBounds = new Rectangle(rectangle.x + 60, rectangle.y + 5, 130, 31);
    }

    private void createZoneFont() {
        Font font = this.mCanvas.getFont();
        this.mZoneFont = font.deriveFont(10.0f);
    }

    private boolean verticalZone() {
        boolean bl = false;
        boolean bl2 = this.mCanvas.isTransposed();
        if (this.mZoneType == ZoneType.zt_angle || !bl2 && this.mZoneType == ZoneType.zt_y || this.mZoneType == ZoneType.zt_filter || bl2 && this.mZoneType == ZoneType.zt_x || bl2 && this.mZoneType == ZoneType.zt_matrix) {
            bl = true;
        }
        return bl;
    }

    private String prepareDropZoneTextForBidiDisplay(String string) {
        String string2 = null;
        string2 = ComponentState.getBTD() == 1 ? (new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? string : '\u200f' + string) : (ComponentState.getBTD() == 2 ? (!new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? string : '\u200e' + string) : string);
        return string2;
    }

    static class OBSEX
    extends OBS {
        private int mOrder;

        OBSEX(String string, int n) {
            super(string);
            this.mOrder = n;
        }

        public int compareTo(Object object) {
            if (object instanceof OBSEX) {
                OBSEX oBSEX = (OBSEX)((Object)object);
                return this.mOrder < oBSEX.mOrder ? -1 : (this.mOrder == oBSEX.mOrder ? 0 : 1);
            }
            return super.compareTo(object);
        }

        public boolean equals(Object object) {
            return object instanceof OBSEX && this.mOrder == ((OBSEX)((Object)object)).mOrder && super.equals(object);
        }
    }
}

