/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.VarInfo;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.vis.specification.ExtensionSpecification;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.data.ExpressionVariableSpecification;
import com.spss.vis.specification.data.SourceVariableSpecification;
import com.spss.vis.specification.domain.DomainSpecification;
import com.spss.vis.specification.element.ElementSpecification;
import com.spss.vizimager.VizDataProcessor;
import com.spss.vizimager.VizDataSource;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;

public class DataGenerator {
    private final int HISTOGRAM_XBINS = 9;
    private CanvasImager mImager = null;
    private double[] mScalarData = null;

    public DataGenerator(CanvasImager canvasImager) {
        this.mImager = canvasImager;
    }

    public Collection<VizDataSource> generateData() {
        int n;
        Vector<VizDataSource> vector = new Vector<VizDataSource>();
        VisualizationSpecification visualizationSpecification = this.mImager.getSpecification();
        if (visualizationSpecification == null) {
            return vector;
        }
        Vector<VarInfo> vector2 = this.acquireVariables(visualizationSpecification);
        boolean bl = this.mImager.getOwnerCanvas().hasVariables();
        boolean bl2 = this.mImager.isSchema();
        boolean bl3 = this.mImager.getOwnerCanvas().getZoneMgr().hasScaleVar(ZoneType.zt_x);
        boolean bl4 = this.mImager.getOwnerCanvas().getZoneMgr().hasCatVar(ZoneType.zt_y);
        boolean bl5 = this.mImager.isHiLoClose() || this.mImager.hasErrorBars();
        boolean bl6 = this.mImager.isPopulationPyramid();
        boolean bl7 = this.mImager.isSplom();
        boolean bl8 = this.mImager.isSingleDimensionDotPlot();
        boolean bl9 = this.mImager.isHistogram();
        boolean bl10 = this.mImager.isDifferenceArea();
        int n2 = 1;
        if (bl9) {
            n2 = 9;
        } else if (bl7 || bl2 || bl3) {
            n2 = 12;
        } else if (bl8) {
            int n3 = n2 = vector2.size() == 1 ? 6 : 3;
        }
        if (bl6) {
            n2 = 9;
            n = 18 * this.getPanelVarCatCount(vector2);
        } else {
            n = this.getRowCount(vector2) * n2;
        }
        VizDataProcessor vizDataProcessor = new VizDataProcessor();
        VizDataSource vizDataSource = vizDataProcessor.createDataSource(n);
        vizDataSource.setID("source0");
        int n4 = 0;
        int n5 = 0;
        for (VarInfo varInfo : vector2) {
            String string;
            int n6;
            boolean bl11;
            double[] dArray = new double[n];
            boolean bl12 = bl11 = bl9 && varInfo.isXVar();
            if (varInfo.isCategorical() && !bl11) {
                int n7;
                int n8;
                n6 = 0;
                string = "CAT" + ++n4;
                if (bl6) {
                    if (varInfo.isXVar()) {
                        this.getPyramidData(dArray, 9);
                        vizDataSource.setColumn(string, DoubleBuffer.wrap(dArray));
                        varInfo.getVarSpec().setSourceName(string);
                        continue;
                    }
                    n8 = varInfo.isColorSplitVar() ? 2 : this.countZoneCategories(varInfo);
                } else {
                    n8 = this.countZoneCategories(varInfo);
                }
                while (n6 < n) {
                    block2: for (n7 = 0; n7 < n8 && n6 < n; ++n7) {
                        for (int i = 0; i < n2; ++i) {
                            dArray[n6] = n7 + 1;
                            if (++n6 >= n) continue block2;
                        }
                    }
                }
                n2 *= n8;
                if (bl && bl8) {
                    dArray[n / 2] = dArray[dArray.length - 1];
                    dArray[n / 2 - 1] = dArray[dArray.length - 1];
                }
                if (bl4 && varInfo.isYVar()) {
                    int n9 = n7 = dArray.length - 1;
                    dArray[n9] = dArray[n9] + 1.0;
                    int n10 = n7 - 1;
                    dArray[n10] = dArray[n10] - 1.0;
                }
            } else {
                string = "SCALE" + ++n5;
                if (bl6 && varInfo.isXVar()) {
                    this.getPyramidData(dArray, 9);
                } else if (bl11) {
                    this.getHistogramXData(dArray);
                } else if (bl || bl10) {
                    this.getScalarData(dArray, n5 - 1);
                } else {
                    Arrays.fill(dArray, 10.0);
                    if (bl2) {
                        for (n6 = 0; n6 < dArray.length; n6 += 2) {
                            int n11 = n6;
                            dArray[n11] = dArray[n11] + 10.0;
                        }
                        dArray[1] = 23.0;
                        dArray[dArray.length / 2 - 1] = 23.0;
                        dArray[dArray.length - 2] = 23.0;
                        dArray[0] = 45.0;
                        dArray[dArray.length - 1] = 45.0;
                    }
                }
            }
            vizDataSource.setColumn(string, DoubleBuffer.wrap(dArray));
            varInfo.getVarSpec().setSourceName(string);
        }
        if (bl5) {
            this.fixupRangeGathers(vizDataSource, vector2, bl);
        }
        vector.add(vizDataSource);
        return vector;
    }

    private Vector<VarInfo> acquireVariables(VisualizationSpecification visualizationSpecification) {
        SourceVariableSpecification[] sourceVariableSpecificationArray = (SourceVariableSpecification[])visualizationSpecification.findDescendantsOfType(SourceVariableSpecification.class);
        Vector<VarInfo> vector = new Vector<VarInfo>();
        for (SourceVariableSpecification sourceVariableSpecification : sourceVariableSpecificationArray) {
            if (!this.isVariableInUse(sourceVariableSpecification)) {
                DomainSpecification domainSpecification = sourceVariableSpecification.getDomain();
                sourceVariableSpecification.setDomain(null);
                if (domainSpecification != null) {
                    domainSpecification.getParent().remove((Specification)domainSpecification);
                }
                visualizationSpecification.remove((Specification)sourceVariableSpecification);
                continue;
            }
            vector.add(new VarInfo(sourceVariableSpecification, this.mImager.getMaxCats()));
        }
        return vector;
    }

    private boolean isVariableInUse(SourceVariableSpecification sourceVariableSpecification) {
        Specification[] specificationArray;
        for (Specification specification : specificationArray = sourceVariableSpecification.getTop().getReferencesTo(sourceVariableSpecification.getId())) {
            if (specification.getParent() instanceof DomainSpecification) continue;
            return true;
        }
        String string = sourceVariableSpecification.getId();
        for (Specification specification : specificationArray = sourceVariableSpecification.getTop().findDescendantsOfType(ExpressionVariableSpecification.class)) {
            ExpressionVariableSpecification expressionVariableSpecification = (ExpressionVariableSpecification)specification;
            if (expressionVariableSpecification.getExpression().indexOf(string) <= -1) continue;
            return true;
        }
        return false;
    }

    private int getRowCount(Vector<VarInfo> vector) {
        int n = 1;
        boolean bl = this.mImager.isHistogram();
        for (VarInfo varInfo : vector) {
            if (!varInfo.isCategorical() || bl && varInfo.isXVar()) continue;
            int n2 = this.countZoneCategories(varInfo);
            n *= n2;
        }
        return n;
    }

    private int countZoneCategories(VarInfo varInfo) {
        int n = varInfo.categoryCount();
        if (n < 1) {
            n = this.mImager.getMaxCats();
        }
        n = Math.min(n, this.mImager.getMaxCats());
        return n;
    }

    private int getPanelVarCatCount(Vector<VarInfo> vector) {
        for (VarInfo varInfo : vector) {
            if (!varInfo.isPanelVar()) continue;
            return this.countZoneCategories(varInfo);
        }
        return 1;
    }

    private void getScalarData(double[] dArray, int n) {
        int n2;
        if (this.mScalarData == null) {
            this.generateScalarData();
        }
        int n3 = n2 = dArray.length > this.mScalarData.length ? this.mScalarData.length : dArray.length;
        if (dArray.length + n > this.mScalarData.length) {
            n2 -= n;
        }
        int n4 = 0;
        System.arraycopy(this.mScalarData, n, dArray, 0, n2);
        if (this.mImager.isDifferenceArea()) {
            this.setDiffAreaData(dArray);
        }
        for (int i = dArray.length - (n4 += n2); i > 0; i -= n2) {
            n2 = i > this.mScalarData.length ? this.mScalarData.length : i;
            System.arraycopy(this.mScalarData, 0, dArray, n4, n2);
            n4 += n2;
        }
    }

    private void setDiffAreaData(double[] dArray) {
        double[] dArray2 = new double[]{10.0, 8.0, 18.0, 4.0, 16.0, 8.0};
        int n = dArray2.length < dArray.length ? dArray2.length : dArray.length;
        System.arraycopy(dArray2, 0, dArray, 0, n);
    }

    private void getPyramidData(double[] dArray, int n) {
        int n2 = 0;
        int n3 = dArray.length / n;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[n2++] = j + 1;
            }
        }
    }

    private void getHistogramXData(double[] dArray) {
        int n = 0;
        int n2 = dArray.length / 9;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 9; ++j) {
                dArray[n++] = j + 1;
            }
        }
    }

    private void generateScalarData() {
        this.mScalarData = new double[81];
        for (int i = 0; i < this.mScalarData.length; ++i) {
            this.mScalarData[i] = Math.rint((Math.random() + 0.05) * 20.0);
        }
    }

    private void fixupRangeGathers(VizDataSource vizDataSource, Vector<VarInfo> vector, boolean bl) {
        int n = bl && this.mImager.isHiLoClose() ? 4 : 2;
        for (VarInfo varInfo : vector) {
            if (varInfo.isRangeLow()) {
                this.setRangeData(vizDataSource, varInfo.getVarSpec(), -n);
                continue;
            }
            if (!varInfo.isRangeHigh()) continue;
            this.setRangeData(vizDataSource, varInfo.getVarSpec(), n);
        }
    }

    private void setRangeData(VizDataSource vizDataSource, SourceVariableSpecification sourceVariableSpecification, int n) {
        ExtensionSpecification[] extensionSpecificationArray;
        SourceVariableSpecification sourceVariableSpecification2 = null;
        for (ExtensionSpecification extensionSpecification : extensionSpecificationArray = sourceVariableSpecification.getExtensionSpecifications()) {
            String string = extensionSpecification.get("range_key");
            if (string != null && string.length() > 0) {
                ElementSpecification[] elementSpecificationArray;
                VisualizationSpecification i = sourceVariableSpecification.getTop();
                for (ElementSpecification elementSpecification : elementSpecificationArray = (ElementSpecification[])i.findDescendantsOfType(ElementSpecification.class)) {
                    if (!elementSpecification.getId().equals(string)) continue;
                    sourceVariableSpecification2 = (SourceVariableSpecification)elementSpecification.getY();
                    break;
                }
            }
            if (sourceVariableSpecification2 != null) break;
        }
        if (sourceVariableSpecification2 == null) {
            return;
        }
        double[] dArray = vizDataSource.getDoubleColumn(sourceVariableSpecification2.getSourceName());
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i] + (double)n;
            dArray2[i] = d = Math.max(0.0, d);
        }
        vizDataSource.setColumn(sourceVariableSpecification.getSourceName(), DoubleBuffer.wrap(dArray2));
    }
}

