/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.IChart;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.vizimager.VizImager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ChartPrototype
implements IChart,
Cloneable {
    private static final int PROTO_SIZE = 64;
    private static VizImager sRenderer = null;
    private static ImageIcon sCustomMarkerIcon = null;
    private int mChartGroup;
    private String mTitle;
    private ByteBuffer mXml;
    private ByteBuffer mData;
    private BufferedImage mImage;
    private boolean mIsCustom;

    public ChartPrototype(int n) {
        this.mChartGroup = n;
    }

    public int getChartGroup() {
        return this.mChartGroup;
    }

    public boolean isCustomChart() {
        return this.mIsCustom;
    }

    public void setIsCustomChart(boolean bl) {
        this.mIsCustom = bl;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public ByteBuffer getXml() {
        return this.mXml;
    }

    public void setXml(ByteBuffer byteBuffer) {
        this.mXml = byteBuffer;
        this.freeImageCache();
    }

    public ByteBuffer getData() {
        return this.mData;
    }

    public void setData(ByteBuffer byteBuffer) {
        this.mData = byteBuffer;
        this.freeImageCache();
    }

    public BufferedImage getImage() {
        return this.getImage(64, 64);
    }

    public BufferedImage getImage(int n, int n2) {
        if (this.mImage == null || this.mImage.getWidth() != n || this.mImage.getHeight() != n2) {
            this.mImage = this.renderImage(n, n2);
        }
        return this.mImage;
    }

    public boolean serializeIn(ByteBuffer byteBuffer) {
        try {
            byte by = byteBuffer.get();
            if (by < 3 || by > 5) {
                return false;
            }
            if (by == 3) {
                return this.serializeInBaseVersion(byteBuffer);
            }
            if (by == 4) {
                return this.serializeInProto4Version(byteBuffer);
            }
            return this.serializeInCurrentVersion(byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean serializeOut(ByteBuffer byteBuffer) {
        try {
            byte[] byArray;
            byteBuffer.put((byte)5);
            byteBuffer.putInt(this.mChartGroup);
            try {
                byArray = this.mTitle.getBytes("UTF-8");
                byteBuffer.putShort((short)byArray.length);
                byteBuffer.put(byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return false;
            }
            byteBuffer.put((byte)(this.mIsCustom ? 1 : 0));
            byteBuffer.putInt(this.mXml.limit());
            byteBuffer.put(this.mXml.array());
            byteBuffer.putInt(this.mData.limit());
            byteBuffer.put(this.mData.array());
            this.getImage();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            if (!ImageIO.write((RenderedImage)this.mImage, "png", byteArrayOutputStream)) {
                return false;
            }
            byArray = byteArrayOutputStream.toByteArray();
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getTitle();
    }

    protected Object clone() {
        try {
            ChartPrototype chartPrototype = (ChartPrototype)super.clone();
            this.mXml.rewind();
            byte[] byArray = new byte[this.mXml.limit()];
            this.mXml.get(byArray);
            chartPrototype.mXml = ByteBuffer.wrap(byArray);
            this.mData.rewind();
            byArray = new byte[this.mData.limit()];
            this.mData.get(byArray);
            chartPrototype.mData = ByteBuffer.wrap(byArray);
            chartPrototype.mImage = null;
            return chartPrototype;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private BufferedImage renderImage(int n, int n2) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = this.getImager().renderToImage(this.mXml, this.mData, n, n2, null);
            if (bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                if (this.isCustomChart()) {
                    if (sCustomMarkerIcon == null) {
                        String string = "gallery_check.png";
                        URL uRL = ResUtil.getImageResourceFullPath(GraphsResBundle.getImageFolder() + string);
                        sCustomMarkerIcon = new ImageIcon(uRL);
                    }
                    sCustomMarkerIcon.paintIcon(null, graphics2D, 47, 47);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    private VizImager getImager() {
        if (sRenderer == null) {
            sRenderer = new VizImager();
        }
        return sRenderer;
    }

    private boolean serializeInCurrentVersion(ByteBuffer byteBuffer) throws IOException {
        this.mChartGroup = byteBuffer.getInt();
        short s = byteBuffer.getShort();
        byte[] byArray = new byte[s];
        byteBuffer.get(byArray);
        try {
            this.mTitle = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            this.mTitle = "";
        }
        this.mIsCustom = byteBuffer.get() != 0;
        int n = byteBuffer.getInt();
        byArray = new byte[n];
        byteBuffer.get(byArray);
        this.mXml = ByteBuffer.wrap(byArray);
        n = byteBuffer.getInt();
        byArray = new byte[n];
        byteBuffer.get(byArray);
        this.mData = ByteBuffer.wrap(byArray);
        this.freeImageCache();
        n = byteBuffer.getInt();
        if (n > 0) {
            byArray = new byte[n];
            byteBuffer.get(byArray);
            this.mImage = ImageIO.read(new ByteArrayInputStream(byArray));
        }
        return true;
    }

    private boolean serializeInProto4Version(ByteBuffer byteBuffer) throws IOException {
        this.mChartGroup = byteBuffer.getInt();
        byte by = byteBuffer.get();
        byte[] byArray = new byte[by];
        byteBuffer.get(byArray);
        try {
            this.mTitle = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            this.mTitle = "";
        }
        this.mIsCustom = byteBuffer.get() != 0;
        int n = byteBuffer.getInt();
        byArray = new byte[n];
        byteBuffer.get(byArray);
        this.mXml = ByteBuffer.wrap(byArray);
        n = byteBuffer.getInt();
        byArray = new byte[n];
        byteBuffer.get(byArray);
        this.mData = ByteBuffer.wrap(byArray);
        this.freeImageCache();
        n = byteBuffer.getInt();
        if (n > 0) {
            byArray = new byte[n];
            byteBuffer.get(byArray);
            this.mImage = ImageIO.read(new ByteArrayInputStream(byArray));
        }
        return true;
    }

    private boolean serializeInBaseVersion(ByteBuffer byteBuffer) {
        this.mChartGroup = byteBuffer.getInt();
        byte by = byteBuffer.get();
        byte[] byArray = new byte[by];
        try {
            byteBuffer.get(byArray);
            this.mTitle = new String(byArray, ComponentState.getCurrentCharsetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return false;
        }
        this.mIsCustom = byteBuffer.get() != 0;
        int n = byteBuffer.getInt();
        byArray = new byte[n];
        byteBuffer.get(byArray);
        this.mXml = ByteBuffer.wrap(byArray);
        n = byteBuffer.getInt();
        byArray = new byte[n];
        byteBuffer.get(byArray);
        this.mData = ByteBuffer.wrap(byArray);
        this.freeImageCache();
        n = byteBuffer.getInt();
        byArray = new byte[n];
        byteBuffer.get(byArray);
        return true;
    }

    private void freeImageCache() {
        this.mImage = null;
    }
}

