/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartPrototype;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.IChart;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;

public class ChartLib
implements IChart {
    private static final String GALLERY_FILE_NAME = "ChartLib.pto";
    private static final String CUSTOM_LIB_FILE_NAME = "CustomChartFavorites.pto";
    private String mLibfilePath;
    private boolean mIsCustom;
    private Vector<ChartPrototype> mCharts = new Vector();
    private boolean mIsModified;

    public ChartLib() {
        this(System.getProperty("application.home") + File.separatorChar + "lang" + File.separatorChar + PrefsMgr.getILangTag() + File.separatorChar + GALLERY_FILE_NAME, false);
    }

    public ChartLib(String string, boolean bl) {
        this.mLibfilePath = string;
        this.mIsCustom = bl;
        this.mIsModified = false;
    }

    public int getPrototypes(int n, Vector<ChartPrototype> vector) {
        vector.clear();
        for (ChartPrototype chartPrototype : this.mCharts) {
            if ((chartPrototype.getChartGroup() & n) == 0) continue;
            vector.add(chartPrototype);
        }
        return vector.size();
    }

    public int size() {
        return this.mCharts.size();
    }

    public void add(ChartPrototype chartPrototype) {
        this.mCharts.add(chartPrototype);
        this.mIsModified = true;
    }

    public void remove(ChartPrototype chartPrototype) {
        if (this.mCharts.contains(chartPrototype)) {
            this.mCharts.remove(chartPrototype);
            this.mIsModified = true;
        }
    }

    public void setModified(boolean bl) {
        this.mIsModified = bl;
    }

    public boolean load() {
        this.mCharts.clear();
        this.mIsModified = false;
        File file = new File(this.mLibfilePath);
        if (!file.exists()) {
            return false;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            int n = fileInputStream.read(byArray);
            fileInputStream.close();
            if (n != byArray.length) {
                return false;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byte by = byteBuffer.get();
            if (by < 3 || by > 5) {
                return false;
            }
            if (by == 3) {
                return this.loadBaseVersion(byteBuffer);
            }
            return this.loadCurrentVersion(byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean save() {
        if (!this.mIsModified) {
            return true;
        }
        File file = new File(this.mLibfilePath);
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n = this.mCharts.size() * 4 + 5;
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put((byte)5);
            byteBuffer.putInt(this.mCharts.size());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(8192);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            for (ChartPrototype chartPrototype : this.mCharts) {
                byteBuffer.putInt(n + byteArrayOutputStream.size());
                chartPrototype.serializeOut(byteBuffer2);
                byteBuffer2.flip();
                byte[] byArray = new byte[byteBuffer2.limit()];
                byteBuffer2.get(byArray);
                byteArrayOutputStream.write(byArray);
                byteBuffer2.clear();
            }
            fileOutputStream.write(byteBuffer.array());
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.close();
            this.mIsModified = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isCustomLibrary() {
        return this.mIsCustom;
    }

    public String getLibfilePath() {
        return this.mLibfilePath;
    }

    public void setLibfilePath(String string) {
        this.mLibfilePath = string;
        this.mIsModified = true;
    }

    public static String getCustomLibFileName() {
        return CUSTOM_LIB_FILE_NAME;
    }

    private boolean loadCurrentVersion(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = byteBuffer.getInt();
        }
        for (int n2 : nArray) {
            byteBuffer.position(n2);
            ChartPrototype chartPrototype = new ChartPrototype(0);
            if (!chartPrototype.serializeIn(byteBuffer)) continue;
            this.mCharts.add(chartPrototype);
        }
        return true;
    }

    private boolean loadBaseVersion(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            ChartPrototype chartPrototype = new ChartPrototype(0);
            if (!chartPrototype.serializeIn(byteBuffer)) {
                return false;
            }
            this.mCharts.add(chartPrototype);
        }
        this.mIsModified = true;
        return true;
    }
}

