/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.IExtension;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasDragAdapter;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartPrototype;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartVarTransferData;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ElementDragAdapter;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ElementTransferData;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ICanvasChangeListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ITitles;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.IndexVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.TitleMgr;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneChangeType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneMgr;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.AddToFavoritesDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.GroupingZoneDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.YXPairs;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.AddElementEdit;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.AddVariablesEdit;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.AddZoneEdit;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.ApplyGalleryChartEdit;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.ChangeCoordsEdit;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.ClearCanvasEdit;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.RemoveVariablesEdit;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.RemoveZoneEdit;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo.TransposeEdit;
import com.spss.uitools.canvas.BaseCanvas;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.res.IResourceAccessor;
import com.spss.uitools.util.IOptionConstants;
import com.spss.vis.ItemInfo;
import com.spss.vis.ResultsProcessor;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.processors.picking.InformationProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class ChartCanvas
extends BaseCanvas
implements IDropListener {
    private String mEmptyCanvasText = "";
    private Vector<ICanvasChangeListener> mChangeListeners = new Vector();
    private CanvasImager mImager = new CanvasImager(this);
    private Rectangle mChartBounds = new Rectangle(50, 50, 300, 200);
    private ZoneMgr mZoneMgr;
    private boolean mShowVarLabels;
    private CanvasDragAdapter mDragAdapter = null;
    private TitleMgr mTitleMgr = new TitleMgr(this);
    private ISpssVariable[] mLocalClipboard = null;
    private JCheckBoxMenuItem mPropsMenuItem = null;
    private boolean mInDeserialize = false;
    private AddGroupingZoneAction mAddGroupingZoneAction;
    private EditGroupingZoneAction mEditGroupingZoneAction;
    private DeleteGroupingZoneAction mDeleteGroupingZoneAction;
    private AddRemoveZoneAction mAddColPanelAction;
    private AddRemoveZoneAction mRemoveColPanelAction;
    private AddRemoveZoneAction mAddRowPanelAction;
    private AddRemoveZoneAction mRemoveRowPanelAction;
    private AddRemoveZoneAction mAddPointIdAction;
    private AddRemoveZoneAction mRemovePointIdAction;
    private JMenu mDeleteSubmenu;
    private boolean mDrawOuterFrameBorder;

    public ChartCanvas(IResourceAccessor iResourceAccessor) {
        super(iResourceAccessor);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = dimension.width <= 800 || dimension.height <= 600 ? new Dimension(350, 200) : new Dimension(400, 260);
        this.setPreferredSize(dimension2);
        this.mZoneMgr = new ZoneMgr(this, iResourceAccessor);
        this.initContextMenu();
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node("general");
        this.mShowVarLabels = preferences3.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS).equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 122) {
                    ChartCanvas.this.viewXML();
                } else if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                    ChartCanvas.this.mZoneMgr.navKeyPressed(keyEvent.getKeyCode());
                }
            }
        });
    }

    public void reset() {
        this.mImager.setEmpty();
        this.mZoneMgr.clear();
        this.mTitleMgr.clear();
        this.recalcCanvasSize();
        this.repaint();
        this.fireChangeEvent(CanvasChangeEvent.ChangeType.elementChange);
    }

    public boolean chartComplete() {
        if (this.mImager.isEmpty()) {
            return false;
        }
        boolean bl = this.mZoneMgr.sufficientVariables();
        if (bl) {
            int n = 1;
            if (this.mImager.getCoordinates() == Coords.coords_DualY) {
                n = 2;
            }
            bl = this.mImager.dataElementCount() >= n;
        }
        return bl;
    }

    public boolean hasVariables() {
        return this.mZoneMgr.hasVariables();
    }

    public boolean getShowVarLabels() {
        return this.mShowVarLabels;
    }

    public void setEmptyCanvasText(String string) {
        this.mEmptyCanvasText = string;
        if (this.isEmpty()) {
            this.getAccessibleContext().setAccessibleName(this.mEmptyCanvasText);
            this.repaint();
        }
    }

    public boolean isEmpty() {
        return this.mImager.isEmpty();
    }

    public boolean isTransposed() {
        return this.mImager.isTransposed();
    }

    public void transpose() {
        new TransposeEdit(this.getUndoManager(), this.getParentDlg());
    }

    public void addChangeListener(ICanvasChangeListener iCanvasChangeListener) {
        if (!this.mChangeListeners.contains(iCanvasChangeListener)) {
            this.mChangeListeners.add(iCanvasChangeListener);
        }
    }

    public void removeChangeListener(ICanvasChangeListener iCanvasChangeListener) {
        this.mChangeListeners.remove(iCanvasChangeListener);
    }

    public void addZone(ZoneType zoneType) {
        new AddZoneEdit(this.getUndoManager(), this.getParentDlg(), zoneType);
    }

    public void removeZone(ZoneType zoneType) {
        new RemoveZoneEdit(this.getUndoManager(), this.getParentDlg(), zoneType);
    }

    public void removeVariables(DropZone dropZone) {
        new RemoveVariablesEdit(this.getUndoManager(), this.getParentDlg(), dropZone.getZoneType());
    }

    public BaseCanvas.CanvasContextMenu getCanvasContextMenu() {
        return super.getCanvasContextMenu();
    }

    public CanvasImager getImager() {
        return this.mImager;
    }

    public ZoneMgr getZoneMgr() {
        return this.mZoneMgr;
    }

    public TitleMgr getTitleMgr() {
        return this.mTitleMgr;
    }

    public ChartProps getProperties() {
        return this.mImager.getProperties();
    }

    public boolean setProperties(ChartProps chartProps) {
        boolean bl;
        boolean bl2 = this.mImager.isOverlayScatter();
        boolean bl3 = this.mImager.hasSSVs();
        boolean bl4 = false;
        boolean bl5 = false;
        Props.ElProps elProps = chartProps.getElementProp(0);
        if (elProps != null && elProps.isModified()) {
            bl4 = true;
        }
        if (chartProps.hasDeletedItems()) {
            bl5 = this.removedDeletedElements(chartProps);
        }
        this.addNewTitles(chartProps);
        if (bl3 && bl4) {
            this.updateModifiedSSVs(chartProps);
            DropZone.updateIndexValueLabelMap(this, this.mZoneMgr.getIndexVariable());
        }
        boolean bl6 = bl = this.mImager.setProperties(chartProps, true) || bl5;
        if (bl) {
            if (bl2) {
                this.updateOverlayZones(chartProps);
            }
            if (bl5) {
                this.mZoneMgr.rebuildZones(this.mImager, this.mImager.getCoordinates());
                this.recalcLayout();
            }
            this.repaint();
        }
        return bl;
    }

    public void setLocalClipboard(ISpssVariable[] iSpssVariableArray) {
        this.mLocalClipboard = iSpssVariableArray;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        DropZone dropZone = this.mZoneMgr.hitTest(mouseEvent.getPoint());
        if (dropZone != null) {
            return dropZone.getZoneText();
        }
        return null;
    }

    public void updateUI() {
        this.removeMouseMotionListener((MouseMotionListener)this.mMouseHandler);
        super.updateUI();
        this.addMouseMotionListener((MouseMotionListener)this.mMouseHandler);
    }

    public void dropGalleryChart(ChartPrototype chartPrototype) {
        new ApplyGalleryChartEdit(this.getUndoManager(), this.getParentDlg(), chartPrototype);
        if (!this.getImager().hasTitle(ITitles.TitleType.title1)) {
            this.getTitleMgr().addTitle(ITitles.TitleType.title1, true);
        }
        if (!this.getImager().hasTitle(ITitles.TitleType.footnote1) && !this.mZoneMgr.getZone(ZoneType.zt_filter).isEmpty()) {
            this.getTitleMgr().addTitle(ITitles.TitleType.footnote1, true);
        }
        if (!(this.getImager().hasTitle(ITitles.TitleType.footnote2) || this.isAutoAllowed(ITitles.TitleType.footnote1) || this.mZoneMgr.getZone(ZoneType.zt_filter).isEmpty())) {
            this.getTitleMgr().addTitle(ITitles.TitleType.footnote2, true);
        }
    }

    public void changeCoordinates(Coords coords) {
        if (coords.equals((Object)this.mImager.getCoordinates())) {
            return;
        }
        new ChangeCoordsEdit(this.getUndoManager(), this.getParentDlg(), coords);
    }

    public void addElement(Elements elements) {
        new AddElementEdit(this.getUndoManager(), this.getParentDlg(), elements);
    }

    public boolean isDeserializing() {
        return this.mInDeserialize;
    }

    public void serializeIn(DataInputStream dataInputStream) {
        try {
            this.mInDeserialize = true;
            this.mZoneMgr.serializeIn(dataInputStream);
            this.mImager.serializeIn(dataInputStream);
            DropZone.setRoleStatDisplay(this.mZoneMgr.hasVariables());
            this.rebuildZones(this.mImager.getCoordinates(), false);
            this.updateTitles();
            this.recalcCanvasSize();
            this.mInDeserialize = false;
            this.fireChangeEvent(CanvasChangeEvent.ChangeType.newChart);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.recalcLayout();
    }

    public boolean serializeOut(DataOutputStream dataOutputStream) {
        try {
            this.mZoneMgr.serializeOut(dataOutputStream);
            this.mImager.serializeOut(dataOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void fireChangeEvent(CanvasChangeEvent.ChangeType changeType) {
        CanvasChangeEvent canvasChangeEvent = new CanvasChangeEvent(this, changeType);
        for (ICanvasChangeListener iCanvasChangeListener : this.mChangeListeners) {
            iCanvasChangeListener.canvasChange(canvasChangeEvent);
        }
    }

    public void recalcLayout() {
        super.recalcLayout();
        this.recalcChartBounds();
        this.updateTitlesText();
        this.mZoneMgr.updateZonePositions(this);
        this.revalidate();
        this.repaint();
    }

    public void rebuildZones(Coords coords, boolean bl) {
        ZoneType[] zoneTypeArray;
        if (this.mZoneMgr.getDropZones().size() > 0) {
            boolean bl2 = this.mImager.getUsesColorByDefault();
            zoneTypeArray = this.mZoneMgr.getDropZones().keySet();
            for (ZoneType zoneType : zoneTypeArray) {
                DropZone dropZone = this.mZoneMgr.getDropZones().get((Object)zoneType);
                if (dropZone == null || dropZone.getUsesColorStyling() == bl2) continue;
                this.mImager.updateVizSpec();
                break;
            }
        }
        this.mZoneMgr.rebuildZones(this.mImager, coords);
        if (bl) {
            for (ZoneType zoneType : zoneTypeArray = ZoneType.values()) {
                DropZone dropZone = this.mZoneMgr.getZone(zoneType);
                if (dropZone == null) continue;
                this.mImager.rebuildVariable(dropZone);
            }
        }
    }

    public void recalcCanvasSize() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getParent().getBounds();
        int n = this.mTitleMgr.getFootnotesHeight();
        rectangle.width = rectangle2.width;
        rectangle.height = rectangle2.height + n;
        if (n > 0) {
            rectangle.width -= 16;
        }
        this.setSize(rectangle.getSize());
        this.setPreferredSize(rectangle.getSize());
    }

    public void adjustOverlayGrouping(boolean bl) {
        Rectangle rectangle = null;
        DropZone dropZone = this.mZoneMgr.getZone(ZoneType.zt_group);
        if (bl) {
            if (dropZone == null) {
                this.mZoneMgr.addZone(this, ZoneType.zt_group);
                dropZone = this.mZoneMgr.getZone(ZoneType.zt_group);
                dropZone.setUsesColorStyling(this.mImager.mStyleCycler.getUseColors());
            }
            dropZone.clear();
            this.mImager.zoneChange(this.mZoneMgr, ZoneType.zt_group, ZoneChangeType.addZone);
            rectangle = dropZone.getBounds().getBounds();
        } else if (dropZone != null) {
            this.mZoneMgr.removeZone(ZoneType.zt_group);
            this.mImager.zoneChange(this.mZoneMgr, ZoneType.zt_group, ZoneChangeType.removeZone);
            rectangle = dropZone.getBounds().getBounds();
        }
        if (rectangle != null) {
            this.repaint(200L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void removeOverlayScatterVariables() {
        DropZone dropZone = this.mZoneMgr.getZone(ZoneType.zt_x);
        DropZone dropZone2 = this.mZoneMgr.getZone(ZoneType.zt_y);
        if (dropZone == null) {
            dropZone = this.mZoneMgr.getZone(ZoneType.zt_slice_by);
        }
        if (dropZone2 == null) {
            dropZone2 = this.mZoneMgr.getZone(ZoneType.zt_angle);
        }
        if (dropZone != null && !dropZone.isEmpty()) {
            dropZone.clear();
            this.mImager.zoneChange(this.mZoneMgr, dropZone.getZoneType(), ZoneChangeType.removeVariable);
        }
        if (dropZone2 != null && !dropZone2.isEmpty()) {
            dropZone2.clear();
            this.mImager.zoneChange(this.mZoneMgr, dropZone2.getZoneType(), ZoneChangeType.removeVariable);
        }
    }

    public void updateTitles() {
        this.mTitleMgr.setTitle(ITitles.TitleType.title1, this.mImager.hasTitle(ITitles.TitleType.title1));
        this.mTitleMgr.setTitle(ITitles.TitleType.title2, this.mImager.hasTitle(ITitles.TitleType.title2));
        this.mTitleMgr.setTitle(ITitles.TitleType.subTitle1, this.mImager.hasTitle(ITitles.TitleType.subTitle1));
        this.mTitleMgr.setTitle(ITitles.TitleType.footnote1, this.mImager.hasTitle(ITitles.TitleType.footnote1));
        this.mTitleMgr.setTitle(ITitles.TitleType.footnote2, this.mImager.hasTitle(ITitles.TitleType.footnote2));
    }

    public void updateTitlesText() {
        String string = this.getTitleText(IPropEnum.TitleFlag.tf_Title1);
        String string2 = this.getTitleText(IPropEnum.TitleFlag.tf_Title2);
        String string3 = this.getTitleText(IPropEnum.TitleFlag.tf_Subtitle);
        if (string != null) {
            this.mTitleMgr.setTitleText(ITitles.TitleType.title1, this.shortenStringAsNeeded(string));
        }
        if (string2 != null) {
            this.mTitleMgr.setTitleText(ITitles.TitleType.title2, this.shortenStringAsNeeded(string2));
        }
        if (string3 != null) {
            this.mTitleMgr.setTitleText(ITitles.TitleType.subTitle1, this.shortenStringAsNeeded(string3));
        }
        this.updateFootnoteText();
    }

    public void updateFootnoteText() {
        String string;
        String string2 = this.getTitleText(IPropEnum.TitleFlag.tf_Footnote1);
        if (string2 == null || string2.length() == 0) {
            string2 = this.getResources().getResString("IDS_F1");
        }
        if ((string = this.getTitleText(IPropEnum.TitleFlag.tf_Footnote2)) == null || string.length() == 0) {
            string = this.getResources().getResString("IDS_F2");
        }
        if (string2 != null) {
            this.mTitleMgr.setTitleText(ITitles.TitleType.footnote1, this.shortenStringAsNeeded(string2));
        }
        if (string != null) {
            this.mTitleMgr.setTitleText(ITitles.TitleType.footnote2, this.shortenStringAsNeeded(string));
        }
    }

    private String shortenStringAsNeeded(String string) {
        if (string == null) {
            return null;
        }
        int n = (int)(this.mChartBounds.getWidth() - 10.0);
        int n2 = string.indexOf("\n");
        if (n2 > -1) {
            string = string.substring(0, n2);
        }
        return this.getClippedStringAsNeeded(string, n);
    }

    private String getClippedStringAsNeeded(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((n2 += this.getGraphics().getFontMetrics().charWidth(c)) > n) {
                stringBuilder.append("...");
                break;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String getTitleText(IPropEnum.TitleFlag titleFlag) {
        String string;
        Props.TitleProps titleProps = this.getTitleProp(titleFlag);
        String string2 = null;
        if (titleProps != null && (string = this.getTitle1Str(titleProps)) != null && string.length() > 0) {
            string2 = string;
        }
        return string2;
    }

    public boolean isAutoAllowed(ITitles.TitleType titleType) {
        boolean bl = false;
        IPropEnum.TitleFlag titleFlag = this.titleTypeToTitleFlag(titleType);
        Props.TitleProps titleProps = this.getTitleProp(titleFlag);
        if (titleProps != null && (titleProps.getFlags() & 0x8002) != 0) {
            bl = true;
        }
        return bl;
    }

    private Props.TitleProps getTitleProp(IPropEnum.TitleFlag titleFlag) {
        for (Props props : this.getProperties().getProperties()) {
            if (!(props instanceof Props.TitleProps) || ((Props.TitleProps)props).getTitleType() != titleFlag) continue;
            return (Props.TitleProps)props;
        }
        return null;
    }

    private String getTitle1Str(Props.TitleProps titleProps) {
        String string = titleProps.getStrTitle();
        String string2 = this.getImager().getChartAppearanceOption().getTemplateTitle(this.titleFlagToTitleType(titleProps.getTitleType()));
        int n = titleProps.getUseIndex();
        if (string.length() > 0) {
            return string;
        }
        if (string2 != null && string2.length() > 0) {
            string = string2;
        } else if ((n < 0 || n == 0) && (titleProps.getFlags() & 0x8002) != 0) {
            string = titleProps.getTitleType() == IPropEnum.TitleFlag.tf_Title1 ? this.composeDefaultTitle() : this.composeDefaultFootnote();
        }
        return string;
    }

    public ChartBuilderDlg getParentDlg() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof ChartBuilderDlg); container = container.getParent()) {
        }
        return container != null ? (ChartBuilderDlg)((Object)container) : null;
    }

    public ZoneType getNewGroupingZoneType() {
        ChartProps chartProps = this.getProperties();
        Coords coords = chartProps.getCoords();
        Props.ElProps elProps = chartProps.getElementProp(0);
        Elements elements = elProps != null ? elProps.getElement() : null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = this.getZoneMgr().hasZone(ZoneType.zt_group);
        boolean bl5 = this.getZoneMgr().hasZone(ZoneType.zt_cluster_x);
        boolean bl6 = this.getZoneMgr().hasZone(ZoneType.zt_cluster_z);
        if (elements != null) {
            boolean bl7 = this.getZoneMgr().hasScaleVar(ZoneType.zt_x);
            boolean bl8 = this.getZoneMgr().hasScaleVar(ZoneType.zt_z);
            boolean bl9 = coords.equals((Object)Coords.coords_DualY);
            if (elements.equals((Object)Elements.hilo)) {
                if (!bl7 && !bl9) {
                    bl = true;
                }
            } else if (elements.equals((Object)Elements.interval)) {
                if (coords.equals((Object)Coords.coords_2D)) {
                    if (!(bl4 || bl7 || bl9 || this.mImager.isHistogram())) {
                        bl = true;
                    }
                    if (!bl5 && !bl9) {
                        bl3 = true;
                    }
                } else {
                    if (!(bl7 || bl4 && bl6)) {
                        bl = true;
                    }
                    if (!(bl8 || bl4 && bl5)) {
                        bl2 = true;
                    }
                    if (!bl5 || !bl6) {
                        bl3 = true;
                    }
                }
            } else if (elements.equals((Object)Elements.area) || elements.equals((Object)Elements.line) || elements.equals((Object)Elements.point)) {
                if (!bl9) {
                    bl3 = true;
                }
            } else if (elements.equals((Object)Elements.schema)) {
                if (coords.equals((Object)Coords.coords_2D) && !bl7 && !bl9) {
                    bl = true;
                }
            } else if (elements.equals((Object)Elements.splom)) {
                bl3 = true;
            }
        }
        if (bl && !bl5) {
            return ZoneType.zt_cluster_x;
        }
        if (bl2 && !bl6) {
            return ZoneType.zt_cluster_z;
        }
        if (bl3 && !bl4) {
            return ZoneType.zt_group;
        }
        assert (false);
        return ZoneType.zt_group;
    }

    public boolean legalStat(ChartProps chartProps, Statistics statistics, int n) {
        MeasurementLevel measurementLevel;
        boolean bl;
        ISpssVariable iSpssVariable;
        DropZone dropZone;
        boolean bl2;
        boolean bl3 = false;
        Props.ElProps elProps = chartProps.getElementProp(n);
        if (elProps == null) {
            return false;
        }
        boolean bl4 = elProps instanceof Props.PointProps;
        boolean bl5 = elProps instanceof Props.MatrixProps;
        boolean bl6 = elProps instanceof Props.PyramidProps;
        boolean bl7 = this.mImager.isHiLoClose();
        boolean bl8 = this.mImager.isDifferenceArea();
        boolean bl9 = chartProps.getCoords() == Coords.coords_DualY;
        boolean bl10 = bl2 = bl9 && this.mImager.dualYElementWithFirstYAxis(elProps.getStrElId());
        if (chartProps.getCoords() == Coords.coords_Polar) {
            dropZone = this.mZoneMgr.getZone(ZoneType.zt_slice_by);
            iSpssVariable = dropZone != null && !dropZone.isEmpty() ? dropZone.getVariables().get(0) : null;
            bl = iSpssVariable instanceof SpssMRVariable;
        } else {
            dropZone = this.mZoneMgr.getZone(ZoneType.zt_x);
            iSpssVariable = dropZone != null && !dropZone.isEmpty() ? dropZone.getVariables().get(0) : null;
            bl = iSpssVariable instanceof SpssMRVariable;
        }
        dropZone = null;
        if (chartProps.getCoords() == Coords.coords_Polar) {
            dropZone = this.mZoneMgr.getZone(ZoneType.zt_angle);
        } else if (bl7 || bl8) {
            dropZone = this.mZoneMgr.getZone(ZoneType.zt_high);
        } else if (bl5) {
            dropZone = this.mZoneMgr.getZone(ZoneType.zt_matrix);
        } else if (bl6) {
            dropZone = this.mZoneMgr.getZone(ZoneType.zt_dist_var);
        } else if (bl9) {
            dropZone = bl2 ? this.mZoneMgr.getZone(ZoneType.zt_y) : this.mZoneMgr.getZone(ZoneType.zt_y2);
        } else if (chartProps.getCoords() != Coords.coords_1D) {
            dropZone = this.mZoneMgr.getZone(ZoneType.zt_y);
        }
        if (dropZone == null) {
            return false;
        }
        int n2 = dropZone.getVariables().size();
        ISpssVariable iSpssVariable2 = n2 > 0 ? dropZone.getVariables().get(0) : null;
        boolean bl11 = iSpssVariable2 instanceof SpssMRVariable;
        boolean bl12 = iSpssVariable2 != null && iSpssVariable2.getType() > 0;
        MeasurementLevel measurementLevel2 = measurementLevel = iSpssVariable2 != null ? iSpssVariable2.getDisplayMeasurementLevel() : MeasurementLevel.unknown;
        if (bl7 || bl8) {
            n2 = 1;
            measurementLevel = MeasurementLevel.scale;
        }
        if (n2 == 0) {
            if (this.mImager.isPopulationPyramid()) {
                dropZone = this.mZoneMgr.getZone(ZoneType.zt_dist_var);
                n2 = dropZone.getVariables().size();
                boolean bl13 = this.mZoneMgr.hasScaleVar(ZoneType.zt_dist_var);
                if (n2 > 0 && bl13 && statistics != Statistics.Histogram) {
                    return false;
                }
                return n2 <= 0 || bl13 || statistics == Statistics.Count;
            }
            if (statistics == Statistics.Histogram || statistics == Statistics.HistogramPct) {
                if (elProps != null && chartProps.getCoords() == Coords.coords_2D) {
                    if (bl4 && ((Props.PointProps)elProps).getHasDropLine()) {
                        return false;
                    }
                    Elements elements = elProps.getElement();
                    boolean bl14 = this.mImager.hasXCluster() || this.mImager.hasZCluster();
                    boolean bl15 = this.mZoneMgr.hasCatVar(ZoneType.zt_x);
                    if (!(bl15 || bl14 || elements != Elements.interval && elements != Elements.area && elements != Elements.line)) {
                        return true;
                    }
                }
                return false;
            }
            if (bl) {
                bl3 = statistics != Statistics.Value;
            } else {
                boolean bl16 = bl3 = statistics != Statistics.Responses && statistics != Statistics.CumResponses && statistics != Statistics.ResponsePct && statistics != Statistics.CumResponsePct;
                if (bl3 && chartProps.getHasSSVs()) {
                    boolean bl17 = bl3 = statistics != Statistics.Value;
                }
            }
            if (bl3 && Coords.coords_Polar == chartProps.getCoords()) {
                boolean bl18 = bl3 = statistics == Statistics.Count || statistics == Statistics.PctOfCases || statistics == Statistics.Value || statistics == Statistics.Sum;
                if (!bl3 && this.hasMRVarsInDataSet()) {
                    bl3 = statistics == Statistics.Responses || statistics == Statistics.ResponsePct;
                }
            }
        } else if (statistics == Statistics.Count || statistics == Statistics.CumCount || statistics == Statistics.PctOfCases || statistics == Statistics.CumPct) {
            bl3 = false;
        } else if (statistics == Statistics.Value) {
            bl3 = !bl && !chartProps.getHasSSVs() && (bl12 || !bl11 && (measurementLevel == MeasurementLevel.scale || measurementLevel == MeasurementLevel.nominal || measurementLevel == MeasurementLevel.ordinal));
        } else if (statistics == Statistics.Mode) {
            bl3 = chartProps.getCoords() != Coords.coords_Polar && !bl12 && !bl11 && (measurementLevel == MeasurementLevel.scale || measurementLevel == MeasurementLevel.nominal || measurementLevel == MeasurementLevel.ordinal);
        } else if (statistics == Statistics.Median || statistics == Statistics.Minimum || statistics == Statistics.Maximum) {
            bl3 = chartProps.getCoords() != Coords.coords_Polar && !bl12 && !bl11 && (measurementLevel == MeasurementLevel.scale || measurementLevel == MeasurementLevel.ordinal);
        } else if (statistics == Statistics.Sum) {
            bl3 = !bl12 && !bl11 && measurementLevel == MeasurementLevel.scale;
        } else if (statistics == Statistics.GMedian || statistics == Statistics.ValidN || statistics == Statistics.Mean || statistics == Statistics.PTile || statistics == Statistics.GPTile || statistics == Statistics.StdDev || statistics == Statistics.Variance || statistics == Statistics.NumAbove || statistics == Statistics.NumBelow || statistics == Statistics.PctAbove || statistics == Statistics.PctBelow || statistics == Statistics.PctInside || statistics == Statistics.NumInside) {
            bl3 = chartProps.getCoords() != Coords.coords_Polar && !bl12 && measurementLevel == MeasurementLevel.scale && !bl11;
        } else if (statistics == Statistics.CumSum) {
            boolean bl19 = bl3 = chartProps.getCoords() != Coords.coords_Polar && !bl12 && !bl7 && !bl8 && measurementLevel == MeasurementLevel.scale && !bl11;
        }
        if (bl3 && bl4 && ((Props.PointProps)elProps).getHasDropLine()) {
            boolean bl20 = bl3 = statistics != Statistics.Value && statistics != Statistics.Histogram && statistics != Statistics.HistogramPct;
        }
        if (bl3 && bl5) {
            bl3 = statistics == Statistics.Value;
        }
        return bl3;
    }

    public Statistics getDefaultStatistic(ChartProps chartProps) {
        ZoneType zoneType = ZoneType.zt_y;
        Coords coords = chartProps.getCoords();
        if (coords == Coords.coords_Polar) {
            zoneType = ZoneType.zt_angle;
        } else if (this.mImager.isDifferenceArea()) {
            zoneType = ZoneType.zt_high;
        }
        return this.defaultStat(chartProps, zoneType);
    }

    private Statistics defaultStat(ChartProps chartProps, ZoneType zoneType) {
        DropZone dropZone;
        Coords coords = chartProps.getCoords();
        Statistics statistics = Statistics.Count;
        boolean bl = this.mZoneMgr.hasMRVars();
        boolean bl2 = this.mImager.hasSSVs();
        boolean bl3 = this.mZoneMgr.hasScaleVar(ZoneType.zt_x);
        Props.ElProps elProps = chartProps.getElementProp(0);
        boolean bl4 = elProps instanceof Props.PointProps;
        DropZone dropZone2 = this.mZoneMgr.getZone(zoneType);
        if (dropZone2 != null) {
            MeasurementLevel measurementLevel = MeasurementLevel.unknown;
            Vector<ISpssVariable> vector = dropZone2.getVariables();
            short s = 0;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                dropZone = vector.get(i);
                if (0 == i) {
                    measurementLevel = dropZone.getDisplayMeasurementLevel();
                    s = dropZone.getType();
                    continue;
                }
                if (dropZone.getDisplayMeasurementLevel() == measurementLevel) continue;
                measurementLevel = MeasurementLevel.unknown;
                break;
            }
            statistics = zoneType == ZoneType.zt_high ? Statistics.Mean : (bl4 && !bl2 && !bl ? Statistics.Value : (0 == n ? Statistics.Count : (coords == Coords.coords_Polar ? Statistics.Sum : (bl ? Statistics.ValidN : (s > 0 ? Statistics.Value : (measurementLevel == MeasurementLevel.nominal || measurementLevel == MeasurementLevel.ordinal ? Statistics.Value : (bl3 && !bl2 ? Statistics.Value : Statistics.Mean)))))));
        }
        if (this.mImager.isPopulationPyramid()) {
            dropZone = this.mZoneMgr.getZone(ZoneType.zt_dist_var);
            boolean bl5 = dropZone != null && !dropZone.isEmpty();
            boolean bl6 = this.mZoneMgr.hasScaleVar(ZoneType.zt_dist_var);
            if (!bl5 || !bl6) {
                statistics = Statistics.Count;
                this.mImager.removeNormalCurve();
            } else {
                statistics = Statistics.Histogram;
            }
        }
        return statistics;
    }

    public void checkStatistic() {
        ElementStat elementStat;
        ChartProps chartProps = this.mImager.getProperties();
        Props.ElProps elProps = chartProps.getElementProp(0);
        if (elProps != null && !this.legalStat(chartProps, (elementStat = elProps.getStatistic()).getStat(), 0)) {
            elementStat.setStat(this.getDefaultStatistic(chartProps));
            elementStat.setStrParm1("");
            elementStat.setStrParm2("");
            elementStat.setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
            if (elementStat.getStat() != Statistics.Mean) {
                elProps.setErrorIntervalType(IPropEnum.ErrorIntervalType.eit_Confidence);
            }
            this.setProperties(chartProps);
        }
        if (this.mImager.getCoordinates() == Coords.coords_DualY && (elProps = chartProps.getElementProp(1)) != null && !this.legalStat(chartProps, (elementStat = elProps.getStatistic()).getStat(), 1)) {
            elementStat.setStat(this.defaultStat(chartProps, ZoneType.zt_y2));
            elementStat.setStrParm1("");
            elementStat.setStrParm2("");
            elementStat.setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
            if (elementStat.getStat() != Statistics.Mean) {
                elProps.setErrorIntervalType(IPropEnum.ErrorIntervalType.eit_Confidence);
            }
            this.setProperties(chartProps);
        }
    }

    public boolean checkForHistogramChange(ZoneType zoneType) {
        ElementStat elementStat;
        boolean bl;
        Elements elements = this.mImager.getPrimaryElementType();
        boolean bl2 = bl = elements == Elements.area || elements == Elements.interval || elements == Elements.line;
        if (zoneType != ZoneType.zt_x || !bl || this.mImager.getCoordinates() != Coords.coords_2D) {
            return false;
        }
        DropZone dropZone = this.mZoneMgr.getZone(zoneType);
        if (dropZone.getVariables().size() != 1 || dropZone.getVariables().get(0).getDisplayMeasurementLevel() != MeasurementLevel.scale) {
            return false;
        }
        DropZone dropZone2 = this.mZoneMgr.getZone(ZoneType.zt_y);
        if (dropZone2 == null || dropZone2.getVariables().size() != 0) {
            return false;
        }
        ChartProps chartProps = this.mImager.getProperties();
        Props.ElProps elProps = chartProps.getElementProp(0);
        ElementStat elementStat2 = elementStat = elProps != null ? elProps.getStatistic() : null;
        if (elementStat != null && elementStat.getStat() != Statistics.Histogram && elementStat.getStat() != Statistics.HistogramPct) {
            Props.AxisProps axisProps;
            elementStat.setStat(Statistics.Histogram);
            elementStat.setStrParm1("");
            elementStat.setStrParm2("");
            elementStat.setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
            elProps.setErrorIntervalType(IPropEnum.ErrorIntervalType.eit_Confidence);
            Props props = chartProps.getProperties().get(1);
            Props.AxisProps axisProps2 = axisProps = props instanceof Props.AxisProps ? (Props.AxisProps)props : null;
            if (axisProps != null) {
                axisProps.setFlags(15);
            }
            if (this.mImager.hasErrorBars()) {
                int n = elProps.getFlags();
                elProps.setFlags(n &= 0xFFFFFFEF);
                for (Props props2 : chartProps.getProperties()) {
                    Props.TitleProps titleProps;
                    if (!(props2 instanceof Props.TitleProps) || (titleProps = (Props.TitleProps)props2).getTitleType() != IPropEnum.TitleFlag.tf_Footnote1) continue;
                    titleProps.setDeleted(true);
                    break;
                }
            }
            this.setProperties(chartProps);
            return true;
        }
        return false;
    }

    public void setHighlights(String string) {
        this.mImager.setHighlights(string);
        this.repaint();
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        return dragDropAdapter instanceof ElementDragAdapter;
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        if (this.pointWithin(point)) {
            Object object;
            if (dragDropAdapter instanceof ElementDragAdapter) {
                return Cursor.getPredefinedCursor(12);
            }
            if (dragDropAdapter instanceof ListDragAdapter) {
                Object object2 = dragDropAdapter.getTransferData();
                if (object2 instanceof VariableList.TransferData) {
                    Point point2 = new Point(point);
                    SwingUtilities.convertPointFromScreen(point2, (Component)((Object)this));
                    DropZone dropZone = this.mZoneMgr.hitTest(point2);
                    ISpssVariable[] iSpssVariableArray = ((VariableList.TransferData)object2).getVariables();
                    if (dropZone != null && dropZone.canDrop(iSpssVariableArray)) {
                        this.mZoneMgr.highlightZone(dropZone, iSpssVariableArray, point2);
                        return Cursor.getPredefinedCursor(12);
                    }
                }
            } else if (dragDropAdapter instanceof CanvasDragAdapter && (object = dragDropAdapter.getTransferData()) instanceof ChartVarTransferData) {
                Point point3 = new Point(point);
                SwingUtilities.convertPointFromScreen(point3, (Component)((Object)this));
                Vector<ISpssVariable> vector = ((ChartVarTransferData)object).getVariables();
                DropZone dropZone = this.mZoneMgr.hitTest(point3);
                ISpssVariable[] iSpssVariableArray = new ISpssVariable[vector.size()];
                if (dropZone != null && dropZone.canDrop(vector.toArray(iSpssVariableArray))) {
                    this.mZoneMgr.highlightZone(dropZone, iSpssVariableArray, point3);
                    return Cursor.getPredefinedCursor(12);
                }
            }
        }
        this.mZoneMgr.clearHighlights();
        return null;
    }

    public void itemDropped(DropEvent dropEvent) {
        Object object;
        boolean bl = false;
        boolean bl2 = this.mImager.hasSSVs();
        Object object2 = dropEvent.getTransferData();
        if (this.pointWithin(dropEvent.getDropLocation())) {
            this.paintImmediately(this.getBounds());
            if (object2 instanceof ElementTransferData) {
                object = (ElementTransferData)object2;
                if (((ElementTransferData)object).getSrcType().equals((Object)ElementDragAdapter.DragSrcType.gallery)) {
                    this.dropGalleryChart(((ElementTransferData)object).getProto());
                    this.updateTitlesText();
                } else if (((ElementTransferData)object).getSrcType().equals((Object)ElementDragAdapter.DragSrcType.coordinates)) {
                    this.changeCoordinates(Coords.fromInt(((ElementTransferData)object).getDragItemId()));
                } else if (((ElementTransferData)object).getSrcType().equals((Object)ElementDragAdapter.DragSrcType.elements)) {
                    this.addElement(Elements.fromInt(((ElementTransferData)object).getDragItemId()));
                }
                if (bl2) {
                    this.mImager.removeSSVVariables();
                    if (this.mZoneMgr.getIndexVarZoneType() != null) {
                        this.updateImagerSSVs();
                    }
                    this.fireChangeEvent(CanvasChangeEvent.ChangeType.variableChange);
                }
            } else if (object2 instanceof VariableList.TransferData) {
                object = (VariableList.TransferData)object2;
                Point point = new Point(dropEvent.getDropLocation());
                SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
                DropZone dropZone = this.mZoneMgr.hitTest(point);
                if (dropZone != null && dropZone.canDrop(((VariableList.TransferData)object).getVariables())) {
                    new AddVariablesEdit(this.getUndoManager(), this.getParentDlg(), dropZone.getZoneType(), ((VariableList.TransferData)object).getVariables());
                    bl = bl2;
                    if (dropZone.getZoneType() == ZoneType.zt_filter) {
                        if (dropZone.getVariables().size() < 2) {
                            if (!this.getImager().hasTitle(ITitles.TitleType.footnote1)) {
                                this.getTitleMgr().addTitle(ITitles.TitleType.footnote1, true);
                            } else if (!this.getImager().hasTitle(ITitles.TitleType.footnote2)) {
                                this.getTitleMgr().addTitle(ITitles.TitleType.footnote2, true);
                            }
                        }
                        this.getParentDlg().chartItemHit((Object)dropZone.getZoneType(), dropZone, dropZone.getVariables().size() - 1);
                    }
                }
                this.updateTitlesText();
            } else if (object2 instanceof ChartVarTransferData) {
                object = (ChartVarTransferData)object2;
                Point point = new Point(dropEvent.getDropLocation());
                SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
                Vector<ISpssVariable> vector = ((ChartVarTransferData)object).getVariables();
                DropZone dropZone = this.mZoneMgr.hitTest(point);
                ISpssVariable[] iSpssVariableArray = new ISpssVariable[vector.size()];
                if (dropZone != null && dropZone.canDrop(vector.toArray(iSpssVariableArray))) {
                    new AddVariablesEdit(this.getUndoManager(), this.getParentDlg(), dropZone.getZoneType(), iSpssVariableArray);
                }
                bl = bl2 || vector.size() == 1 && vector.get(0) instanceof IndexVariable;
            }
        } else {
            bl = bl2;
        }
        this.mZoneMgr.clearHighlights();
        this.clearHighlight2();
        object = this.mZoneMgr.getZone(ZoneType.zt_filter);
        if (object != null && ((DropZone)object).isEmpty()) {
            if (this.isAutoAllowed(ITitles.TitleType.footnote1)) {
                this.mTitleMgr.removeTitle(ITitles.TitleType.footnote1);
            }
            if (this.isAutoAllowed(ITitles.TitleType.footnote2)) {
                this.mTitleMgr.removeTitle(ITitles.TitleType.footnote2);
            }
        }
        if (bl) {
            if (object2 instanceof ChartVarTransferData) {
                if (this.mZoneMgr.getIndexVarZoneType() == null) {
                    this.mZoneMgr.removeSSVVariables();
                    this.fireChangeEvent(CanvasChangeEvent.ChangeType.variableChange);
                }
            } else if (!this.mImager.hasSSVs()) {
                this.mZoneMgr.removeSSVVariables();
                this.fireChangeEvent(CanvasChangeEvent.ChangeType.variableChange);
            }
        }
    }

    public boolean hasDateOnY() {
        Vector<ISpssVariable> vector;
        DropZone dropZone = this.getZoneMgr().getZone(ZoneType.zt_y);
        Vector<ISpssVariable> vector2 = vector = dropZone != null ? dropZone.getVariables() : null;
        if (vector != null && vector.size() > 0) {
            ISpssVariable iSpssVariable = vector.get(0);
            return iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat();
        }
        return false;
    }

    public String composeDefaultTitle() {
        DropZone dropZone = this.mZoneMgr.getZone(ZoneType.zt_y);
        DropZone dropZone2 = this.mZoneMgr.getZone(ZoneType.zt_high);
        DropZone dropZone3 = this.mZoneMgr.getZone(ZoneType.zt_low);
        DropZone dropZone4 = this.mZoneMgr.getZone(ZoneType.zt_close);
        DropZone dropZone5 = this.mZoneMgr.getZone(ZoneType.zt_angle);
        DropZone dropZone6 = this.mZoneMgr.getZone(ZoneType.zt_y2);
        DropZone dropZone7 = this.mZoneMgr.getZone(ZoneType.zt_dist_var);
        Vector<ISpssVariable> vector = dropZone != null ? dropZone.getVariables() : null;
        ISpssVariable iSpssVariable = dropZone6 != null && dropZone6.getVariables().size() > 0 ? dropZone6.getVariables().get(0) : null;
        String string = this.mResources.getResString("IDS_TITLE_OF") != null ? this.mResources.getResString("IDS_TITLE_OF") : "of";
        Statistics statistics = this.getImager().getPrimaryStatistic();
        Statistics statistics2 = this.getImager().getSecondaryStatistic();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getImager().getProtoTypeTitle();
        stringBuffer.append(string2);
        ChartProps chartProps = this.getImager().getProperties();
        Props.ElProps elProps = chartProps.getElementProp(0);
        ElementStat elementStat = null;
        if (elProps != null) {
            elementStat = elProps.getStatistic();
        }
        boolean bl = this.getImager().hasSSVs();
        Props.SSVData sSVData = null;
        if (bl && (sSVData = this.getImager().getSSVData()) != null && sSVData.getSSVVariables().size() > 0) {
            elementStat = sSVData.getSSVVariables().get(0);
        }
        if (!(elementStat == null || statistics == Statistics.Value || this.mImager.isSchema() || this.mImager.isHiLoClose() || this.mImager.isDifferenceArea() || this.mImager.isHistogram() || this.mImager.isSingleDimensionDotPlot())) {
            stringBuffer.append(" ");
            stringBuffer.append(elementStat.getStat().getStatLabel(this.getResources(), elementStat));
        }
        int n = 0;
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append(i == 0 ? " " : "");
                if (i > 0) {
                    stringBuffer.append(", ");
                    if (bl && sSVData != null) {
                        elementStat = sSVData.getSSVVariables().get(i);
                    }
                    String string3 = elementStat.getStat().getStatLabel(this.getResources(), elementStat);
                    stringBuffer.append(string3);
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string).append(" ");
                stringBuffer.append(this.getVarTitleValue(vector.get(i)));
                ++n;
            }
        } else if (dropZone5 != null && dropZone5.getVariables() != null && dropZone5.getVariables().size() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string).append(" ");
            stringBuffer.append(this.getVarTitleValue(dropZone5.getVariables().get(0)));
            ++n;
        } else if (this.mImager.isHiLoClose() || this.mImager.isDifferenceArea()) {
            ElementStat elementStat2 = this.getImager().getStatForDependentZone(ZoneType.zt_high);
            if (n < 4 && dropZone2.getVariables() != null && dropZone2.getVariables().size() > 0) {
                if (n == 3) {
                    return stringBuffer.append("...").toString();
                }
                stringBuffer.append(" ");
                stringBuffer.append(elementStat2.getStat().getUserString(this.getResources()));
                stringBuffer.append(" ").append(string).append(" ");
                stringBuffer.append(this.getVarTitleValue(dropZone2.getVariables().get(0)));
                ++n;
            }
            elementStat2 = this.getImager().getStatForDependentZone(ZoneType.zt_low);
            if (n < 4 && dropZone3.getVariables() != null && dropZone3.getVariables().size() > 0) {
                if (n == 3) {
                    return stringBuffer.append("...").toString();
                }
                stringBuffer.append(dropZone2.getVariables().size() > 0 ? "," : " ");
                stringBuffer.append(elementStat2.getStat().getUserString(this.getResources()));
                stringBuffer.append(" ").append(string).append(" ");
                stringBuffer.append(this.getVarTitleValue(dropZone3.getVariables().get(0)));
                ++n;
            }
            elementStat2 = this.getImager().getStatForDependentZone(ZoneType.zt_close);
            if (n < 4 && dropZone4 != null && dropZone4.getVariables() != null && dropZone4.getVariables().size() > 0) {
                if (n == 3) {
                    return stringBuffer.append("...").toString();
                }
                stringBuffer.append(dropZone2.getVariables().size() > 0 || dropZone3.getVariables().size() > 0 ? "," : " ");
                stringBuffer.append(elementStat2.getStat().getUserString(this.getResources()));
                stringBuffer.append(" ").append(string).append(" ");
                stringBuffer.append(this.getVarTitleValue(dropZone4.getVariables().get(0)));
                ++n;
            }
        }
        if (dropZone6 != null) {
            stringBuffer.append(",");
            if (iSpssVariable == null) {
                stringBuffer.append(statistics2.getUserString(this.getResources()));
            } else {
                stringBuffer.append(statistics.getUserString(this.getResources()));
                stringBuffer.append(" ").append(string).append(" ");
                stringBuffer.append(this.getVarTitleValue(iSpssVariable));
            }
            stringBuffer.append(" ");
            ++n;
        }
        if (dropZone7 != null) {
            ISpssVariable iSpssVariable2;
            ISpssVariable iSpssVariable3 = iSpssVariable2 = dropZone7 != null && dropZone7.getVariables().size() > 0 ? dropZone7.getVariables().get(0) : null;
            if (iSpssVariable2 != null) {
                stringBuffer.append(" ");
                stringBuffer.append(this.getVarTitleValue(iSpssVariable2));
                stringBuffer.append(" ");
                ++n;
            }
        }
        n = this.addZoneVarsTitle(stringBuffer, ZoneType.zt_x, n);
        if (stringBuffer.lastIndexOf("...") == stringBuffer.length() - 3) {
            return stringBuffer.toString();
        }
        n = this.addZoneVarsTitle(stringBuffer, ZoneType.zt_z, n);
        if (stringBuffer.lastIndexOf("...") == stringBuffer.length() - 3) {
            return stringBuffer.toString();
        }
        n = this.addZoneVarsTitle(stringBuffer, ZoneType.zt_matrix, n);
        if (stringBuffer.lastIndexOf("...") == stringBuffer.length() - 3) {
            return stringBuffer.toString();
        }
        n = this.addZoneVarsTitle(stringBuffer, ZoneType.zt_group, n);
        if (stringBuffer.lastIndexOf("...") == stringBuffer.length() - 3) {
            return stringBuffer.toString();
        }
        n = this.addZoneVarsTitle(stringBuffer, ZoneType.zt_split_var, n);
        if (stringBuffer.lastIndexOf("...") == stringBuffer.length() - 3) {
            return stringBuffer.toString();
        }
        n = this.addZoneVarsTitle(stringBuffer, ZoneType.zt_cluster_x, n);
        if (stringBuffer.lastIndexOf("...") == stringBuffer.length() - 3) {
            return stringBuffer.toString();
        }
        n = this.addZoneVarsTitle(stringBuffer, ZoneType.zt_cluster_z, n);
        if (stringBuffer.lastIndexOf("...") == stringBuffer.length() - 3) {
            return stringBuffer.toString();
        }
        n = this.addZoneVarsTitle(stringBuffer, ZoneType.zt_slice_by, n);
        if (stringBuffer.lastIndexOf("...") == stringBuffer.length() - 3) {
            return stringBuffer.toString();
        }
        n = this.addZoneVarsTitle(stringBuffer, ZoneType.zt_panel_horz, n);
        if (stringBuffer.lastIndexOf("...") == stringBuffer.length() - 3) {
            return stringBuffer.toString();
        }
        if (n < 4) {
            this.addZoneVarsTitle(stringBuffer, ZoneType.zt_panel_vert, n);
        }
        return stringBuffer.toString();
    }

    public void setDrawOuterFrameBorder(boolean bl) {
        this.mDrawOuterFrameBorder = bl;
    }

    public Vector<ISpssVariable> getFilterVars() {
        Vector<ISpssVariable> vector = null;
        DropZone dropZone = this.getZoneMgr().getZone(ZoneType.zt_filter);
        if (!dropZone.isEmpty()) {
            vector = dropZone.getVariables();
        }
        return vector;
    }

    public String composeDefaultFootnote() {
        Vector<ISpssVariable> vector = this.getFilterVars();
        StringBuffer stringBuffer = new StringBuffer();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            for (ISpssVariable iSpssVariable : vector) {
                if (iSpssVariable != null) {
                    stringBuffer.append(iSpssVariable.getLabel().length() > 0 ? iSpssVariable.getLabel() : (iSpssVariable.getName().length() > 0 ? iSpssVariable.getName() : iSpssVariable.getId().toString()));
                    if (n < vector.size() - 1) {
                        stringBuffer.append(", ");
                    }
                }
                ++n;
            }
        }
        return MessageFormat.format(this.mResources.getResString("IDS_FOOTNOTE_AUTO_TEXT"), stringBuffer.toString());
    }

    private int addZoneVarsTitle(StringBuffer stringBuffer, ZoneType zoneType, int n) {
        String string;
        int n2 = n;
        DropZone dropZone = this.mZoneMgr.getZone(zoneType);
        Vector<ISpssVariable> vector = dropZone != null ? dropZone.getVariables() : null;
        String string2 = this.mResources.getResString("IDS_TITLE_BY") != null ? this.mResources.getResString("IDS_TITLE_BY") : "by";
        String string3 = string = this.mResources.getResString("IDS_TITLE_OF") != null ? this.mResources.getResString("IDS_TITLE_OF") : "of";
        if (vector != null && vector.size() > 0) {
            if (n2 == 3) {
                stringBuffer.append("...");
                return n2;
            }
            if (vector.size() == 1) {
                stringBuffer.append(n2 > 0 ? " " + string2 + " " : " " + string + " ");
                ISpssVariable iSpssVariable = vector.get(0);
                stringBuffer.append(this.getVarTitleValue(iSpssVariable));
                ++n2;
            } else {
                int n3 = 0;
                for (ISpssVariable iSpssVariable : vector) {
                    if (n2 == 3) {
                        stringBuffer.append("...");
                        return n2;
                    }
                    if (n3 > 0) {
                        stringBuffer.append(",");
                    }
                    if (n3 == 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(this.getVarTitleValue(iSpssVariable));
                    ++n3;
                    ++n2;
                }
            }
        }
        return n2;
    }

    protected void onCopy() {
        DropZone dropZone = this.mZoneMgr.getFocusZone();
        if (dropZone != null && !dropZone.isEmpty()) {
            Vector<ISpssVariable> vector = dropZone.getVariables();
            ISpssVariable[] iSpssVariableArray = new ISpssVariable[vector.size()];
            this.setLocalClipboard(vector.toArray(iSpssVariableArray));
        }
    }

    protected void onCut() {
        DropZone dropZone = this.mZoneMgr.getFocusZone();
        if (dropZone != null && !dropZone.isEmpty()) {
            Vector<ISpssVariable> vector = dropZone.getVariables();
            ISpssVariable[] iSpssVariableArray = new ISpssVariable[vector.size()];
            this.setLocalClipboard(vector.toArray(iSpssVariableArray));
            new RemoveVariablesEdit(this.getUndoManager(), this.getParentDlg(), dropZone.getZoneType());
        }
    }

    protected void onDelete() {
        DropZone dropZone = this.mZoneMgr.getFocusZone();
        if (dropZone != null && !dropZone.isEmpty()) {
            boolean bl = dropZone.isIndexZone();
            new RemoveVariablesEdit(this.getUndoManager(), this.getParentDlg(), dropZone.getZoneType());
            if (bl) {
                this.mZoneMgr.removeSSVVariables();
            }
        }
    }

    protected void onPaste() {
        DropZone dropZone = this.mZoneMgr.getFocusZone();
        if (dropZone != null && dropZone.canDrop(this.mLocalClipboard)) {
            new AddVariablesEdit(this.getUndoManager(), this.getParentDlg(), dropZone.getZoneType(), this.mLocalClipboard);
        }
    }

    private boolean pointWithin(Point point) {
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, (Component)((Object)this));
        return this.getBounds().contains(point2);
    }

    private void updateOverlayZones(ChartProps chartProps) {
        Props.ElProps elProps = chartProps.getElementProp(0);
        if (elProps instanceof Props.PointProps) {
            Props.PointProps pointProps = (Props.PointProps)elProps;
            YXPairs yXPairs = pointProps.getYXPairs();
            DropZone dropZone = this.mZoneMgr.getZone(ZoneType.zt_y);
            DropZone dropZone2 = this.mZoneMgr.getZone(ZoneType.zt_x);
            Vector<ISpssVariable> vector = dropZone.getVariables();
            Vector<ISpssVariable> vector2 = dropZone2.getVariables();
            Vector<ISpssVariable> vector3 = new Vector<ISpssVariable>();
            Vector<ISpssVariable> vector4 = new Vector<ISpssVariable>();
            for (ISpssVariable iSpssVariable : vector) {
                if (yXPairs.containsVariable(iSpssVariable.getName())) continue;
                vector3.add(iSpssVariable);
            }
            for (ISpssVariable iSpssVariable : vector2) {
                if (yXPairs.containsVariable(iSpssVariable.getName())) continue;
                vector4.add(iSpssVariable);
            }
            for (ISpssVariable iSpssVariable : vector3) {
                vector.remove(iSpssVariable);
            }
            for (ISpssVariable iSpssVariable : vector4) {
                vector2.remove(iSpssVariable);
            }
            if (vector.size() < 2) {
                this.adjustOverlayGrouping(false);
                vector2.clear();
            }
        }
    }

    private void addNewTitles(ChartProps chartProps) {
        boolean bl = false;
        for (Props props : chartProps.getProperties()) {
            if (!(props instanceof Props.TitleProps) || (props.getFlags() & 0x8000) == 0) continue;
            ITitles.TitleType titleType = this.titleFlagToTitleType(((Props.TitleProps)props).getTitleType());
            this.mTitleMgr.setTitle(titleType, true);
            bl = true;
        }
        if (bl) {
            this.recalcCanvasSize();
        }
    }

    private boolean removedDeletedElements(ChartProps chartProps) {
        boolean bl = false;
        boolean bl2 = false;
        Vector<Props> vector = new Vector<Props>();
        for (Props props : chartProps.getProperties()) {
            if (props.isDeleted() && props instanceof Props.ElProps) {
                this.mImager.removeDataElement((Props.ElProps)props);
                vector.add(props);
                bl = true;
                continue;
            }
            if (!props.isDeleted() || !(props instanceof Props.TitleProps)) continue;
            ITitles.TitleType titleType = this.titleFlagToTitleType(((Props.TitleProps)props).getTitleType());
            this.mTitleMgr.setTitle(titleType, false);
            this.mImager.setTitle(titleType, false);
            vector.add(props);
            if (titleType != ITitles.TitleType.footnote1 && titleType != ITitles.TitleType.footnote2) continue;
            bl2 = true;
        }
        for (Props props : vector) {
            chartProps.getProperties().remove(props);
        }
        if (bl2) {
            this.recalcCanvasSize();
        }
        return bl;
    }

    public ITitles.TitleType titleFlagToTitleType(IPropEnum.TitleFlag titleFlag) {
        if (titleFlag == IPropEnum.TitleFlag.tf_Title1) {
            return ITitles.TitleType.title1;
        }
        if (titleFlag == IPropEnum.TitleFlag.tf_Title2) {
            return ITitles.TitleType.title2;
        }
        if (titleFlag == IPropEnum.TitleFlag.tf_Subtitle) {
            return ITitles.TitleType.subTitle1;
        }
        if (titleFlag == IPropEnum.TitleFlag.tf_Footnote1) {
            return ITitles.TitleType.footnote1;
        }
        if (titleFlag == IPropEnum.TitleFlag.tf_Footnote2) {
            return ITitles.TitleType.footnote2;
        }
        return null;
    }

    public IPropEnum.TitleFlag titleTypeToTitleFlag(ITitles.TitleType titleType) {
        if (titleType == ITitles.TitleType.title1) {
            return IPropEnum.TitleFlag.tf_Title1;
        }
        if (titleType == ITitles.TitleType.title2) {
            return IPropEnum.TitleFlag.tf_Title2;
        }
        if (titleType == ITitles.TitleType.subTitle1) {
            return IPropEnum.TitleFlag.tf_Subtitle;
        }
        if (titleType == ITitles.TitleType.footnote1) {
            return IPropEnum.TitleFlag.tf_Footnote1;
        }
        if (titleType == ITitles.TitleType.footnote2) {
            return IPropEnum.TitleFlag.tf_Footnote2;
        }
        return null;
    }

    public void clearHighlight2() {
        this.getZoneMgr().clearHighlights2();
        this.getTitleMgr().clearHighlight();
    }

    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle;
        super.paintComponent(graphics);
        if (!this.isEmpty()) {
            this.mImager.render((Graphics2D)graphics, this.mChartBounds, this.getParentDlg().isElementPropertiesVisible());
            this.mZoneMgr.render((Graphics2D)graphics, ComponentState.getOLangLocale());
            this.mTitleMgr.renderTitles((Graphics2D)graphics);
        } else {
            rectangle = this.getBounds();
            rectangle.grow((int)((double)(-rectangle.width) * 0.18), 0);
            rectangle.y -= 10;
            graphics.setColor(Color.BLUE);
            CommonUtil.drawWrappedText((Graphics)graphics, (String)this.mEmptyCanvasText, (Rectangle)rectangle, (int)0);
        }
        if (this.mDrawOuterFrameBorder) {
            rectangle = (Rectangle)this.getBounds().clone();
            rectangle.grow(-3, -3);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void doMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 503) {
            boolean bl = false;
            DropZone dropZone = this.mZoneMgr.hitTest(mouseEvent.getPoint());
            if (dropZone != null) {
                bl = !dropZone.isEmpty();
            }
            this.setCursor(bl ? Cursor.getPredefinedCursor(12) : null);
        } else if (mouseEvent.getID() == 501) {
            DropZone dropZone = this.mZoneMgr.hitTest(mouseEvent.getPoint());
            if (dropZone != null) {
                this.mZoneMgr.setFocusZone(dropZone);
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1 && dropZone.isStyleByZone()) {
                    this.doGroupingZoneDlg(dropZone);
                }
            } else {
                int n = this.mTitleMgr.checkForTitleHits(mouseEvent.getPoint());
                if (n > -1) {
                    this.getParentDlg().chartItemHit(n);
                } else {
                    this.checkForChartElementHits(mouseEvent.getPoint());
                }
            }
        } else if (mouseEvent.getID() == 502) {
            DropZone dropZone = this.mZoneMgr.hitTest(mouseEvent.getPoint());
            if (dropZone != null) {
                this.mZoneMgr.setFocusZone(dropZone);
                ZoneType zoneType = dropZone.getZoneType();
                if (mouseEvent.getClickCount() == 1 && zoneType != null) {
                    dropZone.setClickDelta();
                    this.getParentDlg().chartItemHit((Object)zoneType, dropZone, -1);
                }
            }
        } else if (mouseEvent.getID() == 505) {
            this.setCursor(null);
        }
    }

    protected void checkForChartElementHits(Point point) {
        if (this.mImager.isEmpty()) {
            return;
        }
        point.x -= this.mChartBounds.x;
        point.y -= this.mChartBounds.y;
        Shape shape = this.clickShape(point, 2);
        InformationProcessor informationProcessor = InformationProcessor.getPickingProcessor((Shape)shape);
        try {
            this.mImager.getVisualization().runProcessor((ResultsProcessor)informationProcessor);
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
            return;
        }
        ItemInfo[] itemInfoArray = informationProcessor.getItems();
        if (itemInfoArray.length > 0) {
            this.getParentDlg().chartItemHit(itemInfoArray[0].getId());
        }
    }

    protected Shape clickShape(Point point, int n) {
        int n2 = point.x - n;
        int n3 = point.y - n;
        n2 = n2 > 0 ? n2 : 0;
        n3 = n3 > 0 ? n3 : 0;
        return new Rectangle(n2, n3, 2 * n, 2 * n);
    }

    protected void doGroupingZoneDlg(DropZone dropZone) {
        GroupingZoneDlg groupingZoneDlg = new GroupingZoneDlg(this.getParentDlg(), dropZone);
        groupingZoneDlg.setVisible(true);
    }

    private void doAddToFavorites(String string) {
        ChartPrototype chartPrototype = this.mImager.makeGalleryPrototype(string);
        if (chartPrototype != null) {
            this.getParentDlg().addToFavorites(chartPrototype);
        }
    }

    protected void addDragDropAdapters() {
        DragPane dragPane = this.findDragPane();
        if (dragPane != null) {
            if (this.mDragAdapter == null) {
                this.mDragAdapter = new CanvasDragAdapter(dragPane, this, "ChartCanvas");
            }
            this.addMouseListener((MouseListener)((Object)this.mDragAdapter));
            this.addMouseMotionListener((MouseMotionListener)((Object)this.mDragAdapter));
            dragPane.addDropListener((IDropListener)this);
        }
        this.addComponentListener((ComponentListener)this.mResizeAdapter);
    }

    protected void removeDragDropAdapters() {
        DragPane dragPane = this.findDragPane();
        if (dragPane != null) {
            if (this.mDragAdapter == null) {
                this.mDragAdapter = new CanvasDragAdapter(dragPane, this, "ChartCanvas");
            }
            this.removeMouseListener((MouseListener)((Object)this.mDragAdapter));
            this.removeMouseMotionListener((MouseMotionListener)((Object)this.mDragAdapter));
            dragPane.removeDropListener((IDropListener)this);
        }
    }

    protected void initContextMenu() {
        JMenu jMenu = new JMenu(this.mResources.getResString("IDS_GROUPING_ZONE"));
        this.mAddGroupingZoneAction = new AddGroupingZoneAction();
        jMenu.add(new JMenuItem(this.mAddGroupingZoneAction));
        this.mEditGroupingZoneAction = new EditGroupingZoneAction();
        jMenu.add(new JMenuItem(this.mEditGroupingZoneAction));
        this.mDeleteGroupingZoneAction = new DeleteGroupingZoneAction();
        jMenu.add(new JMenuItem(this.mDeleteGroupingZoneAction));
        JMenu jMenu2 = new JMenu(this.mResources.getResString("IDS_COL_PANEL_ZONE"));
        this.mAddColPanelAction = new AddRemoveZoneAction(ZoneType.zt_panel_horz, true);
        jMenu2.add(new JMenuItem(this.mAddColPanelAction));
        this.mRemoveColPanelAction = new AddRemoveZoneAction(ZoneType.zt_panel_horz, false);
        jMenu2.add(new JMenuItem(this.mRemoveColPanelAction));
        JMenu jMenu3 = new JMenu(this.mResources.getResString("IDS_ROW_PANEL_ZONE"));
        this.mAddRowPanelAction = new AddRemoveZoneAction(ZoneType.zt_panel_vert, true);
        jMenu3.add(new JMenuItem(this.mAddRowPanelAction));
        this.mRemoveRowPanelAction = new AddRemoveZoneAction(ZoneType.zt_panel_vert, false);
        jMenu3.add(new JMenuItem(this.mRemoveRowPanelAction));
        JMenu jMenu4 = new JMenu(this.mResources.getResString("IDS_POINT_ID_ZONE"));
        this.mAddPointIdAction = new AddRemoveZoneAction(ZoneType.zt_point_id, true);
        jMenu4.add(new JMenuItem(this.mAddPointIdAction));
        this.mRemovePointIdAction = new AddRemoveZoneAction(ZoneType.zt_point_id, false);
        jMenu4.add(new JMenuItem(this.mRemovePointIdAction));
        this.mDeleteSubmenu = new JMenu(this.mResources.getResString("IDS_CANVASMENU_DELETE"));
        this.mDeleteSubmenu.setMnemonic(this.mResources.getDlgAccessKey("IDK_CANVASMENU_DELETE_KEY"));
        this.mPropsMenuItem = new JCheckBoxMenuItem(new PropertiesAction());
        Component[] componentArray = new Component[]{new JMenuItem((Action)new BaseCanvas.UndoAction((BaseCanvas)this)), new JMenuItem((Action)new BaseCanvas.RedoAction((BaseCanvas)this)), new JPopupMenu.Separator(), this.mPropsMenuItem, new JPopupMenu.Separator(), new JMenuItem((Action)new BaseCanvas.CutAction((BaseCanvas)this)), new JMenuItem((Action)new BaseCanvas.CopyAction((BaseCanvas)this)), new JMenuItem((Action)new BaseCanvas.PasteAction((BaseCanvas)this)), new JMenuItem((Action)new BaseCanvas.DeleteAction((BaseCanvas)this)), new JPopupMenu.Separator(), jMenu, jMenu2, jMenu3, jMenu4, new JPopupMenu.Separator(), new JMenuItem(new TransposeAxesAction()), new JPopupMenu.Separator(), new JMenuItem(new AddToFavoritesAction()), new JPopupMenu.Separator(), new JMenuItem(new ClearCanvasAction())};
        this.mCanvasContextMenu = new BaseCanvas.CanvasContextMenu(componentArray);
    }

    protected void setupContextMenu(Component[] componentArray) {
        super.setupContextMenu(componentArray);
    }

    protected void updateContextMenuEnableState(Point point) {
        boolean bl;
        DropZone dropZone;
        boolean bl2;
        Action action;
        boolean bl3;
        super.updateContextMenuEnableState(point);
        DropZone dropZone2 = this.mZoneMgr.hitTest(point);
        boolean bl4 = bl3 = dropZone2 != null && dropZone2.isIndexZone();
        if (dropZone2 != null) {
            this.mZoneMgr.setFocusZone(dropZone2);
        }
        if (this.mPropsMenuItem != null) {
            this.mPropsMenuItem.setSelected(this.getParentDlg().isElementPropertiesVisible());
        }
        if ((action = this.mCanvasContextMenu.findAction(BaseCanvas.CutAction.class)) != null) {
            action.setEnabled(dropZone2 != null && !dropZone2.isEmpty() && !bl3);
        }
        if ((action = this.mCanvasContextMenu.findAction(BaseCanvas.CopyAction.class)) != null) {
            action.setEnabled(dropZone2 != null && !dropZone2.isEmpty() && !bl3);
        }
        if ((action = this.mCanvasContextMenu.findAction(BaseCanvas.PasteAction.class)) != null) {
            action.setEnabled(dropZone2 != null && dropZone2.canDrop(this.mLocalClipboard));
        }
        if ((action = this.mCanvasContextMenu.findAction(BaseCanvas.DeleteAction.class)) != null) {
            action.setEnabled(dropZone2 != null && !dropZone2.isEmpty());
        }
        this.mAddGroupingZoneAction.setEnabled(this.canAddGroupingZone());
        boolean bl5 = bl2 = this.legendZoneCount() > 1;
        if (bl2) {
            dropZone = dropZone2;
            bl = dropZone2 != null && dropZone2.isStyleByZone();
        } else {
            dropZone = this.getLegendZone();
            bl = dropZone != null;
        }
        this.mEditGroupingZoneAction.setEnabled(bl);
        this.mEditGroupingZoneAction.setZone(dropZone);
        this.mDeleteGroupingZoneAction.setEnabled(bl &= this.mImager.getCoordinates() != Coords.coords_Polar);
        this.mDeleteGroupingZoneAction.setZone(dropZone);
        this.updateDeleteSubMenu(dropZone2);
        action = this.mCanvasContextMenu.findAction(TransposeAxesAction.class);
        if (action != null) {
            action.setEnabled(this.canTranspose());
        }
        if ((action = this.mCanvasContextMenu.findAction(AddToFavoritesAction.class)) != null) {
            action.setEnabled(!this.isEmpty());
        }
        if ((action = this.mCanvasContextMenu.findAction(ClearCanvasAction.class)) != null) {
            action.setEnabled(!this.isEmpty());
        }
        if ((action = this.mCanvasContextMenu.findAction(BaseCanvas.UndoAction.class)) != null) {
            action.setEnabled(this.getUndoManager().canUndo());
        }
        if ((action = this.mCanvasContextMenu.findAction(BaseCanvas.RedoAction.class)) != null) {
            action.setEnabled(this.getUndoManager().canRedo());
        }
        this.enableZoneActions();
    }

    private int legendZoneCount() {
        int n = 0;
        if (this.mZoneMgr.hasZone(ZoneType.zt_cluster_x)) {
            ++n;
        }
        if (this.mZoneMgr.hasZone(ZoneType.zt_cluster_z)) {
            ++n;
        }
        if (this.mZoneMgr.hasZone(ZoneType.zt_group)) {
            ++n;
        }
        return n;
    }

    private DropZone getLegendZone() {
        if (this.mZoneMgr.hasZone(ZoneType.zt_cluster_x)) {
            return this.mZoneMgr.getZone(ZoneType.zt_cluster_x);
        }
        if (this.mZoneMgr.hasZone(ZoneType.zt_cluster_z)) {
            return this.mZoneMgr.getZone(ZoneType.zt_cluster_z);
        }
        if (this.mZoneMgr.hasZone(ZoneType.zt_group)) {
            return this.mZoneMgr.getZone(ZoneType.zt_group);
        }
        return null;
    }

    private void updateDeleteSubMenu(DropZone dropZone) {
        boolean bl;
        JMenu jMenu = this.getDeleteSubMenu();
        Vector<ISpssVariable> vector = dropZone != null ? dropZone.getVariables() : null;
        boolean bl2 = bl = vector != null && vector.size() > 1;
        if (bl && jMenu == null) {
            this.mCanvasContextMenu.insertAfter((JMenuItem)this.mDeleteSubmenu, BaseCanvas.DeleteAction.class);
        } else if (!bl && jMenu != null) {
            this.mCanvasContextMenu.remove((Component)this.mDeleteSubmenu);
        }
        if (bl) {
            this.mDeleteSubmenu.removeAll();
            for (ISpssVariable iSpssVariable : vector) {
                this.mDeleteSubmenu.add(new DeleteVarAction(dropZone, iSpssVariable));
            }
        }
    }

    private JMenu getDeleteSubMenu() {
        JMenu jMenu = null;
        for (Component component : this.mCanvasContextMenu.getComponents()) {
            if (component != this.mDeleteSubmenu) continue;
            jMenu = (JMenu)component;
            break;
        }
        return jMenu;
    }

    protected void enableZoneActions() {
        Coords coords = this.getImager().getCoordinates();
        Elements elements = this.getImager().getPrimaryElementType();
        boolean bl = false;
        boolean bl2 = false;
        if (elements == Elements.area || elements == Elements.diff_area || elements == Elements.hilo || elements == Elements.interval || elements == Elements.line || elements == Elements.point || elements == Elements.polar_interval || elements == Elements.pyramid || elements == Elements.schema) {
            bl = true;
            boolean bl3 = bl2 = elements != Elements.pyramid;
        }
        boolean bl4 = (elements == Elements.point || elements == Elements.splom) && coords != Coords.coords_1D ? this.getImager().getPrimaryStatistic() == Statistics.Value : elements == Elements.schema;
        boolean bl5 = this.getZoneMgr().hasZone(ZoneType.zt_panel_horz);
        this.mAddColPanelAction.setEnabled(bl && !bl5);
        this.mRemoveColPanelAction.setEnabled(bl && bl5);
        boolean bl6 = this.getZoneMgr().hasZone(ZoneType.zt_panel_vert);
        this.mAddRowPanelAction.setEnabled(bl2 && !bl6);
        this.mRemoveRowPanelAction.setEnabled(bl2 && bl6);
        boolean bl7 = this.getZoneMgr().hasZone(ZoneType.zt_point_id);
        this.mAddPointIdAction.setEnabled(bl4 && !bl7);
        this.mRemovePointIdAction.setEnabled(bl4 && bl7);
    }

    protected Rectangle getFocusedBounds() {
        DropZone dropZone = this.mZoneMgr.getFocusZone();
        Rectangle rectangle = dropZone != null ? dropZone.getBounds().getBounds() : super.getFocusedBounds();
        return rectangle;
    }

    private void updateModifiedSSVs(ChartProps chartProps) {
        Props.ElProps elProps = chartProps.getElementProp(0);
        if (elProps == null) {
            return;
        }
        Props.SSVData sSVData = elProps.getSSVData();
        if (sSVData.getSSVVariables().size() == 0) {
            this.mZoneMgr.removeSSVVariables();
        } else {
            ZoneType zoneType = chartProps.getCoords() == Coords.coords_Polar ? ZoneType.zt_angle : ZoneType.zt_y;
            DropZone dropZone = this.mZoneMgr.getZone(zoneType);
            Vector<ISpssVariable> vector = dropZone.getVariables();
            vector.clear();
            for (ElementStat elementStat : sSVData.getSSVVariables()) {
                vector.add(elementStat.getVariable());
            }
        }
    }

    private void updateImagerSSVs() {
        Props.ElProps elProps;
        Statistics statistics;
        ChartProps chartProps = this.getProperties();
        if (!this.legalStat(chartProps, statistics = (elProps = chartProps.getElementProp(0)).getStatistic().getStat(), 0)) {
            statistics = this.getDefaultStatistic(chartProps);
        }
        DropZone dropZone = this.mZoneMgr.getSummaryZone();
        Vector<ElementStat> vector = elProps.getSSVData().getSSVVariables();
        Vector<ISpssVariable> vector2 = dropZone.getVariables();
        for (ISpssVariable iSpssVariable : vector2) {
            ElementStat elementStat = new ElementStat(elProps);
            elementStat.setStat(statistics);
            elementStat.setVariable(iSpssVariable);
            vector.add(elementStat);
        }
        elProps.setModified(true);
        this.setProperties(chartProps);
    }

    private boolean canTranspose() {
        boolean bl = false;
        int n = this.getImager().dataElementCount();
        Coords coords = this.getImager().getCoordinates();
        if (n == 0) {
            if (coords == Coords.coords_1D) {
                bl = true;
            } else if (coords == Coords.coords_2D) {
                bl = !this.getImager().isPopulationPyramid();
            }
        } else {
            bl = coords == Coords.coords_1D || coords == Coords.coords_2D && !this.getImager().isPopulationPyramid();
        }
        return bl;
    }

    private boolean canAddGroupingZone() {
        ChartProps chartProps = this.getProperties();
        Coords coords = chartProps.getCoords();
        Props.ElProps elProps = chartProps.getElementProp(0);
        Elements elements = elProps != null ? elProps.getElement() : null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = this.getZoneMgr().hasZone(ZoneType.zt_group);
        boolean bl5 = this.getZoneMgr().hasZone(ZoneType.zt_cluster_x);
        boolean bl6 = this.getZoneMgr().hasZone(ZoneType.zt_cluster_z);
        if (elements != null) {
            boolean bl7 = this.getZoneMgr().hasScaleVar(ZoneType.zt_x);
            boolean bl8 = this.getZoneMgr().hasScaleVar(ZoneType.zt_z);
            boolean bl9 = coords.equals((Object)Coords.coords_DualY);
            if (elements.equals((Object)Elements.hilo)) {
                if (!bl7 && !bl9) {
                    bl = true;
                }
            } else if (elements.equals((Object)Elements.interval)) {
                boolean bl10 = this.hasDateOnY();
                if (coords.equals((Object)Coords.coords_2D)) {
                    if (!(bl4 || bl7 || bl9)) {
                        bl = true;
                    }
                    if (!(bl5 || bl9 || bl10)) {
                        bl3 = true;
                    }
                } else if (!bl9) {
                    if (!(bl7 || bl4 && bl6)) {
                        bl = true;
                    }
                    if (!(bl8 || bl4 && bl5)) {
                        bl2 = true;
                    }
                    if (!bl5 || !bl6 && !bl10) {
                        bl3 = true;
                    }
                }
            } else if (elements.equals((Object)Elements.area)) {
                if (!bl9 && !this.hasDateOnY()) {
                    bl3 = true;
                }
            } else if (elements.equals((Object)Elements.line) || elements.equals((Object)Elements.point)) {
                if (!bl9 && !bl5) {
                    bl3 = true;
                }
            } else if (elements.equals((Object)Elements.schema)) {
                if (coords.equals((Object)Coords.coords_2D) && !bl7 && !bl9) {
                    bl = true;
                }
            } else if (elements.equals((Object)Elements.splom)) {
                bl3 = true;
            }
        }
        return bl && !bl5 || bl2 && !bl6 || bl3 && !bl4;
    }

    private void recalcChartBounds() {
        this.mChartBounds = this.getBounds();
        this.mChartBounds.x += 60;
        this.mChartBounds.width -= 180;
        this.mChartBounds.y += 40;
        this.mChartBounds.height -= 85 + this.mTitleMgr.getFootnotesHeight();
        if (this.getImager().getCoordinates() == Coords.coords_3D) {
            this.mChartBounds.width -= 20;
        }
    }

    private void viewXML() {
        String string = this.mImager.getViZmlAsString(true, false);
        String string2 = "\"C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE\"";
        String string3 = System.getProperty("java.io.tmpdir") + "cb_vizml.xml";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(string);
            outputStreamWriter.close();
            fileOutputStream.close();
            new ProcessBuilder(string2, string3).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean hasMRVarsInDataSet() {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId());
        IExtension iExtension = iSpssDataSrc.getExtension(ExtensionType.kMultipleResponseGroups);
        IExtension iExtension2 = iSpssDataSrc.getExtension(ExtensionType.kEnhancedMRSets);
        return iExtension != null || iExtension2 != null;
    }

    private String getVarTitleValue(ISpssVariable iSpssVariable) {
        String string = iSpssVariable.getLabel();
        if (string == null || string.length() == 0) {
            string = iSpssVariable.getName();
        }
        return string;
    }

    public boolean hasFilter() {
        DropZone dropZone = this.mZoneMgr.getZone(ZoneType.zt_filter);
        return !dropZone.isEmpty();
    }

    class DeleteVarAction
    extends AbstractAction {
        private DropZone mZone;
        private ISpssVariable mVar;

        public DeleteVarAction(DropZone dropZone, ISpssVariable iSpssVariable) {
            String string;
            this.mZone = dropZone;
            this.mVar = iSpssVariable;
            String string2 = string = ChartCanvas.this.getShowVarLabels() ? iSpssVariable.getLabel() : iSpssVariable.getName();
            if (string == null || string.length() == 0) {
                string = iSpssVariable.getName();
            }
            this.putValue("Name", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new RemoveVariablesEdit(ChartCanvas.this.getUndoManager(), ChartCanvas.this.getParentDlg(), this.mZone.getZoneType(), this.mVar);
        }
    }

    class ClearCanvasAction
    extends AbstractAction {
        public ClearCanvasAction() {
            this.putValue("Name", ChartCanvas.this.mResources.getResString("IDS_CLEAR_CANVAS"));
            this.putValue("MnemonicKey", ChartCanvas.this.mResources.getDlgAccessKey("IDK_CLEAR_CANVAS_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ClearCanvasEdit(ChartCanvas.this.getUndoManager(), ChartCanvas.this.getParentDlg());
        }
    }

    class AddToFavoritesAction
    extends AbstractAction {
        public AddToFavoritesAction() {
            this.putValue("Name", ChartCanvas.this.mResources.getResString("IDS_ADD_TO_FAVORITES"));
            this.putValue("MnemonicKey", ChartCanvas.this.mResources.getDlgAccessKey("IDK_ADD_TO_FAVORITES_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddToFavoritesDlg addToFavoritesDlg = new AddToFavoritesDlg(ChartCanvas.this.getParentDlg());
            addToFavoritesDlg.setVisible(true);
            if (addToFavoritesDlg.wasOKPressed()) {
                ChartCanvas.this.doAddToFavorites(addToFavoritesDlg.getChartName());
            }
        }
    }

    class TransposeAxesAction
    extends AbstractAction {
        public TransposeAxesAction() {
            this.putValue("Name", ChartCanvas.this.mResources.getResString("IDS_TRANSPOSE_AXES"));
            this.putValue("MnemonicKey", ChartCanvas.this.mResources.getDlgAccessKey("IDK_TRANSPOSE_AXES_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChartCanvas.this.transpose();
        }
    }

    class AddRemoveZoneAction
    extends AbstractAction {
        private ZoneType mZoneType;
        private boolean mIsAdd;

        public AddRemoveZoneAction(ZoneType zoneType, boolean bl) {
            if (bl) {
                this.putValue("Name", ChartCanvas.this.mResources.getResString("IDS_ADD_MENU_ITEM"));
                this.putValue("MnemonicKey", ChartCanvas.this.mResources.getDlgAccessKey("IDK_ADD_MENU_ITEM_KEY"));
            } else {
                this.putValue("Name", ChartCanvas.this.mResources.getResString("IDS_REMOVE_MENU_ITEM"));
                this.putValue("MnemonicKey", ChartCanvas.this.mResources.getDlgAccessKey("IDK_REMOVE_MENU_ITEM_KEY"));
            }
            this.mIsAdd = bl;
            this.mZoneType = zoneType;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.mIsAdd) {
                ChartCanvas.this.addZone(this.mZoneType);
            } else {
                ChartCanvas.this.removeZone(this.mZoneType);
            }
            ChartCanvas.this.recalcLayout();
            ChartCanvas.this.fireChangeEvent(CanvasChangeEvent.ChangeType.variableChange);
        }
    }

    class DeleteGroupingZoneAction
    extends AbstractAction {
        private DropZone mZone = null;

        public DeleteGroupingZoneAction() {
            this.putValue("Name", ChartCanvas.this.mResources.getResString("IDS_DELETE_GROUPING"));
            this.putValue("MnemonicKey", ChartCanvas.this.mResources.getDlgAccessKey("IDK_DELETE_GROUPING_KEY"));
        }

        public void setZone(DropZone dropZone) {
            this.mZone = dropZone;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChartCanvas.this.removeZone(this.mZone.getZoneType());
            ChartCanvas.this.recalcLayout();
            ChartCanvas.this.fireChangeEvent(CanvasChangeEvent.ChangeType.variableChange);
        }
    }

    class EditGroupingZoneAction
    extends AbstractAction {
        private DropZone mZone = null;

        public EditGroupingZoneAction() {
            this.putValue("Name", ChartCanvas.this.mResources.getResString("IDS_EDIT_GROUPING"));
            this.putValue("MnemonicKey", ChartCanvas.this.mResources.getDlgAccessKey("IDK_EDIT_GROUPING_KEY"));
        }

        public void setZone(DropZone dropZone) {
            this.mZone = dropZone;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChartCanvas.this.doGroupingZoneDlg(this.mZone);
        }
    }

    class AddGroupingZoneAction
    extends AbstractAction {
        public AddGroupingZoneAction() {
            this.putValue("Name", ChartCanvas.this.mResources.getResString("IDS_ADD_GROUPING"));
            this.putValue("MnemonicKey", ChartCanvas.this.mResources.getDlgAccessKey("IDK_ADD_GROUPING_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChartCanvas.this.addZone(ChartCanvas.this.getNewGroupingZoneType());
            ChartCanvas.this.recalcLayout();
            ChartCanvas.this.fireChangeEvent(CanvasChangeEvent.ChangeType.variableChange);
        }
    }

    class PropertiesAction
    extends AbstractAction {
        public PropertiesAction() {
            this.putValue("Name", ChartCanvas.this.mResources.getResString("IDS_PROPS_WINDOW"));
            this.putValue("MnemonicKey", ChartCanvas.this.mResources.getDlgAccessKey("IDK_PROPS_WINDOW_KEY"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 2));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ChartCanvas.this.getParentDlg().isElementPropertiesVisible();
            ChartCanvas.this.getParentDlg().showElementProperties(!bl);
        }
    }
}

