/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.ui.controls.CategoriesList;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.BasicFrontPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderOptions;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartPrototype;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.GalleryFrontPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.GroupsFrontPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ICanvasChangeListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.IndexVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.SyntaxGenerator;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.TitlesFrontPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.SidePropertiesPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.ResourceAccessor;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.doc_util.ThinBeveledBorder;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.canvas.BaseCanvas;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChartBuilderDlg
extends BaseProcedureDialog
implements ICanvasChangeListener,
AdjustmentListener {
    private final String CANVAS_KEY = "chart_canvas";
    private final String TAB_KEY_BELOW = "last_tab_below";
    private final String TAB_KEY_SIDE = "last_tab_side";
    private final String GROUP_KEY = "last_group";
    private boolean mLeftTabs;
    private boolean mLeftButtons;
    private JLabel mSrcListLabel;
    private SrcVariableList mSrcVarList;
    private ChartCanvas mCanvas;
    private CBTabbedPane mTabbedPane;
    private boolean mGalleryMsg;
    private GalleryFrontPanel mGalleryPane;
    private ChartBuilderOptions mOptions;
    public static final String sChartBuilderSizeLocation = "ChartBuilderSizeLocation";
    private JButton mExpandCollapseButton;
    private SidePropertiesPanel mSidePropertiesPanel;
    private JSplitPane mSplitPane;
    private double mDefaultRightSideWidth = -1.0;
    private double mDefaultLeftSideWidth = -1.0;

    public ChartBuilderDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.secondInit(jFrame);
    }

    public SidePropertiesPanel getSidePropertiesPanel() {
        return this.mSidePropertiesPanel;
    }

    private void secondInit(JFrame jFrame) {
        this.setTitle(this.getResString("IDS_CHART_BUILDER_WINDOW_TITLE"));
        this.mCanvas.updateUI();
        this.mCanvas.addChangeListener(this);
        this.mSrcVarList.setSelectedIndex(0);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.mGalleryMsg = false;
        this.setEmptyCanvasText(true);
        this.mSrcVarList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                    ChartBuilderDlg.this.onCopySrcListVar();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ChartBuilderDlg.this.validate();
            }
        });
    }

    @Override
    public String generateSyntax() {
        SyntaxGenerator syntaxGenerator = new SyntaxGenerator(this.mCanvas, this.mOptions);
        return syntaxGenerator.generateSyntax();
    }

    @Override
    public boolean okPastePressed() {
        this.getSidePropertiesPanel().getChartAppearancePanel().validateThisPanel();
        if (this.getSidePropertiesPanel().canSwitchTab()) {
            this.getSidePropertiesPanel().applyChangesAsNeeded();
        }
        Vector<String> vector = new Vector<String>();
        for (ZoneType zoneType : ZoneType.values()) {
            DropZone dropZone = this.mCanvas.getZoneMgr().getZone(zoneType);
            if (dropZone == null || dropZone.isEmpty()) continue;
            for (ISpssVariable iSpssVariable : dropZone.getVariables()) {
                if (iSpssVariable instanceof SpssMRVariable || iSpssVariable instanceof IndexVariable || SyntaxGenerator.isNameInDataset(iSpssVariable.getName())) continue;
                vector.add(iSpssVariable.getName());
            }
        }
        if (vector.size() > 0) {
            Object object = "";
            for (String string : vector) {
                if (((String)object).length() > 0) {
                    object = (String)object + " ";
                }
                object = (String)object + string;
            }
            String string = this.getResString("ERR_INVALID_VARS_MSG");
            String string2 = String.format(string, object);
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public String getIActionKey() {
        return "graphs_chart_builder";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idc_cg_help_main";
    }

    @Override
    public void reset() {
        super.reset();
        this.showElementProperties(false);
        this.mCanvas.reset();
        this.mOptions.reset();
        this.getSidePropertiesPanel().getChartAppearancePanel().reset();
        this.getCanvas().getUndoManager().discardAllEdits();
        this.mSrcVarList.loadFromActiveDataset(true);
        this.mSrcVarList.setSelectedIndex(0);
        this.updateOKPasteButtons();
    }

    public ChartCanvas getCanvas() {
        return this.mCanvas;
    }

    public ChartBuilderOptions getChartBuilderOptions() {
        return this.mOptions;
    }

    @Override
    public void pack() {
        super.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension dimension = ChartBuilderDlg.this.mCanvas.getPreferredSize();
                Dimension dimension2 = ChartBuilderDlg.this.mCanvas.getParent().getSize();
                if (dimension.height > dimension2.height) {
                    dimension.height = dimension2.height;
                    ChartBuilderDlg.this.mCanvas.setPreferredSize(dimension);
                }
            }
        });
    }

    public void addToFavorites(ChartPrototype chartPrototype) {
        this.mGalleryPane.addToFavorites(chartPrototype);
        this.mTabbedPane.setSelectedIndex(0);
    }

    public CBTabbedPane getTabbedPane() {
        return this.mTabbedPane;
    }

    @Override
    public void dispose() {
        if (this.mGalleryPane != null) {
            this.mGalleryPane.close();
        }
        super.dispose();
    }

    public void showElementProperties(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                boolean bl22 = bl = ChartBuilderDlg.this.mSplitPane.getRightComponent() != null;
                if (bl != bl2) {
                    ChartBuilderDlg.this.showOrHideProperties(bl2);
                }
            }
        });
    }

    public String getOLResString(String string, Locale locale) {
        String string2 = GraphsResBundle.getDefaultResourceBundleName();
        return UIToolResUtil.getString((ResourceBundle)ResourceBundle.getBundle(string2, locale), (String)string);
    }

    public SrcVariableList getSrcVarList() {
        return this.mSrcVarList;
    }

    @Override
    public void canvasChange(CanvasChangeEvent canvasChangeEvent) {
        this.updateOKPasteButtons();
    }

    private void updateOKPasteButtons() {
        this.enableOkPaste(this.mCanvas.chartComplete());
    }

    public void setEmptyCanvasText() {
        int n = this.getTabbedPane().getSelectedIndex();
        this.setEmptyCanvasText(n != 1);
    }

    private void setEmptyCanvasText(boolean bl) {
        this.mGalleryMsg = bl;
        String string = this.mGalleryMsg ? "IDS_CANVAS_GALLERY_MSG" : "IDS_CANVAS_BASICEL_MSG";
        String string2 = this.getResString(string);
        this.mCanvas.setEmptyCanvasText(string2);
    }

    @Override
    protected void loadDialogState() {
        Object object;
        byte[] byArray = (byte[])this.getDialogDataModel().getObject("chart_canvas");
        if (byArray != null && byArray.length > 0) {
            object = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            this.mCanvas.serializeIn(dataInputStream);
        }
        if ((object = this.getDialogDataModel().getInteger("last_tab_below")) != null) {
            this.mTabbedPane.setSelectedIndex((Integer)object);
        }
        if ((object = this.getDialogDataModel().getInteger("last_tab_side")) != null) {
            this.mSidePropertiesPanel.setInReload(true);
            this.mSidePropertiesPanel.getTabbedPane().setSelectedIndex((Integer)object);
            this.mSidePropertiesPanel.setInReload(false);
        }
        if ((object = this.getDialogDataModel().getInteger("last_group")) != null) {
            this.mGalleryPane.setActiveGroupIndex((Integer)object);
        }
        int n = 100;
        try {
            n = Integer.valueOf(this.getDialogDataModel().getString("chart_scale"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.mOptions.setChartSizePct(n);
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_EXCLUDE_LISTWISE");
        if (bl == null) {
            bl = true;
        }
        this.mOptions.setExcludeListwise(bl);
        bl = this.getDialogDataModel().getBoolean("IDS_INCLUDE");
        if (bl == null) {
            bl = false;
        }
        this.mOptions.setIncludeBreakVars(bl);
        bl = this.getDialogDataModel().getBoolean("IDS_WRAP_PANELS");
        if (bl == null) {
            bl = false;
        }
        this.mOptions.setWrapPanels(bl);
        this.getSidePropertiesPanel().getChartAppearancePanel().loadState(this.getDialogDataModel());
        super.loadDialogState();
        this.restoreDlgLocationAndSize((JDialog)((Object)this), sChartBuilderSizeLocation);
        this.mCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.newChart);
    }

    private void restoreDlgLocationAndSize(JDialog jDialog, String string) {
        Point point;
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(string);
        if (dimension != null) {
            jDialog.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation(string)) != null) {
            jDialog.setLocation(point);
        } else if (jDialog != this) {
            jDialog.setLocationRelativeTo(this.getParent());
        }
    }

    @Override
    protected void saveDialogState() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (this.mCanvas.serializeOut(dataOutputStream)) {
            this.getDialogDataModel().putObject("chart_canvas", byteArrayOutputStream.toByteArray());
        }
        this.getDialogDataModel().putInteger("last_tab_below", this.mTabbedPane.getSelectedIndex());
        this.getDialogDataModel().putInteger("last_tab_side", this.mSidePropertiesPanel.getTabbedPane().getSelectedIndex());
        this.getDialogDataModel().putInteger("last_group", this.mGalleryPane.getActiveGroupIndex());
        ProcedureDlgMgr.getMgr().saveDialogLocation(sChartBuilderSizeLocation, this.getLocation());
        ProcedureDlgMgr.getMgr().saveDialogSize(sChartBuilderSizeLocation, this.getSize());
        super.saveDialogState();
        this.getSidePropertiesPanel().getOptionsPanel().saveState(this.getDialogDataModel());
        this.getSidePropertiesPanel().getChartAppearancePanel().saveState(this.getDialogDataModel());
    }

    @Override
    protected void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(true);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        String string = System.getProperty("os.name", "Windows").toLowerCase();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        if (string.startsWith("mac")) {
            insets.bottom = 14;
        }
        jPanel2.setBorder(new EmptyBorder(insets));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        this.mCmdButtonPanel = this.setupCmdButtonPanel();
        if (this.mCmdButtonPanel != null) {
            UIToolDialogUtil.normalizeButtonWidths((JPanel)this.mCmdButtonPanel);
            boolean bl = UIToolDialogUtil.areCommandButtonsBelow();
            DialogUtil.addUsingGBL(jPanel2, this.mCmdButtonPanel, gridBagConstraints, 0, 1, 1, 1, 10, null);
        }
        DragPane dragPane = new DragPane();
        this.setGlassPane((Component)dragPane);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.setupLeftPanel(jPanel3);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 0, 1, 1, 18, null);
        this.mOptions = new ChartBuilderOptions();
        this.mSidePropertiesPanel = new SidePropertiesPanel(this, this.mOptions);
        this.mSidePropertiesPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mSplitPane = new JSplitPane(1, jPanel2, this.mSidePropertiesPanel);
        this.mSplitPane.setDividerSize(1);
        this.mSplitPane.setResizeWeight(1.0);
        this.setContentPane(jPanel);
        this.getContentPane().add((Component)this.mSplitPane, "Center");
    }

    private void setupLeftPanel(JPanel jPanel) {
        this.mLeftTabs = false;
        this.mLeftButtons = false;
        this.setupLeftTopPane(jPanel);
        this.setupLeftCenterPane(jPanel);
        this.setupLeftLowerPane(jPanel);
        this.mSrcListLabel.setLabelFor(this.mSrcVarList);
        this.mSrcVarList.loadFromActiveDataset(true);
    }

    private void setupLeftTopPane(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        this.mSrcListLabel = new JLabel(this.getResString("IDS_VARIABLES"));
        this.mSrcListLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_VARIABLE_KEY"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardButtonInsets().clone();
        insets.top = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JLabel jLabel = new JLabel(this.getResString("IDS_CANVAS_LOWER_DATA_MSG"), 0);
        gridBagConstraints.weightx = 0.8;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        ExpandCollapseAction expandCollapseAction = new ExpandCollapseAction();
        this.mExpandCollapseButton = new JButton(expandCollapseAction);
        this.mExpandCollapseButton.setToolTipText(this.getResString("IDS_COLLAPSE"));
        gridBagConstraints.weightx = 0.0;
        n = 26;
        DialogUtil.addUsingGBL(jPanel2, this.mExpandCollapseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private void setupLeftCenterPane(JPanel jPanel) {
        JSplitPane jSplitPane = this.setupLists();
        this.mCanvas = new ChartCanvas(new ResourceAccessor(this));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.mCanvas));
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        jScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("general");
        boolean bl = preferences.getBoolean("var_list_display", true);
        BaseCanvas.setDefaultEmptyLabelStatus((boolean)bl);
        JSplitPane jSplitPane2 = new JSplitPane(1, jSplitPane, jScrollPane);
        jSplitPane2.setDividerLocation(150);
        jSplitPane2.setDividerSize(jSplitPane2.getDividerSize() - 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jSplitPane2, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JSplitPane setupLists() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eKeepOriginal);
        int n = this.mSrcVarList.getContextMenuFlags();
        this.mSrcVarList.setContextMenuFlags(8 | n);
        Component[] componentArray = new Component[]{new JPopupMenu.Separator(), new JMenuItem(new CopyVarsAction())};
        this.mSrcVarList.setAdditonalMenuItems(componentArray);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JPanel jPanel = this.setupLowerPane();
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel);
        jSplitPane.setResizeWeight(0.0);
        jSplitPane.setDividerLocation(180);
        return jSplitPane;
    }

    private JPanel setupLowerPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getResString("IDS_CATEGORIES_LABEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        CategoriesList categoriesList = new CategoriesList(this.mSrcVarList);
        Dimension dimension = this.mSrcVarList.getMinimumSize();
        dimension.height = 1;
        categoriesList.setMinimumSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(categoriesList);
        jScrollPane.setPreferredSize(categoriesList.getMinimumSize());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        categoriesList.setBackground(SystemColor.control);
        return jPanel;
    }

    private void setupLeftLowerPane(JPanel jPanel) {
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.MAC)) {
            this.mLeftTabs = false;
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        this.setupTabbedPane(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(10, 0, 0, 0);
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    private void setupTabbedPane(JPanel jPanel) {
        int n = this.mLeftTabs ? 2 : 1;
        this.mTabbedPane = new CBTabbedPane(n);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinBeveledBorder thinBeveledBorder = new ThinBeveledBorder(uIDefaults.getColor("ToolBar.highlight"), uIDefaults.getColor("ToolBar.shadow"), 0);
        String string = this.getResString("IDS_GALLERY_TAB");
        String string2 = this.getResString("IDS_GALLERY_TAB_TIP");
        this.mGalleryPane = new GalleryFrontPanel(this);
        this.mGalleryPane.setBorder(thinBeveledBorder);
        this.mTabbedPane.addTab(string, null, this.mGalleryPane, string2);
        string = this.getResString("IDS_BASIC_ELEMENTS_TAB");
        string2 = this.getResString("IDS_BASIC_ELEMENTS_TAB_TIP");
        BasicFrontPanel basicFrontPanel = new BasicFrontPanel(this, this.mCanvas);
        basicFrontPanel.setBorder(thinBeveledBorder);
        this.mTabbedPane.addTab(string, null, basicFrontPanel, string2);
        string = this.getResString("IDS_GROUPS_TAB");
        string2 = this.getResString("IDS_GROUPS_TAB_TIP");
        GroupsFrontPanel groupsFrontPanel = new GroupsFrontPanel(this, this.mCanvas);
        groupsFrontPanel.setBorder(thinBeveledBorder);
        this.mTabbedPane.addTab(string, null, groupsFrontPanel, string2);
        string = this.getResString("IDS_TITLES_TAB");
        string2 = this.getResString("IDS_TITLES_TAB_TIP");
        TitlesFrontPanel titlesFrontPanel = new TitlesFrontPanel(this, this.mCanvas);
        titlesFrontPanel.setBorder(thinBeveledBorder);
        this.mTabbedPane.addTab(string, null, titlesFrontPanel, string2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (this.mLeftTabs) {
            DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 1, 2, 2, n2, insets);
        } else {
            if (this.mLeftButtons) {
                DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 1, 0, 2, 2, n2, insets);
            } else {
                DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 0, 2, 2, n2, insets);
            }
            DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        }
    }

    public void selectEPItem(IPropEnum.ElementPanelType elementPanelType, int n) {
        final IPropEnum.ElementPanelType elementPanelType2 = elementPanelType;
        final int n2 = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ChartBuilderDlg.this.mSplitPane.getRightComponent() == null) {
                    ChartBuilderDlg.this.showOrHideProperties(true);
                }
                ChartBuilderDlg.this.getSidePropertiesPanel().selectItem(elementPanelType2, n2);
            }
        });
    }

    public boolean isElementPropertiesVisible() {
        return this.mSplitPane.getRightComponent() != null;
    }

    public void chartItemHit(Object object) {
        if (this.isElementPropertiesVisible()) {
            this.mSidePropertiesPanel.chartItemHit(object, null, -1);
        }
    }

    public void chartItemHit(Object object, DropZone dropZone, int n) {
        if (this.isElementPropertiesVisible()) {
            this.mSidePropertiesPanel.chartItemHit(object, dropZone, n);
        }
    }

    private void onCopySrcListVar() {
        ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            this.mCanvas.setLocalClipboard(iSpssVariableArray);
        }
    }

    private void showOrHideProperties(boolean bl) {
        if (this.mDefaultRightSideWidth == -1.0) {
            this.mDefaultRightSideWidth = this.mSplitPane.getRightComponent().getSize().getWidth();
        }
        if (this.mDefaultLeftSideWidth == -1.0) {
            this.mDefaultLeftSideWidth = this.mSplitPane.getLeftComponent().getSize().getWidth();
        }
        this.mSplitPane.setRightComponent(bl ? this.mSidePropertiesPanel : null);
        Dimension dimension = this.getSize();
        double d = bl ? dimension.getWidth() + this.mDefaultRightSideWidth : dimension.getWidth() - this.mDefaultRightSideWidth;
        dimension.setSize(d, dimension.getHeight());
        this.setSize(dimension);
        double d2 = dimension.getHeight();
        double d3 = bl ? this.mDefaultLeftSideWidth + this.mDefaultRightSideWidth : this.mDefaultLeftSideWidth;
        Dimension dimension2 = new Dimension((int)d3, (int)d2);
        this.setSizeConstraints(dimension2);
        super.justPack();
        this.mSidePropertiesPanel.uponShowOrHide(bl);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.mCanvas.getTitleMgr().setAllowScrollToVisible(false);
    }

    class ExpandCollapseAction
    extends AbstractAction {
        ExpandCollapseAction() {
            URL uRL = ChartBuilderDlg.this.getResImageURL("IDS_COLLAPSE_IMAGE");
            if (uRL != null) {
                this.putValue("SmallIcon", new ImageIcon(uRL));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL;
            boolean bl = ChartBuilderDlg.this.mSplitPane.getRightComponent() == null;
            ChartBuilderDlg.this.showOrHideProperties(bl);
            URL uRL2 = uRL = bl ? ChartBuilderDlg.this.getResImageURL("IDS_COLLAPSE_IMAGE") : ChartBuilderDlg.this.getResImageURL("IDS_EXPAND_IMAGE");
            if (uRL != null) {
                this.putValue("SmallIcon", new ImageIcon(uRL));
            }
            ChartBuilderDlg.this.mExpandCollapseButton.setToolTipText(bl ? ChartBuilderDlg.this.getResString("IDS_COLLAPSE") : ChartBuilderDlg.this.getResString("IDS_EXPAND"));
        }
    }

    class BorderLayoutFix
    extends BorderLayout {
        private Component mNorthComp;
        private Component mSouthComp;

        @Override
        public void addLayoutComponent(Component component, Object object) {
            super.addLayoutComponent(component, object);
            if (object instanceof String) {
                String string = (String)object;
                if ("North".equals(string)) {
                    this.mNorthComp = component;
                } else if ("South".equals(string)) {
                    this.mSouthComp = component;
                }
            }
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension = this.minimumLayoutSize(container);
            super.layoutContainer(container);
            if (container.getSize().height < dimension.height) {
                this.mSouthComp.setLocation(this.mSouthComp.getX(), this.mNorthComp.getY() + super.getVgap() + this.mNorthComp.getHeight());
            }
        }
    }

    class CopyVarsAction
    extends AbstractAction {
        public CopyVarsAction() {
            this.putValue("Name", ResUtil.getString("edit_copy"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ResUtil.getAccessKey("edit_copy"));
                this.putValue("AcceleratorKey", ResUtil.getShortcut("edit_copy"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChartBuilderDlg.this.onCopySrcListVar();
        }
    }

    class CBTabbedPane
    extends JTabbedPane
    implements ChangeListener {
        private int mLastTab;

        public CBTabbedPane(int n) {
            super(n);
            this.mLastTab = -1;
            this.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            this.mLastTab = n = this.getSelectedIndex();
            ChartBuilderDlg.this.setEmptyCanvasText(n != 1);
        }

        private void updateTabText(int n) {
            if (n != this.mLastTab) {
                String string;
                if (this.mLastTab > -1) {
                    string = this.getTitleAt(this.mLastTab);
                    string = string.replaceAll("<HTML><B>", "");
                    string = string.replaceAll("</B></HTML>", "");
                    this.setTitleAt(this.mLastTab, string);
                }
                if (n > -1) {
                    string = this.getTitleAt(n);
                    string = "<HTML><B>" + string + "</B></HTML>";
                    this.setTitleAt(n, string);
                }
            }
        }
    }
}

