/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartPrototype;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ITitles;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneMgr;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.shared.export.table_look.ColorDecoder;
import com.spss.uitools.util.IOptionConstants;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ChartAppearanceOption {
    private CanvasImager mImager;
    private Map<Integer, Color> mChangedColorMap;
    private Color[] mCycleColors = new Color[30];
    private HashMap<String, SimpleStyle> mSimpleColorMap = new HashMap();
    private boolean mUseCustomSetting;
    private boolean mIsOuterFrameBorder;
    private boolean mIsInnerFrameBorder;
    private boolean mIsGridlineX;
    private boolean mIsGridlineY;
    private String mTemplatePath = "";
    private String[] mTemplateTitles = new String[]{"", "", "", "", ""};
    private boolean mModified;

    public ChartAppearanceOption(CanvasImager canvasImager) {
        this.mImager = canvasImager;
        this.setupDefaultOption();
    }

    public boolean isUseCustomSetting() {
        return this.mUseCustomSetting;
    }

    public void setUseCustomSetting(boolean bl) {
        this.mUseCustomSetting = bl;
    }

    public Map<Integer, Color> getChangedColorMap() {
        return this.mChangedColorMap;
    }

    public void setChangedColorMap(Map<Integer, Color> map) {
        this.mChangedColorMap = map;
    }

    public boolean isOuterFrameBorder() {
        return this.mIsOuterFrameBorder;
    }

    public void setIsOuterFrameBorder(boolean bl) {
        this.mIsOuterFrameBorder = bl;
    }

    public boolean isInnerFrameBorder() {
        return this.mIsInnerFrameBorder;
    }

    public void setIsInnerFrameBorder(boolean bl) {
        this.mIsInnerFrameBorder = bl;
    }

    public boolean isGridlineX() {
        return this.mIsGridlineX;
    }

    public void setIsGridlineX(boolean bl) {
        this.mIsGridlineX = bl;
    }

    public boolean isGridlineY() {
        return this.mIsGridlineY;
    }

    public void setIsGridlineY(boolean bl) {
        this.mIsGridlineY = bl;
    }

    public String getTemplatePath() {
        return this.mTemplatePath;
    }

    public void setTemplatePath(String string) {
        this.mTemplatePath = string;
    }

    public Color[] getCycleColors() {
        return this.mCycleColors;
    }

    public void setCycleColors(Color[] colorArray) {
        this.mCycleColors = colorArray;
    }

    public HashMap<String, SimpleStyle> getSimpleColorMap() {
        return this.mSimpleColorMap;
    }

    public Color getSimpleColor(String string) {
        if (string == null) {
            return null;
        }
        SimpleStyle simpleStyle = this.mSimpleColorMap.get(string);
        return simpleStyle != null ? simpleStyle.mColor : null;
    }

    public String getTemplateTitle(ITitles.TitleType titleType) {
        return this.mTemplateTitles[titleType.ordinal()];
    }

    public boolean isModified() {
        return this.mModified;
    }

    public void setModified(boolean bl) {
        this.mModified = bl;
    }

    public void applyChartAppearanceOption(File file) {
        this.applyChartAppearanceOption(file, true, true);
    }

    public void applyChartAppearanceOption(File file, boolean bl, boolean bl2) {
        try {
            NodeList nodeList;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            FileInputStream fileInputStream = new FileInputStream(file);
            Document document = documentBuilder.parse(new InputSource(new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"))));
            if (bl && (nodeList = document.getElementsByTagName("setColor")) != null && nodeList.getLength() > 0) {
                Element element = (Element)nodeList.item(0);
                this.applyCycleColors(element);
            }
            if (bl2) {
                this.applyGridline(document, "x", ZoneType.zt_x);
                this.applyGridline(document, "y", ZoneType.zt_y);
            }
            nodeList = document.getElementsByTagName("setStyle");
            this.setSimpleColorMap(nodeList);
            this.applyFrameBorder(document, "visualization");
            this.applyFrameBorder(document, "graph");
            this.applyTitles(document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isCategorical(ZoneType zoneType) {
        Vector<ISpssVariable> vector;
        DropZone dropZone;
        ZoneMgr zoneMgr;
        boolean bl;
        boolean bl2 = bl = zoneType == ZoneType.zt_x;
        if (this.mImager.getOwnerCanvas() != null && (zoneMgr = this.mImager.getOwnerCanvas().getZoneMgr()) != null && (dropZone = zoneMgr.getZone(zoneType)) != null && (vector = dropZone.getVariables()).size() > 0) {
            bl = vector.get(0).getMeasurementLevel() != MeasurementLevel.scale;
        }
        return bl;
    }

    public String convertType(ChartPrototype chartPrototype) {
        String string = "bar";
        int n = chartPrototype.getChartGroup();
        if (n == 1) {
            string = "bar";
        } else if (n == 2) {
            string = "line";
        } else if (n == 4) {
            string = "area";
        } else if (n == 16) {
            string = "scatter";
        } else if (n == 256) {
            string = "schema";
        } else if (n == 512) {
            string = "histogram";
        }
        return string;
    }

    private void setSimpleColorMap(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (!element.hasAttribute("subtype") || !element.getAttribute("subtype").equals("simple") || !element.hasAttribute("type")) continue;
            String string = element.getAttribute("type");
            NodeList nodeList2 = element.getElementsByTagName("style");
            if (nodeList2 == null || nodeList2.getLength() <= 0) continue;
            Element element2 = (Element)nodeList2.item(0);
            String string2 = element2.getAttribute("color");
            String string3 = element2.getAttribute("color2");
            String string4 = element2.getAttribute("gradient-color");
            if (string2 == null || string2.length() <= 0 || string3 == null || string4 == null) continue;
            this.mSimpleColorMap.put(string, new SimpleStyle(ColorDecoder.getColor((String)string2), ColorDecoder.getColor((String)string3), string4));
        }
    }

    private void applyFrameBorder(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName("addFrame");
        boolean bl = false;
        boolean bl2 = true;
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (!element.hasAttribute("type") || !element.getAttribute("type").equals(string)) continue;
            NodeList nodeList2 = element.getElementsByTagName("style");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                if (!element2.hasAttribute("color2")) continue;
                bl = true;
                if (!element2.getAttribute("color2").equals("transparent")) continue;
                bl2 = false;
                break block0;
            }
        }
        if (bl) {
            if (string.equals("graph")) {
                this.mIsInnerFrameBorder = bl2;
            } else {
                this.mIsOuterFrameBorder = bl2;
            }
        }
    }

    private void applyGridline(Document document, String string, ZoneType zoneType) {
        NodeList nodeList = document.getElementsByTagName("setAxisMajorTicks");
        boolean bl = false;
        boolean bl2 = true;
        if (nodeList != null && nodeList.getLength() > 0) {
            block0: for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean bl3;
                String string2;
                Element element;
                Element element2 = (Element)nodeList.item(i);
                NodeList nodeList2 = element2.getElementsByTagName("majorTicks");
                if (nodeList2 == null || nodeList2.getLength() <= 0 || !(element = (Element)nodeList2.item(0)).hasAttribute("role") || !element.getAttribute("role").equals(string) || !(string2 = element.getAttribute("categorical")).equals(Boolean.toString(bl3 = this.isCategorical(zoneType)))) continue;
                NodeList nodeList3 = element.getElementsByTagName("gridLines");
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    bl2 = true;
                    bl = true;
                    Element element3 = (Element)nodeList3.item(j);
                    NodeList nodeList4 = element3.getElementsByTagName("style");
                    for (int k = 0; k < nodeList4.getLength(); ++k) {
                        Element element4 = (Element)nodeList4.item(k);
                        if (element4.hasAttribute("visible") && element4.getAttribute("visible").equals("true")) {
                            bl = true;
                            break block0;
                        }
                        if (!element4.hasAttribute("visible") || !element4.getAttribute("visible").equals("false")) continue;
                        bl = false;
                        break block0;
                    }
                }
            }
        }
        if (bl2) {
            if (string.equals("x")) {
                this.mIsGridlineX = bl;
            } else {
                this.mIsGridlineY = bl;
            }
        }
    }

    private void applyTitles(Document document) {
        NodeList nodeList = document.getElementsByTagName("addFrame");
        String string = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            String string2;
            Element element2 = (Element)nodeList.item(i);
            String string3 = element2.getAttribute("type");
            if (!element2.hasAttribute("type") || !string3.equals("title") && !string3.equals("subtitle") && !string3.equals("footnote")) continue;
            boolean bl = element2.hasAttribute("count");
            int n = Integer.parseInt(element2.getAttribute("count"));
            int n2 = 0;
            if (string3.equals("title")) {
                n2 = n == 1 ? 0 : 1;
            } else if (string3.equals("subtitle")) {
                n2 = 2;
            } else if (string3.equals("footnote")) {
                int n3 = n2 = n == 1 ? 3 : 4;
            }
            if (!bl) continue;
            NodeList nodeList2 = element2.getElementsByTagName("label");
            if (nodeList2.getLength() > 0 && (string2 = (element = (Element)nodeList2.item(0)).getTextContent()).length() > 0) {
                string = string2;
            }
            if (string.length() <= 0) continue;
            this.mTemplateTitles[n2] = string;
        }
    }

    private void applyCycleColors(Element element) {
        NodeList nodeList = element.getElementsByTagName("style");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = ((Element)node).getAttribute("color");
            if (string == null || i >= 30) continue;
            this.mCycleColors[i] = ColorDecoder.getColor((String)string);
        }
    }

    public void refreshBorderGridlineOption(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.mUseCustomSetting = bl;
        this.mIsOuterFrameBorder = bl2;
        this.mIsInnerFrameBorder = bl3;
        this.mIsGridlineX = bl4;
        this.mIsGridlineY = bl5;
    }

    public void reset(boolean bl) {
        this.mChangedColorMap = null;
        this.mUseCustomSetting = false;
        this.mIsOuterFrameBorder = false;
        this.mIsInnerFrameBorder = false;
        this.mIsGridlineX = false;
        this.mIsGridlineY = false;
        if (bl) {
            this.mTemplatePath = "";
        }
        Arrays.fill(this.mTemplateTitles, "");
        this.setupDefaultOption();
    }

    public void resetColorCycleOnly() {
        this.setupDefaultOptionOnColorCycleOnly();
        if (this.mTemplatePath != null && this.mTemplatePath.length() > 0) {
            File file = new File(this.mTemplatePath);
            this.applyChartAppearanceOption(file, true, false);
        }
    }

    public void serializeIn(DataInputStream dataInputStream) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            this.mUseCustomSetting = dataInputStream.readBoolean();
            int n5 = dataInputStream.readInt();
            if (n5 > 0) {
                this.mCycleColors = new Color[n5];
                if (n5 > 0) {
                    for (n4 = 0; n4 < n5; ++n4) {
                        n3 = dataInputStream.readInt();
                        n2 = dataInputStream.readInt();
                        n = dataInputStream.readInt();
                        this.mCycleColors[n4] = new Color(n3, n2, n);
                    }
                }
            }
            if ((n4 = dataInputStream.readInt()) > 0) {
                this.mChangedColorMap = new TreeMap<Integer, Color>();
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = dataInputStream.readInt();
                    n = dataInputStream.readInt();
                    int n6 = dataInputStream.readInt();
                    int n7 = dataInputStream.readInt();
                    this.mChangedColorMap.put(n2, new Color(n, n6, n7));
                }
            }
            this.mTemplatePath = dataInputStream.readUTF();
            this.mIsOuterFrameBorder = dataInputStream.readBoolean();
            this.mIsInnerFrameBorder = dataInputStream.readBoolean();
            this.mIsGridlineX = dataInputStream.readBoolean();
            this.mIsGridlineY = dataInputStream.readBoolean();
            n3 = dataInputStream.readInt();
            if (n3 > 0) {
                this.mTemplateTitles = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mTemplateTitles[n2] = dataInputStream.readUTF();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean serializeOut(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeBoolean(this.mUseCustomSetting);
            boolean bl = this.mCycleColors.length > 0 && this.mCycleColors[0] != null;
            int n = bl ? this.mCycleColors.length : 0;
            dataOutputStream.writeInt(n);
            if (bl && n > 0 && this.mCycleColors[0] != null) {
                for (Color color : this.mCycleColors) {
                    dataOutputStream.writeInt(color.getRed());
                    dataOutputStream.writeInt(color.getGreen());
                    dataOutputStream.writeInt(color.getBlue());
                }
            }
            int n2 = this.mChangedColorMap == null || this.mChangedColorMap.size() == 0 ? 0 : this.mChangedColorMap.size();
            dataOutputStream.writeInt(n2);
            if (n2 > 0) {
                for (Map.Entry<Integer, Color> entry : this.mChangedColorMap.entrySet()) {
                    Color color;
                    dataOutputStream.writeInt(entry.getKey());
                    color = entry.getValue();
                    dataOutputStream.writeInt(color.getRed());
                    dataOutputStream.writeInt(color.getGreen());
                    dataOutputStream.writeInt(color.getBlue());
                }
            }
            dataOutputStream.writeUTF(this.mTemplatePath != null ? this.mTemplatePath : "");
            dataOutputStream.writeBoolean(this.mIsOuterFrameBorder);
            dataOutputStream.writeBoolean(this.mIsInnerFrameBorder);
            dataOutputStream.writeBoolean(this.mIsGridlineX);
            dataOutputStream.writeBoolean(this.mIsGridlineY);
            int n3 = 0;
            for (String string : this.mTemplateTitles) {
                if (string == null || string.length() <= 0) continue;
                n3 = 1;
            }
            int n4 = n3 != 0 ? this.mTemplateTitles.length : 0;
            dataOutputStream.writeInt(n4);
            if (n3 != 0 && n > 0) {
                for (String string : this.mTemplateTitles) {
                    dataOutputStream.writeUTF(string);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void updateOption(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.applyChartAppearanceOption(file);
        } else {
            TraceSettings.trace1((String)("CANNOT OPEN Template File: " + string), (int)15);
        }
    }

    private void setupDefaultOption() {
        File file;
        String string;
        Object object;
        String string2 = FileLocationsUtil.getChartTemplateDirectoryPath() + File.separator + "chart_style.sgt";
        this.updateOption(string2);
        String string3 = PrefsMgr.getPrefsMgr().getTempPath();
        String string4 = string3 + "otmpl.tmp";
        this.updateOption(string4);
        boolean bl = true;
        String string5 = CanvasImager.getPrefsValue("charts", "use_custom_template", PrefDefaults.CHART_USE_CUSTOM_TEMPLATE);
        if (string5.equals(IOptionConstants.CHART_USE_CUSTOM_TEMPLATE_VALUES[0]) && ((File)(object = new File(string = CanvasImager.getPrefsValue("charts", "custom_template_path", "None")))).exists()) {
            this.applyChartAppearanceOption((File)object);
            bl = false;
        }
        if (bl && (file = new File((String)(object = string3 + "dtmpl.tmp"))).exists()) {
            this.applyChartAppearanceOption(file);
        }
        if (this.mChangedColorMap != null) {
            this.mChangedColorMap.clear();
        }
        this.mUseCustomSetting = false;
    }

    public void updateDefaultGridlineOptionOnly() {
        File file;
        String string;
        Object object;
        String string2 = FileLocationsUtil.getChartTemplateDirectoryPath() + File.separator + "chart_style.sgt";
        File file2 = new File(string2);
        this.applyChartAppearanceOption(file2, false, true);
        String string3 = PrefsMgr.getPrefsMgr().getTempPath();
        String string4 = string3 + "otmpl.tmp";
        File file3 = new File(string4);
        this.applyChartAppearanceOption(file3, false, true);
        boolean bl = true;
        String string5 = CanvasImager.getPrefsValue("charts", "use_custom_template", PrefDefaults.CHART_USE_CUSTOM_TEMPLATE);
        if (string5.equals(IOptionConstants.CHART_USE_CUSTOM_TEMPLATE_VALUES[0]) && ((File)(object = new File(string = CanvasImager.getPrefsValue("charts", "custom_template_path", "None")))).exists()) {
            this.applyChartAppearanceOption((File)object, false, true);
            bl = false;
        }
        if (bl && (file = new File((String)(object = string3 + "dtmpl.tmp"))).exists()) {
            this.applyChartAppearanceOption(file, false, true);
        }
    }

    private void setupDefaultOptionOnColorCycleOnly() {
        File file;
        String string;
        Object object;
        String string2 = FileLocationsUtil.getChartTemplateDirectoryPath() + File.separator + "chart_style.sgt";
        File file2 = new File(string2);
        this.applyChartAppearanceOption(file2, true, false);
        if (!file2.exists()) {
            TraceSettings.trace1((String)("CANNOT OPEN Template File: " + string2), (int)15);
        }
        String string3 = PrefsMgr.getPrefsMgr().getTempPath();
        String string4 = string3 + "otmpl.tmp";
        File file3 = new File(string4);
        this.applyChartAppearanceOption(file3, true, false);
        boolean bl = true;
        String string5 = CanvasImager.getPrefsValue("charts", "use_custom_template", PrefDefaults.CHART_USE_CUSTOM_TEMPLATE);
        if (string5.equals(IOptionConstants.CHART_USE_CUSTOM_TEMPLATE_VALUES[0]) && ((File)(object = new File(string = CanvasImager.getPrefsValue("charts", "custom_template_path", "None")))).exists()) {
            this.applyChartAppearanceOption((File)object, true, false);
            bl = false;
        }
        if (bl && (file = new File((String)(object = string3 + "dtmpl.tmp"))).exists()) {
            this.applyChartAppearanceOption(file, true, false);
        }
        if (this.mChangedColorMap != null) {
            this.mChangedColorMap.clear();
        }
        this.mUseCustomSetting = false;
    }

    class SimpleStyle {
        Color mColor;
        Color mColor2;
        String mGradientColor;

        SimpleStyle(Color color, Color color2, String string) {
            this.mColor = color;
            this.mColor2 = color2;
            this.mGradientColor = string;
        }
    }
}

