/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.controls.CategoriesList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.TristateCheckBox;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.RelabelBag;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CategoriesTable
extends JTable {
    public static Icon sNormalIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_NORMAL_CAT_IMAGE")));
    public static Icon sMissingIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_MISSING_CAT_IMAGE")));
    public static final int FILTER_ICON_NONE = 0;
    public static final int FILTER_ICON_NORMAL = 1;
    public static final int FILTER_ICON_INVALID = 2;
    private VariableList mVarList = null;
    private TristateCheckBox mSelectAllCheck;
    private JCheckBox mIncludeVCheck;
    private Font mNormalFont;
    private Font mItalicFont;
    private String mEmptyText = "";
    private HashMap<String, FilteringState> mFilterMap = new HashMap();
    private boolean mReloadingFilterControls = false;

    public CategoriesTable(VariableList variableList, TristateCheckBox tristateCheckBox, JCheckBox jCheckBox) {
        this.mVarList = variableList;
        this.mSelectAllCheck = tristateCheckBox;
        this.mIncludeVCheck = jCheckBox;
        this.setBackground(SystemColor.control);
        this.setTableHeader(null);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        DefaultTableModel defaultTableModel = new DefaultTableModel(5, 2){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }
        };
        this.setModel(defaultTableModel);
        this.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(15);
        tableColumn.setMinWidth(15);
        tableColumn.setMaxWidth(15);
        tableColumn.setCellRenderer(new CheckBoxRenderer());
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setPreferredWidth(120);
        tableColumn.setMinWidth(120);
        tableColumn.setCellRenderer(new CategoryLabelRenderer());
        this.setFocusTraversalKeys(0, null);
        this.setFocusTraversalKeys(1, null);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        if (this.mVarList != null) {
            this.mVarList.removeListSelectionListener(this);
        }
        super.updateUI();
        if (this.mVarList != null) {
            this.mNormalFont = this.getFont();
            HashMap hashMap = new HashMap(this.mNormalFont.getAttributes());
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            this.mItalicFont = new Font(hashMap);
            this.mVarList.addListSelectionListener(this);
        }
    }

    public TristateCheckBox.State getCurrentSelectionState() {
        TristateCheckBox.State state = TristateCheckBox.MIXED;
        int n = 0;
        int n2 = 0;
        int n3 = this.getRowCount();
        for (int i = 0; i < n3; ++i) {
            if (this.getModel().getValueAt(i, 0) == null) {
                --n3;
                continue;
            }
            boolean bl = (Boolean)this.getModel().getValueAt(i, 0);
            if (bl) {
                ++n;
                continue;
            }
            ++n2;
        }
        if (n == n3) {
            state = TristateCheckBox.CHECKED;
        } else if (n2 == n3) {
            state = TristateCheckBox.NOT_SELECTED;
        }
        return state;
    }

    public boolean containInvalidSrcVar() {
        boolean bl = false;
        VarListModel varListModel = this.mVarList.getModel();
        if (this.mFilterMap == null) {
            return bl;
        }
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            FilteringState filteringState = this.mFilterMap.get(iSpssVariable.getName());
            if (filteringState == null || filteringState.getFilterIconType() != 2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasFilters() {
        boolean bl = false;
        for (Map.Entry<String, FilteringState> entry : this.mFilterMap.entrySet()) {
            int n;
            FilteringState filteringState = entry.getValue();
            if (filteringState == null || (n = filteringState.getFilterIconType()) != 1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isExcludedCategory(ISpssVariable iSpssVariable, Map.Entry<OBS, String> entry) {
        FilteringState filteringState = null;
        HashMap<String, FilteringState> hashMap = this.getFilterMap();
        for (Map.Entry<String, FilteringState> categoryItemArray : hashMap.entrySet()) {
            if (!categoryItemArray.getKey().equals(iSpssVariable.getName())) continue;
            filteringState = categoryItemArray.getValue();
            break;
        }
        boolean bl = false;
        if (filteringState != null) {
            CategoryItem[] categoryItemArray;
            for (CategoryItem categoryItem : categoryItemArray = filteringState.getCategoryItems()) {
                if (!categoryItem.getObs().equals((Object)entry.getKey())) continue;
                bl = categoryItem.isChecked() == false;
                break;
            }
        }
        return bl;
    }

    public boolean isFilteredVar(ISpssVariable iSpssVariable) {
        boolean bl = false;
        if (this.mFilterMap == null) {
            return bl;
        }
        FilteringState filteringState = this.mFilterMap.get(iSpssVariable.getName());
        if (filteringState != null && filteringState.getFilterIconType() == 1) {
            bl = true;
        }
        return bl;
    }

    public ArrayList<ISpssVariable> getAllFilteredVars() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        VarListModel varListModel = this.mVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (!this.isFilteredVar(iSpssVariable)) continue;
            arrayList.add(iSpssVariable);
        }
        return arrayList;
    }

    public HashMap<String, FilteringState> getFilterMap() {
        return this.mFilterMap;
    }

    public void setFilterMap(HashMap<String, FilteringState> hashMap) {
        this.mFilterMap = hashMap;
    }

    public void putFilterState(String string, CategoryItem[] categoryItemArray, boolean bl) {
        this.mFilterMap.put(string, new FilteringState(categoryItemArray, bl));
    }

    public void modifyRelabelBag(ISpssVariable iSpssVariable, RelabelBag relabelBag) {
        FilteringState filteringState = this.mFilterMap.get(iSpssVariable.getName());
        if (filteringState != null) {
            CategoryItem[] categoryItemArray;
            for (CategoryItem categoryItem : categoryItemArray = filteringState.getCategoryItems()) {
                OBS oBS = categoryItem.getObs();
                if ((oBS.getString() == null || !oBS.getString().equals(relabelBag.getStrOrgValue())) && (oBS.getString() != null || oBS.getNum() != (double)Float.parseFloat(relabelBag.getStrOrgValue()))) continue;
                relabelBag.setExcluded(categoryItem.isChecked() == false);
                break;
            }
        }
    }

    public boolean isReloadingFilterControls() {
        return this.mReloadingFilterControls;
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.getModel().getRowCount() == 0 && this.mEmptyText.length() > 0 && graphics instanceof Graphics2D) {
            TextLayout textLayout;
            Rectangle rectangle = this.getBounds();
            rectangle.grow(-4, -4);
            Font font = graphics.getFont();
            graphics.setFont(this.mItalicFont);
            AttributedString attributedString = new AttributedString(this.mEmptyText);
            attributedString.addAttribute(TextAttribute.FONT, this.mItalicFont);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), new FontRenderContext(null, false, true));
            Vector<TextLayout> vector = new Vector<TextLayout>();
            while ((textLayout = lineBreakMeasurer.nextLayout(rectangle.width)) != null) {
                vector.add(textLayout);
            }
            float f = rectangle.y;
            for (TextLayout textLayout2 : vector) {
                float f2 = textLayout2.getAdvance();
                float f3 = (float)rectangle.x + ((float)rectangle.width - f2) / 2.0f;
                textLayout2.draw((Graphics2D)graphics, f3, f += textLayout2.getAscent());
                f += textLayout2.getDescent() + textLayout2.getLeading();
            }
            graphics.setFont(font);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray;
        if (listSelectionEvent.getValueIsAdjusting() || listSelectionEvent.getSource() != this.mVarList) {
            super.valueChanged(listSelectionEvent);
            return;
        }
        this.mReloadingFilterControls = true;
        int n = 0;
        boolean bl = false;
        GatherType gatherType = GatherType.gt_NoCats;
        Vector<CategoryItem> vector = new Vector<CategoryItem>();
        ISpssVariable[] iSpssVariableArray = this.mVarList.getSelectedValues();
        for (ISpssVariable object : iSpssVariableArray) {
            objectArray = object.getDisplayMeasurementLevel();
            if (objectArray.equals((Object)MeasurementLevel.nominal) || objectArray.equals((Object)MeasurementLevel.ordinal)) {
                bl = true;
                gatherType = this.analyzeCategories(object, vector, n == 0);
                if (gatherType.equals((Object)GatherType.gt_MixedSelection)) {
                    break;
                }
            } else if (gatherType.equals((Object)GatherType.gt_CatsPresent)) {
                gatherType = GatherType.gt_MixedSelection;
                vector.clear();
                break;
            }
            ++n;
        }
        Collections.sort(vector);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        if (defaultTableModel.getRowCount() > 0) {
            for (int i = defaultTableModel.getRowCount() - 1; i > -1; --i) {
                defaultTableModel.removeRow(i);
            }
        }
        ArrayList<CategoryItem> arrayList = new ArrayList<CategoryItem>();
        arrayList.ensureCapacity(vector.size());
        for (CategoryItem categoryItem : vector) {
            if (categoryItem.isMissing()) continue;
            arrayList.add(categoryItem);
        }
        for (CategoryItem categoryItem : vector) {
            if (!categoryItem.isMissing()) continue;
            arrayList.add(categoryItem);
        }
        if (!gatherType.equals((Object)GatherType.gt_PseudoCats)) {
            for (int i = 0; i < arrayList.size(); ++i) {
                CategoryItem categoryItem = (CategoryItem)arrayList.get(i);
                objectArray = new Object[]{categoryItem.isChecked(), categoryItem};
                defaultTableModel.addRow(objectArray);
            }
        }
        this.mSelectAllCheck.setVisible(defaultTableModel.getRowCount() > 0);
        this.mIncludeVCheck.setVisible(defaultTableModel.getRowCount() > 0);
        if (this.mSelectAllCheck.isVisible()) {
            this.mSelectAllCheck.setState(this.getCurrentSelectionState());
            this.mSelectAllCheck.repaint();
        }
        String string = "";
        if (defaultTableModel.getRowCount() == 0) {
            if (gatherType.equals((Object)GatherType.gt_MixedSelection)) {
                string = ResUtil.getCommonDlgString("IDS_MIXED_SELECTION");
            } else if (gatherType.equals((Object)GatherType.gt_PseudoCats)) {
                string = ResUtil.getCommonDlgString("IDS_NO_LABELED_CATEGORIES");
            } else if (!this.mVarList.getSelectionModel().isSelectionEmpty()) {
                string = ResUtil.getCommonDlgString("IDS_NO_CATEGORIES");
                if (!bl) {
                    string = string + " " + ResUtil.getCommonDlgString("IDS_SCALE_VARIABLE");
                }
            } else {
                string = ResUtil.getCommonDlgString("IDS_NO_SELECTIONS");
            }
        } else {
            this.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.getParentDlg().setEmptyCanvasText();
        this.setEmptyText(string);
        this.setFont(gatherType.equals((Object)GatherType.gt_PseudoCats) ? this.mItalicFont : this.mNormalFont);
        this.repaint();
        this.mReloadingFilterControls = false;
    }

    private GatherType analyzeCategories(ISpssVariable iSpssVariable, Vector<CategoryItem> vector, boolean bl) {
        GatherType gatherType = GatherType.gt_CatsPresent;
        return gatherType;
    }

    private ChartBuilderDlg getParentDlg() {
        return (ChartBuilderDlg)((Object)this.getTopLevelAncestor());
    }

    public String getFilterSyntaxPortion(ISpssVariable iSpssVariable) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        FilteringState filteringState = this.mFilterMap.get(iSpssVariable.getName());
        if (filteringState != null) {
            stringBuffer.append("VALUES=");
            CategoryItem[] categoryItemArray = filteringState.mCategoryItems;
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = 0;
            for (CategoryItem categoryItem : categoryItemArray) {
                if (categoryItem == null || categoryItem.isChecked() == null || !categoryItem.isChecked().booleanValue()) continue;
                stringBuffer2.append(categoryItem.getObs().getString() == null ? String.valueOf((int)categoryItem.getObs().getNum()) : categoryItem.getObs().getString());
                stringBuffer2.append(" ");
                ++n;
            }
            if (n == categoryItemArray.length || n == 0) {
                stringBuffer.append("ALL");
            } else {
                stringBuffer.append(stringBuffer2);
            }
            string = stringBuffer.toString().trim();
            string = string + " UNLABELED=";
            string = string + (filteringState.isIncludeUnlabeled() ? "INCLUDE" : "EXCLUDE");
        }
        return string;
    }

    public String getEmptyText() {
        return this.mEmptyText;
    }

    public void setEmptyText(String string) {
        this.mEmptyText = string;
    }

    public class FilteringState {
        CategoryItem[] mCategoryItems;
        boolean mIncludeUnlabeled;

        FilteringState(CategoryItem[] categoryItemArray, boolean bl) {
            this.mCategoryItems = categoryItemArray;
            this.mIncludeUnlabeled = bl;
        }

        public CategoryItem[] getCategoryItems() {
            return this.mCategoryItems;
        }

        public CategoryItem findCategoryItem(OBS oBS) {
            for (CategoryItem categoryItem : this.mCategoryItems) {
                if (categoryItem == null || (categoryItem.getObs().getString() != null || categoryItem.getObs().getNum() != oBS.getNum()) && (categoryItem.getObs().getString() == null || !categoryItem.getObs().getString().equals(oBS.getString()))) continue;
                return categoryItem;
            }
            return null;
        }

        public boolean isIncludeUnlabeled() {
            return this.mIncludeUnlabeled;
        }

        public int getFilterIconType() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (CategoryItem categoryItem : this.mCategoryItems) {
                if (categoryItem == null) {
                    ++n3;
                    continue;
                }
                if (categoryItem.isChecked() == null || !categoryItem.isChecked().booleanValue()) continue;
                ++n2;
            }
            n = n2 == this.mCategoryItems.length - n3 && this.mIncludeUnlabeled ? 0 : (n2 == 0 && !this.mIncludeUnlabeled ? 2 : 1);
            return n;
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        boolean mChecked;

        public CheckBoxRenderer() {
            this.setBorder(null);
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(this.mHighLightBorder);
            this.setBorderPainted(true);
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return new JLabel("");
            }
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(2);
            if (bl2) {
                this.setBorder(this.mHighLightBorder);
            } else {
                this.setBorder(this.mEmptyBorder);
            }
            this.setSelected((Boolean)object);
            boolean bl3 = jTable.isCellEditable(n, n2);
            this.setEnabled(bl3);
            return this;
        }
    }

    class CategoryLabelRenderer
    extends JLabel
    implements TableCellRenderer {
        CategoryLabelRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(10);
            this.setFocusable(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = object instanceof CategoryItem;
            if (bl3) {
                CategoryItem categoryItem = (CategoryItem)object;
                this.setIcon(categoryItem.getIcon());
                this.setText(categoryItem.getName());
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setEnabled(jTable.isEnabled());
            this.setFont(jTable.getFont());
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    static enum GatherType {
        gt_NoCats,
        gt_CatsPresent,
        gt_PseudoCats,
        gt_MixedSelection;

    }

    public static class CategoryItem
    extends CategoriesList.VarCatItem {
        boolean mChecked = true;

        public CategoryItem(String string, boolean bl, OBS oBS, boolean bl2) {
            super(string, bl, oBS);
            this.mChecked = bl2;
        }

        public Boolean isChecked() {
            return !this.isMissing() ? Boolean.valueOf(this.mChecked) : null;
        }

        public void setChecked(boolean bl) {
            this.mChecked = bl;
        }
    }
}

