/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.charteditor.template.ApplyTemplate;
import com.spss.charteditor.util.TrinityUtil;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartAppearanceOption;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartPrototype;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DataGenerator;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ITitles;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.StyleCycler;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneChangeType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneMgr;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.InterpolationGroup;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.RelabelBag;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.YXPairs;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.util.IOptionConstants;
import com.spss.uitools.util.TraceSettings;
import com.spss.vis.Source;
import com.spss.vis.Visualization;
import com.spss.vis.VisualizationFactory;
import com.spss.vis.action.coordinate.DropDimensionAction;
import com.spss.vis.action.coordinate.SetInsetCoordinatesAction;
import com.spss.vis.action.source.ConvertToEmbeddedAction;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.specification.AbstractSpecification;
import com.spss.vis.specification.Attribute;
import com.spss.vis.specification.ConditionalStyleSpecification;
import com.spss.vis.specification.ExtensionSpecification;
import com.spss.vis.specification.GraphSpecification;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.SpecificationChangeEvent;
import com.spss.vis.specification.UnitType;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.aesthetic.AestheticSpecification;
import com.spss.vis.specification.aesthetic.ColorAestheticSpecification;
import com.spss.vis.specification.aesthetic.ColorAffectType;
import com.spss.vis.specification.aesthetic.PatternAestheticSpecification;
import com.spss.vis.specification.aesthetic.StyleAestheticSpecification;
import com.spss.vis.specification.axis.AxisRepeatType;
import com.spss.vis.specification.axis.AxisSpecification;
import com.spss.vis.specification.axis.GridlineSpecification;
import com.spss.vis.specification.axis.MajorTicksSpecification;
import com.spss.vis.specification.axis.MinorTicksSpecification;
import com.spss.vis.specification.coordinate.CoordinateTransformSpecification;
import com.spss.vis.specification.coordinate.CoordinatesSpecification;
import com.spss.vis.specification.coordinate.ObliqueCoordinateSpecification;
import com.spss.vis.specification.coordinate.PolarTransformSpecification;
import com.spss.vis.specification.coordinate.ReflectionCoordinateSpecification;
import com.spss.vis.specification.coordinate.TransposeCoordinateSpecification;
import com.spss.vis.specification.data.DataSpecification;
import com.spss.vis.specification.data.DerivedVariableSpecification;
import com.spss.vis.specification.data.ExpressionVariableSpecification;
import com.spss.vis.specification.data.SourceVariableSpecification;
import com.spss.vis.specification.data.UserSourceSpecification;
import com.spss.vis.specification.data.VariableSpecification;
import com.spss.vis.specification.dimension.DimensionSpecification;
import com.spss.vis.specification.dimension.DimensionType;
import com.spss.vis.specification.domain.CategoricalDomainSpecification;
import com.spss.vis.specification.domain.DomainSpecification;
import com.spss.vis.specification.domain.FixedCategorySpecification;
import com.spss.vis.specification.domain.IntervalDomainSpecification;
import com.spss.vis.specification.domain.SimpleSortSpecification;
import com.spss.vis.specification.domain.SortMethodType;
import com.spss.vis.specification.domain.SortSpecification;
import com.spss.vis.specification.element.AreaSpecification;
import com.spss.vis.specification.element.BreakRepresentationType;
import com.spss.vis.specification.element.ElementSpecification;
import com.spss.vis.specification.element.IntervalSpecification;
import com.spss.vis.specification.element.LabelCollisionHandlingType;
import com.spss.vis.specification.element.LineSpecification;
import com.spss.vis.specification.element.PointSpecification;
import com.spss.vis.specification.element.PositionModifierType;
import com.spss.vis.specification.element.SchemaSpecification;
import com.spss.vis.specification.facet.CrossSpecification;
import com.spss.vis.specification.facet.ExpressionSpecification;
import com.spss.vis.specification.facet.ExpressionType;
import com.spss.vis.specification.facet.FacetLayoutSpecification;
import com.spss.vis.specification.facet.FacetLevelSpecification;
import com.spss.vis.specification.facet.FacetingSpecification;
import com.spss.vis.specification.facet.UnitySpecification;
import com.spss.vis.specification.facet.VariableReferenceSpecification;
import com.spss.vis.specification.format.FormatSpecification;
import com.spss.vis.specification.format.RelabelSpecification;
import com.spss.vis.specification.guide.GuideSpecification;
import com.spss.vis.specification.guide.PlaneGuideSpecification;
import com.spss.vis.specification.label.LabelSpecification;
import com.spss.vis.specification.layout.LocationPartType;
import com.spss.vis.specification.layout.LocationSpecification;
import com.spss.vis.specification.statistic.BinStatisticSpecification;
import com.spss.vis.specification.statistic.DistributionStatisticSpecification;
import com.spss.vis.specification.statistic.DistributionType;
import com.spss.vis.specification.statistic.GridType;
import com.spss.vis.specification.statistic.SmoothMethodType;
import com.spss.vis.specification.statistic.SmoothStatisticSpecification;
import com.spss.vis.specification.statistic.StatisticSpecification;
import com.spss.vis.specification.statistic.SummaryBaseType;
import com.spss.vis.specification.statistic.SummaryStatisticSpecification;
import com.spss.vis.specification.statistic.SummaryType;
import com.spss.vis.specification.statistic.TukeyStatisticSpecification;
import com.spss.vis.specification.style.CycleSpecification;
import com.spss.vis.specification.style.FillStyle;
import com.spss.vis.specification.style.LineStyle;
import com.spss.vis.specification.style.StyleCycleSpecification;
import com.spss.vis.specification.style.StyleSpecification;
import com.spss.vis.specification.style.SymbolType;
import com.spss.vis.specification.style.TextStyle;
import com.spss.vis.template.Template;
import com.spss.vis.template.TemplateFactory;
import com.spss.vizimager.VizDataProcessor;
import com.spss.vizimager.VizDataSource;
import com.spss.vizimager.VizDataWriter;
import com.spss.vizimager.VizHighlighter;
import com.spss.vizimager.VizImager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.text.Bidi;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CanvasImager
extends VizImager
implements IPropEnum {
    private static final int MAX_CATS = 10;
    protected static final String RANGE_KEY = "range_key";
    protected static final String LOW_RANGE_KEY = "low_range_key";
    protected static final String HIGH_RANGE_KEY = "high_range_key";
    protected static final String DIFF_AREA_KEY = "diff_area";
    private static final String AXIS1_ASSOC_KEY = "AxisY1_assoc";
    private static final String AXIS2_ASSOC_KEY = "AxisY2_assoc";
    protected Visualization mVisualization = null;
    protected ChartPrototype mChartProto = null;
    protected BufferedImage mImage = null;
    protected ChartCanvas mCanvas = null;
    protected Coords mCoordinates = Coords.coords_none;
    protected Collection<VizDataSource> mSources = null;
    protected DataGenerator mDataGenerator = null;
    protected StyleCycler mStyleCycler = null;
    protected ChartAppearanceOption mChartAppearanceOption = null;
    protected VizHighlighter mHighlighter = null;
    protected String mStrHighlights = "";
    protected String mPrototypeTitle = "";
    protected String mPrototypeStr = "";

    public CanvasImager(ChartCanvas chartCanvas) {
        this.mCanvas = chartCanvas;
        this.mDataGenerator = new DataGenerator(this);
        this.mStyleCycler = new StyleCycler(this);
        this.mChartAppearanceOption = new ChartAppearanceOption(this);
        if (this.mChartAppearanceOption.getCycleColors().length > 0 && this.mChartAppearanceOption.getCycleColors()[0] != null) {
            this.mStyleCycler.refreshColorCycle(this.mChartAppearanceOption.getCycleColors());
        }
        this.mHighlighter = new VizHighlighter();
    }

    public void setPrototype(ChartPrototype chartPrototype) {
        this.mChartProto = chartPrototype;
        this.mImage = null;
        this.mSources = null;
        this.buildVizSpecFromPrototype();
        this.managePolarSummaryStatistic(this.mCoordinates == Coords.coords_Polar);
    }

    public ChartPrototype getPrototype() {
        return this.mChartProto;
    }

    public ChartCanvas getOwnerCanvas() {
        return this.mCanvas;
    }

    public void addDataElement(Elements elements) {
        if (elements == Elements.none) {
            return;
        }
        try {
            this.setCoordsForElementType(elements);
            boolean bl = elements == Elements.hilo;
            ElementSpecification elementSpecification = this.createElement(elements);
            this.adjustElementVariables(elementSpecification);
            this.managePolarSummaryStatistic(this.mCoordinates == Coords.coords_Polar);
            if (bl) {
                this.setupHiLoClose((IntervalSpecification)elementSpecification);
            }
            if (elements == Elements.diff_area) {
                this.setupDifferenceArea((AreaSpecification)elementSpecification);
            }
            if (elements == Elements.pyramid) {
                this.setupPopPyramid((IntervalSpecification)elementSpecification);
            }
            if (elements == Elements.schema) {
                this.setSchemaWidths((SchemaSpecification)elementSpecification);
            }
            if (elements == Elements.splom) {
                this.setupSplom((PointSpecification)elementSpecification);
            }
            Props.ElProps elProps = this.getDefaultDataProp();
            this.removeDefaultElement();
            if (elProps != null) {
                Props.ElProps elProps2 = (Props.ElProps)this.getElementProp(elementSpecification);
                if (!bl) {
                    elProps2.getStatistic().setStat(elProps.getStatistic().getStat());
                    elProps2.getStatistic().setStrParm1(elProps.getStatistic().getStrParm1());
                    elProps2.getStatistic().setStrParm2(elProps.getStatistic().getStrParm2());
                }
                elProps2.setLevel(elProps.getLevel());
                elProps2.setMultiplierStdError(elProps.getMultiplierStdError());
                elProps2.setMultiplierStdDev(elProps.getMultiplierStdDev());
                elProps2.setFlags(elProps.getFlags() & 0xFFFFFF7F);
                elProps2.setSSVData(elProps.getSSVData());
                ChartProps chartProps = new ChartProps();
                chartProps.addProp(elProps2);
                this.setProperties(chartProps, true);
            } else if (this.mCoordinates == Coords.coords_DualY) {
                this.updateZoneLabel(ZoneType.zt_y2);
            }
            this.mImage = null;
            this.mSources = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeDataElement(Props.ElProps elProps) {
        IntervalSpecification intervalSpecification;
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", elProps.getStrElId());
        boolean bl = this.isPopulationPyramid();
        this.handleRemoveZone(ZoneType.zt_panel_horz);
        this.handleRemoveZone(ZoneType.zt_panel_vert);
        this.takeOutErrorBars(elProps);
        if (this.hasXCluster()) {
            this.handleRemoveZone(ZoneType.zt_cluster_x);
        } else if (this.hasZCluster()) {
            this.handleRemoveZone(ZoneType.zt_cluster_z);
        }
        if (this.isHiLoClose() && (intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class)) != null) {
            intervalSpecification.getParent().remove((Specification)intervalSpecification);
        }
        this.removeNormalCurve();
        if (bl) {
            this.takeoutPyramidElements();
        }
        elementSpecification.getParent().remove((Specification)elementSpecification);
        this.validateElements(this.mCoordinates);
        this.mImage = null;
        this.mSources = null;
    }

    public void removeNormalCurve() {
        LineSpecification lineSpecification = this.getNormalCurve();
        if (lineSpecification != null) {
            lineSpecification.getParent().remove((Specification)lineSpecification);
        }
    }

    public boolean isEmpty() {
        return this.mVisualization == null;
    }

    public void setEmpty() {
        this.mVisualization = null;
        this.mChartProto = null;
        this.mImage = null;
        this.mSources = null;
        this.mCoordinates = Coords.coords_none;
        this.mChartAppearanceOption.reset(true);
        this.mStyleCycler.refreshColorCycle(this.mChartAppearanceOption.getCycleColors());
    }

    public int getMaxCats() {
        return 10;
    }

    public void setTitle(ITitles.TitleType titleType, boolean bl) {
        if (this.isEmpty()) {
            assert (false);
            return;
        }
        ExtensionSpecification extensionSpecification = this.getTitlesExtension();
        String string = this.getTitleKey(titleType);
        String string2 = string + "_flags";
        extensionSpecification.put(string, bl ? "" : null);
        extensionSpecification.put(string2, bl ? "0" : null);
    }

    public boolean hasTitle(ITitles.TitleType titleType) {
        String string;
        if (this.isEmpty()) {
            return false;
        }
        ExtensionSpecification extensionSpecification = this.getTitlesExtension();
        String string2 = extensionSpecification.get(string = this.getTitleKey(titleType));
        return string2 != null;
    }

    public boolean isTransposed() {
        return !this.isEmpty() && this.getFirstSpecByClass(null, TransposeCoordinateSpecification.class) != null;
    }

    public void transpose() {
        if (this.isEmpty()) {
            return;
        }
        boolean bl = this.isTransposed();
        if (bl) {
            Specification specification = this.getFirstSpecByClass(null, TransposeCoordinateSpecification.class);
            specification.getParent().remove(specification);
        } else {
            Specification specification = this.getFirstSpecByClass(null, CoordinatesSpecification.class);
            if (specification != null) {
                ((CoordinatesSpecification)specification).addCoordinateTransform((CoordinateTransformSpecification)new TransposeCoordinateSpecification());
            }
        }
        this.mImage = null;
    }

    public boolean hasRegressionLine() {
        GraphSpecification graphSpecification;
        ElementSpecification[] elementSpecificationArray;
        Elements elements = this.getPrimaryElementType();
        if ((elements == Elements.point || elements == Elements.splom) && (elementSpecificationArray = (graphSpecification = this.getGraphSpec()).getElementSpecifications()) != null) {
            for (ElementSpecification elementSpecification : elementSpecificationArray) {
                StatisticSpecification[] statisticSpecificationArray;
                if (!(elementSpecification instanceof LineSpecification) || (statisticSpecificationArray = ((LineSpecification)elementSpecification).getStatistics()) == null) continue;
                for (StatisticSpecification statisticSpecification : statisticSpecificationArray) {
                    if (!(statisticSpecification instanceof SmoothStatisticSpecification)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void regressionLine() {
        if (this.isEmpty()) {
            return;
        }
        boolean bl = this.hasRegressionLine();
        if (bl) {
            Specification specification = this.getFirstSpecByClass(null, LineSpecification.class);
            specification.getParent().remove(specification);
        } else {
            GraphSpecification graphSpecification = this.getGraphSpec();
            PointSpecification pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class);
            LineSpecification lineSpecification = new LineSpecification();
            lineSpecification.setX(pointSpecification.getX());
            lineSpecification.setY(pointSpecification.getY());
            SmoothStatisticSpecification smoothStatisticSpecification = new SmoothStatisticSpecification(SmoothMethodType.LINEAR);
            lineSpecification.addStatistic((StatisticSpecification)smoothStatisticSpecification);
            graphSpecification.addElement((ElementSpecification)lineSpecification);
        }
        this.mImage = null;
    }

    public ChartProps getProperties() {
        ChartProps chartProps = new ChartProps();
        if (!this.isEmpty()) {
            try {
                chartProps.setCoords(this.getCoordinates());
                chartProps.setHasSSVs(this.hasSSVs());
                chartProps.setIsOverlayScatter(this.isOverlayScatter());
                this.acquireElementProps(chartProps);
                this.acquireAxisProps(chartProps);
                this.acquireLegendProps(chartProps);
                this.acquireFilterPanelProps(chartProps);
                this.acquirePanelProps(chartProps);
                this.acquireTitleProps(chartProps);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        chartProps.clearModFlags();
        return chartProps;
    }

    public boolean setProperties(ChartProps chartProps, boolean bl) {
        if (!chartProps.isModified() && !this.mChartAppearanceOption.isModified()) {
            return false;
        }
        try {
            boolean bl2 = false;
            if (chartProps.getCoords() == Coords.coords_DualY) {
                this.checkDualYElementSwaps(chartProps);
                bl2 = this.isElementModified(chartProps);
            }
            for (Props props : chartProps.getProperties()) {
                if (!props.isModified() && (!(props instanceof Props.ElProps) || !this.mChartAppearanceOption.isModified())) continue;
                this.dispatchProperty(props, bl);
            }
            if (bl2) {
                this.setDualYColors(chartProps);
            }
            this.mImage = null;
            this.mSources = null;
            chartProps.clearModFlags();
            this.mChartAppearanceOption.setModified(false);
            this.cleanupSpec();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean getUsesColorForStyleByType(ZoneType zoneType) {
        StyleCycleSpecification styleCycleSpecification;
        String[] stringArray3;
        StyleCycleSpecification styleCycleSpecification2;
        if (zoneType == ZoneType.zt_split_var) {
            return true;
        }
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        StyleCycleSpecification styleCycleSpecification3 = styleCycleSpecification2 = elementSpecification != null ? elementSpecification.getAestheticSpecifications() : null;
        if (styleCycleSpecification2 == null || elementSpecification.getAestheticSpecifications().length == 0) {
            return false;
        }
        VariableSpecification variableSpecification = this.getVarSpecForZoneType(zoneType, elementSpecification, (AestheticSpecification[])styleCycleSpecification2);
        if (variableSpecification == null) {
            assert (false);
            return false;
        }
        String[] stringArray2 = null;
        for (String[] stringArray3 : styleCycleSpecification2) {
            if (!variableSpecification.equals(stringArray3.getVariable())) continue;
            stringArray2 = stringArray3;
            break;
        }
        if (stringArray2 instanceof ColorAestheticSpecification) {
            styleCycleSpecification = ((ColorAestheticSpecification)stringArray2).getCycle();
        } else if (stringArray2 instanceof StyleAestheticSpecification) {
            styleCycleSpecification = ((StyleAestheticSpecification)stringArray2).getStyleCycleSpecification();
        } else {
            return false;
        }
        CycleSpecification[] cycleSpecificationArray = styleCycleSpecification.getCycles();
        if (cycleSpecificationArray == null || cycleSpecificationArray.length == 0) {
            return false;
        }
        StyleSpecification[] styleSpecificationArray = cycleSpecificationArray[0].getStyles();
        if (styleSpecificationArray == null || styleSpecificationArray.length == 0) {
            return false;
        }
        for (String string : stringArray3 = styleSpecificationArray[0].getAllValidKeys()) {
            if (string.indexOf("color") > -1 || string.equals("fill") || string.equals("stroke")) {
                return true;
            }
            if (string.indexOf("pattern") <= -1 && !string.equals("symbol") && string.indexOf("stroke-dasharray") <= -1) continue;
            return false;
        }
        return false;
    }

    public void updateVizSpec() {
        this.setDefaultStyles();
    }

    public void refreshCategories(ISpssVariable iSpssVariable) {
        if (this.mVisualization == null) {
            return;
        }
        ZoneType zoneType = this.mCanvas.getZoneMgr().getVarZoneType(iSpssVariable);
        if (zoneType == null) {
            return;
        }
        VariableSpecification variableSpecification = this.getVarForZone(zoneType);
        this.setupVarCategories((SourceVariableSpecification)variableSpecification, iSpssVariable, zoneType);
        this.setupCategoricalDomain((SourceVariableSpecification)variableSpecification, iSpssVariable);
        this.mCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.elementChange);
    }

    private VariableSpecification getVarSpecForZoneType(ZoneType zoneType, ElementSpecification elementSpecification, AestheticSpecification[] aestheticSpecificationArray) {
        VariableSpecification variableSpecification = null;
        if (zoneType == ZoneType.zt_cluster_x) {
            variableSpecification = elementSpecification.getX();
        } else if (zoneType == ZoneType.zt_cluster_z) {
            variableSpecification = elementSpecification.getZ();
        } else if (zoneType == ZoneType.zt_group) {
            for (AestheticSpecification aestheticSpecification : aestheticSpecificationArray) {
                if (elementSpecification.getX().equals(aestheticSpecification.getVariable()) || this.mCoordinates == Coords.coords_3D && elementSpecification.getZ().equals(aestheticSpecification.getVariable())) continue;
                variableSpecification = aestheticSpecification.getVariable();
                break;
            }
        } else if (zoneType == ZoneType.zt_slice_by) {
            variableSpecification = aestheticSpecificationArray[0].getVariable();
        }
        return variableSpecification;
    }

    public void zoneChange(ZoneMgr zoneMgr, ZoneType zoneType, ZoneChangeType zoneChangeType) {
        try {
            if (this.isEmpty()) {
                return;
            }
            if (zoneChangeType.equals((Object)ZoneChangeType.addVariable) || zoneChangeType.equals((Object)ZoneChangeType.removeVariable)) {
                this.rebuildVariable(zoneMgr.getZone(zoneType));
            } else if (zoneChangeType.equals((Object)ZoneChangeType.addZone)) {
                this.handleAddZone(zoneMgr.getZone(zoneType));
            } else if (zoneChangeType.equals((Object)ZoneChangeType.removeZone)) {
                this.handleRemoveZone(zoneType);
            }
            this.mSources = null;
            this.mImage = null;
            this.mChartAppearanceOption.updateDefaultGridlineOptionOnly();
            if (this.mCoordinates == Coords.coords_2D) {
                this.updateGridline(this.mChartAppearanceOption.isGridlineX(), "x");
                this.updateGridline(this.mChartAppearanceOption.isGridlineY(), "y");
            }
            this.mCanvas.getParentDlg().getSidePropertiesPanel().getChartAppearancePanel().refreshChartAppearanceOptionControls();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void render(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        if (this.isEmpty()) {
            return;
        }
        if (this.mSources == null) {
            this.refreshData();
        }
        if (!this.withinSizeTolerance(rectangle)) {
            if (this.mCanvas != null) {
                this.mCanvas.getParentDlg().setCursor(Cursor.getPredefinedCursor(3));
            }
            this.makeImage(rectangle);
            if (bl && this.mImage != null && this.mStrHighlights != null && this.mStrHighlights.length() > 0) {
                this.mHighlighter.renderHilites(this.mVisualization, this.mImage, this.mStrHighlights);
            }
            if (this.mCanvas != null) {
                this.mCanvas.getParentDlg().setCursor(null);
            }
        }
        if (this.mImage != null) {
            graphics2D.drawImage((Image)this.mImage, rectangle.x, rectangle.y, null);
        }
    }

    public Visualization getVisualization() {
        return this.mVisualization;
    }

    public VisualizationSpecification getSpecification() {
        if (this.isEmpty()) {
            return null;
        }
        return this.mVisualization.getSpecification();
    }

    public Coords getCoordinates() {
        return this.mCoordinates;
    }

    public void setCoordinates(Coords coords) {
        if (this.mCoordinates.equals((Object)coords)) {
            return;
        }
        try {
            if (this.isEmpty()) {
                this.setupBaseChart();
            }
            boolean bl = this.isSingleDimensionDotPlot();
            boolean bl2 = this.isSplom();
            boolean bl3 = this.isPopulationPyramid();
            boolean bl4 = coords == Coords.coords_1D && ((PointSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(PointSpecification.class)).length > 0;
            int n = this.dimCountForCoords(this.mCoordinates);
            int n2 = this.dimCountForCoords(coords);
            try {
                this.handleGroupingForCoordChange(coords);
                GraphSpecification graphSpecification = this.getGraphSpec();
                CoordinatesSpecification coordinatesSpecification = (CoordinatesSpecification)this.getFirstSpecByClass((Specification)graphSpecification, CoordinatesSpecification.class);
                int n3 = n;
                while (n3 > n2) {
                    new DropDimensionAction(--n3).modify(this.mVisualization.getSpecification());
                }
                n3 = n;
                DimensionSpecification[] dimensionSpecificationArray = coordinatesSpecification.getDimensionSpecifications();
                for (int i = dimensionSpecificationArray.length - 1; i >= n2; --i) {
                    dimensionSpecificationArray[i].getParent().remove((Specification)dimensionSpecificationArray[i]);
                }
                while (n3++ < n2) {
                    DimensionSpecification dimensionSpecification = new DimensionSpecification(true);
                    coordinatesSpecification.addDimension(dimensionSpecification);
                    ZoneType zoneType = n3 == 1 ? ZoneType.zt_x : (n3 == 2 ? ZoneType.zt_y : ZoneType.zt_z);
                    this.setTickLabelVisibility(zoneType, false);
                    this.clearVarForZoneType(zoneType);
                }
                if (bl || bl4) {
                    this.adjustDotPlotDimension(coords, bl, bl4);
                }
                if (bl2) {
                    this.takeoutSplomElements();
                } else if (bl3) {
                    this.takeoutPyramidElements();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.validateElements(coords);
            this.handlePolarChanges(coords);
            this.handle3DChanges(coords);
            this.handleDualYChanges(coords);
            this.handleSchemaChanges(coords);
            this.removeAxisLabels();
            this.removeYTicks();
            this.cleanupSpec();
            this.mCoordinates = coords;
            this.mImage = null;
            this.mSources = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int dataElementCount() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = 0;
        try {
            ElementSpecification[] elementSpecificationArray;
            for (ElementSpecification elementSpecification : elementSpecificationArray = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
                if (this.isErrorBarElement(elementSpecification) || this.isHiddenLine(elementSpecification)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public void setHighlights(String string) {
        this.mStrHighlights = string;
        this.mImage = null;
    }

    public boolean isPopulationPyramid() {
        return !this.isEmpty() && ((ReflectionCoordinateSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ReflectionCoordinateSpecification.class)).length > 0 && ((IntervalSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(IntervalSpecification.class)).length > 0;
    }

    public boolean isHistogram() {
        ElementStat elementStat = this.getStatForDependentZone(this.getDepZoneType());
        if (elementStat != null) {
            return elementStat.getStat() == Statistics.Histogram || elementStat.getStat() == Statistics.HistogramPct;
        }
        return !this.isEmpty() && !this.isPopulationPyramid() && ((BinStatisticSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(BinStatisticSpecification.class)).length > 0 && ((DistributionStatisticSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(DistributionStatisticSpecification.class)).length > 0;
    }

    public boolean isSplom() {
        return !this.isEmpty() && ((ConditionalStyleSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ConditionalStyleSpecification.class)).length > 0;
    }

    public boolean isSingleDimensionDotPlot() {
        return !this.isEmpty() && this.mCoordinates == Coords.coords_1D && ((PointSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(PointSpecification.class)).length > 0;
    }

    public boolean isSchema() {
        return !this.isEmpty() && ((SchemaSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(SchemaSpecification.class)).length > 0;
    }

    public boolean isHiLoClose() {
        return !this.isEmpty() && this.checkRangeElements(false);
    }

    public boolean isDifferenceArea() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bl = this.getFirstSpecByClass(null, AreaSpecification.class) != null;
        return bl && (this.getSpecByClassAndAttr(null, ColorAestheticSpecification.class, "affect", "main") != null || this.getSpecByClassAndAttr(null, PatternAestheticSpecification.class, "clamp", "true") != null);
    }

    public boolean hasErrorBars() {
        ElementSpecification[] elementSpecificationArray;
        if (this.isEmpty()) {
            return false;
        }
        VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
        for (ElementSpecification elementSpecification : elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class)) {
            StatisticSpecification[] statisticSpecificationArray = elementSpecification.getStatistics();
            if (statisticSpecificationArray.length <= 0 || !(statisticSpecificationArray[0] instanceof SummaryStatisticSpecification)) continue;
            boolean bl = ((SummaryStatisticSpecification)statisticSpecificationArray[0]).getMethod() == SummaryType.RANGE;
            boolean bl2 = ((SummaryStatisticSpecification)statisticSpecificationArray[0]).getBase() == SummaryBaseType.COORDINATE;
            VariableSpecification variableSpecification = elementSpecification.getY();
            if (!bl || !bl2 || !(variableSpecification instanceof ExpressionVariableSpecification)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSSVs() {
        DropZone dropZone;
        if (this.isEmpty()) {
            return false;
        }
        boolean bl = false;
        ZoneMgr zoneMgr = this.mCanvas.getZoneMgr();
        if (this.mCoordinates == Coords.coords_2D || this.mCoordinates == Coords.coords_3D) {
            DropZone dropZone2 = zoneMgr.getZone(ZoneType.zt_y);
            if (dropZone2 != null) {
                bl = dropZone2.getVariables().size() > 1 && !this.isOverlayScatter();
            }
        } else if (this.mCoordinates == Coords.coords_Polar && (dropZone = zoneMgr.getZone(ZoneType.zt_angle)) != null) {
            bl = dropZone.getVariables().size() > 1;
        }
        return bl && zoneMgr.getIndexVarZoneType() != null;
    }

    public Props.SSVData getSSVData() {
        if (!this.hasSSVs()) {
            return null;
        }
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        if (elementSpecification != null) {
            Props.BarProps barProps = new Props.BarProps();
            this.getSSVStatistics(elementSpecification, barProps);
            return barProps.getSSVData();
        }
        return null;
    }

    public boolean isOverlayScatter() {
        if (this.isEmpty()) {
            return false;
        }
        ZoneMgr zoneMgr = this.mCanvas.getZoneMgr();
        DropZone dropZone = zoneMgr.getZone(ZoneType.zt_y);
        boolean bl = this.mCoordinates == Coords.coords_2D;
        boolean bl2 = this.getFirstSpecByClass(null, PointSpecification.class) != null;
        boolean bl3 = !zoneMgr.hasCatVar(ZoneType.zt_x);
        boolean bl4 = zoneMgr.hasScaleVar(ZoneType.zt_y);
        int n = dropZone != null ? dropZone.getVariables().size() : 0;
        return bl3 && bl4 && bl2 && bl && n > 1 && !this.hasErrorBars() && !this.isDropLine();
    }

    public boolean isDropLine() {
        if (this.isEmpty()) {
            return false;
        }
        PointSpecification pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class);
        if (pointSpecification == null) {
            return false;
        }
        AestheticSpecification[] aestheticSpecificationArray = pointSpecification.getAestheticSpecifications();
        if (aestheticSpecificationArray.length != 1 || !(aestheticSpecificationArray[0] instanceof StyleAestheticSpecification)) {
            return false;
        }
        IntervalSpecification intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class);
        if (intervalSpecification == null) {
            return false;
        }
        if (intervalSpecification.getAestheticSpecifications().length > 0) {
            return false;
        }
        StatisticSpecification[] statisticSpecificationArray = intervalSpecification.getStatistics();
        if (statisticSpecificationArray.length != 1 || !(statisticSpecificationArray[0] instanceof SummaryStatisticSpecification)) {
            return false;
        }
        if (((SummaryStatisticSpecification)statisticSpecificationArray[0]).getMethod() != SummaryType.RANGE) {
            return false;
        }
        return pointSpecification.getX().equals(intervalSpecification.getX()) && pointSpecification.getY().equals(intervalSpecification.getY());
    }

    public boolean hasHorzPanels() {
        return !this.isEmpty() && !this.isPopulationPyramid() && !this.isSplom() && this.getSpecByClassAndAttr((Specification)this.mVisualization.getSpecification(), FacetLevelSpecification.class, "level", "1") != null;
    }

    public boolean hasVertPanels() {
        return !this.isEmpty() && !this.isSplom() && this.getSpecByClassAndAttr((Specification)this.mVisualization.getSpecification(), FacetLevelSpecification.class, "level", "2") != null;
    }

    public boolean hasPointId() {
        if (this.isEmpty()) {
            return false;
        }
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        if (elementSpecification == null) {
            return false;
        }
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = extensionSpecification.get("flags");
        if (string != null && string.length() > 0) {
            int n = Integer.valueOf(string);
            return (n & 0x20) != 0;
        }
        return false;
    }

    public boolean hasXCluster() {
        if (!this.isEmpty()) {
            Specification[] specificationArray = this.mVisualization.getSpecification().findDescendantsOfType(DimensionSpecification.class);
            for (int i = 0; i < specificationArray.length; ++i) {
                DimensionSpecification dimensionSpecification = (DimensionSpecification)specificationArray[i];
                if (dimensionSpecification.getClusterVariable() == null) continue;
                return i == 0;
            }
        }
        return false;
    }

    public boolean hasZCluster() {
        if (!this.isEmpty()) {
            Specification[] specificationArray = this.mVisualization.getSpecification().findDescendantsOfType(DimensionSpecification.class);
            for (int i = 0; i < specificationArray.length; ++i) {
                DimensionSpecification dimensionSpecification = (DimensionSpecification)specificationArray[i];
                if (i != 2 || dimensionSpecification.getClusterVariable() == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasGrouping() {
        if (this.isEmpty() || this.mCoordinates.equals((Object)Coords.coords_Polar)) {
            return false;
        }
        Specification[] specificationArray = this.mVisualization.getSpecification().findDescendantsOfType(StyleAestheticSpecification.class);
        boolean bl = false;
        for (Specification specification : specificationArray) {
            VariableSpecification variableSpecification = ((StyleAestheticSpecification)specification).getVariable();
            if (variableSpecification == null) continue;
            bl = false;
            AbstractSpecification abstractSpecification = (AbstractSpecification)specification.getParent();
            Attribute attribute = abstractSpecification.getAttribute("x");
            Attribute attribute2 = abstractSpecification.getAttribute("z");
            if (attribute != null && attribute.asSpecification().equals(variableSpecification)) {
                bl = true;
            } else if (attribute2 != null && attribute2.asSpecification().equals(variableSpecification)) {
                bl = true;
            }
            if (bl || !this.mCoordinates.equals((Object)Coords.coords_3D)) continue;
            return true;
        }
        return !bl && specificationArray.length > 0 || this.isSplom() && this.getFirstSpecByClass(null, ColorAestheticSpecification.class) != null;
    }

    public boolean hasElementStacking() {
        if (this.isEmpty()) {
            return false;
        }
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        return elementSpecification != null && elementSpecification.getPositionModifier() == PositionModifierType.STACK;
    }

    public Props.ElProps getDefaultDataProp() {
        Props.ElProps elProps = null;
        if (!this.isEmpty()) {
            try {
                ElementSpecification elementSpecification;
                Specification[] specificationArray = this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class);
                if (specificationArray != null && specificationArray.length > 0 && this.isHiddenLine(elementSpecification = (ElementSpecification)specificationArray[0])) {
                    elProps = (Props.ElProps)this.getElementProp(elementSpecification);
                    elProps.setFlags(elProps.getFlags() | 0x80);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return elProps;
    }

    public String getDualYAxisColor(int n) {
        if (this.mCoordinates != Coords.coords_DualY || n < 0 || n > 1) {
            return "000000";
        }
        Color color = this.mStyleCycler.getDualYAxisColor(n);
        return String.format("%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public boolean getUsesColorByDefault() {
        return this.mStyleCycler.getUseColors();
    }

    public ElementStat getStatForDependentZone(ZoneType zoneType) {
        ElementStat elementStat = null;
        ChartProps chartProps = this.getProperties();
        if (zoneType == ZoneType.zt_y || zoneType == ZoneType.zt_angle) {
            Props.ElProps elProps = chartProps.getElementProp(0);
            if (chartProps.getCoords() == Coords.coords_DualY && elProps != null && elProps.getStrElAssoc().equals("2")) {
                elProps = chartProps.getElementProp(1);
            }
            if (elProps != null) {
                elementStat = elProps.getStatistic();
            }
        } else if (zoneType == ZoneType.zt_y2) {
            Props.ElProps elProps = chartProps.getElementProp(1);
            if (chartProps.getCoords() == Coords.coords_DualY && elProps != null && elProps.getStrElAssoc().equals("1")) {
                elProps = chartProps.getElementProp(0);
            }
            if (elProps != null) {
                elementStat = elProps.getStatistic();
            }
        } else if (zoneType == ZoneType.zt_high || zoneType == ZoneType.zt_low || zoneType == ZoneType.zt_close) {
            Props.HiLoCloseProps hiLoCloseProps;
            Props.ElProps elProps = chartProps.getElementProp(0);
            Props.HiLoCloseProps hiLoCloseProps2 = hiLoCloseProps = elProps != null ? (Props.HiLoCloseProps)elProps : null;
            if (hiLoCloseProps != null) {
                elementStat = zoneType == ZoneType.zt_high ? hiLoCloseProps.getHighStat() : (zoneType == ZoneType.zt_low ? hiLoCloseProps.getLowStat() : hiLoCloseProps.getCloseStat());
            }
        }
        return elementStat;
    }

    public Elements getPrimaryElementType() {
        if (this.isEmpty()) {
            return Elements.none;
        }
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        return this.getElementType(this.mCoordinates, elementSpecification);
    }

    public Statistics getPrimaryStatistic() {
        ElementStat elementStat;
        ElementSpecification elementSpecification;
        Statistics statistics = Statistics.Count;
        if (this.mVisualization != null && (elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class)) != null && (elementStat = this.getStatistic(elementSpecification)) != null) {
            statistics = elementStat.getStat();
        }
        return statistics;
    }

    public Statistics getSecondaryStatistic() {
        ElementStat elementStat;
        Statistics statistics = null;
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClass(null, ElementSpecification.class, 1);
        if (elementSpecification != null && (elementStat = this.getStatistic(elementSpecification)) != null) {
            statistics = elementStat.getStat();
        }
        return statistics;
    }

    public boolean dualYElementWithFirstYAxis(String string) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", string);
        return elementSpecification == null || this.dualYElementWithFirstYAxis(elementSpecification);
    }

    public boolean dualYElementWithFirstYAxis(ElementSpecification elementSpecification) {
        ExtensionSpecification[] extensionSpecificationArray;
        boolean bl = true;
        GraphSpecification graphSpecification = this.getGraphSpec();
        for (ExtensionSpecification extensionSpecification : extensionSpecificationArray = graphSpecification.getExtensionSpecifications()) {
            String string = extensionSpecification.get(AXIS1_ASSOC_KEY);
            String string2 = extensionSpecification.get(AXIS2_ASSOC_KEY);
            if (string != null && string.equals(elementSpecification.getId())) {
                bl = true;
                break;
            }
            if (string2 == null || !string2.equals(elementSpecification.getId())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void updateOverlayYXPairs() {
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        if (!this.isOverlayScatter()) {
            extensionSpecification.put("YXpairs", "");
            return;
        }
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_y);
        DropZone dropZone2 = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_x);
        Vector<ISpssVariable> vector = dropZone.getVariables();
        Vector<ISpssVariable> vector2 = dropZone2.getVariables();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (ISpssVariable iSpssVariable : vector2) {
            for (ISpssVariable iSpssVariable2 : vector) {
                stringBuffer.append(iSpssVariable2.getName()).append(",").append(iSpssVariable.getName());
                if (++n >= vector.size() * vector2.size()) continue;
                stringBuffer.append(";");
            }
        }
        extensionSpecification.put("YXpairs", stringBuffer.toString());
    }

    public void rebuildVariable(DropZone dropZone) {
        ElementSpecification elementSpecification;
        ISpssVariable iSpssVariable;
        VariableSpecification variableSpecification;
        Object object;
        boolean bl;
        ZoneType zoneType = dropZone.getZoneType();
        boolean bl2 = zoneType.equals((Object)ZoneType.zt_panel_horz) || zoneType.equals((Object)ZoneType.zt_panel_vert) || zoneType.equals((Object)ZoneType.zt_filter);
        boolean bl3 = zoneType.equals((Object)ZoneType.zt_point_id);
        if (bl3) {
            return;
        }
        boolean bl4 = bl = !dropZone.isEmpty();
        if (bl2) {
            if (dropZone.getZoneType() != ZoneType.zt_filter) {
                this.restructure(zoneType, dropZone, true);
            }
            if ((object = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_z)) != null) {
                ((DropZone)object).setBounds(this.mCanvas);
            }
            if (!bl) {
                return;
            }
        }
        Object object2 = object = bl ? dropZone.getVariables() : null;
        if (zoneType == ZoneType.zt_close) {
            this.setCloseZoneVisibility(bl);
        }
        if ((variableSpecification = this.getVarForZone(zoneType)) == null) {
            variableSpecification = this.createNewVariable();
        } else {
            variableSpecification.setSource((DataSpecification)this.getUserSource());
        }
        boolean bl5 = variableSpecification instanceof SourceVariableSpecification;
        if (bl5) {
            ISpssVariable iSpssVariable2;
            boolean bl6 = false;
            if (bl) {
                iSpssVariable = ((Vector)object).iterator();
                while (iSpssVariable.hasNext()) {
                    iSpssVariable2 = (ISpssVariable)iSpssVariable.next();
                    bl6 = !iSpssVariable2.getDisplayMeasurementLevel().equals((Object)MeasurementLevel.scale);
                    variableSpecification.setCategorical(Boolean.valueOf(bl6));
                    variableSpecification.setShortLabel(iSpssVariable2.getName());
                    String string = iSpssVariable2.getLabel().length() > 0 ? iSpssVariable2.getLabel() : iSpssVariable2.getName();
                    variableSpecification.setLabel(string);
                    if (zoneType != ZoneType.zt_x) continue;
                    this.mCanvas.checkForHistogramChange(zoneType);
                }
            } else {
                bl6 = (zoneType != ZoneType.zt_x || !this.isHistogram()) && this.defaultIsCategorical(zoneType);
                variableSpecification.setCategorical(Boolean.valueOf(bl6));
                variableSpecification.setShortLabel(null);
                variableSpecification.setLabel(null);
            }
            this.setVarForZone(zoneType, (SourceVariableSpecification)variableSpecification);
            if (bl6 && dropZone.isDependentVarZone()) {
                if (this.hasErrorBars()) {
                    iSpssVariable = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
                    if (iSpssVariable != null) {
                        this.removeErrorBars(iSpssVariable.getId());
                        iSpssVariable2 = this.getElementExtension((ElementSpecification)iSpssVariable);
                        int n = 0;
                        String string = iSpssVariable2.get("flags");
                        if (string != null && string.length() > 0) {
                            n = Integer.valueOf(string);
                        }
                        iSpssVariable2.put("flags", Integer.toString(n &= 0xFFFFFFEF));
                    }
                } else if (this.isDropLine() && (iSpssVariable = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class)) != null) {
                    this.updateDropLine((PointSpecification)iSpssVariable, false);
                    iSpssVariable2 = this.getElementExtension((ElementSpecification)iSpssVariable);
                    iSpssVariable2.put("dropLine", "0");
                }
            }
        }
        if (variableSpecification.getCategorical().booleanValue() && bl5 && object != null) {
            Iterator iterator = ((Vector)object).iterator();
            while (iterator.hasNext()) {
                iSpssVariable = (ISpssVariable)iterator.next();
                this.setupVarCategories((SourceVariableSpecification)variableSpecification, iSpssVariable, zoneType);
            }
        }
        if (zoneType.equals((Object)ZoneType.zt_x) || zoneType.equals((Object)ZoneType.zt_z)) {
            boolean bl7 = bl && ((ISpssVariable)((Vector)object).get(0)).getDisplayMeasurementLevel() != MeasurementLevel.scale;
            this.setTickLabelVisibility(zoneType, bl7);
        }
        this.updateZoneLabel(zoneType);
        if (this.isPopulationPyramid()) {
            this.updateZoneLabel(ZoneType.zt_y);
        }
        if (bl5) {
            if (variableSpecification.getCategorical().booleanValue()) {
                if (zoneType == ZoneType.zt_y) {
                    DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 1);
                    iSpssVariable = dimensionSpecification.getDomain();
                    if (iSpssVariable != null) {
                        dimensionSpecification.setDomain((DomainSpecification)null);
                        iSpssVariable.getParent().remove((Specification)iSpssVariable);
                    }
                    dimensionSpecification.setUnionDomain(Boolean.valueOf(false));
                }
                if (this.mCoordinates == Coords.coords_Polar) {
                    this.removeDomain((SourceVariableSpecification)variableSpecification);
                } else {
                    this.setupCategoricalDomain((SourceVariableSpecification)variableSpecification);
                }
            } else if (!(this.isDifferenceArea() || this.isDropLine() || this.isHistogram())) {
                this.setupIntervalDomain((SourceVariableSpecification)variableSpecification);
            } else {
                this.removeDomain((SourceVariableSpecification)variableSpecification);
            }
        }
        if (this.isPopulationPyramid() && (elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class)) != null) {
            this.manageNormalCurve(elementSpecification, new ElementStat(null));
        }
    }

    public void updateZoneLabel(ZoneType zoneType) {
        boolean bl;
        boolean bl2;
        if (zoneType == this.mCanvas.getZoneMgr().getIndexVarZoneType()) {
            return;
        }
        boolean bl3 = zoneType == ZoneType.zt_y && this.isPopulationPyramid();
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(zoneType);
        if (!bl3 && dropZone == null) {
            return;
        }
        boolean bl4 = bl2 = dropZone != null && dropZone.isDependentVarZone();
        if (bl2 && this.isDifferenceArea()) {
            return;
        }
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        if (bl2 && this.mCoordinates == Coords.coords_DualY && ((bl = this.dualYElementWithFirstYAxis(elementSpecification.getId())) && zoneType == ZoneType.zt_y2 || !bl && zoneType == ZoneType.zt_y)) {
            elementSpecification = (ElementSpecification)this.getSpecByClass(null, ElementSpecification.class, 1);
        }
        if (elementSpecification == null) {
            return;
        }
        Vector<ISpssVariable> vector = this.getSpssVarsForZone(zoneType);
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        if (vector != null && vector.size() > 0) {
            int n = 1;
            for (ISpssVariable iSpssVariable : vector) {
                if (zoneType != ZoneType.zt_filter && n > 1) continue;
                String string = this.getIdentifierForZoneType(zoneType, n);
                if (string == null) {
                    return;
                }
                String string2 = "";
                if (iSpssVariable != null) {
                    string2 = iSpssVariable.getLabel();
                    if (string2 == null || string2.length() == 0) {
                        string2 = iSpssVariable.getName();
                    }
                } else if (bl3) {
                    string2 = this.mCanvas.getZoneMgr().hasCatVar(ZoneType.zt_dist_var) ? this.mCanvas.getResources().getResString("IDS_LABEL_COUNT") : this.mCanvas.getResources().getResString("IDS_FREQUENCY");
                }
                this.assignLabel(extensionSpecification, string, bl2, elementSpecification, string2);
                ++n;
            }
        } else {
            String string = this.getIdentifierForZoneType(zoneType, -1);
            this.assignLabel(extensionSpecification, string, bl2, elementSpecification, "");
        }
    }

    private void assignLabel(ExtensionSpecification extensionSpecification, String string, boolean bl, ElementSpecification elementSpecification, String string2) {
        String string3;
        ElementStat elementStat = this.getStatistic(elementSpecification);
        if (bl && elementStat.getStat() != Statistics.Value && !this.isSchema()) {
            if (this.isHiLoClose()) {
                string3 = this.buildHiLoCloseAxisLabel();
            } else if (this.hasSSVs()) {
                string3 = this.buildSSVDepAxisLabel();
            } else {
                String string4 = this.getStatLabel(elementStat);
                if (string2.length() > 0) {
                    if (!ComponentState.isBtdRtlOrLtr()) {
                        string3 = string2 != null && string2.length() > 0 && ComponentState.containsBidiLetter((String)string2) && (ComponentState.isBidiLetter((char)string2.charAt(0)) || string2.charAt(0) == '\u05b9') ? Character.toString('\u200e') + string4 + " " + '\u200e' + '\u202b' + string2 + '\u202c' : string4 + " " + string2;
                    } else {
                        String string5 = Character.toString('\u200e') + (ComponentState.getBTD() == 1 ? (char)'\u202b' : '\u202a');
                        string3 = Character.toString('\u200e') + string4 + " " + string5 + string2 + '\u202c';
                    }
                } else {
                    string3 = string4;
                }
            }
        } else if (!ComponentState.isBtdRtlOrLtr() || string2 == null || string2.length() == 0) {
            string3 = string2;
        } else {
            String string6 = Character.toString('\u200e') + (ComponentState.getBTD() == 1 ? (char)'\u202b' : '\u202a');
            string3 = string6 + string2 + '\u202c';
        }
        extensionSpecification.put(string + "_label", string3);
    }

    public void setCycleForZoneType(ZoneType zoneType, boolean bl) {
        boolean bl2 = this.getUsesColorForStyleByType(zoneType);
        if (bl2 != bl) {
            AestheticSpecification[] aestheticSpecificationArray;
            ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
            VariableSpecification variableSpecification = this.getVarSpecForZoneType(zoneType, elementSpecification, aestheticSpecificationArray = elementSpecification.getAestheticSpecifications());
            if (variableSpecification == null) {
                assert (false);
                return;
            }
            AestheticSpecification aestheticSpecification = null;
            for (AestheticSpecification aestheticSpecification2 : aestheticSpecificationArray) {
                if (!variableSpecification.equals(aestheticSpecification2.getVariable())) continue;
                aestheticSpecification = aestheticSpecification2;
                break;
            }
            if (aestheticSpecification != null) {
                this.setupStyleCycle(elementSpecification, (StyleAestheticSpecification)aestheticSpecification, bl);
                this.mStyleCycler.setBaseStyle(this.mCoordinates, elementSpecification, this.getElementType(this.mCoordinates, elementSpecification), bl);
                this.mImage = null;
            }
        }
    }

    public String getViZmlAsString(boolean bl, boolean bl2) {
        String string = "";
        if (!this.isEmpty()) {
            try {
                StringWriter stringWriter = new StringWriter();
                VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification().clone();
                Collection collection = this.mSources != null ? this.mSources : this.mDataReader.getSources();
                if (bl) {
                    new ConvertToEmbeddedAction(collection).modify(visualizationSpecification);
                } else if (bl2) {
                    this.adjustSizeForGallery(visualizationSpecification);
                    this.turnOffTickLabels(visualizationSpecification);
                }
                visualizationSpecification.writeXml((Writer)stringWriter);
                string = stringWriter.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    public void addSSVVariables(ISpssVariable[] iSpssVariableArray) {
        Vector<ElementStat> vector;
        ChartProps chartProps = this.getProperties();
        if (!chartProps.getHasSSVs()) {
            this.removeSSVVariables();
            return;
        }
        Props.ElProps elProps = chartProps.getElementProp(0);
        if (elProps == null) {
            elProps = this.getDefaultDataProp();
            chartProps.addProp(elProps);
        }
        ElementStat elementStat = (vector = elProps.getSSVData().getSSVVariables()).size() > 0 ? vector.get(0) : null;
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            ElementStat elementStat2 = new ElementStat(elProps);
            if (elementStat != null) {
                elementStat2.assign(elementStat);
            } else {
                elementStat2.setStat(Statistics.Mean);
            }
            elementStat2.setVariable(iSpssVariable);
            vector.add(elementStat2);
        }
        elProps.setModified(true);
        this.setProperties(chartProps, true);
    }

    public void removeSSVVariables() {
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = extensionSpecification.get("SSVCount");
        if (string != null && string.length() > 0) {
            extensionSpecification.put("SSVCount", null);
            int n = Integer.valueOf(string);
            for (int i = 0; i < n; ++i) {
                String string2 = String.format("SSVStat_%d", i);
                extensionSpecification.put(string2, null);
                string2 = String.format("SSVParm1_%d", i);
                extensionSpecification.put(string2, null);
                string2 = String.format("SSVParm2_%d", i);
                extensionSpecification.put(string2, null);
                string2 = String.format("SSVVar_%d", i);
                extensionSpecification.put(string2, null);
            }
        }
    }

    public ZoneType getDepZoneType() {
        ZoneType zoneType = this.isHiLoClose() ? ZoneType.zt_high : (this.isPopulationPyramid() ? ZoneType.zt_dist_var : (this.mCoordinates == Coords.coords_Polar ? ZoneType.zt_angle : (this.isDifferenceArea() ? ZoneType.zt_high : ZoneType.zt_y)));
        return zoneType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartPrototype makeGalleryPrototype(String string) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2;
        VizDataProcessor vizDataProcessor = new VizDataProcessor();
        VizDataWriter vizDataWriter = vizDataProcessor.getDataWriter();
        if (this.mSources == null) {
            this.refreshData();
        }
        String string2 = this.getViZmlAsString(false, true);
        try {
            byteBuffer2 = vizDataWriter.writeStreamData(this.mSources);
            byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(string2.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ChartPrototype chartPrototype = null;
            return chartPrototype;
        }
        finally {
            vizDataWriter.releaseAllData();
        }
        ChartPrototype chartPrototype = new ChartPrototype(32768);
        chartPrototype.setIsCustomChart(true);
        chartPrototype.setTitle(string);
        chartPrototype.setXml(byteBuffer);
        chartPrototype.setData(byteBuffer2);
        return chartPrototype;
    }

    public String getProtoTypeTitle() {
        ChartPrototype chartPrototype = this.getPrototype();
        if (chartPrototype != null) {
            this.mPrototypeTitle = chartPrototype.getTitle();
        }
        return this.mPrototypeTitle;
    }

    public String getProtoTypeStr() {
        ChartPrototype chartPrototype = this.getPrototype();
        if (chartPrototype != null) {
            this.mPrototypeStr = this.mChartAppearanceOption.convertType(chartPrototype);
        }
        return this.mPrototypeStr;
    }

    public void serializeIn(DataInputStream dataInputStream) {
        try {
            this.mImage = null;
            this.mSources = null;
            this.mVisualization = null;
            this.mStyleCycler.serializeIn(dataInputStream);
            this.mChartAppearanceOption.serializeIn(dataInputStream);
            this.mPrototypeTitle = dataInputStream.readUTF();
            this.mPrototypeStr = dataInputStream.readUTF();
            this.mCoordinates = Coords.valueOf(dataInputStream.readUTF());
            String string = dataInputStream.readUTF();
            if (string.length() > 0 && this.mCoordinates != Coords.coords_none) {
                VisualizationSpecification visualizationSpecification = new VisualizationSpecification((Reader)new StringReader(string));
                visualizationSpecification.setLocale(ComponentState.getSPSSLocale());
                VisualizationFactory visualizationFactory = VisualizationFactory.getInstance();
                this.mVisualization = visualizationFactory.makeVisualization(visualizationSpecification);
                this.setRenderingHints(this.mVisualization);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean serializeOut(DataOutputStream dataOutputStream) {
        try {
            this.mStyleCycler.serializeOut(dataOutputStream);
            this.mChartAppearanceOption.serializeOut(dataOutputStream);
            dataOutputStream.writeUTF(this.getProtoTypeTitle());
            dataOutputStream.writeUTF(this.getProtoTypeStr());
            dataOutputStream.writeUTF(this.mCoordinates.name());
            String string = this.getViZmlAsString(false, false);
            dataOutputStream.writeUTF(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    boolean isErrorBarElement(ElementSpecification elementSpecification) {
        SummaryBaseType summaryBaseType;
        StatisticSpecification[] statisticSpecificationArray;
        return elementSpecification instanceof IntervalSpecification && (statisticSpecificationArray = elementSpecification.getStatistics()).length >= 1 && statisticSpecificationArray[0] instanceof SummaryStatisticSpecification && (summaryBaseType = ((SummaryStatisticSpecification)statisticSpecificationArray[0]).getBase()) != null && summaryBaseType == SummaryBaseType.COORDINATE;
    }

    public String getRangeElementId() {
        IntervalSpecification intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class);
        if (intervalSpecification != null) {
            return intervalSpecification.getId();
        }
        return "";
    }

    public String getErrorBarsId(String string) {
        ExtensionSpecification extensionSpecification = (ExtensionSpecification)this.getSpecByClassAndAttr(null, ExtensionSpecification.class, RANGE_KEY, string);
        if (extensionSpecification != null) {
            ExpressionVariableSpecification[] expressionVariableSpecificationArray;
            SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)extensionSpecification.getParent();
            for (ExpressionVariableSpecification expressionVariableSpecification : expressionVariableSpecificationArray = (ExpressionVariableSpecification[])sourceVariableSpecification.getTop().findDescendantsOfType(ExpressionVariableSpecification.class)) {
                if (expressionVariableSpecification.getExpression().indexOf(sourceVariableSpecification.getId()) <= -1) continue;
                Specification specification = this.getSpecByClassAndAttr(null, IntervalSpecification.class, "y", expressionVariableSpecification.getId());
                if (specification == null) break;
                return specification.getId();
            }
        }
        return "";
    }

    public boolean isSummaryPointPlot() {
        ElementStat elementStat;
        boolean bl = false;
        ChartProps chartProps = this.getProperties();
        Props.ElProps elProps = chartProps.getElementProp(0);
        if (elProps != null && elProps instanceof Props.PointProps && (elementStat = elProps.getStatistic()).getStat() == Statistics.Mean) {
            bl = true;
        }
        return bl;
    }

    private boolean isSummaryPointChart() {
        PointSpecification[] pointSpecificationArray;
        boolean bl = false;
        VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
        block0: for (PointSpecification pointSpecification : pointSpecificationArray = (PointSpecification[])visualizationSpecification.findDescendantsOfType(PointSpecification.class)) {
            StatisticSpecification[] statisticSpecificationArray;
            for (StatisticSpecification statisticSpecification : statisticSpecificationArray = pointSpecification.getStatistics()) {
                if (!(statisticSpecification instanceof SummaryStatisticSpecification) || ((SummaryStatisticSpecification)statisticSpecification).getMethod() != SummaryType.MEAN) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public StyleCycler getStyleCycler() {
        return this.mStyleCycler;
    }

    public ChartAppearanceOption getChartAppearanceOption() {
        return this.mChartAppearanceOption;
    }

    private String getStatLabel(ElementStat elementStat) {
        String string = elementStat.getStat().getStatLabel(this.mCanvas.getResources(), elementStat);
        return string;
    }

    private String buildSSVDepAxisLabel() {
        String string = "";
        boolean bl = true;
        boolean bl2 = true;
        ElementStat elementStat = null;
        ISpssVariable iSpssVariable = null;
        Props.SSVData sSVData = this.getSSVData();
        for (ElementStat elementStat2 : sSVData.getSSVVariables()) {
            if (iSpssVariable == null) {
                iSpssVariable = elementStat2.getVariable();
                elementStat = elementStat2;
            } else {
                bl = iSpssVariable.getName().equals(elementStat2.getVariable().getName());
                boolean bl3 = bl2 = elementStat.getStat() == elementStat2.getStat() && elementStat.getStrParm1().equals(elementStat2.getStrParm1()) && elementStat.getStrParm2().equals(elementStat2.getStrParm2());
            }
            if (bl || bl2) continue;
            break;
        }
        if (elementStat != null) {
            if (bl2) {
                string = elementStat.getStat().getStatLabel(this.mCanvas.getResources(), elementStat);
            } else if (bl) {
                string = elementStat.getVarLabel();
            }
        }
        return string;
    }

    private String buildHiLoCloseAxisLabel() {
        String string;
        boolean bl;
        String string2;
        String string3;
        String string4;
        PointSpecification pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class);
        if (pointSpecification == null) {
            return "";
        }
        Props.HiLoCloseProps hiLoCloseProps = new Props.HiLoCloseProps();
        this.getHiLoCloseProps((ElementSpecification)pointSpecification, hiLoCloseProps);
        String string5 = this.getStatLabel(hiLoCloseProps.getLowStat());
        String string6 = this.getStatLabel(hiLoCloseProps.getHighStat());
        String string7 = this.getStatLabel(hiLoCloseProps.getCloseStat());
        ISpssVariable iSpssVariable = hiLoCloseProps.getLowStat().getVariable();
        if (iSpssVariable != null) {
            string4 = iSpssVariable.getLabel();
            if (string4 == null || string4.length() == 0) {
                string4 = iSpssVariable.getName();
            }
        } else {
            string4 = "";
        }
        if ((iSpssVariable = hiLoCloseProps.getHighStat().getVariable()) != null) {
            string3 = iSpssVariable.getLabel();
            if (string3 == null || string3.length() == 0) {
                string3 = iSpssVariable.getName();
            }
        } else {
            string3 = "";
        }
        if ((iSpssVariable = hiLoCloseProps.getCloseStat().getVariable()) != null) {
            string2 = iSpssVariable.getLabel();
            if (string2 == null || string2.length() == 0) {
                string2 = iSpssVariable.getName();
            }
        } else {
            string2 = "";
        }
        boolean bl2 = string5.equals(string6);
        boolean bl3 = bl = string4.length() > 0 && string4.equals(string3);
        if (string2.length() > 0) {
            bl2 &= string6.equals(string6);
            bl &= string3.equals(string2);
        }
        if (bl) {
            string = string4;
        } else if (bl2) {
            string = string5;
        } else {
            String string8 = String.format("%s(%s), %s(%s)", string6, string3, string5, string4);
            if (string2.length() > 0) {
                string8 = string8 + ", " + string7 + "(" + string2 + ")";
            }
            string = string8;
        }
        return string;
    }

    private void handleGroupingForCoordChange(Coords coords) {
        boolean bl = this.hasXCluster();
        boolean bl2 = this.hasZCluster();
        boolean bl3 = this.hasGrouping();
        boolean bl4 = bl && !this.mCanvas.getZoneMgr().getZone(ZoneType.zt_cluster_x).getUsesColorStyling();
        boolean bl5 = bl2 && !this.mCanvas.getZoneMgr().getZone(ZoneType.zt_cluster_z).getUsesColorStyling();
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (coords == Coords.coords_2D) {
            if (bl && bl2) {
                if (bl4) {
                    bl6 = true;
                } else {
                    bl7 = true;
                }
            } else if (bl && bl3) {
                if (bl4) {
                    bl6 = true;
                } else {
                    bl8 = true;
                }
            } else if (bl2 && bl3) {
                if (bl5) {
                    bl7 = true;
                } else {
                    bl8 = true;
                }
            }
        }
        if (coords == Coords.coords_1D) {
            if (bl) {
                bl6 = true;
            }
            if (bl2) {
                bl7 = true;
            }
        }
        if (bl7) {
            this.zoneChange(this.mCanvas.getZoneMgr(), ZoneType.zt_cluster_z, ZoneChangeType.removeZone);
        }
        if (bl6) {
            this.zoneChange(this.mCanvas.getZoneMgr(), ZoneType.zt_cluster_x, ZoneChangeType.removeZone);
        }
        if (bl8) {
            this.zoneChange(this.mCanvas.getZoneMgr(), ZoneType.zt_group, ZoneChangeType.removeZone);
        }
    }

    private ElementStat getStatistic(ElementSpecification elementSpecification) {
        Props.BarProps barProps = new Props.BarProps();
        this.getStatistics(elementSpecification, barProps.getStatistic());
        return barProps.getStatistic();
    }

    private void takeOutErrorBars(Props.ElProps elProps) {
        if ((elProps.getFlags() & 0x10) != 0) {
            String string = elProps.getStrElId();
            this.removeErrorBars(string);
            elProps.setFlags(elProps.getFlags() & 0xFFFFFFEF);
        }
    }

    private void removeErrorBars(String string) {
        ExtensionSpecification extensionSpecification = (ExtensionSpecification)this.getSpecByClassAndAttr(null, ExtensionSpecification.class, "main_element", string);
        if (extensionSpecification != null) {
            IntervalSpecification intervalSpecification = (IntervalSpecification)extensionSpecification.getParent();
            intervalSpecification.getParent().remove((Specification)intervalSpecification);
        } else {
            IntervalSpecification[] intervalSpecificationArray;
            for (IntervalSpecification intervalSpecification : intervalSpecificationArray = (IntervalSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(IntervalSpecification.class)) {
                StatisticSpecification[] statisticSpecificationArray = intervalSpecification.getStatistics();
                if (statisticSpecificationArray.length <= 0 || !(statisticSpecificationArray[0] instanceof SummaryStatisticSpecification)) continue;
                boolean bl = ((SummaryStatisticSpecification)statisticSpecificationArray[0]).getMethod() == SummaryType.RANGE;
                boolean bl2 = ((SummaryStatisticSpecification)statisticSpecificationArray[0]).getBase() == SummaryBaseType.COORDINATE;
                VariableSpecification variableSpecification = intervalSpecification.getY();
                if (!bl || !bl2 || !(variableSpecification instanceof ExpressionVariableSpecification)) continue;
                intervalSpecification.getParent().remove((Specification)intervalSpecification);
                break;
            }
        }
    }

    private void turnOffTickLabels(VisualizationSpecification visualizationSpecification) {
        DimensionSpecification dimensionSpecification = ((DimensionSpecification[])visualizationSpecification.findDescendantsOfType(DimensionSpecification.class))[0];
        if (dimensionSpecification == null || dimensionSpecification.getAxisSpecifications().length == 0) {
            return;
        }
        AxisSpecification axisSpecification = dimensionSpecification.getAxisSpecifications()[0];
        MajorTicksSpecification majorTicksSpecification = axisSpecification.getMajorTickChild();
        if (majorTicksSpecification == null) {
            return;
        }
        TextStyle textStyle = majorTicksSpecification.getStyle();
        if (textStyle == null) {
            textStyle = new StyleSpecification();
            majorTicksSpecification.setStyle(textStyle);
            this.addVizStyle((StyleSpecification)textStyle);
        }
        textStyle.setVisible(Boolean.valueOf(false));
    }

    private void adjustSizeForGallery(VisualizationSpecification visualizationSpecification) {
        ObliqueCoordinateSpecification obliqueCoordinateSpecification;
        ObliqueCoordinateSpecification obliqueCoordinateSpecification2 = obliqueCoordinateSpecification = (ObliqueCoordinateSpecification)visualizationSpecification.findDescendantsOfType(LocationSpecification.class);
        int n = ((LocationSpecification[])obliqueCoordinateSpecification2).length;
        for (int i = 0; i < n; ++i) {
            LocationSpecification locationSpecification = obliqueCoordinateSpecification2[i];
            if (locationSpecification.getPart() == LocationPartType.RIGHT || locationSpecification.getPart() == LocationPartType.WIDTH) {
                locationSpecification.setFixedValue(new Length("62px"));
                continue;
            }
            if (locationSpecification.getPart() != LocationPartType.BOTTOM && locationSpecification.getPart() != LocationPartType.HEIGHT) continue;
            locationSpecification.setFixedValue(new Length("60px"));
        }
        if (this.mCoordinates.equals((Object)Coords.coords_3D) && (obliqueCoordinateSpecification2 = (ObliqueCoordinateSpecification)this.getFirstSpecByClass((Specification)visualizationSpecification, ObliqueCoordinateSpecification.class)) != null) {
            obliqueCoordinateSpecification2.setDx(Double.valueOf(0.0));
            obliqueCoordinateSpecification2.setDy(Double.valueOf(-0.05));
        }
        visualizationSpecification.fireSpecificationChangedEvent(new SpecificationChangeEvent((Object)this, "redraw chart"));
    }

    protected void useData(Visualization visualization, boolean bl) {
        if (this.mSources != null) {
            if (bl) {
                for (VizDataSource vizDataSource : this.mSources) {
                    visualization.addUserSource((Source)vizDataSource);
                }
            } else {
                this.mDataReader.releaseAllData();
            }
        } else {
            super.useData(visualization, bl);
        }
    }

    private void validateElements(Coords coords) {
        ElementSpecification[] elementSpecificationArray;
        ElementSpecification[] elementSpecificationArray2;
        int n = 0;
        GraphSpecification graphSpecification = this.getGraphSpec();
        for (ElementSpecification elementSpecification : elementSpecificationArray2 = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
            if (!this.isValidElementForCoords(elementSpecification, coords)) {
                elementSpecification.getParent().remove((Specification)elementSpecification);
                continue;
            }
            if (!this.isErrorBarElement(elementSpecification)) {
                ++n;
            }
            if (n <= 1) continue;
            elementSpecification.getParent().remove((Specification)elementSpecification);
        }
        elementSpecificationArray2 = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class);
        if (elementSpecificationArray2.length == 0) {
            elementSpecificationArray = new LineSpecification();
            graphSpecification.addElement((ElementSpecification)elementSpecificationArray);
            StyleSpecification styleSpecification = new StyleSpecification();
            styleSpecification.setVisible(Boolean.valueOf(false));
            elementSpecificationArray.setStyle(styleSpecification);
            this.addVizStyle(styleSpecification);
        }
        for (ElementSpecification elementSpecification : elementSpecificationArray2 = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
            if ((coords == Coords.coords_1D || coords == Coords.coords_2D || coords == Coords.coords_DualY || coords == Coords.coords_3D || coords == Coords.coords_Polar) && elementSpecification.getX() == null) {
                elementSpecificationArray = this.createNewVariable();
                elementSpecificationArray.setCategorical(Boolean.valueOf(coords != Coords.coords_Polar));
                elementSpecification.setX((VariableSpecification)elementSpecificationArray);
            }
            if ((coords == Coords.coords_2D || coords == Coords.coords_DualY || coords == Coords.coords_3D) && elementSpecification.getY() == null) {
                elementSpecificationArray = this.createNewVariable();
                elementSpecificationArray.setCategorical(Boolean.valueOf(false));
                elementSpecification.setY((VariableSpecification)elementSpecificationArray);
            }
            if (coords != Coords.coords_3D || elementSpecification.getZ() != null) continue;
            elementSpecificationArray = this.createNewVariable();
            elementSpecificationArray.setCategorical(Boolean.valueOf(true));
            elementSpecification.setZ((VariableSpecification)elementSpecificationArray);
        }
    }

    private boolean isValidElementForCoords(ElementSpecification elementSpecification, Coords coords) {
        if (elementSpecification instanceof IntervalSpecification) {
            if (this.isHiLoClose()) {
                return coords == Coords.coords_2D;
            }
            return coords != Coords.coords_1D;
        }
        if (elementSpecification instanceof LineSpecification) {
            return this.isElementHidden(elementSpecification) || coords == Coords.coords_2D || coords == Coords.coords_DualY;
        }
        if (elementSpecification instanceof PointSpecification) {
            if (this.isHiLoClose()) {
                return coords == Coords.coords_2D;
            }
            return coords != Coords.coords_Polar;
        }
        if (elementSpecification instanceof AreaSpecification) {
            if (this.isDifferenceArea()) {
                return coords == Coords.coords_2D;
            }
            return coords == Coords.coords_2D || coords == Coords.coords_DualY;
        }
        if (elementSpecification instanceof SchemaSpecification) {
            return coords == Coords.coords_1D || coords == Coords.coords_2D;
        }
        return false;
    }

    private void adjustDotPlotDimension(Coords coords, boolean bl, boolean bl2) {
        CoordinatesSpecification coordinatesSpecification = (CoordinatesSpecification)this.getFirstSpecByClass(null, CoordinatesSpecification.class);
        PointSpecification pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class);
        if (bl) {
            DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 1);
            if (dimensionSpecification != null && dimensionSpecification.getAxisSpecifications().length == 0) {
                AxisSpecification axisSpecification = new AxisSpecification(true);
                dimensionSpecification.addAxis(axisSpecification);
                this.setTickLabelVisibility(ZoneType.zt_y, false);
            }
            if (coords == Coords.coords_3D && this.getSpecByClass(null, DimensionSpecification.class, 2) == null) {
                dimensionSpecification = new DimensionSpecification(true);
                coordinatesSpecification.addDimension(dimensionSpecification);
                this.setTickLabelVisibility(ZoneType.zt_z, false);
            }
            pointSpecification.setPositionModifier(null);
        } else if (bl2) {
            pointSpecification.setPositionModifier(PositionModifierType.PILE);
        }
    }

    private void takeoutSplomElements() {
        ExpressionVariableSpecification[] expressionVariableSpecificationArray;
        ExpressionVariableSpecification[] expressionVariableSpecificationArray2;
        PointSpecification pointSpecification;
        FacetLayoutSpecification facetLayoutSpecification = (FacetLayoutSpecification)this.getFirstSpecByClass(null, FacetLayoutSpecification.class);
        if (facetLayoutSpecification != null) {
            facetLayoutSpecification.getParent().remove((Specification)facetLayoutSpecification);
        }
        if ((pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class)) != null) {
            expressionVariableSpecificationArray2 = (ExpressionVariableSpecification[])this.getFirstSpecByClass((Specification)pointSpecification, ConditionalStyleSpecification.class);
            if (expressionVariableSpecificationArray2 != null) {
                expressionVariableSpecificationArray2.getParent().remove((Specification)expressionVariableSpecificationArray2);
            }
            if ((expressionVariableSpecificationArray = pointSpecification.getX()) instanceof ExpressionVariableSpecification) {
                expressionVariableSpecificationArray = this.createNewVariable();
                expressionVariableSpecificationArray.setCategorical(Boolean.valueOf(true));
                this.setupVarCategories((SourceVariableSpecification)expressionVariableSpecificationArray, null, ZoneType.zt_x);
                pointSpecification.setX((VariableSpecification)expressionVariableSpecificationArray);
            }
            if ((expressionVariableSpecificationArray = pointSpecification.getY()) instanceof ExpressionVariableSpecification) {
                expressionVariableSpecificationArray = this.createNewVariable();
                expressionVariableSpecificationArray.setCategorical(Boolean.valueOf(false));
                pointSpecification.setY((VariableSpecification)expressionVariableSpecificationArray);
            }
        }
        expressionVariableSpecificationArray = expressionVariableSpecificationArray2 = (ExpressionVariableSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(DerivedVariableSpecification.class);
        int n = expressionVariableSpecificationArray.length;
        for (int i = 0; i < n; ++i) {
            VariableSpecification variableSpecification = expressionVariableSpecificationArray[i];
            variableSpecification.getParent().remove((Specification)variableSpecification);
        }
        for (ExpressionVariableSpecification expressionVariableSpecification : expressionVariableSpecificationArray = (ExpressionVariableSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ExpressionVariableSpecification.class)) {
            expressionVariableSpecification.getParent().remove((Specification)expressionVariableSpecification);
        }
    }

    private void takeoutPyramidElements() {
        IntervalSpecification intervalSpecification;
        DimensionSpecification dimensionSpecification;
        TransposeCoordinateSpecification transposeCoordinateSpecification;
        ReflectionCoordinateSpecification reflectionCoordinateSpecification;
        FacetingSpecification facetingSpecification;
        FacetLayoutSpecification facetLayoutSpecification = (FacetLayoutSpecification)this.getFirstSpecByClass(null, FacetLayoutSpecification.class);
        if (facetLayoutSpecification != null) {
            facetLayoutSpecification.getParent().remove((Specification)facetLayoutSpecification);
        }
        if ((facetingSpecification = (FacetingSpecification)this.getFirstSpecByClass(null, FacetingSpecification.class)) != null) {
            facetingSpecification.getParent().remove((Specification)facetingSpecification);
        }
        if ((reflectionCoordinateSpecification = (ReflectionCoordinateSpecification)this.getFirstSpecByClass(null, ReflectionCoordinateSpecification.class)) != null) {
            reflectionCoordinateSpecification.getParent().remove((Specification)reflectionCoordinateSpecification);
        }
        if ((transposeCoordinateSpecification = (TransposeCoordinateSpecification)this.getFirstSpecByClass(null, TransposeCoordinateSpecification.class)) != null) {
            transposeCoordinateSpecification.getParent().remove((Specification)transposeCoordinateSpecification);
        }
        if ((dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 0)) != null) {
            intervalSpecification = dimensionSpecification.getAxisSpecifications();
            for (int i = 1; i < ((IntervalSpecification)intervalSpecification).length; ++i) {
                intervalSpecification[i].getParent().remove((Specification)intervalSpecification[i]);
            }
        }
        if ((intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class)) != null) {
            ColorAestheticSpecification colorAestheticSpecification;
            BinStatisticSpecification binStatisticSpecification = (BinStatisticSpecification)this.getFirstSpecByClass((Specification)intervalSpecification, BinStatisticSpecification.class);
            if (binStatisticSpecification != null) {
                binStatisticSpecification.getParent().remove((Specification)binStatisticSpecification);
            }
            if ((colorAestheticSpecification = (ColorAestheticSpecification)this.getFirstSpecByClass((Specification)intervalSpecification, ColorAestheticSpecification.class)) != null) {
                colorAestheticSpecification.getParent().remove((Specification)colorAestheticSpecification);
            }
        }
        this.makeXScale(false);
    }

    private void handlePolarChanges(Coords coords) {
        if (this.mCoordinates.equals((Object)Coords.coords_Polar)) {
            this.removePolarTransforms();
            this.makeXScale(false);
            this.adjustGrouping(false);
            this.adjustDimensionMapping(false);
            this.removeAesthetics();
            this.setIntervalWidths(true);
            this.managePolarSummaryStatistic(false);
        } else if (coords.equals((Object)Coords.coords_Polar)) {
            this.addPolarTransforms();
            this.adjustXCluster(false);
            this.adjustZCluster(false);
            this.adjustGrouping(true);
            this.removeStatistics();
            this.makeXScale(true);
            this.adjustDimensionMapping(true);
            this.setIntervalWidths(false);
            this.setTickLabelVisibility(ZoneType.zt_x, false);
            this.managePolarSummaryStatistic(true);
        }
    }

    private void managePolarSummaryStatistic(boolean bl) {
        IntervalSpecification intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class);
        if (intervalSpecification != null) {
            StatisticSpecification[] statisticSpecificationArray;
            SummaryStatisticSpecification summaryStatisticSpecification = null;
            for (StatisticSpecification statisticSpecification : statisticSpecificationArray = intervalSpecification.getStatistics()) {
                SummaryStatisticSpecification summaryStatisticSpecification2;
                if (!(statisticSpecification instanceof SummaryStatisticSpecification) || (summaryStatisticSpecification2 = (SummaryStatisticSpecification)statisticSpecification).getMethod() != SummaryType.PERCENT) continue;
                summaryStatisticSpecification = summaryStatisticSpecification2;
                break;
            }
            if (bl && summaryStatisticSpecification == null) {
                summaryStatisticSpecification = new SummaryStatisticSpecification(SummaryType.PERCENT);
                intervalSpecification.addStatistic((StatisticSpecification)summaryStatisticSpecification);
            } else if (!bl && summaryStatisticSpecification != null) {
                summaryStatisticSpecification.getParent().remove((Specification)summaryStatisticSpecification);
            }
        }
    }

    private void removeStatistics() {
        IntervalSpecification intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class);
        if (intervalSpecification != null) {
            StatisticSpecification[] statisticSpecificationArray;
            for (StatisticSpecification statisticSpecification : statisticSpecificationArray = intervalSpecification.getStatistics()) {
                statisticSpecification.getParent().remove((Specification)statisticSpecification);
            }
        }
    }

    private void setIntervalWidths(boolean bl) {
        IntervalSpecification intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class);
        if (intervalSpecification != null) {
            StyleSpecification styleSpecification = intervalSpecification.getStyle("");
            if (!bl) {
                styleSpecification.setDepth(null);
                styleSpecification.setWidth(new Length("100%"));
                styleSpecification.setSymbol(null);
            } else {
                styleSpecification.setDepth(new Length("75%"));
                if (this.hasXCluster()) {
                    styleSpecification.setWidth(new Length("100%"));
                } else {
                    styleSpecification.setWidth(new Length("75%"));
                }
            }
            styleSpecification.setSize(null);
        }
    }

    private void handleSchemaChanges(Coords coords) {
        if (coords == Coords.coords_1D) {
            this.adjustXCluster(false);
        }
    }

    private void handleDualYChanges(Coords coords) {
        LineStyle lineStyle;
        LineStyle lineStyle2;
        boolean bl = this.mCoordinates.equals((Object)Coords.coords_DualY);
        boolean bl2 = coords.equals((Object)Coords.coords_DualY);
        if (!bl && !bl2) {
            return;
        }
        DimensionSpecification[] dimensionSpecificationArray = (DimensionSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(DimensionSpecification.class);
        if (dimensionSpecificationArray.length > 1) {
            LineStyle lineStyle3;
            lineStyle2 = dimensionSpecificationArray[1];
            lineStyle = lineStyle2.getAxisSpecifications();
            if (bl) {
                if (((AxisSpecification[])lineStyle).length > 1) {
                    lineStyle[1].getParent().remove((Specification)lineStyle[1]);
                }
                if ((lineStyle3 = lineStyle[0].getStyle()) == null) {
                    lineStyle3 = new StyleSpecification();
                    lineStyle[0].setStyle(lineStyle3);
                    this.addVizStyle((StyleSpecification)lineStyle3);
                }
                lineStyle3.setColor(Color.black);
            } else if (((AxisSpecification[])lineStyle).length == 1) {
                lineStyle3 = new AxisSpecification(true);
                lineStyle3.setOpposite(Boolean.valueOf(true));
                StyleSpecification styleSpecification = new StyleSpecification();
                this.addVizStyle(styleSpecification);
                styleSpecification.setColor(this.mStyleCycler.getDualYAxisColor(1));
                styleSpecification.setStrokeWidth(new Length(1.0f, UnitType.PT));
                lineStyle3.setStyle((LineStyle)styleSpecification);
                lineStyle2.addAxis((AxisSpecification)lineStyle3);
                AxisSpecification axisSpecification = lineStyle3.getMajorTickChild();
                LineStyle lineStyle4 = axisSpecification.getStyle();
                if (lineStyle4 == null) {
                    lineStyle4 = new StyleSpecification();
                    axisSpecification.setStyle((TextStyle)lineStyle4);
                    this.addVizStyle((StyleSpecification)lineStyle4);
                }
                lineStyle4.setVisible(Boolean.valueOf(false));
                LineStyle lineStyle5 = lineStyle[0].getStyle();
                if (lineStyle5 == null) {
                    lineStyle5 = new StyleSpecification();
                    lineStyle[0].setStyle(lineStyle5);
                    this.addVizStyle((StyleSpecification)lineStyle5);
                }
                lineStyle5.setColor(this.mStyleCycler.getDualYAxisColor(0));
                lineStyle5.setStrokeWidth(new Length(1.0f, UnitType.PT));
            }
        }
        if (bl2) {
            this.adjustXCluster(false);
            for (LineStyle lineStyle4 : lineStyle2 = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
                for (AxisSpecification axisSpecification : lineStyle = lineStyle4.getAestheticSpecifications()) {
                    axisSpecification.getParent().remove((Specification)axisSpecification);
                }
            }
        }
        for (AxisSpecification axisSpecification : lineStyle2 = (LineStyle)this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
            this.mStyleCycler.setBaseStyle(coords, (ElementSpecification)axisSpecification, this.getElementType(coords, (ElementSpecification)axisSpecification), this.mStyleCycler.getUseColors());
        }
    }

    private void handle3DChanges(Coords coords) {
        GraphSpecification graphSpecification = this.getGraphSpec();
        if (this.mCoordinates.equals((Object)Coords.coords_3D)) {
            GuideSpecification[] guideSpecificationArray;
            ObliqueCoordinateSpecification obliqueCoordinateSpecification = (ObliqueCoordinateSpecification)this.getFirstSpecByClass((Specification)graphSpecification, ObliqueCoordinateSpecification.class);
            if (obliqueCoordinateSpecification != null) {
                obliqueCoordinateSpecification.getParent().remove((Specification)obliqueCoordinateSpecification);
            }
            for (GuideSpecification guideSpecification : guideSpecificationArray = graphSpecification.getGuideSpecifications()) {
                guideSpecification.getParent().remove((Specification)guideSpecification);
            }
        } else if (coords.equals((Object)Coords.coords_3D)) {
            CoordinatesSpecification coordinatesSpecification = (CoordinatesSpecification)this.getFirstSpecByClass((Specification)graphSpecification, CoordinatesSpecification.class);
            ObliqueCoordinateSpecification obliqueCoordinateSpecification = new ObliqueCoordinateSpecification();
            obliqueCoordinateSpecification.setDx(Double.valueOf(-0.15));
            obliqueCoordinateSpecification.setDy(null);
            obliqueCoordinateSpecification.setDistance(Double.valueOf(1.4));
            coordinatesSpecification.addCoordinateTransform((CoordinateTransformSpecification)obliqueCoordinateSpecification);
            PlaneGuideSpecification[] planeGuideSpecificationArray = (PlaneGuideSpecification[])graphSpecification.findDescendantsOfType(PlaneGuideSpecification.class);
            if (planeGuideSpecificationArray.length == 0) {
                int n = 0;
                DimensionType[] dimensionTypeArray = new DimensionType[]{DimensionType.X, DimensionType.Y, DimensionType.Z};
                planeGuideSpecificationArray = new PlaneGuideSpecification[3];
                for (DimensionType dimensionType : dimensionTypeArray) {
                    planeGuideSpecificationArray[n] = new PlaneGuideSpecification(dimensionType);
                    graphSpecification.addGuide((GuideSpecification)planeGuideSpecificationArray[n++]);
                }
            }
            for (PlaneGuideSpecification planeGuideSpecification : planeGuideSpecificationArray) {
                FillStyle fillStyle = planeGuideSpecification.getStyle();
                if (fillStyle == null) {
                    fillStyle = new StyleSpecification();
                    planeGuideSpecification.setStyle(fillStyle);
                    this.addVizStyle((StyleSpecification)fillStyle);
                }
                fillStyle.setColor(Color.lightGray);
            }
            PlaneGuideSpecification[] planeGuideSpecificationArray2 = (PlaneGuideSpecification[])this.getSpecByClass((Specification)graphSpecification, DimensionSpecification.class, 2);
            if (planeGuideSpecificationArray2 != null) {
                AxisSpecification axisSpecification = planeGuideSpecificationArray2.getAxisSpecifications()[0];
                axisSpecification.setOpposite(Boolean.valueOf(false));
                this.setTickLabelVisibility(ZoneType.zt_z, false);
            }
        }
    }

    private void setupBaseChart() {
        try {
            SourceVariableSpecification sourceVariableSpecification;
            UserSourceSpecification userSourceSpecification = new UserSourceSpecification("source0");
            Template template = TemplateFactory.getStandardInstance().getTemplate("line");
            VisualizationFactory visualizationFactory = template.getRequiredVariables();
            HashMap<String, SourceVariableSpecification> hashMap = new HashMap<String, SourceVariableSpecification>();
            int n = 0;
            for (VisualizationFactory visualizationFactory2 : visualizationFactory) {
                sourceVariableSpecification = new SourceVariableSpecification();
                sourceVariableSpecification.setSource((DataSpecification)userSourceSpecification);
                sourceVariableSpecification.setCategorical(Boolean.valueOf(n++ == 0));
                hashMap.put(visualizationFactory2.getId(), sourceVariableSpecification);
            }
            VisualizationFactory visualizationFactory3 = VisualizationFactory.getInstance();
            this.mVisualization = visualizationFactory3.makeVisualization(template, (DataSpecification)userSourceSpecification, hashMap);
            this.setRenderingHints(this.mVisualization);
            this.mCoordinates = Coords.coords_2D;
            for (Map.Entry entry : hashMap.entrySet()) {
                sourceVariableSpecification = (SourceVariableSpecification)entry.getValue();
                if (sourceVariableSpecification.getCategorical().booleanValue()) {
                    this.setupVarCategories(sourceVariableSpecification, null, ZoneType.zt_x);
                    this.setupCategoricalDomain(sourceVariableSpecification);
                    continue;
                }
                this.setupIntervalDomain(sourceVariableSpecification);
            }
            LineSpecification lineSpecification = (LineSpecification)this.getFirstSpecByClass(null, LineSpecification.class);
            StyleSpecification styleSpecification = new StyleSpecification();
            this.addVizStyle(styleSpecification);
            styleSpecification.setVisible(Boolean.valueOf(false));
            lineSpecification.setStyle((LineStyle)styleSpecification);
            this.setTickLabelVisibility(ZoneType.zt_x, false);
            this.setTickLabelVisibility(ZoneType.zt_y, false);
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
    }

    private void setupHiLoClose(IntervalSpecification intervalSpecification) {
        GraphSpecification graphSpecification = this.getGraphSpec();
        intervalSpecification.addStatistic((StatisticSpecification)new SummaryStatisticSpecification(SummaryType.RANGE));
        PointSpecification pointSpecification = new PointSpecification();
        pointSpecification.setX(intervalSpecification.getX());
        pointSpecification.setY(intervalSpecification.getY());
        pointSpecification.getY().setDomain(null);
        StyleSpecification styleSpecification = new StyleSpecification();
        this.addVizStyle(styleSpecification);
        pointSpecification.setStyle(styleSpecification);
        styleSpecification.setSize(new Length("6pt"));
        styleSpecification.setColor(new Color(0, 128, 0, 0), true);
        styleSpecification.setSecondaryColor(Color.black);
        styleSpecification.setSymbol(SymbolType.CIRCLE);
        styleSpecification.setVisible(Boolean.valueOf(false));
        graphSpecification.addElement((ElementSpecification)pointSpecification);
        SourceVariableSpecification sourceVariableSpecification = this.createNewVariable();
        sourceVariableSpecification.setCategorical(Boolean.valueOf(false));
        ExtensionSpecification extensionSpecification = this.getVariableExtension((VariableSpecification)sourceVariableSpecification);
        extensionSpecification.put(RANGE_KEY, pointSpecification.getId());
        extensionSpecification.put(LOW_RANGE_KEY, "low");
        SourceVariableSpecification sourceVariableSpecification2 = this.createNewVariable();
        sourceVariableSpecification2.setCategorical(Boolean.valueOf(false));
        extensionSpecification = this.getVariableExtension((VariableSpecification)sourceVariableSpecification2);
        extensionSpecification.put(RANGE_KEY, pointSpecification.getId());
        extensionSpecification.put(HIGH_RANGE_KEY, "high");
        String string = sourceVariableSpecification.getId() + " + " + sourceVariableSpecification2.getId();
        ExpressionVariableSpecification expressionVariableSpecification = new ExpressionVariableSpecification(string, Boolean.valueOf(false));
        this.mVisualization.getSpecification().addVariable((VariableSpecification)expressionVariableSpecification);
        intervalSpecification.setY((VariableSpecification)expressionVariableSpecification);
        IntervalDomainSpecification intervalDomainSpecification = new IntervalDomainSpecification(0.0, 21.0);
        this.mVisualization.getSpecification().addDomain((DomainSpecification)intervalDomainSpecification);
        DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 1);
        dimensionSpecification.setDomain((DomainSpecification)intervalDomainSpecification);
        dimensionSpecification.setUnionDomain(Boolean.valueOf(true));
    }

    private void setupDifferenceArea(AreaSpecification areaSpecification) {
        SourceVariableSpecification sourceVariableSpecification = this.createNewVariable();
        sourceVariableSpecification.setCategorical(Boolean.valueOf(true));
        ExtensionSpecification extensionSpecification = this.getVariableExtension((VariableSpecification)sourceVariableSpecification);
        extensionSpecification.put(DIFF_AREA_KEY, "true");
        boolean bl = this.mStyleCycler.getUseColors();
        this.setupDiffAreaAesthetic(areaSpecification, sourceVariableSpecification, bl);
        this.setupVarCategories(sourceVariableSpecification, null, ZoneType.zt_group);
        this.removeDomain((SourceVariableSpecification)areaSpecification.getY());
        this.mStyleCycler.setCycleForElement((ElementSpecification)areaSpecification, this.mStyleCycler.getUseColors(), 0);
        IntervalDomainSpecification intervalDomainSpecification = new IntervalDomainSpecification(0.0, 21.0);
        this.mVisualization.getSpecification().addDomain((DomainSpecification)intervalDomainSpecification);
        DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 1);
        dimensionSpecification.setDomain((DomainSpecification)intervalDomainSpecification);
        dimensionSpecification.setUnionDomain(Boolean.valueOf(true));
    }

    private void setupDiffAreaAesthetic(AreaSpecification areaSpecification, SourceVariableSpecification sourceVariableSpecification, boolean bl) {
        if (bl) {
            ColorAestheticSpecification colorAestheticSpecification = new ColorAestheticSpecification();
            colorAestheticSpecification.setVariable((VariableSpecification)sourceVariableSpecification);
            colorAestheticSpecification.setAffect(ColorAffectType.MAIN);
            areaSpecification.addAesthetic((AestheticSpecification)colorAestheticSpecification);
        } else {
            PatternAestheticSpecification patternAestheticSpecification = new PatternAestheticSpecification();
            patternAestheticSpecification.setVariable((VariableSpecification)sourceVariableSpecification);
            patternAestheticSpecification.setClamp(Boolean.valueOf(true));
            areaSpecification.addAesthetic((AestheticSpecification)patternAestheticSpecification);
        }
    }

    private void setupSplom(PointSpecification pointSpecification) {
        FacetLevelSpecification[] facetLevelSpecificationArray;
        pointSpecification.setDotAll(Boolean.valueOf(true));
        StyleSpecification styleSpecification = new StyleSpecification();
        styleSpecification.setVisible(Boolean.valueOf(false));
        pointSpecification.getTop().addStyle(styleSpecification);
        ConditionalStyleSpecification conditionalStyleSpecification = new ConditionalStyleSpecification(styleSpecification, "facet1==facet2");
        pointSpecification.addFacetStyle(conditionalStyleSpecification);
        SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)pointSpecification.getX();
        sourceVariableSpecification.setCategorical(Boolean.valueOf(false));
        SourceVariableSpecification sourceVariableSpecification2 = (SourceVariableSpecification)pointSpecification.getY();
        sourceVariableSpecification2.setCategorical(Boolean.valueOf(false));
        DerivedVariableSpecification derivedVariableSpecification = new DerivedVariableSpecification(String.format("constant(%s)", "labelVar1"), true);
        DerivedVariableSpecification derivedVariableSpecification2 = new DerivedVariableSpecification(String.format("constant(%s)", "labelVar2"), true);
        pointSpecification.getTop().addVariable((VariableSpecification)derivedVariableSpecification);
        pointSpecification.getTop().addVariable((VariableSpecification)derivedVariableSpecification2);
        FormatSpecification formatSpecification = new FormatSpecification();
        derivedVariableSpecification.setDisplayFormatChild(formatSpecification);
        RelabelSpecification relabelSpecification = new RelabelSpecification("labelVar1", "");
        formatSpecification.addRelabeling(relabelSpecification);
        formatSpecification = new FormatSpecification();
        derivedVariableSpecification2.setDisplayFormatChild(formatSpecification);
        relabelSpecification = new RelabelSpecification("labelVar2", "");
        formatSpecification.addRelabeling(relabelSpecification);
        ExpressionVariableSpecification expressionVariableSpecification = new ExpressionVariableSpecification();
        expressionVariableSpecification.setCategorical(Boolean.valueOf(false));
        expressionVariableSpecification.setExpression(sourceVariableSpecification.getId() + "/" + derivedVariableSpecification.getId() + "+" + sourceVariableSpecification2.getId() + "/" + derivedVariableSpecification2.getId());
        pointSpecification.getTop().addVariable((VariableSpecification)expressionVariableSpecification);
        pointSpecification.setX((VariableSpecification)expressionVariableSpecification);
        expressionVariableSpecification = new ExpressionVariableSpecification();
        expressionVariableSpecification.setCategorical(Boolean.valueOf(false));
        expressionVariableSpecification.setExpression(sourceVariableSpecification2.getId() + "/" + derivedVariableSpecification2.getId() + "+" + sourceVariableSpecification.getId() + "/" + derivedVariableSpecification.getId());
        pointSpecification.getTop().addVariable((VariableSpecification)expressionVariableSpecification);
        pointSpecification.setY((VariableSpecification)expressionVariableSpecification);
        styleSpecification = pointSpecification.getStyle("");
        if (styleSpecification == null) {
            styleSpecification = new StyleSpecification();
            pointSpecification.setStyle("", styleSpecification);
            pointSpecification.getTop().addStyle(styleSpecification);
        }
        this.removeDomain(sourceVariableSpecification);
        FormatSpecification formatSpecification2 = sourceVariableSpecification.getDisplayFormatChild();
        if (formatSpecification2 != null) {
            sourceVariableSpecification.remove((Specification)formatSpecification2);
        }
        this.removeDomain(sourceVariableSpecification2);
        IntervalDomainSpecification intervalDomainSpecification = new IntervalDomainSpecification(0.0, 21.0);
        this.mVisualization.getSpecification().addDomain((DomainSpecification)intervalDomainSpecification);
        DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 1);
        dimensionSpecification.setDomain((DomainSpecification)intervalDomainSpecification);
        dimensionSpecification.setUnionDomain(Boolean.valueOf(true));
        this.adjustHPanel(true);
        this.adjustVPanel(true);
        FacetingSpecification facetingSpecification = (FacetingSpecification)this.getFirstSpecByClass(null, FacetingSpecification.class);
        if (facetingSpecification != null) {
            facetingSpecification.getParent().remove((Specification)facetingSpecification);
        }
        for (FacetLevelSpecification facetLevelSpecification : facetLevelSpecificationArray = (FacetLevelSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(FacetLevelSpecification.class)) {
            facetLevelSpecification.setGap(new Length("0%"));
        }
    }

    private void setupDualYAxisAssociations() {
        ElementSpecification[] elementSpecificationArray;
        ExtensionSpecification extensionSpecification = this.getGraphExtension();
        int n = 0;
        for (ElementSpecification elementSpecification : elementSpecificationArray = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
            if (this.isErrorBarElement(elementSpecification) || this.isElementHidden(elementSpecification)) continue;
            String string = n == 0 ? AXIS1_ASSOC_KEY : AXIS2_ASSOC_KEY;
            extensionSpecification.put(string, elementSpecification.getId());
            ++n;
        }
        assert (n < 3);
    }

    private void setSchemaWidths(SchemaSpecification schemaSpecification) {
        StyleSpecification styleSpecification = schemaSpecification.getStyle("");
        if (styleSpecification == null) {
            styleSpecification = new StyleSpecification();
            schemaSpecification.setStyle("", styleSpecification);
            schemaSpecification.getTop().addStyle(styleSpecification);
        }
        styleSpecification.setWidth(new Length("75%"));
        styleSpecification.setDepth(new Length("75%"));
    }

    private void setupPopPyramid(IntervalSpecification intervalSpecification) {
        FacetingSpecification facetingSpecification;
        this.makeXScale(true);
        BinStatisticSpecification binStatisticSpecification = new BinStatisticSpecification(GridType.SQUARE);
        intervalSpecification.addStatistic((StatisticSpecification)binStatisticSpecification);
        SourceVariableSpecification sourceVariableSpecification = this.createNewVariable();
        sourceVariableSpecification.setCategorical(Boolean.valueOf(true));
        ColorAestheticSpecification colorAestheticSpecification = new ColorAestheticSpecification();
        colorAestheticSpecification.setVariable((VariableSpecification)sourceVariableSpecification);
        colorAestheticSpecification.setAffect(ColorAffectType.MAIN);
        intervalSpecification.addAesthetic((AestheticSpecification)colorAestheticSpecification);
        this.setupVarCategories(sourceVariableSpecification, null, ZoneType.zt_split_var);
        StyleSpecification styleSpecification = intervalSpecification.getStyle("");
        if (styleSpecification == null) {
            styleSpecification = new StyleSpecification();
            intervalSpecification.setStyle("", styleSpecification);
            intervalSpecification.getTop().addStyle(styleSpecification);
        }
        styleSpecification.setDepth(new Length("75%"));
        styleSpecification.setWidth(new Length("100%"));
        styleSpecification.setSize(null);
        this.removeDomain((SourceVariableSpecification)intervalSpecification.getY());
        this.mStyleCycler.setCycleForElement((ElementSpecification)intervalSpecification, this.mStyleCycler.getUseColors(), 0);
        IntervalDomainSpecification intervalDomainSpecification = new IntervalDomainSpecification(0.0, 21.0);
        this.mVisualization.getSpecification().addDomain((DomainSpecification)intervalDomainSpecification);
        DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 1);
        dimensionSpecification.setDomain((DomainSpecification)intervalDomainSpecification);
        dimensionSpecification.setUnionDomain(Boolean.valueOf(true));
        CoordinatesSpecification coordinatesSpecification = (CoordinatesSpecification)this.getFirstSpecByClass(null, CoordinatesSpecification.class);
        if (coordinatesSpecification != null) {
            coordinatesSpecification.addCoordinateTransform((CoordinateTransformSpecification)new TransposeCoordinateSpecification());
            facetingSpecification = new ReflectionCoordinateSpecification(DimensionType.X);
            facetingSpecification.setAlternating(Boolean.valueOf(true));
            coordinatesSpecification.addCoordinateTransform((CoordinateTransformSpecification)facetingSpecification);
        }
        this.adjustHPanel(true);
        facetingSpecification = (FacetingSpecification)this.getFirstSpecByClass(null, FacetingSpecification.class);
        facetingSpecification.setMethod(ExpressionType.CROSS);
        CrossSpecification crossSpecification = (CrossSpecification)facetingSpecification.getExpressionChild();
        Specification[] specificationArray = crossSpecification.getOperands();
        if (specificationArray.length > 0) {
            crossSpecification.remove(specificationArray[0]);
        }
        CrossSpecification crossSpecification2 = new CrossSpecification();
        crossSpecification2.addOperand((VariableSpecification)sourceVariableSpecification);
        crossSpecification.addOperand((ExpressionSpecification)crossSpecification2);
        FacetLevelSpecification facetLevelSpecification = (FacetLevelSpecification)this.getFirstSpecByClass(null, FacetLevelSpecification.class);
        facetLevelSpecification.setGap(new Length("0%"));
        AxisSpecification axisSpecification = facetLevelSpecification.getAxis()[0];
        styleSpecification = new StyleSpecification();
        styleSpecification.setVisible(Boolean.valueOf(false));
        facetLevelSpecification.getTop().addStyle(styleSpecification);
        axisSpecification.setStyle("", styleSpecification);
        MajorTicksSpecification majorTicksSpecification = axisSpecification.getMajorTickChild();
        styleSpecification = new StyleSpecification();
        styleSpecification.setFontSize(new Length(8.0f, UnitType.PT));
        majorTicksSpecification.setStyle("", styleSpecification);
        facetLevelSpecification.getTop().addStyle(styleSpecification);
    }

    private void removeAxisLabels() {
        AxisSpecification[] axisSpecificationArray;
        for (AxisSpecification axisSpecification : axisSpecificationArray = (AxisSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(AxisSpecification.class)) {
            LabelSpecification[] labelSpecificationArray;
            for (LabelSpecification labelSpecification : labelSpecificationArray = (LabelSpecification[])axisSpecification.findDescendantsOfType(LabelSpecification.class)) {
                labelSpecification.getParent().remove((Specification)labelSpecification);
            }
        }
    }

    private void addPolarTransforms() {
        try {
            new SetInsetCoordinatesAction(null, null, null, Double.valueOf(0.2)).modify(this.mVisualization.getSpecification());
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        CoordinatesSpecification coordinatesSpecification = (CoordinatesSpecification)this.getFirstSpecByClass(null, CoordinatesSpecification.class);
        coordinatesSpecification.addCoordinateTransform((CoordinateTransformSpecification)new PolarTransformSpecification());
    }

    private void removePolarTransforms() {
        CoordinateTransformSpecification[] coordinateTransformSpecificationArray;
        try {
            new SetInsetCoordinatesAction(null, null, null, null).modify(this.mVisualization.getSpecification());
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        CoordinatesSpecification coordinatesSpecification = (CoordinatesSpecification)this.getFirstSpecByClass(null, CoordinatesSpecification.class);
        for (CoordinateTransformSpecification coordinateTransformSpecification : coordinateTransformSpecificationArray = coordinatesSpecification.getCoordinateTransformSpecifications()) {
            coordinatesSpecification.remove((Specification)coordinateTransformSpecification);
        }
    }

    private void removeAesthetics() {
        ElementSpecification[] elementSpecificationArray;
        for (ElementSpecification elementSpecification : elementSpecificationArray = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
            AestheticSpecification[] aestheticSpecificationArray;
            for (AestheticSpecification aestheticSpecification : aestheticSpecificationArray = elementSpecification.getAestheticSpecifications()) {
                aestheticSpecification.getParent().remove((Specification)aestheticSpecification);
            }
        }
    }

    private Elements getElementType(Coords coords, ElementSpecification elementSpecification) {
        Elements elements = Elements.none;
        if (elementSpecification instanceof PointSpecification) {
            elements = this.isHiLoClose() ? Elements.hilo : (this.isSplom() ? Elements.splom : Elements.point);
        } else if (elementSpecification instanceof AreaSpecification) {
            Attribute attribute = elementSpecification.getAttribute("positionModifier");
            elements = attribute != null && attribute.toString().equals("minusIntersection") ? Elements.diff_area : Elements.area;
        } else if (elementSpecification instanceof LineSpecification) {
            elements = Elements.line;
        } else if (elementSpecification instanceof SchemaSpecification) {
            elements = Elements.schema;
        } else if (elementSpecification instanceof IntervalSpecification) {
            elements = coords.equals((Object)Coords.coords_Polar) ? Elements.polar_interval : (this.isHiLoClose() ? Elements.hilo : (this.isPopulationPyramid() ? Elements.pyramid : Elements.interval));
        }
        return elements;
    }

    private boolean isHiddenLine(ElementSpecification elementSpecification) {
        return elementSpecification instanceof LineSpecification && this.isElementHidden(elementSpecification);
    }

    private boolean isElementHidden(ElementSpecification elementSpecification) {
        StyleSpecification styleSpecification = elementSpecification.getStyle("");
        if (styleSpecification != null) {
            Attribute attribute = styleSpecification.getAttribute("visible");
            return attribute != null && attribute.asBoolean().equals(Boolean.FALSE);
        }
        return false;
    }

    private boolean checkRangeElements(boolean bl) {
        StatisticSpecification[] statisticSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
        boolean bl2 = ((PointSpecification[])visualizationSpecification.findDescendantsOfType(PointSpecification.class)).length == 1;
        IntervalSpecification[] intervalSpecificationArray = (IntervalSpecification[])visualizationSpecification.findDescendantsOfType(IntervalSpecification.class);
        if (bl2 && intervalSpecificationArray.length == 1 && (statisticSpecificationArray = intervalSpecificationArray[0].getStatistics()).length > 0 && statisticSpecificationArray[0] instanceof SummaryStatisticSpecification) {
            boolean bl3 = ((SummaryStatisticSpecification)statisticSpecificationArray[0]).getMethod() == SummaryType.RANGE;
            boolean bl4 = ((SummaryStatisticSpecification)statisticSpecificationArray[0]).getBase() == SummaryBaseType.COORDINATE;
            VariableSpecification variableSpecification = intervalSpecificationArray[0].getY();
            if (bl3 && bl4 == bl && variableSpecification instanceof ExpressionVariableSpecification) {
                return true;
            }
        }
        return false;
    }

    public void refreshData() {
        this.mSources = this.mDataGenerator.generateData();
        this.useData(this.mVisualization, true);
        this.mImage = null;
    }

    private void makeImage(Rectangle rectangle) {
        try {
            LocationSpecification[] locationSpecificationArray;
            for (LocationSpecification locationSpecification : locationSpecificationArray = this.getOrCreateLocations()) {
                if (locationSpecification.getPart().equals((Object)LocationPartType.RIGHT)) {
                    locationSpecification.setFixedValue(new Length((float)rectangle.width, UnitType.PX));
                    continue;
                }
                if (!locationSpecification.getPart().equals((Object)LocationPartType.BOTTOM)) continue;
                locationSpecification.setFixedValue(new Length((float)rectangle.height, UnitType.PX));
            }
            this.mVisualization.getSpecification().fireSpecificationChangedEvent(new SpecificationChangeEvent((Object)this, "redraw chart"));
            this.mImage = this.mVisualization.makeImage();
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
    }

    private boolean withinSizeTolerance(Rectangle rectangle) {
        if (this.mImage != null) {
            int n = Math.abs(this.mImage.getWidth() - rectangle.width);
            int n2 = Math.abs(this.mImage.getHeight() - rectangle.height);
            return n < 2 && n2 < 2;
        }
        return false;
    }

    private LocationSpecification[] getOrCreateLocations() {
        LocationSpecification[] locationSpecificationArray = (LocationSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(LocationSpecification.class);
        if (locationSpecificationArray == null || locationSpecificationArray.length == 0) {
            GraphSpecification graphSpecification = this.getGraphSpec();
            locationSpecificationArray = new LocationSpecification[]{new LocationSpecification(LocationPartType.LEFT), new LocationSpecification(LocationPartType.TOP), new LocationSpecification(LocationPartType.RIGHT), new LocationSpecification(LocationPartType.BOTTOM)};
            for (LocationSpecification locationSpecification : locationSpecificationArray) {
                locationSpecification.setFixedValue(new Length(0.0f, UnitType.PX));
                graphSpecification.addLocation(locationSpecification);
            }
        }
        return locationSpecificationArray;
    }

    private void buildVizSpecFromPrototype() {
        boolean bl;
        ObliqueCoordinateSpecification obliqueCoordinateSpecification;
        AxisSpecification[] axisSpecificationArray;
        VisualizationFactory visualizationFactory;
        try {
            visualizationFactory = VisualizationFactory.getInstance();
            axisSpecificationArray = this.getProperInputStream(this.mChartProto.getXml().array());
            if (this.mDataReader.readStreamData(this.mChartProto.getData())) {
                String string;
                ExtensionSpecification extensionSpecification;
                obliqueCoordinateSpecification = new VisualizationSpecification((InputStream)axisSpecificationArray);
                obliqueCoordinateSpecification.setLocale(ComponentState.getSPSSLocale());
                int n = this.mChartProto.getChartGroup();
                ExtensionSpecification[] extensionSpecificationArray = obliqueCoordinateSpecification.getExtensionSpecifications();
                if (n == 1 && extensionSpecificationArray.length > 0 && (extensionSpecification = extensionSpecificationArray[0]).get(string = "Footnote1") != null) {
                    String string2 = this.mCanvas.getResources().getResString("IDS_ERROR_BARS_CI_FOOTNOTE");
                    extensionSpecification.put(string, String.format(string2, "95"));
                }
                this.mVisualization = visualizationFactory.makeVisualization((VisualizationSpecification)obliqueCoordinateSpecification);
                this.setRenderingHints(this.mVisualization);
                this.mSources = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mVisualization = null;
            return;
        }
        this.mCoordinates = this.determineCoordinates();
        if (this.mCoordinates == Coords.coords_3D) {
            visualizationFactory = (CoordinatesSpecification)this.getFirstSpecByClass(null, CoordinatesSpecification.class);
            if (visualizationFactory != null && ((DimensionSpecification[])(obliqueCoordinateSpecification = visualizationFactory.getDimensionSpecifications())).length > 2 && (axisSpecificationArray = obliqueCoordinateSpecification[2].getAxisSpecifications()).length > 0) {
                axisSpecificationArray[0].setOpposite(Boolean.valueOf(false));
            }
            if ((obliqueCoordinateSpecification = (ObliqueCoordinateSpecification)this.getFirstSpecByClass(null, ObliqueCoordinateSpecification.class)) != null) {
                obliqueCoordinateSpecification.setDistance(Double.valueOf(1.4));
                obliqueCoordinateSpecification.setDx(Double.valueOf(-0.15));
                obliqueCoordinateSpecification.setDy(null);
            }
        }
        if (!this.mChartProto.isCustomChart()) {
            this.setDefaultStyles();
        }
        if ((bl = this.isHiLoClose()) || this.hasErrorBars()) {
            this.setRangeExtensions(this.mChartProto.isCustomChart());
        }
        if (bl && this.hasXCluster()) {
            this.setHLCPointCycle();
        }
        if (this.isDifferenceArea()) {
            this.setDiffAreaVarExtension();
        }
        if (this.isPopulationPyramid()) {
            this.fixupPyramidAesthetics();
        }
        if (this.isSingleDimensionDotPlot()) {
            this.fixupDotPlotDimension();
        }
        this.checkHistogramVariables();
        this.normalizeLabels();
        this.removeYTicks();
        this.cleanupSpec();
    }

    private void checkHistogramVariables() {
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        if (elementSpecification == null) {
            return;
        }
        ElementStat elementStat = this.getStatistic(elementSpecification);
        if (elementStat != null && (elementStat.getStat() == Statistics.Histogram || elementStat.getStat() == Statistics.HistogramPct)) {
            ZoneMgr zoneMgr = this.mCanvas.getZoneMgr();
            DropZone dropZone = zoneMgr.getZone(ZoneType.zt_x);
            DropZone dropZone2 = zoneMgr.getZone(ZoneType.zt_y);
            if (dropZone != null && zoneMgr.hasCatVar(ZoneType.zt_x)) {
                dropZone.clear(false);
            }
            if (dropZone2 != null) {
                dropZone2.clear(false);
            }
        }
    }

    private void fixupDotPlotDimension() {
        StatisticSpecification[] statisticSpecificationArray;
        DimensionSpecification[] dimensionSpecificationArray = (DimensionSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(DimensionSpecification.class);
        for (int i = dimensionSpecificationArray.length - 1; i >= 1; --i) {
            dimensionSpecificationArray[i].getParent().remove((Specification)dimensionSpecificationArray[i]);
        }
        PointSpecification pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class);
        for (StatisticSpecification statisticSpecification : statisticSpecificationArray = pointSpecification.getStatistics()) {
            pointSpecification.remove((Specification)statisticSpecification);
        }
    }

    private void fixupPyramidAesthetics() {
        BinStatisticSpecification binStatisticSpecification;
        IntervalSpecification intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class);
        if (intervalSpecification == null) {
            return;
        }
        StatisticSpecification[] statisticSpecificationArray = intervalSpecification.getStatistics();
        if (statisticSpecificationArray.length == 0) {
            binStatisticSpecification = new BinStatisticSpecification(GridType.SQUARE);
            intervalSpecification.addStatistic((StatisticSpecification)binStatisticSpecification);
        }
        for (BinStatisticSpecification binStatisticSpecification2 : binStatisticSpecification = intervalSpecification.getAestheticSpecifications()) {
            if (!(binStatisticSpecification2 instanceof StyleAestheticSpecification)) continue;
            intervalSpecification.remove((Specification)binStatisticSpecification2);
            if (this.mStyleCycler.getUseColors()) {
                ColorAestheticSpecification colorAestheticSpecification = new ColorAestheticSpecification(binStatisticSpecification2.getVariable());
                colorAestheticSpecification.setCycle(((StyleAestheticSpecification)binStatisticSpecification2).getStyleCycleSpecification());
                colorAestheticSpecification.setAffect(ColorAffectType.MAIN);
                intervalSpecification.addAesthetic((AestheticSpecification)colorAestheticSpecification);
                break;
            }
            PatternAestheticSpecification patternAestheticSpecification = new PatternAestheticSpecification(binStatisticSpecification2.getVariable());
            patternAestheticSpecification.setCycle(((StyleAestheticSpecification)binStatisticSpecification2).getStyleCycleSpecification());
            patternAestheticSpecification.setClamp(Boolean.valueOf(true));
            intervalSpecification.addAesthetic((AestheticSpecification)patternAestheticSpecification);
            break;
        }
        BinStatisticSpecification binStatisticSpecification3 = intervalSpecification.getStyle("");
        StyleSpecification styleSpecification = new StyleSpecification();
        styleSpecification.setWidth(new Length("100%"));
        styleSpecification.setDepth(new Length("75%"));
        styleSpecification.setPatternIndex(binStatisticSpecification3.getPatternIndex());
        styleSpecification.setColor(binStatisticSpecification3.getColor());
        styleSpecification.setSecondaryColor(binStatisticSpecification3.getSecondaryColor());
        intervalSpecification.setStyle("", styleSpecification);
        binStatisticSpecification3.getParent().remove((Specification)binStatisticSpecification3);
        this.addVizStyle(styleSpecification);
    }

    private String getExtensionValue(ExtensionSpecification[] extensionSpecificationArray, String string) {
        for (ExtensionSpecification extensionSpecification : extensionSpecificationArray) {
            String string2 = extensionSpecification.get(string);
            if (string2 == null || string2.length() <= 0) continue;
            return string2;
        }
        return null;
    }

    private void setDiffAreaVarExtension() {
        Specification specification = this.getSpecByClassAndAttr(null, ColorAestheticSpecification.class, "affect", "main");
        if (specification == null) {
            specification = this.getSpecByClassAndAttr(null, PatternAestheticSpecification.class, "clamp", "true");
        }
        if (specification == null) {
            return;
        }
        VariableSpecification variableSpecification = null;
        if (specification instanceof ColorAestheticSpecification) {
            variableSpecification = ((ColorAestheticSpecification)specification).getVariable();
        } else if (specification instanceof PatternAestheticSpecification) {
            variableSpecification = ((PatternAestheticSpecification)specification).getVariable();
        }
        if (variableSpecification == null) {
            return;
        }
        ExtensionSpecification extensionSpecification = this.getVariableExtension(variableSpecification);
        extensionSpecification.put(DIFF_AREA_KEY, "true");
        this.setupVarCategories((SourceVariableSpecification)variableSpecification, null, ZoneType.zt_x);
    }

    private void setHLCPointCycle() {
        PointSpecification pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class);
        if (pointSpecification != null && pointSpecification.getAestheticSpecifications().length > 0) {
            this.mStyleCycler.setSimplePointCycle((StyleAestheticSpecification)pointSpecification.getAestheticSpecifications()[0]);
        }
    }

    private void setRangeExtensions(boolean bl) {
        if (this.isHiLoClose()) {
            ExtensionSpecification extensionSpecification;
            PointSpecification pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class);
            if (pointSpecification == null) {
                assert (false);
                return;
            }
            SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)this.getSpecByClassAndAttr(null, SourceVariableSpecification.class, "id", "range_element_low");
            if (sourceVariableSpecification != null) {
                extensionSpecification = this.getVariableExtension((VariableSpecification)sourceVariableSpecification);
                extensionSpecification.put(RANGE_KEY, pointSpecification.getId());
                extensionSpecification.put(LOW_RANGE_KEY, "low");
            }
            if ((extensionSpecification = (SourceVariableSpecification)this.getSpecByClassAndAttr(null, SourceVariableSpecification.class, "id", "range_element_high")) != null) {
                ExtensionSpecification extensionSpecification2 = this.getVariableExtension((VariableSpecification)extensionSpecification);
                extensionSpecification2.put(RANGE_KEY, pointSpecification.getId());
                extensionSpecification2.put(HIGH_RANGE_KEY, "high");
            }
        } else {
            ExpressionVariableSpecification[] expressionVariableSpecificationArray;
            ElementSpecification[] elementSpecificationArray = this.getNonRangeElements();
            for (ExpressionVariableSpecification expressionVariableSpecification : expressionVariableSpecificationArray = (ExpressionVariableSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ExpressionVariableSpecification.class)) {
                String string = expressionVariableSpecification.getExpression();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "+", false);
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    ExtensionSpecification extensionSpecification;
                    String string2;
                    String string3 = stringTokenizer.nextToken().trim();
                    SourceVariableSpecification sourceVariableSpecification = (SourceVariableSpecification)this.getSpecByClassAndAttr(null, SourceVariableSpecification.class, "id", string3);
                    if (sourceVariableSpecification == null) {
                        assert (false);
                        return;
                    }
                    String string4 = sourceVariableSpecification.getId();
                    if (string4.indexOf("_1") > -1 && elementSpecificationArray.length > 0) {
                        string2 = elementSpecificationArray[0].getId();
                    } else if (string4.indexOf("_2") > -1 && elementSpecificationArray.length > 1) {
                        string2 = elementSpecificationArray[1].getId();
                    } else {
                        assert (false);
                        return;
                    }
                    if (string4.indexOf("_low") > -1) {
                        String string5;
                        ExtensionSpecification extensionSpecification3;
                        String string6;
                        extensionSpecification = this.getVariableExtension((VariableSpecification)sourceVariableSpecification);
                        extensionSpecification.put(RANGE_KEY, string2);
                        extensionSpecification.put(LOW_RANGE_KEY, "low");
                        if (!bl && (string6 = (extensionSpecification3 = this.getTitlesExtension()).get(string5 = "Footnote1")) != null) {
                            extensionSpecification3.put(string5 + "_assoc", string2);
                            string6 = extensionSpecification3.get(string5 + "_flags");
                            int n2 = 0;
                            if (string6 != null && string6.length() > 0) {
                                n2 = Integer.valueOf(string6);
                            }
                            extensionSpecification3.put(string5 + "_flags", Integer.toString(n2 |= 0x8000));
                        }
                    } else if (string4.indexOf("_high") > -1) {
                        extensionSpecification = this.getVariableExtension((VariableSpecification)sourceVariableSpecification);
                        extensionSpecification.put(RANGE_KEY, string2);
                        extensionSpecification.put(HIGH_RANGE_KEY, "high");
                    } else if (n == 0) {
                        extensionSpecification = this.getVariableExtension((VariableSpecification)sourceVariableSpecification);
                        extensionSpecification.put(RANGE_KEY, string2);
                        extensionSpecification.put(LOW_RANGE_KEY, "low");
                    } else if (n == 1) {
                        extensionSpecification = this.getVariableExtension((VariableSpecification)sourceVariableSpecification);
                        extensionSpecification.put(RANGE_KEY, string2);
                        extensionSpecification.put(HIGH_RANGE_KEY, "high");
                    } else {
                        assert (false);
                        return;
                    }
                    ++n;
                }
            }
        }
    }

    private ElementSpecification[] getNonRangeElements() {
        ElementSpecification[] elementSpecificationArray;
        Vector<ElementSpecification> vector = new Vector<ElementSpecification>();
        for (ElementSpecification elementSpecification : elementSpecificationArray = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
            if (elementSpecification.getY() instanceof ExpressionVariableSpecification) continue;
            vector.add(elementSpecification);
        }
        elementSpecificationArray = new ElementSpecification[vector.size()];
        return vector.toArray(elementSpecificationArray);
    }

    private void setDefaultStyles() {
        ElementSpecification[] elementSpecificationArray;
        this.setDefaultStyleForChartAppearance();
        Color color = this.mChartAppearanceOption.getSimpleColor(this.getProtoTypeStr());
        if (color == null) {
            color = this.mStyleCycler.getCycleColors()[0];
        }
        if (color != null) {
            this.mStyleCycler.refreshSimpleColor(color);
        }
        ElementSpecification[] elementSpecificationArray2 = elementSpecificationArray = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class);
        int n = elementSpecificationArray2.length;
        for (int i = 0; i < n; ++i) {
            Specification specification;
            ElementSpecification elementSpecification = elementSpecificationArray2[i];
            Elements elements = this.getElementType(this.mCoordinates, elementSpecification);
            if (elements == Elements.interval && this.isDropLine()) continue;
            this.mStyleCycler.setBaseStyle(this.mCoordinates, elementSpecification, elements, this.mStyleCycler.getUseColors());
            boolean bl = this.mStyleCycler.getUseColors();
            if (this.isDifferenceArea()) {
                VariableSpecification variableSpecification;
                specification = this.getSpecByClassAndAttr(null, ColorAestheticSpecification.class, "affect", "main");
                if (specification != null && !bl) {
                    variableSpecification = ((ColorAestheticSpecification)specification).getVariable();
                    specification.getParent().remove(specification);
                    this.setupDiffAreaAesthetic((AreaSpecification)elementSpecification, (SourceVariableSpecification)variableSpecification, bl);
                }
                Specification specification2 = specification = bl ? this.getSpecByClassAndAttr(null, PatternAestheticSpecification.class, "clamp", "true") : null;
                if (specification != null) {
                    variableSpecification = ((PatternAestheticSpecification)specification).getVariable();
                    specification.getParent().remove(specification);
                    this.setupDiffAreaAesthetic((AreaSpecification)elementSpecification, (SourceVariableSpecification)variableSpecification, bl);
                }
                this.mStyleCycler.setCycleForElement(elementSpecification, bl, 0);
                continue;
            }
            specification = (Specification)elementSpecification.findDescendantsOfType(StyleAestheticSpecification.class);
            for (int j = 0; j < ((Specification)specification).length; ++j) {
                StyleCycleSpecification styleCycleSpecification = specification[j].getStyleCycleSpecification();
                if (styleCycleSpecification == null) continue;
                this.mStyleCycler.setCycleForElement(elementSpecification, bl, j);
                bl = !bl;
            }
            if (((Specification)specification).length != 0) continue;
            ColorAestheticSpecification[] colorAestheticSpecificationArray = (ColorAestheticSpecification[])elementSpecification.findDescendantsOfType(ColorAestheticSpecification.class);
            for (int j = 0; j < colorAestheticSpecificationArray.length; ++j) {
                StyleCycleSpecification styleCycleSpecification = colorAestheticSpecificationArray[j].getCycle();
                if (styleCycleSpecification == null) continue;
                this.mStyleCycler.setCycleForElement(elementSpecification, bl, j);
                bl = !bl;
            }
        }
        if (this.mCoordinates == Coords.coords_DualY) {
            this.setDualYAxisColors();
        }
        if ((elementSpecificationArray2 = this.mVisualization.getSpecification().getStyleSpecifications()) != null && elementSpecificationArray2.length > 0) {
            elementSpecificationArray2[0].setFontFamily("SansSerif");
        }
    }

    private void setDefaultStyleForChartAppearance() {
        String string;
        String string2;
        try {
            String string3;
            ApplyTemplate applyTemplate;
            String string4;
            string2 = TrinityUtil.visSpecToString((VisualizationSpecification)this.mVisualization.getSpecification(), (boolean)false);
            string = this.applyChartTemplates(string2);
            String string5 = this.mChartAppearanceOption.getTemplatePath();
            String string6 = string;
            if (string5 != null && string5.length() > 0 && (string4 = this.applyTemplate(applyTemplate = new ApplyTemplate(), string, string3 = this.getFilteredTemplate(this.readXmlFromFile(string5)))).length() > 0) {
                string6 = string4;
                this.mChartAppearanceOption.updateOption(string5);
            }
            applyTemplate = new VisualizationSpecification((Reader)new StringReader(string6));
            this.mVisualization.setSpecification((VisualizationSpecification)applyTemplate);
            this.mVisualization.getSpecification().fireSpecificationChangedEvent(new SpecificationChangeEvent((Object)this, "redraw chart"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        string2 = this.getGraphSpec();
        string = string2.getCellStyle();
        string.setSecondaryColor(this.mChartAppearanceOption.isInnerFrameBorder() ? Color.BLACK : new Color(0, 0, 0, 0));
        this.mCanvas.setDrawOuterFrameBorder(this.mChartAppearanceOption.isOuterFrameBorder());
        if (this.mCoordinates == Coords.coords_2D) {
            this.updateGridline(this.mChartAppearanceOption.isGridlineX(), "x");
            this.updateGridline(this.mChartAppearanceOption.isGridlineY(), "y");
        }
    }

    private String readXmlFromFile(String string) throws Exception {
        String string2 = null;
        if (string != null && string.length() > 0) {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "";
            while (string3 != null) {
                stringBuffer.append(string3);
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private void setDualYAxisColors() {
        DimensionSpecification[] dimensionSpecificationArray = (DimensionSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(DimensionSpecification.class);
        if (dimensionSpecificationArray == null || dimensionSpecificationArray.length < 2) {
            return;
        }
        AxisSpecification[] axisSpecificationArray = (AxisSpecification[])dimensionSpecificationArray[1].findDescendantsOfType(AxisSpecification.class);
        if (axisSpecificationArray == null || axisSpecificationArray.length < 2) {
            return;
        }
        LineStyle lineStyle = axisSpecificationArray[0].getStyle();
        lineStyle.setColor(this.mStyleCycler.getDualYAxisColor(0));
        lineStyle = axisSpecificationArray[1].getStyle();
        lineStyle.setColor(this.mStyleCycler.getDualYAxisColor(1));
    }

    private void normalizeLabels() {
        AxisSpecification[] axisSpecificationArray;
        boolean bl = false;
        for (AxisSpecification axisSpecification : axisSpecificationArray = (AxisSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(AxisSpecification.class)) {
            if (this.mCoordinates != Coords.coords_DualY || !bl) {
                axisSpecification.setStyle("", null);
            }
            bl = true;
            if (axisSpecification.getMajorTickChild() != null) {
                MajorTicksSpecification majorTicksSpecification = axisSpecification.getMajorTickChild();
                majorTicksSpecification.setLabelAngle(null);
                majorTicksSpecification.setMarkStyle(null);
                StyleSpecification styleSpecification = new StyleSpecification();
                styleSpecification.setVisible(Boolean.valueOf(false));
                styleSpecification.setFontSize(new Length(8.0f, UnitType.PT));
                majorTicksSpecification.setStyle((TextStyle)styleSpecification);
                this.addVizStyle(styleSpecification);
            }
            axisSpecification.setMinorTickChild(null);
        }
    }

    private void addVizStyle(StyleSpecification styleSpecification) {
        StyleSpecification[] styleSpecificationArray = this.mVisualization.getSpecification().getStyleSpecifications();
        if (styleSpecificationArray != null && styleSpecificationArray.length > 0) {
            styleSpecificationArray[0].addStyle(styleSpecification);
        } else {
            this.mVisualization.getSpecification().addStyle(styleSpecification);
        }
    }

    private void removeYTicks() {
        AxisSpecification[] axisSpecificationArray;
        DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 1);
        if (dimensionSpecification == null) {
            return;
        }
        for (AxisSpecification axisSpecification : axisSpecificationArray = dimensionSpecification.getAxisSpecifications()) {
            MinorTicksSpecification minorTicksSpecification;
            LineStyle lineStyle;
            MajorTicksSpecification majorTicksSpecification = axisSpecification.getMajorTickChild();
            LineStyle lineStyle2 = lineStyle = majorTicksSpecification != null ? majorTicksSpecification.getMarkStyle() : null;
            if (lineStyle != null) {
                lineStyle.setVisible(Boolean.valueOf(false));
            }
            LineStyle lineStyle3 = lineStyle = (minorTicksSpecification = axisSpecification.getMinorTickChild()) != null ? minorTicksSpecification.getMarkStyle() : null;
            if (lineStyle == null) continue;
            lineStyle.setVisible(Boolean.valueOf(false));
        }
    }

    private int dimCountForCoords(Coords coords) {
        if (coords.equals((Object)Coords.coords_1D)) {
            return 1;
        }
        if (coords.equals((Object)Coords.coords_2D)) {
            return 2;
        }
        if (coords.equals((Object)Coords.coords_3D)) {
            return 3;
        }
        if (coords.equals((Object)Coords.coords_DualY)) {
            return 2;
        }
        if (coords.equals((Object)Coords.coords_Polar)) {
            return 1;
        }
        return 0;
    }

    private void adjustDimensionMapping(boolean bl) {
        DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 0);
        if (dimensionSpecification == null) {
            return;
        }
        int n = bl ? 0 : 5;
        dimensionSpecification.setLowerMargin((float)n, UnitType.PERCENT);
        dimensionSpecification.setUpperMargin((float)n, UnitType.PERCENT);
        dimensionSpecification.setNiceLowerMapping(Boolean.valueOf(true));
        dimensionSpecification.setNiceUpperMapping(Boolean.valueOf(!bl));
        dimensionSpecification.setUnionDomain(Boolean.valueOf(false));
    }

    private void removeDefaultElement() {
        Specification specification = this.getFirstSpecByClass(null, LineSpecification.class);
        if (specification == null) {
            return;
        }
        LineSpecification lineSpecification = (LineSpecification)specification;
        if (this.isElementHidden((ElementSpecification)lineSpecification)) {
            lineSpecification.getParent().remove((Specification)lineSpecification);
        }
    }

    private void setCoordsForElementType(Elements elements) {
        Coords coords;
        Coords coords2 = coords = this.mCoordinates == Coords.coords_none ? Coords.coords_2D : this.mCoordinates;
        if (elements == Elements.polar_interval) {
            coords = Coords.coords_Polar;
        }
        this.setCoordinates(coords);
    }

    private void adjustElementVariables(ElementSpecification elementSpecification) {
        block5: {
            block4: {
                AestheticSpecification[] aestheticSpecificationArray;
                Specification specification = this.getFirstSpecByClass(null, LineSpecification.class);
                int n = this.dimCountForCoords(this.mCoordinates);
                if (specification == null || !this.isElementHidden((ElementSpecification)specification)) break block4;
                LineSpecification lineSpecification = (LineSpecification)specification;
                elementSpecification.setX(lineSpecification.getX());
                if (n > 1) {
                    elementSpecification.setY(lineSpecification.getY());
                }
                if (n > 2) {
                    elementSpecification.setZ(lineSpecification.getZ());
                }
                if ((aestheticSpecificationArray = lineSpecification.getAestheticSpecifications()).length <= 0) break block5;
                aestheticSpecificationArray[0].getParent().remove((Specification)aestheticSpecificationArray[0]);
                elementSpecification.addAesthetic(aestheticSpecificationArray[0]);
                break block5;
            }
            if (this.mCoordinates == Coords.coords_DualY && this.dataElementCount() > 1) {
                ElementSpecification[] elementSpecificationArray;
                for (ElementSpecification elementSpecification2 : elementSpecificationArray = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
                    if (elementSpecification2.equals(elementSpecification) || this.isErrorBarElement(elementSpecification2)) continue;
                    elementSpecification.setX(elementSpecification2.getX());
                    SourceVariableSpecification sourceVariableSpecification = this.createNewVariable();
                    sourceVariableSpecification.setCategorical(Boolean.valueOf(false));
                    elementSpecification.setY((VariableSpecification)sourceVariableSpecification);
                    break;
                }
            }
        }
    }

    private void setTickLabelVisibility(ZoneType zoneType, boolean bl) {
        int n;
        if (zoneType.equals((Object)ZoneType.zt_x)) {
            n = 0;
        } else if (zoneType.equals((Object)ZoneType.zt_y)) {
            n = 1;
        } else if (zoneType.equals((Object)ZoneType.zt_z)) {
            n = 2;
        } else {
            return;
        }
        DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, n);
        if (dimensionSpecification == null || dimensionSpecification.getAxisSpecifications().length == 0) {
            return;
        }
        AxisSpecification axisSpecification = dimensionSpecification.getAxisSpecifications()[0];
        MajorTicksSpecification majorTicksSpecification = axisSpecification.getMajorTickChild();
        if (majorTicksSpecification == null) {
            return;
        }
        TextStyle textStyle = majorTicksSpecification.getStyle();
        if (textStyle == null) {
            textStyle = new StyleSpecification();
            majorTicksSpecification.setStyle(textStyle);
            this.addVizStyle((StyleSpecification)textStyle);
        }
        textStyle.setVisible(Boolean.valueOf(bl));
        if (bl) {
            textStyle.setFontSize(new Length(8.0f, UnitType.PT));
        }
    }

    private void setupIntervalDomain(SourceVariableSpecification sourceVariableSpecification) {
        this.removeDomain(sourceVariableSpecification);
        if (this.mCoordinates.equals((Object)Coords.coords_Polar)) {
            return;
        }
        IntervalDomainSpecification intervalDomainSpecification = new IntervalDomainSpecification(0.0, 21.0);
        this.mVisualization.getSpecification().addDomain((DomainSpecification)intervalDomainSpecification);
        intervalDomainSpecification.addVariableReference((VariableSpecification)sourceVariableSpecification);
        sourceVariableSpecification.setDomain((DomainSpecification)intervalDomainSpecification);
    }

    private void removeDomain(SourceVariableSpecification sourceVariableSpecification) {
        DomainSpecification domainSpecification = sourceVariableSpecification.getDomain();
        sourceVariableSpecification.setDomain(null);
        if (domainSpecification != null) {
            domainSpecification.getParent().remove((Specification)domainSpecification);
        }
    }

    private void setupCategoricalDomain(SourceVariableSpecification sourceVariableSpecification) {
        int n;
        this.removeDomain(sourceVariableSpecification);
        int n2 = ((RelabelSpecification[])sourceVariableSpecification.findDescendantsOfType(RelabelSpecification.class)).length;
        CategoricalDomainSpecification categoricalDomainSpecification = new CategoricalDomainSpecification();
        this.mVisualization.getSpecification().addDomain((DomainSpecification)categoricalDomainSpecification);
        sourceVariableSpecification.setDomain((DomainSpecification)categoricalDomainSpecification);
        String[] stringArray = new String[n2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = String.format("%d", n + 1);
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = String.format("%d", n + 1);
        }
        FixedCategorySpecification fixedCategorySpecification = new FixedCategorySpecification(stringArray);
        fixedCategorySpecification.setRemove(Boolean.valueOf(false));
        categoricalDomainSpecification.addDomainCategory(fixedCategorySpecification);
        categoricalDomainSpecification.addVariableReference((VariableSpecification)sourceVariableSpecification);
        fixedCategorySpecification = new FixedCategorySpecification(new String[0]);
        fixedCategorySpecification.setRemove(Boolean.valueOf(true));
        categoricalDomainSpecification.addDomainCategory(fixedCategorySpecification);
        SimpleSortSpecification simpleSortSpecification = new SimpleSortSpecification(SortMethodType.CUSTOM);
        simpleSortSpecification.setCategoryOrder(stringArray);
        categoricalDomainSpecification.setSortChild((SortSpecification)simpleSortSpecification);
    }

    private void setupCategoricalDomain(SourceVariableSpecification sourceVariableSpecification, ISpssVariable iSpssVariable) {
        this.removeDomain(sourceVariableSpecification);
        int n = ((RelabelSpecification[])sourceVariableSpecification.findDescendantsOfType(RelabelSpecification.class)).length;
        CategoricalDomainSpecification categoricalDomainSpecification = new CategoricalDomainSpecification();
        this.mVisualization.getSpecification().addDomain((DomainSpecification)categoricalDomainSpecification);
        sourceVariableSpecification.setDomain((DomainSpecification)categoricalDomainSpecification);
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.format("%d", i + 1);
        }
        FixedCategorySpecification fixedCategorySpecification = new FixedCategorySpecification(stringArray);
        fixedCategorySpecification.setRemove(Boolean.valueOf(false));
        categoricalDomainSpecification.addDomainCategory(fixedCategorySpecification);
        categoricalDomainSpecification.addVariableReference((VariableSpecification)sourceVariableSpecification);
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        String[] stringArray2 = this.getExcludeArray((VariableSpecification)sourceVariableSpecification, iSpssVariable, iValueLabelMap, stringArray);
        if (stringArray2.length > 0) {
            fixedCategorySpecification = new FixedCategorySpecification(stringArray2);
            fixedCategorySpecification.setRemove(Boolean.valueOf(true));
        } else {
            fixedCategorySpecification = new FixedCategorySpecification(new String[0]);
            fixedCategorySpecification.setRemove(Boolean.valueOf(false));
        }
        categoricalDomainSpecification.addDomainCategory(fixedCategorySpecification);
        SimpleSortSpecification simpleSortSpecification = new SimpleSortSpecification(SortMethodType.CUSTOM);
        simpleSortSpecification.setCategoryOrder(stringArray);
        categoricalDomainSpecification.setSortChild((SortSpecification)simpleSortSpecification);
    }

    private String[] getExcludeArray(VariableSpecification variableSpecification, ISpssVariable iSpssVariable, IValueLabelMap iValueLabelMap, String[] stringArray) {
        String[] stringArray2 = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        FormatSpecification formatSpecification = variableSpecification.getDisplayFormatChild();
        RelabelSpecification[] relabelSpecificationArray = formatSpecification.getRelabeling();
        int n = stringArray.length + 1;
        for (Map.Entry entry : iValueLabelMap.getValueLabelEntries()) {
            if (iSpssVariable.isMissing((OBS)entry.getKey())) continue;
            String string = (String)entry.getValue();
            boolean bl = false;
            for (RelabelSpecification relabelSpecification : relabelSpecificationArray) {
                if (!relabelSpecification.getTo().equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(String.valueOf(n));
            ++n;
        }
        if (arrayList.size() > 0) {
            stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray2;
    }

    private void setupVarCategories(SourceVariableSpecification sourceVariableSpecification, ISpssVariable iSpssVariable, ZoneType zoneType) {
        RelabelSpecification[] relabelSpecificationArray;
        FormatSpecification formatSpecification;
        FormatSpecification formatSpecification2 = sourceVariableSpecification.getDisplayFormatChild();
        if (formatSpecification2 == null) {
            formatSpecification = new FormatSpecification();
            sourceVariableSpecification.setDisplayFormatChild(formatSpecification);
        } else {
            formatSpecification = formatSpecification2;
        }
        for (RelabelSpecification relabelSpecification : relabelSpecificationArray = formatSpecification.getRelabeling()) {
            formatSpecification.remove((Specification)relabelSpecification);
        }
        if (this.isDiffAreaVariable(sourceVariableSpecification)) {
            this.setupDiffAreaCats(formatSpecification);
            return;
        }
        int n = 0;
        if (iSpssVariable != null) {
            IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
            for (Object object : iValueLabelMap.getValueLabelEntries()) {
                if (iSpssVariable.isMissing((OBS)object.getKey())) continue;
                ++n;
            }
            boolean bl = n > 10;
            n = 0;
            for (Map.Entry entry : iValueLabelMap.getValueLabelEntries()) {
                if (iSpssVariable.isMissing((OBS)entry.getKey())) continue;
                String string = n == 9 && bl ? this.mCanvas.getResources().getResString("IDS_MORE_CATS") : (String)entry.getValue();
                formatSpecification.addRelabeling(new RelabelSpecification(Integer.toString(++n), string));
                if (n < 10) continue;
                break;
            }
        }
        if (n == 0) {
            this.addDefaultRelabels(formatSpecification);
        }
        if (zoneType != ZoneType.zt_filter) {
            this.clearRelabels(zoneType);
        }
    }

    private void clearRelabels(ZoneType zoneType) {
        String string = this.getIdentifierForZoneType(zoneType);
        if (string == null) {
            return;
        }
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        extensionSpecification.put(string + "_relabels", null);
    }

    private String getIdentifierForZoneType(ZoneType zoneType) {
        return this.getIdentifierForZoneType(zoneType, 1);
    }

    private String getIdentifierForZoneType(ZoneType zoneType, int n) {
        String string = null;
        if (zoneType == ZoneType.zt_x || zoneType == ZoneType.zt_dist_var) {
            string = "AxisX1";
        } else if (zoneType == ZoneType.zt_y || zoneType == ZoneType.zt_y2 || zoneType == ZoneType.zt_high || zoneType == ZoneType.zt_low || zoneType == ZoneType.zt_close) {
            string = "AxisY1";
        } else if (zoneType == ZoneType.zt_z) {
            string = "AxisZ1";
        } else if (zoneType == ZoneType.zt_panel_horz) {
            string = "PanelH1";
        } else if (zoneType == ZoneType.zt_panel_vert) {
            string = "PanelV1";
        } else if (zoneType == ZoneType.zt_cluster_x || zoneType == ZoneType.zt_cluster_z || zoneType == ZoneType.zt_group || zoneType == ZoneType.zt_slice_by || zoneType == ZoneType.zt_split_var) {
            boolean bl = this.hasXCluster();
            boolean bl2 = this.hasZCluster();
            int n2 = 0;
            if (zoneType == ZoneType.zt_cluster_z) {
                n2 = bl ? 1 : 0;
            } else if (zoneType == ZoneType.zt_group) {
                n2 = bl || bl2 ? 1 : 0;
            }
            string = "Legend" + Integer.toString(n2 + 1);
        } else if (zoneType == ZoneType.zt_filter) {
            string = "Filter" + n;
        }
        return string;
    }

    private void setupDiffAreaCats(FormatSpecification formatSpecification) {
        String string = this.mCanvas.getResources().getResString("IDS_CAT_NUM");
        formatSpecification.addRelabeling(new RelabelSpecification("1", String.format(string, 1)));
        formatSpecification.addRelabeling(new RelabelSpecification("2", String.format(string, 2)));
    }

    private boolean isDiffAreaVariable(SourceVariableSpecification sourceVariableSpecification) {
        String string = this.getExtensionValue(sourceVariableSpecification.getExtensionSpecifications(), DIFF_AREA_KEY);
        return string != null && string.equals("true");
    }

    private void addDefaultRelabels(FormatSpecification formatSpecification) {
        String string = this.mCanvas.getResources().getResString("IDS_CAT_NUM");
        String string2 = this.mCanvas.getResources().getResString("IDS_MORE_CATS");
        formatSpecification.addRelabeling(new RelabelSpecification("1", String.format(string, 1)));
        formatSpecification.addRelabeling(new RelabelSpecification("2", String.format(string, 2)));
        formatSpecification.addRelabeling(new RelabelSpecification("3", string2));
    }

    private boolean defaultIsCategorical(ZoneType zoneType) {
        return !zoneType.equals((Object)ZoneType.zt_angle) && !zoneType.equals((Object)ZoneType.zt_y) && !zoneType.equals((Object)ZoneType.zt_y2) && !zoneType.equals((Object)ZoneType.zt_high) && !zoneType.equals((Object)ZoneType.zt_low) && !zoneType.equals((Object)ZoneType.zt_close) && !zoneType.equals((Object)ZoneType.zt_dist_var) && !zoneType.equals((Object)ZoneType.zt_matrix);
    }

    private SourceVariableSpecification createNewVariable() {
        SourceVariableSpecification sourceVariableSpecification = new SourceVariableSpecification();
        sourceVariableSpecification.setSource((DataSpecification)this.getUserSource());
        this.mVisualization.getSpecification().addVariable((VariableSpecification)sourceVariableSpecification);
        return sourceVariableSpecification;
    }

    private void setVarForZone(ZoneType zoneType, SourceVariableSpecification sourceVariableSpecification) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        if (elementSpecification == null) {
            return;
        }
        if (zoneType.equals((Object)ZoneType.zt_cluster_x)) {
            this.setXClusterVar(elementSpecification, sourceVariableSpecification);
        } else if (zoneType.equals((Object)ZoneType.zt_cluster_z)) {
            this.setZClusterVar(elementSpecification, sourceVariableSpecification);
        } else if (zoneType.equals((Object)ZoneType.zt_panel_horz)) {
            this.setPanelVariable(sourceVariableSpecification, 1);
        } else if (zoneType.equals((Object)ZoneType.zt_panel_vert)) {
            this.setPanelVariable(sourceVariableSpecification, 2);
        } else if (zoneType.equals((Object)ZoneType.zt_angle)) {
            this.setXVariable(sourceVariableSpecification);
        } else if (zoneType.equals((Object)ZoneType.zt_x)) {
            this.setXVariable(sourceVariableSpecification);
        } else if (zoneType.equals((Object)ZoneType.zt_y)) {
            this.setYVariable(sourceVariableSpecification);
        } else if (zoneType.equals((Object)ZoneType.zt_z)) {
            this.setZVariable(sourceVariableSpecification);
        }
    }

    private void setXVariable(SourceVariableSpecification sourceVariableSpecification) {
        if (this.hasXCluster()) {
            DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 0);
            if (dimensionSpecification != null) {
                dimensionSpecification.setClusterVariable((VariableSpecification)sourceVariableSpecification);
            }
        } else {
            ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
            if (elementSpecification != null) {
                elementSpecification.setX((VariableSpecification)sourceVariableSpecification);
            }
        }
    }

    private void setYVariable(SourceVariableSpecification sourceVariableSpecification) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        if (elementSpecification != null) {
            elementSpecification.setY((VariableSpecification)sourceVariableSpecification);
        }
    }

    private void setZVariable(SourceVariableSpecification sourceVariableSpecification) {
        if (this.hasZCluster()) {
            DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 2);
            if (dimensionSpecification != null) {
                dimensionSpecification.setClusterVariable((VariableSpecification)sourceVariableSpecification);
            }
        } else {
            ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
            if (elementSpecification != null) {
                elementSpecification.setZ((VariableSpecification)sourceVariableSpecification);
            }
        }
    }

    private void setPanelVariable(SourceVariableSpecification sourceVariableSpecification, int n) {
        GraphSpecification graphSpecification = this.getGraphSpec();
        FacetingSpecification facetingSpecification = graphSpecification.getFacetingChild();
        if (facetingSpecification == null) {
            return;
        }
        Specification specification = facetingSpecification.getExpressionChild();
        if (!(specification instanceof CrossSpecification)) {
            return;
        }
        CrossSpecification crossSpecification = (CrossSpecification)specification;
        Specification[] specificationArray = crossSpecification.getOperands();
        if (n == 1) {
            if (specificationArray.length == 0) {
                crossSpecification.addOperand((VariableSpecification)sourceVariableSpecification);
            } else {
                crossSpecification.setA((VariableSpecification)sourceVariableSpecification);
            }
        } else if (n == 2) {
            if (specificationArray.length == 0) {
                crossSpecification.addOperand((ExpressionSpecification)new UnitySpecification());
            } else if (specificationArray.length == 1) {
                crossSpecification.addOperand((VariableSpecification)sourceVariableSpecification);
            } else {
                crossSpecification.setB((VariableSpecification)sourceVariableSpecification);
            }
        } else assert (false);
    }

    private void setXClusterVar(ElementSpecification elementSpecification, SourceVariableSpecification sourceVariableSpecification) {
        VariableSpecification variableSpecification = elementSpecification.getX();
        StyleAestheticSpecification styleAestheticSpecification = elementSpecification.getAestheticSpecifications();
        StyleCycleSpecification styleCycleSpecification = null;
        for (AestheticSpecification aestheticSpecification : styleAestheticSpecification) {
            if (!(aestheticSpecification instanceof StyleAestheticSpecification) || !aestheticSpecification.getVariable().equals(variableSpecification)) continue;
            styleCycleSpecification = ((StyleAestheticSpecification)aestheticSpecification).getStyleCycleSpecification();
            elementSpecification.remove((Specification)aestheticSpecification);
            break;
        }
        StyleAestheticSpecification styleAestheticSpecification2 = new StyleAestheticSpecification((VariableSpecification)sourceVariableSpecification);
        styleAestheticSpecification2.setStyleCycle(styleCycleSpecification);
        elementSpecification.addAesthetic((AestheticSpecification)styleAestheticSpecification2);
        elementSpecification.setX((VariableSpecification)sourceVariableSpecification);
    }

    private void setZClusterVar(ElementSpecification elementSpecification, SourceVariableSpecification sourceVariableSpecification) {
        VariableSpecification variableSpecification = elementSpecification.getZ();
        StyleAestheticSpecification styleAestheticSpecification = elementSpecification.getAestheticSpecifications();
        StyleCycleSpecification styleCycleSpecification = null;
        for (AestheticSpecification aestheticSpecification : styleAestheticSpecification) {
            if (!(aestheticSpecification instanceof StyleAestheticSpecification) || !aestheticSpecification.getVariable().equals(variableSpecification)) continue;
            styleCycleSpecification = ((StyleAestheticSpecification)aestheticSpecification).getStyleCycleSpecification();
            elementSpecification.remove((Specification)aestheticSpecification);
            break;
        }
        StyleAestheticSpecification styleAestheticSpecification2 = new StyleAestheticSpecification((VariableSpecification)sourceVariableSpecification);
        styleAestheticSpecification2.setStyleCycle(styleCycleSpecification);
        elementSpecification.addAesthetic((AestheticSpecification)styleAestheticSpecification2);
        elementSpecification.setZ((VariableSpecification)sourceVariableSpecification);
    }

    private void setupStyleCycle(ElementSpecification elementSpecification, StyleAestheticSpecification styleAestheticSpecification, boolean bl) {
        int n = -1;
        AestheticSpecification[] aestheticSpecificationArray = elementSpecification.getAestheticSpecifications();
        for (int i = 0; i < aestheticSpecificationArray.length; ++i) {
            if (!aestheticSpecificationArray[i].equals(styleAestheticSpecification)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            if (elementSpecification instanceof PointSpecification && this.isHiLoClose()) {
                this.mStyleCycler.setSimplePointCycle(styleAestheticSpecification);
            } else {
                this.mStyleCycler.setCycleForElement(elementSpecification, bl, n);
            }
        } else assert (false);
    }

    private boolean useColorsForNextStyleBy() {
        boolean bl = this.mStyleCycler.getUseColors();
        StyleAestheticSpecification[] styleAestheticSpecificationArray = (StyleAestheticSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(StyleAestheticSpecification.class);
        boolean bl2 = false;
        for (StyleAestheticSpecification styleAestheticSpecification : styleAestheticSpecificationArray) {
            String[] stringArray;
            StyleSpecification[] styleSpecificationArray;
            CycleSpecification[] cycleSpecificationArray;
            StyleCycleSpecification styleCycleSpecification = styleAestheticSpecification.getStyleCycleSpecification();
            if (styleCycleSpecification == null || (cycleSpecificationArray = styleCycleSpecification.getCycles()) == null || cycleSpecificationArray.length == 0 || (styleSpecificationArray = cycleSpecificationArray[0].getStyles()) == null || styleSpecificationArray.length == 0) continue;
            for (String string : stringArray = styleSpecificationArray[0].getAllValidKeys()) {
                if (bl) {
                    if (string.indexOf("color") <= -1 && !string.equals("fill") && !string.equals("stroke")) continue;
                    bl = false;
                    bl2 = true;
                    break;
                }
                if (string.indexOf("pattern") <= -1 && !string.equals("symbol") && string.indexOf("stroke-dasharray") <= -1) continue;
                bl = true;
                bl2 = true;
                break;
            }
            if (bl2) break;
        }
        return bl;
    }

    private void setCloseZoneVisibility(boolean bl) {
        PointSpecification pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class);
        StyleSpecification styleSpecification = pointSpecification.getStyle("");
        if (styleSpecification == null) {
            styleSpecification = new StyleSpecification();
            pointSpecification.setStyle(styleSpecification);
            this.addVizStyle(styleSpecification);
        }
        styleSpecification.setVisible(Boolean.valueOf(bl));
    }

    private VariableSpecification getVarForZone(ZoneType zoneType) {
        VariableSpecification variableSpecification = null;
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        if (elementSpecification == null) {
            return null;
        }
        AestheticSpecification[] aestheticSpecificationArray = elementSpecification.getAestheticSpecifications();
        if (zoneType.equals((Object)ZoneType.zt_cluster_x)) {
            variableSpecification = elementSpecification.getX();
        } else if (zoneType.equals((Object)ZoneType.zt_cluster_z)) {
            variableSpecification = elementSpecification.getZ();
        } else if (zoneType.equals((Object)ZoneType.zt_group)) {
            variableSpecification = this.getGroupingVarSpec(aestheticSpecificationArray);
        } else if (zoneType.equals((Object)ZoneType.zt_panel_horz)) {
            variableSpecification = this.getPanelingVarSpec(zoneType);
        } else if (zoneType.equals((Object)ZoneType.zt_panel_vert)) {
            variableSpecification = this.getPanelingVarSpec(zoneType);
        } else if (zoneType.equals((Object)ZoneType.zt_angle)) {
            variableSpecification = elementSpecification.getX();
        } else if (zoneType.equals((Object)ZoneType.zt_slice_by)) {
            variableSpecification = aestheticSpecificationArray[0].getVariable();
        } else if (zoneType.equals((Object)ZoneType.zt_x)) {
            variableSpecification = this.getXVarSpec(elementSpecification);
        } else if (zoneType.equals((Object)ZoneType.zt_y)) {
            variableSpecification = elementSpecification.getY();
        } else if (zoneType.equals((Object)ZoneType.zt_z)) {
            variableSpecification = this.getZVarSpec(elementSpecification);
        } else if (zoneType.equals((Object)ZoneType.zt_high)) {
            variableSpecification = elementSpecification.getY();
        } else if (zoneType.equals((Object)ZoneType.zt_low)) {
            variableSpecification = elementSpecification.getY();
        } else if (zoneType.equals((Object)ZoneType.zt_close)) {
            variableSpecification = elementSpecification.getY();
        } else if (zoneType.equals((Object)ZoneType.zt_dist_var)) {
            variableSpecification = elementSpecification.getX();
        }
        return variableSpecification;
    }

    private SourceVariableSpecification getXVarSpec(ElementSpecification elementSpecification) {
        SourceVariableSpecification sourceVariableSpecification = null;
        if (this.hasXCluster()) {
            DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 0);
            if (dimensionSpecification != null) {
                sourceVariableSpecification = (SourceVariableSpecification)dimensionSpecification.getClusterVariable();
            }
        } else {
            sourceVariableSpecification = (SourceVariableSpecification)elementSpecification.getX();
        }
        return sourceVariableSpecification;
    }

    private SourceVariableSpecification getZVarSpec(ElementSpecification elementSpecification) {
        SourceVariableSpecification sourceVariableSpecification = null;
        if (this.hasZCluster()) {
            DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 2);
            if (dimensionSpecification != null) {
                sourceVariableSpecification = (SourceVariableSpecification)dimensionSpecification.getClusterVariable();
            }
        } else {
            sourceVariableSpecification = (SourceVariableSpecification)elementSpecification.getZ();
        }
        return sourceVariableSpecification;
    }

    private SourceVariableSpecification getPanelingVarSpec(ZoneType zoneType) {
        SourceVariableSpecification sourceVariableSpecification = null;
        GraphSpecification graphSpecification = this.getGraphSpec();
        FacetingSpecification facetingSpecification = graphSpecification.getFacetingChild();
        if (facetingSpecification == null) {
            return sourceVariableSpecification;
        }
        Specification specification = facetingSpecification.getExpressionChild();
        if (!(specification instanceof CrossSpecification)) {
            return null;
        }
        CrossSpecification crossSpecification = (CrossSpecification)specification;
        Specification[] specificationArray = crossSpecification.getOperands();
        if (zoneType.equals((Object)ZoneType.zt_panel_horz)) {
            sourceVariableSpecification = specificationArray.length > 0 && specificationArray[0] instanceof VariableReferenceSpecification && ((VariableReferenceSpecification)specificationArray[0]).getReference() instanceof SourceVariableSpecification ? (SourceVariableSpecification)((VariableReferenceSpecification)specificationArray[0]).getReference() : null;
        } else if (zoneType.equals((Object)ZoneType.zt_panel_vert)) {
            sourceVariableSpecification = specificationArray.length > 1 && specificationArray[1] instanceof VariableReferenceSpecification && ((VariableReferenceSpecification)specificationArray[1]).getReference() instanceof SourceVariableSpecification ? (SourceVariableSpecification)((VariableReferenceSpecification)specificationArray[1]).getReference() : null;
        }
        return sourceVariableSpecification;
    }

    private SourceVariableSpecification getGroupingVarSpec(AestheticSpecification[] aestheticSpecificationArray) {
        int n = 0;
        if (this.hasXCluster() || this.hasZCluster()) {
            ++n;
        }
        if (aestheticSpecificationArray.length > n) {
            return (SourceVariableSpecification)aestheticSpecificationArray[n].getVariable();
        }
        return null;
    }

    private void handleAddZone(DropZone dropZone) {
        boolean bl;
        ZoneType zoneType = dropZone.getZoneType();
        boolean bl2 = bl = zoneType.equals((Object)ZoneType.zt_panel_horz) || zoneType.equals((Object)ZoneType.zt_panel_vert);
        if (!bl) {
            this.restructure(zoneType, dropZone, true);
        }
    }

    private void clearXandYAxisLabels() {
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = this.getIdentifierForZoneType(ZoneType.zt_x);
        extensionSpecification.put(string + "_label", null);
        string = this.getIdentifierForZoneType(ZoneType.zt_y);
        extensionSpecification.put(string + "_label", null);
    }

    private void handleRemoveZone(ZoneType zoneType) {
        PointSpecification pointSpecification;
        if (zoneType == ZoneType.zt_group && this.isDropLine() && (pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class)) != null) {
            this.updateDropLine(pointSpecification, false);
            ExtensionSpecification extensionSpecification = this.getElementExtension((ElementSpecification)pointSpecification);
            extensionSpecification.put("dropLine", "0");
        }
        this.restructure(zoneType, null, false);
    }

    private void restructure(ZoneType zoneType, DropZone dropZone, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = dropZone != null;
        if (zoneType.equals((Object)ZoneType.zt_panel_horz) || zoneType.equals((Object)ZoneType.zt_panel_vert) || zoneType.equals((Object)ZoneType.zt_filter)) {
            boolean bl4 = bl2 = dropZone != null && !dropZone.isEmpty();
            if (!bl2) {
                this.resetPctBase(bl);
            }
        }
        if (zoneType.equals((Object)ZoneType.zt_cluster_x)) {
            this.adjustXCluster(bl2);
        } else if (zoneType.equals((Object)ZoneType.zt_cluster_z)) {
            this.adjustZCluster(bl2);
        } else if (zoneType.equals((Object)ZoneType.zt_group)) {
            this.adjustGrouping(bl2);
        } else if (zoneType.equals((Object)ZoneType.zt_panel_horz)) {
            this.adjustHPanel(bl2);
        } else if (zoneType.equals((Object)ZoneType.zt_panel_vert)) {
            this.adjustVPanel(bl2);
        } else if (zoneType.equals((Object)ZoneType.zt_point_id)) {
            this.adjustPointId(bl2);
        } else if (zoneType.equals((Object)ZoneType.zt_filter)) {
            this.adjustFilterPanel(bl2);
        }
    }

    private void resetPctBase(boolean bl) {
        ChartProps chartProps = this.getProperties();
        Props.ElProps elProps = chartProps.getElementProp(0);
        if (elProps != null) {
            elProps.getStatistic().setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
            this.setProperties(chartProps, bl);
        }
    }

    private void adjustXCluster(boolean bl) {
        if (bl && this.hasXCluster() || !bl && !this.hasXCluster()) {
            return;
        }
        boolean bl2 = false;
        IntervalSpecification intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class);
        if (intervalSpecification == null) {
            intervalSpecification = (SchemaSpecification)this.getFirstSpecByClass(null, SchemaSpecification.class);
        }
        if (intervalSpecification == null && this.getPrimaryElementType() == Elements.point) {
            intervalSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class);
            bl2 = true;
        }
        if (intervalSpecification == null) {
            return;
        }
        DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 0);
        if (dimensionSpecification == null) {
            return;
        }
        StyleSpecification styleSpecification = intervalSpecification.getStyle("");
        VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
        if (bl) {
            PointSpecification pointSpecification;
            SourceVariableSpecification sourceVariableSpecification = new SourceVariableSpecification(this.generateSourceName(), (DataSpecification)this.getUserSource(), true);
            visualizationSpecification.addVariable((VariableSpecification)sourceVariableSpecification);
            StyleAestheticSpecification styleAestheticSpecification = new StyleAestheticSpecification((VariableSpecification)sourceVariableSpecification);
            intervalSpecification.addAesthetic((AestheticSpecification)styleAestheticSpecification);
            boolean bl3 = this.useColorsForNextStyleBy();
            this.setupStyleCycle((ElementSpecification)intervalSpecification, styleAestheticSpecification, bl3);
            if ((this.isHiLoClose() || this.getPrimaryElementType() == Elements.point) && (pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class)) != null) {
                styleAestheticSpecification = new StyleAestheticSpecification((VariableSpecification)sourceVariableSpecification);
                pointSpecification.addAesthetic((AestheticSpecification)styleAestheticSpecification);
                pointSpecification.setX((VariableSpecification)sourceVariableSpecification);
                this.setupStyleCycle((ElementSpecification)pointSpecification, styleAestheticSpecification, bl3);
            }
            dimensionSpecification.setClusterGap(new Length(15.0f, UnitType.PERCENT));
            dimensionSpecification.setClusterVariable(intervalSpecification.getX());
            intervalSpecification.setX((VariableSpecification)sourceVariableSpecification);
            if (!bl2) {
                styleSpecification.setWidth(new Length("100%"));
            }
        } else {
            AestheticSpecification[] aestheticSpecificationArray;
            for (AestheticSpecification aestheticSpecification : aestheticSpecificationArray = intervalSpecification.getAestheticSpecifications()) {
                PointSpecification pointSpecification;
                if (!aestheticSpecification.getVariable().equals(intervalSpecification.getX())) continue;
                VariableSpecification variableSpecification = dimensionSpecification.getClusterVariable();
                intervalSpecification.remove((Specification)aestheticSpecification);
                intervalSpecification.setX(variableSpecification);
                dimensionSpecification.setClusterGap(null);
                dimensionSpecification.setClusterVariable(null);
                if ((this.isHiLoClose() || this.getPrimaryElementType() == Elements.point) && (pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class)) != null && (aestheticSpecificationArray = pointSpecification.getAestheticSpecifications()).length > 0 && aestheticSpecificationArray[0] instanceof StyleAestheticSpecification) {
                    pointSpecification.remove((Specification)aestheticSpecificationArray[0]);
                    pointSpecification.setX(variableSpecification);
                }
                this.mStyleCycler.setBaseStyle(this.mCoordinates, (ElementSpecification)intervalSpecification, this.getElementType(this.mCoordinates, (ElementSpecification)intervalSpecification), this.mStyleCycler.getUseColors());
                break;
            }
            if (!bl2) {
                styleSpecification.setWidth(new Length("75%"));
            }
        }
    }

    private void adjustZCluster(boolean bl) {
        if (bl && this.hasZCluster() || !bl && !this.hasZCluster()) {
            return;
        }
        IntervalSpecification intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class);
        if (intervalSpecification == null) {
            return;
        }
        DimensionSpecification dimensionSpecification = (DimensionSpecification)this.getSpecByClass(null, DimensionSpecification.class, 2);
        if (dimensionSpecification == null) {
            return;
        }
        VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
        if (bl) {
            SourceVariableSpecification sourceVariableSpecification = new SourceVariableSpecification(this.generateSourceName(), (DataSpecification)this.getUserSource(), true);
            visualizationSpecification.addVariable((VariableSpecification)sourceVariableSpecification);
            StyleAestheticSpecification styleAestheticSpecification = new StyleAestheticSpecification((VariableSpecification)sourceVariableSpecification);
            intervalSpecification.addAesthetic((AestheticSpecification)styleAestheticSpecification);
            this.setupStyleCycle((ElementSpecification)intervalSpecification, styleAestheticSpecification, this.useColorsForNextStyleBy());
            dimensionSpecification.setClusterGap(new Length(15.0f, UnitType.PERCENT));
            dimensionSpecification.setClusterVariable(intervalSpecification.getZ());
            intervalSpecification.setZ((VariableSpecification)sourceVariableSpecification);
        } else {
            AestheticSpecification[] aestheticSpecificationArray;
            for (AestheticSpecification aestheticSpecification : aestheticSpecificationArray = intervalSpecification.getAestheticSpecifications()) {
                if (!aestheticSpecification.getVariable().equals(intervalSpecification.getZ())) continue;
                intervalSpecification.remove((Specification)aestheticSpecification);
                intervalSpecification.setZ(dimensionSpecification.getClusterVariable());
                dimensionSpecification.setClusterGap(null);
                dimensionSpecification.setClusterVariable(null);
                this.mStyleCycler.setBaseStyle(this.mCoordinates, (ElementSpecification)intervalSpecification, this.getElementType(this.mCoordinates, (ElementSpecification)intervalSpecification), this.mStyleCycler.getUseColors());
                break;
            }
        }
    }

    private void adjustGrouping(boolean bl) {
        VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
        SourceVariableSpecification sourceVariableSpecification = null;
        ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
        boolean bl2 = this.isOverlayScatter() ? this.mStyleCycler.getUseColors() : this.useColorsForNextStyleBy();
        boolean bl3 = false;
        for (ElementSpecification elementSpecification : elementSpecificationArray) {
            AestheticSpecification[] aestheticSpecificationArray;
            boolean bl4 = elementSpecification instanceof IntervalSpecification;
            if (elementSpecification instanceof PointSpecification) {
                bl3 = true;
            }
            if (bl3 && elementSpecification instanceof LineSpecification) continue;
            if (!bl && bl4 && this.isDropLine()) {
                elementSpecification.getParent().remove((Specification)elementSpecification);
                continue;
            }
            if (elementSpecification == this.getNormalCurve()) continue;
            boolean bl5 = bl4 || elementSpecification instanceof AreaSpecification;
            StyleAestheticSpecification styleAestheticSpecification = null;
            for (AestheticSpecification aestheticSpecification : aestheticSpecificationArray = elementSpecification.getAestheticSpecifications()) {
                VariableSpecification variableSpecification = aestheticSpecification.getVariable();
                if (elementSpecification.getX().equals(variableSpecification) || elementSpecification.getZ() != null && elementSpecification.getZ().equals(variableSpecification)) continue;
                styleAestheticSpecification = aestheticSpecification;
                sourceVariableSpecification = variableSpecification;
                break;
            }
            if (bl) {
                if (styleAestheticSpecification == null) {
                    if (sourceVariableSpecification == null) {
                        sourceVariableSpecification = this.createNewVariable();
                        sourceVariableSpecification.setCategorical(Boolean.valueOf(true));
                    }
                    styleAestheticSpecification = new StyleAestheticSpecification();
                    styleAestheticSpecification.setVariable((VariableSpecification)sourceVariableSpecification);
                    elementSpecification.addAesthetic((AestheticSpecification)styleAestheticSpecification);
                }
                this.setupStyleCycle(elementSpecification, styleAestheticSpecification, bl2);
                if (!bl5) continue;
                elementSpecification.setPositionModifier(PositionModifierType.STACK);
                continue;
            }
            if (styleAestheticSpecification != null) {
                styleAestheticSpecification.getParent().remove(styleAestheticSpecification);
                this.mStyleCycler.setBaseStyle(this.mCoordinates, elementSpecification, this.getElementType(this.mCoordinates, elementSpecification), this.mStyleCycler.getUseColors());
            }
            if (this.isSingleDimensionDotPlot()) continue;
            elementSpecification.setPositionModifier(null);
        }
    }

    private void adjustHPanel(boolean bl) {
        GraphSpecification graphSpecification = this.getGraphSpec();
        FacetingSpecification facetingSpecification = graphSpecification.getFacetingChild();
        if (bl) {
            if (facetingSpecification == null) {
                CrossSpecification crossSpecification = new CrossSpecification();
                facetingSpecification = new FacetingSpecification((ExpressionSpecification)crossSpecification);
                graphSpecification.setFacetingChild(facetingSpecification);
            }
        } else if (facetingSpecification != null) {
            if (this.hasVertPanels()) {
                CrossSpecification crossSpecification = (CrossSpecification)this.getFirstSpecByClass(null, CrossSpecification.class);
                crossSpecification.setA((ExpressionSpecification)new UnitySpecification());
            } else {
                facetingSpecification.getParent().remove((Specification)facetingSpecification);
            }
        }
        this.manageFacetLayout(graphSpecification, bl, 1);
    }

    private void adjustVPanel(boolean bl) {
        GraphSpecification graphSpecification = this.getGraphSpec();
        FacetingSpecification facetingSpecification = graphSpecification.getFacetingChild();
        if (bl) {
            if (facetingSpecification == null) {
                CrossSpecification crossSpecification = new CrossSpecification();
                crossSpecification.addOperand((ExpressionSpecification)new UnitySpecification());
                facetingSpecification = new FacetingSpecification((ExpressionSpecification)crossSpecification);
                graphSpecification.setFacetingChild(facetingSpecification);
            }
        } else if (facetingSpecification != null) {
            Specification[] specificationArray = facetingSpecification.findDescendantsOfType(VariableReferenceSpecification.class);
            if (specificationArray.length <= 1) {
                if (!this.isPopulationPyramid()) {
                    facetingSpecification.getParent().remove((Specification)facetingSpecification);
                }
            } else {
                specificationArray[1].getParent().remove(specificationArray[1]);
            }
        }
        this.manageFacetLayout(graphSpecification, bl, 2);
    }

    private void adjustFilterPanel(boolean bl) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        if (bl) {
            if (extensionSpecification == null) {
                extensionSpecification = new ExtensionSpecification();
                elementSpecification.addExtension(extensionSpecification);
            }
        } else if (extensionSpecification != null) {
            elementSpecification.remove((Specification)extensionSpecification);
        }
    }

    private void manageFacetLayout(GraphSpecification graphSpecification, boolean bl, Integer n) {
        FacetLayoutSpecification facetLayoutSpecification = graphSpecification.getFacetLayoutChild();
        if (bl) {
            if (this.getSpecByClassAndAttr((Specification)this.mVisualization.getSpecification(), FacetLevelSpecification.class, "level", n.toString()) != null) {
                return;
            }
            if (facetLayoutSpecification == null) {
                facetLayoutSpecification = new FacetLayoutSpecification();
                facetLayoutSpecification.setTopDown(Boolean.valueOf(false));
                graphSpecification.setFacetLayoutChild(facetLayoutSpecification);
            }
            FacetLevelSpecification facetLevelSpecification = new FacetLevelSpecification(n);
            facetLayoutSpecification.addFacetLevel(facetLevelSpecification);
            facetLevelSpecification.setGap(new Length(10.0f, UnitType.PERCENT));
            AxisSpecification axisSpecification = new AxisSpecification(true);
            facetLevelSpecification.addAxis(axisSpecification);
            axisSpecification.setOpposite(Boolean.valueOf(true));
            axisSpecification.setRepeatMethod(AxisRepeatType.NEVER);
        } else if (facetLayoutSpecification != null) {
            boolean bl2;
            boolean bl3 = bl2 = n == 2 && this.isPopulationPyramid();
            if (!bl2 && !this.hasVertPanels()) {
                facetLayoutSpecification.getParent().remove((Specification)facetLayoutSpecification);
            } else {
                Specification specification = this.getSpecByClassAndAttr((Specification)facetLayoutSpecification, FacetLevelSpecification.class, "level", n.toString());
                if (specification != null) {
                    specification.getParent().remove(specification);
                }
            }
        }
    }

    private void adjustPointId(boolean bl) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        if (elementSpecification == null) {
            return;
        }
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = extensionSpecification.get("flags");
        int n = string == null || string.length() == 0 ? 0 : Integer.valueOf(string);
        n = bl ? (n |= 0x20) : (n &= 0xFFFFFFDF);
        extensionSpecification.put("flags", Integer.toString(n));
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_point_id);
        if (bl && dropZone == null) {
            this.mCanvas.getZoneMgr().addZone(this.mCanvas, ZoneType.zt_point_id);
        } else if (!bl && dropZone != null) {
            this.mCanvas.getZoneMgr().removeZone(ZoneType.zt_point_id);
        }
    }

    private void clearVarForZoneType(ZoneType zoneType) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        if (elementSpecification == null) {
            return;
        }
        if (zoneType == ZoneType.zt_x) {
            elementSpecification.setX(null);
        } else if (zoneType == ZoneType.zt_y) {
            elementSpecification.setY(null);
        } else if (zoneType == ZoneType.zt_z) {
            elementSpecification.setZ(null);
        }
    }

    private ElementSpecification createElement(Elements elements) {
        AreaSpecification areaSpecification;
        GraphSpecification graphSpecification = this.getGraphSpec();
        if (elements == Elements.area) {
            areaSpecification = new AreaSpecification();
            areaSpecification.setPositionModifier(PositionModifierType.STACK);
        } else if (elements == Elements.diff_area) {
            areaSpecification = new AreaSpecification();
            areaSpecification.setPositionModifier(PositionModifierType.MINUS_INTERSECTION);
            areaSpecification.setBreakRepresentation(BreakRepresentationType.WINGS);
        } else if (elements == Elements.hilo) {
            areaSpecification = new IntervalSpecification();
        } else if (elements == Elements.interval) {
            areaSpecification = new IntervalSpecification();
        } else if (elements == Elements.line) {
            areaSpecification = new LineSpecification();
        } else if (elements == Elements.point) {
            areaSpecification = new PointSpecification();
            if (this.mCoordinates == Coords.coords_1D) {
                areaSpecification.setPositionModifier(PositionModifierType.PILE);
            }
        } else if (elements == Elements.polar_interval) {
            areaSpecification = new IntervalSpecification();
            areaSpecification.setPositionModifier(PositionModifierType.STACK);
        } else if (elements == Elements.pyramid) {
            areaSpecification = new IntervalSpecification();
        } else if (elements == Elements.schema) {
            areaSpecification = new SchemaSpecification();
            areaSpecification.addStatistic((StatisticSpecification)new TukeyStatisticSpecification());
        } else if (elements == Elements.splom) {
            areaSpecification = new PointSpecification();
            areaSpecification.setLabelCollisionHandling(LabelCollisionHandlingType.NORMAL);
            areaSpecification.setShowCollidingLabels(Boolean.valueOf(false));
            areaSpecification.setCoordinates((CoordinatesSpecification)this.getFirstSpecByClass(null, CoordinatesSpecification.class));
        } else {
            assert (false);
            return null;
        }
        graphSpecification.addElement((ElementSpecification)areaSpecification);
        if (this.mCoordinates == Coords.coords_DualY) {
            this.setupDualYAxisAssociations();
        }
        this.mStyleCycler.setBaseStyle(this.mCoordinates, (ElementSpecification)areaSpecification, elements, this.mStyleCycler.getUseColors());
        return areaSpecification;
    }

    private GraphSpecification getGraphSpec() {
        return (GraphSpecification)this.getFirstSpecByClass(null, GraphSpecification.class);
    }

    private ExtensionSpecification getVariableExtension(VariableSpecification variableSpecification) {
        ExtensionSpecification extensionSpecification;
        ExtensionSpecification[] extensionSpecificationArray = variableSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length == 0) {
            extensionSpecification = new ExtensionSpecification();
            variableSpecification.addExtension(extensionSpecification);
        } else {
            extensionSpecification = extensionSpecificationArray[0];
        }
        return extensionSpecification;
    }

    private ExtensionSpecification getTitlesExtension() {
        ExtensionSpecification extensionSpecification;
        VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
        ExtensionSpecification[] extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length == 0) {
            extensionSpecification = new ExtensionSpecification();
            visualizationSpecification.addExtension(extensionSpecification);
        } else {
            extensionSpecification = extensionSpecificationArray[0];
        }
        return extensionSpecification;
    }

    private String getTitleKey(ITitles.TitleType titleType) {
        String string = "";
        if (titleType == ITitles.TitleType.title1) {
            string = "Title1";
        } else if (titleType == ITitles.TitleType.title2) {
            string = "Title2";
        } else if (titleType == ITitles.TitleType.subTitle1) {
            string = "Subtitle";
        } else if (titleType == ITitles.TitleType.footnote1) {
            string = "Footnote1";
        } else if (titleType == ITitles.TitleType.footnote2) {
            string = "Footnote2";
        }
        return string;
    }

    private void makeXScale(boolean bl) {
        ElementSpecification[] elementSpecificationArray;
        VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
        for (ElementSpecification elementSpecification : elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class)) {
            FormatSpecification formatSpecification;
            VariableSpecification variableSpecification = elementSpecification.getX();
            if (!(variableSpecification instanceof SourceVariableSpecification)) continue;
            variableSpecification.setCategorical(Boolean.valueOf(!bl));
            this.removeDomain((SourceVariableSpecification)variableSpecification);
            if (!bl || (formatSpecification = variableSpecification.getDisplayFormatChild()) == null) continue;
            formatSpecification.getParent().remove((Specification)formatSpecification);
        }
    }

    private UserSourceSpecification getUserSource() {
        return (UserSourceSpecification)this.getFirstSpecByClass(null, UserSourceSpecification.class);
    }

    private String generateSourceName() {
        String string;
        int n = 1;
        String string2 = "SRC_";
        while (this.getSpecByClassAndAttr(null, SourceVariableSpecification.class, "sourceName", string = string2 + Integer.toString(n++)) != null) {
        }
        return string;
    }

    private Coords determineCoordinates() {
        Coords coords = Coords.coords_none;
        if (!this.isEmpty()) {
            VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
            CoordinatesSpecification coordinatesSpecification = (CoordinatesSpecification)this.getFirstSpecByClass((Specification)visualizationSpecification, CoordinatesSpecification.class);
            if (coordinatesSpecification == null) {
                return coords;
            }
            Specification[] specificationArray = coordinatesSpecification.findDescendantsOfType(PolarTransformSpecification.class);
            if (specificationArray != null && specificationArray.length > 0) {
                coords = Coords.coords_Polar;
            } else {
                int n = 0;
                int n2 = 0;
                for (Specification specification : specificationArray = visualizationSpecification.findDescendantsOfType(DimensionSpecification.class)) {
                    Specification[] specificationArray2 = specification.findDescendantsOfType(AxisSpecification.class);
                    if (specificationArray2 == null || specificationArray2.length <= 0) continue;
                    ++n;
                    n2 += specificationArray2.length;
                }
                if (n == 1) {
                    coords = Coords.coords_1D;
                } else if (n == 2) {
                    coords = n2 == 3 ? (this.isPopulationPyramid() ? Coords.coords_2D : Coords.coords_DualY) : Coords.coords_2D;
                } else if (n == 3) {
                    coords = Coords.coords_3D;
                } else assert (false);
            }
        }
        return coords;
    }

    private void cleanupSpec() {
        this.cleanupDomains();
        this.cleanupStyles();
        this.cleanupStyleCycles();
    }

    private void cleanupDomains() {
        if (this.mVisualization != null) {
            DomainSpecification[] domainSpecificationArray;
            for (DomainSpecification domainSpecification : domainSpecificationArray = this.mVisualization.getSpecification().getDomainSpecifications()) {
                Specification[] specificationArray = this.mVisualization.getSpecification().getReferencesTo(domainSpecification.getId());
                if (specificationArray.length != 0) continue;
                ComponentState.trace1((String)("Orphan domain: " + domainSpecification.getId()), (int)15);
                domainSpecification.getParent().remove((Specification)domainSpecification);
            }
        }
    }

    private void cleanupStyleCycles() {
        StyleCycleSpecification[] styleCycleSpecificationArray;
        for (StyleCycleSpecification styleCycleSpecification : styleCycleSpecificationArray = this.mVisualization.getSpecification().getStyleCycleSpecifications()) {
            Specification[] specificationArray = this.mVisualization.getSpecification().getReferencesTo(styleCycleSpecification.getId());
            if (specificationArray.length != 0) continue;
            ComponentState.trace1((String)("Orphan styleCycle: " + styleCycleSpecification.getId()), (int)15);
            styleCycleSpecification.getParent().remove((Specification)styleCycleSpecification);
        }
    }

    private void cleanupStyles() {
        StyleSpecification[] styleSpecificationArray;
        if (this.mVisualization == null) {
            return;
        }
        for (StyleSpecification styleSpecification : styleSpecificationArray = this.mVisualization.getSpecification().getStyleSpecifications()) {
            Specification[] specificationArray;
            if (styleSpecification.getChildren().length > 0 || (specificationArray = this.mVisualization.getSpecification().getReferencesTo(styleSpecification.getId())).length != 0 && (specificationArray.length != 1 || !(specificationArray[0] instanceof StyleSpecification))) continue;
            ComponentState.trace1((String)("Orphan style: " + styleSpecification.getId()), (int)15);
            styleSpecification.getParent().remove((Specification)styleSpecification);
        }
    }

    private Specification getFirstSpecByClass(Specification specification, Class<? extends Specification> clazz) {
        specification = specification == null ? this.mVisualization.getSpecification() : specification;
        Specification[] specificationArray = specification.findDescendantsOfType(clazz);
        return specificationArray == null || specificationArray.length == 0 ? null : specificationArray[0];
    }

    private Specification getSpecByClass(Specification specification, Class<? extends Specification> clazz, int n) {
        Specification[] specificationArray = (specification = specification == null ? this.mVisualization.getSpecification() : specification).findDescendantsOfType(clazz);
        if (specificationArray.length > n) {
            return specificationArray[n];
        }
        return null;
    }

    private Specification getSpecByClassAndAttr(Specification specification, Class<? extends Specification> clazz, String string, String string2) {
        return this.getSpecByClassAndAttr(specification, clazz, string, string2, 0);
    }

    private Specification getSpecByClassAndAttr(Specification specification, Class<? extends Specification> clazz, String string, String string2, int n) {
        Specification[] specificationArray;
        int n2 = 0;
        Specification specification2 = null;
        specification = specification == null ? this.mVisualization.getSpecification() : specification;
        for (Specification specification3 : specificationArray = specification.findDescendantsOfType(clazz)) {
            Attribute attribute;
            if (!(specification3 instanceof AbstractSpecification) || (attribute = ((AbstractSpecification)specification3).getAttribute(string)) == null || !attribute.toString().equals(string2) || n != n2++) continue;
            specification2 = specification3;
            break;
        }
        return specification2;
    }

    private ExtensionSpecification getGraphExtension() {
        ExtensionSpecification extensionSpecification;
        GraphSpecification graphSpecification = this.getGraphSpec();
        ExtensionSpecification[] extensionSpecificationArray = graphSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length == 0) {
            extensionSpecification = new ExtensionSpecification();
            graphSpecification.addExtension(extensionSpecification);
        } else {
            extensionSpecification = extensionSpecificationArray[0];
        }
        return extensionSpecification;
    }

    private ExtensionSpecification getElementExtension(ElementSpecification elementSpecification) {
        ExtensionSpecification extensionSpecification;
        ExtensionSpecification[] extensionSpecificationArray = elementSpecification.getExtensionSpecifications();
        if (extensionSpecificationArray.length == 0) {
            extensionSpecification = new ExtensionSpecification();
            elementSpecification.addExtension(extensionSpecification);
        } else {
            extensionSpecification = extensionSpecificationArray[0];
        }
        return extensionSpecification;
    }

    private void dispatchProperty(Props props, boolean bl) {
        if (props instanceof Props.ElProps) {
            this.dispatchElementProperty((Props.ElProps)props, bl);
        } else if (props instanceof Props.AxisProps) {
            if (props instanceof Props.PanelProps && ((Props.PanelProps)props).getZoneType() == ZoneType.zt_filter) {
                this.dispatchCatAxisProperties((Props.CatAxisProps)props);
                return;
            }
            this.dispatchAxisProperty((Props.AxisProps)props);
        } else if (props instanceof Props.TitleProps) {
            this.dispatchTitleProperty((Props.TitleProps)props);
        }
    }

    private void dispatchElementProperty(Props.ElProps elProps, boolean bl) {
        this.setElementProp(elProps);
        if (elProps instanceof Props.BarProps) {
            this.setBarProp((Props.BarProps)elProps);
        } else if (elProps instanceof Props.LineProps || elProps instanceof Props.AreaProps) {
            this.setInterpolationStyles(elProps);
        } else if (elProps instanceof Props.PointProps) {
            this.setPointProp((Props.PointProps)elProps);
        } else if (elProps instanceof Props.HiLoCloseProps) {
            this.setHiLoCloseProp((Props.HiLoCloseProps)elProps);
        } else if (elProps instanceof Props.PyramidProps) {
            this.setPyramidProp((Props.PyramidProps)elProps);
        } else if (elProps instanceof Props.MatrixProps) {
            this.setMatrixProp((Props.MatrixProps)elProps);
        }
        if (bl) {
            this.setDefaultStyles();
        }
    }

    private void setElementProp(Props.ElProps elProps) {
        Object object;
        Object object2;
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", elProps.getStrElId());
        if (elementSpecification == null) {
            return;
        }
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        int n = elProps.getFlags();
        boolean bl = (n & 0x10) != 0;
        String string = String.format("%d", n);
        extensionSpecification.put("flags", string);
        IPropEnum.ErrorIntervalType errorIntervalType = elProps.getErrorIntervalType();
        int n2 = errorIntervalType == IPropEnum.ErrorIntervalType.eit_MultStdError ? 2 : (errorIntervalType == IPropEnum.ErrorIntervalType.eit_MultStdDev ? 1 : 0);
        extensionSpecification.put("errorIntervalType", Integer.toString(n2));
        double d = elProps.getLevel();
        extensionSpecification.put("errorIntervalPct", Double.toString(d));
        d = elProps.getMultiplierStdError();
        extensionSpecification.put("errorIntervalMultStdError", Double.toString(d));
        d = elProps.getMultiplierStdDev();
        extensionSpecification.put("errorIntervalMultStdDev", Double.toString(d));
        if (this.hasSSVs()) {
            this.setSSVStatistics(elementSpecification, elProps);
        } else {
            this.setStatistics(elementSpecification, elProps);
        }
        if (this.mCoordinates == Coords.coords_DualY) {
            object2 = elProps.getStrElAssoc();
            object = this.getGraphExtension();
            String string2 = String.format("AxisY%s_assoc", object2);
            object.put(string2, elementSpecification.getId());
        }
        if (!this.isHiLoClose()) {
            this.manageErrorBars(elementSpecification, bl);
        }
        object2 = this.mCoordinates == Coords.coords_DualY ? ((object = elProps.getStrElAssoc()) != null && ((String)object).equals("2") ? ZoneType.zt_y2 : ZoneType.zt_y) : this.getDepZoneType();
        if (object2 != null) {
            this.updateZoneLabel((ZoneType)((Object)object2));
        }
    }

    private void manageErrorBars(ElementSpecification elementSpecification, boolean bl) {
        ExtensionSpecification extensionSpecification = (ExtensionSpecification)this.getSpecByClassAndAttr(null, ExtensionSpecification.class, RANGE_KEY, elementSpecification.getId(), 0);
        ExtensionSpecification extensionSpecification2 = (ExtensionSpecification)this.getSpecByClassAndAttr(null, ExtensionSpecification.class, RANGE_KEY, elementSpecification.getId(), 1);
        GraphSpecification graphSpecification = this.getGraphSpec();
        if (bl) {
            StyleAestheticSpecification styleAestheticSpecification;
            ExtensionSpecification extensionSpecification3;
            Color color;
            if (extensionSpecification != null) {
                return;
            }
            IntervalSpecification intervalSpecification = new IntervalSpecification();
            graphSpecification.addElement((ElementSpecification)intervalSpecification);
            intervalSpecification.setX(elementSpecification.getX());
            if (this.mCoordinates == Coords.coords_3D) {
                intervalSpecification.setZ(elementSpecification.getZ());
            }
            SummaryStatisticSpecification summaryStatisticSpecification = new SummaryStatisticSpecification(SummaryType.RANGE);
            summaryStatisticSpecification.setBase(SummaryBaseType.COORDINATE);
            intervalSpecification.addStatistic((StatisticSpecification)summaryStatisticSpecification);
            StyleSpecification styleSpecification = new StyleSpecification();
            intervalSpecification.getTop().addStyle(styleSpecification);
            intervalSpecification.setStyle("", styleSpecification);
            if (this.mCoordinates == Coords.coords_DualY) {
                int n = this.dualYElementWithFirstYAxis(elementSpecification) ? 0 : 1;
                color = this.mStyleCycler.getDualYAxisColor(n);
            } else {
                color = Color.black;
            }
            styleSpecification.setColor(color);
            styleSpecification.setDepth(new Length("75%"));
            styleSpecification.setSymbol(SymbolType.IBEAM);
            styleSpecification.setWidth(new Length("25%"));
            if (!(elementSpecification instanceof IntervalSpecification) && (extensionSpecification3 = elementSpecification.getAestheticSpecifications()) != null && ((AestheticSpecification[])extensionSpecification3).length > 0 && extensionSpecification3[0] instanceof StyleAestheticSpecification) {
                StyleAestheticSpecification styleAestheticSpecification2 = (StyleAestheticSpecification)extensionSpecification3[0];
                styleAestheticSpecification = new StyleAestheticSpecification(styleAestheticSpecification2.getVariable());
                styleAestheticSpecification.setStyleCycle(styleAestheticSpecification2.getStyleCycleSpecification());
                intervalSpecification.addAesthetic((AestheticSpecification)styleAestheticSpecification);
            }
            SourceVariableSpecification sourceVariableSpecification = this.createNewVariable();
            sourceVariableSpecification.setCategorical(Boolean.valueOf(false));
            extensionSpecification3 = this.getVariableExtension((VariableSpecification)sourceVariableSpecification);
            extensionSpecification3.put(RANGE_KEY, elementSpecification.getId());
            extensionSpecification3.put(LOW_RANGE_KEY, "low");
            styleAestheticSpecification = this.createNewVariable();
            styleAestheticSpecification.setCategorical(Boolean.valueOf(false));
            extensionSpecification3 = this.getVariableExtension((VariableSpecification)styleAestheticSpecification);
            extensionSpecification3.put(RANGE_KEY, elementSpecification.getId());
            extensionSpecification3.put(HIGH_RANGE_KEY, "high");
            String string = sourceVariableSpecification.getId() + " + " + styleAestheticSpecification.getId();
            ExpressionVariableSpecification expressionVariableSpecification = new ExpressionVariableSpecification(string, Boolean.valueOf(false));
            this.mVisualization.getSpecification().addVariable((VariableSpecification)expressionVariableSpecification);
            intervalSpecification.setY((VariableSpecification)expressionVariableSpecification);
        } else {
            ExpressionVariableSpecification[] expressionVariableSpecificationArray;
            if (extensionSpecification == null || extensionSpecification2 == null) {
                return;
            }
            String string = null;
            ExpressionVariableSpecification expressionVariableSpecification = null;
            for (ExpressionVariableSpecification expressionVariableSpecification2 : expressionVariableSpecificationArray = (ExpressionVariableSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ExpressionVariableSpecification.class)) {
                String string2 = expressionVariableSpecification2.getExpression();
                if (string2.indexOf(extensionSpecification.getParent().getId()) <= -1) continue;
                string = expressionVariableSpecification2.getId();
                expressionVariableSpecification = expressionVariableSpecification2;
                break;
            }
            extensionSpecification.getParent().getParent().remove(extensionSpecification.getParent());
            extensionSpecification2.getParent().getParent().remove(extensionSpecification2.getParent());
            if (expressionVariableSpecification != null) {
                expressionVariableSpecification.getParent().remove((Specification)expressionVariableSpecification);
            }
            if (string == null) {
                return;
            }
            this.takeOutElementsWithYVar(string);
        }
        this.mSources = null;
    }

    private void takeOutElementsWithYVar(String string) {
        ElementSpecification[] elementSpecificationArray;
        for (ElementSpecification elementSpecification : elementSpecificationArray = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
            if (!elementSpecification.getY().getId().equals(string)) continue;
            elementSpecification.getParent().remove((Specification)elementSpecification);
        }
    }

    private void setSSVStatistics(ElementSpecification elementSpecification, Props.ElProps elProps) {
        this.removeSSVVariables();
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        Vector<ElementStat> vector = elProps.getSSVData().getSSVVariables();
        extensionSpecification.put("SSVCount", Integer.toString(vector.size()));
        for (int i = 0; i < vector.size(); ++i) {
            ElementStat elementStat = vector.get(i);
            String string = String.format("SSVStat_%d", i);
            String string2 = String.format("%d;%d", elementStat.getStat().value(), elementStat.getPctBaseType().ordinal());
            extensionSpecification.put(string, string2);
            string = String.format("SSVParm1_%d", i);
            extensionSpecification.put(string, elementStat.getStrParm1());
            string = String.format("SSVParm2_%d", i);
            extensionSpecification.put(string, elementStat.getStrParm2());
            string = String.format("SSVVar_%d", i);
            extensionSpecification.put(string, elementStat.getVariable().getName());
        }
    }

    private void setStatistics(ElementSpecification elementSpecification, Props.ElProps elProps) {
        StringTokenizer stringTokenizer;
        ElementStat elementStat = elProps.getStatistic();
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = "0";
        String string2 = "0";
        String string3 = extensionSpecification.get("statistics");
        if (string3 != null && string3.length() > 0 && (stringTokenizer = new StringTokenizer(string3, ";", false)).hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
        }
        string3 = String.format("%s;%s;%s;%s", string, string2, elementStat.getStat().value(), Integer.toString(elementStat.getPctBaseType().ordinal()));
        extensionSpecification.put("statistics", string3);
        extensionSpecification.put("endParm1", elementStat.getStrParm1());
        extensionSpecification.put("endParm2", elementStat.getStrParm2());
        extensionSpecification.put("endAnchorType", Integer.toString(elementStat.getAnchorType()));
        extensionSpecification.put("endBinSizeType", Integer.toString(elementStat.getBinSize()));
        extensionSpecification.put("endBinSizeCustom", Integer.toString(elementStat.getBinSizeCustom()));
        extensionSpecification.put("endDisplayNormalCurve", elementStat.getDisplayNormalCurve() ? "1" : "0");
        this.manageNormalCurve(elementSpecification, elementStat);
    }

    private void checkDualYElementSwaps(ChartProps chartProps) {
        ElementSpecification elementSpecification = null;
        ElementSpecification elementSpecification2 = null;
        ExtensionSpecification extensionSpecification = this.getGraphExtension();
        for (Props props : chartProps.getProperties()) {
            if (!(props instanceof Props.ElProps)) continue;
            if (elementSpecification == null && (props.getFlags() & 0x40) != 0) {
                elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", props.getStrElId());
                props.setFlags(props.getFlags() & 0xFFFFFFBF);
            } else if (elementSpecification != null && (props.getFlags() & 0x40) != 0) {
                elementSpecification2 = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", props.getStrElId());
                props.setFlags(props.getFlags() & 0xFFFFFFBF);
            }
            String string = props.getStrElAssoc();
            String string2 = string == null || !string.equals("2") ? AXIS1_ASSOC_KEY : AXIS2_ASSOC_KEY;
            extensionSpecification.put(string2, props.getStrElId());
        }
        if (elementSpecification == null || elementSpecification2 == null) {
            return;
        }
        GraphSpecification graphSpecification = this.getGraphSpec();
        graphSpecification.remove(elementSpecification);
        graphSpecification.addElement(elementSpecification);
    }

    private LineSpecification getNormalCurve() {
        LineSpecification[] lineSpecificationArray;
        LineSpecification lineSpecification = null;
        for (LineSpecification lineSpecification2 : lineSpecificationArray = (LineSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(LineSpecification.class)) {
            if (this.getFirstSpecByClass((Specification)lineSpecification2, DistributionStatisticSpecification.class) == null) continue;
            lineSpecification = lineSpecification2;
            break;
        }
        return lineSpecification;
    }

    private void manageNormalCurve(ElementSpecification elementSpecification, ElementStat elementStat) {
        Specification specification = this.getFirstSpecByClass((Specification)elementSpecification, BinStatisticSpecification.class);
        LineSpecification lineSpecification = this.getNormalCurve();
        boolean bl = elementStat.getStat() == Statistics.Histogram || elementStat.getStat() == Statistics.HistogramPct;
        boolean bl2 = this.isPopulationPyramid();
        if (bl || bl2) {
            StyleSpecification styleSpecification;
            if (specification == null) {
                styleSpecification = new BinStatisticSpecification(GridType.SQUARE);
                elementSpecification.addStatistic((StatisticSpecification)styleSpecification);
            }
            if ((styleSpecification = elementSpecification.getStyle("")) != null && !(elementSpecification instanceof LineSpecification)) {
                styleSpecification.setWidth(new Length("100%"));
            }
            if (lineSpecification == null) {
                lineSpecification = new LineSpecification();
                GraphSpecification graphSpecification = this.getGraphSpec();
                graphSpecification.addElement((ElementSpecification)lineSpecification);
                lineSpecification.addStatistic((StatisticSpecification)new DistributionStatisticSpecification(DistributionType.NORMAL));
                lineSpecification.setX(elementSpecification.getX());
                lineSpecification.setY(elementSpecification.getY());
                this.mSources = null;
            }
            if ((styleSpecification = lineSpecification.getStyle("")) == null) {
                styleSpecification = new StyleSpecification();
                this.addVizStyle(styleSpecification);
                lineSpecification.setStyle("", styleSpecification);
            }
            boolean bl3 = elementStat.getDisplayNormalCurve();
            if (bl2) {
                boolean bl4;
                ISpssVariable iSpssVariable = this.getSpssVarForZone(ZoneType.zt_dist_var);
                bl3 = bl3 && (iSpssVariable == null || iSpssVariable.getDisplayMeasurementLevel() == MeasurementLevel.scale);
                boolean bl5 = bl4 = iSpssVariable == null || iSpssVariable.getDisplayMeasurementLevel() == MeasurementLevel.scale;
                if (bl4) {
                    this.removeErrorBars(elementSpecification.getId());
                    ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
                    int n = 0;
                    String string = extensionSpecification.get("flags");
                    if (string != null && string.length() > 0) {
                        n = Integer.valueOf(string);
                    }
                    extensionSpecification.put("flags", Integer.toString(n &= 0xFFFFFFEF));
                }
            }
            styleSpecification.setVisible(Boolean.valueOf(bl3));
            this.removeDomain((SourceVariableSpecification)elementSpecification.getX());
        } else {
            if (specification != null) {
                specification.getParent().remove(specification);
            }
            if (lineSpecification != null) {
                lineSpecification.getParent().remove((Specification)lineSpecification);
                this.mSources = null;
            }
        }
    }

    private boolean isElementModified(ChartProps chartProps) {
        for (Props props : chartProps.getProperties()) {
            if (!(props instanceof Props.ElProps) || !props.isModified()) continue;
            return true;
        }
        return false;
    }

    private void setDualYColors(ChartProps chartProps) {
        for (Props props : chartProps.getProperties()) {
            if (!(props instanceof Props.ElProps)) continue;
            ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", props.getStrElId());
            this.mStyleCycler.setBaseStyle(this.mCoordinates, elementSpecification, this.getElementType(this.mCoordinates, elementSpecification), true);
        }
    }

    private void setBarProp(Props.BarProps barProps) {
        IntervalSpecification intervalSpecification = (IntervalSpecification)this.getSpecByClassAndAttr(null, IntervalSpecification.class, "id", barProps.getStrElId());
        StyleSpecification styleSpecification = intervalSpecification.getStyle("");
        this.setIntervalStyle(styleSpecification, barProps.getIntervalStyle());
    }

    private void setIntervalStyle(StyleSpecification styleSpecification, IPropEnum.IntervalStyle intervalStyle) {
        SymbolType symbolType;
        if (intervalStyle == IPropEnum.IntervalStyle.is_Square) {
            symbolType = SymbolType.SQUARE;
        } else if (intervalStyle == IPropEnum.IntervalStyle.is_IBeam) {
            symbolType = SymbolType.IBEAM;
        } else if (intervalStyle == IPropEnum.IntervalStyle.is_Line) {
            symbolType = SymbolType.LINE;
        } else {
            return;
        }
        styleSpecification.setSymbol(symbolType);
    }

    private void setPointProp(Props.PointProps pointProps) {
        boolean bl;
        int n;
        PointSpecification pointSpecification = (PointSpecification)this.getSpecByClassAndAttr(null, PointSpecification.class, "id", pointProps.getStrElId());
        ExtensionSpecification extensionSpecification = this.getElementExtension((ElementSpecification)pointSpecification);
        extensionSpecification.put("stackIdentical", pointProps.getStackIdentical() ? "1" : "0");
        extensionSpecification.put("canHaveFitline", pointProps.canHaveRegressionLine() ? "1" : "0");
        extensionSpecification.put("hasTotalFitline", pointProps.hasTotalRegressionLine() ? "1" : "0");
        extensionSpecification.put("hasSubgroupFitline", pointProps.hasSubgroupRegressionLine() ? "1" : "0");
        IPropEnum.PlotShape plotShape = pointProps.getPlotShape();
        if (plotShape == IPropEnum.PlotShape.ps_Asymmetric) {
            pointSpecification.setPositionModifier(PositionModifierType.PILE);
        } else if (plotShape == IPropEnum.PlotShape.ps_Symmetric) {
            pointSpecification.setPositionModifier(PositionModifierType.DODGE);
        } else if (plotShape == IPropEnum.PlotShape.ps_Flat) {
            pointSpecification.setPositionModifier(null);
        }
        extensionSpecification.put("dropLine", pointProps.getHasDropLine() ? "1" : "0");
        this.updateDropLine(pointSpecification, pointProps.getHasDropLine());
        StringBuffer stringBuffer = new StringBuffer();
        YXPairs yXPairs = pointProps.getYXPairs();
        for (n = 0; n < yXPairs.getCount(); ++n) {
            stringBuffer.append(yXPairs.get(n));
            if (n >= yXPairs.getCount() - 1) continue;
            stringBuffer.append(";");
        }
        extensionSpecification.put("YXpairs", stringBuffer.toString());
        if (pointProps.getStatistic().getStat() != Statistics.Value && this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_point_id)) {
            this.adjustPointId(false);
        }
        n = this.mCanvas.getZoneMgr().hasScaleVar(ZoneType.zt_x) ? 1 : 0;
        boolean bl2 = this.hasXCluster();
        boolean bl3 = this.hasGrouping();
        boolean bl4 = bl = (pointProps.getFlags() & 0x10) != 0;
        if (bl2 && !bl) {
            ISpssVariable iSpssVariable = this.getSpssVarForZone(ZoneType.zt_cluster_x);
            this.mCanvas.getZoneMgr().removeZone(ZoneType.zt_cluster_x);
            this.adjustXCluster(false);
            this.mCanvas.getZoneMgr().addZone(this.mCanvas, ZoneType.zt_group);
            this.adjustGrouping(true);
            DropZone dropZone = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_group);
            dropZone.setUsesColorStyling(this.getUsesColorForStyleByType(ZoneType.zt_group));
            if (iSpssVariable != null) {
                dropZone.dropVars(new ISpssVariable[]{iSpssVariable});
            }
        } else if (bl3 && bl && n == 0) {
            ISpssVariable iSpssVariable = this.getSpssVarForZone(ZoneType.zt_group);
            this.mCanvas.getZoneMgr().removeZone(ZoneType.zt_group);
            this.adjustGrouping(false);
            this.mCanvas.getZoneMgr().addZone(this.mCanvas, ZoneType.zt_cluster_x);
            this.adjustXCluster(true);
            if (iSpssVariable != null) {
                this.mCanvas.getZoneMgr().getZone(ZoneType.zt_cluster_x).dropVars(new ISpssVariable[]{iSpssVariable});
            }
        }
    }

    private void updateDropLine(PointSpecification pointSpecification, boolean bl) {
        if (this.isDropLine() == bl) {
            return;
        }
        if (bl) {
            IntervalSpecification intervalSpecification = new IntervalSpecification();
            SummaryStatisticSpecification summaryStatisticSpecification = new SummaryStatisticSpecification(SummaryType.RANGE);
            intervalSpecification.addStatistic((StatisticSpecification)summaryStatisticSpecification);
            intervalSpecification.setX(pointSpecification.getX());
            intervalSpecification.setY(pointSpecification.getY());
            StyleSpecification styleSpecification = new StyleSpecification();
            styleSpecification.setColor(Color.black);
            styleSpecification.setDepth(new Length("75%"));
            styleSpecification.setSize(new Length("75%"));
            styleSpecification.setSymbol(SymbolType.LINE);
            intervalSpecification.setStyle(styleSpecification);
            GraphSpecification graphSpecification = this.getGraphSpec();
            graphSpecification.addElement((ElementSpecification)intervalSpecification);
            graphSpecification.getTop().addStyle(styleSpecification);
        } else {
            IntervalSpecification intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(pointSpecification.getParent(), IntervalSpecification.class);
            if (intervalSpecification != null) {
                intervalSpecification.getParent().remove((Specification)intervalSpecification);
            }
        }
    }

    private void setHiLoCloseProp(Props.HiLoCloseProps hiLoCloseProps) {
        if (this.isHiLoClose()) {
            IntervalSpecification intervalSpecification;
            PointSpecification pointSpecification = (PointSpecification)this.getSpecByClassAndAttr(null, PointSpecification.class, "id", hiLoCloseProps.getStrElId());
            if (pointSpecification == null) {
                pointSpecification = (PointSpecification)this.getFirstSpecByClass(null, PointSpecification.class);
            }
            if ((intervalSpecification = pointSpecification != null ? (IntervalSpecification)this.getFirstSpecByClass(pointSpecification.getParent(), IntervalSpecification.class) : (IntervalSpecification)this.getFirstSpecByClass(null, IntervalSpecification.class)) == null) {
                return;
            }
            StyleSpecification styleSpecification = intervalSpecification.getStyle("");
            this.setIntervalStyle(styleSpecification, hiLoCloseProps.getIntervalStyle());
            this.mStyleCycler.setBaseStyle(this.mCoordinates, (ElementSpecification)intervalSpecification, Elements.hilo, this.mStyleCycler.getUseColors());
            ElementStat elementStat = hiLoCloseProps.getCloseStat();
            ExtensionSpecification extensionSpecification = this.getElementExtension((ElementSpecification)intervalSpecification);
            extensionSpecification.put("statistics", String.format("%d;%d", elementStat.getStat().value(), elementStat.getPctBaseType().ordinal()));
            extensionSpecification.put("startParm1", elementStat.getStrParm1());
            extensionSpecification.put("startParm2", elementStat.getStrParm2());
            extensionSpecification = this.getElementExtension((ElementSpecification)pointSpecification);
            ElementStat elementStat2 = hiLoCloseProps.getHighStat();
            ElementStat elementStat3 = hiLoCloseProps.getLowStat();
            extensionSpecification.put("statistics", String.format("%d;%d;%d;%d", elementStat3.getStat().value(), elementStat3.getPctBaseType().ordinal(), elementStat2.getStat().value(), elementStat2.getPctBaseType().ordinal()));
            extensionSpecification.put("startParm1", elementStat3.getStrParm1());
            extensionSpecification.put("startParm2", elementStat3.getStrParm2());
            extensionSpecification.put("endParm1", elementStat2.getStrParm1());
            extensionSpecification.put("endParm2", elementStat2.getStrParm2());
            if (pointSpecification != null) {
                this.setSymbolType(pointSpecification.getStyle(""), hiLoCloseProps.getSymbolType());
            }
            this.updateZoneLabel(ZoneType.zt_low);
            this.updateZoneLabel(ZoneType.zt_close);
        } else if (this.isDifferenceArea()) {
            AreaSpecification areaSpecification = (AreaSpecification)this.getFirstSpecByClass(null, AreaSpecification.class);
            ElementStat elementStat = hiLoCloseProps.getHighStat();
            ElementStat elementStat4 = hiLoCloseProps.getLowStat();
            ExtensionSpecification extensionSpecification = this.getElementExtension((ElementSpecification)areaSpecification);
            extensionSpecification.put("statistics", String.format("%d;%d;%d;%d", elementStat4.getStat().value(), elementStat4.getPctBaseType().ordinal(), elementStat.getStat().value(), elementStat.getPctBaseType().ordinal()));
            extensionSpecification.put("startParm1", elementStat4.getStrParm1());
            extensionSpecification.put("startParm2", elementStat4.getStrParm2());
            extensionSpecification.put("endParm1", elementStat.getStrParm1());
            extensionSpecification.put("endParm2", elementStat.getStrParm2());
            this.setInterpolationStyles(hiLoCloseProps);
        }
    }

    private void setSymbolType(StyleSpecification styleSpecification, IPropEnum.SymbolType symbolType) {
        SymbolType symbolType2 = SymbolType.CIRCLE;
        if (symbolType == IPropEnum.SymbolType.st_IBeam) {
            symbolType2 = SymbolType.IBEAM;
        } else if (symbolType == IPropEnum.SymbolType.st_Line) {
            symbolType2 = SymbolType.LINE;
        } else if (symbolType == IPropEnum.SymbolType.st_Arrow) {
            symbolType2 = SymbolType.ARROW;
        } else if (symbolType == IPropEnum.SymbolType.st_Bowtie) {
            symbolType2 = SymbolType.BOWTIE;
        } else if (symbolType == IPropEnum.SymbolType.st_Circle) {
            symbolType2 = SymbolType.CIRCLE;
        } else if (symbolType == IPropEnum.SymbolType.st_Cross) {
            symbolType2 = SymbolType.CROSS;
        } else if (symbolType == IPropEnum.SymbolType.st_Female) {
            symbolType2 = SymbolType.FEMALE;
        } else if (symbolType == IPropEnum.SymbolType.st_Flower) {
            symbolType2 = SymbolType.FLOWER;
        } else if (symbolType == IPropEnum.SymbolType.st_Male) {
            symbolType2 = SymbolType.MALE;
        } else if (symbolType == IPropEnum.SymbolType.st_Plus) {
            symbolType2 = SymbolType.PLUS;
        } else if (symbolType == IPropEnum.SymbolType.st_Polygon) {
            symbolType2 = SymbolType.POLYGON;
        } else if (symbolType == IPropEnum.SymbolType.st_Square) {
            symbolType2 = SymbolType.SQUARE;
        } else if (symbolType == IPropEnum.SymbolType.st_Star) {
            symbolType2 = SymbolType.STAR;
        }
        styleSpecification.setSymbol(symbolType2);
    }

    private void setPyramidProp(Props.PyramidProps pyramidProps) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", pyramidProps.getStrElId());
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = String.format("%s;%s;%s;%s", pyramidProps.getAnchorCustVal(), pyramidProps.getNoOfIntervals(), pyramidProps.getIntervalWidth(), pyramidProps.getConfInterval());
        extensionSpecification.put("Pyramid11_scale", string);
    }

    private void setMatrixProp(Props.MatrixProps matrixProps) {
        ISpssVariable iSpssVariable;
        ElementSpecification elementSpecification;
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_matrix);
        if (dropZone != null) {
            dropZone.clear();
            elementSpecification = matrixProps.getMatrixVarList().iterator();
            while (elementSpecification.hasNext()) {
                iSpssVariable = elementSpecification.next();
                dropZone.getVariables().add(iSpssVariable);
            }
        }
        if (matrixProps.getStatistic().getStat() != Statistics.Value && this.mCanvas.getZoneMgr().hasZone(ZoneType.zt_point_id)) {
            this.adjustPointId(false);
        }
        if ((elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class)) == null) {
            return;
        }
        iSpssVariable = this.getElementExtension(elementSpecification);
        iSpssVariable.put("hasTotalFitline", matrixProps.hasTotalRegressionLine() ? "1" : "0");
        iSpssVariable.put("hasSubgroupFitline", matrixProps.hasSubgroupRegressionLine() ? "1" : "0");
    }

    private void setInterpolationStyles(Props.ElProps elProps) {
        StatisticSpecification[] statisticSpecificationArray;
        boolean bl;
        InterpolationGroup interpolationGroup;
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", elProps.getStrElId());
        if (elProps instanceof Props.LineProps) {
            interpolationGroup = ((Props.LineProps)elProps).getInterpolationGroup();
            bl = interpolationGroup.getInterpolateThroughMissing();
            ((LineSpecification)elementSpecification).setBreakRepresentation((BreakRepresentationType)(bl ? BreakRepresentationType.INTERPOLATE : null));
        } else if (elProps instanceof Props.AreaProps) {
            interpolationGroup = ((Props.AreaProps)elProps).getInterpolationGroup();
            bl = interpolationGroup.getInterpolateThroughMissing();
            ((AreaSpecification)elementSpecification).setBreakRepresentation((BreakRepresentationType)(bl ? BreakRepresentationType.INTERPOLATE : null));
        } else if (elProps instanceof Props.HiLoCloseProps) {
            interpolationGroup = ((Props.HiLoCloseProps)elProps).getInterpolationGroup();
            bl = interpolationGroup.getInterpolateThroughMissing();
            ((AreaSpecification)elementSpecification).setBreakRepresentation((BreakRepresentationType)(bl ? BreakRepresentationType.INTERPOLATE : null));
        } else {
            return;
        }
        SmoothStatisticSpecification smoothStatisticSpecification = null;
        StatisticSpecification[] object = statisticSpecificationArray = elementSpecification.getStatistics();
        int n = object.length;
        for (int i = 0; i < n; i += 1) {
            StatisticSpecification statisticSpecification = object[i];
            if (!(statisticSpecification instanceof SmoothStatisticSpecification)) continue;
            smoothStatisticSpecification = (SmoothStatisticSpecification)statisticSpecification;
            break;
        }
        if (smoothStatisticSpecification == null && interpolationGroup.getInterpolationType() != IPropEnum.InterpolationType.it_Straight) {
            smoothStatisticSpecification = new SmoothStatisticSpecification();
            elementSpecification.addStatistic((StatisticSpecification)smoothStatisticSpecification);
        } else {
            if (smoothStatisticSpecification != null && interpolationGroup.getInterpolationType() == IPropEnum.InterpolationType.it_Straight) {
                elementSpecification.remove((Specification)smoothStatisticSpecification);
                return;
            }
            if (smoothStatisticSpecification == null) {
                return;
            }
        }
        IPropEnum.InterpolationLocation interpolationLocation = interpolationGroup.getInterpolationLocation();
        if (interpolationGroup.getInterpolationType() == IPropEnum.InterpolationType.it_Step || interpolationGroup.getInterpolationType() == IPropEnum.InterpolationType.it_Jump) {
            int n2 = n = interpolationGroup.getInterpolationType() == IPropEnum.InterpolationType.it_Jump ? 1 : 0;
            if (elementSpecification instanceof LineSpecification) {
                ((LineSpecification)elementSpecification).setShowDiscontinuity(Boolean.valueOf(n != 0));
            } else if (elementSpecification instanceof AreaSpecification) {
                ((AreaSpecification)elementSpecification).setShowDiscontinuity(Boolean.valueOf(n != 0));
            }
            if (interpolationLocation == IPropEnum.InterpolationLocation.il_Left) {
                smoothStatisticSpecification.setMethod(SmoothMethodType.STEP_LEFT);
            } else if (interpolationLocation == IPropEnum.InterpolationLocation.il_Right) {
                smoothStatisticSpecification.setMethod(SmoothMethodType.STEP_RIGHT);
            } else if (interpolationLocation == IPropEnum.InterpolationLocation.il_Center) {
                smoothStatisticSpecification.setMethod(SmoothMethodType.STEP_CENTER);
            }
        } else if (interpolationGroup.getInterpolationType() == IPropEnum.InterpolationType.it_Spline) {
            smoothStatisticSpecification.setMethod(SmoothMethodType.SPLINE);
        }
    }

    private void dispatchAxisProperty(Props.AxisProps axisProps) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", axisProps.getStrElAssoc());
        if (elementSpecification == null) {
            return;
        }
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = axisProps.getIdentifier() + "_flags";
        boolean bl = axisProps.getZoneType() == ZoneType.zt_y2;
        String string2 = String.format("%d;%d", axisProps.getFlags(), bl ? 1 : 0);
        extensionSpecification.put(string, string2);
        string = axisProps.getIdentifier() + "_label";
        string2 = axisProps.getStrLabel();
        extensionSpecification.put(string, string2);
        if (axisProps instanceof Props.AngleAxisProps) {
            this.dispatchAngleAxisProperties((Props.AngleAxisProps)axisProps);
        } else if (axisProps instanceof Props.ScaleAxisProps) {
            this.dispatchScaleAxisProperties((Props.ScaleAxisProps)axisProps);
        } else if (axisProps instanceof Props.CatAxisProps) {
            this.dispatchCatAxisProperties((Props.CatAxisProps)axisProps);
        }
    }

    private void dispatchCatAxisProperties(Props.CatAxisProps catAxisProps) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", catAxisProps.getStrElAssoc());
        if (elementSpecification == null) {
            return;
        }
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = catAxisProps.getIdentifier() + "_cat";
        String string2 = String.format("%d;%d;%d", catAxisProps.getSortType().ordinal(), catAxisProps.getSortOrder().ordinal(), catAxisProps.getCollapsePct());
        extensionSpecification.put(string, string2);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        string = catAxisProps.getIdentifier() + "_relabels";
        Vector<RelabelBag> vector = catAxisProps.getCategories();
        for (RelabelBag relabelBag : vector) {
            stringBuffer.append(relabelBag.write());
            if (++n >= vector.size()) continue;
            stringBuffer.append("^^");
        }
        extensionSpecification.put(string, stringBuffer.toString());
        string = catAxisProps.getIdentifier() + "_include";
        extensionSpecification.put(string, catAxisProps.getIncludeUnlabeled() ? "1" : "0");
        this.updateRelabelDisplay(catAxisProps);
    }

    private void updateRelabelDisplay(Props.CatAxisProps catAxisProps) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", catAxisProps.getStrElAssoc());
        SourceVariableSpecification sourceVariableSpecification = null;
        ZoneType zoneType = catAxisProps.getZoneType();
        if (zoneType == ZoneType.zt_x || zoneType == ZoneType.zt_dist_var) {
            sourceVariableSpecification = this.getXVarSpec(elementSpecification);
        } else if (catAxisProps.getZoneType() == ZoneType.zt_y) {
            sourceVariableSpecification = elementSpecification.getY();
        } else if (catAxisProps.getZoneType() == ZoneType.zt_z) {
            sourceVariableSpecification = this.getZVarSpec(elementSpecification);
        } else if (catAxisProps.getZoneType() == ZoneType.zt_panel_horz) {
            sourceVariableSpecification = this.getPanelVarSpec(ZoneType.zt_panel_horz);
        } else if (catAxisProps.getZoneType() == ZoneType.zt_panel_vert) {
            sourceVariableSpecification = this.getPanelVarSpec(ZoneType.zt_panel_vert);
        } else {
            AestheticSpecification[] aestheticSpecificationArray;
            if (catAxisProps.getZoneType() == ZoneType.zt_filter) {
                VariableSpecification[] variableSpecificationArray;
                for (VariableSpecification variableSpecification : variableSpecificationArray = this.getFilterVarSpecs()) {
                    this.doUpdateRelabelDisplay(catAxisProps, variableSpecification);
                }
                return;
            }
            if ((catAxisProps.getZoneType() == ZoneType.zt_cluster_x || catAxisProps.getZoneType() == ZoneType.zt_cluster_z || catAxisProps.getZoneType() == ZoneType.zt_group || catAxisProps.getZoneType() == ZoneType.zt_split_var || catAxisProps.getZoneType() == ZoneType.zt_slice_by) && (aestheticSpecificationArray = elementSpecification.getAestheticSpecifications()).length > 0) {
                if (this.mCoordinates != Coords.coords_3D) {
                    sourceVariableSpecification = aestheticSpecificationArray[0].getVariable();
                } else {
                    boolean bl = this.hasXCluster();
                    boolean bl2 = this.hasZCluster();
                    int n = 0;
                    if (catAxisProps.getZoneType() == ZoneType.zt_cluster_z) {
                        n = bl ? 1 : 0;
                    } else if (catAxisProps.getZoneType() == ZoneType.zt_group) {
                        int n2 = n = bl || bl2 ? 1 : 0;
                    }
                    if (aestheticSpecificationArray.length > n) {
                        sourceVariableSpecification = aestheticSpecificationArray[n].getVariable();
                    }
                }
            }
        }
        this.doUpdateRelabelDisplay(catAxisProps, (VariableSpecification)sourceVariableSpecification);
    }

    private void doUpdateRelabelDisplay(Props.CatAxisProps catAxisProps, VariableSpecification variableSpecification) {
        Object object;
        FormatSpecification formatSpecification;
        if (variableSpecification == null || !(variableSpecification instanceof SourceVariableSpecification)) {
            return;
        }
        FormatSpecification formatSpecification2 = variableSpecification.getDisplayFormatChild();
        if (formatSpecification2 == null) {
            formatSpecification = new FormatSpecification();
            variableSpecification.setDisplayFormatChild(formatSpecification);
        } else {
            formatSpecification = formatSpecification2;
        }
        RelabelSpecification[] relabelSpecificationArray = formatSpecification.getRelabeling();
        for (RelabelSpecification object22 : relabelSpecificationArray) {
            formatSpecification.remove((Specification)object22);
        }
        Vector<RelabelBag> vector = catAxisProps.getCategories();
        if (vector.size() == 0) {
            this.addDefaultRelabels(formatSpecification);
            return;
        }
        int n = 0;
        Iterator bl = vector.iterator();
        while (bl.hasNext()) {
            object = (RelabelBag)bl.next();
            if (((RelabelBag)object).getExcluded()) continue;
            ++n;
        }
        boolean bl2 = n > 10;
        n = 0;
        object = vector.iterator();
        while (object.hasNext()) {
            RelabelBag relabelBag = (RelabelBag)object.next();
            if (relabelBag.getExcluded()) continue;
            String string = n == 9 && bl2 ? this.mCanvas.getResources().getResString("IDS_MORE_CATS") : relabelBag.getStrTo();
            formatSpecification.addRelabeling(new RelabelSpecification(Integer.toString(++n), string));
            if (n < 10) continue;
            break;
        }
        this.setupCategoricalDomain((SourceVariableSpecification)variableSpecification);
    }

    private VariableSpecification[] getFilterVarSpecs() {
        SourceVariableSpecification[] sourceVariableSpecificationArray;
        ArrayList<SourceVariableSpecification> arrayList = new ArrayList<SourceVariableSpecification>();
        Vector<ISpssVariable> vector = this.mCanvas.getFilterVars();
        VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
        for (SourceVariableSpecification sourceVariableSpecification : sourceVariableSpecificationArray = (SourceVariableSpecification[])visualizationSpecification.findDescendantsOfType(SourceVariableSpecification.class)) {
            for (ISpssVariable iSpssVariable : vector) {
                if (sourceVariableSpecification.getShortLabel() == null || !sourceVariableSpecification.getShortLabel().equals(iSpssVariable.getName())) continue;
                arrayList.add(sourceVariableSpecification);
            }
        }
        return arrayList.toArray(new VariableSpecification[arrayList.size()]);
    }

    private VariableSpecification getPanelVarSpec(ZoneType zoneType) {
        FacetingSpecification facetingSpecification = (FacetingSpecification)this.getFirstSpecByClass(null, FacetingSpecification.class);
        if (facetingSpecification != null) {
            int n = zoneType == ZoneType.zt_panel_horz ? 0 : 1;
            CrossSpecification crossSpecification = (CrossSpecification)facetingSpecification.getExpressionChild();
            Specification[] specificationArray = crossSpecification.getOperands();
            if (specificationArray.length > n && specificationArray[n] instanceof SourceVariableSpecification) {
                return (VariableSpecification)specificationArray[n];
            }
            if (specificationArray.length > n && specificationArray[n] instanceof VariableReferenceSpecification) {
                return ((VariableReferenceSpecification)specificationArray[n]).getReference();
            }
        }
        return null;
    }

    private void dispatchScaleAxisProperties(Props.ScaleAxisProps scaleAxisProps) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", scaleAxisProps.getStrElAssoc());
        if (elementSpecification == null) {
            return;
        }
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = scaleAxisProps.getIdentifier() + "_scale";
        String string2 = scaleAxisProps.getStrMinimum().length() != 0 ? scaleAxisProps.getStrMinimum() : scaleAxisProps.getStrMinimumDefault();
        String string3 = scaleAxisProps.getStrMaximum().length() != 0 ? scaleAxisProps.getStrMaximum() : scaleAxisProps.getStrMaximumDefault();
        String string4 = scaleAxisProps.getStrMajorIncrement().length() != 0 ? scaleAxisProps.getStrMajorIncrement() : scaleAxisProps.getStrMajorIncrementDefault();
        String string5 = scaleAxisProps.getStrOrigin().length() != 0 ? scaleAxisProps.getStrOrigin() : scaleAxisProps.getStrOriginDefault();
        String string6 = scaleAxisProps.getStrBase().length() != 0 ? scaleAxisProps.getStrBase() : scaleAxisProps.getStrBaseDefault();
        String string7 = scaleAxisProps.getStrExponent().length() != 0 ? scaleAxisProps.getStrExponent() : scaleAxisProps.getStrExponentDefault();
        String string8 = String.format("%d;%s;%s;%s;%s;%s;%s", scaleAxisProps.getScaleType().ordinal(), string2, string3, string4, string5, string6, string7);
        extensionSpecification.put(string, string8);
    }

    private void dispatchAngleAxisProperties(Props.AngleAxisProps angleAxisProps) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", angleAxisProps.getStrElAssoc());
        if (elementSpecification == null) {
            return;
        }
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = angleAxisProps.getIdentifier() + "_polar";
        String string2 = String.format("%d;%d", angleAxisProps.getClockOrder().ordinal(), angleAxisProps.getClockPos());
        extensionSpecification.put(string, string2);
    }

    private void dispatchTitleProperty(Props.TitleProps titleProps) {
        String string;
        ExtensionSpecification extensionSpecification = this.getTitlesExtension();
        IPropEnum.TitleFlag titleFlag = titleProps.getTitleType();
        if (titleFlag == IPropEnum.TitleFlag.tf_Title1) {
            string = "Title1";
        } else if (titleFlag == IPropEnum.TitleFlag.tf_Title2) {
            string = "Title2";
        } else if (titleFlag == IPropEnum.TitleFlag.tf_Subtitle) {
            string = "Subtitle";
        } else if (titleFlag == IPropEnum.TitleFlag.tf_Footnote1) {
            string = "Footnote1";
        } else if (titleFlag == IPropEnum.TitleFlag.tf_Footnote2) {
            string = "Footnote2";
        } else {
            return;
        }
        extensionSpecification.put(string, titleProps.getStrTitle());
        extensionSpecification.put(string + "_index", Integer.toString(titleProps.getUseIndex()));
        extensionSpecification.put(string + "_flags", Integer.toString(titleProps.getFlags()));
        extensionSpecification.put(string + "_assoc", titleProps.getStrElAssoc());
    }

    private void updateGridline(boolean bl, String string) {
        VisualizationSpecification visualizationSpecification = this.mVisualization.getSpecification();
        int n = string.equals("x") ? 0 : 1;
        DimensionSpecification dimensionSpecification = ((DimensionSpecification[])visualizationSpecification.findDescendantsOfType(DimensionSpecification.class))[n];
        if (dimensionSpecification == null || dimensionSpecification.getAxisSpecifications().length == 0) {
            return;
        }
        AxisSpecification axisSpecification = dimensionSpecification.getAxisSpecifications()[0];
        MajorTicksSpecification majorTicksSpecification = axisSpecification.getMajorTickChild();
        if (majorTicksSpecification != null) {
            GridlineSpecification gridlineSpecification = majorTicksSpecification.getGridLinesChild();
            if (bl) {
                if (gridlineSpecification == null) {
                    gridlineSpecification = new GridlineSpecification();
                    majorTicksSpecification.setGridLinesChild(gridlineSpecification);
                    StyleSpecification styleSpecification = new StyleSpecification();
                    styleSpecification.setStrokeWidth(new Length("0.2pt"));
                    gridlineSpecification.setStyle((LineStyle)styleSpecification);
                    this.addVizStyle(styleSpecification);
                }
            } else if (gridlineSpecification != null) {
                majorTicksSpecification.remove((Specification)gridlineSpecification);
            }
        }
    }

    private void acquireElementProps(ChartProps chartProps) {
        Specification[] specificationArray = this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class);
        if (specificationArray != null && specificationArray.length > 0) {
            ElementSpecification elementSpecification;
            boolean bl = this.isHiLoClose();
            boolean bl2 = bl && specificationArray[0] instanceof IntervalSpecification;
            boolean bl3 = bl && specificationArray.length > 1 && specificationArray[1] instanceof PointSpecification;
            ElementSpecification elementSpecification2 = (ElementSpecification)specificationArray[0];
            ElementSpecification elementSpecification3 = elementSpecification = specificationArray.length > 1 ? (ElementSpecification)specificationArray[1] : null;
            if (!this.isHiddenLine(elementSpecification2) && !bl2) {
                chartProps.addProp(this.getElementProp(elementSpecification2));
            }
            if (specificationArray.length > 1 && !this.isHiddenLine(elementSpecification) && (this.mCoordinates == Coords.coords_DualY || bl3)) {
                chartProps.addProp(this.getElementProp(elementSpecification));
            }
        }
    }

    private Props getElementProp(ElementSpecification elementSpecification) {
        Props.ElProps elProps;
        Elements elements = this.getElementType(this.mCoordinates, elementSpecification);
        if (elements == Elements.point) {
            elProps = new Props.PointProps();
            this.getPointProps(elementSpecification, (Props.PointProps)elProps);
        } else if (elements == Elements.interval) {
            elProps = new Props.BarProps();
            this.getBarProps(elementSpecification, (Props.BarProps)elProps);
        } else if (elements == Elements.line) {
            elProps = new Props.LineProps();
            this.getInterpolationStyles(elementSpecification, (Props.LineProps)elProps);
        } else if (elements == Elements.area) {
            elProps = new Props.AreaProps();
            this.getInterpolationStyles(elementSpecification, (Props.AreaProps)elProps);
        } else if (elements == Elements.schema) {
            elProps = new Props.SchemaProps();
        } else if (elements == Elements.hilo) {
            elProps = new Props.HiLoCloseProps();
            this.getHiLoCloseProps(elementSpecification, (Props.HiLoCloseProps)elProps);
        } else if (elements == Elements.diff_area) {
            elProps = new Props.HiLoCloseProps();
            ((Props.HiLoCloseProps)elProps).getHighStat().setStat(Statistics.Mean);
            ((Props.HiLoCloseProps)elProps).getLowStat().setStat(Statistics.Mean);
            ((Props.HiLoCloseProps)elProps).setElement(elements);
            this.getHiLoCloseProps(elementSpecification, (Props.HiLoCloseProps)elProps);
        } else if (elements == Elements.pyramid) {
            elProps = new Props.PyramidProps();
            this.getPyramidProps(elementSpecification, (Props.PyramidProps)elProps);
        } else if (elements == Elements.splom) {
            elProps = new Props.MatrixProps();
            this.getMatrixProps(elementSpecification, (Props.MatrixProps)elProps);
        } else if (elements == Elements.polar_interval) {
            elProps = new Props.PieProps();
        } else {
            return null;
        }
        this.getElementProps(elementSpecification, elProps);
        elProps.setStrElId(elementSpecification.getId());
        if (this.mCoordinates == Coords.coords_DualY) {
            Specification specification = this.getSpecByClassAndAttr(null, ExtensionSpecification.class, AXIS2_ASSOC_KEY, elementSpecification.getId());
            elProps.setStrElAssoc(specification == null ? "1" : "2");
        } else {
            elProps.setStrElAssoc(elementSpecification.getId());
        }
        return elProps;
    }

    private void getMatrixProps(ElementSpecification elementSpecification, Props.MatrixProps matrixProps) {
        String string;
        Object object;
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_matrix);
        if (dropZone != null && !dropZone.isEmpty()) {
            object = dropZone.getVariables().iterator();
            while (object.hasNext()) {
                string = (ISpssVariable)object.next();
                matrixProps.getMatrixVarList().add((ISpssVariable)string);
            }
        }
        boolean bl = (string = (object = this.getElementExtension(elementSpecification)).get("hasTotalFitline")) != null && string.equals("1");
        matrixProps.setHasTotalRegressionLine(bl);
        String string2 = object.get("hasSubgroupFitline");
        boolean bl2 = string2 != null && string2.equals("1");
        matrixProps.setHasSubgroupRegressionLine(bl2);
    }

    private void getPyramidProps(ElementSpecification elementSpecification, Props.PyramidProps pyramidProps) {
        StringTokenizer stringTokenizer;
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = extensionSpecification.get("Pyramid11_scale");
        if (string != null && string.length() > 0 && (stringTokenizer = new StringTokenizer(string, ";", false)).hasMoreTokens()) {
            pyramidProps.setAnchorCustVal(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                pyramidProps.setNoOfIntervals(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    pyramidProps.setIntervalWidth(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        pyramidProps.setConfInterval(stringTokenizer.nextToken());
                    }
                }
            }
        }
    }

    private void getElementProps(ElementSpecification elementSpecification, Props.ElProps elProps) {
        double d;
        String string;
        Object object;
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string2 = extensionSpecification.get("flags");
        if (string2 != null && string2.length() > 0) {
            elProps.setFlags(Long.valueOf(string2).intValue());
        } else {
            elProps.setFlags(0);
        }
        String string3 = extensionSpecification.get("errorIntervalType");
        if (string3 != null && string3.length() > 0) {
            int n = Integer.valueOf(string3);
            object = n == 2 ? IPropEnum.ErrorIntervalType.eit_MultStdError : (n == 1 ? IPropEnum.ErrorIntervalType.eit_MultStdDev : IPropEnum.ErrorIntervalType.eit_Confidence);
            elProps.setErrorIntervalType((IPropEnum.ErrorIntervalType)((Object)object));
        }
        if ((string = extensionSpecification.get("errorIntervalPct")) != null && string.length() > 0) {
            double d2 = Double.valueOf(string);
            elProps.setLevel(d2);
        }
        if ((object = extensionSpecification.get("errorIntervalMultStdError")) != null && ((String)object).length() > 0) {
            d = Double.valueOf((String)object);
            elProps.setMultiplierStdError(d);
        }
        if ((object = extensionSpecification.get("errorIntervalMultStdDev")) != null && ((String)object).length() > 0) {
            d = Double.valueOf((String)object);
            elProps.setMultiplierStdDev(d);
        }
        if (this.hasSSVs()) {
            this.getSSVStatistics(elementSpecification, elProps);
        } else {
            this.getStatistics(elementSpecification, elProps.getStatistic());
        }
    }

    private void getSSVStatistics(ElementSpecification elementSpecification, Props.ElProps elProps) {
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        Vector<ElementStat> vector = elProps.getSSVData().getSSVVariables();
        vector.clear();
        String string = extensionSpecification.get("SSVCount");
        if (string != null && string.length() > 0) {
            int n = Integer.valueOf(string);
            for (int i = 0; i < n; ++i) {
                ElementStat elementStat = new ElementStat(elProps);
                String string2 = String.format("SSVStat_%d", i);
                String string3 = extensionSpecification.get(string2);
                int n2 = string3.indexOf(59);
                if (n2 > -1) {
                    elementStat.setStat(Statistics.fromInt(Integer.valueOf(string3.substring(0, n2))));
                    elementStat.setPctBaseType(IPropEnum.PercentageBaseType.fromInt(Integer.valueOf(string3.substring(n2 + 1))));
                }
                string2 = String.format("SSVParm1_%d", i);
                elementStat.setStrParm1(extensionSpecification.get(string2));
                string2 = String.format("SSVParm2_%d", i);
                elementStat.setStrParm2(extensionSpecification.get(string2));
                string2 = String.format("SSVVar_%d", i);
                string3 = extensionSpecification.get(string2);
                ISpssVariable iSpssVariable = this.getSSVVariable(string3);
                if (iSpssVariable == null) continue;
                elementStat.setVariable(iSpssVariable);
                vector.add(elementStat);
            }
        }
    }

    private ISpssVariable getSSVVariable(String string) {
        DropZone dropZone = this.mCoordinates == Coords.coords_Polar ? this.mCanvas.getZoneMgr().getZone(ZoneType.zt_angle) : this.mCanvas.getZoneMgr().getZone(ZoneType.zt_y);
        if (dropZone == null) {
            return null;
        }
        Vector<ISpssVariable> vector = dropZone.getVariables();
        for (ISpssVariable iSpssVariable : vector) {
            if (!iSpssVariable.getName().equals(string)) continue;
            return iSpssVariable;
        }
        return null;
    }

    private void getStatistics(ElementSpecification elementSpecification, ElementStat elementStat) {
        Object object;
        boolean bl = this.isPopulationPyramid();
        if (this.isHiLoClose() || this.isDifferenceArea()) {
            elementStat.setVariable(this.getSpssVarForZone(ZoneType.zt_high));
        } else if (bl) {
            elementStat.setVariable(this.getSpssVarForZone(ZoneType.zt_dist_var));
        } else if (this.mCoordinates == Coords.coords_Polar) {
            elementStat.setVariable(this.getSpssVarForZone(ZoneType.zt_angle));
        } else if (this.mCoordinates == Coords.coords_DualY) {
            object = this.dualYElementWithFirstYAxis(elementSpecification) ? ZoneType.zt_y : ZoneType.zt_y2;
            elementStat.setVariable(this.getSpssVarForZone((ZoneType)((Object)object)));
        } else {
            elementStat.setVariable(this.getSpssVarForZone(ZoneType.zt_y));
        }
        object = this.getElementExtension(elementSpecification);
        String string = object.get("statistics");
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        elementStat.setStat(Statistics.fromInt(Integer.valueOf(stringTokenizer.nextToken())));
                        if (stringTokenizer.hasMoreTokens()) {
                            elementStat.setPctBaseType(IPropEnum.PercentageBaseType.fromInt(Integer.valueOf(stringTokenizer.nextToken())));
                        }
                    }
                }
            }
            elementStat.setStrParm1(object.get("endParm1"));
            elementStat.setStrParm2(object.get("endParm2"));
            String string2 = object.get("endAnchorType");
            if (string2 != null && string2.length() > 0) {
                elementStat.setAnchorType(Integer.valueOf(string2));
            }
            if ((string2 = object.get("endBinSizeType")) != null && string2.length() > 0) {
                elementStat.setBinSize(Integer.valueOf(string2));
            }
            if ((string2 = object.get("endBinSizeCustom")) != null && string2.length() > 0) {
                elementStat.setBinSizeCustom(Integer.valueOf(string2));
            }
            if ((string2 = object.get("endDisplayNormalCurve")) != null && string2.length() > 0) {
                elementStat.setDisplayNormalCurve(Integer.valueOf(string2) == 1);
            }
            if (!(bl || elementStat.getStat() != Statistics.Histogram && elementStat.getStat() != Statistics.HistogramPct)) {
                elementStat.setVariable(this.getSpssVarForZone(ZoneType.zt_x));
            }
        }
    }

    private void getBarProps(ElementSpecification elementSpecification, Props.BarProps barProps) {
        StyleSpecification styleSpecification = elementSpecification.getStyle("");
        barProps.setIntervalStyle(this.getIntervalStyle(styleSpecification));
    }

    private void getPointProps(ElementSpecification elementSpecification, Props.PointProps pointProps) {
        boolean bl;
        Object object;
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string = extensionSpecification.get("stackIdentical");
        boolean bl2 = string != null && string.equals("1");
        pointProps.setStackIdentical(bl2);
        String string2 = extensionSpecification.get("canHaveFitline");
        if (string2 == null) {
            object = (LineSpecification[])elementSpecification.getTop().findDescendantsOfType(LineSpecification.class);
            if (((LineSpecification[])object).length > 0) {
                pointProps.setHasTotalRegressionLine(true);
                pointProps.setCanHaveRegressionLine(true);
            } else if (this.getPrototype() != null) {
                bl = this.getPrototype().getChartGroup() == 16 && !this.isDropLine() && !this.isSummaryPointChart();
                pointProps.setCanHaveRegressionLine(bl);
                extensionSpecification.put("canHaveFitline", bl ? "1" : "0");
            }
        } else {
            pointProps.setCanHaveRegressionLine(string2.equals("1"));
            object = extensionSpecification.get("hasTotalFitline");
            bl = object != null && ((String)object).equals("1");
            pointProps.setHasTotalRegressionLine(bl);
            String string3 = extensionSpecification.get("hasSubgroupFitline");
            boolean bl3 = string3 != null && string3.equals("1");
            pointProps.setHasSubgroupRegressionLine(bl3);
        }
        object = elementSpecification.getPositionModifier();
        if (object == PositionModifierType.PILE) {
            pointProps.setPlotShape(IPropEnum.PlotShape.ps_Asymmetric);
        } else if (object == PositionModifierType.DODGE) {
            pointProps.setPlotShape(IPropEnum.PlotShape.ps_Symmetric);
        } else {
            pointProps.setPlotShape(IPropEnum.PlotShape.ps_Flat);
        }
        String string4 = extensionSpecification.get("dropLine");
        boolean bl4 = string4 != null && string4.equals("1");
        pointProps.setHasDropLine(bl4);
        String string5 = extensionSpecification.get("YXpairs");
        if (string5 != null && string5.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ";", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                int n = string6.indexOf(44);
                String string7 = string6.substring(0, n);
                String string8 = string6.substring(n + 1);
                pointProps.getYXPairs().add(string7, string8);
            }
        }
    }

    private void getHiLoCloseProps(ElementSpecification elementSpecification, Props.HiLoCloseProps hiLoCloseProps) {
        if (this.isHiLoClose()) {
            IntervalSpecification intervalSpecification = (IntervalSpecification)this.getFirstSpecByClass(elementSpecification.getParent(), IntervalSpecification.class);
            StyleSpecification styleSpecification = intervalSpecification.getStyle("");
            hiLoCloseProps.setIntervalStyle(this.getIntervalStyle(styleSpecification));
            ElementStat elementStat = hiLoCloseProps.getHighStat();
            ElementStat elementStat2 = hiLoCloseProps.getCloseStat();
            ExtensionSpecification extensionSpecification = this.getElementExtension((ElementSpecification)intervalSpecification);
            String string = extensionSpecification.get("statistics");
            if (string != null && string.length() > 0) {
                int n = -1;
                int n2 = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
                if (stringTokenizer.hasMoreTokens()) {
                    n = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n2 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (n > -1) {
                    elementStat2.setStat(Statistics.fromInt(n));
                }
                if (n2 > -1) {
                    elementStat2.setPctBaseType(IPropEnum.PercentageBaseType.fromInt(n2));
                }
                elementStat2.setStrParm1(extensionSpecification.get("startParm1"));
                elementStat2.setStrParm2(extensionSpecification.get("startParm2"));
            }
            if (elementSpecification instanceof PointSpecification) {
                PointSpecification pointSpecification = (PointSpecification)elementSpecification;
                ElementStat elementStat3 = hiLoCloseProps.getLowStat();
                extensionSpecification = this.getElementExtension((ElementSpecification)pointSpecification);
                string = extensionSpecification.get("statistics");
                if (string != null && string.length() > 0) {
                    int n = -1;
                    int n3 = -1;
                    int n4 = -1;
                    int n5 = -1;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
                    if (stringTokenizer.hasMoreTokens()) {
                        n = Integer.valueOf(stringTokenizer.nextToken());
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        n3 = Integer.valueOf(stringTokenizer.nextToken());
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        n4 = Integer.valueOf(stringTokenizer.nextToken());
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        n5 = Integer.valueOf(stringTokenizer.nextToken());
                    }
                    if (n > -1) {
                        elementStat3.setStat(Statistics.fromInt(n));
                    }
                    if (n3 > -1) {
                        elementStat3.setPctBaseType(IPropEnum.PercentageBaseType.fromInt(n3));
                    }
                    elementStat3.setStrParm1(extensionSpecification.get("startParm1"));
                    elementStat3.setStrParm2(extensionSpecification.get("startParm2"));
                    if (n4 > -1) {
                        elementStat.setStat(Statistics.fromInt(n4));
                    }
                    if (n5 > -1) {
                        elementStat.setPctBaseType(IPropEnum.PercentageBaseType.fromInt(n5));
                    }
                    elementStat.setStrParm1(extensionSpecification.get("endParm1"));
                    elementStat.setStrParm2(extensionSpecification.get("endParm2"));
                }
                elementStat.setVariable(this.getSpssVarForZone(ZoneType.zt_high));
                elementStat3.setVariable(this.getSpssVarForZone(ZoneType.zt_low));
                elementStat2.setVariable(this.getSpssVarForZone(ZoneType.zt_close));
                hiLoCloseProps.setSymbolType(this.getSymbolType(pointSpecification.getStyle("")));
            }
        } else if (this.isDifferenceArea()) {
            ElementStat elementStat = hiLoCloseProps.getLowStat();
            ElementStat elementStat4 = hiLoCloseProps.getHighStat();
            ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
            String string = extensionSpecification.get("statistics");
            if (string != null && string.length() > 0) {
                int n = -1;
                int n6 = -1;
                int n7 = -1;
                int n8 = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
                if (stringTokenizer.hasMoreTokens()) {
                    n = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n6 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n7 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n8 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (n > -1) {
                    elementStat.setStat(Statistics.fromInt(n));
                }
                if (n6 > -1) {
                    elementStat.setPctBaseType(IPropEnum.PercentageBaseType.fromInt(n6));
                }
                elementStat.setStrParm1(extensionSpecification.get("startParm1"));
                elementStat.setStrParm2(extensionSpecification.get("startParm2"));
                if (n7 > -1) {
                    elementStat4.setStat(Statistics.fromInt(n7));
                }
                if (n8 > -1) {
                    elementStat4.setPctBaseType(IPropEnum.PercentageBaseType.fromInt(n8));
                }
                elementStat4.setStrParm1(extensionSpecification.get("endParm1"));
                elementStat4.setStrParm2(extensionSpecification.get("endParm2"));
            }
            this.getInterpolationStyles(elementSpecification, hiLoCloseProps);
            elementStat.setVariable(this.getSpssVarForZone(ZoneType.zt_low));
            elementStat4.setVariable(this.getSpssVarForZone(ZoneType.zt_high));
        }
    }

    private ISpssVariable getSpssVarForZone(ZoneType zoneType) {
        ISpssVariable iSpssVariable = null;
        if (this.getSpssVarsForZone(zoneType) != null && this.getSpssVarsForZone(zoneType).size() > 0) {
            iSpssVariable = this.getSpssVarsForZone(zoneType).get(0);
        }
        return iSpssVariable;
    }

    private Vector<ISpssVariable> getSpssVarsForZone(ZoneType zoneType) {
        Vector<ISpssVariable> vector = null;
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(zoneType);
        if (dropZone != null && !dropZone.isEmpty()) {
            vector = dropZone.getVariables();
        }
        return vector;
    }

    private IPropEnum.IntervalStyle getIntervalStyle(StyleSpecification styleSpecification) {
        IPropEnum.IntervalStyle intervalStyle = IPropEnum.IntervalStyle.is_Square;
        SymbolType symbolType = styleSpecification.getSymbol();
        if (symbolType == null) {
            return intervalStyle;
        }
        if (symbolType == SymbolType.IBEAM) {
            intervalStyle = IPropEnum.IntervalStyle.is_IBeam;
        } else if (symbolType == SymbolType.LINE) {
            intervalStyle = IPropEnum.IntervalStyle.is_Line;
        }
        return intervalStyle;
    }

    private IPropEnum.SymbolType getSymbolType(StyleSpecification styleSpecification) {
        IPropEnum.SymbolType symbolType = IPropEnum.SymbolType.st_Circle;
        SymbolType symbolType2 = styleSpecification.getSymbol();
        if (symbolType2 == SymbolType.IBEAM) {
            symbolType = IPropEnum.SymbolType.st_IBeam;
        } else if (symbolType2 == SymbolType.LINE) {
            symbolType = IPropEnum.SymbolType.st_Line;
        } else if (symbolType2 == SymbolType.ARROW) {
            symbolType = IPropEnum.SymbolType.st_Arrow;
        } else if (symbolType2 == SymbolType.BOWTIE) {
            symbolType = IPropEnum.SymbolType.st_Bowtie;
        } else if (symbolType2 == SymbolType.CIRCLE) {
            symbolType = IPropEnum.SymbolType.st_Circle;
        } else if (symbolType2 == SymbolType.CROSS) {
            symbolType = IPropEnum.SymbolType.st_Cross;
        } else if (symbolType2 == SymbolType.FEMALE) {
            symbolType = IPropEnum.SymbolType.st_Female;
        } else if (symbolType2 == SymbolType.FLOWER) {
            symbolType = IPropEnum.SymbolType.st_Flower;
        } else if (symbolType2 == SymbolType.MALE) {
            symbolType = IPropEnum.SymbolType.st_Male;
        } else if (symbolType2 == SymbolType.PLUS) {
            symbolType = IPropEnum.SymbolType.st_Plus;
        } else if (symbolType2 == SymbolType.POLYGON) {
            symbolType = IPropEnum.SymbolType.st_Polygon;
        } else if (symbolType2 == SymbolType.SQUARE) {
            symbolType = IPropEnum.SymbolType.st_Square;
        } else if (symbolType2 == SymbolType.STAR) {
            symbolType = IPropEnum.SymbolType.st_Star;
        }
        return symbolType;
    }

    private void getInterpolationStyles(ElementSpecification elementSpecification, Props.ElProps elProps) {
        SmoothMethodType smoothMethodType;
        Boolean bl;
        BreakRepresentationType breakRepresentationType;
        InterpolationGroup interpolationGroup;
        if (elProps instanceof Props.LineProps) {
            interpolationGroup = ((Props.LineProps)elProps).getInterpolationGroup();
            breakRepresentationType = ((LineSpecification)elementSpecification).getBreakRepresentation();
            bl = ((LineSpecification)elementSpecification).getShowDiscontinuity();
        } else if (elProps instanceof Props.AreaProps) {
            interpolationGroup = ((Props.AreaProps)elProps).getInterpolationGroup();
            breakRepresentationType = ((AreaSpecification)elementSpecification).getBreakRepresentation();
            bl = ((AreaSpecification)elementSpecification).getShowDiscontinuity();
        } else if (elProps instanceof Props.HiLoCloseProps) {
            interpolationGroup = ((Props.HiLoCloseProps)elProps).getInterpolationGroup();
            breakRepresentationType = ((AreaSpecification)elementSpecification).getBreakRepresentation();
            bl = ((AreaSpecification)elementSpecification).getShowDiscontinuity();
        } else {
            return;
        }
        if (bl == null) {
            bl = false;
        }
        interpolationGroup.setInterpolateThroughMissing(breakRepresentationType == BreakRepresentationType.INTERPOLATE);
        SmoothStatisticSpecification smoothStatisticSpecification = null;
        for (StatisticSpecification statisticSpecification : smoothMethodType = elementSpecification.getStatistics()) {
            if (!(statisticSpecification instanceof SmoothStatisticSpecification)) continue;
            smoothStatisticSpecification = (SmoothStatisticSpecification)statisticSpecification;
            break;
        }
        if (smoothStatisticSpecification != null) {
            SmoothMethodType smoothMethodType2 = smoothStatisticSpecification.getMethod();
            if (smoothMethodType2 == SmoothMethodType.STEP_LEFT) {
                interpolationGroup.setInterpolationLocation(IPropEnum.InterpolationLocation.il_Left);
                interpolationGroup.setInterpolationType(bl != false ? IPropEnum.InterpolationType.it_Jump : IPropEnum.InterpolationType.it_Step);
            } else if (smoothMethodType2 == SmoothMethodType.STEP_CENTER) {
                interpolationGroup.setInterpolationLocation(IPropEnum.InterpolationLocation.il_Center);
                interpolationGroup.setInterpolationType(bl != false ? IPropEnum.InterpolationType.it_Jump : IPropEnum.InterpolationType.it_Step);
            } else if (smoothMethodType2 == SmoothMethodType.STEP_RIGHT) {
                interpolationGroup.setInterpolationLocation(IPropEnum.InterpolationLocation.il_Right);
                interpolationGroup.setInterpolationType(bl != false ? IPropEnum.InterpolationType.it_Jump : IPropEnum.InterpolationType.it_Step);
            } else if (smoothMethodType2 == SmoothMethodType.SPLINE) {
                interpolationGroup.setInterpolationType(IPropEnum.InterpolationType.it_Spline);
            } else {
                interpolationGroup.setInterpolationType(IPropEnum.InterpolationType.it_Straight);
            }
        }
    }

    private void acquireAxisProps(ChartProps chartProps) {
        DimensionSpecification[] dimensionSpecificationArray = (DimensionSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(DimensionSpecification.class);
        for (int i = 0; i < dimensionSpecificationArray.length; ++i) {
            AxisSpecification axisSpecification = (AxisSpecification)this.getSpecByClass((Specification)dimensionSpecificationArray[i], AxisSpecification.class, 0);
            Props.AxisProps axisProps = this.acquireAxisProp(i, 0);
            if (axisSpecification != null && axisProps != null) {
                axisProps.setStrElId(axisSpecification.getId());
                chartProps.addProp(axisProps);
            }
            if (i != 1 || this.mCoordinates != Coords.coords_DualY) continue;
            axisSpecification = (AxisSpecification)this.getSpecByClass((Specification)dimensionSpecificationArray[i], AxisSpecification.class, 1);
            axisProps = this.acquireAxisProp(i, 1);
            if (axisSpecification == null || axisProps == null) continue;
            axisProps.setStrElId(axisSpecification.getId());
            chartProps.addProp(axisProps);
        }
    }

    private Props.AxisProps acquireAxisProp(int n, int n2) {
        ISpssVariable iSpssVariable;
        ZoneType zoneType;
        Props.AxisProps axisProps;
        IPropEnum.AxisRole axisRole = null;
        String string = null;
        boolean bl = this.isPopulationPyramid();
        if (this.mCoordinates == Coords.coords_Polar) {
            axisProps = new Props.AngleAxisProps(ZoneType.zt_angle);
            axisRole = IPropEnum.AxisRole.ar_theta;
            string = "AxisTheta1";
            axisProps.setAxisRole(axisRole);
            axisProps.setIdentifier(string);
            this.acquireAxisElementAssociation(axisProps, n2, string);
            this.getAngleAxisProps((Props.AngleAxisProps)axisProps, string);
        } else {
            boolean bl2;
            zoneType = null;
            if (n == 0) {
                zoneType = bl ? ZoneType.zt_dist_var : ZoneType.zt_x;
                axisRole = IPropEnum.AxisRole.ar_x;
                string = "AxisX1";
            } else if (n == 1) {
                if (n2 == 0) {
                    zoneType = ZoneType.zt_y;
                    axisRole = IPropEnum.AxisRole.ar_y;
                    string = "AxisY1";
                } else if (n2 == 1) {
                    zoneType = ZoneType.zt_y2;
                    axisRole = IPropEnum.AxisRole.ar_y2;
                    string = "AxisY1";
                }
            } else if (n == 2) {
                zoneType = ZoneType.zt_z;
                axisRole = IPropEnum.AxisRole.ar_z;
                string = "AxisZ1";
            }
            if (zoneType == null) {
                return null;
            }
            iSpssVariable = this.getSpssVarForZone(zoneType);
            boolean bl3 = iSpssVariable != null ? iSpssVariable.getDisplayMeasurementLevel() != MeasurementLevel.scale : (bl2 = this.defaultIsCategorical(zoneType));
            if (!bl2) {
                axisProps = new Props.ScaleAxisProps(zoneType);
                axisProps.setAxisRole(axisRole);
                axisProps.setIdentifier(string);
                this.acquireAxisElementAssociation(axisProps, n2, string);
                this.getScaleAxisProps((Props.ScaleAxisProps)axisProps, string);
            } else {
                axisProps = new Props.CatAxisProps(zoneType);
                axisProps.setAxisRole(axisRole);
                axisProps.setIdentifier(string);
                this.acquireAxisElementAssociation(axisProps, n2, string);
                this.getCategoricalAxisProps((Props.CatAxisProps)axisProps, iSpssVariable, string);
            }
        }
        iSpssVariable = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", axisProps.getStrElAssoc());
        if (iSpssVariable != null) {
            String string2;
            zoneType = this.getElementExtension((ElementSpecification)iSpssVariable);
            String string3 = zoneType.get(string2 = string + "_flags");
            if (string3 != null && string3.length() > 0) {
                int n3 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ";", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (n3 == 0) {
                        axisProps.setFlags(Integer.valueOf(string4));
                    }
                    ++n3;
                }
            }
            if ((string3 = zoneType.get(string2 = string + "_label")) != null && string3.length() > 0) {
                axisProps.setStrLabel(string3);
            }
        }
        return axisProps;
    }

    private void acquireAxisElementAssociation(Props.AxisProps axisProps, int n, String string) {
        ElementSpecification elementSpecification;
        String string2;
        ExtensionSpecification extensionSpecification;
        String string3;
        ElementSpecification[] elementSpecificationArray = (ElementSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ElementSpecification.class);
        Vector<ElementSpecification> vector = new Vector<ElementSpecification>();
        for (ElementSpecification object2 : elementSpecificationArray) {
            if (this.isErrorBarElement(object2)) continue;
            vector.add(object2);
        }
        boolean bl = false;
        if (this.mCoordinates == Coords.coords_DualY && vector.size() > n && (string3 = (extensionSpecification = this.getGraphExtension()).get(string2 = (string = string.substring(0, string.length() - 1) + Integer.toString(n + 1)) + "_assoc")) != null && string3.length() > 0 && (elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", string3)) != null) {
            axisProps.setStrElAssoc(elementSpecification.getId());
            bl = true;
        }
        if (!bl && vector.size() > n) {
            axisProps.setStrElAssoc(((ElementSpecification)vector.get(n)).getId());
        }
    }

    private void getCategoricalAxisProps(Props.CatAxisProps catAxisProps, ISpssVariable iSpssVariable, String string) {
        StringTokenizer stringTokenizer;
        String string2;
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", catAxisProps.getStrElAssoc());
        if (elementSpecification == null) {
            return;
        }
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string3 = extensionSpecification.get(string2 = string + "_cat");
        if (string3 != null && string3.length() > 0 && (stringTokenizer = new StringTokenizer(string3, ";", false)).hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            IPropEnum.CatSortType catSortType = IPropEnum.CatSortType.fromInt(Integer.valueOf(string4));
            catAxisProps.setSortType(catSortType);
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                IPropEnum.CatSortOrder catSortOrder = IPropEnum.CatSortOrder.fromInt(Integer.valueOf(string4));
                catAxisProps.setSortOrder(catSortOrder);
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                    catAxisProps.setCollapsePct(Integer.valueOf(string4));
                }
            }
        }
        if ((string3 = extensionSpecification.get(string2 = string + "_relabels")) != null && string3.length() > 0) {
            this.readRelabels(catAxisProps, string3);
        } else {
            this.loadRelabels(catAxisProps, iSpssVariable);
        }
        string2 = string + "_include";
        string3 = extensionSpecification.get(string2);
        boolean bl = string3 == null || string3.equals("1");
        catAxisProps.setIncludeUnlabeled(bl);
    }

    private void readRelabels(Props.CatAxisProps catAxisProps, String string) {
        Vector<RelabelBag> vector = catAxisProps.getCategories();
        vector.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "^^", false);
        while (stringTokenizer.hasMoreTokens()) {
            RelabelBag relabelBag = new RelabelBag();
            String string2 = stringTokenizer.nextToken();
            if (!relabelBag.read(string2)) continue;
            vector.add(relabelBag);
        }
    }

    private void loadRelabels(Props.CatAxisProps catAxisProps, ISpssVariable iSpssVariable) {
        Vector<RelabelBag> vector = catAxisProps.getCategories();
        vector.clear();
        if (iSpssVariable == null) {
            return;
        }
        int n = 0;
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        for (Map.Entry entry : iValueLabelMap.getValueLabelEntries()) {
            DecimalFormatSymbols decimalFormatSymbols;
            char c;
            OBS oBS = (OBS)entry.getKey();
            if (iSpssVariable.isMissing(oBS)) continue;
            ++n;
            String string = oBS.isString() ? oBS.getString() : CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat());
            int n2 = string.indexOf(c = (decimalFormatSymbols = new DecimalFormatSymbols(ResUtil.getLocale())).getDecimalSeparator());
            if (n2 == 0) {
                string = "0" + string;
            }
            RelabelBag relabelBag = new RelabelBag(Integer.toString(n), (String)entry.getValue(), string);
            vector.add(relabelBag);
        }
    }

    private void getScaleAxisProps(Props.ScaleAxisProps scaleAxisProps, String string) {
        StringTokenizer stringTokenizer;
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", scaleAxisProps.getStrElAssoc());
        if (elementSpecification == null) {
            return;
        }
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string2 = string + "_scale";
        boolean bl = false;
        String string3 = extensionSpecification.get(string2);
        if (string3 != null && string3.length() > 0 && (stringTokenizer = new StringTokenizer(string3, ";", false)).hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            scaleAxisProps.setScaleType(IPropEnum.ScaleType.fromInt(Integer.valueOf(string4)));
            if (stringTokenizer.hasMoreTokens()) {
                scaleAxisProps.setStrMinimum(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    scaleAxisProps.setStrMaximum(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        scaleAxisProps.setStrMajorIncrement(stringTokenizer.nextToken());
                        if (stringTokenizer.hasMoreTokens()) {
                            scaleAxisProps.setStrOrigin(stringTokenizer.nextToken());
                            if (stringTokenizer.hasMoreTokens()) {
                                scaleAxisProps.setStrBase(stringTokenizer.nextToken());
                                if (stringTokenizer.hasMoreTokens()) {
                                    scaleAxisProps.setStrExponent(stringTokenizer.nextToken());
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!bl) {
            int n = scaleAxisProps.getFlags();
            scaleAxisProps.setFlags(n |= 0xF);
        }
    }

    private void getAngleAxisProps(Props.AngleAxisProps angleAxisProps, String string) {
        StringTokenizer stringTokenizer;
        String string2;
        ElementSpecification elementSpecification = (ElementSpecification)this.getSpecByClassAndAttr(null, ElementSpecification.class, "id", angleAxisProps.getStrElAssoc());
        if (elementSpecification == null) {
            return;
        }
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        String string3 = extensionSpecification.get(string2 = string + "_polar");
        if (string3 != null && string3.length() > 0 && (stringTokenizer = new StringTokenizer(string3, ";", false)).hasMoreTokens()) {
            angleAxisProps.setClockOrder(IPropEnum.PolarClockOrder.fromInt(Integer.valueOf(stringTokenizer.nextToken())));
            if (stringTokenizer.hasMoreTokens()) {
                angleAxisProps.setClockPos(Integer.valueOf(stringTokenizer.nextToken()));
            }
        }
    }

    private void acquireLegendProps(ChartProps chartProps) {
        int n;
        StyleAestheticSpecification[] styleAestheticSpecificationArray;
        if (this.mCoordinates == Coords.coords_Polar && this.dataElementCount() == 0) {
            return;
        }
        int n2 = 0;
        StyleAestheticSpecification[] styleAestheticSpecificationArray2 = styleAestheticSpecificationArray = (StyleAestheticSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(StyleAestheticSpecification.class);
        int n3 = styleAestheticSpecificationArray2.length;
        for (n = 0; n < n3; ++n) {
            StyleAestheticSpecification styleAestheticSpecification = styleAestheticSpecificationArray2[n];
            this.getLegendProp((AestheticSpecification)styleAestheticSpecification, chartProps, n2++);
        }
        n2 = 0;
        StyleAestheticSpecification[] styleAestheticSpecificationArray3 = styleAestheticSpecificationArray2 = (ColorAestheticSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(ColorAestheticSpecification.class);
        n = styleAestheticSpecificationArray3.length;
        for (int i = 0; i < n; ++i) {
            StyleAestheticSpecification styleAestheticSpecification = styleAestheticSpecificationArray3[i];
            this.getLegendProp((AestheticSpecification)styleAestheticSpecification, chartProps, n2++);
        }
        n2 = 0;
        for (StyleAestheticSpecification styleAestheticSpecification : styleAestheticSpecificationArray3 = (PatternAestheticSpecification[])this.mVisualization.getSpecification().findDescendantsOfType(PatternAestheticSpecification.class)) {
            this.getLegendProp((AestheticSpecification)styleAestheticSpecification, chartProps, n2++);
        }
    }

    private void getLegendProp(AestheticSpecification aestheticSpecification, ChartProps chartProps, int n) {
        ElementSpecification elementSpecification = (ElementSpecification)aestheticSpecification.getParent();
        ZoneType zoneType = this.getLegendZoneType(n);
        Props.LegendProps legendProps = new Props.LegendProps(zoneType);
        legendProps.setStrElId(aestheticSpecification.getId());
        legendProps.setStrElAssoc(elementSpecification.getId());
        String string = "Legend" + (n + 1);
        if (zoneType != null) {
            ISpssVariable iSpssVariable = this.getSpssVarForZone(zoneType);
            legendProps.setIdentifier(string);
            this.getCategoricalAxisProps(legendProps, iSpssVariable, string);
            ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
            String string2 = string + "_flags";
            String string3 = extensionSpecification.get(string2);
            if (string3 != null && string3.length() > 0) {
                int n2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ";", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (n2 == 0) {
                        legendProps.setFlags(Integer.valueOf(string4));
                    }
                    ++n2;
                }
            }
            if ((string3 = extensionSpecification.get(string2 = string + "_label")) != null && string3.length() > 0) {
                legendProps.setStrLabel(string3);
            }
            chartProps.addProp(legendProps);
        }
    }

    private ZoneType getLegendZoneType(int n) {
        ZoneType zoneType = null;
        if (this.isPopulationPyramid()) {
            zoneType = ZoneType.zt_split_var;
        } else if (this.mCoordinates == Coords.coords_Polar) {
            zoneType = ZoneType.zt_slice_by;
        } else {
            DropZone dropZone = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_cluster_x);
            DropZone dropZone2 = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_cluster_z);
            DropZone dropZone3 = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_group);
            if (n == 0) {
                if (dropZone != null) {
                    zoneType = ZoneType.zt_cluster_x;
                } else if (dropZone2 != null) {
                    zoneType = ZoneType.zt_cluster_z;
                } else if (dropZone3 != null) {
                    zoneType = ZoneType.zt_group;
                }
            } else {
                int n2 = 0;
                if (dropZone != null) {
                    ++n2;
                }
                if (dropZone2 != null) {
                    if (n2 == n) {
                        zoneType = ZoneType.zt_cluster_z;
                    } else {
                        ++n2;
                    }
                }
                if (dropZone3 != null && n2 == n) {
                    zoneType = ZoneType.zt_group;
                }
            }
        }
        return zoneType;
    }

    private void acquirePanelProps(ChartProps chartProps) {
        String string;
        String string2;
        Object object;
        DropZone dropZone;
        String string3;
        Props.PanelProps panelProps;
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        DropZone dropZone2 = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_panel_horz);
        if (dropZone2 != null && !dropZone2.isEmpty()) {
            panelProps = new Props.PanelProps(ZoneType.zt_panel_horz);
            panelProps.setStrElAssoc(elementSpecification.getId());
            string3 = "PanelH1";
            panelProps.setIdentifier(string3);
            dropZone = dropZone2.getVariables().get(0);
            this.getCategoricalAxisProps(panelProps, (ISpssVariable)dropZone, string3);
            object = string3 + "_flags";
            string2 = extensionSpecification.get((String)object);
            if (string2 != null && string2.length() > 0) {
                int n = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";", false);
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (n == 0) {
                        panelProps.setFlags(Integer.valueOf(string));
                    }
                    ++n;
                }
            }
            if ((string2 = extensionSpecification.get((String)(object = string3 + "_label"))) != null && string2.length() > 0) {
                panelProps.setStrLabel(string2);
            }
            chartProps.addProp(panelProps);
        }
        if ((dropZone = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_panel_vert)) != null && !dropZone.isEmpty()) {
            panelProps = new Props.PanelProps(ZoneType.zt_panel_vert);
            panelProps.setStrElAssoc(elementSpecification.getId());
            string3 = "PanelV1";
            panelProps.setIdentifier(string3);
            object = dropZone.getVariables().get(0);
            this.getCategoricalAxisProps(panelProps, (ISpssVariable)object, string3);
            string2 = string3 + "_flags";
            string = extensionSpecification.get(string2);
            if (string != null && string.length() > 0) {
                int n = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (n == 0) {
                        panelProps.setFlags(Integer.valueOf(string4));
                    }
                    ++n;
                }
            }
            if ((string = extensionSpecification.get(string2 = string3 + "_label")) != null && string.length() > 0) {
                panelProps.setStrLabel(string);
            }
            chartProps.addProp(panelProps);
        }
    }

    private void acquireFilterPanelProps(ChartProps chartProps) {
        ElementSpecification elementSpecification = (ElementSpecification)this.getFirstSpecByClass(null, ElementSpecification.class);
        ExtensionSpecification extensionSpecification = this.getElementExtension(elementSpecification);
        DropZone dropZone = this.mCanvas.getZoneMgr().getZone(ZoneType.zt_filter);
        if (dropZone != null && !dropZone.isEmpty()) {
            Vector<ISpssVariable> vector = dropZone.getVariables();
            int n = 1;
            for (ISpssVariable iSpssVariable : vector) {
                Props.PanelProps panelProps = new Props.PanelProps(ZoneType.zt_filter);
                panelProps.setStrElAssoc(elementSpecification.getId());
                String string = "Filter" + n;
                panelProps.setIdentifier(string);
                this.getCategoricalAxisProps(panelProps, iSpssVariable, string);
                String string2 = string + "_flags";
                String string3 = extensionSpecification.get(string2);
                if (string3 != null && string3.length() > 0) {
                    int n2 = 0;
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ";", false);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (n2 == 0) {
                            panelProps.setFlags(Integer.valueOf(string4));
                        }
                        ++n2;
                    }
                }
                if ((string3 = extensionSpecification.get(string2 = string + "_label")) != null && string3.length() > 0) {
                    panelProps.setStrLabel(string3);
                }
                panelProps.setPanelIndex(n);
                chartProps.addProp(panelProps);
                ++n;
            }
        }
    }

    private void acquireTitleProps(ChartProps chartProps) {
        int n;
        Props.TitleProps titleProps;
        String string;
        ExtensionSpecification extensionSpecification = this.getTitlesExtension();
        String string2 = extensionSpecification.get(string = "Title1");
        if (string2 != null) {
            titleProps = new Props.TitleProps();
            titleProps.setTitleType(IPropEnum.TitleFlag.tf_Title1);
            titleProps.setStrTitle(string2);
            string2 = extensionSpecification.get(string + "_assoc");
            if (string2 != null && string2.length() > 0) {
                titleProps.setStrElAssoc(string2);
            }
            if ((string2 = extensionSpecification.get(string + "_flags")) != null && string2.length() > 0) {
                titleProps.setFlags(Integer.valueOf(string2));
                if (titleProps.getFlags() == 0) {
                    int n2 = this.getPrototype() != null ? 32770 : -32771;
                    titleProps.setFlags(n2);
                    extensionSpecification.put(string + "_flags", String.valueOf(n2));
                }
            }
            if ((string2 = extensionSpecification.get(string + "_index")) != null && string2.length() > 0) {
                titleProps.setUseIndex(Integer.valueOf(string2));
            }
            chartProps.addProp(titleProps);
        }
        if ((string2 = extensionSpecification.get(string = "Title2")) != null) {
            titleProps = new Props.TitleProps();
            titleProps.setTitleType(IPropEnum.TitleFlag.tf_Title2);
            titleProps.setStrTitle(string2);
            string2 = extensionSpecification.get(string + "_assoc");
            if (string2 != null && string2.length() > 0) {
                titleProps.setStrElAssoc(string2);
            }
            if ((string2 = extensionSpecification.get(string + "_flags")) != null && string2.length() > 0) {
                titleProps.setFlags(Integer.valueOf(string2));
            }
            chartProps.addProp(titleProps);
        }
        if ((string2 = extensionSpecification.get(string = "Subtitle")) != null) {
            titleProps = new Props.TitleProps();
            titleProps.setTitleType(IPropEnum.TitleFlag.tf_Subtitle);
            titleProps.setStrTitle(string2);
            string2 = extensionSpecification.get(string + "_assoc");
            if (string2 != null && string2.length() > 0) {
                titleProps.setStrElAssoc(string2);
            }
            if ((string2 = extensionSpecification.get(string + "_flags")) != null && string2.length() > 0) {
                titleProps.setFlags(Integer.valueOf(string2));
            }
            chartProps.addProp(titleProps);
        }
        string = "Footnote1";
        string2 = extensionSpecification.get(string);
        Props.TitleProps titleProps2 = null;
        if (string2 != null) {
            titleProps = new Props.TitleProps();
            titleProps.setTitleType(IPropEnum.TitleFlag.tf_Footnote1);
            titleProps.setStrTitle(string2);
            string2 = extensionSpecification.get(string + "_assoc");
            if (string2 != null && string2.length() > 0) {
                titleProps.setStrElAssoc(string2);
            }
            if ((string2 = extensionSpecification.get(string + "_flags")) != null && string2.length() > 0) {
                titleProps.setFlags(Integer.valueOf(string2));
                if (titleProps.getFlags() == 0) {
                    n = this.shouldAllowAuto(titleProps, null) ? 32770 : -32771;
                    titleProps.setFlags(n);
                    extensionSpecification.put(string + "_flags", String.valueOf(n));
                } else if (titleProps.getStrTitle().length() > 0) {
                    n = -32771;
                    titleProps.setFlags(n);
                    extensionSpecification.put(string + "_flags", String.valueOf(n));
                }
            }
            if ((string2 = extensionSpecification.get(string + "_index")) != null && string2.length() > 0) {
                titleProps.setUseIndex(Integer.valueOf(string2));
            }
            titleProps2 = titleProps;
            chartProps.addProp(titleProps);
        }
        if ((string2 = extensionSpecification.get(string = "Footnote2")) != null) {
            titleProps = new Props.TitleProps();
            titleProps.setTitleType(IPropEnum.TitleFlag.tf_Footnote2);
            titleProps.setStrTitle(string2);
            string2 = extensionSpecification.get(string + "_assoc");
            if (string2 != null && string2.length() > 0) {
                titleProps.setStrElAssoc(string2);
            }
            if ((string2 = extensionSpecification.get(string + "_flags")) != null && string2.length() > 0) {
                titleProps.setFlags(Integer.valueOf(string2));
                if (titleProps.getFlags() == 0) {
                    n = this.getPrototype() != null && this.shouldAllowAuto(titleProps, titleProps2) ? 32770 : -32771;
                    titleProps.setFlags(n);
                    extensionSpecification.put(string + "_flags", String.valueOf(n));
                }
            }
            if ((string2 = extensionSpecification.get(string + "_index")) != null && string2.length() > 0) {
                titleProps.setUseIndex(Integer.valueOf(string2));
            }
            chartProps.addProp(titleProps);
        }
    }

    private boolean shouldAllowAuto(Props.TitleProps titleProps, Props.TitleProps titleProps2) {
        boolean bl = false;
        IPropEnum.TitleFlag titleFlag = titleProps.getTitleType();
        boolean bl2 = this.mCanvas.hasFilter();
        if (bl2) {
            if (titleFlag == IPropEnum.TitleFlag.tf_Footnote1) {
                bl = true;
            } else if (titleProps2 != null && titleFlag == IPropEnum.TitleFlag.tf_Footnote2 && (titleProps2.getFlags() & 0x8002) == 0) {
                bl = true;
            }
        }
        return bl;
    }

    private String concatLabelsForBidiDisplay(String string, String string2) {
        String string3 = null;
        string3 = ComponentState.getBTD() == 1 ? '\u200f' + string2 + '\u200f' + " " + '\u200f' + string : (ComponentState.getBTD() == 2 ? (new Bidi(Character.toString(string2.charAt(0)), 1).isRightToLeft() ? '\u200e' + string + " " + string2 : string + " " + string2) : string + " " + string2);
        return string3;
    }

    private String prepareVarLableForBidiDisplay(String string) {
        String string2 = null;
        string2 = ComponentState.getBTD() == 1 ? (new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? string : '\u200f' + string) : (new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200e' + string : string);
        return string2;
    }

    private String applyChartTemplates(String string) throws OutOfMemoryError {
        String string2;
        try {
            File file;
            String string3;
            Object object;
            String string4;
            String string5;
            File file2;
            String string6;
            ApplyTemplate applyTemplate = new ApplyTemplate();
            String string7 = FileLocationsUtil.getChartTemplateDirectoryPath() + File.separator + "chart_style.sgt";
            File file3 = new File(string7);
            if (!file3.exists()) {
                TraceSettings.trace1((String)("CANNOT OPEN Template File: " + string7), (int)15);
            }
            if ((string6 = this.getFilteredTemplate(this.getTemplateFromFile(string7))) == null || string6.length() == 0) {
                TraceSettings.trace1((String)("CANNOT READ Template File: " + string7), (int)15);
            }
            if ((string2 = this.applyTemplate(applyTemplate, string, string6)) == null || string2.length() == 0) {
                TraceSettings.trace1((String)("CANNOT APPLY Template File: " + string7), (int)15);
            }
            if ((file2 = new File(string5 = (string4 = PrefsMgr.getPrefsMgr().getTempPath()) + "otmpl.tmp")).exists()) {
                string6 = this.getFilteredTemplate(this.getTemplateFromFile(string5));
                string2 = this.applyTemplate(applyTemplate, string2, string6);
            }
            boolean bl = true;
            String string8 = CanvasImager.getPrefsValue("charts", "use_custom_template", PrefDefaults.CHART_USE_CUSTOM_TEMPLATE);
            if (string8.equals(IOptionConstants.CHART_USE_CUSTOM_TEMPLATE_VALUES[0]) && ((File)(object = new File(string3 = CanvasImager.getPrefsValue("charts", "custom_template_path", "None")))).exists()) {
                string6 = this.getFilteredTemplate(this.getTemplateFromFile(string3));
                string2 = this.applyTemplate(applyTemplate, string2, string6);
                bl = false;
            }
            if (bl && (file = new File((String)(object = string4 + "dtmpl.tmp"))).exists()) {
                string6 = this.getFilteredTemplate(this.getTemplateFromFile((String)object));
                string2 = this.applyTemplate(applyTemplate, string2, string6);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string2 = string;
        }
        catch (Throwable throwable) {
            string2 = string;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        return string2;
    }

    private String applyTemplate(ApplyTemplate applyTemplate, String string, String string2) {
        String string3 = string.replaceAll("font-weight=\"normal\"", "");
        return applyTemplate.apply(string3, string2);
    }

    private String getStringFromDocument(Document document) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            return null;
        }
    }

    private String getFilteredTemplate(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            NodeList nodeList = document.getElementsByTagName("addFrame");
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                Element element = (Element)nodeList.item(i);
                String string2 = element.getAttribute("type");
                if ("title".equals(string2) || "footnote".equals(string2) || "labelFrame".equals(string2) || "container".equals(string2)) {
                    element.getParentNode().removeChild(element);
                    continue;
                }
                NodeList nodeList2 = element.getElementsByTagName("location");
                if (nodeList2.getLength() <= 0) continue;
                element.removeChild(nodeList2.item(0));
            }
            return this.getStringFromDocument(document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String getTemplateFromFile(String string) {
        String string2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "";
            while (string3 != null) {
                stringBuffer.append(string3);
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
            string2 = stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static String getPrefsValue(String string, String string2, String string3) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node(string);
        return preferences3.get(string2, string3);
    }
}

