/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartVarTransferData;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

public class CanvasDragAdapter
extends ComponentDragAdapter {
    private ChartCanvas mCanvas;

    public CanvasDragAdapter(DragPane dragPane, ChartCanvas chartCanvas, String string) {
        super(dragPane, string);
        this.mCanvas = chartCanvas;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mDndArmedEvent = null;
        if (mouseEvent.isConsumed() || mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2) {
            return;
        }
        DropZone dropZone = this.mCanvas.getZoneMgr().hitTest(mouseEvent.getPoint());
        if (dropZone != null && !dropZone.isEmpty()) {
            this.mDndArmedEvent = mouseEvent;
        }
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mTransferData == null) {
            this.mDndArmedEvent = null;
            return;
        }
        super.mouseReleased(mouseEvent);
    }

    protected void startDrag(MouseEvent mouseEvent) {
        DropZone dropZone = this.mCanvas.getZoneMgr().hitTest(mouseEvent.getPoint());
        if (dropZone == null || dropZone.isEmpty()) {
            return;
        }
        this.getTransferData();
        Component component = mouseEvent.getComponent();
        BufferedImage bufferedImage = this.getDragImage(component);
        this.removeSelected();
        Rectangle rectangle = dropZone.getBounds().getBounds();
        Point point = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, component);
        SwingUtilities.convertPointFromScreen(point, (Component)this.mDragPane);
        Point point2 = (Point)mouseEvent.getPoint().clone();
        point2.x -= rectangle.x;
        point2.y -= rectangle.y;
        this.mDragPane.setDragImage(bufferedImage, true);
        this.mDragPane.setDragPoint(point);
        this.mDragPane.setImageHotSpot(point2);
        this.mDragPane.setVisible(true);
        this.mDragPane.repaint();
    }

    public Object getTransferData() {
        if (this.mTransferData == null) {
            this.acquireTransferData();
        }
        return this.mTransferData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage getDragImage(Component component) {
        BufferedImage bufferedImage = null;
        Graphics graphics = null;
        Object object = this.getTransferData();
        if (object instanceof ChartVarTransferData) {
            try {
                ChartVarTransferData chartVarTransferData = (ChartVarTransferData)object;
                DropZone dropZone = chartVarTransferData.getZone();
                Rectangle rectangle = dropZone.getBounds().getBounds();
                Dimension dimension = rectangle.getSize();
                bufferedImage = new BufferedImage(dimension.width + 1, dimension.height + 1, 3);
                graphics = bufferedImage.createGraphics();
                ((Graphics2D)graphics).translate(-rectangle.x, -rectangle.y);
                ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(2, 0.5f));
                dropZone.render((Graphics2D)graphics, false, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
            }
        }
        return bufferedImage;
    }

    protected void acquireTransferData() {
        ChartVarTransferData chartVarTransferData = null;
        DropZone dropZone = this.mCanvas.getZoneMgr().getFocusZone();
        if (dropZone != null) {
            chartVarTransferData = new ChartVarTransferData(dropZone);
        }
        this.mTransferData = chartVarTransferData;
    }

    private void removeSelected() {
        Object object = this.getTransferData();
        if (object instanceof ChartVarTransferData) {
            DropZone dropZone = ((ChartVarTransferData)object).getZone();
            this.mCanvas.removeVariables(dropZone);
        }
    }
}

