/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder;

import com.spss.java_client.ui.controls.icon_view.IconViewer;
import com.spss.java_client.ui.controls.icon_view.IconViewerActionListener;
import com.spss.java_client.ui.controls.icon_view.IconViewerItem;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ElementDragAdapter;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ICanvasChangeListener;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class BasicFrontPanel
extends JPanel
implements ICanvasChangeListener,
IconViewerActionListener {
    private ChartBuilderDlg mMainParent;
    private ChartCanvas mCanvas;
    public AxisList mAxisList;
    private JLabel mAxisLabel;
    public IconViewer mElementList;
    private JLabel mElementsLabel;
    private JButton mTransposeButton;

    public BasicFrontPanel(ChartBuilderDlg chartBuilderDlg, ChartCanvas chartCanvas) {
        super(new GridBagLayout(), true);
        this.mMainParent = chartBuilderDlg;
        this.mCanvas = chartCanvas;
        this.init();
        this.setupCoordsList();
        this.setupElementsList();
        this.enableTransposeButton(false);
        this.mCanvas.addChangeListener(this);
        this.mAxisList.addActionListener(this);
        this.mElementList.addActionListener(this);
    }

    public void enableTransposeButton(boolean bl) {
        this.mTransposeButton.setEnabled(bl);
    }

    public void enableAllElements(boolean bl) {
        this.mElementsLabel.setEnabled(bl);
        this.mElementList.enableAllItems(bl);
    }

    @Override
    public void canvasChange(CanvasChangeEvent canvasChangeEvent) {
        int n = this.mCanvas.getImager().dataElementCount();
        Coords coords = this.mCanvas.getImager().getCoordinates();
        this.mAxisList.repaint(200L);
        if (n == 0) {
            IconViewerItem iconViewerItem;
            if (coords == Coords.coords_1D) {
                this.mElementList.enableAllItems(false);
                iconViewerItem = (IconViewerItem)this.mElementList.getComponent(Elements.point.value() - 1);
                iconViewerItem.setEnabled(true);
                iconViewerItem = (IconViewerItem)this.mElementList.getComponent(Elements.schema.value() - 1);
                iconViewerItem.setEnabled(true);
                this.enableTransposeButton(true);
            } else if (coords == Coords.coords_2D) {
                this.mElementList.enableAllItems(true);
                iconViewerItem = (IconViewerItem)this.mElementList.getComponent(Elements.polar_interval.value() - 1);
                iconViewerItem.setEnabled(false);
                this.enableTransposeButton(!this.mCanvas.getImager().isPopulationPyramid());
            } else if (coords == Coords.coords_3D) {
                this.mElementList.enableAllItems(false);
                iconViewerItem = (IconViewerItem)this.mElementList.getComponent(Elements.point.value() - 1);
                iconViewerItem.setEnabled(true);
                iconViewerItem = (IconViewerItem)this.mElementList.getComponent(Elements.interval.value() - 1);
                iconViewerItem.setEnabled(true);
                this.enableTransposeButton(false);
            } else if (coords == Coords.coords_Polar) {
                this.mElementList.enableAllItems(false);
                iconViewerItem = (IconViewerItem)this.mElementList.getComponent(Elements.polar_interval.value() - 1);
                iconViewerItem.setEnabled(true);
                this.enableTransposeButton(false);
            } else if (coords == Coords.coords_DualY) {
                this.mElementList.enableAllItems(false);
                iconViewerItem = (IconViewerItem)this.mElementList.getComponent(Elements.point.value() - 1);
                iconViewerItem.setEnabled(true);
                iconViewerItem = (IconViewerItem)this.mElementList.getComponent(Elements.interval.value() - 1);
                iconViewerItem.setEnabled(true);
                iconViewerItem = (IconViewerItem)this.mElementList.getComponent(Elements.line.value() - 1);
                iconViewerItem.setEnabled(true);
                iconViewerItem = (IconViewerItem)this.mElementList.getComponent(Elements.area.value() - 1);
                iconViewerItem.setEnabled(true);
                this.enableTransposeButton(false);
            } else {
                this.mElementList.enableAllItems(true);
                this.enableTransposeButton(false);
            }
            for (Component component : this.mElementList.getComponents()) {
                IconViewerItem iconViewerItem2;
                if (!(component instanceof IconViewerItem) || !(iconViewerItem2 = (IconViewerItem)component).isEnabled()) continue;
                this.mElementList.setSelectedItem(this.mElementList.getItem(iconViewerItem2.getId()));
                break;
            }
            return;
        }
        int n2 = coords == Coords.coords_1D || coords == Coords.coords_2D && !this.mCanvas.getImager().isPopulationPyramid() ? 1 : 0;
        this.enableTransposeButton(n2 != 0);
        n2 = 0;
        if (coords == Coords.coords_DualY && n == 1) {
            n2 = 4;
        }
        for (int i = 0; i < this.mElementList.getComponentCount(); ++i) {
            IconViewerItem iconViewerItem = (IconViewerItem)this.mElementList.getComponent(i);
            iconViewerItem.setEnabled(i < n2);
        }
    }

    @Override
    public void itemChosen(IconViewerItem iconViewerItem) {
        this.mCanvas.getParentDlg().setCursor(Cursor.getPredefinedCursor(3));
        try {
            Object object = iconViewerItem.getUserData();
            if (object instanceof Coords) {
                this.mCanvas.changeCoordinates((Coords)((Object)object));
            } else if (object instanceof Elements) {
                this.mCanvas.addElement((Elements)((Object)object));
            }
            this.mAxisList.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mCanvas.getParentDlg().setCursor(null);
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 25;
        Insets insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        Insets insets2 = new Insets(2, insets.left, 0, 3);
        this.mAxisLabel = new JLabel(this.mMainParent.getResString("IDS_CHOOSE_AXES"));
        this.mAxisLabel.setDisplayedMnemonic(this.mMainParent.getDlgAccessKey("IDS_CHOOSE_AXES_KEY"));
        DialogUtil.addUsingGBL(this, this.mAxisLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2 = new Insets(2, 3, 0, 2);
        gridBagConstraints.weightx = 1.0;
        this.mElementsLabel = new JLabel(this.mMainParent.getResString("IDS_CHOOSE_ELEMS"));
        this.mElementsLabel.setDisplayedMnemonic(this.mMainParent.getDlgAccessKey("IDS_CHOOSE_ELEMS_KEY"));
        DialogUtil.addUsingGBL(this, this.mElementsLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        this.mTransposeButton = new JButton(new TransposeAction());
        Insets insets3 = this.mTransposeButton.getMargin();
        insets3.top = 0;
        insets3.bottom = 0;
        insets3.left = 6;
        insets3.right = 6;
        this.mTransposeButton.setMargin(insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        n = 26;
        insets2 = new Insets(3, 0, 1, insets.right);
        DialogUtil.addUsingGBL(this, this.mTransposeButton, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        LineBorder lineBorder = new LineBorder(new Color(0, 128, 128));
        this.mAxisList = new AxisList();
        this.mAxisList.setBorder(lineBorder);
        this.mAxisList.setName(this.mMainParent.getResString("IDS_CHOOSE_AXES"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        insets2 = new Insets(1, insets.left, insets.bottom, 3);
        DialogUtil.addUsingGBL(this, this.mAxisList, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mElementList = new IconViewer(4);
        this.mElementList.setBorder(lineBorder);
        this.mElementList.setName(this.mMainParent.getResString("IDS_CHOOSE_ELEMS"));
        insets2 = new Insets(1, 3, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.mElementList, gridBagConstraints, 1, 1, 2, 1, n, insets2);
        this.mAxisList.setMinimumSize(new Dimension(128, 176));
        this.mAxisList.setPreferredSize(new Dimension(128, 176));
        this.mElementList.setMinimumSize(new Dimension(232, 176));
        this.mElementList.setPreferredSize(new Dimension(232, 176));
        this.mAxisLabel.setLabelFor(this.mAxisList);
        this.mElementsLabel.setLabelFor(this.mElementList);
    }

    private void setupCoordsList() {
        String[] stringArray = new String[]{"IDS_1D_COORDS_IMAGE", "IDS_2D_COORDS_IMAGE", "IDS_3D_COORDS_IMAGE", "IDS_POLAR_COORDS_IMAGE", "IDS_DUALY_COORDS_IMAGE"};
        DragPane dragPane = (DragPane)this.mMainParent.getGlassPane();
        ElementDragAdapter elementDragAdapter = new ElementDragAdapter(ElementDragAdapter.DragSrcType.coordinates, dragPane, "Coordinates");
        this.mAxisList.setDragAdapter(elementDragAdapter);
        for (int i = 0; i < 5; ++i) {
            ImageIcon imageIcon = new ImageIcon(this.mMainParent.getResImageURL(stringArray[i]));
            IconViewerItem iconViewerItem = new IconViewerItem(i + 1, imageIcon, null, this.mMainParent.getResString(stringArray[i] + "_TIP"), (Object)Coords.fromInt(i + 1));
            iconViewerItem.getAccessibleContext().setAccessibleDescription(iconViewerItem.getToolTipText());
            this.mAxisList.addItem(iconViewerItem);
        }
    }

    private void setupElementsList() {
        String[] stringArray = new String[]{"IDS_POINT_IMAGE", "IDS_BAR_IMAGE", "IDS_LINE_ELEMENT_IMAGE", "IDS_AREA_IMAGE", "IDS_SCHEMA_IMAGE", "IDS_HILO_IMAGE", "IDS_DIFFAREA_IMAGE", "IDS_PYRAMID_IMAGE", "IDS_SPLOM_IMAGE", "IDS_POLAR_IMAGE"};
        DragPane dragPane = (DragPane)this.mMainParent.getGlassPane();
        ElementDragAdapter elementDragAdapter = new ElementDragAdapter(ElementDragAdapter.DragSrcType.elements, dragPane, "Elements");
        this.mElementList.setDragAdapter(elementDragAdapter);
        for (int i = 0; i < 10; ++i) {
            ImageIcon imageIcon = new ImageIcon(this.mMainParent.getResImageURL(stringArray[i]));
            ImageIcon imageIcon2 = new ImageIcon(this.mMainParent.getResImageURL(stringArray[i] + "_D"));
            IconViewerItem iconViewerItem = new IconViewerItem(i + 1, imageIcon, imageIcon2, this.mMainParent.getResString(stringArray[i] + "_TIP"), (Object)Elements.fromInt(i + 1));
            this.mElementsLabel.setLabelFor(iconViewerItem);
            iconViewerItem.getAccessibleContext().setAccessibleName(this.mElementsLabel.getText());
            iconViewerItem.getAccessibleContext().setAccessibleDescription(iconViewerItem.getToolTipText());
            this.mElementList.addItem(iconViewerItem);
        }
    }

    class AxisList
    extends IconViewer {
        private final ImageIcon ARROW_ICON = new ImageIcon(ResUtil.getImageResource("NavFocusArrowSmall.png"));

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            IconViewerItem iconViewerItem = this.findCurrentCoordItem();
            if (iconViewerItem != null) {
                Rectangle rectangle = iconViewerItem.getBounds();
                this.ARROW_ICON.paintIcon(this, graphics, rectangle.x - this.ARROW_ICON.getIconWidth(), rectangle.y + (rectangle.height - this.ARROW_ICON.getIconHeight()) / 2);
            }
        }

        private IconViewerItem findCurrentCoordItem() {
            Coords coords = BasicFrontPanel.this.mCanvas.getImager().getCoordinates();
            if (coords == Coords.coords_none) {
                return null;
            }
            for (Component component : this.getComponents()) {
                if (!(component instanceof IconViewerItem) || coords != ((IconViewerItem)component).getUserData()) continue;
                return (IconViewerItem)component;
            }
            return null;
        }
    }

    class TransposeAction
    extends AbstractAction {
        TransposeAction() {
            this.putValue("Name", BasicFrontPanel.this.mMainParent.getResString("IDS_TRANSPOSE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicFrontPanel.this.mCanvas.transpose();
        }
    }
}

