/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.graphs.GBTemplateOptionPanel;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.pes.jaxws.PESBrowser;
import com.spss.pes.ui.dialog.RepositoryPathInfoListener;
import com.spss.pes.ui.dialog.jaxws.RepositoryPathInfo;
import com.spss.repository.client.application.jaxws.Repository;
import com.spss.repository.client.application.jaxws.RepositoryFolder;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.graphboard.Graphboard;
import com.spss.vis.graphboard.GraphboardInternationalization;
import com.spss.vis.graphboard.styleSheet.BadStyleSheetFileException;
import com.spss.vis.graphboard.styleSheet.StyleSheet;
import com.spss.vis.graphboard.styleSheet.StyleSheetFactory;
import com.spss.vis.graphboard.styleSheet.StyleSheetLoaderException;
import com.spss.vis.graphboard.styleSheet.StylesheetLoader;
import com.spss.vis.graphboard.styleSheet.component.StyleSheetListPanel;
import com.spss.vis.graphboard.styleSheet.component.StyleSheetPreviewPanel;
import com.spss.vis.graphboard.template.TemplateHelper;
import com.spss.vis.graphboard.util.GraphboardPreferences;
import com.spss.vis.graphboard.vismodel.NviznModelException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SelectStyleDialog
extends JDialog
implements RepositoryPathInfoListener {
    private List<Graphboard> graphboards = new ArrayList<Graphboard>();
    private StyleSheetListPanel listPanel;
    private StyleSheetPreviewPanel previewPanel;
    private StyleSheet original;
    private StylesheetLoader loader;
    private JLabel pathLabel;
    private GBTemplateOptionPanel mOptionTab;
    private RepositoryPathInfo rpi;
    private static ResourceBundle sResourceBundle = ResUtil.getBundle(GraphsResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());

    public SelectStyleDialog(Dialog dialog, Graphboard graphboard, GBTemplateOptionPanel gBTemplateOptionPanel, StyleSheetFactory styleSheetFactory) {
        super(dialog, UIToolResUtil.getString((ResourceBundle)sResourceBundle, (String)"IDS_GBT_SELECT_STYLESHEET"), true);
        this.init(graphboard, gBTemplateOptionPanel, styleSheetFactory);
    }

    public SelectStyleDialog(Frame frame, Graphboard graphboard, GBTemplateOptionPanel gBTemplateOptionPanel, StyleSheetFactory styleSheetFactory) {
        super(frame, UIToolResUtil.getString((ResourceBundle)sResourceBundle, (String)"IDS_GBT_SELECT_STYLESHEET"), true);
        this.init(graphboard, gBTemplateOptionPanel, styleSheetFactory);
    }

    public SelectStyleDialog(Graphboard[] graphboardArray, GBTemplateOptionPanel gBTemplateOptionPanel) {
        super(JOptionPane.getFrameForComponent(graphboardArray[0].getVisualizationComponent().getJComponent()), UIToolResUtil.getString((ResourceBundle)sResourceBundle, (String)"IDS_GBT_SELECT_STYLESHEET"), true);
        this.graphboards.addAll(Arrays.asList(graphboardArray));
        try {
            this.loader = new StylesheetLoader(graphboardArray[0].getStylesheetDirectory());
        }
        catch (StyleSheetLoaderException styleSheetLoaderException) {
            this.graphboards.get(0).getErrorHandler().handleThrowable((Throwable)styleSheetLoaderException);
        }
        this.mOptionTab = gBTemplateOptionPanel;
        this.build();
    }

    public void build() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.graphboards.size() > 0) {
            this.rpi = this.graphboards.get(0).getRepositoryPathInfo();
            this.rpi.addListener((RepositoryPathInfoListener)this);
        }
        String string = "";
        try {
            string = this.graphboards.get(0).getModel().getWorkingStyleSheet();
        }
        catch (NviznModelException nviznModelException) {
            this.graphboards.get(0).getErrorHandler().handleThrowable((Throwable)nviznModelException);
        }
        this.original = new StyleSheet("", this.graphboards.get(0).getModel().getBaseStyleSheet() + "\n" + string);
        this.setDefaultCloseOperation(1);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setLocation(dimension.width / 4, dimension.height / 4);
        this.setResizable(true);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                int n = mouseEvent.getClickCount();
                if (n == 1) {
                    SelectStyleDialog.this.preview();
                } else {
                    SelectStyleDialog.this.applyButtonAction();
                }
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SelectStyleDialog.this.applyButtonAction();
                } else if (keyEvent.getKeyCode() == 27) {
                    SelectStyleDialog.this.dispose();
                } else if (keyEvent.getKeyCode() == 112) {
                    SelectStyleDialog.this.doHelp();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                    SelectStyleDialog.this.preview();
                }
            }
        };
        ArrayList<EventListener> arrayList = new ArrayList<EventListener>();
        arrayList.add(mouseAdapter);
        arrayList.add(keyAdapter);
        try {
            this.listPanel = new StyleSheetListPanel(this.loader.getAllStyleSheets(), arrayList);
            object4 = this.mOptionTab.getSelectSheetName();
            object3 = this.loader.getAllStyleSheets();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (StyleSheet)object2.next();
                if (object4 == null || !((String)object4).equals(object.getInternationalizedName())) continue;
                this.listPanel.setSelectedStyle((StyleSheet)object);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectStyleDialog.this.preview();
                    }
                });
                break;
            }
        }
        catch (StyleSheetLoaderException styleSheetLoaderException) {
            this.graphboards.get(0).getErrorHandler().handleThrowable((Throwable)styleSheetLoaderException);
        }
        try {
            this.previewPanel = StyleSheetPreviewPanel.makePanel((Collection)this.loader.getDemoSpecs(), (boolean)false);
        }
        catch (VisualizationException visualizationException) {
            this.graphboards.get(0).getErrorHandler().handleThrowable((Throwable)visualizationException);
        }
        object4 = new JPanel();
        ((Container)object4).setLayout(new FlowLayout(0));
        object3 = new JButton(UIToolResUtil.getString((ResourceBundle)sResourceBundle, (String)"IDS_GB_TEMPLATE_IMPORT"));
        ((AbstractButton)object3).addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((Graphboard)((SelectStyleDialog)SelectStyleDialog.this).graphboards.get((int)0)).getSwingActions().TEMPLATE_AND_STYLESHEET_MANAGER.actionPerformed(actionEvent);
                StyleSheetFactory styleSheetFactory = SelectStyleDialog.this.loader.getFactory();
                try {
                    StyleSheet styleSheet = SelectStyleDialog.this.listPanel.getSelected();
                    SelectStyleDialog.this.listPanel.rebuild(SelectStyleDialog.this.loader.getAllStyleSheets());
                    if (styleSheet != null) {
                        SelectStyleDialog.this.listPanel.setSelectedStyle(styleSheet);
                    }
                }
                catch (StyleSheetLoaderException styleSheetLoaderException) {
                    ((Graphboard)SelectStyleDialog.this.graphboards.get(0)).getErrorHandler().handleThrowable((Throwable)styleSheetLoaderException);
                }
            }
        });
        ((AbstractButton)object3).setMnemonic((Integer)UIToolResUtil.getObject((String)"IDS_GB_TEMPLATE_IMPORT_KEY", (ResourceBundle)sResourceBundle));
        ((Container)object4).add((Component)object3);
        if (VersionInfo.allowRemoteServer()) {
            object2 = new JButton(GraphboardInternationalization.getLocalizedMessage((String)"location", (Object[])new Object[]{"..."}));
            ((AbstractButton)object2).addActionListener(this.graphboards.get((int)0).getSwingActions().RETRIEVE_STYLESHEET);
            ((AbstractButton)object2).setMnemonic(TemplateHelper.getMnemonic((String)"locationMnemonic", (char)'l', (Locale)Locale.getDefault()));
            ((Container)object4).add((Component)object2);
            this.pathLabel = new JLabel();
            ((Container)object4).add(this.pathLabel);
            if (this.rpi.isLocal()) {
                this.pathLabel.setText(GraphboardInternationalization.getLocalizedMessage((String)"localRepository"));
            } else {
                this.pathLabel.setText(this.rpi.getSelectFolderPath());
            }
        }
        object2 = new JPanel();
        ((Container)object2).setLayout(new FlowLayout(1, 5, 5));
        object = new JButton(UIToolResUtil.getString((ResourceBundle)sResourceBundle, (String)"IDS_GBT_OK"));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectStyleDialog.this.OKButtonAction();
            }
        });
        JButton jButton = new JButton(UIToolResUtil.getString((ResourceBundle)sResourceBundle, (String)"IDS_GBT_CANCEL"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectStyleDialog.this.cancelButtonAction();
            }
        });
        JButton jButton2 = new JButton(GraphboardInternationalization.getLocalizedMessage((String)"help"));
        jButton2.setToolTipText(GraphboardInternationalization.getLocalizedMessage((String)"help"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectStyleDialog.this.doHelp();
            }
        });
        ((Container)object2).add((Component)object);
        ((Container)object2).add(jButton);
        ((Container)object2).add(jButton2);
        this.listPanel.setPreferredSize(new Dimension(800, 210));
        this.previewPanel.setPreferredSize(new Dimension(800, 270));
        ((JComponent)object4).setPreferredSize(new Dimension(400, 35));
        ((JComponent)object2).setPreferredSize(new Dimension(400, 35));
        Container container = this.getContentPane();
        container.removeAll();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, n2);
        DialogUtil.addUsingGBL(container, (JComponent)this.listPanel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(n2, n2, 0, n2));
        DialogUtil.addUsingGBL(container, (JComponent)this.previewPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(container, (JComponent)object4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(container, (JComponent)object2, gridBagConstraints, 0, 3, 1, 1, n, new Insets(n2, n2, n2, n2));
        this.pack();
        this.setVisible(true);
    }

    public void repositoryInfoChanged() {
        this.setPathLabel();
        if (!this.isVisible()) {
            return;
        }
        try {
            StyleSheetFactory styleSheetFactory;
            if (this.rpi.isLocal()) {
                styleSheetFactory = StyleSheetFactory.getLocalDirectoryInstance((File)this.graphboards.get(0).getStylesheetDirectory());
            } else {
                RepositoryFolder repositoryFolder = this.rpi.getRemoteFolder();
                String string = repositoryFolder.getFullPathName();
                styleSheetFactory = StyleSheetFactory.getRepositoryInstance((Repository)PESBrowser.getRepository(), (String)string, (String)this.rpi.getSpecifiedLabel(), (String)this.rpi.getSelectedFileName());
                this.rpi.setSelectedFileName(null);
            }
            this.loader.setFactory(styleSheetFactory);
            this.listPanel.rebuild(this.loader.getAllStyleSheets());
            if (null != styleSheetFactory && null != styleSheetFactory.getSelectedStyleSheet()) {
                this.listPanel.setSelectedStyle(styleSheetFactory.getSelectedStyleSheet());
            }
        }
        catch (Exception exception) {
            this.graphboards.get(0).getErrorHandler().handleThrowable((Throwable)exception);
        }
    }

    private void preview() {
        try {
            this.previewPanel.applyStyle(this.listPanel.getSelected());
        }
        catch (BadStyleSheetFileException badStyleSheetFileException) {
            this.graphboards.get(0).getErrorHandler().handleThrowable((Throwable)badStyleSheetFileException);
        }
    }

    private void OKButtonAction() {
        if (this.listPanel.getSelected() == null) {
            return;
        }
        this.mOptionTab.setSelectSheetName(this.listPanel.getSelected().getInternationalizedName());
        this.applyButtonAction();
        GraphboardPreferences.setString((String)"stylesheet-default-file", (String)this.listPanel.getSelected().getName());
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonAction() {
        try {
            for (Graphboard graphboard : this.graphboards) {
                graphboard.getModel().setBaseStyleSheet(this.original.getStyle(), false);
            }
        }
        catch (NviznModelException nviznModelException) {
            this.graphboards.get(0).getErrorHandler().handleThrowable((Throwable)nviznModelException);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void applyButtonAction() {
        try {
            StyleSheet styleSheet = this.listPanel.getSelected();
            if (styleSheet != null) {
                for (Graphboard graphboard : this.graphboards) {
                    graphboard.getModel().setBaseStyleSheet(styleSheet.getStyle(), true);
                }
            }
        }
        catch (NviznModelException nviznModelException) {
            this.graphboards.get(0).getErrorHandler().handleThrowable((Throwable)nviznModelException);
        }
    }

    private void setPathLabel() {
        if (this.rpi.isLocal() || this.rpi.getSelectFolderPath() == null || this.rpi.getSelectFolderPath().length() == 0) {
            this.pathLabel.setText(GraphboardInternationalization.getLocalizedMessage((String)"localRepository"));
        } else {
            this.pathLabel.setText(this.rpi.getSelectFolderPath());
        }
    }

    private void init(Graphboard graphboard, GBTemplateOptionPanel gBTemplateOptionPanel, StyleSheetFactory styleSheetFactory) {
        this.graphboards.add(graphboard);
        try {
            this.loader = new StylesheetLoader(graphboard.getStylesheetDirectory());
            if (styleSheetFactory != null) {
                this.loader.setFactory(styleSheetFactory);
            }
        }
        catch (StyleSheetLoaderException styleSheetLoaderException) {
            this.graphboards.get(0).getErrorHandler().handleThrowable((Throwable)styleSheetLoaderException);
        }
        this.mOptionTab = gBTemplateOptionPanel;
        this.build();
    }

    private void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_graphboard_select_stylesheets");
    }
}

